#ifndef __RR_MIME_H__
#define __RR_MIME_H__

typedef struct _RRMimePart RRMimePart;

#include <glib.h>

G_BEGIN_DECLS

struct _RRMimePart {
	GHashTable *headers;
	gboolean    multipart;
	GSList     *subparts;
	gchar      *body;
	gsize       body_len;
	gboolean    should_free;
	gchar      *multipart_type;
	gchar      *boundary;
	gsize       boundary_len;
};

typedef void (*RRMimeFunc) (RRMimePart *part, gpointer user_data);

RRMimePart  *rr_mime_parse              (const gchar *data,
					 gsize len);

RRMimePart  *rr_mime_part_new           (const gchar *type);
RRMimePart  *rr_mime_multipart_new      (const gchar *type);

void         rr_mime_part_free          (RRMimePart *part);

gchar       *rr_mime_part_to_string     (RRMimePart *part);
gsize        rr_mime_part_render        (RRMimePart *part, gchar *str);
gsize        rr_mime_part_to_string_len (RRMimePart *part);

void         rr_mime_part_set_header    (RRMimePart *part, 
					 const gchar *name,
					 const gchar *value);

gboolean     rr_mime_part_has_header    (RRMimePart *part, 
					 const gchar *name);
const gchar *rr_mime_part_get_header    (RRMimePart *part, 
					 const gchar *name);
const gchar *rr_mime_part_get_id        (RRMimePart *part);
void         rr_mime_part_set_unique_id (RRMimePart *part);

void         rr_mime_part_set_body      (RRMimePart *part,
					 gchar *data,
					 gsize len,
					 gboolean should_free);
const gchar *rr_mime_part_get_body      (RRMimePart *part);
gsize        rr_mime_part_get_body_len  (RRMimePart *part);

void         rr_mime_part_append        (RRMimePart *part, 
					 RRMimePart *subpart);

#define rr_mime_part_get_first(part) rr_mime_part_get_next (part, NULL)
RRMimePart  *rr_mime_part_get_next      (RRMimePart *part,
					 RRMimePart *iter);
RRMimePart  *rr_mime_part_find          (RRMimePart *part, 
					 const gchar *content_id);
RRMimePart  *rr_mime_part_find_type     (RRMimePart *part, 
					 const gchar *content_type,
					 RRMimePart *iter);

void         rr_mime_part_foreach       (RRMimePart *part,
					 RRMimeFunc func,
					 gpointer user_data);

G_END_DECLS

#endif /* __RR_MIME_H__ */
