/*-
 * $Id: rr-listener.h,v 1.5 2003/01/03 16:01:05 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_LISTENER_H__
#define __RR_LISTENER_H__

typedef struct _RRListener RRListener;
typedef struct _RRListenerClass RRListenerClass;

#include <librr/rr-connection.h>

G_BEGIN_DECLS

#define RR_TYPE_LISTENER (rr_listener_get_type ())
#define RR_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_LISTENER, RRListener))
#define RR_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_LISTENER, RRListenerClass))
#define RR_IS_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_LISTENER))
#define RR_IS_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_LISTENER))
#define RR_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_LISTENER, RRListenerClass))

struct _RRListener {
	GObject parent_object;

	RRProfileRegistry *profreg;

	GStaticRWLock connections_lock;
	GSList *connections;

	GStaticRWLock dead_connections_lock;
	GSList *dead_connections;

	gint max_connections;
	gint num_connections;
};

struct _RRListenerClass {
	GObjectClass parent_class;
	gboolean (*shutdown) (RRListener *listener, GError **error);
};

GType rr_listener_get_type (void);

gboolean rr_listener_shutdown             (RRListener *listen, GError **error);
gboolean rr_listener_disconnect_all       (RRListener *listener, GError **error);

void     rr_listener_set_profile_registry (RRListener *listener, 
				           RRProfileRegistry *profreg);

void     rr_listener_add_connection       (RRListener *listener,
					   RRConnection *connection);
void     rr_listener_remove_connection    (RRListener *listener,
					   RRConnection *connection);

gint     rr_listener_get_num_connections  (RRListener *listener);
void     rr_listener_set_max_connections  (RRListener *listener, int max);
gint     rr_listener_get_max_connections  (RRListener *listener);

G_END_DECLS

#endif /* __RR_LISTENER_H__ */
