/*-
 * $Id: rr-filter.c,v 1.3 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>

static void
rr_filter_init (GObject *object)
{
}

static void
rr_filter_class_init (GObjectClass *klass)
{
}

GType 
rr_filter_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRFilterClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_filter_class_init,
			NULL,
			NULL,
			sizeof (RRFilter),
			16,
			(GInstanceInitFunc) rr_filter_init
		};
		rr_type = g_type_register_static (G_TYPE_OBJECT, "RRFilter", 
						  &type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return rr_type;
}

GIOStatus
rr_filter_read (RRFilter *filter, guint8 *data, gsize len, gsize *read,
		GSList *stack, GError **error)
{
	return RR_FILTER_GET_CLASS (filter)->read (filter, data, len, read,
						   stack, error);
}

GIOStatus
rr_filter_write (RRFilter *filter, guint8 *data, gsize len, gsize *written,
		 GSList *stack, GError **error)
{
	return RR_FILTER_GET_CLASS (filter)->write (filter, data, len, written,
						     stack, error);
}
