/*-
 * $Id: rr-callbacklist.c,v 1.2 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>


typedef struct {
	GFunc func;
	gpointer data;
	gpointer user_data;
} CBItem;

void
rr_callback_list_push (RRCallbackList **list, GFunc func, 
		       gpointer data, gpointer user_data)
{
	CBItem *item;

	g_return_if_fail (list != NULL);
	if (func == NULL)
		return;

	item = g_new (CBItem, 1);
	item->func = func;
	item->data = data;
	item->user_data = user_data;

	*list = g_slist_append (*list, item);
}

void
rr_callback_list_execute (RRCallbackList *list)
{
	while (list) {
		CBItem *item = list->data;
		g_assert (item != NULL);
		g_assert (item->func != NULL);
		item->func (item->data, item->user_data);
		list = list->next;
	}
}

void
rr_callback_list_free (RRCallbackList *list)
{
	g_slist_foreach (list, (GFunc)g_free, NULL);
	g_slist_free (list);
}
