/*-
 * $Id: rr-beeperror.h,v 1.5 2002/05/11 17:54:00 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_BEEP_ERROR_H__
#define __RR_BEEP_ERROR_H__

/* Supported languages */

typedef enum
{
	RR_BEEP_LANG_EN = 0,
	RR_BEEP_LANG_SV	
} RRBeepLang;

#define RR_BEEP_LANG_DEFAULT RR_BEEP_LANG_EN;
#define RR_GERROR_DEFAULT_MESSAGE  "%s", ""

typedef struct _RRBeepLangIso RRBeepLangIso;

struct _RRBeepLangIso {
	RRBeepLang lang;
	gchar *isocode;
};

typedef struct _RRBeepError RRBeepError;

struct _RRBeepError {
	gint code;
	gchar *msg;
};

typedef struct _RRBeepErrorTable RRBeepErrorTable;

struct _RRBeepErrorTable {
	RRBeepLang lang;
	RRBeepError *errors;
};

typedef enum
{
	RR_BEEP_CODE_UNKNOWN            = 0,   /* Default code */
	RR_BEEP_CODE_SUCCESS            = 200, /* Success. Everything ok. */
	RR_BEEP_CODE_SERVICE_NOT_AVAIL  = 421, /* Service not available. */
	RR_BEEP_CODE_NO_ACTION          = 450, /* Requested action not taken 
						   (e.g., lock already in use)
					       */
	RR_BEEP_CODE_ABORTED            = 451, /* Requested action aborted
						   (e.g., local error in
						   processing) */
	RR_BEEP_CODE_AUTH_FAILURE       = 454, /* Temporary authentication
						   failure */
	RR_BEEP_CODE_SYNTAX_ERROR       = 500, /* General syntax error
						   (e.g., poorly-formed XML) */
	RR_BEEP_CODE_PARAM_ERROR        = 501, /* Syntax error in parameters
						   (e.g., non-valid XML) */
	RR_BEEP_CODE_PARAM_NOIMP        = 504, /* Parameter not implemented */
	RR_BEEP_CODE_AUTH_REQUIRED      = 530, /* Authentication required */
	RR_BEEP_CODE_AUTH_INSUFFICIENT  = 534, /* Authentication mechanism
						   insufficient (e.g., too weak,
						   sequence exhausted, etc.) */
	RR_BEEP_CODE_ACTION_REQ_AUTH    = 537,  /* Action not authorized for
						    user */
	RR_BEEP_CODE_AUTH_REQ_ENCRYPTION = 538, /* Authentication mechanism
						    requires encryption */
	RR_BEEP_CODE_ACTION_NOT_TAKEN   = 550,  /* Requested action not taken
						    (e.g., no requested profiles
						  are acceptable) */
	RR_BEEP_CODE_INVALID_PARAM      = 553, /* Parameter invalid */
	RR_BEEP_CODE_TRANSACTION_FAILED = 554 /* Transaction failed
						   (e.g., policy violation) */

} RRBeepReplyCode;


#define RR_BEEP_ERROR (rr_beep_error_quark ())

GQuark rr_beep_error_quark (void);

RRBeepLang rr_beep_error_get_lang (const gchar *isolang);
RRBeepLang rr_beep_error_get_supported_lang (const gchar *langtokens);
gchar *rr_beep_error_get_lang_iso (RRBeepLang lang);

gchar *rr_beep_error_get_message (RRBeepReplyCode code, RRBeepLang lang);
gchar *rr_beep_error_get_message_iso (RRBeepReplyCode code, 
				      const gchar *isolang);

#endif /* __RR_BEEP_ERROR_H__ */
