/*-
 * $Id: rr-message-static.h,v 1.6 2002/11/08 12:35:28 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_STATIC_H__
#define __RR_MESSAGE_STATIC_H__

typedef struct _RRMessageStatic RRMessageStatic;
typedef struct _RRMessageStaticClass RRMessageStaticClass;

#include <librr/rr-frame.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_TYPE_MESSAGE_STATIC (rr_message_static_get_type ())
#define RR_MESSAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE_STATIC, RRMessageStatic))
#define RR_MESSAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE_STATIC, RRMessageStaticClass))
#define RR_IS_MESSAGE_STATIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE_STATIC))
#define RR_IS_MESSAGE_STATIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE_STATIC))
#define RR_MESSAGE_STATIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE_STATIC, RRMessageStaticClass))

struct _RRMessageStatic {
	RRMessage parent_object;

	gchar *payload;
	gsize payload_len;
	gsize offset;
	gboolean should_free;
};

struct _RRMessageStaticClass {
	RRMessageClass parent_class;
};

GType rr_message_static_get_type (void);

RRMessage *rr_message_static_new (RRFrameType type,
				  gchar *payload, 
				  gsize payload_len, 
				  gboolean should_free);

G_END_DECLS

#endif /* __RR_MESSAGE_STATIC_H__ */
