/*-
 * $Id: rr-message-static.c,v 1.11 2002/11/08 12:35:28 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>

static GObjectClass *parent_class = NULL;
static void finalize (GObject *object);

static RRFrame *get_frame (RRMessage *stat, gsize max_size);

static void
finalize (GObject *object)
{
	RRMessageStatic *stat = (RRMessageStatic *)object;

	if (stat->payload && stat->should_free)
		g_free (stat->payload);
	
	parent_class->finalize (object);
}

static void
rr_message_static_init (GObject *object)
{
}

static void
rr_message_static_class_init (GObjectClass *klass)
{
	RRMessageClass *msg_class = (RRMessageClass *)klass;

	msg_class->get_frame = get_frame;

	klass->finalize = finalize;

	parent_class = g_type_class_peek_parent (klass);
}

GType 
rr_message_static_get_type (void)
{
	static GType rr_type = 0;

	if (!rr_type) {
		static GTypeInfo type_info = {
			sizeof (RRMessageStaticClass),
			NULL,
			NULL,
			(GClassInitFunc) rr_message_static_class_init,
			NULL,
			NULL,
			sizeof (RRMessageStatic),
			16,
			(GInstanceInitFunc) rr_message_static_init
		};
		rr_type = g_type_register_static (RR_TYPE_MESSAGE, "RRMessageStatic", 
						  &type_info, 0);
	}
	return rr_type;
}


RRMessage *
rr_message_static_new (RRFrameType type, 
		       gchar *payload, 
		       gsize payload_len, 
		       gboolean should_free)
{
	RRMessageStatic *stat;
	RRMessage *msg;

	stat = g_object_new (RR_TYPE_MESSAGE_STATIC, NULL);
	msg = RR_MESSAGE (stat);

	msg->type         = type;

	stat->payload     = payload;
	stat->payload_len = payload_len;
	stat->should_free = should_free;

	return (RRMessage *)stat;
}

static RRFrame *
get_frame (RRMessage *message, gsize max_size)
{
	RRMessageStatic *stat = RR_MESSAGE_STATIC(message);
	RRFrame *frame;
	gboolean more;
	gint len;

	g_assert (RR_IS_MESSAGE (stat));

	len = MIN (max_size, stat->payload_len - stat->offset);
	more = (max_size < stat->payload_len - stat->offset);

	frame = rr_frame_new (message->type, message->channel->id, more, 
			      message->msgno,
			      len, message->ansno, 
			      (guint8 *)stat->payload + stat->offset, 
			      FALSE);

	rr_frame_reference_message (frame, message);

	stat->offset += len;

	return frame;
}

