/*-
 * $Id: rr-message-startrpy.h,v 1.3 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_STARTRPY_H__
#define __RR_MESSAGE_STARTRPY_H__

typedef struct _RRMessageStartRpy RRMessageStartRpy;
typedef struct _RRMessageStartRpyClass RRMessageStartRpyClass;

#include <librr/rr-frame.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_TYPE_MESSAGE_STARTRPY (rr_message_startrpy_get_type ())
#define RR_MESSAGE_STARTRPY(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE_STARTRPY, RRMessageStartRpy))
#define RR_MESSAGE_STARTRPY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE_STARTRPY, RRMessageStartRpyClass))
#define RR_IS_MESSAGE_STARTRPY(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE_STARTRPY))
#define RR_IS_MESSAGE_STARTRPY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE_STARTRPY))
#define RR_MESSAGE_STARTRPY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE_STARTRPY, RRMessageStartRpyClass))

struct _RRMessageStartRpy {
	RRMessage parent_object;
	RRChannel *channel_to_activate;

	gchar *piggyback;
	gchar *uri;
};

struct _RRMessageStartRpyClass {
	RRMessageClass parent_class;
};

GType rr_message_startrpy_get_type (void);

RRMessageStartRpy *rr_message_startrpy_new (const gchar *uri,
					    const gchar *piggyback);

G_END_DECLS

#endif /* __RR_MESSAGE_STARTRPY_H__ */
