/*-
 * $Id: rr-message-start.h,v 1.9 2002/11/08 12:35:28 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_MESSAGE_START_H__
#define __RR_MESSAGE_START_H__

typedef struct _RRMessageStart RRMessageStart;
typedef struct _RRMessageStartClass RRMessageStartClass;

#include <librr/rr-frame.h>
#include <librr/message/rr-message.h>

G_BEGIN_DECLS

#define RR_TYPE_MESSAGE_START (rr_message_start_get_type ())
#define RR_MESSAGE_START(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_MESSAGE_START, RRMessageStart))
#define RR_MESSAGE_START_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_MESSAGE_START, RRMessageStartClass))
#define RR_IS_MESSAGE_START(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_MESSAGE_START))
#define RR_IS_MESSAGE_START_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_MESSAGE_START))
#define RR_MESSAGE_START_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_MESSAGE_START, RRMessageStartClass))

struct _RRMessageStart {
	RRMessage parent_object;

	gint number;
	GSList *in_list;
	GSList *out_list;

	RRChannel *done_channel;
	GMutex *done_mutex;
	GCond *done_cond;
	gboolean done;
	GError *done_error;
	GError *client_init_error;
	
	gchar *server_name;
};

struct _RRMessageStartClass {
	RRMessageClass parent_class;
};

typedef struct {
	GType type;
	gchar *piggyback;
} RRStartItem;

GType rr_message_start_get_type (void);

RRMessageStart *rr_message_start_new (gint number, const gchar *server_name);

void rr_message_start_add_channel (RRMessageStart *start,
				   RRConnection *conn,
				   GType type,
				   gpointer config_data);

GSList *rr_message_start_get_channel_list (RRMessageStart *start);

RRChannel *rr_message_start_wait_for_reply (RRMessageStart *start,
					    GError **error);

void rr_message_start_done (RRMessageStart *start,
			    RRChannel *channel, GError *error);

const gchar *rr_message_start_get_server_name (RRMessageStart *start);

gboolean rr_message_start_empty_request_p (RRMessageStart *start);

G_END_DECLS

#endif /* __RR_MESSAGE_START_H__ */
