/*-
 * $Id: rr-greeting.h,v 1.5 2002/05/11 17:54:01 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_GREETING_H__
#define __RR_GREETING_H__

typedef struct _RRGreeting RRGreeting;
typedef struct _RRGreetingClass RRGreetingClass;

#include <librr/message/rr-message.h>
#include <librr/rr-profileregistry.h>

G_BEGIN_DECLS

#define RR_TYPE_GREETING (rr_greeting_get_type ())
#define RR_GREETING(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_GREETING, RRGreeting))
#define RR_GREETING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_GREETING, RRGreetingClass))
#define RR_IS_GREETING(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_GREETING))
#define RR_IS_GREETING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_GREETING))
#define RR_GREETING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_GREETING, RRGreetingClass))

struct _RRGreeting {
	RRMessage parent_object;
	RRProfileRegistry *profreg;
	GSList *peer_profiles;
	gchar *localize;
	gchar *features;
};

struct _RRGreetingClass {
	RRMessageClass parent_class;
};

GType rr_greeting_get_type (void);

RRGreeting *rr_greeting_new (RRProfileRegistry *profreg, 
			     const gchar *localize, const gchar *features);


G_END_DECLS

#endif /* __RR_GREETING_H__ */
