/*-
 * $Id: simple-server.c,v 1.6 2002/05/13 13:47:19 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include "simple-profile.h"

int
main (gint argc, gchar **argv)
{
	GError *error = NULL;
	RRListener *listener;
	RRProfileRegistry *profreg;

	/* Initialize roadrunner */
	if (!rr_init (&argc, &argv, &error))
		g_error ("rr_init failed: %s\n", error->message);

	/* Select a few profiles we want to support */
	profreg = rr_profile_registry_new ();
  	rr_profile_registry_add_profile (profreg, RR_TYPE_SIMPLE, NULL);  

	/* Listen... */
	if ((listener = rr_tcp_listener_new (profreg, "localhost", 10289, 
						&error)) == NULL)
		g_error ("listen failed: %s\n", error->message);

	if (!rr_wait_until_done (&error))
		g_error ("rr_wait failed: %s\n", error->message);

	if (!rr_exit (&error))
		g_error ("rr_exit failed: %s\n", error->message);

	if (!rr_listener_shutdown (listener, &error))
		g_error ("rr_listener_shutdown failed: %s\n", error->message);

	return 0;
}
