/*-
 * $Id: simple-profile.h,v 1.3 2002/08/15 16:21:41 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#ifndef __RR_SIMPLE_PROFILE_H__
#define __RR_SIMPLE_PROFILE_H__

typedef struct _RRSimple RRSimple;
typedef struct _RRSimpleClass RRSimpleClass;

#include <librr/rr-channel.h>

G_BEGIN_DECLS

#define RR_TYPE_SIMPLE (rr_simple_get_type ())
#define RR_SIMPLE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), RR_TYPE_SIMPLE, RRSimple))
#define RR_SIMPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RR_TYPE_SIMPLE, RRSimpleClass))
#define RR_IS_SIMPLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), RR_TYPE_SIMPLE))
#define RR_IS_SIMPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RR_TYPE_SIMPLE))
#define RR_SIMPLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RR_TYPE_SIMPLE, RRSimpleClass))

struct _RRSimple {
	RRChannel parent_object;
};

struct _RRSimpleClass {
	RRChannelClass parent_class;
};

GType rr_simple_get_type (void);

RRSimple *rr_simple_start    (RRConnection *connection, GError **error);
gboolean  rr_simple_do_stuff (RRSimple  *simple,  GError **error);
gboolean  rr_simple_close    (RRSimple  *simple,  GError **error);

G_END_DECLS

#endif /* __RR_SIMPLE_PROFILE_H__ */


