/*-
 * $Id: simple-client.c,v 1.8 2002/08/15 16:21:41 jonas Exp $
 *
 * See the file LICENSE for redistribution information. 
 * If you have not received a copy of the license, please contact CodeFactory
 * by email at info@codefactory.se, or on the web at http://www.codefactory.se/
 * You may also write to: CodeFactory AB, SE-903 47, Ume, Sweden.
 *
 * Copyright (c) 2002 Jonas Borgstrm <jonas@codefactory.se>
 * Copyright (c) 2002 Daniel Lundin   <daniel@codefactory.se>
 * Copyright (c) 2002 CodeFactory AB.  All rights reserved.
 */

#include <librr/rr.h>
#include "simple-profile.h"

int
main (gint argc, gchar **argv)
{
	GError *error = NULL;
	RRConnection *connection;
	RRProfileRegistry *profreg;
	RRSimple *simple;

	/* Initialize roadrunner */
	if (!rr_init (&argc, &argv, &error))
		g_error ("rr_init failed: %s\n", error->message);

	/* Tell roadrunner which profiles we want to support */
	profreg = rr_profile_registry_new ();
	rr_profile_registry_add_profile (profreg, RR_TYPE_SIMPLE, NULL);

	/* Create a connection object */
	if ((connection = rr_tcp_connection_new (profreg, "localhost", 
						 10289, &error)) == NULL)
		g_error ("connection failed: %s\n", error->message);

	if ((simple = rr_simple_start (connection, &error)) == NULL)
		g_error ("rr_simple_start failed: %s\n", error->message);

	if (!rr_simple_do_stuff (simple, &error))
		g_error ("rr_simple_do_stuff failed: %s\n", error->message);

	if (!rr_simple_close (simple, &error))
		g_error ("rr_simple_close failed: %s\n", error->message);

	/* Close the connection */
	if (!rr_connection_disconnect (connection, &error))
		g_error ("disconnect failed: %s\n", error->message);

	/* Stop the main-loop */
	if (!rr_exit (&error))
		g_error ("rr_exit failed: %s\n", error->message);

	return 0;
}
