// SPDX-FileCopyrightText: 2024 Billow <billow.fun@gmail.com>
// SPDX-License-Identifier: LGPL-3.0-only

static const char *
v850_register_name(ut32 regnum) {
	static const char *v850_reg_names[] = { "r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7",
		"r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15",
		"r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23",
		"r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31",
		"eipc", "eipsw", "fepc", "fepsw", "ecr", "psw", "sr6", "sr7",
		"sr8", "sr9", "sr10", "sr11", "sr12", "sr13", "sr14", "sr15",
		"sr16", "sr17", "sr18", "sr19", "sr20", "sr21", "sr22", "sr23",
		"sr24", "sr25", "sr26", "sr27", "sr28", "sr29", "sr30", "sr31",
		"pc", "fp" };
	if (regnum >= RZ_ARRAY_SIZE(v850_reg_names)) {
		return "";
	}
	return v850_reg_names[regnum];
}

static const char *
v850e_register_name(ut32 regnum) {
	static const char *v850e_reg_names[] = {
		"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7",
		"r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15",
		"r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23",
		"r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31",
		"eipc", "eipsw", "fepc", "fepsw", "ecr", "psw", "sr6", "sr7",
		"sr8", "sr9", "sr10", "sr11", "sr12", "sr13", "sr14", "sr15",
		"ctpc", "ctpsw", "dbpc", "dbpsw", "ctbp", "sr21", "sr22", "sr23",
		"sr24", "sr25", "sr26", "sr27", "sr28", "sr29", "sr30", "sr31",
		"pc", "fp"
	};
	if (regnum >= RZ_ARRAY_SIZE(v850e_reg_names)) {
		return "";
	}
	return v850e_reg_names[regnum];
}

static const char *
v850e2_register_name(ut32 regnum) {
	static const char *v850e2_reg_names[] = {
		/* General purpose registers.  */
		"r0", "r1", "r2", "r3", "r4", "r5", "r6", "r7",
		"r8", "r9", "r10", "r11", "r12", "r13", "r14", "r15",
		"r16", "r17", "r18", "r19", "r20", "r21", "r22", "r23",
		"r24", "r25", "r26", "r27", "r28", "r29", "r30", "r31",

		/* System registers - main banks.  */
		"eipc", "eipsw", "fepc", "fepsw", "ecr", "psw", "pid", "cfg",
		"", "", "", "sccfg", "scbp", "eiic", "feic", "dbic",
		"ctpc", "ctpsw", "dbpc", "dbpsw", "ctbp", "dir", "", "",
		"", "", "", "", "eiwr", "fewr", "dbwr", "bsel",

		/* PC.  */
		"pc", "",

		/* System registers - MPV (PROT00) bank.  */
		"vsecr", "vstid", "vsadr", "", "vmecr", "vmtid", "vmadr", "",
		"vpecr", "vptid", "vpadr", "", "", "", "", "",
		"", "", "", "", "", "", "", "",
		"mca", "mcs", "mcc", "mcr",

		/* System registers - MPU (PROT01) bank.  */
		"mpm", "mpc", "tid", "", "", "", "ipa0l", "ipa0u",
		"ipa1l", "ipa1u", "ipa2l", "ipa2u", "ipa3l", "ipa3u", "ipa4l", "ipa4u",
		"dpa0l", "dpa0u", "dpa1l", "dpa1u", "dpa2l", "dpa2u", "dpa3l", "dpa3u",
		"dpa4l", "dpa4u", "dpa5l", "dpa5u",

		/* FPU system registers.  */
		"", "", "", "", "", "", "fpsr", "fpepc",
		"fpst", "fpcc", "fpcfg", "fpec", "", "", "", "",
		"", "", "", "", "", "", "", "",
		"", "", "", "fpspc"
	};
	if (regnum >= RZ_ARRAY_SIZE(v850e2_reg_names)) {
		return NULL;
	}
	return v850e2_reg_names[regnum];
}

static const char *
v850e3v5_register_name(ut32 regnum) {
	static const char *v850e3v5_reg_names[] = {
		/* General purpose registers.  */
		"r0",
		"r1",
		"r2",
		"r3",
		"r4",
		"r5",
		"r6",
		"r7",
		"r8",
		"r9",
		"r10",
		"r11",
		"r12",
		"r13",
		"r14",
		"r15",
		"r16",
		"r17",
		"r18",
		"r19",
		"r20",
		"r21",
		"r22",
		"r23",
		"r24",
		"r25",
		"r26",
		"r27",
		"r28",
		"r29",
		"r30",
		"r31",

		/* selID 0, not including FPU registers.  The FPU registers are
		   listed later on.  */
		"eipc",
		"eipsw",
		"fepc",
		"fepsw",
		"",
		"psw",
		"" /* fpsr */,
		"" /* fpepc */,
		"" /* fpst */,
		"" /* fpcc */,
		"" /* fpcfg */,
		"" /* fpec */,
		"sesr",
		"eiic",
		"feic",
		"",
		"ctpc",
		"ctpsw",
		"",
		"",
		"ctbp",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"eiwr",
		"fewr",
		"",
		"bsel",

		/* PC.  */
		"pc",
		"",

		/* v850e2 MPV bank.  */
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",

		/* Skip v850e2 MPU bank.  It's tempting to reuse these, but we need
		   32 entries for this bank.  */
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",

		/* FPU system registers.  These are actually in selID 0, but
		   are placed here to preserve register numbering compatibility
		   with previous architectures.  */
		"",
		"",
		"",
		"",
		"",
		"",
		"fpsr",
		"fpepc",
		"fpst",
		"fpcc",
		"fpcfg",
		"fpec",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",

		/* selID 1.  */
		"mcfg0",
		"mcfg1",
		"rbase",
		"ebase",
		"intbp",
		"mctl",
		"pid",
		"fpipr",
		"",
		"",
		"tcsel",
		"sccfg",
		"scbp",
		"hvccfg",
		"hvcbp",
		"vsel",
		"vmprt0",
		"vmprt1",
		"vmprt2",
		"",
		"",
		"",
		"",
		"vmscctl",
		"vmsctbl0",
		"vmsctbl1",
		"vmsctbl2",
		"vmsctbl3",
		"",
		"",
		"",
		"",

		/* selID 2.  */
		"htcfg0",
		"",
		"",
		"",
		"",
		"htctl",
		"mea",
		"asid",
		"mei",
		"ispr",
		"pmr",
		"icsr",
		"intcfg",
		"",
		"",
		"",
		"tlbsch",
		"",
		"",
		"",
		"",
		"",
		"",
		"htscctl",
		"htsctbl0",
		"htsctbl1",
		"htsctbl2",
		"htsctbl3",
		"htsctbl4",
		"htsctbl5",
		"htsctbl6",
		"htsctbl7",

		/* selID 3.  */
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",

		/* selID 4.  */
		"tlbidx",
		"",
		"",
		"",
		"telo0",
		"telo1",
		"tehi0",
		"tehi1",
		"",
		"",
		"tlbcfg",
		"",
		"bwerrl",
		"bwerrh",
		"brerrl",
		"brerrh",
		"ictagl",
		"ictagh",
		"icdatl",
		"icdath",
		"dctagl",
		"dctagh",
		"dcdatl",
		"dcdath",
		"icctrl",
		"dcctrl",
		"iccfg",
		"dccfg",
		"icerr",
		"dcerr",
		"",
		"",

		/* selID 5.  */
		"mpm",
		"mprc",
		"",
		"",
		"mpbrgn",
		"mptrgn",
		"",
		"",
		"mca",
		"mcs",
		"mcc",
		"mcr",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"mpprt0",
		"mpprt1",
		"mpprt2",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",

		/* selID 6.  */
		"mpla0",
		"mpua0",
		"mpat0",
		"",
		"mpla1",
		"mpua1",
		"mpat1",
		"",
		"mpla2",
		"mpua2",
		"mpat2",
		"",
		"mpla3",
		"mpua3",
		"mpat3",
		"",
		"mpla4",
		"mpua4",
		"mpat4",
		"",
		"mpla5",
		"mpua5",
		"mpat5",
		"",
		"mpla6",
		"mpua6",
		"mpat6",
		"",
		"mpla7",
		"mpua7",
		"mpat7",
		"",

		/* selID 7.  */
		"mpla8",
		"mpua8",
		"mpat8",
		"",
		"mpla9",
		"mpua9",
		"mpat9",
		"",
		"mpla10",
		"mpua10",
		"mpat10",
		"",
		"mpla11",
		"mpua11",
		"mpat11",
		"",
		"mpla12",
		"mpua12",
		"mpat12",
		"",
		"mpla13",
		"mpua13",
		"mpat13",
		"",
		"mpla14",
		"mpua14",
		"mpat14",
		"",
		"mpla15",
		"mpua15",
		"mpat15",
		"",

		/* Vector Registers */
		"vr0",
		"vr1",
		"vr2",
		"vr3",
		"vr4",
		"vr5",
		"vr6",
		"vr7",
		"vr8",
		"vr9",
		"vr10",
		"vr11",
		"vr12",
		"vr13",
		"vr14",
		"vr15",
		"vr16",
		"vr17",
		"vr18",
		"vr19",
		"vr20",
		"vr21",
		"vr22",
		"vr23",
		"vr24",
		"vr25",
		"vr26",
		"vr27",
		"vr28",
		"vr29",
		"vr30",
		"vr31",
	};

	if (regnum >= RZ_ARRAY_SIZE(v850e3v5_reg_names)) {
		return "";
	}
	return v850e3v5_reg_names[regnum];
}