// SPDX-FileCopyrightText: 2021 Rot127 <unisono@quyllur.org>
// SPDX-License-Identifier: LGPL-3.0-only

// LLVM commit: 96e220e6886868d6663d966ecc396befffc355e7
// LLVM commit date: 2022-01-05 11:01:52 +0000 (ISO 8601 format)
// Date of code generation: 2022-04-22 13:29:27+02:00
//========================================
// The following code is generated.
// Do not edit. Repository of code generator:
// https://github.com/rizinorg/rz-hexagon

#include <stdio.h>
#include <stdbool.h>
#include <rz_types.h>
#include <rz_util.h>
#include <rz_util/rz_hex.h>
#include <rz_analysis.h>
#include "hexagon.h"
#include "hexagon_insn.h"
#include "hexagon_arch.h"

#if ASAN && !defined(__clang__)
#define NO_OPT_IF_ASAN __attribute__((optimize(0)))
#else
#define NO_OPT_IF_ASAN
#endif

#define HEX_OP_MASKS_MAX 4

typedef enum {
	HEX_OP_TEMPLATE_TYPE_NONE = 0,
	HEX_OP_TEMPLATE_TYPE_IMM = 1,
	HEX_OP_TEMPLATE_TYPE_IMM_CONST = 2,
	HEX_OP_TEMPLATE_TYPE_REG = 3,
	HEX_OP_TEMPLATE_TYPE_MASK = 3
} HexOpTemplateType;

typedef enum {
	// 1 << 0 and 1 << 1 reserved by HexOpTemplateType
	// for HEX_OP_TEMPLATE_TYPE_REG:
	HEX_OP_TEMPLATE_FLAG_REG_OUT = 1 << 2,
	HEX_OP_TEMPLATE_FLAG_REG_PAIR = 1 << 3,
	HEX_OP_TEMPLATE_FLAG_REG_QUADRUPLE = 1 << 4,
	HEX_OP_TEMPLATE_FLAG_REG_N_REG = 1 << 5,
	// for HEX_OP_TEMPLATE_TYPE_IMM:
	HEX_OP_TEMPLATE_FLAG_IMM_SIGNED = 1 << 2,
	HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE = 1 << 3,
	HEX_OP_TEMPLATE_FLAG_IMM_PC_RELATIVE = 1 << 4,
	HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH = 1 << 5
} HexOpTemplateFlag;

// Note:
// The structs below are using ut8 instead of direct enum types
// where possible to optimize for size. Members are also ordered
// deliberately to make them well packed.
// Keep this in mind when changing anything here!

typedef struct {
	ut8 bits; // number of bits this part has
	ut8 shift; // index of the first bit in the instruction where this part starts
} HexOpMask;

typedef struct {
	ut8 info; // HexOpTemplateType | HexOpTemplateFlag
	ut8 syntax; // offset into HexInsnTemplate.syntax where to insert this op
	HexOpMask masks[HEX_OP_MASKS_MAX];
	union {
		ut8 imm_scale;
		ut8 reg_cls; // HexRegClass
	};
} HexOpTemplate;

typedef enum {
	HEX_INSN_TEMPLATE_FLAG_CALL = 1 << 0,
	HEX_INSN_TEMPLATE_FLAG_PREDICATED = 1 << 1,
	HEX_INSN_TEMPLATE_FLAG_HAS_JMP_TGT = 1 << 2,
	HEX_INSN_TEMPLATE_FLAG_LOOP_BEGIN = 1 << 3,
	HEX_INSN_TEMPLATE_FLAG_LOOP_0 = 1 << 4,
	HEX_INSN_TEMPLATE_FLAG_LOOP_1 = 1 << 5
} HexInsnTemplateFlag;

typedef struct {
	struct {
		ut32 mask;
		ut32 op;
	} encoding;
	enum HEX_INS id;
	HexOpTemplate ops[HEX_MAX_OPERANDS];
	ut8 pred; // HexPred
	ut8 cond; // RzTypeCond
	ut8 flags; // HexInsnTemplateFlag
	const char *syntax;
	_RzAnalysisOpType type;
} HexInsnTemplate;

static const HexInsnTemplate templates_duplex_0x0[] = {
	{
		// 0000IIIISSSSDDDDEE00iiiissssdddd | RD = memw(RS+II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xf000f000, .op = 0x0 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memw(+)",
	},
	{
		// 0000IIIISSSSDDDDEE01iiiissssdddd | RD = memw(RS+II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xf000f000, .op = 0x1000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memub(+)",
	},
	{
		// 0001IIIISSSSDDDDEE01iiiissssdddd | RD = memub(RS+II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xf000f000, .op = 0x10001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memub(+)",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x1[] = {
	{
		// 0000iiiissssddddEE11111100000000 | Rd = memw(Rs+Ii) ; deallocframe
		.encoding = { .mask = 0xf000ffff, .op = 0x3f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ; deallocframe",
	},
	{
		// 0001iiiissssddddEE11111100000000 | Rd = memub(Rs+Ii) ; deallocframe
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ; deallocframe",
	},
	{
		// 0000iiiissssddddEE11111111000000 | Rd = memw(Rs+Ii) ; jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x3fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memw(+) ; jumpr R31",
	},
	{
		// 0001iiiissssddddEE11111111000000 | Rd = memub(Rs+Ii) ; jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x10003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memub(+) ; jumpr R31",
	},
	{
		// 0000iiiissssddddEE11111111000101 | Rd = memw(Rs+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x3fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111111000101 | Rd = memub(Rs+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x10003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111111000111 | Rd = memw(Rs+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf000ffff, .op = 0x3fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111111000111 | Rd = memub(Rs+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf000ffff, .op = 0x10003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111111000100 | Rd = memw(Rs+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x3fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111111000100 | Rd = memub(Rs+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf000ffff, .op = 0x10003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111111000110 | Rd = memw(Rs+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf000ffff, .op = 0x3fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111111000110 | Rd = memub(Rs+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf000ffff, .op = 0x10003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000IIIISSSSDDDDEE110iiissssdddd | RD = memw(RS+II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x3000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memb(+)",
	},
	{
		// 0001IIIISSSSDDDDEE110iiissssdddd | RD = memub(RS+II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x10003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memb(+)",
	},
	{
		// 0000IIIIssssDDDDEE111110iiiiiddd | RD = memw(Rs+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf000ff00, .op = 0x3e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memd(R29+)",
	},
	{
		// 0001IIIIssssDDDDEE111110iiiiiddd | RD = memub(Rs+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf000ff00, .op = 0x10003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memd(R29+)",
	},
	{
		// 0000IIIISSSSDDDDEE100iiissssdddd | RD = memw(RS+II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x2000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memh(+)",
	},
	{
		// 0001IIIISSSSDDDDEE100iiissssdddd | RD = memub(RS+II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x10002000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memh(+)",
	},
	{
		// 0000IIIIssssDDDDEE11110iiiiidddd | RD = memw(Rs+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf000fe00, .op = 0x3c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memw(R29+)",
	},
	{
		// 0001IIIIssssDDDDEE11110iiiiidddd | RD = memub(Rs+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf000fe00, .op = 0x10003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memw(R29+)",
	},
	{
		// 0000IIIISSSSDDDDEE101iiissssdddd | RD = memw(RS+II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x2800 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ;  = memuh(+)",
	},
	{
		// 0001IIIISSSSDDDDEE101iiissssdddd | RD = memub(RS+II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf000f800, .op = 0x10002800 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ;  = memuh(+)",
	},
	{
		// 0000iiiissssddddEE11111101000000 | Rd = memw(Rs+Ii) ; dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x3f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memw(+) ; dealloc_return",
	},
	{
		// 0001iiiissssddddEE11111101000000 | Rd = memub(Rs+Ii) ; dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memub(+) ; dealloc_return",
	},
	{
		// 0000iiiissssddddEE11111101000101 | Rd = memw(Rs+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x3f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111101000101 | Rd = memub(Rs+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111101000111 | Rd = memw(Rs+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf000ffff, .op = 0x3f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111101000111 | Rd = memub(Rs+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111101000100 | Rd = memw(Rs+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x3f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111101000100 | Rd = memub(Rs+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0000iiiissssddddEE11111101000110 | Rd = memw(Rs+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf000ffff, .op = 0x3f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0001iiiissssddddEE11111101000110 | Rd = memub(Rs+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf000ffff, .op = 0x10003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 24 } }, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memub(+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x2[] = {
	{
		// 0011111100000000EE01111100000000 | deallocframe ; deallocframe
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_DEALLOCFRAME,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "deallocframe ; deallocframe",
	},
	{
		// 00110iiissssddddEE01111100000000 | Rd = memb(Rs+Ii) ; deallocframe
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ; deallocframe",
	},
	{
		// 00111110iiiiidddEE01111100000000 | Rdd = memd(r29+Ii) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(R29+) ; deallocframe",
	},
	{
		// 00100iiissssddddEE01111100000000 | Rd = memh(Rs+Ii) ; deallocframe
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ; deallocframe",
	},
	{
		// 0011110iiiiiddddEE01111100000000 | Rd = memw(r29+Ii) ; deallocframe
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(R29+) ; deallocframe",
	},
	{
		// 00101iiissssddddEE01111100000000 | Rd = memuh(Rs+Ii) ; deallocframe
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ; deallocframe",
	},
	{
		// 0011111100000000EE01111111000000 | deallocframe ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_JUMPR31,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "deallocframe ; jumpr R31",
	},
	{
		// 00110iiissssddddEE01111111000000 | Rd = memb(Rs+Ii) ; jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x30001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memb(+) ; jumpr R31",
	},
	{
		// 00111110iiiiidddEE01111111000000 | Rdd = memd(r29+Ii) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memd(R29+) ; jumpr R31",
	},
	{
		// 00100iiissssddddEE01111111000000 | Rd = memh(Rs+Ii) ; jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x20001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memh(+) ; jumpr R31",
	},
	{
		// 0011110iiiiiddddEE01111111000000 | Rd = memw(r29+Ii) ; jumpr r31
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memw(R29+) ; jumpr R31",
	},
	{
		// 00101iiissssddddEE01111111000000 | Rd = memuh(Rs+Ii) ; jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x28001fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memuh(+) ; jumpr R31",
	},
	{
		// 0011111101000000EE01111111000000 | dealloc_return ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f401fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_JUMPR31,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "dealloc_return ; jumpr R31",
	},
	{
		// 0011111101000101EE01111111000000 | if (!p0) dealloc_return ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f451fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_JUMPR31,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111111000000 | if (!p0.new) dealloc_return:nt ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f471fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_JUMPR31,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111111000000 | if (p0) dealloc_return ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f441fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_JUMPR31,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111111000000 | if (p0.new) dealloc_return:nt ; jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f461fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_JUMPR31,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111111000101 | deallocframe ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111111000101 | Rd = memb(Rs+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x30001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111111000101 | Rdd = memd(r29+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111111000101 | Rd = memh(Rs+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x20001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111111000101 | Rd = memw(r29+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111111000101 | Rd = memuh(Rs+Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x28001fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111111000101 | dealloc_return ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f401fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111111000101 | if (!p0) dealloc_return ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f451fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111111000101 | if (!p0.new) dealloc_return:nt ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f471fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111111000101 | if (p0) dealloc_return ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f441fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111111000101 | if (p0.new) dealloc_return:nt ; if (!p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f461fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_JUMPR31_F,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111111000111 | deallocframe ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111111000111 | Rd = memb(Rs+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x30001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111111000111 | Rdd = memd(r29+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111111000111 | Rd = memh(Rs+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x20001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111111000111 | Rd = memw(r29+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111111000111 | Rd = memuh(Rs+Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x28001fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111111000111 | dealloc_return ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f401fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111111000111 | if (!p0) dealloc_return ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f451fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111111000111 | if (!p0.new) dealloc_return:nt ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f471fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111111000111 | if (p0) dealloc_return ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f441fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111111000111 | if (p0.new) dealloc_return:nt ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f461fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_JUMPR31_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111111000100 | deallocframe ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_JUMPR31_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111111000100 | Rd = memb(Rs+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x30001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111111000100 | Rdd = memd(r29+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111111000100 | Rd = memh(Rs+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x20001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111111000100 | Rd = memw(r29+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111111000100 | Rd = memuh(Rs+Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x28001fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111111000100 | dealloc_return ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f401fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_JUMPR31_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111111000100 | if (!p0) dealloc_return ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f451fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_JUMPR31_T,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111111000100 | if (!p0.new) dealloc_return:nt ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f471fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_JUMPR31_T,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111111000100 | if (p0) dealloc_return ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f441fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_JUMPR31_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111111000100 | if (p0.new) dealloc_return:nt ; if (p0) jumpr r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f461fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_JUMPR31_T,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111111000110 | deallocframe ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111111000110 | Rd = memb(Rs+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x30001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111111000110 | Rdd = memd(r29+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111111000110 | Rd = memh(Rs+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x20001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111111000110 | Rd = memw(r29+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111111000110 | Rd = memuh(Rs+Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x28001fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111111000110 | dealloc_return ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f401fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111111000110 | if (!p0) dealloc_return ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f451fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111111000110 | if (!p0.new) dealloc_return:nt ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f471fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111111000110 | if (p0) dealloc_return ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f441fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111111000110 | if (p0.new) dealloc_return:nt ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xffffffff, .op = 0x3f461fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_JUMPR31_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110IIISSSSDDDDEE010iiissssdddd | RD = memb(RS+II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x30001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ;  = memb(+)",
	},
	{
		// 00100IIISSSSDDDDEE010iiissssdddd | RD = memh(RS+II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x20001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ;  = memb(+)",
	},
	{
		// 00101IIISSSSDDDDEE010iiissssdddd | RD = memuh(RS+II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x28001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ;  = memb(+)",
	},
	{
		// 00110IIIssssDDDDEE011110iiiiiddd | RD = memb(Rs+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf800ff00, .op = 0x30001e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ;  = memd(R29+)",
	},
	{
		// 00111110IIIIIDDDEE011110iiiiiddd | RDD = memd(r29+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x3e001e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(R29+) ;  = memd(R29+)",
	},
	{
		// 00100IIIssssDDDDEE011110iiiiiddd | RD = memh(Rs+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf800ff00, .op = 0x20001e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ;  = memd(R29+)",
	},
	{
		// 0011110IIIIIDDDDEE011110iiiiiddd | RD = memw(r29+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfe00ff00, .op = 0x3c001e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(R29+) ;  = memd(R29+)",
	},
	{
		// 00101IIIssssDDDDEE011110iiiiiddd | RD = memuh(Rs+II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf800ff00, .op = 0x28001e00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ;  = memd(R29+)",
	},
	{
		// 00100IIISSSSDDDDEE000iiissssdddd | RD = memh(RS+II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x20000000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ;  = memh(+)",
	},
	{
		// 00110IIIssssDDDDEE01110iiiiidddd | RD = memb(Rs+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf800fe00, .op = 0x30001c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ;  = memw(R29+)",
	},
	{
		// 00100IIIssssDDDDEE01110iiiiidddd | RD = memh(Rs+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf800fe00, .op = 0x20001c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ;  = memw(R29+)",
	},
	{
		// 0011110IIIIIDDDDEE01110iiiiidddd | RD = memw(r29+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfe00fe00, .op = 0x3c001c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(R29+) ;  = memw(R29+)",
	},
	{
		// 00101IIIssssDDDDEE01110iiiiidddd | RD = memuh(Rs+II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf800fe00, .op = 0x28001c00 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ;  = memw(R29+)",
	},
	{
		// 00100IIISSSSDDDDEE001iiissssdddd | RD = memh(RS+II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x20000800 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ;  = memuh(+)",
	},
	{
		// 00101IIISSSSDDDDEE001iiissssdddd | RD = memuh(RS+II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x28000800 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ;  = memuh(+)",
	},
	{
		// 0011111100000000EE01111101000000 | deallocframe ; dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_RETURN,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "deallocframe ; dealloc_return",
	},
	{
		// 00110iiissssddddEE01111101000000 | Rd = memb(Rs+Ii) ; dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memb(+) ; dealloc_return",
	},
	{
		// 00111110iiiiidddEE01111101000000 | Rdd = memd(r29+Ii) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memd(R29+) ; dealloc_return",
	},
	{
		// 00100iiissssddddEE01111101000000 | Rd = memh(Rs+Ii) ; dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memh(+) ; dealloc_return",
	},
	{
		// 0011110iiiiiddddEE01111101000000 | Rd = memw(r29+Ii) ; dealloc_return
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memw(R29+) ; dealloc_return",
	},
	{
		// 00101iiissssddddEE01111101000000 | Rd = memuh(Rs+Ii) ; dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = memuh(+) ; dealloc_return",
	},
	{
		// 0011111101000000EE01111101000000 | dealloc_return ; dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f401f40 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_RETURN,
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "dealloc_return ; dealloc_return",
	},
	{
		// 0011111100000000EE01111101000101 | deallocframe ; if (!p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_RETURN_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111101000101 | Rd = memb(Rs+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111101000101 | Rdd = memd(r29+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111101000101 | Rd = memh(Rs+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111101000101 | Rd = memw(r29+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111101000101 | Rd = memuh(Rs+Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111101000101 | dealloc_return ; if (!p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f401f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_RETURN_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111101000101 | if (!p0) dealloc_return ; if (!p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f451f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_RETURN_F,
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111101000101 | if (p0) dealloc_return ; if (!p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f441f45 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_RETURN_F,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111101000111 | deallocframe ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111101000111 | Rd = memb(Rs+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111101000111 | Rdd = memd(r29+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111101000111 | Rd = memh(Rs+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111101000111 | Rd = memw(r29+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111101000111 | Rd = memuh(Rs+Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111101000111 | dealloc_return ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f401f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111101000111 | if (!p0) dealloc_return ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f451f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000111EE01111101000111 | if (!p0.new) dealloc_return:nt ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f471f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111101000111 | if (p0) dealloc_return ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f441f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111101000111 | if (p0.new) dealloc_return:nt ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f461f47 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_RETURN_FNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111101000100 | deallocframe ; if (p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_RETURN_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111101000100 | Rd = memb(Rs+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111101000100 | Rdd = memd(r29+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111101000100 | Rd = memh(Rs+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111101000100 | Rd = memw(r29+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111101000100 | Rd = memuh(Rs+Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111101000100 | dealloc_return ; if (p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f401f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_RETURN_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111101000100 | if (p0) dealloc_return ; if (p0) dealloc_return
		.encoding = { .mask = 0xffffffff, .op = 0x3f441f44 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_RETURN_T,
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111100000000EE01111101000110 | deallocframe ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SL2_RETURN_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "deallocframe ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110iiissssddddEE01111101000110 | Rd = memb(Rs+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x30001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memb(+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111110iiiiidddEE01111101000110 | Rdd = memd(r29+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x3e001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memd(R29+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiissssddddEE01111101000110 | Rd = memh(Rs+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x20001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memh(+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011110iiiiiddddEE01111101000110 | Rd = memw(r29+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfe00ffff, .op = 0x3c001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memw(R29+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00101iiissssddddEE01111101000110 | Rd = memuh(Rs+Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x28001f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = memuh(+) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000000EE01111101000110 | dealloc_return ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f401f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SL2_RETURN_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "dealloc_return ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000101EE01111101000110 | if (!p0) dealloc_return ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f451f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SL2_RETURN_TNEW,
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000100EE01111101000110 | if (p0) dealloc_return ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f441f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SL2_RETURN_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 0011111101000110EE01111101000110 | if (p0.new) dealloc_return:nt ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xffffffff, .op = 0x3f461f46 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SL2_RETURN_TNEW,
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x3[] = {
	{
		// 00100iiiiiiiXXXXEE111000ssssxxxx | RX = add(RXin,Ii) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,)",
	},
	{
		// 00111000SSSSXXXXEE111000ssssxxxx | RX = add(RXin,RS) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x38003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,)",
	},
	{
		// 001011iiiiiiddddEE111000ssssxxxx | Rd = add(r29,Ii) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = add(,)",
	},
	{
		// 00110010SSSSddddEE111000ssssxxxx | Rd = and(RS,#1) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = add(,)",
	},
	{
		// 00110011SSSSddddEE111000ssssxxxx | Rd = add(RS,n1) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,)",
	},
	{
		// 00110001SSSSddddEE111000ssssxxxx | Rd = add(RS,#1) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = add(,)",
	},
	{
		// 001010iiiiiiddddEE111000ssssxxxx | Rd = Ii ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 00110101SSSSddddEE111000ssssxxxx | Rd = sxtb(RS) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x35003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = add(,)",
	},
	{
		// 00110100SSSSddddEE111000ssssxxxx | Rd = sxth(RS) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x34003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = add(,)",
	},
	{
		// 00110000SSSSddddEE111000ssssxxxx | Rd = RS ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 00110111SSSSddddEE111000ssssxxxx | Rd = and(RS,#255) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x37003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = add(,)",
	},
	{
		// 00110110SSSSddddEE111000ssssxxxx | Rd = zxth(RS) ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x36003800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = add(,)",
	},
	{
		// 001010iiiiiiddddEE111000ssssxxxx | Rd = Ii ; Rx = add(Rxin,Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003800 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_ADDRX,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 00100IIIIIIIxxxxEE1011iiiiiidddd | Rx = add(Rxin,II) ; Rd = add(r29,Ii)
		.encoding = { .mask = 0xf800fc00, .op = 0x20002c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_ADDSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(R29,)",
	},
	{
		// 001011IIIIIIDDDDEE1011iiiiiidddd | RD = add(r29,II) ; Rd = add(r29,Ii)
		.encoding = { .mask = 0xfc00fc00, .op = 0x2c002c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_ADDSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = add(R29,)",
	},
	{
		// 001010IIIIIIDDDDEE1011iiiiiidddd | RD = II ; Rd = add(r29,Ii)
		.encoding = { .mask = 0xfc00fc00, .op = 0x28002c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_ADDSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(R29,)",
	},
	{
		// 001010IIIIIIDDDDEE1011iiiiiidddd | RD = II ; Rd = add(r29,Ii)
		.encoding = { .mask = 0xfc00fc00, .op = 0x28002c00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_ADDSP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .imm_scale = 2, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(R29,)",
	},
	{
		// 00100iiiiiiixxxxEE110010ssssdddd | Rx = add(Rxin,Ii) ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = and(,#1)",
	},
	{
		// 001011iiiiiiDDDDEE110010ssssdddd | RD = add(r29,Ii) ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = and(,#1)",
	},
	{
		// 00110010SSSSDDDDEE110010ssssdddd | RD = and(RS,#1) ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = and(,#1)",
	},
	{
		// 00110001SSSSDDDDEE110010ssssdddd | RD = add(RS,#1) ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = and(,#1)",
	},
	{
		// 001010iiiiiiDDDDEE110010ssssdddd | RD = Ii ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#1)",
	},
	{
		// 00110000SSSSDDDDEE110010ssssdddd | RD = RS ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#1)",
	},
	{
		// 001010iiiiiiDDDDEE110010ssssdddd | RD = Ii ; Rd = and(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003200 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_AND1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#1)",
	},
	{
		// 00100iiiiiiixxxxEE1110100111dddd | Rx = add(Rxin,Ii) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xf800fff0, .op = 0x20003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000ssssxxxxEE1110100111dddd | Rx = add(Rxin,Rs) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x38003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001011iiiiiiDDDDEE1110100111dddd | RD = add(r29,Ii) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x2c003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(R29,) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010ssssDDDDEE1110100111dddd | RD = and(Rs,#1) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x32003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#1) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100111DDDDEE1110100111dddd | if (!p0) RD = #0 ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a703a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1110100111dddd | if (!p0.new) RD = #0 ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a503a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1110100111dddd | if (p0) RD = #0 ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a603a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1110100111dddd | if (p0.new) RD = #0 ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a403a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00iiEE1110100111dddd | p0 = cmp.eq(Rs,Ii) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff0cfff0, .op = 0x39003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "P0 = cmp.eq(,) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011ssssDDDDEE1110100111dddd | RD = add(Rs,n1) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x33003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001ssssDDDDEE1110100111dddd | RD = add(Rs,#1) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x31003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,#1) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100111dddd | RD = Ii ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100000DDDDEE1110100111dddd | RD = n1 ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101ssssDDDDEE1110100111dddd | RD = sxtb(Rs) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x35003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxtb() ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100ssssDDDDEE1110100111dddd | RD = sxth(Rs) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x34003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxth() ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000ssssDDDDEE1110100111dddd | RD = Rs ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x30003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111ssssDDDDEE1110100111dddd | RD = and(Rs,#255) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x37003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#255) ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110ssssDDDDEE1110100111dddd | RD = zxth(Rs) ; if (!p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x36003a70 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = zxth() ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100111dddd | RD = Ii ; if (!p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a70 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_CLRF,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiiiiiixxxxEE1110100101dddd | Rx = add(Rxin,Ii) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xf800fff0, .op = 0x20003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000ssssxxxxEE1110100101dddd | Rx = add(Rxin,Rs) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x38003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001011iiiiiiDDDDEE1110100101dddd | RD = add(r29,Ii) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x2c003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(R29,) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010ssssDDDDEE1110100101dddd | RD = and(Rs,#1) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x32003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#1) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1110100101dddd | if (!p0.new) RD = #0 ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a503a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 34 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1110100101dddd | if (p0.new) RD = #0 ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a403a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 33 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00iiEE1110100101dddd | p0 = cmp.eq(Rs,Ii) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff0cfff0, .op = 0x39003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "P0 = cmp.eq(,) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011ssssDDDDEE1110100101dddd | RD = add(Rs,n1) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x33003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001ssssDDDDEE1110100101dddd | RD = add(Rs,#1) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x31003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,#1) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100101dddd | RD = Ii ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100000DDDDEE1110100101dddd | RD = n1 ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101ssssDDDDEE1110100101dddd | RD = sxtb(Rs) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x35003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxtb() ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100ssssDDDDEE1110100101dddd | RD = sxth(Rs) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x34003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxth() ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000ssssDDDDEE1110100101dddd | RD = Rs ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x30003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111ssssDDDDEE1110100101dddd | RD = and(Rs,#255) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x37003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#255) ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110ssssDDDDEE1110100101dddd | RD = zxth(Rs) ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x36003a50 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = zxth() ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100101dddd | RD = Ii ; if (!p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a50 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_CLRFNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (!P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiiiiiixxxxEE1110100110dddd | Rx = add(Rxin,Ii) ; if (p0) Rd = #0
		.encoding = { .mask = 0xf800fff0, .op = 0x20003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000ssssxxxxEE1110100110dddd | Rx = add(Rxin,Rs) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x38003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001011iiiiiiDDDDEE1110100110dddd | RD = add(r29,Ii) ; if (p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x2c003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(R29,) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010ssssDDDDEE1110100110dddd | RD = and(Rs,#1) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x32003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#1) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1110100110dddd | if (!p0.new) RD = #0 ; if (p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a503a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1110100110dddd | if (p0) RD = #0 ; if (p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a603a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1110100110dddd | if (p0.new) RD = #0 ; if (p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a403a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00iiEE1110100110dddd | p0 = cmp.eq(Rs,Ii) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff0cfff0, .op = 0x39003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "P0 = cmp.eq(,) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011ssssDDDDEE1110100110dddd | RD = add(Rs,n1) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x33003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001ssssDDDDEE1110100110dddd | RD = add(Rs,#1) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x31003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,#1) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100110dddd | RD = Ii ; if (p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100000DDDDEE1110100110dddd | RD = n1 ; if (p0) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101ssssDDDDEE1110100110dddd | RD = sxtb(Rs) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x35003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxtb() ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100ssssDDDDEE1110100110dddd | RD = sxth(Rs) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x34003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxth() ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000ssssDDDDEE1110100110dddd | RD = Rs ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x30003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111ssssDDDDEE1110100110dddd | RD = and(Rs,#255) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x37003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#255) ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110ssssDDDDEE1110100110dddd | RD = zxth(Rs) ; if (p0) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x36003a60 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = zxth() ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100110dddd | RD = Ii ; if (p0) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a60 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_CLRT,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100iiiiiiixxxxEE1110100100dddd | Rx = add(Rxin,Ii) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xf800fff0, .op = 0x20003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111000ssssxxxxEE1110100100dddd | Rx = add(Rxin,Rs) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x38003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001011iiiiiiDDDDEE1110100100dddd | RD = add(r29,Ii) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x2c003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(R29,) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110010ssssDDDDEE1110100100dddd | RD = and(Rs,#1) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x32003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#1) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1110100100dddd | if (p0.new) RD = #0 ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a403a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00iiEE1110100100dddd | p0 = cmp.eq(Rs,Ii) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff0cfff0, .op = 0x39003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "P0 = cmp.eq(,) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110011ssssDDDDEE1110100100dddd | RD = add(Rs,n1) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x33003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110001ssssDDDDEE1110100100dddd | RD = add(Rs,#1) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x31003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = add(,#1) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100100dddd | RD = Ii ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100000DDDDEE1110100100dddd | RD = n1 ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110101ssssDDDDEE1110100100dddd | RD = sxtb(Rs) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x35003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxtb() ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110100ssssDDDDEE1110100100dddd | RD = sxth(Rs) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x34003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = sxth() ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110000ssssDDDDEE1110100100dddd | RD = Rs ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x30003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110111ssssDDDDEE1110100100dddd | RD = and(Rs,#255) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x37003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = and(,#255) ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00110110ssssDDDDEE1110100100dddd | RD = zxth(Rs) ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xff00fff0, .op = 0x36003a40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " = zxth() ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001010iiiiiiDDDDEE1110100100dddd | RD = Ii ; if (p0.new) Rd = #0
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a40 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_CLRTNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = " =  ; if (P0.new)  = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00100IIIIIIIxxxxEE111001ssss00ii | Rx = add(Rxin,II) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xf800ff0c, .op = 0x20003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; P0 = cmp.eq(,)",
	},
	{
		// 00111000SSSSxxxxEE111001ssss00ii | Rx = add(Rxin,RS) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x38003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; P0 = cmp.eq(,)",
	},
	{
		// 001011IIIIIIddddEE111001ssss00ii | Rd = add(r29,II) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xfc00ff0c, .op = 0x2c003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; P0 = cmp.eq(,)",
	},
	{
		// 00110010SSSSddddEE111001ssss00ii | Rd = and(RS,#1) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x32003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; P0 = cmp.eq(,)",
	},
	{
		// 00111001SSSS00IIEE111001ssss00ii | p0 = cmp.eq(RS,II) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff0cff0c, .op = 0x39003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; P0 = cmp.eq(,)",
	},
	{
		// 00110011SSSSddddEE111001ssss00ii | Rd = add(RS,n1) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x33003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; P0 = cmp.eq(,)",
	},
	{
		// 00110001SSSSddddEE111001ssss00ii | Rd = add(RS,#1) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x31003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; P0 = cmp.eq(,)",
	},
	{
		// 001010IIIIIIddddEE111001ssss00ii | Rd = II ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xfc00ff0c, .op = 0x28003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; P0 = cmp.eq(,)",
	},
	{
		// 00110101SSSSddddEE111001ssss00ii | Rd = sxtb(RS) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x35003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; P0 = cmp.eq(,)",
	},
	{
		// 00110100SSSSddddEE111001ssss00ii | Rd = sxth(RS) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x34003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; P0 = cmp.eq(,)",
	},
	{
		// 00110000SSSSddddEE111001ssss00ii | Rd = RS ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x30003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; P0 = cmp.eq(,)",
	},
	{
		// 00110111SSSSddddEE111001ssss00ii | Rd = and(RS,#255) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x37003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; P0 = cmp.eq(,)",
	},
	{
		// 00110110SSSSddddEE111001ssss00ii | Rd = zxth(RS) ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xff00ff0c, .op = 0x36003900 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 0 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; P0 = cmp.eq(,)",
	},
	{
		// 001010IIIIIIddddEE111001ssss00ii | Rd = II ; p0 = cmp.eq(Rs,Ii)
		.encoding = { .mask = 0xfc00ff0c, .op = 0x28003900 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_CMPEQI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 0 } }, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; P0 = cmp.eq(,)",
	},
	{
		// 00100IIIIIIIxxxxEE1111000ii00ddd | Rx = add(Rxin,II) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xf800ff98, .op = 0x20003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 00111000ssssxxxxEE1111000ii00ddd | Rx = add(Rxin,Rs) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x38003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 001011IIIIIIDDDDEE1111000ii00ddd | RD = add(r29,II) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x2c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(#0,)",
	},
	{
		// 00110010ssssDDDDEE1111000ii00ddd | RD = and(Rs,#1) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x32003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(#0,)",
	},
	{
		// 001110100111DDDDEE1111000ii00ddd | if (!p0) RD = #0 ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a703c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1111000ii00ddd | if (!p0.new) RD = #0 ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a503c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 35 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1111000ii00ddd | if (p0) RD = #0 ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a603c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1111000ii00ddd | if (p0.new) RD = #0 ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a403c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 34 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00IIEE1111000ii00ddd | p0 = cmp.eq(Rs,II) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff0cff98, .op = 0x39003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(#0,)",
	},
	{
		// 001111000II00DDDEE1111000ii00ddd | RDD = combine(#0,II) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#0,)",
	},
	{
		// 00110011ssssDDDDEE1111000ii00ddd | RD = add(Rs,n1) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x33003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 00110001ssssDDDDEE1111000ii00ddd | RD = add(Rs,#1) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x31003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(#0,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii00ddd | RD = II ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 001110100000DDDDEE1111000ii00ddd | RD = n1 ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00110101ssssDDDDEE1111000ii00ddd | RD = sxtb(Rs) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x35003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(#0,)",
	},
	{
		// 00110100ssssDDDDEE1111000ii00ddd | RD = sxth(Rs) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x34003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(#0,)",
	},
	{
		// 00110000ssssDDDDEE1111000ii00ddd | RD = Rs ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x30003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00110111ssssDDDDEE1111000ii00ddd | RD = and(Rs,#255) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x37003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(#0,)",
	},
	{
		// 00110110ssssDDDDEE1111000ii00ddd | RD = zxth(Rs) ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x36003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(#0,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii00ddd | RD = II ; Rdd = combine(#0,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINE0I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00100IIIIIIIxxxxEE1111000ii01ddd | Rx = add(Rxin,II) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xf800ff98, .op = 0x20003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#1,)",
	},
	{
		// 00111000ssssxxxxEE1111000ii01ddd | Rx = add(Rxin,Rs) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x38003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#1,)",
	},
	{
		// 001011IIIIIIDDDDEE1111000ii01ddd | RD = add(r29,II) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x2c003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(#1,)",
	},
	{
		// 00110010ssssDDDDEE1111000ii01ddd | RD = and(Rs,#1) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x32003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(#1,)",
	},
	{
		// 001110100111DDDDEE1111000ii01ddd | if (!p0) RD = #0 ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a703c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(#1,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1111000ii01ddd | if (!p0.new) RD = #0 ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a503c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 35 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(#1,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1111000ii01ddd | if (p0) RD = #0 ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a603c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(#1,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1111000ii01ddd | if (p0.new) RD = #0 ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a403c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 34 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(#1,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00IIEE1111000ii01ddd | p0 = cmp.eq(Rs,II) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff0cff98, .op = 0x39003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(#1,)",
	},
	{
		// 001111000II00DDDEE1111000ii01ddd | RDD = combine(#0,II) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#1,)",
	},
	{
		// 001111000II01DDDEE1111000ii01ddd | RDD = combine(#1,II) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c083c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = combine(#1,)",
	},
	{
		// 00110011ssssDDDDEE1111000ii01ddd | RD = add(Rs,n1) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x33003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#1,)",
	},
	{
		// 00110001ssssDDDDEE1111000ii01ddd | RD = add(Rs,#1) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x31003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(#1,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii01ddd | RD = II ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#1,)",
	},
	{
		// 001110100000DDDDEE1111000ii01ddd | RD = n1 ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#1,)",
	},
	{
		// 00110101ssssDDDDEE1111000ii01ddd | RD = sxtb(Rs) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x35003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(#1,)",
	},
	{
		// 00110100ssssDDDDEE1111000ii01ddd | RD = sxth(Rs) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x34003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(#1,)",
	},
	{
		// 00110000ssssDDDDEE1111000ii01ddd | RD = Rs ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x30003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#1,)",
	},
	{
		// 00110111ssssDDDDEE1111000ii01ddd | RD = and(Rs,#255) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x37003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(#1,)",
	},
	{
		// 00110110ssssDDDDEE1111000ii01ddd | RD = zxth(Rs) ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x36003c08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(#1,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii01ddd | RD = II ; Rdd = combine(#1,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c08 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINE1I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#1,)",
	},
	{
		// 00100IIIIIIIxxxxEE1111000ii10ddd | Rx = add(Rxin,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xf800ff98, .op = 0x20003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#2,)",
	},
	{
		// 00111000ssssxxxxEE1111000ii10ddd | Rx = add(Rxin,Rs) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x38003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#2,)",
	},
	{
		// 001011IIIIIIDDDDEE1111000ii10ddd | RD = add(r29,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x2c003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(#2,)",
	},
	{
		// 00110010ssssDDDDEE1111000ii10ddd | RD = and(Rs,#1) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x32003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(#2,)",
	},
	{
		// 001110100111DDDDEE1111000ii10ddd | if (!p0) RD = #0 ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a703c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(#2,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1111000ii10ddd | if (!p0.new) RD = #0 ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a503c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 35 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(#2,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1111000ii10ddd | if (p0) RD = #0 ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a603c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(#2,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1111000ii10ddd | if (p0.new) RD = #0 ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a403c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 34 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(#2,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00IIEE1111000ii10ddd | p0 = cmp.eq(Rs,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff0cff98, .op = 0x39003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(#2,)",
	},
	{
		// 001111000II00DDDEE1111000ii10ddd | RDD = combine(#0,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#2,)",
	},
	{
		// 001111000II01DDDEE1111000ii10ddd | RDD = combine(#1,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c083c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = combine(#2,)",
	},
	{
		// 001111000II10DDDEE1111000ii10ddd | RDD = combine(#2,II) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c103c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = combine(#2,)",
	},
	{
		// 00110011ssssDDDDEE1111000ii10ddd | RD = add(Rs,n1) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x33003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#2,)",
	},
	{
		// 00110001ssssDDDDEE1111000ii10ddd | RD = add(Rs,#1) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x31003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(#2,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii10ddd | RD = II ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#2,)",
	},
	{
		// 001110100000DDDDEE1111000ii10ddd | RD = n1 ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#2,)",
	},
	{
		// 00110101ssssDDDDEE1111000ii10ddd | RD = sxtb(Rs) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x35003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(#2,)",
	},
	{
		// 00110100ssssDDDDEE1111000ii10ddd | RD = sxth(Rs) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x34003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(#2,)",
	},
	{
		// 00110000ssssDDDDEE1111000ii10ddd | RD = Rs ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x30003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#2,)",
	},
	{
		// 00110111ssssDDDDEE1111000ii10ddd | RD = and(Rs,#255) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x37003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(#2,)",
	},
	{
		// 00110110ssssDDDDEE1111000ii10ddd | RD = zxth(Rs) ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x36003c10 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(#2,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii10ddd | RD = II ; Rdd = combine(#2,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c10 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINE2I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#2,)",
	},
	{
		// 00100IIIIIIIxxxxEE1111000ii11ddd | Rx = add(Rxin,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xf800ff98, .op = 0x20003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#3,)",
	},
	{
		// 00111000ssssxxxxEE1111000ii11ddd | Rx = add(Rxin,Rs) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x38003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#3,)",
	},
	{
		// 001011IIIIIIDDDDEE1111000ii11ddd | RD = add(r29,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x2c003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(#3,)",
	},
	{
		// 00110010ssssDDDDEE1111000ii11ddd | RD = and(Rs,#1) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x32003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(#3,)",
	},
	{
		// 001110100111DDDDEE1111000ii11ddd | if (!p0) RD = #0 ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a703c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(#3,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE1111000ii11ddd | if (!p0.new) RD = #0 ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a503c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 35 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(#3,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE1111000ii11ddd | if (p0) RD = #0 ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a603c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(#3,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE1111000ii11ddd | if (p0.new) RD = #0 ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a403c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 34 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(#3,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001ssss00IIEE1111000ii11ddd | p0 = cmp.eq(Rs,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff0cff98, .op = 0x39003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(#3,)",
	},
	{
		// 001111000II00DDDEE1111000ii11ddd | RDD = combine(#0,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#3,)",
	},
	{
		// 001111000II01DDDEE1111000ii11ddd | RDD = combine(#1,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c083c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = combine(#3,)",
	},
	{
		// 001111000II10DDDEE1111000ii11ddd | RDD = combine(#2,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c103c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = combine(#3,)",
	},
	{
		// 001111000II11DDDEE1111000ii11ddd | RDD = combine(#3,II) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff98ff98, .op = 0x3c183c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = combine(#3,)",
	},
	{
		// 00110011ssssDDDDEE1111000ii11ddd | RD = add(Rs,n1) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x33003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#3,)",
	},
	{
		// 00110001ssssDDDDEE1111000ii11ddd | RD = add(Rs,#1) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x31003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(#3,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii11ddd | RD = II ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#3,)",
	},
	{
		// 001110100000DDDDEE1111000ii11ddd | RD = n1 ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfff0ff98, .op = 0x3a003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#3,)",
	},
	{
		// 00110101ssssDDDDEE1111000ii11ddd | RD = sxtb(Rs) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x35003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(#3,)",
	},
	{
		// 00110100ssssDDDDEE1111000ii11ddd | RD = sxth(Rs) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x34003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(#3,)",
	},
	{
		// 00110000ssssDDDDEE1111000ii11ddd | RD = Rs ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x30003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#3,)",
	},
	{
		// 00110111ssssDDDDEE1111000ii11ddd | RD = and(Rs,#255) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x37003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(#3,)",
	},
	{
		// 00110110ssssDDDDEE1111000ii11ddd | RD = zxth(Rs) ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xff00ff98, .op = 0x36003c18 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 5 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(#3,)",
	},
	{
		// 001010IIIIIIDDDDEE1111000ii11ddd | RD = II ; Rdd = combine(#3,Ii)
		.encoding = { .mask = 0xfc00ff98, .op = 0x28003c18 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINE3I,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 5 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#3,)",
	},
	{
		// 00100iiiiiiixxxxEE111101ssss1ddd | Rx = add(Rxin,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xf800ff08, .op = 0x20003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(,#0)",
	},
	{
		// 00111000SSSSxxxxEE111101ssss1ddd | Rx = add(Rxin,RS) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x38003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(,#0)",
	},
	{
		// 001011iiiiiiDDDDEE111101ssss1ddd | RD = add(r29,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfc00ff08, .op = 0x2c003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(,#0)",
	},
	{
		// 00110010SSSSDDDDEE111101ssss1ddd | RD = and(RS,#1) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x32003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(,#0)",
	},
	{
		// 001110100111DDDDEE111101ssss1ddd | if (!p0) RD = #0 ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a703d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(,#0)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE111101ssss1ddd | if (!p0.new) RD = #0 ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a503d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(,#0)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE111101ssss1ddd | if (p0) RD = #0 ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a603d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(,#0)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE111101ssss1ddd | if (p0.new) RD = #0 ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a403d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(,#0)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001SSSS00iiEE111101ssss1ddd | p0 = cmp.eq(RS,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff0cff08, .op = 0x39003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(,#0)",
	},
	{
		// 001111000ii00DDDEE111101ssss1ddd | RDD = combine(#0,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(,#0)",
	},
	{
		// 001111000ii01DDDEE111101ssss1ddd | RDD = combine(#1,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c083d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = combine(,#0)",
	},
	{
		// 001111000ii10DDDEE111101ssss1ddd | RDD = combine(#2,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c103d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = combine(,#0)",
	},
	{
		// 001111000ii11DDDEE111101ssss1ddd | RDD = combine(#3,Ii) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c183d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = combine(,#0)",
	},
	{
		// 00111101SSSS1DDDEE111101ssss1ddd | RDD = combine(RS,#0) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff08ff08, .op = 0x3d083d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = combine(,#0)",
	},
	{
		// 00111101SSSS0DDDEE111101ssss1ddd | RDD = combine(#0,RS) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff08ff08, .op = 0x3d003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(,#0)",
	},
	{
		// 00110011SSSSDDDDEE111101ssss1ddd | RD = add(RS,n1) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x33003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(,#0)",
	},
	{
		// 00110001SSSSDDDDEE111101ssss1ddd | RD = add(RS,#1) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x31003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(,#0)",
	},
	{
		// 001010iiiiiiDDDDEE111101ssss1ddd | RD = Ii ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfc00ff08, .op = 0x28003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(,#0)",
	},
	{
		// 001110100000DDDDEE111101ssss1ddd | RD = n1 ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(,#0)",
	},
	{
		// 00110101SSSSDDDDEE111101ssss1ddd | RD = sxtb(RS) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x35003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(,#0)",
	},
	{
		// 00110100SSSSDDDDEE111101ssss1ddd | RD = sxth(RS) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x34003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(,#0)",
	},
	{
		// 00110000SSSSDDDDEE111101ssss1ddd | RD = RS ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x30003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(,#0)",
	},
	{
		// 00110111SSSSDDDDEE111101ssss1ddd | RD = and(RS,#255) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x37003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(,#0)",
	},
	{
		// 00110110SSSSDDDDEE111101ssss1ddd | RD = zxth(RS) ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xff00ff08, .op = 0x36003d08 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(,#0)",
	},
	{
		// 001010iiiiiiDDDDEE111101ssss1ddd | RD = Ii ; Rdd = combine(Rs,#0)
		.encoding = { .mask = 0xfc00ff08, .op = 0x28003d08 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINERZ,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(,#0)",
	},
	{
		// 00100iiiiiiixxxxEE111101ssss0ddd | Rx = add(Rxin,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xf800ff08, .op = 0x20003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 00111000SSSSxxxxEE111101ssss0ddd | Rx = add(Rxin,RS) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x38003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 001011iiiiiiDDDDEE111101ssss0ddd | RD = add(r29,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfc00ff08, .op = 0x2c003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = combine(#0,)",
	},
	{
		// 00110010SSSSDDDDEE111101ssss0ddd | RD = and(RS,#1) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x32003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = combine(#0,)",
	},
	{
		// 001110100111DDDDEE111101ssss0ddd | if (!p0) RD = #0 ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a703d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100101DDDDEE111101ssss0ddd | if (!p0.new) RD = #0 ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a503d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 35 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100110DDDDEE111101ssss0ddd | if (p0) RD = #0 ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a603d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 001110100100DDDDEE111101ssss0ddd | if (p0.new) RD = #0 ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a403d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 34 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = combine(#0,)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 00111001SSSS00iiEE111101ssss0ddd | p0 = cmp.eq(RS,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff0cff08, .op = 0x39003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = combine(#0,)",
	},
	{
		// 001111000ii00DDDEE111101ssss0ddd | RDD = combine(#0,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#0,)",
	},
	{
		// 001111000ii01DDDEE111101ssss0ddd | RDD = combine(#1,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c083d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = combine(#0,)",
	},
	{
		// 001111000ii10DDDEE111101ssss0ddd | RDD = combine(#2,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c103d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = combine(#0,)",
	},
	{
		// 001111000ii11DDDEE111101ssss0ddd | RDD = combine(#3,Ii) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff98ff08, .op = 0x3c183d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = combine(#0,)",
	},
	{
		// 00111101SSSS0DDDEE111101ssss0ddd | RDD = combine(#0,RS) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff08ff08, .op = 0x3d003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 32 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = combine(#0,)",
	},
	{
		// 00110011SSSSDDDDEE111101ssss0ddd | RD = add(RS,n1) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x33003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = combine(#0,)",
	},
	{
		// 00110001SSSSDDDDEE111101ssss0ddd | RD = add(RS,#1) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x31003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = combine(#0,)",
	},
	{
		// 001010iiiiiiDDDDEE111101ssss0ddd | RD = Ii ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfc00ff08, .op = 0x28003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 001110100000DDDDEE111101ssss0ddd | RD = n1 ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfff0ff08, .op = 0x3a003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00110101SSSSDDDDEE111101ssss0ddd | RD = sxtb(RS) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x35003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = combine(#0,)",
	},
	{
		// 00110100SSSSDDDDEE111101ssss0ddd | RD = sxth(RS) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x34003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = combine(#0,)",
	},
	{
		// 00110000SSSSDDDDEE111101ssss0ddd | RD = RS ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x30003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00110111SSSSDDDDEE111101ssss0ddd | RD = and(RS,#255) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x37003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = combine(#0,)",
	},
	{
		// 00110110SSSSDDDDEE111101ssss0ddd | RD = zxth(RS) ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xff00ff08, .op = 0x36003d00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = combine(#0,)",
	},
	{
		// 001010iiiiiiDDDDEE111101ssss0ddd | RD = Ii ; Rdd = combine(#0,Rs)
		.encoding = { .mask = 0xfc00ff08, .op = 0x28003d00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_COMBINEZR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = combine(#0,)",
	},
	{
		// 00100iiiiiiixxxxEE110011ssssdddd | Rx = add(Rxin,Ii) ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,)",
	},
	{
		// 001011iiiiiiDDDDEE110011ssssdddd | RD = add(r29,Ii) ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = add(,)",
	},
	{
		// 00110010SSSSDDDDEE110011ssssdddd | RD = and(RS,#1) ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = add(,)",
	},
	{
		// 00110011SSSSDDDDEE110011ssssdddd | RD = add(RS,N1) ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,)",
	},
	{
		// 00110001SSSSDDDDEE110011ssssdddd | RD = add(RS,#1) ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = add(,)",
	},
	{
		// 001010iiiiiiDDDDEE110011ssssdddd | RD = Ii ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 00110000SSSSDDDDEE110011ssssdddd | RD = RS ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 001010iiiiiiDDDDEE110011ssssdddd | RD = Ii ; Rd = add(Rs,n1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003300 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_DEC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,)",
	},
	{
		// 00100iiiiiiixxxxEE110001ssssdddd | Rx = add(Rxin,Ii) ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = add(,#1)",
	},
	{
		// 001011iiiiiiDDDDEE110001ssssdddd | RD = add(r29,Ii) ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = add(,#1)",
	},
	{
		// 00110001SSSSDDDDEE110001ssssdddd | RD = add(RS,#1) ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = add(,#1)",
	},
	{
		// 001010iiiiiiDDDDEE110001ssssdddd | RD = Ii ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,#1)",
	},
	{
		// 00110000SSSSDDDDEE110001ssssdddd | RD = RS ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,#1)",
	},
	{
		// 001010iiiiiiDDDDEE110001ssssdddd | RD = Ii ; Rd = add(Rs,#1)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003100 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_INC,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = add(,#1)",
	},
	{
		// 00100iiiiiiixxxxEE1110100000dddd | Rx = add(Rxin,Ii) ; Rd = n1
		.encoding = { .mask = 0xf800fff0, .op = 0x20003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = ",
	},
	{
		// 00111000ssssxxxxEE1110100000dddd | Rx = add(Rxin,Rs) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x38003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = ",
	},
	{
		// 001011iiiiiiDDDDEE1110100000dddd | RD = add(r29,Ii) ; Rd = n1
		.encoding = { .mask = 0xfc00fff0, .op = 0x2c003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = ",
	},
	{
		// 00110010ssssDDDDEE1110100000dddd | RD = and(Rs,#1) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x32003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = ",
	},
	{
		// 00111001ssss00iiEE1110100000dddd | p0 = cmp.eq(Rs,Ii) ; Rd = n1
		.encoding = { .mask = 0xff0cfff0, .op = 0x39003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = ",
	},
	{
		// 00110011ssssDDDDEE1110100000dddd | RD = add(Rs,N1) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x33003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = ",
	},
	{
		// 00110001ssssDDDDEE1110100000dddd | RD = add(Rs,#1) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x31003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = ",
	},
	{
		// 001010iiiiiiDDDDEE1110100000dddd | RD = Ii ; Rd = n1
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 001110100000DDDDEE1110100000dddd | RD = N1 ; Rd = n1
		.encoding = { .mask = 0xfff0fff0, .op = 0x3a003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 00110101ssssDDDDEE1110100000dddd | RD = sxtb(Rs) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x35003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = ",
	},
	{
		// 00110100ssssDDDDEE1110100000dddd | RD = sxth(Rs) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x34003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = ",
	},
	{
		// 00110000ssssDDDDEE1110100000dddd | RD = Rs ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x30003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 00110111ssssDDDDEE1110100000dddd | RD = and(Rs,#255) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x37003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = ",
	},
	{
		// 00110110ssssDDDDEE1110100000dddd | RD = zxth(Rs) ; Rd = n1
		.encoding = { .mask = 0xff00fff0, .op = 0x36003a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = ",
	},
	{
		// 001010iiiiiiDDDDEE1110100000dddd | RD = Ii ; Rd = n1
		.encoding = { .mask = 0xfc00fff0, .op = 0x28003a00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_SETIN1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 00100iiiiiiixxxxEE110101ssssdddd | Rx = add(Rxin,Ii) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = sxtb()",
	},
	{
		// 001011iiiiiiDDDDEE110101ssssdddd | RD = add(r29,Ii) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = sxtb()",
	},
	{
		// 00110010SSSSDDDDEE110101ssssdddd | RD = and(RS,#1) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = sxtb()",
	},
	{
		// 00110011SSSSDDDDEE110101ssssdddd | RD = add(RS,n1) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = sxtb()",
	},
	{
		// 00110001SSSSDDDDEE110101ssssdddd | RD = add(RS,#1) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = sxtb()",
	},
	{
		// 001010iiiiiiDDDDEE110101ssssdddd | RD = Ii ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxtb()",
	},
	{
		// 00110101SSSSDDDDEE110101ssssdddd | RD = sxtb(RS) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x35003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = sxtb()",
	},
	{
		// 00110100SSSSDDDDEE110101ssssdddd | RD = sxth(RS) ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x34003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = sxtb()",
	},
	{
		// 00110000SSSSDDDDEE110101ssssdddd | RD = RS ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003500 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxtb()",
	},
	{
		// 001010iiiiiiDDDDEE110101ssssdddd | RD = Ii ; Rd = sxtb(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003500 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_SXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxtb()",
	},
	{
		// 00100iiiiiiixxxxEE110100ssssdddd | Rx = add(Rxin,Ii) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = sxth()",
	},
	{
		// 001011iiiiiiDDDDEE110100ssssdddd | RD = add(r29,Ii) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = sxth()",
	},
	{
		// 00110010SSSSDDDDEE110100ssssdddd | RD = and(RS,#1) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = sxth()",
	},
	{
		// 00110011SSSSDDDDEE110100ssssdddd | RD = add(RS,n1) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = sxth()",
	},
	{
		// 00110001SSSSDDDDEE110100ssssdddd | RD = add(RS,#1) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = sxth()",
	},
	{
		// 001010iiiiiiDDDDEE110100ssssdddd | RD = Ii ; Rd = sxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxth()",
	},
	{
		// 00110100SSSSDDDDEE110100ssssdddd | RD = sxth(RS) ; Rd = sxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x34003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = sxth()",
	},
	{
		// 00110000SSSSDDDDEE110100ssssdddd | RD = RS ; Rd = sxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003400 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxth()",
	},
	{
		// 001010iiiiiiDDDDEE110100ssssdddd | RD = Ii ; Rd = sxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003400 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_SXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = sxth()",
	},
	{
		// 00100iiiiiiixxxxEE110000ssssdddd | Rx = add(Rxin,Ii) ; Rd = Rs
		.encoding = { .mask = 0xf800ff00, .op = 0x20003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = ",
	},
	{
		// 001011iiiiiiDDDDEE110000ssssdddd | RD = add(r29,Ii) ; Rd = Rs
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = ",
	},
	{
		// 001010iiiiiiDDDDEE110000ssssdddd | RD = Ii ; Rd = Rs
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 00110000SSSSDDDDEE110000ssssdddd | RD = RS ; Rd = Rs
		.encoding = { .mask = 0xff00ff00, .op = 0x30003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 001010iiiiiiDDDDEE110000ssssdddd | RD = Ii ; Rd = Rs
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_TFR,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 00100iiiiiiixxxxEE110111ssssdddd | Rx = add(Rxin,Ii) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = and(,#255)",
	},
	{
		// 001011iiiiiiDDDDEE110111ssssdddd | RD = add(r29,Ii) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = and(,#255)",
	},
	{
		// 00110010SSSSDDDDEE110111ssssdddd | RD = and(RS,#1) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = and(,#255)",
	},
	{
		// 00110011SSSSDDDDEE110111ssssdddd | RD = add(RS,n1) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = and(,#255)",
	},
	{
		// 00110001SSSSDDDDEE110111ssssdddd | RD = add(RS,#1) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = and(,#255)",
	},
	{
		// 001010iiiiiiDDDDEE110111ssssdddd | RD = Ii ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#255)",
	},
	{
		// 00110101SSSSDDDDEE110111ssssdddd | RD = sxtb(RS) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x35003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = and(,#255)",
	},
	{
		// 00110100SSSSDDDDEE110111ssssdddd | RD = sxth(RS) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x34003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = and(,#255)",
	},
	{
		// 00110000SSSSDDDDEE110111ssssdddd | RD = RS ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#255)",
	},
	{
		// 00110111SSSSDDDDEE110111ssssdddd | RD = and(RS,#255) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x37003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = and(,#255)",
	},
	{
		// 00110110SSSSDDDDEE110111ssssdddd | RD = zxth(RS) ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xff00ff00, .op = 0x36003700 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = and(,#255)",
	},
	{
		// 001010iiiiiiDDDDEE110111ssssdddd | RD = Ii ; Rd = and(Rs,#255)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003700 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_ZXTB,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = and(,#255)",
	},
	{
		// 00100iiiiiiixxxxEE110110ssssdddd | Rx = add(Rxin,Ii) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xf800ff00, .op = 0x20003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = zxth()",
	},
	{
		// 001011iiiiiiDDDDEE110110ssssdddd | RD = add(r29,Ii) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x2c003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = zxth()",
	},
	{
		// 00110010SSSSDDDDEE110110ssssdddd | RD = and(RS,#1) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x32003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = zxth()",
	},
	{
		// 00110011SSSSDDDDEE110110ssssdddd | RD = add(RS,n1) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x33003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = zxth()",
	},
	{
		// 00110001SSSSDDDDEE110110ssssdddd | RD = add(RS,#1) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x31003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = zxth()",
	},
	{
		// 001010iiiiiiDDDDEE110110ssssdddd | RD = Ii ; Rd = zxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = zxth()",
	},
	{
		// 00110101SSSSDDDDEE110110ssssdddd | RD = sxtb(RS) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x35003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = zxth()",
	},
	{
		// 00110100SSSSDDDDEE110110ssssdddd | RD = sxth(RS) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x34003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = zxth()",
	},
	{
		// 00110000SSSSDDDDEE110110ssssdddd | RD = RS ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x30003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = zxth()",
	},
	{
		// 00110110SSSSDDDDEE110110ssssdddd | RD = zxth(RS) ; Rd = zxth(Rs)
		.encoding = { .mask = 0xff00ff00, .op = 0x36003600 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = zxth()",
	},
	{
		// 001010iiiiiiDDDDEE110110ssssdddd | RD = Ii ; Rd = zxth(Rs)
		.encoding = { .mask = 0xfc00ff00, .op = 0x28003600 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SA1_ZXTH,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = zxth()",
	},
	{
		// 00100IIIIIIIxxxxEE1010iiiiiidddd | Rx = add(Rxin,II) ; Rd = Ii
		.encoding = { .mask = 0xf800fc00, .op = 0x20002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_UNDOCUMENTED_SA2_TFRSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = ",
	},
	{
		// 001010IIIIIIDDDDEE1010iiiiiidddd | RD = II ; Rd = Ii
		.encoding = { .mask = 0xfc00fc00, .op = 0x28002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_UNDOCUMENTED_SA2_TFRSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{
		// 001010IIIIIIDDDDEE1010iiiiiidddd | RD = II ; Rd = Ii
		.encoding = { .mask = 0xfc00fc00, .op = 0x28002800 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_UNDOCUMENTED_SA2_TFRSI,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 4 } }, .syntax = 9 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = ",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x4[] = {
	{
		// 01000IIIIIIIxxxxEE00iiiissssdddd | Rx = add(Rxin,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xf800f000, .op = 0x40000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(+)",
	},
	{
		// 01011000SSSSxxxxEE00iiiissssdddd | Rx = add(Rxin,RS) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x58000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(+)",
	},
	{
		// 010011IIIIIIDDDDEE00iiiissssdddd | RD = add(r29,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x4c000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memw(+)",
	},
	{
		// 01010010SSSSDDDDEE00iiiissssdddd | RD = and(RS,#1) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x52000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memw(+)",
	},
	{
		// 010110100111DDDDEE00iiiissssdddd | if (!p0) RD = #0 ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a700000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE00iiiissssdddd | if (!p0.new) RD = #0 ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a500000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE00iiiissssdddd | if (p0) RD = #0 ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a600000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 25 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE00iiiissssdddd | if (p0.new) RD = #0 ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a400000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memw(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001SSSS00IIEE00iiiissssdddd | p0 = cmp.eq(RS,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff0cf000, .op = 0x59000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memw(+)",
	},
	{
		// 010111000II00DDDEE00iiiissssdddd | RDD = combine(#0,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memw(+)",
	},
	{
		// 010111000II01DDDEE00iiiissssdddd | RDD = combine(#1,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c080000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memw(+)",
	},
	{
		// 010111000II10DDDEE00iiiissssdddd | RDD = combine(#2,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c100000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memw(+)",
	},
	{
		// 010111000II11DDDEE00iiiissssdddd | RDD = combine(#3,II) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c180000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memw(+)",
	},
	{
		// 01011101SSSS1DDDEE00iiiissssdddd | RDD = combine(RS,#0) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff08f000, .op = 0x5d080000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memw(+)",
	},
	{
		// 01011101SSSS0DDDEE00iiiissssdddd | RDD = combine(#0,RS) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff08f000, .op = 0x5d000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memw(+)",
	},
	{
		// 01010011SSSSDDDDEE00iiiissssdddd | RD = add(RS,n1) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x53000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(+)",
	},
	{
		// 01010001SSSSDDDDEE00iiiissssdddd | RD = add(RS,#1) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x51000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memw(+)",
	},
	{
		// 010010IIIIIIDDDDEE00iiiissssdddd | RD = II ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x48000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(+)",
	},
	{
		// 010110100000DDDDEE00iiiissssdddd | RD = n1 ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(+)",
	},
	{
		// 01010101SSSSDDDDEE00iiiissssdddd | RD = sxtb(RS) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x55000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memw(+)",
	},
	{
		// 01010100SSSSDDDDEE00iiiissssdddd | RD = sxth(RS) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x54000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memw(+)",
	},
	{
		// 01010000SSSSDDDDEE00iiiissssdddd | RD = RS ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x50000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(+)",
	},
	{
		// 01010111SSSSDDDDEE00iiiissssdddd | RD = and(RS,#255) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x57000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memw(+)",
	},
	{
		// 01010110SSSSDDDDEE00iiiissssdddd | RD = zxth(RS) ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x56000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memw(+)",
	},
	{
		// 010010IIIIIIDDDDEE00iiiissssdddd | RD = II ; Rd = memw(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x48000000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL1_LOADRI_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(+)",
	},
	{
		// 01000IIIIIIIxxxxEE01iiiissssdddd | Rx = add(Rxin,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xf800f000, .op = 0x40001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memub(+)",
	},
	{
		// 01011000SSSSxxxxEE01iiiissssdddd | Rx = add(Rxin,RS) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x58001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memub(+)",
	},
	{
		// 010011IIIIIIDDDDEE01iiiissssdddd | RD = add(r29,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x4c001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memub(+)",
	},
	{
		// 01010010SSSSDDDDEE01iiiissssdddd | RD = and(RS,#1) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x52001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memub(+)",
	},
	{
		// 010110100111DDDDEE01iiiissssdddd | if (!p0) RD = #0 ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a701000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE01iiiissssdddd | if (!p0.new) RD = #0 ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a501000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE01iiiissssdddd | if (p0) RD = #0 ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a601000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE01iiiissssdddd | if (p0.new) RD = #0 ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a401000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memub(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001SSSS00IIEE01iiiissssdddd | p0 = cmp.eq(RS,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff0cf000, .op = 0x59001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memub(+)",
	},
	{
		// 010111000II00DDDEE01iiiissssdddd | RDD = combine(#0,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memub(+)",
	},
	{
		// 010111000II01DDDEE01iiiissssdddd | RDD = combine(#1,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c081000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memub(+)",
	},
	{
		// 010111000II10DDDEE01iiiissssdddd | RDD = combine(#2,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c101000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memub(+)",
	},
	{
		// 010111000II11DDDEE01iiiissssdddd | RDD = combine(#3,II) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff98f000, .op = 0x5c181000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memub(+)",
	},
	{
		// 01011101SSSS1DDDEE01iiiissssdddd | RDD = combine(RS,#0) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff08f000, .op = 0x5d081000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memub(+)",
	},
	{
		// 01011101SSSS0DDDEE01iiiissssdddd | RDD = combine(#0,RS) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff08f000, .op = 0x5d001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memub(+)",
	},
	{
		// 01010011SSSSDDDDEE01iiiissssdddd | RD = add(RS,n1) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x53001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memub(+)",
	},
	{
		// 01010001SSSSDDDDEE01iiiissssdddd | RD = add(RS,#1) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x51001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memub(+)",
	},
	{
		// 010010IIIIIIDDDDEE01iiiissssdddd | RD = II ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x48001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memub(+)",
	},
	{
		// 010110100000DDDDEE01iiiissssdddd | RD = n1 ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfff0f000, .op = 0x5a001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memub(+)",
	},
	{
		// 01010101SSSSDDDDEE01iiiissssdddd | RD = sxtb(RS) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x55001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memub(+)",
	},
	{
		// 01010100SSSSDDDDEE01iiiissssdddd | RD = sxth(RS) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x54001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memub(+)",
	},
	{
		// 01010000SSSSDDDDEE01iiiissssdddd | RD = RS ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x50001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memub(+)",
	},
	{
		// 01010111SSSSDDDDEE01iiiissssdddd | RD = and(RS,#255) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x57001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memub(+)",
	},
	{
		// 01010110SSSSDDDDEE01iiiissssdddd | RD = zxth(RS) ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xff00f000, .op = 0x56001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memub(+)",
	},
	{
		// 010010IIIIIIDDDDEE01iiiissssdddd | RD = II ; Rd = memub(Rs+Ii)
		.encoding = { .mask = 0xfc00f000, .op = 0x48001000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL1_LOADRUB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memub(+)",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x5[] = {
	{
		// 01000iiiiiiixxxxEE11111100000000 | Rx = add(Rxin,Ii) ; deallocframe
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; deallocframe",
	},
	{
		// 01011000ssssxxxxEE11111100000000 | Rx = add(Rxin,Rs) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; deallocframe",
	},
	{
		// 010011iiiiiiddddEE11111100000000 | Rd = add(r29,Ii) ; deallocframe
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; deallocframe",
	},
	{
		// 01010010ssssddddEE11111100000000 | Rd = and(Rs,#1) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; deallocframe",
	},
	{
		// 010110100111ddddEE11111100000000 | if (!p0) Rd = #0 ; deallocframe
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; deallocframe",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111100000000 | if (!p0.new) Rd = #0 ; deallocframe
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; deallocframe",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111100000000 | if (p0) Rd = #0 ; deallocframe
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; deallocframe",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111100000000 | if (p0.new) Rd = #0 ; deallocframe
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; deallocframe",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111100000000 | p0 = cmp.eq(Rs,Ii) ; deallocframe
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; deallocframe",
	},
	{
		// 010111000ii00dddEE11111100000000 | Rdd = combine(#0,Ii) ; deallocframe
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; deallocframe",
	},
	{
		// 010111000ii01dddEE11111100000000 | Rdd = combine(#1,Ii) ; deallocframe
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; deallocframe",
	},
	{
		// 010111000ii10dddEE11111100000000 | Rdd = combine(#2,Ii) ; deallocframe
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; deallocframe",
	},
	{
		// 010111000ii11dddEE11111100000000 | Rdd = combine(#3,Ii) ; deallocframe
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; deallocframe",
	},
	{
		// 01011101ssss1dddEE11111100000000 | Rdd = combine(Rs,#0) ; deallocframe
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; deallocframe",
	},
	{
		// 01011101ssss0dddEE11111100000000 | Rdd = combine(#0,Rs) ; deallocframe
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; deallocframe",
	},
	{
		// 01010011ssssddddEE11111100000000 | Rd = add(Rs,n1) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; deallocframe",
	},
	{
		// 01010001ssssddddEE11111100000000 | Rd = add(Rs,#1) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; deallocframe",
	},
	{
		// 010010iiiiiiddddEE11111100000000 | Rd = Ii ; deallocframe
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; deallocframe",
	},
	{
		// 010110100000ddddEE11111100000000 | Rd = n1 ; deallocframe
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; deallocframe",
	},
	{
		// 01010101ssssddddEE11111100000000 | Rd = sxtb(Rs) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; deallocframe",
	},
	{
		// 01010100ssssddddEE11111100000000 | Rd = sxth(Rs) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; deallocframe",
	},
	{
		// 01010000ssssddddEE11111100000000 | Rd = Rs ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; deallocframe",
	},
	{
		// 01010111ssssddddEE11111100000000 | Rd = and(Rs,#255) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; deallocframe",
	},
	{
		// 01010110ssssddddEE11111100000000 | Rd = zxth(Rs) ; deallocframe
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; deallocframe",
	},
	{
		// 010010iiiiiiddddEE11111100000000 | Rd = Ii ; deallocframe
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_DEALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; deallocframe",
	},
	{
		// 01000iiiiiiixxxxEE11111111000000 | Rx = add(Rxin,Ii) ; jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x40003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; jumpr R31",
	},
	{
		// 01011000ssssxxxxEE11111111000000 | Rx = add(Rxin,Rs) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x58003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; jumpr R31",
	},
	{
		// 010011iiiiiiddddEE11111111000000 | Rd = add(r29,Ii) ; jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(R29,) ; jumpr R31",
	},
	{
		// 01010010ssssddddEE11111111000000 | Rd = and(Rs,#1) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x52003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = and(,#1) ; jumpr R31",
	},
	{
		// 010110100111ddddEE11111111000000 | if (!p0) Rd = #0 ; jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111111000000 | if (!p0.new) Rd = #0 ; jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111111000000 | if (p0) Rd = #0 ; jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111111000000 | if (p0.new) Rd = #0 ; jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111111000000 | p0 = cmp.eq(Rs,Ii) ; jumpr r31
		.encoding = { .mask = 0xff0cffff, .op = 0x59003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "P0 = cmp.eq(,) ; jumpr R31",
	},
	{
		// 010111000ii00dddEE11111111000000 | Rdd = combine(#0,Ii) ; jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#0,) ; jumpr R31",
	},
	{
		// 010111000ii01dddEE11111111000000 | Rdd = combine(#1,Ii) ; jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#1,) ; jumpr R31",
	},
	{
		// 010111000ii10dddEE11111111000000 | Rdd = combine(#2,Ii) ; jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#2,) ; jumpr R31",
	},
	{
		// 010111000ii11dddEE11111111000000 | Rdd = combine(#3,Ii) ; jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#3,) ; jumpr R31",
	},
	{
		// 01011101ssss1dddEE11111111000000 | Rdd = combine(Rs,#0) ; jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(,#0) ; jumpr R31",
	},
	{
		// 01011101ssss0dddEE11111111000000 | Rdd = combine(#0,Rs) ; jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#0,) ; jumpr R31",
	},
	{
		// 01010011ssssddddEE11111111000000 | Rd = add(Rs,n1) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x53003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; jumpr R31",
	},
	{
		// 01010001ssssddddEE11111111000000 | Rd = add(Rs,#1) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x51003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,#1) ; jumpr R31",
	},
	{
		// 010010iiiiiiddddEE11111111000000 | Rd = Ii ; jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; jumpr R31",
	},
	{
		// 010110100000ddddEE11111111000000 | Rd = n1 ; jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; jumpr R31",
	},
	{
		// 01010101ssssddddEE11111111000000 | Rd = sxtb(Rs) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x55003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = sxtb() ; jumpr R31",
	},
	{
		// 01010100ssssddddEE11111111000000 | Rd = sxth(Rs) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x54003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = sxth() ; jumpr R31",
	},
	{
		// 01010000ssssddddEE11111111000000 | Rd = Rs ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x50003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; jumpr R31",
	},
	{
		// 01010111ssssddddEE11111111000000 | Rd = and(Rs,#255) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x57003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = and(,#255) ; jumpr R31",
	},
	{
		// 01010110ssssddddEE11111111000000 | Rd = zxth(Rs) ; jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x56003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = zxth() ; jumpr R31",
	},
	{
		// 010010iiiiiiddddEE11111111000000 | Rd = Ii ; jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc0 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_JUMPR31,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; jumpr R31",
	},
	{
		// 01000iiiiiiixxxxEE11111111000101 | Rx = add(Rxin,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x40003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111111000101 | Rx = add(Rxin,Rs) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x58003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111111000101 | Rd = add(r29,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111111000101 | Rd = and(Rs,#1) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x52003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111111000101 | if (!p0) Rd = #0 ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111111000101 | if (!p0.new) Rd = #0 ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111111000101 | if (p0) Rd = #0 ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111111000101 | if (p0.new) Rd = #0 ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111111000101 | p0 = cmp.eq(Rs,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff0cffff, .op = 0x59003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111111000101 | Rdd = combine(#0,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111111000101 | Rdd = combine(#1,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111111000101 | Rdd = combine(#2,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111111000101 | Rdd = combine(#3,Ii) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111111000101 | Rdd = combine(Rs,#0) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111111000101 | Rdd = combine(#0,Rs) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111111000101 | Rd = add(Rs,n1) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x53003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111111000101 | Rd = add(Rs,#1) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x51003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000101 | Rd = Ii ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111111000101 | Rd = n1 ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111111000101 | Rd = sxtb(Rs) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x55003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111111000101 | Rd = sxth(Rs) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x54003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111111000101 | Rd = Rs ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x50003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111111000101 | Rd = and(Rs,#255) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x57003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111111000101 | Rd = zxth(Rs) ; if (!p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x56003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000101 | Rd = Ii ; if (!p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc5 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_JUMPR31_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111111000111 | Rx = add(Rxin,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x40003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111111000111 | Rx = add(Rxin,Rs) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x58003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111111000111 | Rd = add(r29,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111111000111 | Rd = and(Rs,#1) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x52003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111111000111 | if (!p0) Rd = #0 ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111111000111 | if (!p0.new) Rd = #0 ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111111000111 | if (p0) Rd = #0 ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111111000111 | if (p0.new) Rd = #0 ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111111000111 | p0 = cmp.eq(Rs,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff0cffff, .op = 0x59003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111111000111 | Rdd = combine(#0,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111111000111 | Rdd = combine(#1,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111111000111 | Rdd = combine(#2,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111111000111 | Rdd = combine(#3,Ii) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111111000111 | Rdd = combine(Rs,#0) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111111000111 | Rdd = combine(#0,Rs) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111111000111 | Rd = add(Rs,n1) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x53003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111111000111 | Rd = add(Rs,#1) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x51003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000111 | Rd = Ii ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111111000111 | Rd = n1 ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111111000111 | Rd = sxtb(Rs) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x55003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111111000111 | Rd = sxth(Rs) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x54003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111111000111 | Rd = Rs ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x50003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111111000111 | Rd = and(Rs,#255) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x57003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111111000111 | Rd = zxth(Rs) ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x56003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000111 | Rd = Ii ; if (!p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc7 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_JUMPR31_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111111000100 | Rx = add(Rxin,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xf800ffff, .op = 0x40003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111111000100 | Rx = add(Rxin,Rs) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x58003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111111000100 | Rd = add(r29,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111111000100 | Rd = and(Rs,#1) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x52003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111111000100 | if (!p0) Rd = #0 ; if (p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111111000100 | if (!p0.new) Rd = #0 ; if (p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111111000100 | if (p0) Rd = #0 ; if (p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111111000100 | if (p0.new) Rd = #0 ; if (p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111111000100 | p0 = cmp.eq(Rs,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff0cffff, .op = 0x59003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111111000100 | Rdd = combine(#0,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111111000100 | Rdd = combine(#1,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111111000100 | Rdd = combine(#2,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111111000100 | Rdd = combine(#3,Ii) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111111000100 | Rdd = combine(Rs,#0) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111111000100 | Rdd = combine(#0,Rs) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111111000100 | Rd = add(Rs,n1) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x53003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111111000100 | Rd = add(Rs,#1) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x51003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000100 | Rd = Ii ; if (p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111111000100 | Rd = n1 ; if (p0) jumpr r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111111000100 | Rd = sxtb(Rs) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x55003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111111000100 | Rd = sxth(Rs) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x54003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111111000100 | Rd = Rs ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x50003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111111000100 | Rd = and(Rs,#255) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x57003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111111000100 | Rd = zxth(Rs) ; if (p0) jumpr r31
		.encoding = { .mask = 0xff00ffff, .op = 0x56003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000100 | Rd = Ii ; if (p0) jumpr r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc4 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_JUMPR31_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) jumpr R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111111000110 | Rx = add(Rxin,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xf800ffff, .op = 0x40003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111111000110 | Rx = add(Rxin,Rs) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x58003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111111000110 | Rd = add(r29,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111111000110 | Rd = and(Rs,#1) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x52003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111111000110 | if (!p0) Rd = #0 ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111111000110 | if (!p0.new) Rd = #0 ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111111000110 | if (p0) Rd = #0 ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111111000110 | if (p0.new) Rd = #0 ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111111000110 | p0 = cmp.eq(Rs,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff0cffff, .op = 0x59003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111111000110 | Rdd = combine(#0,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111111000110 | Rdd = combine(#1,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111111000110 | Rdd = combine(#2,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111111000110 | Rdd = combine(#3,Ii) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111111000110 | Rdd = combine(Rs,#0) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111111000110 | Rdd = combine(#0,Rs) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111111000110 | Rd = add(Rs,n1) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x53003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111111000110 | Rd = add(Rs,#1) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x51003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000110 | Rd = Ii ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111111000110 | Rd = n1 ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111111000110 | Rd = sxtb(Rs) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x55003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111111000110 | Rd = sxth(Rs) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x54003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111111000110 | Rd = Rs ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x50003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111111000110 | Rd = and(Rs,#255) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x57003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111111000110 | Rd = zxth(Rs) ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xff00ffff, .op = 0x56003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111111000110 | Rd = Ii ; if (p0.new) jumpr:nt r31
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003fc6 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_JUMPR31_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) jumpr:nt R31",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000IIIIIIIxxxxEE110iiissssdddd | Rx = add(Rxin,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x40003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memb(+)",
	},
	{
		// 01011000SSSSxxxxEE110iiissssdddd | Rx = add(Rxin,RS) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x58003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memb(+)",
	},
	{
		// 010011IIIIIIDDDDEE110iiissssdddd | RD = add(r29,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x4c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memb(+)",
	},
	{
		// 01010010SSSSDDDDEE110iiissssdddd | RD = and(RS,#1) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x52003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memb(+)",
	},
	{
		// 010110100111DDDDEE110iiissssdddd | if (!p0) RD = #0 ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a703000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 26 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE110iiissssdddd | if (!p0.new) RD = #0 ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a503000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE110iiissssdddd | if (p0) RD = #0 ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a603000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 25 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE110iiissssdddd | if (p0.new) RD = #0 ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a403000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memb(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001SSSS00IIEE110iiissssdddd | p0 = cmp.eq(RS,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff0cf800, .op = 0x59003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memb(+)",
	},
	{
		// 010111000II00DDDEE110iiissssdddd | RDD = combine(#0,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memb(+)",
	},
	{
		// 010111000II01DDDEE110iiissssdddd | RDD = combine(#1,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c083000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memb(+)",
	},
	{
		// 010111000II10DDDEE110iiissssdddd | RDD = combine(#2,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c103000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memb(+)",
	},
	{
		// 010111000II11DDDEE110iiissssdddd | RDD = combine(#3,II) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c183000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memb(+)",
	},
	{
		// 01011101SSSS1DDDEE110iiissssdddd | RDD = combine(RS,#0) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d083000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memb(+)",
	},
	{
		// 01011101SSSS0DDDEE110iiissssdddd | RDD = combine(#0,RS) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memb(+)",
	},
	{
		// 01010011SSSSDDDDEE110iiissssdddd | RD = add(RS,n1) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x53003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memb(+)",
	},
	{
		// 01010001SSSSDDDDEE110iiissssdddd | RD = add(RS,#1) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x51003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memb(+)",
	},
	{
		// 010010IIIIIIDDDDEE110iiissssdddd | RD = II ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memb(+)",
	},
	{
		// 010110100000DDDDEE110iiissssdddd | RD = n1 ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memb(+)",
	},
	{
		// 01010101SSSSDDDDEE110iiissssdddd | RD = sxtb(RS) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x55003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memb(+)",
	},
	{
		// 01010100SSSSDDDDEE110iiissssdddd | RD = sxth(RS) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x54003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memb(+)",
	},
	{
		// 01010000SSSSDDDDEE110iiissssdddd | RD = RS ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x50003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memb(+)",
	},
	{
		// 01010111SSSSDDDDEE110iiissssdddd | RD = and(RS,#255) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x57003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memb(+)",
	},
	{
		// 01010110SSSSDDDDEE110iiissssdddd | RD = zxth(RS) ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x56003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memb(+)",
	},
	{
		// 010010IIIIIIDDDDEE110iiissssdddd | RD = II ; Rd = memb(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48003000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_LOADRB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memb(+)",
	},
	{
		// 01000IIIIIIIxxxxEE111110iiiiiddd | Rx = add(Rxin,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xf800ff00, .op = 0x40003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memd(R29+)",
	},
	{
		// 01011000ssssxxxxEE111110iiiiiddd | Rx = add(Rxin,Rs) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x58003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memd(R29+)",
	},
	{
		// 010011IIIIIIDDDDEE111110iiiiiddd | RD = add(r29,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfc00ff00, .op = 0x4c003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memd(R29+)",
	},
	{
		// 01010010ssssDDDDEE111110iiiiiddd | RD = and(Rs,#1) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x52003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memd(R29+)",
	},
	{
		// 010110100111DDDDEE111110iiiiiddd | if (!p0) RD = #0 ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfff0ff00, .op = 0x5a703e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memd(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE111110iiiiiddd | if (!p0.new) RD = #0 ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfff0ff00, .op = 0x5a503e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 33 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memd(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE111110iiiiiddd | if (p0) RD = #0 ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfff0ff00, .op = 0x5a603e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memd(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE111110iiiiiddd | if (p0.new) RD = #0 ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfff0ff00, .op = 0x5a403e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 32 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memd(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00IIEE111110iiiiiddd | p0 = cmp.eq(Rs,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff0cff00, .op = 0x59003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memd(R29+)",
	},
	{
		// 010111000II00DDDEE111110iiiiiddd | RDD = combine(#0,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff98ff00, .op = 0x5c003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memd(R29+)",
	},
	{
		// 010111000II01DDDEE111110iiiiiddd | RDD = combine(#1,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff98ff00, .op = 0x5c083e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memd(R29+)",
	},
	{
		// 010111000II10DDDEE111110iiiiiddd | RDD = combine(#2,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff98ff00, .op = 0x5c103e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memd(R29+)",
	},
	{
		// 010111000II11DDDEE111110iiiiiddd | RDD = combine(#3,II) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff98ff00, .op = 0x5c183e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memd(R29+)",
	},
	{
		// 01011101ssss1DDDEE111110iiiiiddd | RDD = combine(Rs,#0) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff08ff00, .op = 0x5d083e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memd(R29+)",
	},
	{
		// 01011101ssss0DDDEE111110iiiiiddd | RDD = combine(#0,Rs) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff08ff00, .op = 0x5d003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memd(R29+)",
	},
	{
		// 01010011ssssDDDDEE111110iiiiiddd | RD = add(Rs,n1) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x53003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memd(R29+)",
	},
	{
		// 01010001ssssDDDDEE111110iiiiiddd | RD = add(Rs,#1) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x51003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memd(R29+)",
	},
	{
		// 010010IIIIIIDDDDEE111110iiiiiddd | RD = II ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfc00ff00, .op = 0x48003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memd(R29+)",
	},
	{
		// 010110100000DDDDEE111110iiiiiddd | RD = n1 ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfff0ff00, .op = 0x5a003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memd(R29+)",
	},
	{
		// 01010101ssssDDDDEE111110iiiiiddd | RD = sxtb(Rs) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x55003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memd(R29+)",
	},
	{
		// 01010100ssssDDDDEE111110iiiiiddd | RD = sxth(Rs) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x54003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memd(R29+)",
	},
	{
		// 01010000ssssDDDDEE111110iiiiiddd | RD = Rs ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x50003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memd(R29+)",
	},
	{
		// 01010111ssssDDDDEE111110iiiiiddd | RD = and(Rs,#255) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x57003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memd(R29+)",
	},
	{
		// 01010110ssssDDDDEE111110iiiiiddd | RD = zxth(Rs) ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xff00ff00, .op = 0x56003e00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memd(R29+)",
	},
	{
		// 010010IIIIIIDDDDEE111110iiiiiddd | RD = II ; Rdd = memd(r29+Ii)
		.encoding = { .mask = 0xfc00ff00, .op = 0x48003e00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_LOADRD_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 3 } }, .imm_scale = 3, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memd(R29+)",
	},
	{
		// 01000IIIIIIIxxxxEE100iiissssdddd | Rx = add(Rxin,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x40002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memh(+)",
	},
	{
		// 01011000SSSSxxxxEE100iiissssdddd | Rx = add(Rxin,RS) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x58002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memh(+)",
	},
	{
		// 010011IIIIIIDDDDEE100iiissssdddd | RD = add(r29,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x4c002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memh(+)",
	},
	{
		// 01010010SSSSDDDDEE100iiissssdddd | RD = and(RS,#1) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x52002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memh(+)",
	},
	{
		// 010110100111DDDDEE100iiissssdddd | if (!p0) RD = #0 ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a702000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 26 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE100iiissssdddd | if (!p0.new) RD = #0 ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a502000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE100iiissssdddd | if (p0) RD = #0 ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a602000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 25 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE100iiissssdddd | if (p0.new) RD = #0 ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a402000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001SSSS00IIEE100iiissssdddd | p0 = cmp.eq(RS,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff0cf800, .op = 0x59002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memh(+)",
	},
	{
		// 010111000II00DDDEE100iiissssdddd | RDD = combine(#0,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memh(+)",
	},
	{
		// 010111000II01DDDEE100iiissssdddd | RDD = combine(#1,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c082000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memh(+)",
	},
	{
		// 010111000II10DDDEE100iiissssdddd | RDD = combine(#2,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c102000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memh(+)",
	},
	{
		// 010111000II11DDDEE100iiissssdddd | RDD = combine(#3,II) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c182000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memh(+)",
	},
	{
		// 01011101SSSS1DDDEE100iiissssdddd | RDD = combine(RS,#0) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d082000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memh(+)",
	},
	{
		// 01011101SSSS0DDDEE100iiissssdddd | RDD = combine(#0,RS) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memh(+)",
	},
	{
		// 01010011SSSSDDDDEE100iiissssdddd | RD = add(RS,n1) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x53002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memh(+)",
	},
	{
		// 01010001SSSSDDDDEE100iiissssdddd | RD = add(RS,#1) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x51002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memh(+)",
	},
	{
		// 010010IIIIIIDDDDEE100iiissssdddd | RD = II ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memh(+)",
	},
	{
		// 010110100000DDDDEE100iiissssdddd | RD = n1 ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memh(+)",
	},
	{
		// 01010101SSSSDDDDEE100iiissssdddd | RD = sxtb(RS) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x55002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memh(+)",
	},
	{
		// 01010100SSSSDDDDEE100iiissssdddd | RD = sxth(RS) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x54002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memh(+)",
	},
	{
		// 01010000SSSSDDDDEE100iiissssdddd | RD = RS ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x50002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memh(+)",
	},
	{
		// 01010111SSSSDDDDEE100iiissssdddd | RD = and(RS,#255) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x57002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memh(+)",
	},
	{
		// 01010110SSSSDDDDEE100iiissssdddd | RD = zxth(RS) ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x56002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memh(+)",
	},
	{
		// 010010IIIIIIDDDDEE100iiissssdddd | RD = II ; Rd = memh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48002000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_LOADRH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 15 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memh(+)",
	},
	{
		// 01000IIIIIIIxxxxEE11110iiiiidddd | Rx = add(Rxin,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xf800fe00, .op = 0x40003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(R29+)",
	},
	{
		// 01011000ssssxxxxEE11110iiiiidddd | Rx = add(Rxin,Rs) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x58003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(R29+)",
	},
	{
		// 010011IIIIIIDDDDEE11110iiiiidddd | RD = add(r29,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfc00fe00, .op = 0x4c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memw(R29+)",
	},
	{
		// 01010010ssssDDDDEE11110iiiiidddd | RD = and(Rs,#1) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x52003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memw(R29+)",
	},
	{
		// 010110100111DDDDEE11110iiiiidddd | if (!p0) RD = #0 ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfff0fe00, .op = 0x5a703c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memw(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE11110iiiiidddd | if (!p0.new) RD = #0 ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfff0fe00, .op = 0x5a503c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 33 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memw(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE11110iiiiidddd | if (p0) RD = #0 ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfff0fe00, .op = 0x5a603c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memw(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE11110iiiiidddd | if (p0.new) RD = #0 ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfff0fe00, .op = 0x5a403c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 32 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memw(R29+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00IIEE11110iiiiidddd | p0 = cmp.eq(Rs,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff0cfe00, .op = 0x59003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memw(R29+)",
	},
	{
		// 010111000II00DDDEE11110iiiiidddd | RDD = combine(#0,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff98fe00, .op = 0x5c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memw(R29+)",
	},
	{
		// 010111000II01DDDEE11110iiiiidddd | RDD = combine(#1,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff98fe00, .op = 0x5c083c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memw(R29+)",
	},
	{
		// 010111000II10DDDEE11110iiiiidddd | RDD = combine(#2,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff98fe00, .op = 0x5c103c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memw(R29+)",
	},
	{
		// 010111000II11DDDEE11110iiiiidddd | RDD = combine(#3,II) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff98fe00, .op = 0x5c183c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memw(R29+)",
	},
	{
		// 01011101ssss1DDDEE11110iiiiidddd | RDD = combine(Rs,#0) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff08fe00, .op = 0x5d083c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memw(R29+)",
	},
	{
		// 01011101ssss0DDDEE11110iiiiidddd | RDD = combine(#0,Rs) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff08fe00, .op = 0x5d003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memw(R29+)",
	},
	{
		// 01010011ssssDDDDEE11110iiiiidddd | RD = add(Rs,n1) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x53003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memw(R29+)",
	},
	{
		// 01010001ssssDDDDEE11110iiiiidddd | RD = add(Rs,#1) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x51003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memw(R29+)",
	},
	{
		// 010010IIIIIIDDDDEE11110iiiiidddd | RD = II ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfc00fe00, .op = 0x48003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(R29+)",
	},
	{
		// 010110100000DDDDEE11110iiiiidddd | RD = n1 ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfff0fe00, .op = 0x5a003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(R29+)",
	},
	{
		// 01010101ssssDDDDEE11110iiiiidddd | RD = sxtb(Rs) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x55003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memw(R29+)",
	},
	{
		// 01010100ssssDDDDEE11110iiiiidddd | RD = sxth(Rs) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x54003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memw(R29+)",
	},
	{
		// 01010000ssssDDDDEE11110iiiiidddd | RD = Rs ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x50003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(R29+)",
	},
	{
		// 01010111ssssDDDDEE11110iiiiidddd | RD = and(Rs,#255) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x57003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memw(R29+)",
	},
	{
		// 01010110ssssDDDDEE11110iiiiidddd | RD = zxth(Rs) ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xff00fe00, .op = 0x56003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memw(R29+)",
	},
	{
		// 010010IIIIIIDDDDEE11110iiiiidddd | RD = II ; Rd = memw(r29+Ii)
		.encoding = { .mask = 0xfc00fe00, .op = 0x48003c00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_LOADRI_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memw(R29+)",
	},
	{
		// 01000IIIIIIIxxxxEE101iiissssdddd | Rx = add(Rxin,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xf800f800, .op = 0x40002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memuh(+)",
	},
	{
		// 01011000SSSSxxxxEE101iiissssdddd | Rx = add(Rxin,RS) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x58002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memuh(+)",
	},
	{
		// 010011IIIIIIDDDDEE101iiissssdddd | RD = add(r29,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x4c002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ;  = memuh(+)",
	},
	{
		// 01010010SSSSDDDDEE101iiissssdddd | RD = and(RS,#1) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x52002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ;  = memuh(+)",
	},
	{
		// 010110100111DDDDEE101iiissssdddd | if (!p0) RD = #0 ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a702800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ;  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101DDDDEE101iiissssdddd | if (!p0.new) RD = #0 ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a502800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ;  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110DDDDEE101iiissssdddd | if (p0) RD = #0 ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a602800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ;  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100DDDDEE101iiissssdddd | if (p0.new) RD = #0 ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a402800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ;  = memuh(+)",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001SSSS00IIEE101iiissssdddd | p0 = cmp.eq(RS,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff0cf800, .op = 0x59002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ;  = memuh(+)",
	},
	{
		// 010111000II00DDDEE101iiissssdddd | RDD = combine(#0,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memuh(+)",
	},
	{
		// 010111000II01DDDEE101iiissssdddd | RDD = combine(#1,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c082800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ;  = memuh(+)",
	},
	{
		// 010111000II10DDDEE101iiissssdddd | RDD = combine(#2,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c102800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ;  = memuh(+)",
	},
	{
		// 010111000II11DDDEE101iiissssdddd | RDD = combine(#3,II) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff98f800, .op = 0x5c182800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ;  = memuh(+)",
	},
	{
		// 01011101SSSS1DDDEE101iiissssdddd | RDD = combine(RS,#0) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d082800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ;  = memuh(+)",
	},
	{
		// 01011101SSSS0DDDEE101iiissssdddd | RDD = combine(#0,RS) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff08f800, .op = 0x5d002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ;  = memuh(+)",
	},
	{
		// 01010011SSSSDDDDEE101iiissssdddd | RD = add(RS,n1) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x53002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ;  = memuh(+)",
	},
	{
		// 01010001SSSSDDDDEE101iiissssdddd | RD = add(RS,#1) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x51002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ;  = memuh(+)",
	},
	{
		// 010010IIIIIIDDDDEE101iiissssdddd | RD = II ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memuh(+)",
	},
	{
		// 010110100000DDDDEE101iiissssdddd | RD = n1 ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfff0f800, .op = 0x5a002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memuh(+)",
	},
	{
		// 01010101SSSSDDDDEE101iiissssdddd | RD = sxtb(RS) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x55002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ;  = memuh(+)",
	},
	{
		// 01010100SSSSDDDDEE101iiissssdddd | RD = sxth(RS) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x54002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ;  = memuh(+)",
	},
	{
		// 01010000SSSSDDDDEE101iiissssdddd | RD = RS ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x50002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memuh(+)",
	},
	{
		// 01010111SSSSDDDDEE101iiissssdddd | RD = and(RS,#255) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x57002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ;  = memuh(+)",
	},
	{
		// 01010110SSSSDDDDEE101iiissssdddd | RD = zxth(RS) ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xff00f800, .op = 0x56002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ;  = memuh(+)",
	},
	{
		// 010010IIIIIIDDDDEE101iiissssdddd | RD = II ; Rd = memuh(Rs+Ii)
		.encoding = { .mask = 0xfc00f800, .op = 0x48002800 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_LOADRUH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 6 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ;  = memuh(+)",
	},
	{
		// 01000iiiiiiixxxxEE11111101000000 | Rx = add(Rxin,Ii) ; dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; dealloc_return",
	},
	{
		// 01011000ssssxxxxEE11111101000000 | Rx = add(Rxin,Rs) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; dealloc_return",
	},
	{
		// 010011iiiiiiddddEE11111101000000 | Rd = add(r29,Ii) ; dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(R29,) ; dealloc_return",
	},
	{
		// 01010010ssssddddEE11111101000000 | Rd = and(Rs,#1) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = and(,#1) ; dealloc_return",
	},
	{
		// 010110100111ddddEE11111101000000 | if (!p0) Rd = #0 ; dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111101000000 | if (!p0.new) Rd = #0 ; dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111101000000 | if (p0) Rd = #0 ; dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111101000000 | if (p0.new) Rd = #0 ; dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111101000000 | p0 = cmp.eq(Rs,Ii) ; dealloc_return
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "P0 = cmp.eq(,) ; dealloc_return",
	},
	{
		// 010111000ii00dddEE11111101000000 | Rdd = combine(#0,Ii) ; dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#0,) ; dealloc_return",
	},
	{
		// 010111000ii01dddEE11111101000000 | Rdd = combine(#1,Ii) ; dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#1,) ; dealloc_return",
	},
	{
		// 010111000ii10dddEE11111101000000 | Rdd = combine(#2,Ii) ; dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#2,) ; dealloc_return",
	},
	{
		// 010111000ii11dddEE11111101000000 | Rdd = combine(#3,Ii) ; dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#3,) ; dealloc_return",
	},
	{
		// 01011101ssss1dddEE11111101000000 | Rdd = combine(Rs,#0) ; dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(,#0) ; dealloc_return",
	},
	{
		// 01011101ssss0dddEE11111101000000 | Rdd = combine(#0,Rs) ; dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = combine(#0,) ; dealloc_return",
	},
	{
		// 01010011ssssddddEE11111101000000 | Rd = add(Rs,n1) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,) ; dealloc_return",
	},
	{
		// 01010001ssssddddEE11111101000000 | Rd = add(Rs,#1) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = add(,#1) ; dealloc_return",
	},
	{
		// 010010iiiiiiddddEE11111101000000 | Rd = Ii ; dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; dealloc_return",
	},
	{
		// 010110100000ddddEE11111101000000 | Rd = n1 ; dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; dealloc_return",
	},
	{
		// 01010101ssssddddEE11111101000000 | Rd = sxtb(Rs) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = sxtb() ; dealloc_return",
	},
	{
		// 01010100ssssddddEE11111101000000 | Rd = sxth(Rs) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = sxth() ; dealloc_return",
	},
	{
		// 01010000ssssddddEE11111101000000 | Rd = Rs ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; dealloc_return",
	},
	{
		// 01010111ssssddddEE11111101000000 | Rd = and(Rs,#255) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = and(,#255) ; dealloc_return",
	},
	{
		// 01010110ssssddddEE11111101000000 | Rd = zxth(Rs) ; dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f40 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " = zxth() ; dealloc_return",
	},
	{
		// 010010iiiiiiddddEE11111101000000 | Rd = Ii ; dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f40 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_RETURN,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = " =  ; dealloc_return",
	},
	{
		// 01000iiiiiiixxxxEE11111101000101 | Rx = add(Rxin,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111101000101 | Rx = add(Rxin,Rs) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111101000101 | Rd = add(r29,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111101000101 | Rd = and(Rs,#1) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111101000101 | if (!p0) Rd = #0 ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111101000101 | if (!p0.new) Rd = #0 ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111101000101 | if (p0) Rd = #0 ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111101000101 | if (p0.new) Rd = #0 ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111101000101 | p0 = cmp.eq(Rs,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111101000101 | Rdd = combine(#0,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111101000101 | Rdd = combine(#1,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111101000101 | Rdd = combine(#2,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111101000101 | Rdd = combine(#3,Ii) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111101000101 | Rdd = combine(Rs,#0) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111101000101 | Rdd = combine(#0,Rs) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111101000101 | Rd = add(Rs,n1) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111101000101 | Rd = add(Rs,#1) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000101 | Rd = Ii ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111101000101 | Rd = n1 ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111101000101 | Rd = sxtb(Rs) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111101000101 | Rd = sxth(Rs) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111101000101 | Rd = Rs ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111101000101 | Rd = and(Rs,#255) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111101000101 | Rd = zxth(Rs) ; if (!p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f45 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000101 | Rd = Ii ; if (!p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f45 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_RETURN_F,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111101000111 | Rx = add(Rxin,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111101000111 | Rx = add(Rxin,Rs) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111101000111 | Rd = add(r29,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111101000111 | Rd = and(Rs,#1) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111101000111 | if (!p0) Rd = #0 ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111101000111 | if (!p0.new) Rd = #0 ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111101000111 | if (p0) Rd = #0 ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111101000111 | if (p0.new) Rd = #0 ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111101000111 | p0 = cmp.eq(Rs,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111101000111 | Rdd = combine(#0,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111101000111 | Rdd = combine(#1,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111101000111 | Rdd = combine(#2,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111101000111 | Rdd = combine(#3,Ii) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111101000111 | Rdd = combine(Rs,#0) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111101000111 | Rdd = combine(#0,Rs) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111101000111 | Rd = add(Rs,n1) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111101000111 | Rd = add(Rs,#1) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000111 | Rd = Ii ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111101000111 | Rd = n1 ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111101000111 | Rd = sxtb(Rs) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111101000111 | Rd = sxth(Rs) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111101000111 | Rd = Rs ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111101000111 | Rd = and(Rs,#255) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111101000111 | Rd = zxth(Rs) ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f47 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000111 | Rd = Ii ; if (!p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f47 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_RETURN_FNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (!P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111101000100 | Rx = add(Rxin,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111101000100 | Rx = add(Rxin,Rs) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111101000100 | Rd = add(r29,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111101000100 | Rd = and(Rs,#1) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111101000100 | if (!p0) Rd = #0 ; if (p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111101000100 | if (!p0.new) Rd = #0 ; if (p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111101000100 | if (p0) Rd = #0 ; if (p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111101000100 | if (p0.new) Rd = #0 ; if (p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111101000100 | p0 = cmp.eq(Rs,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111101000100 | Rdd = combine(#0,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111101000100 | Rdd = combine(#1,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111101000100 | Rdd = combine(#2,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111101000100 | Rdd = combine(#3,Ii) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111101000100 | Rdd = combine(Rs,#0) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111101000100 | Rdd = combine(#0,Rs) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111101000100 | Rd = add(Rs,n1) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111101000100 | Rd = add(Rs,#1) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000100 | Rd = Ii ; if (p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111101000100 | Rd = n1 ; if (p0) dealloc_return
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111101000100 | Rd = sxtb(Rs) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111101000100 | Rd = sxth(Rs) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111101000100 | Rd = Rs ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111101000100 | Rd = and(Rs,#255) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111101000100 | Rd = zxth(Rs) ; if (p0) dealloc_return
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f44 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000100 | Rd = Ii ; if (p0) dealloc_return
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f44 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_RETURN_T,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0) dealloc_return",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01000iiiiiiixxxxEE11111101000110 | Rx = add(Rxin,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xf800ffff, .op = 0x40003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011000ssssxxxxEE11111101000110 | Rx = add(Rxin,Rs) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x58003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010011iiiiiiddddEE11111101000110 | Rd = add(r29,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x4c003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(R29,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010010ssssddddEE11111101000110 | Rd = and(Rs,#1) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x52003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#1) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100111ddddEE11111101000110 | if (!p0) Rd = #0 ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a703f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0)  = #0 ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100101ddddEE11111101000110 | if (!p0.new) Rd = #0 ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a503f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new)  = #0 ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100110ddddEE11111101000110 | if (p0) Rd = #0 ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a603f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0)  = #0 ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100100ddddEE11111101000110 | if (p0.new) Rd = #0 ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a403f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new)  = #0 ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011001ssss00iiEE11111101000110 | p0 = cmp.eq(Rs,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff0cffff, .op = 0x59003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 16 } }, .syntax = 13 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "P0 = cmp.eq(,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii00dddEE11111101000110 | Rdd = combine(#0,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii01dddEE11111101000110 | Rdd = combine(#1,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c083f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#1,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii10dddEE11111101000110 | Rdd = combine(#2,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c103f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#2,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010111000ii11dddEE11111101000110 | Rdd = combine(#3,Ii) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff98ffff, .op = 0x5c183f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x2, 21 } }, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#3,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss1dddEE11111101000110 | Rdd = combine(Rs,#0) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff08ffff, .op = 0x5d083f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(,#0) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01011101ssss0dddEE11111101000110 | Rdd = combine(#0,Rs) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff08ffff, .op = 0x5d003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = combine(#0,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010011ssssddddEE11111101000110 | Rd = add(Rs,n1) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x53003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010001ssssddddEE11111101000110 | Rd = add(Rs,#1) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x51003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = add(,#1) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000110 | Rd = Ii ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010110100000ddddEE11111101000110 | Rd = n1 ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfff0ffff, .op = 0x5a003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010101ssssddddEE11111101000110 | Rd = sxtb(Rs) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x55003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxtb() ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010100ssssddddEE11111101000110 | Rd = sxth(Rs) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x54003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = sxth() ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010000ssssddddEE11111101000110 | Rd = Rs ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x50003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010111ssssddddEE11111101000110 | Rd = and(Rs,#255) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x57003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = and(,#255) ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01010110ssssddddEE11111101000110 | Rd = zxth(Rs) ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xff00ffff, .op = 0x56003f46 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " = zxth() ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 010010iiiiiiddddEE11111101000110 | Rd = Ii ; if (p0.new) dealloc_return:nt
		.encoding = { .mask = 0xfc00ffff, .op = 0x48003f46 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SL2_RETURN_TNEW,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 20 } }, .syntax = 3 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = " =  ; if (P0.new) dealloc_return:nt",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x6[] = {
	{
		// 01100IIIIIIIxxxxEE01iiiisssstttt | Rx = add(Rxin,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x60001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = ",
	},
	{
		// 01111000SSSSxxxxEE01iiiisssstttt | Rx = add(Rxin,RS) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x78001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = ",
	},
	{
		// 011011IIIIIIddddEE01iiiisssstttt | Rd = add(r29,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x6c001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memb(+) = ",
	},
	{
		// 01110010SSSSddddEE01iiiisssstttt | Rd = and(RS,#1) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x72001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memb(+) = ",
	},
	{
		// 011110100111ddddEE01iiiisssstttt | if (!p0) Rd = #0 ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a701000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE01iiiisssstttt | if (!p0.new) Rd = #0 ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a501000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE01iiiisssstttt | if (p0) Rd = #0 ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a601000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE01iiiisssstttt | if (p0.new) Rd = #0 ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a401000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE01iiiisssstttt | p0 = cmp.eq(RS,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff0cf000, .op = 0x79001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memb(+) = ",
	},
	{
		// 011111000II00dddEE01iiiisssstttt | Rdd = combine(#0,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = ",
	},
	{
		// 011111000II01dddEE01iiiisssstttt | Rdd = combine(#1,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c081000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memb(+) = ",
	},
	{
		// 011111000II10dddEE01iiiisssstttt | Rdd = combine(#2,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c101000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memb(+) = ",
	},
	{
		// 011111000II11dddEE01iiiisssstttt | Rdd = combine(#3,II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c181000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memb(+) = ",
	},
	{
		// 01111101SSSS1dddEE01iiiisssstttt | Rdd = combine(RS,#0) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f000, .op = 0x7d081000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memb(+) = ",
	},
	{
		// 01111101SSSS0dddEE01iiiisssstttt | Rdd = combine(#0,RS) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f000, .op = 0x7d001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = ",
	},
	{
		// 01110011SSSSddddEE01iiiisssstttt | Rd = add(RS,n1) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x73001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = ",
	},
	{
		// 01110001SSSSddddEE01iiiisssstttt | Rd = add(RS,#1) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x71001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memb(+) = ",
	},
	{
		// 011010IIIIIIddddEE01iiiisssstttt | Rd = II ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x68001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = ",
	},
	{
		// 011110100000ddddEE01iiiisssstttt | Rd = n1 ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = ",
	},
	{
		// 01110101SSSSddddEE01iiiisssstttt | Rd = sxtb(RS) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x75001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memb(+) = ",
	},
	{
		// 01110100SSSSddddEE01iiiisssstttt | Rd = sxth(RS) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x74001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memb(+) = ",
	},
	{
		// 01110000SSSSddddEE01iiiisssstttt | Rd = RS ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x70001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = ",
	},
	{
		// 01110111SSSSddddEE01iiiisssstttt | Rd = and(RS,#255) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x77001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memb(+) = ",
	},
	{
		// 01110110SSSSddddEE01iiiisssstttt | Rd = zxth(RS) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x76001000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memb(+) = ",
	},
	{
		// 011010IIIIIIddddEE01iiiisssstttt | Rd = II ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x68001000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = ",
	},
	{
		// 01100IIIIIIIxxxxEE00iiiisssstttt | Rx = add(Rxin,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x60000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = ",
	},
	{
		// 01111000SSSSxxxxEE00iiiisssstttt | Rx = add(Rxin,RS) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x78000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = ",
	},
	{
		// 011011IIIIIIddddEE00iiiisssstttt | Rd = add(r29,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x6c000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memw(+) = ",
	},
	{
		// 01110010SSSSddddEE00iiiisssstttt | Rd = and(RS,#1) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x72000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memw(+) = ",
	},
	{
		// 011110100111ddddEE00iiiisssstttt | if (!p0) Rd = #0 ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a700000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE00iiiisssstttt | if (!p0.new) Rd = #0 ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a500000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE00iiiisssstttt | if (p0) Rd = #0 ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a600000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE00iiiisssstttt | if (p0.new) Rd = #0 ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a400000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memw(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE00iiiisssstttt | p0 = cmp.eq(RS,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff0cf000, .op = 0x79000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memw(+) = ",
	},
	{
		// 011111000II00dddEE00iiiisssstttt | Rdd = combine(#0,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = ",
	},
	{
		// 011111000II01dddEE00iiiisssstttt | Rdd = combine(#1,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c080000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memw(+) = ",
	},
	{
		// 011111000II10dddEE00iiiisssstttt | Rdd = combine(#2,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c100000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memw(+) = ",
	},
	{
		// 011111000II11dddEE00iiiisssstttt | Rdd = combine(#3,II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f000, .op = 0x7c180000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memw(+) = ",
	},
	{
		// 01111101SSSS1dddEE00iiiisssstttt | Rdd = combine(RS,#0) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f000, .op = 0x7d080000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memw(+) = ",
	},
	{
		// 01111101SSSS0dddEE00iiiisssstttt | Rdd = combine(#0,RS) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f000, .op = 0x7d000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = ",
	},
	{
		// 01110011SSSSddddEE00iiiisssstttt | Rd = add(RS,n1) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x73000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = ",
	},
	{
		// 01110001SSSSddddEE00iiiisssstttt | Rd = add(RS,#1) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x71000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memw(+) = ",
	},
	{
		// 011010IIIIIIddddEE00iiiisssstttt | Rd = II ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x68000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = ",
	},
	{
		// 011110100000ddddEE00iiiisssstttt | Rd = n1 ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f000, .op = 0x7a000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = ",
	},
	{
		// 01110101SSSSddddEE00iiiisssstttt | Rd = sxtb(RS) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x75000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memw(+) = ",
	},
	{
		// 01110100SSSSddddEE00iiiisssstttt | Rd = sxth(RS) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x74000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memw(+) = ",
	},
	{
		// 01110000SSSSddddEE00iiiisssstttt | Rd = RS ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x70000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = ",
	},
	{
		// 01110111SSSSddddEE00iiiisssstttt | Rd = and(RS,#255) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x77000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memw(+) = ",
	},
	{
		// 01110110SSSSddddEE00iiiisssstttt | Rd = zxth(RS) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x76000000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memw(+) = ",
	},
	{
		// 011010IIIIIIddddEE00iiiisssstttt | Rd = II ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f000, .op = 0x68000000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = ",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x7[] = {
	{
		// 01100IIIIIIIxxxxEE11110iiiii0000 | Rx = add(Rxin,II) ; allocframe(Ii)
		.encoding = { .mask = 0xf800fe0f, .op = 0x60003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; allocframe()",
	},
	{
		// 01111000ssssxxxxEE11110iiiii0000 | Rx = add(Rxin,Rs) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x78003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; allocframe()",
	},
	{
		// 011011IIIIIIddddEE11110iiiii0000 | Rd = add(r29,II) ; allocframe(Ii)
		.encoding = { .mask = 0xfc00fe0f, .op = 0x6c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; allocframe()",
	},
	{
		// 01110010ssssddddEE11110iiiii0000 | Rd = and(Rs,#1) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x72003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; allocframe()",
	},
	{
		// 011110100111ddddEE11110iiiii0000 | if (!p0) Rd = #0 ; allocframe(Ii)
		.encoding = { .mask = 0xfff0fe0f, .op = 0x7a703c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; allocframe()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE11110iiiii0000 | if (!p0.new) Rd = #0 ; allocframe(Ii)
		.encoding = { .mask = 0xfff0fe0f, .op = 0x7a503c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 32 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; allocframe()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE11110iiiii0000 | if (p0) Rd = #0 ; allocframe(Ii)
		.encoding = { .mask = 0xfff0fe0f, .op = 0x7a603c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 27 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; allocframe()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE11110iiiii0000 | if (p0.new) Rd = #0 ; allocframe(Ii)
		.encoding = { .mask = 0xfff0fe0f, .op = 0x7a403c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 31 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; allocframe()",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001ssss00IIEE11110iiiii0000 | p0 = cmp.eq(Rs,II) ; allocframe(Ii)
		.encoding = { .mask = 0xff0cfe0f, .op = 0x79003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; allocframe()",
	},
	{
		// 011111000II00dddEE11110iiiii0000 | Rdd = combine(#0,II) ; allocframe(Ii)
		.encoding = { .mask = 0xff98fe0f, .op = 0x7c003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; allocframe()",
	},
	{
		// 011111000II01dddEE11110iiiii0000 | Rdd = combine(#1,II) ; allocframe(Ii)
		.encoding = { .mask = 0xff98fe0f, .op = 0x7c083c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; allocframe()",
	},
	{
		// 011111000II10dddEE11110iiiii0000 | Rdd = combine(#2,II) ; allocframe(Ii)
		.encoding = { .mask = 0xff98fe0f, .op = 0x7c103c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; allocframe()",
	},
	{
		// 011111000II11dddEE11110iiiii0000 | Rdd = combine(#3,II) ; allocframe(Ii)
		.encoding = { .mask = 0xff98fe0f, .op = 0x7c183c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; allocframe()",
	},
	{
		// 01111101ssss1dddEE11110iiiii0000 | Rdd = combine(Rs,#0) ; allocframe(Ii)
		.encoding = { .mask = 0xff08fe0f, .op = 0x7d083c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; allocframe()",
	},
	{
		// 01111101ssss0dddEE11110iiiii0000 | Rdd = combine(#0,Rs) ; allocframe(Ii)
		.encoding = { .mask = 0xff08fe0f, .op = 0x7d003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; allocframe()",
	},
	{
		// 01110011ssssddddEE11110iiiii0000 | Rd = add(Rs,n1) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x73003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; allocframe()",
	},
	{
		// 01110001ssssddddEE11110iiiii0000 | Rd = add(Rs,#1) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x71003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; allocframe()",
	},
	{
		// 011010IIIIIIddddEE11110iiiii0000 | Rd = II ; allocframe(Ii)
		.encoding = { .mask = 0xfc00fe0f, .op = 0x68003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; allocframe()",
	},
	{
		// 011110100000ddddEE11110iiiii0000 | Rd = n1 ; allocframe(Ii)
		.encoding = { .mask = 0xfff0fe0f, .op = 0x7a003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; allocframe()",
	},
	{
		// 01110101ssssddddEE11110iiiii0000 | Rd = sxtb(Rs) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x75003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; allocframe()",
	},
	{
		// 01110100ssssddddEE11110iiiii0000 | Rd = sxth(Rs) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x74003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; allocframe()",
	},
	{
		// 01110000ssssddddEE11110iiiii0000 | Rd = Rs ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x70003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; allocframe()",
	},
	{
		// 01110111ssssddddEE11110iiiii0000 | Rd = and(Rs,#255) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x77003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; allocframe()",
	},
	{
		// 01110110ssssddddEE11110iiiii0000 | Rd = zxth(Rs) ; allocframe(Ii)
		.encoding = { .mask = 0xff00fe0f, .op = 0x76003c00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; allocframe()",
	},
	{
		// 011010IIIIIIddddEE11110iiiii0000 | Rd = II ; allocframe(Ii)
		.encoding = { .mask = 0xfc00fe0f, .op = 0x68003c00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_ALLOCFRAME,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 3, .syntax = 17 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; allocframe()",
	},
	{
		// 01100IIIIIIIxxxxEE110010ssssiiii | Rx = add(Rxin,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xf800ff00, .op = 0x60003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #0",
	},
	{
		// 01111000SSSSxxxxEE110010ssssiiii | Rx = add(Rxin,RS) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x78003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #0",
	},
	{
		// 011011IIIIIIddddEE110010ssssiiii | Rd = add(r29,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x6c003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memb(+) = #0",
	},
	{
		// 01110010SSSSddddEE110010ssssiiii | Rd = and(RS,#1) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x72003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memb(+) = #0",
	},
	{
		// 011110100111ddddEE110010ssssiiii | if (!p0) Rd = #0 ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a703200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memb(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE110010ssssiiii | if (!p0.new) Rd = #0 ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a503200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memb(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE110010ssssiiii | if (p0) Rd = #0 ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a603200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memb(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE110010ssssiiii | if (p0.new) Rd = #0 ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a403200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memb(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE110010ssssiiii | p0 = cmp.eq(RS,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff0cff00, .op = 0x79003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memb(+) = #0",
	},
	{
		// 011111000II00dddEE110010ssssiiii | Rdd = combine(#0,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = #0",
	},
	{
		// 011111000II01dddEE110010ssssiiii | Rdd = combine(#1,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c083200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memb(+) = #0",
	},
	{
		// 011111000II10dddEE110010ssssiiii | Rdd = combine(#2,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c103200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memb(+) = #0",
	},
	{
		// 011111000II11dddEE110010ssssiiii | Rdd = combine(#3,II) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c183200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memb(+) = #0",
	},
	{
		// 01111101SSSS1dddEE110010ssssiiii | Rdd = combine(RS,#0) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff08ff00, .op = 0x7d083200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memb(+) = #0",
	},
	{
		// 01111101SSSS0dddEE110010ssssiiii | Rdd = combine(#0,RS) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff08ff00, .op = 0x7d003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = #0",
	},
	{
		// 01110011SSSSddddEE110010ssssiiii | Rd = add(RS,n1) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x73003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #0",
	},
	{
		// 01110001SSSSddddEE110010ssssiiii | Rd = add(RS,#1) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x71003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memb(+) = #0",
	},
	{
		// 011010IIIIIIddddEE110010ssssiiii | Rd = II ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #0",
	},
	{
		// 011110100000ddddEE110010ssssiiii | Rd = n1 ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #0",
	},
	{
		// 01110101SSSSddddEE110010ssssiiii | Rd = sxtb(RS) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x75003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memb(+) = #0",
	},
	{
		// 01110100SSSSddddEE110010ssssiiii | Rd = sxth(RS) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x74003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memb(+) = #0",
	},
	{
		// 01110000SSSSddddEE110010ssssiiii | Rd = RS ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x70003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #0",
	},
	{
		// 01110111SSSSddddEE110010ssssiiii | Rd = and(RS,#255) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x77003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memb(+) = #0",
	},
	{
		// 01110110SSSSddddEE110010ssssiiii | Rd = zxth(RS) ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x76003200 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memb(+) = #0",
	},
	{
		// 011010IIIIIIddddEE110010ssssiiii | Rd = II ; memb(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003200 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREBI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #0",
	},
	{
		// 01100IIIIIIIxxxxEE110011ssssiiii | Rx = add(Rxin,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xf800ff00, .op = 0x60003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #1",
	},
	{
		// 01111000SSSSxxxxEE110011ssssiiii | Rx = add(Rxin,RS) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x78003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #1",
	},
	{
		// 011011IIIIIIddddEE110011ssssiiii | Rd = add(r29,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x6c003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memb(+) = #1",
	},
	{
		// 01110010SSSSddddEE110011ssssiiii | Rd = and(RS,#1) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x72003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memb(+) = #1",
	},
	{
		// 011110100111ddddEE110011ssssiiii | if (!p0) Rd = #0 ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a703300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memb(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE110011ssssiiii | if (!p0.new) Rd = #0 ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a503300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memb(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE110011ssssiiii | if (p0) Rd = #0 ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a603300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memb(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE110011ssssiiii | if (p0.new) Rd = #0 ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a403300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memb(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE110011ssssiiii | p0 = cmp.eq(RS,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff0cff00, .op = 0x79003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memb(+) = #1",
	},
	{
		// 011111000II00dddEE110011ssssiiii | Rdd = combine(#0,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = #1",
	},
	{
		// 011111000II01dddEE110011ssssiiii | Rdd = combine(#1,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c083300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memb(+) = #1",
	},
	{
		// 011111000II10dddEE110011ssssiiii | Rdd = combine(#2,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c103300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memb(+) = #1",
	},
	{
		// 011111000II11dddEE110011ssssiiii | Rdd = combine(#3,II) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c183300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memb(+) = #1",
	},
	{
		// 01111101SSSS1dddEE110011ssssiiii | Rdd = combine(RS,#0) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff08ff00, .op = 0x7d083300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memb(+) = #1",
	},
	{
		// 01111101SSSS0dddEE110011ssssiiii | Rdd = combine(#0,RS) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff08ff00, .op = 0x7d003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memb(+) = #1",
	},
	{
		// 01110011SSSSddddEE110011ssssiiii | Rd = add(RS,n1) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x73003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memb(+) = #1",
	},
	{
		// 01110001SSSSddddEE110011ssssiiii | Rd = add(RS,#1) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x71003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memb(+) = #1",
	},
	{
		// 011010IIIIIIddddEE110011ssssiiii | Rd = II ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #1",
	},
	{
		// 011110100000ddddEE110011ssssiiii | Rd = n1 ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #1",
	},
	{
		// 01110101SSSSddddEE110011ssssiiii | Rd = sxtb(RS) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x75003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memb(+) = #1",
	},
	{
		// 01110100SSSSddddEE110011ssssiiii | Rd = sxth(RS) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x74003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memb(+) = #1",
	},
	{
		// 01110000SSSSddddEE110011ssssiiii | Rd = RS ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x70003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #1",
	},
	{
		// 01110111SSSSddddEE110011ssssiiii | Rd = and(RS,#255) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x77003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memb(+) = #1",
	},
	{
		// 01110110SSSSddddEE110011ssssiiii | Rd = zxth(RS) ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x76003300 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memb(+) = #1",
	},
	{
		// 011010IIIIIIddddEE110011ssssiiii | Rd = II ; memb(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003300 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREBI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memb(+) = #1",
	},
	{
		// 01100IIIIIIIxxxxEE10101iiiiiittt | Rx = add(Rxin,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xf800fe00, .op = 0x60002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memd(R29+) = ",
	},
	{
		// 01111000ssssxxxxEE10101iiiiiittt | Rx = add(Rxin,Rs) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x78002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memd(R29+) = ",
	},
	{
		// 011011IIIIIIddddEE10101iiiiiittt | Rd = add(r29,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfc00fe00, .op = 0x6c002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memd(R29+) = ",
	},
	{
		// 01110010ssssddddEE10101iiiiiittt | Rd = and(Rs,#1) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x72002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memd(R29+) = ",
	},
	{
		// 011110100111ddddEE10101iiiiiittt | if (!p0) Rd = #0 ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a702a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memd(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE10101iiiiiittt | if (!p0.new) Rd = #0 ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a502a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 30 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 34 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memd(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE10101iiiiiittt | if (p0) Rd = #0 ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a602a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memd(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE10101iiiiiittt | if (p0.new) Rd = #0 ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a402a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 33 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memd(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001ssss00IIEE10101iiiiiittt | p0 = cmp.eq(Rs,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff0cfe00, .op = 0x79002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memd(R29+) = ",
	},
	{
		// 011111000II00dddEE10101iiiiiittt | Rdd = combine(#0,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memd(R29+) = ",
	},
	{
		// 011111000II01dddEE10101iiiiiittt | Rdd = combine(#1,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c082a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memd(R29+) = ",
	},
	{
		// 011111000II10dddEE10101iiiiiittt | Rdd = combine(#2,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c102a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memd(R29+) = ",
	},
	{
		// 011111000II11dddEE10101iiiiiittt | Rdd = combine(#3,II) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c182a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memd(R29+) = ",
	},
	{
		// 01111101ssss1dddEE10101iiiiiittt | Rdd = combine(Rs,#0) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff08fe00, .op = 0x7d082a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memd(R29+) = ",
	},
	{
		// 01111101ssss0dddEE10101iiiiiittt | Rdd = combine(#0,Rs) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff08fe00, .op = 0x7d002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memd(R29+) = ",
	},
	{
		// 01110011ssssddddEE10101iiiiiittt | Rd = add(Rs,n1) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x73002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memd(R29+) = ",
	},
	{
		// 01110001ssssddddEE10101iiiiiittt | Rd = add(Rs,#1) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x71002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memd(R29+) = ",
	},
	{
		// 011010IIIIIIddddEE10101iiiiiittt | Rd = II ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfc00fe00, .op = 0x68002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memd(R29+) = ",
	},
	{
		// 011110100000ddddEE10101iiiiiittt | Rd = n1 ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memd(R29+) = ",
	},
	{
		// 01110101ssssddddEE10101iiiiiittt | Rd = sxtb(Rs) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x75002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memd(R29+) = ",
	},
	{
		// 01110100ssssddddEE10101iiiiiittt | Rd = sxth(Rs) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x74002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memd(R29+) = ",
	},
	{
		// 01110000ssssddddEE10101iiiiiittt | Rd = Rs ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x70002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memd(R29+) = ",
	},
	{
		// 01110111ssssddddEE10101iiiiiittt | Rd = and(Rs,#255) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x77002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memd(R29+) = ",
	},
	{
		// 01110110ssssddddEE10101iiiiiittt | Rd = zxth(Rs) ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xff00fe00, .op = 0x76002a00 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memd(R29+) = ",
	},
	{
		// 011010IIIIIIddddEE10101iiiiiittt | Rd = II ; memd(r29+Ii) = Rtt
		.encoding = { .mask = 0xfc00fe00, .op = 0x68002a00 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STORED_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED, .masks = { { 0x6, 3 } }, .imm_scale = 3, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memd(R29+) = ",
	},
	{
		// 01100IIIIIIIxxxxEE100iiisssstttt | Rx = add(Rxin,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f800, .op = 0x60002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memh(+) = ",
	},
	{
		// 01111000SSSSxxxxEE100iiisssstttt | Rx = add(Rxin,RS) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x78002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memh(+) = ",
	},
	{
		// 011011IIIIIIddddEE100iiisssstttt | Rd = add(r29,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f800, .op = 0x6c002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memh(+) = ",
	},
	{
		// 01110010SSSSddddEE100iiisssstttt | Rd = and(RS,#1) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x72002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memh(+) = ",
	},
	{
		// 011110100111ddddEE100iiisssstttt | if (!p0) Rd = #0 ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f800, .op = 0x7a702000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE100iiisssstttt | if (!p0.new) Rd = #0 ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f800, .op = 0x7a502000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE100iiisssstttt | if (p0) Rd = #0 ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f800, .op = 0x7a602000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE100iiisssstttt | if (p0.new) Rd = #0 ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f800, .op = 0x7a402000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memh(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE100iiisssstttt | p0 = cmp.eq(RS,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff0cf800, .op = 0x79002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memh(+) = ",
	},
	{
		// 011111000II00dddEE100iiisssstttt | Rdd = combine(#0,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f800, .op = 0x7c002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memh(+) = ",
	},
	{
		// 011111000II01dddEE100iiisssstttt | Rdd = combine(#1,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f800, .op = 0x7c082000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memh(+) = ",
	},
	{
		// 011111000II10dddEE100iiisssstttt | Rdd = combine(#2,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f800, .op = 0x7c102000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memh(+) = ",
	},
	{
		// 011111000II11dddEE100iiisssstttt | Rdd = combine(#3,II) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff98f800, .op = 0x7c182000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memh(+) = ",
	},
	{
		// 01111101SSSS1dddEE100iiisssstttt | Rdd = combine(RS,#0) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f800, .op = 0x7d082000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memh(+) = ",
	},
	{
		// 01111101SSSS0dddEE100iiisssstttt | Rdd = combine(#0,RS) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff08f800, .op = 0x7d002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memh(+) = ",
	},
	{
		// 01110011SSSSddddEE100iiisssstttt | Rd = add(RS,n1) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x73002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memh(+) = ",
	},
	{
		// 01110001SSSSddddEE100iiisssstttt | Rd = add(RS,#1) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x71002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memh(+) = ",
	},
	{
		// 011010IIIIIIddddEE100iiisssstttt | Rd = II ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f800, .op = 0x68002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memh(+) = ",
	},
	{
		// 011110100000ddddEE100iiisssstttt | Rd = n1 ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfff0f800, .op = 0x7a002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memh(+) = ",
	},
	{
		// 01110101SSSSddddEE100iiisssstttt | Rd = sxtb(RS) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x75002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memh(+) = ",
	},
	{
		// 01110100SSSSddddEE100iiisssstttt | Rd = sxth(RS) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x74002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memh(+) = ",
	},
	{
		// 01110000SSSSddddEE100iiisssstttt | Rd = RS ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x70002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memh(+) = ",
	},
	{
		// 01110111SSSSddddEE100iiisssstttt | Rd = and(RS,#255) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x77002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memh(+) = ",
	},
	{
		// 01110110SSSSddddEE100iiisssstttt | Rd = zxth(RS) ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f800, .op = 0x76002000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memh(+) = ",
	},
	{
		// 011010IIIIIIddddEE100iiisssstttt | Rd = II ; memh(Rs+Ii) = Rt
		.encoding = { .mask = 0xfc00f800, .op = 0x68002000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREH_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 8 } }, .imm_scale = 1, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 16 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memh(+) = ",
	},
	{
		// 01100IIIIIIIxxxxEE10100iiiiitttt | Rx = add(Rxin,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xf800fe00, .op = 0x60002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(R29+) = ",
	},
	{
		// 01111000ssssxxxxEE10100iiiiitttt | Rx = add(Rxin,Rs) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x78002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(R29+) = ",
	},
	{
		// 011011IIIIIIddddEE10100iiiiitttt | Rd = add(r29,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfc00fe00, .op = 0x6c002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 24 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 28 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memw(R29+) = ",
	},
	{
		// 01110010ssssddddEE10100iiiiitttt | Rd = and(Rs,#1) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x72002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memw(R29+) = ",
	},
	{
		// 011110100111ddddEE10100iiiiitttt | if (!p0) Rd = #0 ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a702800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memw(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE10100iiiiitttt | if (!p0.new) Rd = #0 ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a502800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 30 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 34 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memw(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE10100iiiiitttt | if (p0) Rd = #0 ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a602800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memw(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE10100iiiiitttt | if (p0.new) Rd = #0 ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a402800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 29 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 33 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memw(R29+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001ssss00IIEE10100iiiiitttt | p0 = cmp.eq(Rs,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff0cfe00, .op = 0x79002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memw(R29+) = ",
	},
	{
		// 011111000II00dddEE10100iiiiitttt | Rdd = combine(#0,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(R29+) = ",
	},
	{
		// 011111000II01dddEE10100iiiiitttt | Rdd = combine(#1,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c082800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memw(R29+) = ",
	},
	{
		// 011111000II10dddEE10100iiiiitttt | Rdd = combine(#2,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c102800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memw(R29+) = ",
	},
	{
		// 011111000II11dddEE10100iiiiitttt | Rdd = combine(#3,II) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff98fe00, .op = 0x7c182800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memw(R29+) = ",
	},
	{
		// 01111101ssss1dddEE10100iiiiitttt | Rdd = combine(Rs,#0) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff08fe00, .op = 0x7d082800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memw(R29+) = ",
	},
	{
		// 01111101ssss0dddEE10100iiiiitttt | Rdd = combine(#0,Rs) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff08fe00, .op = 0x7d002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 27 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(R29+) = ",
	},
	{
		// 01110011ssssddddEE10100iiiiitttt | Rd = add(Rs,n1) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x73002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(R29+) = ",
	},
	{
		// 01110001ssssddddEE10100iiiiitttt | Rd = add(Rs,#1) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x71002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memw(R29+) = ",
	},
	{
		// 011010IIIIIIddddEE10100iiiiitttt | Rd = II ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfc00fe00, .op = 0x68002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(R29+) = ",
	},
	{
		// 011110100000ddddEE10100iiiiitttt | Rd = n1 ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfff0fe00, .op = 0x7a002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(R29+) = ",
	},
	{
		// 01110101ssssddddEE10100iiiiitttt | Rd = sxtb(Rs) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x75002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memw(R29+) = ",
	},
	{
		// 01110100ssssddddEE10100iiiiitttt | Rd = sxth(Rs) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x74002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memw(R29+) = ",
	},
	{
		// 01110000ssssddddEE10100iiiiitttt | Rd = Rs ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x70002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(R29+) = ",
	},
	{
		// 01110111ssssddddEE10100iiiiitttt | Rd = and(Rs,#255) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x77002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 29 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memw(R29+) = ",
	},
	{
		// 01110110ssssddddEE10100iiiiitttt | Rd = zxth(Rs) ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xff00fe00, .op = 0x76002800 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memw(R29+) = ",
	},
	{
		// 011010IIIIIIddddEE10100iiiiitttt | Rd = II ; memw(r29+Ii) = Rt
		.encoding = { .mask = 0xfc00fe00, .op = 0x68002800 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREW_SP,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 4 } }, .imm_scale = 2, .syntax = 15 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(R29+) = ",
	},
	{
		// 01100IIIIIIIxxxxEE110000ssssiiii | Rx = add(Rxin,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xf800ff00, .op = 0x60003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #0",
	},
	{
		// 01111000SSSSxxxxEE110000ssssiiii | Rx = add(Rxin,RS) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x78003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #0",
	},
	{
		// 011011IIIIIIddddEE110000ssssiiii | Rd = add(r29,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x6c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memw(+) = #0",
	},
	{
		// 01110010SSSSddddEE110000ssssiiii | Rd = and(RS,#1) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x72003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memw(+) = #0",
	},
	{
		// 011110100111ddddEE110000ssssiiii | if (!p0) Rd = #0 ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a703000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memw(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE110000ssssiiii | if (!p0.new) Rd = #0 ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a503000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memw(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE110000ssssiiii | if (p0) Rd = #0 ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a603000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memw(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE110000ssssiiii | if (p0.new) Rd = #0 ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a403000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memw(+) = #0",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE110000ssssiiii | p0 = cmp.eq(RS,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff0cff00, .op = 0x79003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memw(+) = #0",
	},
	{
		// 011111000II00dddEE110000ssssiiii | Rdd = combine(#0,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = #0",
	},
	{
		// 011111000II01dddEE110000ssssiiii | Rdd = combine(#1,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c083000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memw(+) = #0",
	},
	{
		// 011111000II10dddEE110000ssssiiii | Rdd = combine(#2,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c103000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memw(+) = #0",
	},
	{
		// 011111000II11dddEE110000ssssiiii | Rdd = combine(#3,II) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff98ff00, .op = 0x7c183000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memw(+) = #0",
	},
	{
		// 01111101SSSS1dddEE110000ssssiiii | Rdd = combine(RS,#0) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff08ff00, .op = 0x7d083000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memw(+) = #0",
	},
	{
		// 01111101SSSS0dddEE110000ssssiiii | Rdd = combine(#0,RS) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff08ff00, .op = 0x7d003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = #0",
	},
	{
		// 01110011SSSSddddEE110000ssssiiii | Rd = add(RS,n1) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x73003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #0",
	},
	{
		// 01110001SSSSddddEE110000ssssiiii | Rd = add(RS,#1) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x71003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memw(+) = #0",
	},
	{
		// 011010IIIIIIddddEE110000ssssiiii | Rd = II ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #0",
	},
	{
		// 011110100000ddddEE110000ssssiiii | Rd = n1 ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #0",
	},
	{
		// 01110101SSSSddddEE110000ssssiiii | Rd = sxtb(RS) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x75003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memw(+) = #0",
	},
	{
		// 01110100SSSSddddEE110000ssssiiii | Rd = sxth(RS) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x74003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memw(+) = #0",
	},
	{
		// 01110000SSSSddddEE110000ssssiiii | Rd = RS ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x70003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #0",
	},
	{
		// 01110111SSSSddddEE110000ssssiiii | Rd = and(RS,#255) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x77003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memw(+) = #0",
	},
	{
		// 01110110SSSSddddEE110000ssssiiii | Rd = zxth(RS) ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xff00ff00, .op = 0x76003000 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memw(+) = #0",
	},
	{
		// 011010IIIIIIddddEE110000ssssiiii | Rd = II ; memw(Rs+Ii) = #0
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003000 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREWI0,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #0",
	},
	{
		// 01100IIIIIIIxxxxEE110001ssssiiii | Rx = add(Rxin,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xf800ff00, .op = 0x60003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDI_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_SIGNED | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x7, 20 } }, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #1",
	},
	{
		// 01111000SSSSxxxxEE110001ssssiiii | Rx = add(Rxin,RS) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x78003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDRX_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #1",
	},
	{
		// 011011IIIIIIddddEE110001ssssiiii | Rd = add(r29,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x6c003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ADDSP_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .imm_scale = 2, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 21 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(R29,) ; memw(+) = #1",
	},
	{
		// 01110010SSSSddddEE110001ssssiiii | Rd = and(RS,#1) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x72003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_AND1_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#1) ; memw(+) = #1",
	},
	{
		// 011110100111ddddEE110001ssssiiii | if (!p0) Rd = #0 ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a703100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRF_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0)  = #0 ; memw(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100101ddddEE110001ssssiiii | if (!p0.new) Rd = #0 ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a503100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRFNEW_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 27 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (!P0.new)  = #0 ; memw(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100110ddddEE110001ssssiiii | if (p0) Rd = #0 ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a603100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRT_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 22 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0)  = #0 ; memw(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 011110100100ddddEE110001ssssiiii | if (p0.new) Rd = #0 ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a403100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CLRTNEW_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 26 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_COND,
		.syntax = "if (P0.new)  = #0 ; memw(+) = #1",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 01111001SSSS00IIEE110001ssssiiii | p0 = cmp.eq(RS,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff0cff00, .op = 0x79003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_CMPEQI_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 16 } }, .syntax = 13 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "P0 = cmp.eq(,) ; memw(+) = #1",
	},
	{
		// 011111000II00dddEE110001ssssiiii | Rdd = combine(#0,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE0I_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = #1",
	},
	{
		// 011111000II01dddEE110001ssssiiii | Rdd = combine(#1,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c083100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE1I_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#1,) ; memw(+) = #1",
	},
	{
		// 011111000II10dddEE110001ssssiiii | Rdd = combine(#2,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c103100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE2I_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#2,) ; memw(+) = #1",
	},
	{
		// 011111000II11dddEE110001ssssiiii | Rdd = combine(#3,II) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff98ff00, .op = 0x7c183100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINE3I_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x2, 21 } }, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#3,) ; memw(+) = #1",
	},
	{
		// 01111101SSSS1dddEE110001ssssiiii | Rdd = combine(RS,#0) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff08ff00, .op = 0x7d083100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINERZ_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(,#0) ; memw(+) = #1",
	},
	{
		// 01111101SSSS0dddEE110001ssssiiii | Rdd = combine(#0,RS) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff08ff00, .op = 0x7d003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_COMBINEZR_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 14 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = combine(#0,) ; memw(+) = #1",
	},
	{
		// 01110011SSSSddddEE110001ssssiiii | Rd = add(RS,n1) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x73003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_DEC_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,) ; memw(+) = #1",
	},
	{
		// 01110001SSSSddddEE110001ssssiiii | Rd = add(RS,#1) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x71003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_INC_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 20 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = add(,#1) ; memw(+) = #1",
	},
	{
		// 011010IIIIIIddddEE110001ssssiiii | Rd = II ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETI_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE | HEX_OP_TEMPLATE_FLAG_IMM_DOUBLE_HASH, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #1",
	},
	{
		// 011110100000ddddEE110001ssssiiii | Rd = n1 ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfff0ff00, .op = 0x7a003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SETIN1_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM_CONST, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #1",
	},
	{
		// 01110101SSSSddddEE110001ssssiiii | Rd = sxtb(RS) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x75003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTB_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxtb() ; memw(+) = #1",
	},
	{
		// 01110100SSSSddddEE110001ssssiiii | Rd = sxth(RS) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x74003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_SXTH_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = sxth() ; memw(+) = #1",
	},
	{
		// 01110000SSSSddddEE110001ssssiiii | Rd = RS ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x70003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_TFR_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #1",
	},
	{
		// 01110111SSSSddddEE110001ssssiiii | Rd = and(RS,#255) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x77003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTB_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 7 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 22 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = and(,#255) ; memw(+) = #1",
	},
	{
		// 01110110SSSSddddEE110001ssssiiii | Rd = zxth(RS) ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xff00ff00, .op = 0x76003100 },
		.id = HEX_INS_X2_AUTOJOIN_SA1_ZXTH_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 17 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 18 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = zxth() ; memw(+) = #1",
	},
	{
		// 011010IIIIIIddddEE110001ssssiiii | Rd = II ; memw(Rs+Ii) = #1
		.encoding = { .mask = 0xfc00ff00, .op = 0x68003100 },
		.id = HEX_INS_X2_AUTOJOIN_UNDOCUMENTED_SA2_TFRSI_SS2_STOREWI1,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x6, 20 } }, .syntax = 3 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 11 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 0 } }, .imm_scale = 2, .syntax = 12 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " =  ; memw(+) = #1",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x8[] = {
	{
		// 1000IIIISSSSddddEE01iiiisssstttt | Rd = memw(RS+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf000f000, .op = 0x80001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ; memb(+) = ",
	},
	{
		// 1001IIIISSSSddddEE01iiiisssstttt | Rd = memub(RS+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf000f000, .op = 0x90001000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ; memb(+) = ",
	},
	{
		// 1000IIIISSSSddddEE00iiiisssstttt | Rd = memw(RS+II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xf000f000, .op = 0x80000000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRI_IO_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .imm_scale = 2, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(+) ; memw(+) = ",
	},
	{
		// 1001IIIISSSSddddEE00iiiisssstttt | Rd = memub(RS+II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xf000f000, .op = 0x90000000 },
		.id = HEX_INS_X2_AUTOJOIN_SL1_LOADRUB_IO_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 24 } }, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memub(+) ; memw(+) = ",
	},
	{ { 0 } },
};

static const HexInsnTemplate templates_duplex_0x9[] = {
	{
		// 1001111100000000EE11iiiisssstttt | deallocframe ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "deallocframe ; memb(+) = ",
	},
	{
		// 10010IIISSSSddddEE11iiiisssstttt | Rd = memb(RS+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x90003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ; memb(+) = ",
	},
	{
		// 10011110IIIIIdddEE11iiiisssstttt | Rdd = memd(r29+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x9e003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memd(R29+) ; memb(+) = ",
	},
	{
		// 10000IIISSSSddddEE11iiiisssstttt | Rd = memh(RS+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x80003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRH_IO_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memh(+) ; memb(+) = ",
	},
	{
		// 1001110IIIIIddddEE11iiiisssstttt | Rd = memw(r29+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfe00f000, .op = 0x9c003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRI_SP_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 20 } }, .imm_scale = 2, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 26 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memw(R29+) ; memb(+) = ",
	},
	{
		// 10001IIISSSSddddEE11iiiisssstttt | Rd = memuh(RS+II) ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x88003000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRUH_IO_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .imm_scale = 1, .syntax = 10 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 24 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memuh(+) ; memb(+) = ",
	},
	{
		// 1001111101000000EE11iiiisssstttt | dealloc_return ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f403000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 22 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 23 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 27 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_RET,
		.syntax = "dealloc_return ; memb(+) = ",
	},
	{
		// 1001111101000101EE11iiiisssstttt | if (!p0) dealloc_return ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f453000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_F_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 31 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 32 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 36 },
		},
		.pred = HEX_PRED_FALSE,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0) dealloc_return ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 1001111101000111EE11iiiisssstttt | if (!p0.new) dealloc_return:nt ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f473000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_FNEW_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 38 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 39 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 43 },
		},
		.pred = HEX_PRED_FALSE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_FALSE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (!P0.new) dealloc_return:nt ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 1001111101000100EE11iiiisssstttt | if (p0) dealloc_return ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f443000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_T_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 30 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 31 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 35 },
		},
		.pred = HEX_PRED_TRUE,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0) dealloc_return ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 1001111101000110EE11iiiisssstttt | if (p0.new) dealloc_return:nt ; memb(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f463000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_RETURN_TNEW_SS1_STOREB_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 37 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .syntax = 38 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 42 },
		},
		.pred = HEX_PRED_TRUE | HEX_PRED_NEW,
		.cond = RZ_TYPE_COND_HEX_SCL_TRUE,
		.type = RZ_ANALYSIS_OP_TYPE_CRET,
		.syntax = "if (P0.new) dealloc_return:nt ; memb(+) = ",
		.flags = HEX_INSN_TEMPLATE_FLAG_PREDICATED,
	},
	{
		// 1001111100000000EE10iiiisssstttt | deallocframe ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xfffff000, .op = 0x9f002000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_DEALLOCFRAME_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 20 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM | HEX_OP_TEMPLATE_FLAG_IMM_EXTENDABLE, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 21 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 25 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = "deallocframe ; memw(+) = ",
	},
	{
		// 10010IIISSSSddddEE10iiiisssstttt | Rd = memb(RS+II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xf800f000, .op = 0x90002000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRB_IO_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT, .masks = { { 0x4, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 20 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 8 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x3, 24 } }, .syntax = 9 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 18 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x4, 8 } }, .imm_scale = 2, .syntax = 19 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 0 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_REGS, .syntax = 23 },
		},
		.pred = HEX_NOPRED,
		.cond = RZ_TYPE_COND_AL,
		.type = RZ_ANALYSIS_OP_TYPE_NULL,
		.syntax = " = memb(+) ; memw(+) = ",
	},
	{
		// 10011110IIIIIdddEE10iiiisssstttt | Rdd = memd(r29+II) ; memw(Rs+Ii) = Rt
		.encoding = { .mask = 0xff00f000, .op = 0x9e002000 },
		.id = HEX_INS_X2_AUTOJOIN_SL2_LOADRD_SP_SS1_STOREW_IO,
		.ops = {
			{ .info = HEX_OP_TEMPLATE_TYPE_REG | HEX_OP_TEMPLATE_FLAG_REG_OUT | HEX_OP_TEMPLATE_FLAG_REG_PAIR, .masks = { { 0x3, 16 } }, .reg_cls = HEX_REG_CLASS_GENERAL_DOUBLE_LOW8_REGS, .syntax = 0 },
			{ .info = HEX_OP_TEMPLATE_TYPE_IMM, .masks = { { 0x5, 19 } }, .imm_scale = 3, .syntax = 12 },
			{ .info = HEX_OP_TEMPLATE_TYPE_REG, .masks = { { 0x4, 4 } }, .reg_cls = HEX_REG_CLASS_GENERAL_SUB_