/*
 * YARA rules for MIPS64 ELF compiler detection.
 * Copyright (c) 2017 Avast Software, licensed under the MIT license
 */

import "elf"

rule gc
{
	meta:
		tool = "C"
		name = "gc"
		language = "Go"
		pattern = "0801????0000000000000000000000008FA4000463A500080801????000000000411000100000000001FE03E001CE03C3C01000?003C082D6421????0020000800000000000000008FA40008640214550000000C03E000080000000000000000DFA40008"
	strings:
		$1 = { 08 01 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 8F A4 00 04 63 A5 00 08 08 01 ?? ?? 00 00 00 00 04 11 00 01 00 00 00 00 00 1F E0 3E 00 1C E0 3C 3C 01 00 0? 00 3C 08 2D 64 21 ?? ?? 00 20 00 08 00 00 00 00 00 00 00 00 8F A4 00 08 64 02 14 55 00 00 00 0C 03 E0 00 08 00 00 00 00 00 00 00 00 DF A4 00 08 }
	condition:
		$1 at elf.entry_point
}

rule gc_le
{
	meta:
		tool = "C"
		name = "gc"
		language = "Go"
		pattern = "????01080000000000000000000000000000A48F0800A563????01080000000001001104000000003EE01F003CE01C000?00013C2D083C00????21640800200000000000000000000800A48F551402640C0000000800E00300000000000000000800A4DF"
	strings:
		$1 = { ?? ?? 01 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 A4 8F 08 00 A5 63 ?? ?? 01 08 00 00 00 00 01 00 11 04 00 00 00 00 3E E0 1F 00 3C E0 1C 00 0? 00 01 3C 2D 08 3C 00 ?? ?? 21 64 08 00 20 00 00 00 00 00 00 00 00 00 08 00 A4 8F 55 14 02 64 0C 00 00 00 08 00 E0 03 00 00 00 00 00 00 00 00 08 00 A4 DF }
	condition:
		$1 at elf.entry_point
}
