/*
 * YARA rules for ARM ELF packer detection.
 * Copyright (c) 2017 Avast Software, licensed under the MIT license
 */

import "elf"

rule upx_391_lzma
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.91 [LZMA]"
		source = "Made by Retdec Team"
		pattern = "00000000F04F2DE930D04DE200308DE50030D0E50250D0E501E0D0E500C09DE514308DE55C309DE50040A0E300408CE5004083E514C09DE50130D0E503308CE0"
		start = 380
	strings:
		$1 = { 00 00 00 00 F0 4F 2D E9 30 D0 4D E2 00 30 8D E5 00 30 D0 E5 02 50 D0 E5 01 E0 D0 E5 00 C0 9D E5 14 30 8D E5 5C 30 9D E5 00 40 A0 E3 00 40 8C E5 00 40 83 E5 14 C0 9D E5 01 30 D0 E5 03 30 8C E0 }
	condition:
		$1 at elf.entry_point + 380
}

rule upx_391_nrv2b
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.91 [NRV2B]"
		source = "Made by Retdec Team"
		pattern = "044094E00EF0A0110140D0E40440A4E0044CB0E10EF0A0E10110A0E30EC0A0E1F6FFFFEB0110B1E0F4FFFFEBFBFFFF3A"
		start = 276
	strings:
		$1 = { 04 40 94 E0 0E F0 A0 11 01 40 D0 E4 04 40 A4 E0 04 4C B0 E1 0E F0 A0 E1 01 10 A0 E3 0E C0 A0 E1 F6 FF FF EB 01 10 B1 E0 F4 FF FF EB FB FF FF 3A }
	condition:
		$1 at elf.entry_point + 276
}

rule upx_391_nrv2d
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.91 [NRV2D]"
		source = "Made by Retdec Team"
		pattern = "0140D0E40440A4E0044CB0E10EF0A0E10130D0E40130C2E4044094E0F7FFFF0BFAFFFF2A0110A0E3030000EA011041E2044094E0F1FFFF0B0110B1E0"
		start = 276
	strings:
		$1 = { 01 40 D0 E4 04 40 A4 E0 04 4C B0 E1 0E F0 A0 E1 01 30 D0 E4 01 30 C2 E4 04 40 94 E0 F7 FF FF 0B FA FF FF 2A 01 10 A0 E3 03 00 00 EA 01 10 41 E2 04 40 94 E0 F1 FF FF 0B 01 10 B1 E0 }
	condition:
		$1 at elf.entry_point + 276
}

rule upx_391_nrv2e
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.91 [NRV2E]"
		source = "Made by Retdec Team"
		pattern = "0140D0E40440A4E0044CB0E10EF0A0E10130D0E40130C2E4044094E0F7FFFF0BFAFFFF2A0110A0E3030000EA011041E2044094E0F1FFFF0B0110A1E0"
		start = 276
	strings:
		$1 = { 01 40 D0 E4 04 40 A4 E0 04 4C B0 E1 0E F0 A0 E1 01 30 D0 E4 01 30 C2 E4 04 40 94 E0 F7 FF FF 0B FA FF FF 2A 01 10 A0 E3 03 00 00 EA 01 10 41 E2 04 40 94 E0 F1 FF FF 0B 01 10 A1 E0 }
	condition:
		$1 at elf.entry_point + 276
}

rule upx_392_393_lzma
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.92, 3.93 [LZMA]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80CB08BE00CA08AE000309BE501904CE0031081E00200A0E1011A81E20030A0E30F402DE90720A0E310309CE50050A0E30040E0E3103083E3C070A0E3000000EF010A70E39B02002AFE01B9E80A0059E1FE01A0E8FBFFFF3A094040E0"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 03 10 81 E0 02 00 A0 E1 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 9B 02 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 FB FF FF 3A 09 40 40 E0 }
	condition:
		$1 at elf.entry_point
}

rule upx_392_393_nrv2b
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.92, 3.93 [NRV2B]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80CB08BE00CA08AE000309BE501904CE0031081E00200A0E1011A81E20030A0E30F402DE90720A0E310309CE50050A0E30040E0E3103083E3C070A0E3000000EF010A70E35900002AFE01B9E80A0059E1FE01A0E8FBFFFF3A094040E0"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 03 10 81 E0 02 00 A0 E1 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 59 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 FB FF FF 3A 09 40 40 E0 }
	condition:
		$1 at elf.entry_point
}

rule upx_392_393_nrv2d
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.92, 3.93 [NRV2D]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80CB08BE00CA08AE000309BE501904CE0031081E00200A0E1011A81E20030A0E30F402DE90720A0E310309CE50050A0E30040E0E3103083E3C070A0E3000000EF010A70E36800002AFE01B9E80A0059E1FE01A0E8FBFFFF3A094040E0"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 03 10 81 E0 02 00 A0 E1 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 68 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 FB FF FF 3A 09 40 40 E0 }
	condition:
		$1 at elf.entry_point
}

rule upx_392_393_nrv2e
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.92, 3.93 [NRV2E]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80CB08BE00CA08AE000309BE501904CE0031081E00200A0E1011A81E20030A0E30F402DE90720A0E310309CE50050A0E30040E0E3103083E3C070A0E3000000EF010A70E36800002AFE01B9E80A0059E1FE01A0E8FBFFFF3A094040E0"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 03 10 81 E0 02 00 A0 E1 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 6D 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 FB FF FF 3A 09 40 40 E0 }
	condition:
		$1 at elf.entry_point
}

rule upx_394_lzma
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.94 [LZMA]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80200A0E10CB08BE00CA08AE000309BE501904CE00120A0E1031081E0011A81E20030A0E30F402DE90720A0E310309CE509C0A0E10050A0E30040E0E3103083E3C070A0E3000000EF010A70E39E02002AFE01B9E80A0059E1FE01A0E8"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 02 00 A0 E1 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 01 20 A0 E1 03 10 81 E0 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 09 C0 A0 E1 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 9E 02 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 }
	condition:
		$1 at elf.entry_point
}

rule upx_394_nrv2b
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.94 [NRV2B]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80200A0E10CB08BE00CA08AE000309BE501904CE00120A0E1031081E0011A81E20030A0E30F402DE90720A0E310309CE509C0A0E10050A0E30040E0E3103083E3C070A0E3000000EF010A70E35D00002AFE01B9E80A0059E1FE01A0E8"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 02 00 A0 E1 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 01 20 A0 E1 03 10 81 E0 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 09 C0 A0 E1 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 5D 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 }
	condition:
		$1 at elf.entry_point
}

rule upx_394_nrv2d
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.94 [NRV2D]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80200A0E10CB08BE00CA08AE000309BE501904CE00120A0E1031081E0011A81E20030A0E30F402DE90720A0E310309CE509C0A0E10050A0E30040E0E3103083E3C070A0E3000000EF010A70E36C00002AFE01B9E80A0059E1FE01A0E8"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 02 00 A0 E1 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 01 20 A0 E1 03 10 81 E0 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 09 C0 A0 E1 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 6C 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 }
	condition:
		$1 at elf.entry_point
}

rule upx_394_nrv2e
{
	meta:
		tool = "P"
		name = "UPX"
		version = "3.94 [NRV2E]"
		source = "Made by Retdec Team"
		pattern = "1CC04FE2064C9CE80200A0E10CB08BE00CA08AE000309BE501904CE00120A0E1031081E0011A81E20030A0E30F402DE90720A0E310309CE509C0A0E10050A0E30040E0E3103083E3C070A0E3000000EF010A70E37100002AFE01B9E80A0059E1FE01A0E8"
	strings:
		$1 = { 1C C0 4F E2 06 4C 9C E8 02 00 A0 E1 0C B0 8B E0 0C A0 8A E0 00 30 9B E5 01 90 4C E0 01 20 A0 E1 03 10 81 E0 01 1A 81 E2 00 30 A0 E3 0F 40 2D E9 07 20 A0 E3 10 30 9C E5 09 C0 A0 E1 00 50 A0 E3 00 40 E0 E3 10 30 83 E3 C0 70 A0 E3 00 00 00 EF 01 0A 70 E3 71 00 00 2A FE 01 B9 E8 0A 00 59 E1 FE 01 A0 E8 }
	condition:
		$1 at elf.entry_point
}
