#include "Lookups.hh"

#include <stdexcept>

using namespace std;



// Universal Interfaces 3.4.2, 'ver*'-defines
const map<int64_t, string> REGION_NAMES = {
  { 0, "United States" },
  { 1, "France" },
  { 2, "Britain" },
  { 3, "Germany" },
  { 4, "Italy" },
  { 5, "Netherlands" },
  { 6, "Belgium (Flemish)" }, // was: Belgium/Luxembourg (French)
  { 7, "Sweden" },
  { 8, "Spain" },
  { 9, "Denmark" },
  { 10, "Portugal" },
  { 11, "Canada (French)" },
  { 12, "Norway (Bokmål)" },
  { 13, "Israel" },
  { 14, "Japan" },
  { 15, "Australia" },
  { 16, "North Africa/Arabian Peninsula/Levant" },
  { 17, "Finland" },
  { 18, "Switzerland (French)" },
  { 19, "Switzerland (German)" },
  { 20, "Greece" },
  { 21, "Iceland" },
  { 22, "Malta" },
  { 23, "Cyprus" },
  { 24, "Turkey" },
  { 25, "Yugoslavia (Croatian)" },  // replaced by 68 - Croatia
  { 33, "India (Hindi)" },
  { 34, "Pakistan (Urdu)" },
  { 36, "Switzerland (Italian)" },
  { 39, "Romania" },
  { 41, "Lithuania" },
  { 42, "Poland" },
  { 43, "Hungary" },
  { 44, "Estonia" },
  { 45, "Latvia" },
  { 46, "Norway (Northern Sámi)" },
  { 47, "Faroe Islands" },
  { 48, "Iran" },
  { 49, "Russia" },
  { 50, "Ireland (Irish Gaelic without dot above)" },
  { 51, "Korea" },
  { 52, "China" },
  { 53, "Taiwan" },
  { 54, "Thailand" },
  { 56, "Czech Republic" },
  { 57, "Slovakia" },
  { 60, "Bangladesh/India (Bengali)" },
  { 61, "Belarus" },
  { 62, "Ukraine" },
  { 65, "Serbia" },
  { 66, "Slovenia" },
  { 67, "Macedonia" },
  { 68, "Croatia" },
  { 71, "Brazil" },
  { 72, "Bulgaria" },
  { 73, "Catalonia" },
  { 75, "Scotland (Scottish Gaelic)" },
  { 76, "Isle of Man (Manx Gaelic)" },
  { 77, "France (Breton)" },
  { 78, "Canada (Inuktitut)" },
  { 79, "Wales" },
  { 81, "Ireland (Irish Gaelic with dot above)" },
  { 82, "Canada (English)" },
  { 83, "Bhutan" },
  { 84, "Armenia" },
  { 85, "Georgia" },
  { 86, "Latin America" },
  { 88, "Tonga" },
  { 92, "Austria" },
  { 94, "India (Gujarati)" },
  { 95, "India/Pakistan (Punjabi)" },
  { 96, "India (Urdu)" },
  { 97, "Vietnam" },
  { 98, "Belgium (French)" },
  { 99, "Uzbekistan" },
  { 100, "Singapore" },
  { 101, "Norway (Nynorsk)" },
  { 102, "South Africa (Afrikaans)" },
  { 104, "India (Marathi)" },
  { 105, "Tibet" },
  { 106, "Nepal" },
  { 107, "Greenland" },
  { 108, "Ireland (English with Euro)" },
};

const map<int64_t, string> STANDARD_FONT_NAMES = {
  {0, "Chicago"},
  {1, "Helvetica"}, // this is actually "inherit"
  {2, "New York"},
  {3, "Geneva"},
  {4, "Monaco"},
  {5, "Venice"},
  {6, "London"},
  {7, "Athens"},
  {8, "San Francisco"},
  {9, "Toronto"},
  {10, "Seattle"},
  {11, "Cairo"},
  {12, "Los Angeles"},
  {13, "Zapf Dingbats"},
  {14, "Bookman"},
  {15, "N Helvetica Narrow"},
  {16, "Palatino"},
  {18, "Zapf Chancery"},
  {20, "Times"}, // Mac Almanac lists "Times Roman" here - same font?
  {21, "Helvetica"},
  {22, "Courier"},
  {23, "Symbol"},
  {24, "Taliesin"},
  {33, "Avant Garde"},
  {34, "New Century Schoolbook"},
  {169, "O Futura BookOblique"},
  {173, "L Futura Light"},
  {174, "Futura"},
  {176, "H Futura Heavy"},
  {177, "O Futura Oblique"},
  {179, "BO Futura BoldOblique"},
  {221, "HO Futura HeavyOblique"},
  {258, "ProFont"},
  {260, "LO Futura LightOblique"},
  {513, "ISO Latin Nr 1"},
  {514, "PCFont 437"},
  {515, "PCFont 850"},
  {1029, "VT80 Graphics"},
  {1030, "3270 Graphics"},
  {1109, "Trebuchet MS"},
  {1345, "ProFont"},
  {1895, "Nu Sans Regular"},
  {2001, "Arial"},
  {2002, "Charcoal"},
  {2003, "Capitals"},
  {2004, "Sand"},
  {2005, "Courier New"},
  {2006, "Techno"},
  {2010, "Times New Roman"},
  {2011, "Wingdings"},
  {2013, "Hoefler Text"},
  {2018, "Hoefler Text Ornaments"},
  {2039, "Impact"},
  {2040, "Skia"},
  {2305, "Textile"},
  {2307, "Gadget"},
  {2311, "Apple Chancery"},
  {2515, "MT Extra"},
  {4513, "Comic Sans MS"},
  {7092, "Monotype.com"},
  {7102, "Andale Mono"},
  {7203, "Verdana"},
  {9728, "Espi Sans"},
  {9729, "Charcoal"},
  {9840, "Espy Sans/Copland"},
  {9841, "Espi Sans Bold"},
  {9842, "Espy Sans Bold/Copland"},
  {10840, "Klang MT"},
  {10890, "Script MT Bold"},
  {10897, "Old English Text MT"},
  {10909, "New Berolina MT"},
  {10957, "Bodoni MT Ultra Bold"},
  {10967, "Arial MT Condensed Light"},
  {11103, "Lydian MT"},
  {12077, "Arial Black"},
  {12171, "Georgia"},
  {14868, "B Futura Bold"},
  {14870, "Futura Book"},
  {15011, "Gill Sans Condensed Bold"},
  {16383, "Chicago"},
};


const char* name_for_region_code(uint16_t region_code) {
  try {
    return REGION_NAMES.at(region_code).c_str();
  } catch (const out_of_range&) {
    return nullptr;
  }
}

const char* name_for_font_id(uint16_t font_id) {
  try {
    return STANDARD_FONT_NAMES.at(font_id).c_str();
  } catch (const out_of_range&) {
    return nullptr;
  }
}
