# Rekall Memory Forensics
#
# Copyright 2013 Google Inc. All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

"""The following modules were written and contributed by Michael Hale
(michael.hale@gmail.com)."""

# pylint: disable=unused-import
from rekall.plugins.windows.malware import apihooks
from rekall.plugins.windows.malware import callbacks
from rekall.plugins.windows.malware import cmdhistory
from rekall.plugins.windows.malware import devicetree

from rekall.plugins.windows.malware import malfind
from rekall.plugins.windows.malware import psxview
from rekall.plugins.windows.malware import svcscan
from rekall.plugins.windows.malware import timers

# These are optional plugins.
try:
    from rekall.plugins.windows.malware import yarascan
except (ImportError, OSError):
    pass

try:
    from rekall.plugins.windows.malware import impscan
except ImportError:
    pass

