# RPM Spec file for redwax-tool

Name:      redwax-tool
Version:   0.9.4
Release:   1%{?dist}
Summary:   The redwax tool
License:   Apache-2.0
Source0:   https://archive.redwax.eu/dist/rt/%{name}-%{version}/%{name}-%{version}.tar.bz2
Source1:   https://archive.redwax.eu/dist/rt/%{name}-%{version}/%{name}-%{version}.tar.bz2.asc
Source2:   https://source.redwax.eu/svn/dist/rt/keys/KEYS
Url:       https://redwax.eu/rs/
BuildRequires: gnupg2
BuildRequires: gcc
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: libtool
BuildRequires: pkgconfig(apr-1)
BuildRequires: pkgconfig(apr-util-1)
BuildRequires: pkgconfig(libcrypto)
BuildRequires: pkgconfig(nss)
BuildRequires: pkgconfig(p11-kit-1)
BuildRequires: pkgconfig(libical)

%description
The redwax tool allows certificates and keys in a range of formats to
be read, searched for, and converted into other formats as needed by
common services.

%prep
#%{gpgverify} --keyring='%{SOURCE2}' --signature='%{SOURCE1}' --data='%{SOURCE0}'
%setup -q
%build
%configure --with-openssl --with-nss --with-p11-kit --with-libical
%make_build

%install
%make_install

%files
%{_bindir}/redwax-tool
%{_mandir}/man1/redwax-tool.1*
%{_datadir}/bash-completion/completions/redwax-tool

%doc AUTHORS ChangeLog README
%license COPYING

%changelog
* Sun Oct 15 2023 Graham Leggett <minfrin@sharp.fm> 0.9.3-1
- Feature release
* Mon Jan 02 2023 Graham Leggett <minfrin@sharp.fm> 0.9.2-1
- Feature release
* Sat Dec 11 2021 Graham Leggett <minfrin@sharp.fm> 0.9.1-1
- Feature release
* Sat May 15 2021 Graham Leggett <minfrin@sharp.fm> 0.9.0-1
- Initial release
