(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    973068,      19786]
NotebookOptionsPosition[    953929,      19343]
NotebookOutlinePosition[    955044,      19382]
CellTagsIndexPosition[    955001,      19379]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "k"], "(", "z", ")"}], ")"}], "p"]}], "+", 
        FormBox[
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["sin", "k"], "(", "z", ")"}], ")"}], 
           RowBox[{"p", "+", "1"}]]}],
         TraditionalForm], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "k"], "(", "z", ")"}], ")"}], 
          RowBox[{"p", "+", "2"}]]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5104205799816856`*^9, 
   3.5104205799816856`*^9}, {3.51042064726178*^9, 3.51042064726178*^9}, {
   3.510430932928196*^9, 3.510430932928196*^9}, {3.5104309690182457`*^9, 
   3.5104309690182457`*^9}, {3.513276098729741*^9, 3.513276199639883*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, {
   3.5112011061268377`*^9, 3.5112011073768396`*^9}, {3.511212285215206*^9, 
   3.511212285425207*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], ")"}], 
     " ", "\[And]", " ", 
     RowBox[{"p", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "\[NotEqual]", 
      RowBox[{"-", "2"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, {
   3.5112290108595223`*^9, 3.511229013651927*^9}, {3.51136689934383*^9, 
   3.5113668999028625`*^9}, {3.5113670104881873`*^9, 
   3.5113670111482253`*^9}, {3.5113670572278605`*^9, 3.511367067961475*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511201148626897*^9, 
   3.511201158926912*^9}, {3.5112122887552114`*^9, 3.511212292085216*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.511201170036927*^9, 3.5112011883069525`*^9}, {
   3.5112122951352205`*^9, 3.5112123138152466`*^9}, 3.5112289863050795`*^9, {
   3.5113666146135445`*^9, 3.511366638167892*^9}, {3.5113666864416533`*^9, 
   3.511366700323447*^9}, {3.5113668917213945`*^9, 3.51136689286646*^9}, {
   3.511367002502731*^9, 3.5113670054298983`*^9}, {3.511386432891085*^9, 
   3.511386438656415*^9}, {3.5114555059153566`*^9, 3.511455518055373*^9}, 
   3.5114556555335703`*^9, {3.5114558768438807`*^9, 3.5114558795838842`*^9}, {
   3.5159837458643665`*^9, 3.5159837465195675`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.5112012175469937`*^9, 
   3.5112012236270027`*^9}, {3.511212320045255*^9, 3.511212324075261*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201229867011*^9, 
   3.511201242537029*^9}, 3.5112114174739914`*^9, {3.5112123276452656`*^9, 
   3.5112123398952827`*^9}, 3.5112289896590853`*^9, {3.5159838087468767`*^9, 
   3.5159838093708773`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}, {3.5112012676270638`*^9, 
   3.5112012715570693`*^9}, {3.5112123466952925`*^9, 3.5112123510752983`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, {
   3.511201275327075*^9, 3.5112012880170927`*^9}, {3.511212354405303*^9, 
   3.511212367895322*^9}, 3.5112289938554926`*^9, {3.515983773694815*^9, 
   3.5159837743656163`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}, {3.5112012949771023`*^9, 3.511201298807108*^9}, {
   3.5112123738353305`*^9, 3.5112123818253417`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, {3.511201302617113*^9, 
   3.5112013150571303`*^9}, {3.5112123855253468`*^9, 3.5112124008253684`*^9}, 
   3.511228999611902*^9, {3.515983777532422*^9, 3.5159837781252227`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, {
   3.5112011061268377`*^9, 3.5112011073768396`*^9}, {3.5112098352017765`*^9, 
   3.5112098354117765`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511201148626897*^9, 
   3.511201158926912*^9}, {3.511209837151779*^9, 3.5112098394717827`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.511201170036927*^9, 3.5112011883069525`*^9}, {
   3.511209841941786*^9, 3.5112098498717966`*^9}, {3.5159838221005*^9, 
   3.515983822677701*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.5112012175469937`*^9, 
   3.5112012236270027`*^9}, {3.5112098532418013`*^9, 3.511209855201804*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201229867011*^9, 
   3.511201242537029*^9}, {3.5112098579318085`*^9, 3.5112098652418184`*^9}, 
   3.511211448494035*^9, 3.5113711848689485`*^9, {3.5159838257353063`*^9, 
   3.5159838262969074`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}, {3.5112012676270638`*^9, 
   3.5112012715570693`*^9}, {3.511209868391823*^9, 3.5112098707618265`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, {
   3.511201275327075*^9, 3.5112012880170927`*^9}, {3.5112098736918306`*^9, 
   3.5112098823318424`*^9}, 3.51137117720651*^9, {3.5159838298225136`*^9, 
   3.5159838303529143`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}, {3.5112012949771023`*^9, 3.511201298807108*^9}, {
   3.5112098885518513`*^9, 3.511209891431855*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, {3.511201302617113*^9, 
   3.5112013150571303`*^9}, {3.5112098949618597`*^9, 3.5112099032118716`*^9}, 
   3.5113711708341455`*^9, {3.5159838350017223`*^9, 3.5159838355633235`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, {3.5111161445821643`*^9, 
   3.5111161460821667`*^9}, 3.511200996976685*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, 3.5111154304611645`*^9, 3.5111163225024137`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "1"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", "j"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.5111153261010184`*^9, 
   3.511115369591079*^9}, {3.511115571291362*^9, 3.5111155876513844`*^9}, {
   3.511116162302189*^9, 3.5111161676421967`*^9}, {3.511116242412301*^9, 
   3.5111162787323523`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "j"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111142326594877`*^9, 3.5111142764295487`*^9}, 3.5111154233811545`*^9, {
   3.5111155547813387`*^9, 3.5111155558113403`*^9}, {3.5111156446714644`*^9, 
   3.5111156889915266`*^9}, {3.511116181072215*^9, 3.511116195152235*^9}, {
   3.5111163356624317`*^9, 3.5111163692124786`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, {
   3.5112011061268377`*^9, 3.5112011073768396`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511201148626897*^9, 
   3.511201158926912*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.511201170036927*^9, 3.5112011883069525`*^9}, {
   3.5159838395101304`*^9, 3.5159838400561314`*^9}, {3.5159840122768335`*^9, 
   3.515984013244035*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.5112012175469937`*^9, 3.5112012236270027`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201229867011*^9, 
   3.511201242537029*^9}, 3.5112114174739914`*^9, 3.511376146360729*^9, {
   3.5159838458125415`*^9, 3.5159838463741426`*^9}, {3.5159840180644436`*^9, 
   3.515984019250046*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}, {3.5112012676270638`*^9, 
   3.5112012715570693`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, {
   3.511201275327075*^9, 3.5112012880170927`*^9}, 3.51137614043439*^9, {
   3.515983849150947*^9, 3.5159838497437487`*^9}, {3.515984023945654*^9, 
   3.5159840251000557`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}, {3.5112012949771023`*^9, 3.511201298807108*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, {3.511201302617113*^9, 
   3.5112013150571303`*^9}, 3.5113761348090687`*^9, {3.515983853518955*^9, 
   3.5159838540649557`*^9}, {3.515984029343263*^9, 3.5159840302636647`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], "p"]}], "+", 
        FormBox[
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], 
           RowBox[{"p", "+", "1"}]]}],
         TraditionalForm], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], 
          RowBox[{"p", "+", "2"}]]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["i", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5104193993820252`*^9, 
   3.5104193993820252`*^9}, {3.5104195441222277`*^9, 
   3.5104195441222277`*^9}, {3.5132762623299704`*^9, 3.5132763402300797`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5112018724979105`*^9, {3.511211607534258*^9, 
   3.511211607744258*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9, 
   3.5112017817877836`*^9, {3.5112289373989935`*^9, 3.5112289373989935`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.511201729687711*^9, 3.511201734337717*^9}, {
   3.5112116113542633`*^9, 3.5112116150742683`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", "p"}], 
      "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201742277728*^9, 
   3.511201759697753*^9}, {3.5112116216442776`*^9, 3.511211640134303*^9}, {
   3.511211731554431*^9, 3.5112117324544325`*^9}, 3.511228921284165*^9, {
   3.511367434476438*^9, 3.5113674665282717`*^9}, {3.5113865069813232`*^9, 
   3.5113865078103704`*^9}, 3.511456877965282*^9, {3.511457191805729*^9, 
   3.511457195275734*^9}, 3.5114575273661985`*^9, 3.511458120677029*^9, {
   3.5114581541070757`*^9, 3.5114581563670793`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9, 3.5112019108179646`*^9, {3.5112116753843527`*^9, 
   3.5112116755843525`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}, {3.511213929947509*^9, 3.5112139309375105`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}, {3.511213854567404*^9, 
   3.511213900557468*^9}, {3.5112152649193783`*^9, 3.5112152692793837`*^9}, {
   3.5112153014894295`*^9, 3.511215310669442*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "k"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.5112139514875393`*^9, 3.511213992877597*^9}, {3.5112152758293934`*^9, 
   3.511215285879407*^9}, {3.5112153275994654`*^9, 3.511215352669501*^9}, 
   3.5113688287111835`*^9, {3.5114573079058914`*^9, 3.5114573110058956`*^9}, 
   3.511457532836206*^9, 3.511457658516382*^9, {3.511458147797067*^9, 
   3.5114581501070704`*^9}, 3.513102204553969*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}, 3.51120197194805*^9, {3.511456934425361*^9, 
   3.511456934425361*^9}, {3.5114570427555127`*^9, 3.5114570453755164`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "+", "1"}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, {3.5112019325479946`*^9, 
   3.5112019368780007`*^9}, {3.5112116861043673`*^9, 3.511211690154373*^9}, {
   3.5112117596544704`*^9, 3.5112117681344824`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.511201941998008*^9, 3.511201960608034*^9}, {3.5112116947243795`*^9, 
   3.5112117273244257`*^9}, {3.5112117804544992`*^9, 3.5112118238045607`*^9}, 
   3.511368710352414*^9, {3.5113693054664526`*^9, 3.5113693092376685`*^9}, {
   3.5113864739734354`*^9, 3.5113864770386105`*^9}, {3.51145510127479*^9, 
   3.5114551132648067`*^9}, {3.511455157444868*^9, 3.51145516605488*^9}, {
   3.511455892943903*^9, 3.5114558950639057`*^9}, 3.511457032515498*^9, {
   3.511457314705901*^9, 3.5114573186159062`*^9}, 3.5114575372462125`*^9, {
   3.511458125697036*^9, 3.5114581430870605`*^9}, {3.515983861318969*^9, 
   3.5159838618649693`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5112018724979105`*^9, {3.511209624371481*^9, 
   3.5112096245614815`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9, 
   3.5112017817877836`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.511201729687711*^9, 3.511201734337717*^9}, {
   3.5112096279914865`*^9, 3.5112096317914915`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", "p"}], 
      "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201742277728*^9, 
   3.511201759697753*^9}, {3.511209636661498*^9, 3.511209646861513*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9, 3.5112019108179646`*^9, {3.5112096524415207`*^9, 
   3.511209652621521*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}, {3.5112147088785996`*^9, 3.5112147200886154`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{
         RowBox[{"-", "2"}], "k"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}, {3.51121451641833*^9, 
   3.5112145199783354`*^9}, {3.5112146493885164`*^9, 3.5112146679385424`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "*", "k"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", 
      RowBox[{"i2", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.51121452348834*^9, 3.5112145329283533`*^9}, {3.5112145681784024`*^9, 
   3.5112145735584097`*^9}, {3.511214679908559*^9, 3.5112147056285954`*^9}, 
   3.514404725953927*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}, 3.51120197194805*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, {3.5112019325479946`*^9, 
   3.5112019368780007`*^9}, {3.5112096704915457`*^9, 3.5112096737415504`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.511201941998008*^9, 3.511201960608034*^9}, {3.5112096775415554`*^9, 
   3.51120968755157*^9}, {3.511214827868766*^9, 3.511214829088768*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.51120094351661*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{
    "x", "  ", "\[LongRightArrow]", 
     "                                        ", "\[IndentingNewLine]", 
     "                    ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "l_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "k"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "l"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111142326594877`*^9, 3.5111142764295487`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5112018724979105`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9, 
   3.5112017817877836`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.511201729687711*^9, 3.511201734337717*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", "p"}], 
      "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511201742277728*^9, 
   3.511201759697753*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9, 3.5112019108179646`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}, {3.511213929947509*^9, 3.5112139309375105`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{
         RowBox[{"-", "2"}], "k"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}, {3.511213854567404*^9, 
   3.511213900557468*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "*", "k"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "i"}], "-", "i2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.5112139514875393`*^9, 3.511213992877597*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}, 3.51120197194805*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, {3.5112019325479946`*^9, 
   3.5112019368780007`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.511201941998008*^9, 3.511201960608034*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], "p"]}], "+", 
        FormBox[
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], 
           RowBox[{"p", "+", "1"}]]}],
         TraditionalForm], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["sin", "i"], "(", "z", ")"}], ")"}], 
          RowBox[{"p", "+", "2"}]]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["i", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["k", "2"]}], "=", "1"}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5132763701901217`*^9, 3.5132763869901447`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, {
   3.511210295782421*^9, 3.5112102959724216`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], ")"}], 
     " ", "\[And]", " ", 
     RowBox[{"p", "\[NotEqual]", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, {
   3.511225775030238*^9, 3.5112257813638496`*^9}, {3.511379735999045*^9, 
   3.511379735999045*^9}, {3.5114569624854*^9, 3.5114569638454027`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511210299142426*^9, 
   3.5112103025724306`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.511210306182436*^9, 3.5112103323724723`*^9}, 
   3.511225788493062*^9, 3.5113797090615044`*^9, {3.511385284966428*^9, 
   3.5113852891866693`*^9}, {3.5114569668054066`*^9, 
   3.5114569685554085`*^9}, {3.5159838713341866`*^9, 3.515983871880187*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.5112103403324833`*^9, 3.511210343572488*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511210348012494*^9, 
   3.511210360082511*^9}, 3.511211226713724*^9, 3.511225828678733*^9, {
   3.5159838754837933`*^9, 3.5159838760141945`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}, {3.5112103673825216`*^9, 
   3.5112103708925266`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, {
   3.511210375882533*^9, 3.5112104044725733`*^9}, 3.5112258361355457`*^9, {
   3.5159838794618006`*^9, 3.5159838799766016`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}, {3.5112104088225794`*^9, 3.5112104128825855`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, {3.51121041649259*^9, 
   3.511210428402607*^9}, 3.511225844933961*^9, {3.515983883658208*^9, 
   3.515983884188609*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9, {3.511210444412629*^9, 3.5112104445926294`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"j", " ", "k"}]}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}, {3.5112149408889246`*^9, 
   3.5112149440589285`*^9}, {3.5112149897289925`*^9, 3.5112149947089996`*^9}, 
   3.511215056449086*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.5112149509089384`*^9, 3.511214964478957*^9}, {3.5112150046890135`*^9, 
   3.511215014269027*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", "+", "k"}], "=", 
       RowBox[{"0", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], ")"}], 
     " ", "\[And]", " ", 
     RowBox[{"p", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "\[NotEqual]", 
      RowBox[{"-", "2"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51137077542653*^9, 
   3.51137077542653*^9}, {3.5113710102059584`*^9, 3.5113710102059584`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"j", " ", "k", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112104475526333`*^9, 3.5112104837426844`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"j", "*", "k", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "+", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.51121100912342*^9, 
   3.5112110493434763`*^9}, 3.5112151798192587`*^9, 3.511370592615073*^9, 
   3.511370989094751*^9, {3.5113864030003757`*^9, 3.5113864061735573`*^9}, {
   3.511456463014701*^9, 3.5114564655147047`*^9}, {3.5159838886814165`*^9, 
   3.5159838892118177`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "-", "m", "+", "1"}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, {3.511210499272706*^9, 
   3.5112105144127274`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m", "+", "1"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5112110555034847`*^9, 3.5112110641434965`*^9}, 3.5112111800936594`*^9, {
   3.5112121344249954`*^9, 3.511212147665014*^9}, 3.5113709817493305`*^9, {
   3.515983892862224*^9, 3.515983893361425*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"p", "-", "m", "+", "1"}]], 
     RowBox[{"(", 
      RowBox[{"B", "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9, {
   3.511210519912735*^9, 3.5112105339527545`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m", "+", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, {3.511211070143505*^9, 3.5112110840235248`*^9}, {
   3.511211132003592*^9, 3.511211139313602*^9}, {3.5112121645650377`*^9, 
   3.511212175275052*^9}, 3.5113709784931445`*^9, {3.515983896885831*^9, 
   3.5159838973850317`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9, {3.5111992857042894`*^9, 
   3.5111992916342974`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"m", "-", "p", "-", "1"}]], 
     RowBox[{"(", 
      RowBox[{"B", "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9, {
   3.511199096174024*^9, 3.511199127114067*^9}, {3.5112105383227606`*^9, 
   3.5112105607527924`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p", "-", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"B", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, 3.511199220914199*^9, {3.5111992556142473`*^9, 
   3.511199276954277*^9}, 3.511199317694334*^9, {3.511211089923533*^9, 
   3.511211102683551*^9}, {3.511212188645071*^9, 3.5112121917050753`*^9}, 
   3.511370974734929*^9, {3.515983900832638*^9, 3.5159839013318386`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, {
   3.511209129125947*^9, 3.511209129344348*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.5112091333223543`*^9, 
   3.5112091358807592`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5112091397963657`*^9, 3.5112091475807796`*^9}, {
   3.5112092216185093`*^9, 3.511209222460911*^9}, {3.515983904483044*^9, 
   3.5159839049822454`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}, {3.5112092472009535`*^9, 3.5112092501609573`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, {3.511209254570964*^9, 
   3.5112092645909777`*^9}, 3.5112114772740755`*^9, 3.5113762163847346`*^9, {
   3.515983908195851*^9, 3.5159839087262516`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}, {3.51120927352099*^9, 
   3.5112092781709967`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, {
   3.511209282241002*^9, 3.511209291461015*^9}, 3.511376219707925*^9, {
   3.515983913047459*^9, 3.51598391356226*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}, {3.511209298401025*^9, 3.51120930221103*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, {3.511209310151041*^9, 
   3.511209319381054*^9}, 3.5113762258372755`*^9, {3.515983916900666*^9, 
   3.515983917399867*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9, {3.5112093382910805`*^9, 3.511209338471081*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"2", "j", " ", "k"}]}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}, {3.51121451641833*^9, 
   3.5112145199783354`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", 
      RowBox[{"i2", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.51121452348834*^9, 3.5112145329283533`*^9}, {3.5112145681784024`*^9, 
   3.5112145735584097`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", "+", "k"}], "=", 
       RowBox[{"0", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"j", " ", "k", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.511209341571085*^9, 3.51120934487109*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"j", "*", "k", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "+", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.5112093494010963`*^9, 
   3.5112093595311103`*^9}, 3.5112147736586905`*^9, {3.515983922126675*^9, 
   3.515983922625876*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "-", "m", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, {3.5112093640411167`*^9, 
   3.5112093674211216`*^9}, 3.511209399531166*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m", "+", "2"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5112093703511257`*^9, 3.5112093743511314`*^9}, {3.511209422911199*^9, 
   3.5112094372712193`*^9}, 3.5112114888340917`*^9, 3.511371110701706*^9, {
   3.5159839261826825`*^9, 3.5159839267286835`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"p", "-", "m", "+", "2"}]], 
     RowBox[{"(", 
      RowBox[{"C", "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9, {
   3.5112094681212626`*^9, 3.5112094714212675`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m", "+", "2"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, {3.511209474941272*^9, 3.5112094853412867`*^9}, 
   3.5112114923240967`*^9, 3.5113711186711617`*^9, {3.515983930145089*^9, 
   3.51598393064429*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9, {3.5111992857042894`*^9, 
   3.5111992916342974`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"m", "-", "p", "-", "2"}]], 
     RowBox[{"(", 
      RowBox[{"C", "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9, {
   3.511199096174024*^9, 3.511199127114067*^9}, {3.5112094896212926`*^9, 
   3.511209493351298*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p", "-", "2"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", ",", 
        "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, 3.511199220914199*^9, {3.5111992556142473`*^9, 
   3.511199276954277*^9}, 3.511199317694334*^9, {3.511209498101304*^9, 
   3.511209507851318*^9}, 3.5113711240614705`*^9, {3.515983934450697*^9, 
   3.515983934996698*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.5111994324044943`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, 3.5111154304611645`*^9, {3.511191835643859*^9, 
   3.511191835643859*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"j", " ", "k"}]}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.5111153261010184`*^9, 
   3.511115369591079*^9}, {3.511115571291362*^9, 3.5111155876513844`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "l_."}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "l"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111142326594877`*^9, 3.5111142764295487`*^9}, 3.5111154233811545`*^9, {
   3.5111155547813387`*^9, 3.5111155558113403`*^9}, {3.5111156446714644`*^9, 
   3.5111156889915266`*^9}, {3.515984075815745*^9, 3.5159840769389467`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{"j", "=", 
       RowBox[{"k", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k", " ", "p"}]}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k", "*", "p"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "-", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5159839434207125`*^9, 3.5159839440447135`*^9}, {
   3.515984087281765*^9, 3.5159840883581667`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511190188981554*^9, 
   3.511190190071555*^9}, {3.511190241921628*^9, 3.511190242561629*^9}, {
   3.511191494013381*^9, 3.5111914999633894`*^9}, {3.511191792023798*^9, 
   3.5111918103338237`*^9}, {3.511191854613886*^9, 3.511191890643936*^9}, 
   3.511194153217104*^9, {3.5111942557772474`*^9, 3.51119427177727*^9}, {
   3.5111965416004477`*^9, 3.5111965495304585`*^9}, 3.511198296882905*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
        RowBox[{"p", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.511189920401178*^9, 3.511189937011201*^9}, 3.5111900251913247`*^9, {
   3.511190062411377*^9, 3.5111900707013884`*^9}, {3.5111901359814796`*^9, 
   3.511190137451482*^9}, {3.5111914779133587`*^9, 3.511191479783361*^9}, {
   3.5111916181435547`*^9, 3.5111916192335563`*^9}, {3.511194175567135*^9, 
   3.511194176157136*^9}, {3.5111942465972347`*^9, 3.511194247647236*^9}, {
   3.511194331757354*^9, 3.5111943446173716`*^9}, {3.511196535260439*^9, 
   3.5111965358004394`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.5111902018615723`*^9, 3.511190232401615*^9}, {3.511190266931663*^9, 
   3.5111902954717026`*^9}, {3.5111905058119974`*^9, 3.511190509102002*^9}, {
   3.511191484153367*^9, 3.511191512043406*^9}, {3.5111919637840385`*^9, 
   3.511192011354105*^9}, {3.5111943864074306`*^9, 3.511194397667446*^9}, {
   3.5111944673675437`*^9, 3.5111944968775845`*^9}, 3.5112113638739166`*^9, 
   3.5113759359036922`*^9, {3.515983947991521*^9, 3.515983949177123*^9}, {
   3.5159840951597786`*^9, 3.515984096220581*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"p", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511196784420788*^9, 3.5111968455308733`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111969898310747`*^9, 
   3.5111970145211096`*^9}, 3.511197099151228*^9, 3.511197184721348*^9, 
   3.511375940275942*^9, {3.515983952328328*^9, 3.515983952921129*^9}, {
   3.51598410125939*^9, 3.5159841022577915`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.5111249261444583`*^9, 
   3.511124946714487*^9}, {3.5111250395746174`*^9, 3.511125046164626*^9}, {
   3.5111268362071323`*^9, 3.5111268431871424`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"-", "k"}]], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"m", "-", "p"}]], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.511198563893279*^9, 
   3.5111985927333193`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"C", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "+", "k"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111987382835226`*^9, 3.511198754593546*^9}, {
   3.511198790993597*^9, 3.511198805903618*^9}, 3.5113759460232706`*^9, {
   3.515983956477936*^9, 3.5159839570395365`*^9}, {3.515984107203*^9, 
   3.5159841082014017`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, 
   3.5105108931743116`*^9, {3.510510980628065*^9, 3.5105109860880747`*^9}, 
   3.510511577329113*^9, {3.510511636328417*^9, 3.51051164403483*^9}, {
   3.511112459377005*^9, 3.511112474977027*^9}, 3.511113418028347*^9, 
   3.511114386609703*^9, 3.5111145875299845`*^9, 3.511197235491419*^9, 
   3.51119740762166*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}, {3.51121308088632*^9, 
   3.5112130817363214`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{"A", "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"-", "k"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"2", "j", " ", "k"}]}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}, {
   3.5112130912263346`*^9, 3.5112131460264115`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"2", "*", "j", "*", "k"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "i"}], "-", "i2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, {3.511213234946536*^9, 
   3.5112132352265368`*^9}, 3.5112132660865793`*^9, {3.511213334986676*^9, 
   3.5112133897867527`*^9}, {3.511213439166822*^9, 3.5112134855368867`*^9}, {
   3.5159839619379454`*^9, 3.5159839625931463`*^9}, {3.51598411860662*^9, 
   3.515984119651822*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", "+", "k"}], "=", 
       RowBox[{"0", " ", "\[Or]", " ", 
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}], 
      ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, {3.511195723589302*^9, 3.511195756819349*^9}, {
   3.5111960500697594`*^9, 3.5111960500697594`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "-", 
         RowBox[{"j", " ", "k", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, {3.5111956932392597`*^9, 
   3.511195694919262*^9}, {3.5111958230894413`*^9, 3.5111958324194546`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_."}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"j", "*", "k", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"j", "+", "k"}], "]"}], " ", "||", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.511196020579718*^9, 3.5111960294497304`*^9}, {
   3.511196101609832*^9, 3.5111961911099567`*^9}, 3.511213396986763*^9, {
   3.5159839661187525`*^9, 3.5159839666491537`*^9}, {3.515984139861457*^9, 
   3.515984140922259*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic normalization", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5004189578946524`*^9, 3.5004189613818517`*^9}, 
   3.500669295019554*^9, {3.511112549367131*^9, 3.5111125520571346`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, {3.5111982196727967`*^9, 
   3.5111982359428196`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"-", "k"}]], ")"}], 
        RowBox[{"p", "-", "m", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"C", "+", 
         RowBox[{"B", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
         RowBox[{"A", " ", 
          SuperscriptBox[
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], 
           RowBox[{"2", "k"}]]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "m", "+", "2"}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"C", "+", 
        RowBox[{"B", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
        RowBox[{"A", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, 
   3.511211342793887*^9, 3.5113760065817347`*^9, {3.51598397017476*^9, 
   3.5159839707051606`*^9}, {3.515984145493067*^9, 3.515984146553869*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"p", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"-", "k"}]], ")"}], 
      RowBox[{"p", "-", "m", "+", "2"}]], 
     RowBox[{"(", 
      RowBox[{"C", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"-", "k"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "m", "+", "2"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "p", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, 3.511211336093878*^9, 3.5113760022054844`*^9, {
   3.515983974339967*^9, 3.515983974901568*^9}, {3.5159841520762787`*^9, 
   3.51598415305908*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic normalization\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5095837949535475`*^9, 3.5095837995035543`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sec", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"Cos", "[", "z", "]"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"2", "m"}], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5017252894174128`*^9, 
   3.5017252894174128`*^9}, {3.5034234948205976`*^9, 
   3.5034234958505993`*^9}, {3.504318033545261*^9, 3.504318033545261*^9}, {
   3.5043200267259626`*^9, 3.504320029455968*^9}, {3.5043222709590693`*^9, 
   3.504322274669074*^9}, {3.5043238597527943`*^9, 3.5043238597527943`*^9}, 
   3.504325967285698*^9, {3.504327248529565*^9, 3.5043272494343667`*^9}, {
   3.504750575866756*^9, 3.504750577356758*^9}, {3.504988931531271*^9, 
   3.504988932031272*^9}, {3.5087861857030487`*^9, 3.508786186173049*^9}, {
   3.509483828436615*^9, 3.509483828436615*^9}, {3.5099361396188493`*^9, 
   3.5099361398688498`*^9}, {3.5105051692446575`*^9, 3.5105051696814585`*^9}, 
   3.511113486808443*^9, {3.5111150271406*^9, 3.5111150754606676`*^9}, {
   3.511115123680735*^9, 3.5111151389607563`*^9}, {3.511137607991807*^9, 
   3.511137612391015*^9}, {3.5111377271760163`*^9, 3.5111377324644256`*^9}, 
   3.511137864050657*^9, 3.5111391684985485`*^9, {3.511193076295596*^9, 
   3.511193098355627*^9}, 3.5111935403262453`*^9, 3.5111975108018045`*^9, 
   3.511198096892625*^9, 3.511198265712861*^9, {3.5111992857042894`*^9, 
   3.5111992916342974`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"A", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], "p"]}], "+", 
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "1"}]]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"-", "k"}]], ")"}], 
       RowBox[{"p", "+", "2"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"], ")"}], 
      RowBox[{"m", "-", "p", "-", "2"}]], 
     RowBox[{"(", 
      RowBox[{"C", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
       RowBox[{"A", " ", 
        SuperscriptBox[
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.500576683516921*^9, 
   3.5005767522194414`*^9}, 3.5005768662088413`*^9, {3.500576963144212*^9, 
   3.5005769810686436`*^9}, {3.5005783083557744`*^9, 
   3.5005783140809846`*^9}, {3.500578347153043*^9, 3.5005783783374977`*^9}, {
   3.5007781247656803`*^9, 3.5007781247656803`*^9}, {3.500778236181076*^9, 
   3.500778236181076*^9}, {3.511112554947139*^9, 3.5111125915871897`*^9}, {
   3.5111130655578537`*^9, 3.5111131345579505`*^9}, {3.511113630078644*^9, 
   3.511113639538657*^9}, {3.511113673018704*^9, 3.511113718328768*^9}, {
   3.5111137565488214`*^9, 3.5111137588888245`*^9}, 3.511114597659999*^9, {
   3.511114716200165*^9, 3.5111147313201857`*^9}, {3.511115179930814*^9, 
   3.5111151897608275`*^9}, {3.5111155993514013`*^9, 3.511115599511401*^9}, {
   3.5111249069744315`*^9, 3.5111249076144323`*^9}, {3.5111249888045464`*^9, 
   3.511125021594592*^9}, {3.5111250707846613`*^9, 3.511125075034667*^9}, {
   3.511126894657214*^9, 3.5111269044872284`*^9}, {3.5111350542281203`*^9, 
   3.5111351589199047`*^9}, 3.5111362505650225`*^9, {3.5111362874902873`*^9, 
   3.511136290594692*^9}, {3.5111372939632554`*^9, 3.5111372962252593`*^9}, {
   3.5111373280025153`*^9, 3.5111373320273223`*^9}, {3.5111373764718003`*^9, 
   3.511137394864233*^9}, {3.5111374408843136`*^9, 3.511137443473918*^9}, {
   3.5111375571201177`*^9, 3.5111375619717264`*^9}, 3.511137644293071*^9, {
   3.5111396125349293`*^9, 3.511139664483021*^9}, {3.511139913553058*^9, 
   3.511139949823122*^9}, {3.5111928392752647`*^9, 3.5111929007053504`*^9}, {
   3.511193001845492*^9, 3.511193004885496*^9}, 3.5111937524865427`*^9, {
   3.5111938570666895`*^9, 3.511193861996696*^9}, 3.5111976797420406`*^9, {
   3.511199096174024*^9, 3.511199127114067*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}], ")"}], "^", 
      "m_."}], "*", "\n", "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "p_"}]}], "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "q_"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "i_."}], ")"}], "^", 
         "r_"}]}]}], ")"}], "*", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "p", "-", "2"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"C", "+", 
          RowBox[{"B", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "+", 
          RowBox[{"A", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", ",", 
        "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "+", "i"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "1", "-", "q"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", "2", "-", "r"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"2", "*", "m"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.500578518644144*^9, 
   3.5005785216237493`*^9}, {3.5005786284059367`*^9, 
   3.5005786375787525`*^9}, {3.5007781247812805`*^9, 
   3.5007781247812805`*^9}, {3.500778236181076*^9, 3.500778236181076*^9}, {
   3.5111126057972097`*^9, 3.5111126731673045`*^9}, {3.5111131636979914`*^9, 
   3.5111131656279936`*^9}, {3.511113218588068*^9, 3.5111132273780804`*^9}, {
   3.511113299198181*^9, 3.5111133068081913`*^9}, {3.511113337168234*^9, 
   3.5111133767182894`*^9}, {3.5111134557883997`*^9, 
   3.5111134592584047`*^9}, {3.5111135067984715`*^9, 3.511113523828495*^9}, {
   3.5111137862688627`*^9, 3.5111137877688646`*^9}, {3.5111139999091616`*^9, 
   3.511114066159254*^9}, {3.5111140986493*^9, 3.5111142047394485`*^9}, 
   3.5111151596907854`*^9, {3.5111152776209507`*^9, 3.5111152983309793`*^9}, {
   3.511115457161202*^9, 3.511115472931224*^9}, {3.5111155133512807`*^9, 
   3.5111155280013013`*^9}, {3.511117880264594*^9, 3.5111178847446003`*^9}, {
   3.511125263844931*^9, 3.5111253564650607`*^9}, {3.5111268610871677`*^9, 
   3.5111268681371775`*^9}, {3.5111272637177315`*^9, 
   3.5111272763777485`*^9}, {3.5111354489088135`*^9, 
   3.5111355050689125`*^9}, {3.511135569871426*^9, 3.5111355754406357`*^9}, {
   3.511135673065607*^9, 3.511135687183632*^9}, {3.5111357283365045`*^9, 
   3.5111357569469547`*^9}, {3.5111358017502337`*^9, 3.511135818551463*^9}, {
   3.51113630067231*^9, 3.5111363238539505`*^9}, 3.5111363645700226`*^9, 
   3.5111378210101814`*^9, {3.5111378528030367`*^9, 3.5111379013191223`*^9}, {
   3.5111394101273727`*^9, 3.511139428738206*^9}, 3.5111400459348907`*^9, {
   3.511192224124403*^9, 3.5111922250744047`*^9}, {3.511193172685731*^9, 
   3.5111932316558137`*^9}, {3.5111939246367836`*^9, 3.511193932526795*^9}, 
   3.5111940277269278`*^9, {3.511196355520187*^9, 3.511196391220237*^9}, {
   3.5111974863917704`*^9, 3.5111974902817755`*^9}, {3.5111981659027214`*^9, 
   3.511198167142723*^9}, 3.511199220914199*^9, {3.5111992556142473`*^9, 
   3.511199276954277*^9}, 3.511199317694334*^9, 3.5113759971481953`*^9, {
   3.5159839786299744`*^9, 3.5159839792227755`*^9}, {3.515984157442688*^9, 
   3.5159841583942895`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"SubstInertSineForTrigOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FunctionOfTrigOfLinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"SubstInertSineForTrigOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"FunctionOfTrigOfLinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}, {
   3.511224412138645*^9, 3.511224459952729*^9}, {3.5112247828212953`*^9, 
   3.5112247891081057`*^9}, {3.5153733055764923`*^9, 3.5153733240469246`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Defer", "[", 
    RowBox[{"Int", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
   RowBox[{"RecognizedFunctionOfTrigQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5005768946008916`*^9, 
   3.500576904054508*^9}, 3.5005769484801865`*^9, {3.500577003361083*^9, 
   3.5005770076666903`*^9}, 3.500577043687154*^9, {3.5005784813288784`*^9, 
   3.500578485041685*^9}, {3.5005785720118375`*^9, 3.5005785894838686`*^9}, {
   3.500578654785583*^9, 3.500578654957183*^9}, {3.5005791027295704`*^9, 
   3.5005791187351985`*^9}, {3.5005792433794174`*^9, 
   3.5005792510546308`*^9}, {3.500579581868812*^9, 3.5005795833196144`*^9}, 
   3.500581118721512*^9, {3.5032553858206377`*^9, 3.503255411215082*^9}, 
   3.5032572835467696`*^9, {3.503454522386518*^9, 3.503454525834124*^9}, {
   3.503454771951979*^9, 3.5034547794544086`*^9}, {3.5066501623538513`*^9, 
   3.506650207258421*^9}, {3.506650265992877*^9, 3.5066503468190994`*^9}, {
   3.506650454624115*^9, 3.5066504606627984`*^9}, {3.5066504960036163`*^9, 
   3.5066505342486095`*^9}, 3.506650568347642*^9, {3.5066505989616623`*^9, 
   3.5066506013150463`*^9}, {3.5066506399506016`*^9, 3.506650676012456*^9}, {
   3.5066507745741806`*^9, 3.506650800150958*^9}, {3.506650856071368*^9, 
   3.5066509335928383`*^9}, 3.5066509853272285`*^9, {3.5066510269270463`*^9, 
   3.5066511619111443`*^9}, {3.5066512171005025`*^9, 
   3.5066512359676323`*^9}, {3.5066514749813166`*^9, 3.506651554495653*^9}, {
   3.5066516014031024`*^9, 3.506651610426077*^9}, {3.5071767645133343`*^9, 
   3.5071767712033434`*^9}, {3.514139631334648*^9, 3.514139633264651*^9}, {
   3.51413967546471*^9, 3.5141396786947145`*^9}},
 Background->GrayLevel[0.85]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Trig Normalization", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.3999998569488525`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 4328, 90, 162, "Title"],
Cell[CellGroupData[{
Cell[4920, 116, 2467, 53, 63, "Subsubtitle"],
Cell[7390, 171, 1073, 14, 35, "Subsubsection"],
Cell[8466, 187, 3349, 56, 26, "Subsubsection"],
Cell[11818, 245, 4876, 94, 101, "Subsubtitle"],
Cell[16697, 341, 818, 11, 35, "Subsubsection"],
Cell[17518, 354, 6152, 125, 129, "Code"],
Cell[23673, 481, 89, 2, 35, "Subsubsection"],
Cell[23765, 485, 1073, 14, 25, "Subsubsection"],
Cell[24841, 501, 3082, 48, 26, "Subsubsection"],
Cell[27926, 551, 5062, 97, 101, "Subsubtitle"],
Cell[32991, 650, 818, 11, 35, "Subsubsection"],
Cell[33812, 663, 5720, 116, 129, "Code"],
Cell[39535, 781, 89, 2, 35, "Subsubsection"],
Cell[39627, 785, 1041, 15, 25, "Subsubsection"],
Cell[40671, 802, 762, 19, 39, "Subsubsection"],
Cell[41436, 823, 2838, 46, 39, "Subsubsection"],
Cell[44277, 871, 4970, 101, 101, "Subsubtitle"],
Cell[49250, 974, 818, 11, 35, "Subsubsection"],
Cell[50071, 987, 5955, 127, 154, "Code"],
Cell[56029, 1116, 89, 2, 35, "Subsubsection"],
Cell[56121, 1120, 1041, 15, 25, "Subsubsection"],
Cell[57165, 1137, 762, 19, 39, "Subsubsection"],
Cell[57930, 1158, 2913, 48, 39, "Subsubsection"],
Cell[60846, 1208, 5044, 103, 101, "Subsubtitle"],
Cell[65893, 1313, 818, 11, 35, "Subsubsection"],
Cell[66714, 1326, 6088, 129, 154, "Code"],
Cell[72805, 1457, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[72886, 1463, 2471, 53, 63, "Subsubtitle"],
Cell[75360, 1518, 1073, 14, 35, "Subsubsection"],
Cell[76436, 1534, 3001, 50, 26, "Subsubsection"],
Cell[79440, 1586, 4903, 95, 101, "Subsubtitle"],
Cell[84346, 1683, 818, 11, 35, "Subsubsection"],
Cell[85167, 1696, 5726, 120, 129, "Code"],
Cell[90896, 1818, 89, 2, 35, "Subsubsection"],
Cell[90988, 1822, 1073, 14, 25, "Subsubsection"],
Cell[92064, 1838, 3082, 48, 26, "Subsubsection"],
Cell[95149, 1888, 5091, 98, 101, "Subsubtitle"],
Cell[100243, 1988, 818, 11, 35, "Subsubsection"],
Cell[101064, 2001, 5779, 118, 129, "Code"],
Cell[106846, 2121, 89, 2, 35, "Subsubsection"],
Cell[106938, 2125, 1041, 15, 25, "Subsubsection"],
Cell[107982, 2142, 762, 19, 39, "Subsubsection"],
Cell[108747, 2163, 2838, 46, 39, "Subsubsection"],
Cell[111588, 2211, 4993, 102, 101, "Subsubtitle"],
Cell[116584, 2315, 818, 11, 35, "Subsubsection"],
Cell[117405, 2328, 6024, 129, 154, "Code"],
Cell[123432, 2459, 89, 2, 35, "Subsubsection"],
Cell[123524, 2463, 1041, 15, 25, "Subsubsection"],
Cell[124568, 2480, 762, 19, 39, "Subsubsection"],
Cell[125333, 2501, 2913, 48, 39, "Subsubsection"],
Cell[128249, 2551, 5067, 104, 101, "Subsubtitle"],
Cell[133319, 2657, 818, 11, 35, "Subsubsection"],
Cell[134140, 2670, 6158, 131, 154, "Code"],
Cell[140301, 2803, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[140382, 2809, 2263, 47, 63, "Subsubtitle"],
Cell[142648, 2858, 1073, 14, 35, "Subsubsection"],
Cell[143724, 2874, 2453, 38, 26, "Subsubsection"],
Cell[146180, 2914, 4327, 86, 101, "Subsubtitle"],
Cell[150510, 3002, 818, 11, 35, "Subsubsection"],
Cell[151331, 3015, 4747, 100, 104, "Code"],
Cell[156081, 3117, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[156162, 3123, 2667, 60, 63, "Subsubtitle"],
Cell[158832, 3185, 1073, 14, 35, "Subsubsection"],
Cell[159908, 3201, 3001, 50, 26, "Subsubsection"],
Cell[162912, 3253, 5283, 108, 101, "Subsubtitle"],
Cell[168198, 3363, 818, 11, 35, "Subsubsection"],
Cell[169019, 3376, 6282, 136, 154, "Code"],
Cell[175304, 3514, 89, 2, 35, "Subsubsection"],
Cell[175396, 3518, 1073, 14, 25, "Subsubsection"],
Cell[176472, 3534, 3082, 48, 26, "Subsubsection"],
Cell[179557, 3584, 5467, 110, 101, "Subsubtitle"],
Cell[185027, 3696, 818, 11, 35, "Subsubsection"],
Cell[185848, 3709, 6327, 134, 154, "Code"],
Cell[192178, 3845, 89, 2, 35, "Subsubsection"],
Cell[192270, 3849, 1041, 15, 25, "Subsubsection"],
Cell[193314, 3866, 762, 19, 39, "Subsubsection"],
Cell[194079, 3887, 2838, 46, 39, "Subsubsection"],
Cell[196920, 3935, 5363, 115, 101, "Subsubtitle"],
Cell[202286, 4052, 818, 11, 35, "Subsubsection"],
Cell[203107, 4065, 6580, 145, 179, "Code"],
Cell[209690, 4212, 89, 2, 35, "Subsubsection"],
Cell[209782, 4216, 1041, 15, 25, "Subsubsection"],
Cell[210826, 4233, 762, 19, 39, "Subsubsection"],
Cell[211591, 4254, 2913, 48, 39, "Subsubsection"],
Cell[214507, 4304, 5433, 116, 101, "Subsubtitle"],
Cell[219943, 4422, 818, 11, 35, "Subsubsection"],
Cell[220764, 4435, 6714, 147, 179, "Code"],
Cell[227481, 4584, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[227574, 4591, 4301, 91, 124, "Title"],
Cell[CellGroupData[{
Cell[231900, 4686, 2457, 54, 63, "Subsubtitle"],
Cell[234360, 4742, 1073, 14, 35, "Subsubsection"],
Cell[235436, 4758, 3050, 47, 26, "Subsubsection"],
Cell[238489, 4807, 5348, 105, 101, "Subsubtitle"],
Cell[243840, 4914, 818, 11, 35, "Subsubsection"],
Cell[244661, 4927, 6182, 128, 104, "Code"],
Cell[250846, 5057, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[250927, 5063, 2582, 57, 63, "Subsubtitle"],
Cell[253512, 5122, 1073, 14, 35, "Subsubsection"],
Cell[254588, 5138, 2902, 44, 26, "Subsubsection"],
Cell[257493, 5184, 5569, 102, 101, "Subsubtitle"],
Cell[263065, 5288, 818, 11, 35, "Subsubsection"],
Cell[263886, 5301, 6391, 124, 104, "Code"],
Cell[270280, 5427, 89, 2, 35, "Subsubsection"],
Cell[270372, 5431, 1073, 14, 25, "Subsubsection"],
Cell[271448, 5447, 3057, 48, 26, "Subsubsection"],
Cell[274508, 5497, 5921, 115, 101, "Subsubtitle"],
Cell[280432, 5614, 818, 11, 35, "Subsubsection"],
Cell[281253, 5627, 7155, 145, 129, "Code"],
Cell[288411, 5774, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[288492, 5780, 2459, 54, 63, "Subsubtitle"],
Cell[290954, 5836, 1073, 14, 35, "Subsubsection"],
Cell[292030, 5852, 2926, 45, 26, "Subsubsection"],
Cell[294959, 5899, 5375, 106, 101, "Subsubtitle"],
Cell[300337, 6007, 818, 11, 35, "Subsubsection"],
Cell[301158, 6020, 5758, 121, 129, "Code"],
Cell[306919, 6143, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[307000, 6149, 2580, 57, 63, "Subsubtitle"],
Cell[309583, 6208, 1073, 14, 35, "Subsubsection"],
Cell[310659, 6224, 2904, 44, 26, "Subsubsection"],
Cell[313566, 6270, 5599, 104, 101, "Subsubtitle"],
Cell[319168, 6376, 818, 11, 35, "Subsubsection"],
Cell[319989, 6389, 6191, 122, 104, "Code"],
Cell[326183, 6513, 89, 2, 35, "Subsubsection"],
Cell[326275, 6517, 1073, 14, 25, "Subsubsection"],
Cell[327351, 6533, 2802, 43, 26, "Subsubsection"],
Cell[330156, 6578, 5896, 115, 101, "Subsubtitle"],
Cell[336055, 6695, 818, 11, 35, "Subsubsection"],
Cell[336876, 6708, 6495, 134, 104, "Code"],
Cell[343374, 6844, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[343455, 6850, 2281, 49, 63, "Subsubtitle"],
Cell[345739, 6901, 1073, 14, 35, "Subsubsection"],
Cell[346815, 6917, 2405, 38, 26, "Subsubsection"],
Cell[349223, 6957, 4567, 97, 101, "Subsubtitle"],
Cell[353793, 7056, 818, 11, 35, "Subsubsection"],
Cell[354614, 7069, 4963, 109, 104, "Code"],
Cell[359580, 7180, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[359661, 7186, 2657, 61, 63, "Subsubtitle"],
Cell[362321, 7249, 1073, 14, 35, "Subsubsection"],
Cell[363397, 7265, 2926, 45, 26, "Subsubsection"],
Cell[366326, 7312, 5749, 118, 101, "Subsubtitle"],
Cell[372078, 7432, 818, 11, 35, "Subsubsection"],
Cell[372899, 7445, 6239, 136, 129, "Code"],
Cell[379141, 7583, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[379222, 7589, 2803, 65, 63, "Subsubtitle"],
Cell[382028, 7656, 1073, 14, 35, "Subsubsection"],
Cell[383104, 7672, 2902, 44, 26, "Subsubsection"],
Cell[386009, 7718, 5907, 115, 101, "Subsubtitle"],
Cell[391919, 7835, 818, 11, 35, "Subsubsection"],
Cell[392740, 7848, 6505, 132, 104, "Code"],
Cell[399248, 7982, 89, 2, 35, "Subsubsection"],
Cell[399340, 7986, 1073, 14, 25, "Subsubsection"],
Cell[400416, 8002, 2802, 43, 26, "Subsubsection"],
Cell[403221, 8047, 6299, 129, 101, "Subsubtitle"],
Cell[409523, 8178, 818, 11, 35, "Subsubsection"],
Cell[410344, 8191, 6939, 148, 129, "Code"],
Cell[417286, 8341, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[417379, 8348, 4411, 96, 124, "Title"],
Cell[CellGroupData[{
Cell[421815, 8448, 2654, 60, 63, "Subsubtitle"],
Cell[424472, 8510, 1073, 14, 35, "Subsubsection"],
Cell[425548, 8526, 3209, 53, 26, "Subsubsection"],
Cell[428760, 8581, 5340, 110, 101, "Subsubtitle"],
Cell[434103, 8693, 818, 11, 35, "Subsubsection"],
Cell[434924, 8706, 6358, 137, 154, "Code"],
Cell[441285, 8845, 89, 2, 35, "Subsubsection"],
Cell[441377, 8849, 1073, 14, 25, "Subsubsection"],
Cell[442453, 8865, 3082, 48, 26, "Subsubsection"],
Cell[445538, 8915, 5520, 112, 101, "Subsubtitle"],
Cell[451061, 9029, 818, 11, 35, "Subsubsection"],
Cell[451882, 9042, 6252, 133, 154, "Code"],
Cell[458137, 9177, 89, 2, 35, "Subsubsection"],
Cell[458229, 9181, 1041, 15, 25, "Subsubsection"],
Cell[459273, 9198, 762, 19, 39, "Subsubsection"],
Cell[460038, 9219, 2838, 46, 39, "Subsubsection"],
Cell[462879, 9267, 5414, 117, 101, "Subsubtitle"],
Cell[468296, 9386, 818, 11, 35, "Subsubsection"],
Cell[469117, 9399, 6513, 144, 179, "Code"],
Cell[475633, 9545, 89, 2, 35, "Subsubsection"],
Cell[475725, 9549, 1041, 15, 25, "Subsubsection"],
Cell[476769, 9566, 762, 19, 39, "Subsubsection"],
Cell[477534, 9587, 2913, 48, 39, "Subsubsection"],
Cell[480450, 9637, 5486, 118, 101, "Subsubtitle"],
Cell[485939, 9757, 818, 11, 35, "Subsubsection"],
Cell[486760, 9770, 6639, 147, 179, "Code"],
Cell[493402, 9919, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[493483, 9925, 2725, 62, 63, "Subsubtitle"],
Cell[496211, 9989, 1073, 14, 35, "Subsubsection"],
Cell[497287, 10005, 2904, 46, 26, "Subsubsection"],
Cell[500194, 10053, 5821, 111, 101, "Subsubtitle"],
Cell[506018, 10166, 818, 11, 35, "Subsubsection"],
Cell[506839, 10179, 6417, 130, 104, "Code"],
Cell[513259, 10311, 89, 2, 35, "Subsubsection"],
Cell[513351, 10315, 1073, 14, 25, "Subsubsection"],
Cell[514427, 10331, 3324, 56, 26, "Subsubsection"],
Cell[517754, 10389, 6090, 122, 101, "Subsubtitle"],
Cell[523847, 10513, 818, 11, 35, "Subsubsection"],
Cell[524668, 10526, 7199, 152, 154, "Code"],
Cell[531870, 10680, 89, 2, 35, "Subsubsection"],
Cell[531962, 10684, 1073, 14, 25, "Subsubsection"],
Cell[533038, 10700, 2965, 47, 26, "Subsubsection"],
Cell[536006, 10749, 6000, 120, 101, "Subsubtitle"],
Cell[542009, 10871, 818, 11, 35, "Subsubsection"],
Cell[542830, 10884, 6887, 143, 154, "Code"],
Cell[549720, 11029, 89, 2, 35, "Subsubsection"],
Cell[549812, 11033, 1041, 15, 25, "Subsubsection"],
Cell[550856, 11050, 762, 19, 39, "Subsubsection"],
Cell[551621, 11071, 3034, 49, 39, "Subsubsection"],
Cell[554658, 11122, 6186, 128, 101, "Subsubtitle"],
Cell[560847, 11252, 818, 11, 35, "Subsubsection"],
Cell[561668, 11265, 7504, 159, 179, "Code"],
Cell[569175, 11426, 89, 2, 35, "Subsubsection"],
Cell[569267, 11430, 1041, 15, 25, "Subsubsection"],
Cell[570311, 11447, 762, 19, 39, "Subsubsection"],
Cell[571076, 11468, 3109, 51, 39, "Subsubsection"],
Cell[574188, 11521, 6214, 128, 101, "Subsubtitle"],
Cell[580405, 11651, 818, 11, 35, "Subsubsection"],
Cell[581226, 11664, 7513, 158, 179, "Code"],
Cell[588742, 11824, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[588823, 11830, 2652, 60, 63, "Subsubtitle"],
Cell[591478, 11892, 1073, 14, 35, "Subsubsection"],
Cell[592554, 11908, 3001, 50, 26, "Subsubsection"],
Cell[595558, 11960, 5369, 111, 101, "Subsubtitle"],
Cell[600930, 12073, 818, 11, 35, "Subsubsection"],
Cell[601751, 12086, 6324, 138, 154, "Code"],
Cell[608078, 12226, 89, 2, 35, "Subsubsection"],
Cell[608170, 12230, 1073, 14, 25, "Subsubsection"],
Cell[609246, 12246, 3082, 48, 26, "Subsubsection"],
Cell[612331, 12296, 5549, 113, 101, "Subsubtitle"],
Cell[617883, 12411, 818, 11, 35, "Subsubsection"],
Cell[618704, 12424, 6319, 135, 154, "Code"],
Cell[625026, 12561, 89, 2, 35, "Subsubsection"],
Cell[625118, 12565, 1041, 15, 25, "Subsubsection"],
Cell[626162, 12582, 762, 19, 39, "Subsubsection"],
Cell[626927, 12603, 2838, 46, 39, "Subsubsection"],
Cell[629768, 12651, 5436, 118, 101, "Subsubtitle"],
Cell[635207, 12771, 818, 11, 35, "Subsubsection"],
Cell[636028, 12784, 6571, 146, 179, "Code"],
Cell[642602, 12932, 89, 2, 35, "Subsubsection"],
Cell[642694, 12936, 1041, 15, 25, "Subsubsection"],
Cell[643738, 12953, 762, 19, 39, "Subsubsection"],
Cell[644503, 12974, 2913, 48, 39, "Subsubsection"],
Cell[647419, 13024, 5506, 119, 101, "Subsubtitle"],
Cell[652928, 13145, 818, 11, 35, "Subsubsection"],
Cell[653749, 13158, 6709, 149, 179, "Code"],
Cell[660461, 13309, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[660542, 13315, 2725, 62, 63, "Subsubtitle"],
Cell[663270, 13379, 1073, 14, 35, "Subsubsection"],
Cell[664346, 13395, 2904, 46, 26, "Subsubsection"],
Cell[667253, 13443, 5803, 112, 101, "Subsubtitle"],
Cell[673059, 13557, 818, 11, 35, "Subsubsection"],
Cell[673880, 13570, 6519, 133, 104, "Code"],
Cell[680402, 13705, 89, 2, 35, "Subsubsection"],
Cell[680494, 13709, 1073, 14, 25, "Subsubsection"],
Cell[681570, 13725, 3083, 52, 26, "Subsubsection"],
Cell[684656, 13779, 6112, 123, 101, "Subsubtitle"],
Cell[690771, 13904, 818, 11, 35, "Subsubsection"],
Cell[691592, 13917, 7035, 150, 154, "Code"],
Cell[698630, 14069, 89, 2, 35, "Subsubsection"],
Cell[698722, 14073, 1073, 14, 25, "Subsubsection"],
Cell[699798, 14089, 2965, 47, 26, "Subsubsection"],
Cell[702766, 14138, 6051, 121, 101, "Subsubtitle"],
Cell[708820, 14261, 818, 11, 35, "Subsubsection"],
Cell[709641, 14274, 6952, 145, 154, "Code"],
Cell[716596, 14421, 89, 2, 35, "Subsubsection"],
Cell[716688, 14425, 1041, 15, 25, "Subsubsection"],
Cell[717732, 14442, 762, 19, 39, "Subsubsection"],
Cell[718497, 14463, 3034, 49, 39, "Subsubsection"],
Cell[721534, 14514, 6213, 129, 101, "Subsubtitle"],
Cell[727750, 14645, 818, 11, 35, "Subsubsection"],
Cell[728571, 14658, 7494, 160, 179, "Code"],
Cell[736068, 14820, 89, 2, 35, "Subsubsection"],
Cell[736160, 14824, 1041, 15, 25, "Subsubsection"],
Cell[737204, 14841, 762, 19, 39, "Subsubsection"],
Cell[737969, 14862, 3109, 51, 39, "Subsubsection"],
Cell[741081, 14915, 6237, 129, 101, "Subsubtitle"],
Cell[747321, 15046, 818, 11, 35, "Subsubsection"],
Cell[748142, 15059, 7532, 160, 179, "Code"],
Cell[755677, 15221, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[755758, 15227, 2507, 56, 63, "Subsubtitle"],
Cell[758268, 15285, 1073, 14, 35, "Subsubsection"],
Cell[759344, 15301, 2529, 41, 26, "Subsubsection"],
Cell[761876, 15344, 4856, 104, 101, "Subsubtitle"],
Cell[766735, 15450, 818, 11, 35, "Subsubsection"],
Cell[767556, 15463, 5583, 125, 129, "Code"],
Cell[773142, 15590, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[773223, 15596, 2852, 67, 63, "Subsubtitle"],
Cell[776078, 15665, 1073, 14, 35, "Subsubsection"],
Cell[777154, 15681, 3001, 50, 26, "Subsubsection"],
Cell[780158, 15733, 5743, 123, 101, "Subsubtitle"],
Cell[785904, 15858, 818, 11, 35, "Subsubsection"],
Cell[786725, 15871, 6813, 152, 179, "Code"],
Cell[793541, 16025, 89, 2, 35, "Subsubsection"],
Cell[793633, 16029, 1073, 14, 25, "Subsubsection"],
Cell[794709, 16045, 3082, 48, 26, "Subsubsection"],
Cell[797794, 16095, 5927, 126, 101, "Subsubtitle"],
Cell[803724, 16223, 818, 11, 35, "Subsubsection"],
Cell[804545, 16236, 6858, 150, 179, "Code"],
Cell[811406, 16388, 89, 2, 35, "Subsubsection"],
Cell[811498, 16392, 1041, 15, 25, "Subsubsection"],
Cell[812542, 16409, 762, 19, 39, "Subsubsection"],
Cell[813307, 16430, 2838, 46, 39, "Subsubsection"],
Cell[816148, 16478, 5803, 130, 101, "Subsubtitle"],
Cell[821954, 16610, 818, 11, 35, "Subsubsection"],
Cell[822775, 16623, 7124, 161, 204, "Code"],
Cell[829902, 16786, 89, 2, 35, "Subsubsection"],
Cell[829994, 16790, 1041, 15, 25, "Subsubsection"],
Cell[831038, 16807, 762, 19, 39, "Subsubsection"],
Cell[831803, 16828, 2913, 48, 39, "Subsubsection"],
Cell[834719, 16878, 5879, 132, 101, "Subsubtitle"],
Cell[840601, 17012, 818, 11, 35, "Subsubsection"],
Cell[841422, 17025, 7261, 164, 204, "Code"],
Cell[848686, 17191, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[848767, 17197, 2952, 71, 63, "Subsubtitle"],
Cell[851722, 17270, 1073, 14, 35, "Subsubsection"],
Cell[852798, 17286, 2904, 46, 26, "Subsubsection"],
Cell[855705, 17334, 6111, 122, 101, "Subsubtitle"],
Cell[861819, 17458, 818, 11, 35, "Subsubsection"],
Cell[862640, 17471, 6988, 146, 154, "Code"],
Cell[869631, 17619, 89, 2, 35, "Subsubsection"],
Cell[869723, 17623, 1073, 14, 25, "Subsubsection"],
Cell[870799, 17639, 3083, 52, 26, "Subsubsection"],
Cell[873885, 17693, 6516, 136, 101, "Subsubtitle"],
Cell[880404, 17831, 818, 11, 35, "Subsubsection"],
Cell[881225, 17844, 7574, 165, 179, "Code"],
Cell[888802, 18011, 89, 2, 35, "Subsubsection"],
Cell[888894, 18015, 1073, 14, 25, "Subsubsection"],
Cell[889970, 18031, 2965, 47, 26, "Subsubsection"],
Cell[892938, 18080, 6428, 134, 101, "Subsubtitle"],
Cell[899369, 18216, 818, 11, 35, "Subsubsection"],
Cell[900190, 18229, 7434, 159, 179, "Code"],
Cell[907627, 18390, 89, 2, 35, "Subsubsection"],
Cell[907719, 18394, 1041, 15, 25, "Subsubsection"],
Cell[908763, 18411, 762, 19, 39, "Subsubsection"],
Cell[909528, 18432, 3034, 49, 39, "Subsubsection"],
Cell[912565, 18483, 6602, 142, 101, "Subsubtitle"],
Cell[919170, 18627, 818, 11, 35, "Subsubsection"],
Cell[919991, 18640, 8043, 175, 204, "Code"],
Cell[928037, 18817, 89, 2, 35, "Subsubsection"],
Cell[928129, 18821, 1041, 15, 25, "Subsubsection"],
Cell[929173, 18838, 762, 19, 39, "Subsubsection"],
Cell[929938, 18859, 3109, 51, 39, "Subsubsection"],
Cell[933050, 18912, 6628, 142, 101, "Subsubtitle"],
Cell[939681, 19056, 818, 11, 35, "Subsubsection"],
Cell[940502, 19069, 8089, 175, 204, "Code"],
Cell[948594, 19246, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],
Cell[948665, 19251, 1477, 31, 254, "Code"],
Cell[950145, 19284, 3780, 57, 114, "Code"]
}
]
*)

(* End of internal cache information *)
