(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    358375,       8806]
NotebookOptionsPosition[    343396,       8455]
NotebookOutlinePosition[    344515,       8494]
CellTagsIndexPosition[    344472,       8491]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, 3.4976651531681385`*^9, {
   3.497665246783903*^9, 3.4976652608707275`*^9}, {3.4991316095329504`*^9, 
   3.4991316095329504`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "A"}], "+", 
    RowBox[{"b", " ", "B"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, 
   3.4976651743061757`*^9, {3.4991317949832096`*^9, 3.4991317953032103`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"B", " ", "x", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["B", 
    RowBox[{"a", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4976652106074395`*^9, 
   3.4976652204666567`*^9}, 3.4976652749419527`*^9, {3.4991316095329504`*^9, 
   3.4991316274529753`*^9}, {3.4991318033632216`*^9, 3.499131806573226*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", "x", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sinh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "+", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, {
   3.49913160954295*^9, 3.4991316274529753`*^9}, 3.4991317842431946`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"B", "*", "x", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"B", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "A"}], "-", 
      RowBox[{"b", "*", "B"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, {
   3.4979906147107*^9, 3.4979906481259584`*^9}, 3.4979906869044275`*^9, {
   3.49913160977295*^9, 3.4991316275629754`*^9}, 3.4991330476549635`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4978079429925823`*^9, 
   3.49913160955295*^9, 3.4991316726230383`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.423.18'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4991319322334023`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "z", "]"}], " ", 
    RowBox[{"Tanh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Cosh", "[", "z", "]"}], "-", 
    RowBox[{"Sech", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, {
   3.49913160956295*^9, 3.4991316274529753`*^9}, {3.4991316726330385`*^9, 
   3.4991316938930683`*^9}, {3.499131940233413*^9, 3.4991319424534163`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "b"]}]}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.49913160956295*^9, 3.49913160956295*^9}, {
   3.4991316726330385`*^9, 3.4991316939030685`*^9}, {3.499131964973448*^9, 
   3.499131968573453*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "-", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, {3.4991316095729504`*^9, 3.4991316095729504`*^9}, {
   3.4991316726330385`*^9, 3.4991316939030685`*^9}, 3.4991319550634336`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.423.34'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4980071782686453`*^9, 3.515794656069579*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "+", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, {3.4980070688484917`*^9, 3.4980070692184925`*^9}, 
   3.4980071050285425`*^9, 3.498007168308631*^9, {3.4991316275829754`*^9, 
   3.4991316561930156`*^9}, 3.4991317068430862`*^9, {3.515793370524521*^9, 
   3.515793371195322*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "-", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, 3.4978092076443524`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"b", " ", "m"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, {3.4991316095729504`*^9, 
   3.4991316095729504`*^9}, {3.4991316726330385`*^9, 3.4991316726330385`*^9}, 
   3.49913200969351*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, {3.4991316095729504`*^9, 
   3.4991316095729504`*^9}, {3.4991316726430387`*^9, 3.4991316726430387`*^9}, 
   3.499132006583506*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, {3.4980070702084937`*^9, 
   3.4980070705484943`*^9}, {3.4980071059085436`*^9, 3.498007106158544*^9}, 
   3.4980073091088285`*^9, {3.4991316275929756`*^9, 3.4991316562030153`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n", "-", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox[
         RowBox[{"Cosh", "[", "z", "]"}], "2"]}], ")"}], 
      FractionBox[
       RowBox[{"m", "+", "n", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"Cosh", "[", "z", "]"}], "n"]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cosh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, {
   3.4978087748237467`*^9, 3.4978087764737487`*^9}, {3.497808951173993*^9, 
   3.497808995844056*^9}, 3.4978092040243473`*^9, {3.4980074796390667`*^9, 
   3.4980074796390667`*^9}, {3.4991316095929503`*^9, 
   3.4991316274629755`*^9}, {3.4991316726430387`*^9, 
   3.4991316726430387`*^9}, {3.499132115123658*^9, 3.4991321207836657`*^9}}],

Cell[TextData[{
 "Note: This rule is used if  ",
 Cell[BoxData[
  RowBox[{"m", "+", "n"}]]],
 "  is odd since it requires fewer steps and results in a simpler \
antiderivative than the other rules in this section."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, {3.49757671762799*^9, 3.4975767846480837`*^9}, {
   3.4975768494507804`*^9, 3.4975769045208573`*^9}, {3.498010742553635*^9, 
   3.4980107501136456`*^9}, {3.498010843943777*^9, 3.4980108835438323`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n", "-", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, 
   3.4978092015143437`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], 
         FractionBox[
          RowBox[{"m", "+", "n", "-", "1"}], "2"]], 
        SuperscriptBox["x", "n"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, {3.49913160960295*^9, 
   3.4991316274729753`*^9}, 3.4991316726430387`*^9, {3.4991320663535895`*^9, 
   3.4991320741136007`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "2"}], ")"}]}],
             "/", 
            RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, {3.49913160960295*^9, 
   3.4991316274729753`*^9}, 3.4991316726530385`*^9, 3.499132061963584*^9, {
   3.51719040308379*^9, 3.517190407358197*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n", "-", "1"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Coth", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", "z", "]"}], "2"]}], ")"}], 
      FractionBox[
       RowBox[{"m", "+", "n", "-", "1"}], "2"]], 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "z", "]"}], "n"]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Sinh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, {
   3.4978087748237467`*^9, 3.4978087764737487`*^9}, {3.497808951173993*^9, 
   3.497808995844056*^9}, 3.4978092040243473`*^9, 3.498007071128495*^9, 
   3.498007106388544*^9, {3.498007432449001*^9, 3.4980074683190513`*^9}, 
   3.498007548949164*^9, {3.4991316097829504`*^9, 3.4991316562030153`*^9}, {
   3.5153910369855537`*^9, 3.5153910374067545`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "2"}], ")"}]}],
             "/", 
            RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.498007071698496*^9, 
   3.498007106838545*^9, 3.4980074065789647`*^9, {3.4991316097929506`*^9, 
   3.4991316562130156`*^9}, {3.5153910435999656`*^9, 3.515391043974366*^9}, {
   3.517190410072602*^9, 3.5171904132238073`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.1, CRC 567a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.499132177183745*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.498008430090398*^9, 
   3.498008430840399*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "m"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], "m"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, {
   3.49913160960295*^9, 3.49913160960295*^9}, {3.4991316726530385`*^9, 
   3.4991316726530385`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4980084263703923`*^9, {3.4991316096129503`*^9, 3.4991316096129503`*^9}, {
   3.4991316726530385`*^9, 3.4991316726630383`*^9}, 3.499132216113799*^9, 
   3.5157941182774343`*^9, 3.5157948685575523`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.2, CRC 567b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.4980076348692846`*^9, 
   3.515794395377521*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, {
   3.498007072798497*^9, 3.4980070734484987`*^9}, {3.4980071082985473`*^9, 
   3.4980071087985477`*^9}, 3.498007649769305*^9, 3.4980083457402797`*^9, {
   3.4991316276129756`*^9, 3.499131656223016*^9}, {3.515794407935543*^9, 
   3.515794411523549*^9}, 3.5157948665607486`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.6, CRC 568b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4991322434238377`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.4978093447445445`*^9, 
   3.4978093512745533`*^9}, {3.498008439750411*^9, 3.4980084406804123`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "2"}]], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "2"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, 
   3.4978093163545046`*^9, {3.4991316096129503`*^9, 3.4991316096129503`*^9}, {
   3.4991316726630383`*^9, 3.4991316726630383`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.498008436130406*^9, {3.4991316096229506`*^9, 
   3.4991316096229506`*^9}, {3.4991316726630383`*^9, 3.4991316726730385`*^9}, 
   3.4991322640638666`*^9, 3.515794122115041*^9, 3.515794983046153*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.5, CRC 568a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.498007975509761*^9, 3.5157944516936197`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, {3.4980070747385*^9, 3.498007075258501*^9}, {
   3.49800711022855*^9, 3.498007111178551*^9}, 3.4980079821297703`*^9, 
   3.4980083428502755`*^9, {3.4991316276229753`*^9, 3.4991316562330155`*^9}, 
   3.5157944428328047`*^9, 3.5157949819073515`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.2, CRC 567b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.499132290703904*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.4978093447445445`*^9, 
   3.4978093512745533`*^9}, {3.497809459704705*^9, 3.4978094655147133`*^9}, {
   3.4980109876739783`*^9, 3.498010988483979*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", "m"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "-", "1"}], "m"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, 
   3.4978093163545046`*^9, 3.4978094340946693`*^9, {3.4991316096229506`*^9, 
   3.4991316096329503`*^9}, {3.4991316726730385`*^9, 
   3.4991316726730385`*^9}, {3.499132328353956*^9, 3.499132332573962*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.4980109833539724`*^9, {
   3.4991316096329503`*^9, 3.4991316096329503`*^9}, {3.4991316726730385`*^9, 
   3.4991316726830387`*^9}, 3.4991323218039474`*^9, 3.515794126093048*^9, 
   3.5157950994067574`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.1, CRC 567a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4980080553898735`*^9, 3.5157944816456723`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, {3.498007076778503*^9, 
   3.498007077528504*^9}, {3.4980071136585546`*^9, 3.498007116338558*^9}, 
   3.4980080624098825`*^9, 3.4980110278740344`*^9, {3.4991316276329756`*^9, 
   3.4991316562430153`*^9}, 3.5157950981743555`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4991323790140276`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.4978093447445445`*^9, 
   3.4978093512745533`*^9}, {3.497809459704705*^9, 3.4978094655147133`*^9}, 
   3.4978096024249053`*^9, {3.498010997003991*^9, 3.4980109979339924`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
         SuperscriptBox[
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "-", "1"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, 
   3.4978093163545046`*^9, 3.4978094340946693`*^9, 3.4978095921348906`*^9, {
   3.4991316096329503`*^9, 3.49913160964295*^9}, {3.4991316726830387`*^9, 
   3.4991316726830387`*^9}, {3.4991323862840376`*^9, 3.499132393764048*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, 
   3.498010993363986*^9, {3.49913160964295*^9, 3.49913160964295*^9}, {
   3.4991316726830387`*^9, 3.499131672693039*^9}, 3.499132372734019*^9, 
   3.5157941316778574`*^9, 3.515795150481247*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4980080949999285`*^9, 
   3.515794513438528*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, {
   3.4980070790485063`*^9, 3.4980070796585073`*^9}, {3.498007117998561*^9, 
   3.498007119758563*^9}, 3.4980081029299393`*^9, 3.4980110327940416`*^9, {
   3.499131627642976*^9, 3.4991316562530155`*^9}, 3.5153911731737933`*^9, 
   3.515795149046045*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.5, CRC 568a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4978096525149755`*^9, 
   3.4991324456141205`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.4978093447445445`*^9, 
   3.4978093512745533`*^9}, {3.497809459704705*^9, 3.4978094655147133`*^9}, 
   3.4978096024249053`*^9, {3.4978096874850245`*^9, 3.49780970627505*^9}, {
   3.49800845286043*^9, 3.498008453750431*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "2"}]], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "2"}], 
    RowBox[{"m", "+", "n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, 
   3.4978093163545046`*^9, 3.4978094340946693`*^9, 3.4978095921348906`*^9, 
   3.497809676385009*^9, {3.49913160964295*^9, 3.4991316096529503`*^9}, {
   3.499131672693039*^9, 3.499131672693039*^9}, 3.4991324526841307`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, 
   3.497809647134968*^9, 3.4980084487604237`*^9, {3.4991316096529503`*^9, 
   3.4991316096529503`*^9}, {3.499131672693039*^9, 3.4991316727030387`*^9}, 
   3.499132435694107*^9, 3.515794137028667*^9, 3.515795206641346*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.6, CRC 568b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4978096525149755`*^9, 
   3.498008137509988*^9, 3.5157945423921795`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, 
   3.497809647134968*^9, {3.4980070810985093`*^9, 3.4980070820585103`*^9}, {
   3.4980071214185658`*^9, 3.4980071230885677`*^9}, 3.498008145439999*^9, 
   3.498008325900252*^9, {3.4991316276529756`*^9, 3.4991316562630157`*^9}, 
   3.515795207967348*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4978096525149755`*^9, 
   3.4978097598651257`*^9, 3.4991325210542264`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}, {3.4978083089530945`*^9, 
   3.4978083143531017`*^9}, {3.4978084473132877`*^9, 
   3.4978084750933266`*^9}, {3.497808510103376*^9, 3.4978085176833863`*^9}, {
   3.4978090871541834`*^9, 3.4978091125642195`*^9}, {3.4978091437242627`*^9, 
   3.497809166464295*^9}, 3.497809198114339*^9, {3.4978093447445445`*^9, 
   3.4978093512745533`*^9}, {3.497809459704705*^9, 3.4978094655147133`*^9}, 
   3.4978096024249053`*^9, {3.4978096874850245`*^9, 3.49780970627505*^9}, 
   3.4978097648851323`*^9, {3.498008461980442*^9, 3.4980084627904434`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"m", "+", "n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, 3.4978082483830094`*^9, {
   3.4978082814430556`*^9, 3.4978082818430567`*^9}, 3.4978084263332586`*^9, {
   3.497808533993409*^9, 3.497808542973422*^9}, 3.49780906983416*^9, 
   3.4978093163545046`*^9, 3.4978094340946693`*^9, 3.4978095921348906`*^9, 
   3.497809676385009*^9, 3.497809789095166*^9, {3.4991316096629505`*^9, 
   3.4991316096629505`*^9}, {3.4991316727030387`*^9, 3.4991316727030387`*^9}, 
   3.49913249485419*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Tanh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, 
   3.497809647134968*^9, 3.4978097551251187`*^9, 3.4980084579304366`*^9, {
   3.4991316096629505`*^9, 3.4991316096729507`*^9}, {3.4991316727130384`*^9, 
   3.4991316727130384`*^9}, 3.499132487424179*^9, 3.515794142831877*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.4978083657831736`*^9, 3.497809045684126*^9, 3.497809288294465*^9, 
   3.4978094095246353`*^9, 3.4978095645048523`*^9, 3.4978096525149755`*^9, 
   3.4978097598651257`*^9, 3.4980081764400425`*^9, 3.5157945692866263`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Coth", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.4978080327627077`*^9, 3.4978082252929773`*^9, 3.4978083390831366`*^9, {
   3.497808483913339*^9, 3.4978084948533545`*^9}, 3.4978090404941187`*^9, 
   3.4978092822644567`*^9, 3.497809403584627*^9, 3.497809558294843*^9, 
   3.497809647134968*^9, 3.4978097551251187`*^9, {3.498007084118513*^9, 
   3.498007090318522*^9}, {3.49800712455857*^9, 3.498007129568577*^9}, 
   3.4980081814100494`*^9, 3.4980083291602564`*^9, {3.4991316276629753`*^9, 
   3.4991316562730155`*^9}, {3.5157945784750423`*^9, 3.5157945823594494`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   RowBox[{"Sinh", "[", "v", "]"}], " ", 
   RowBox[{"Hyper", "[", "w", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4978079429925823`*^9, 
   3.497835276823431*^9, {3.4978353630447826`*^9, 3.497835377053607*^9}, 
   3.4978355024154277`*^9, 3.4978356715377254`*^9, 3.4991316096729507`*^9, {
   3.51572892684704*^9, 3.515728928297843*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Cosh", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "+", "w"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, {3.4991316096829505`*^9, 
   3.4991316274729753`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"v", ",", 
   RowBox[{
    RowBox[{"w", " ", "\[Element]", "\[DoubleStruckCapitalP]x"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"v", "+", "w"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.498008945331119*^9, 3.4980089470411215`*^9}, {
   3.515693012211714*^9, 3.515693012211714*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Cosh", "[", "w", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"v", "+", "w"}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, {3.4991316096829505`*^9, 
   3.4991316274729753`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{"Cosh", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{"v", "+", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{"v", "-", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"w", ",", "x"}], "]"}]}], " ", "||", " ", 
      RowBox[{"IndependentQ", "[", 
       RowBox[{
        RowBox[{"Cancel", "[", 
         RowBox[{"v", "/", "w"}], "]"}], ",", "x"}], "]"}]}], ")"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4980089392411103`*^9, {3.4980120170054193`*^9, 
   3.498012023205428*^9}, {3.4991316096929502`*^9, 3.499131627482975*^9}, 
   3.4991326291443777`*^9, 3.515693019371724*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Sinh", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "+", "w"}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, {
   3.4991316096929502`*^9, 3.499131627482975*^9}, {3.4991326884244604`*^9, 
   3.4991326884244604`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"v", ",", 
   RowBox[{
    RowBox[{"w", " ", "\[Element]", "\[DoubleStruckCapitalP]x"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"v", "+", "w"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.497836024784746*^9, 3.49783602723395*^9}, {
   3.515693093691828*^9, 3.515693093691828*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Sinh", "[", "w", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"v", "+", "w"}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, 3.49783599296069*^9, {
   3.4978361035960846`*^9, 3.497836104220085*^9}, {3.4991316097029505`*^9, 
   3.499131627482975*^9}, {3.499132702824481*^9, 3.499132707454487*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{"Sinh", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"v", "+", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"v", "-", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"w", ",", "x"}], "]"}]}], " ", "||", " ", 
      RowBox[{"IndependentQ", "[", 
       RowBox[{
        RowBox[{"Cancel", "[", 
         RowBox[{"v", "/", "w"}], "]"}], ",", "x"}], "]"}]}], ")"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, {3.4980120287354355`*^9, 
   3.4980120326954412`*^9}, {3.4991316097029505`*^9, 3.499131627492975*^9}, 
   3.499132660314421*^9, 3.5156930518917694`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], " ", 
    RowBox[{"Cosh", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "+", "w"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.4980090373412476`*^9, {3.499131627682976*^9, 3.4991316276929755`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Cosh", "[", "v_", "]"}], "*", 
     RowBox[{"Cosh", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"v", "-", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"v", "+", "w"}], "]"}], ",", "x"}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"w", ",", "x"}], "]"}]}], " ", "||", " ", 
      RowBox[{"IndependentQ", "[", 
       RowBox[{
        RowBox[{"Cancel", "[", 
         RowBox[{"v", "/", "w"}], "]"}], ",", "x"}], "]"}]}], ")"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.498009047351262*^9, {
   3.498012084065513*^9, 3.498012088195519*^9}, {3.4991316277029753`*^9, 
   3.4991316277029753`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Tanh", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], "-", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Sech", "[", "w", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.497836055064399*^9, {3.4991316097129507`*^9, 3.499131627492975*^9}, {
   3.4991316727130384`*^9, 3.4991316939030685`*^9}, {3.499132741884536*^9, 
   3.499132741884536*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"x", "\[NotElement]", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.497836024784746*^9, 3.49783602723395*^9}, {
   3.4978361593661823`*^9, 3.497836210581072*^9}, {3.4980097343122234`*^9, 
   3.4980097356822257`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Tanh", "[", "w", "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{"u", " ", 
        RowBox[{"Cosh", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Tanh", "[", "w", "]"}], 
         RowBox[{"n", "-", "1"}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}], "-", 
  RowBox[{
   RowBox[{"Cosh", "[", 
    RowBox[{"v", "-", "w"}], "]"}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sech", "[", "w", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", "w", "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, 3.49783599296069*^9, {
   3.497836093674467*^9, 3.4978360980736747`*^9}, {3.4978362664291706`*^9, 
   3.4978362703603773`*^9}, {3.4991316097129507`*^9, 3.499131627492975*^9}, {
   3.4991316727130384`*^9, 3.4991316939030685`*^9}, {3.499132757904558*^9, 
   3.499132764974568*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Cosh", "[", "v", "]"}], "*", 
       RowBox[{
        RowBox[{"Tanh", "[", "w", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Sech", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Tanh", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836064783216*^9, {
   3.4991316097129507`*^9, 3.4991316275029755`*^9}, {3.4991316727230387`*^9, 
   3.4991316939130683`*^9}, 3.499132727824516*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], " ", 
    RowBox[{"Coth", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], "+", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Csch", "[", "w", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.497836055064399*^9, 3.4980092786115856`*^9, {3.4991316098129506`*^9, 
   3.4991316562730155`*^9}, {3.4991317068530865`*^9, 
   3.4991317068530865`*^9}, {3.5153923486698565`*^9, 3.5153923486698565`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Cosh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Sinh", "[", "v", "]"}], "*", 
       RowBox[{
        RowBox[{"Coth", "[", "w", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Csch", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Coth", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836064783216*^9, 
   3.497836247849538*^9, 3.4980092862015963`*^9, {3.4991316098129506`*^9, 
   3.4991316562830153`*^9}, 3.4991317068530865`*^9, 3.515392363708283*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Coth", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Csch", "[", "w", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.497836055064399*^9, {3.515391842765769*^9, 3.515391855432991*^9}, {
   3.515391934041529*^9, 3.515391942293944*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"x", "\[NotElement]", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.497836024784746*^9, 3.49783602723395*^9}, {
   3.4978361593661823`*^9, 3.497836210581072*^9}, {3.4980097398922315`*^9, 
   3.498009741282233*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Coth", "[", "w", "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{"u", " ", 
        RowBox[{"Cosh", "[", "v", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Coth", "[", "w", "]"}], 
         RowBox[{"n", "-", "1"}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"v", "-", "w"}], "]"}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Csch", "[", "w", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Coth", "[", "w", "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, 3.49783599296069*^9, {
   3.497836093674467*^9, 3.4978360980736747`*^9}, {3.4978362824503984`*^9, 
   3.497836305039238*^9}, {3.4991316097129507`*^9, 3.4991316561630154`*^9}, 
   3.4991317068230867`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Coth", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Cosh", "[", "v", "]"}], "*", 
       RowBox[{
        RowBox[{"Coth", "[", "w", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Csch", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Coth", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836064783216*^9, 
   3.497836247849538*^9, {3.4991316097229505`*^9, 3.4991316561630154`*^9}, 
   3.4991317068230867`*^9, 3.4991327898046026`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], " ", 
    RowBox[{"Tanh", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], "-", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Sech", "[", "w", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.497836055064399*^9, 3.4980091456913996`*^9, {3.4991316097929506`*^9, 
   3.4991316432329974`*^9}, {3.499131693923068*^9, 3.499131693923068*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Cosh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Tanh", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Sinh", "[", "v", "]"}], "*", 
       RowBox[{
        RowBox[{"Tanh", "[", "w", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Sech", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Tanh", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836064783216*^9, 
   3.4980091532614098`*^9, {3.499131609802951*^9, 3.499131643242997*^9}, 
   3.4991316939330683`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Sech", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Tanh", "[", "w", "]"}]}], "+", 
    RowBox[{"Sinh", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.4978363858941803`*^9, {3.4991316097229505`*^9, 3.4991316275129757`*^9}, {
   3.499131672733039*^9, 3.4991316939130683`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"x", "\[NotElement]", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.497836024784746*^9, 3.49783602723395*^9}, {
   3.4978361593661823`*^9, 3.497836210581072*^9}, {3.498009745622239*^9, 
   3.4980097468622413`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sech", "[", "w", "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"v", "-", "w"}], "]"}]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Tanh", "[", "w", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sech", "[", "w", "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"v", "-", "w"}], "]"}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", "w", "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, 3.49783599296069*^9, {
   3.4978361035960846`*^9, 3.497836104220085*^9}, {3.4978364329906626`*^9, 
   3.497836443427081*^9}, {3.49913160973295*^9, 3.4991316275129757`*^9}, {
   3.499131672733039*^9, 3.499131693923068*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Tanh", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Sech", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "+", 
    " ", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Sech", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836368063349*^9, {
   3.49913160973295*^9, 3.4991316275129757`*^9}, {3.499131672733039*^9, 
   3.499131693923068*^9}, 3.4991328318746614`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], "*", 
    RowBox[{"Csch", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Coth", "[", "w", "]"}]}], "+", 
    RowBox[{"Sinh", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.4978363858941803`*^9, 3.4978364871071577`*^9, {3.498009514411916*^9, 
   3.4980095186119213`*^9}, {3.4991316098229504`*^9, 
   3.4991316562830153`*^9}, {3.4991317068530865`*^9, 
   3.4991317068530865`*^9}, {3.515392683301244*^9, 3.515392683301244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Cosh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Coth", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Csch", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "+", 
    " ", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Csch", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836368063349*^9, 
   3.4978364947979717`*^9, 3.49800953181194*^9, {3.4991316098329506`*^9, 
   3.4991316562930155`*^9}, {3.4991317068630867`*^9, 3.4991317068630867`*^9}, 
   3.5153926909608574`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.497835761783884*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    RowBox[{"Csch", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Coth", "[", "w", "]"}]}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.4978363858941803`*^9, 3.4978364871071577`*^9, {3.49913160973295*^9, 
   3.4991316561730156`*^9}, {3.4991317068330865`*^9, 3.4991317068330865`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"x", "\[NotElement]", 
    RowBox[{
     RowBox[{"v", "-", "w"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}, {3.4978358337468104`*^9, 
   3.497835886459303*^9}, {3.497836024784746*^9, 3.49783602723395*^9}, {
   3.4978361593661823`*^9, 3.497836210581072*^9}, {3.498009751172247*^9, 
   3.498009752392249*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"Sinh", "[", "v", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csch", "[", "w", "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"v", "-", "w"}], "]"}]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Coth", "[", "w", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Csch", "[", "w", "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Cosh", "[", 
    RowBox[{"v", "-", "w"}], "]"}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Csch", "[", "w", "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4978357296010275`*^9, 3.4978357512382655`*^9}, 3.49783599296069*^9, {
   3.4978361035960846`*^9, 3.497836104220085*^9}, {3.4978364329906626`*^9, 
   3.497836443427081*^9}, 3.497836510678799*^9, {3.4980095667119884`*^9, 
   3.49800956723199*^9}, {3.4991316097429504`*^9, 3.4991316561730156`*^9}, {
   3.4991317068330865`*^9, 3.4991317068330865`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Sinh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Coth", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Csch", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "+", 
    " ", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Csch", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836368063349*^9, 
   3.4978364947979717`*^9, {3.4991316097429504`*^9, 3.4991316561730156`*^9}, {
   3.4991317068330865`*^9, 3.4991317068430862`*^9}, 3.499132857994698*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "v", "]"}], " ", 
    RowBox[{"Sech", "[", "w", "]"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], " ", 
     RowBox[{"Tanh", "[", "w", "]"}]}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, 3.497835794512741*^9, 3.4978359407629986`*^9, 
   3.4978363858941803`*^9, 3.4980093930617456`*^9, {3.4991316098129506`*^9, 
   3.4991316432529974`*^9}, {3.4991316939330683`*^9, 
   3.4991316939330683`*^9}, {3.515392483594494*^9, 3.515392483594494*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"Cosh", "[", "v_", "]"}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", "w_", "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Tanh", "[", "w", "]"}], "*", 
        RowBox[{
         RowBox[{"Sech", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "+", 
    " ", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"v", "-", "w"}], "]"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Sech", "[", "w", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"v", "-", "w"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.4978356847665486`*^9, 3.4978359483134117`*^9, 3.497836368063349*^9, 
   3.4980093810217285`*^9, {3.4991316098229504`*^9, 3.4991316432529974`*^9}, {
   3.4991316939430685`*^9, 3.4991316939430685`*^9}, 3.5153924892417035`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
   RowBox[{"Cosh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4978079429925823`*^9, 
   3.497835276823431*^9, {3.4978353630447826`*^9, 3.497835377053607*^9}, 
   3.4978355024154277`*^9, {3.4991316097529507`*^9, 3.499131627532975*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.479.6", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.4991329645448475`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}, {
   3.49783552656427*^9, 3.497835559620728*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.49783559436439*^9, 3.4978356039740067`*^9}, {
   3.4991316097529507`*^9, 3.499131627532975*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, {
   3.4991316097629504`*^9, 3.499131627532975*^9}, 3.4991329548348336`*^9, {
   3.515795797130784*^9, 3.5157957976767845`*^9}, {3.517190415844612*^9, 
   3.5171904188554173`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.479.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9, 3.49783550973184*^9, 3.498008541850554*^9, 
   3.5157957566799126`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, 3.497835521275861*^9, 
   3.498008549450565*^9, {3.4980085801706076`*^9, 3.4980085904106216`*^9}, {
   3.499131609842951*^9, 3.499131627772976*^9}, {3.5153928273362966`*^9, 
   3.5153928305187025`*^9}, {3.5157957901419716`*^9, 
   3.5157958003911896`*^9}, {3.5171904211798215`*^9, 3.517190423738226*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, {3.4991316098529506`*^9, 
   3.499131627772976*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: ",
 "G&R 2.411.5, CRC 568a, A&S 4.5.86a",
 " with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.4977284496435795`*^9, {3.515790863379716*^9, 
   3.515790874346535*^9}, 3.515795358242412*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "2"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.499131609862951*^9, 
   3.499131627792976*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, {3.4991316098729506`*^9, 3.4991316278029757`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", "z", "]"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"n", "-", "1"}], "2"]], " ", 
    RowBox[{
     SuperscriptBox["Sinh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.499131609892951*^9, 3.499131627812976*^9}, {
   3.515381148112835*^9, 3.515381153619645*^9}, {3.515381210107344*^9, 
   3.515381210450545*^9}}],

Cell[TextData[{
 "Note: This rule is used for odd ",
 Cell[BoxData["n"]],
 " since it requires fewer steps and results in a simpler antiderivative than \
the other rules in this section."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, {3.49757671762799*^9, 3.4975767846480837`*^9}, {
   3.4975768494507804`*^9, 3.4975769045208573`*^9}, {3.498010742553635*^9, 
   3.4980107501136456`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"m", "-", "1"}], "2"], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
      RowBox[{"0", "<", "m", "<", "n"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977279951087804`*^9, 3.497728007354802*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"n", "-", "1"}], "2"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4977277558667603`*^9, 3.4977279564051123`*^9, {3.499131609902951*^9, 
   3.499131627822976*^9}, {3.515381218687359*^9, 3.51538121910856*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "m"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"OddQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "m", "<", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, {
   3.4991316099129505`*^9, 3.499131627832976*^9}, {3.515381222275366*^9, 
   3.5153812226965666`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Cosh", "[", "z", "]"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"m", "-", "1"}], "2"]], " ", 
    RowBox[{
     SuperscriptBox["Cosh", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.497991500508256*^9, 3.497991579865596*^9}, {
   3.4991316099229507`*^9, 3.4991316278429756`*^9}, {3.5153811577536526`*^9, 
   3.5153811577536526`*^9}, {3.5153812565018253`*^9, 
   3.5153812565018253`*^9}, {3.5153813969472713`*^9, 3.5153813990220747`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "n"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OddQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "n", "<=", "m"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497727590085269*^9, 3.4977277276307106`*^9, 
   3.49799144010495*^9, {3.4991316099429507`*^9, 3.4991316278729763`*^9}, {
   3.5153814803450174`*^9, 3.515381497520648*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.515791626673456*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4977282008387423`*^9, 3.497728208435956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497728173385894*^9, 3.497728181940709*^9}, {
   3.4991316099529505`*^9, 3.499131627882976*^9}, {3.515791020128791*^9, 
   3.515791023467197*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, {3.499131609972951*^9, 3.499131627892976*^9}, {
   3.515791052467648*^9, 3.5157910664764724`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.4", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, {
   3.4979918047243905`*^9, 3.497991804973991*^9}, 3.5157919573276377`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.4979918024311867`*^9, {3.499131609992951*^9, 
   3.499131627922976*^9}, {3.5157911654586463`*^9, 3.5157911720106583`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.2, CRC 567b, A&S 4.5.85b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.515791698620783*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
      RowBox[{"n", ">", "1"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4977282008387423`*^9, 3.497728208435956*^9}, {3.497728263675653*^9, 
   3.497728386635069*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{"m", "+", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497728173385894*^9, 3.497728181940709*^9}, 
   3.498011270904375*^9, {3.499131610012951*^9, 3.499131627932976*^9}, {
   3.515389528558507*^9, 3.5153895318969135`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, {3.4980113358844657`*^9, 
   3.4980113391144705`*^9}, {3.499131610022951*^9, 3.499131627942976*^9}, {
   3.5153904804925776`*^9, 3.5153904855937862`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.1, CRC 567a, A&S 4.5.85a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.4979919575578585`*^9, 3.5157920094785295`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, 3.4979919356710205`*^9, {
   3.4980113205744443`*^9, 3.4980113243044496`*^9}, {3.499131610052951*^9, 
   3.4991316279729757`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.411.5, CRC 568a, A&S 4.5.86a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.4977284496435795`*^9, 3.5157917289628363`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "2"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4977282008387423`*^9, 3.497728208435956*^9}, {3.497728263675653*^9, 
   3.497728386635069*^9}, {3.4977284844316406`*^9, 3.497728504134475*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "+", "2"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497728173385894*^9, 3.497728181940709*^9}, 
   3.49772847237282*^9, {3.499131610062951*^9, 3.499131627982976*^9}, 
   3.5157913100709004`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, 3.497728444635971*^9, {
   3.4991316100729513`*^9, 3.499131627992976*^9}, {3.515791318650915*^9, 
   3.5157913193061166`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.411.6, CRC 568b, A&S 4.5.86b", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.4977284496435795`*^9, 3.4979921349613705`*^9, 
   3.5157920501322007`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, 3.497728444635971*^9, 
   3.4979921241661515`*^9, {3.499131610102951*^9, 3.499131628022976*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "m"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "m"]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sinh", "[", "z", "]"}], "m"], 
        SuperscriptBox[
         RowBox[{"Cosh", "[", "z", "]"}], "m"]], ")"}], 
      RowBox[{"1", "/", "m"}]], 
     RowBox[{"m", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"Sinh", "[", "z", "]"}], "m"], 
           SuperscriptBox[
            RowBox[{"Cosh", "[", "z", "]"}], "m"]], ")"}], 
         RowBox[{"2", "/", "m"}]]}], ")"}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sinh", "[", "z", "]"}], "m"], 
      SuperscriptBox[
       RowBox[{"Cosh", "[", "z", "]"}], "m"]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.497729352807166*^9, 3.4977293844996223`*^9}, {
   3.499131610122951*^9, 3.499131628042976*^9}, {3.5153907270174103`*^9, 
   3.5153907270174103`*^9}}],

Cell["Note: This rule should be replaced with a more general one.", \
"Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497728192009127*^9, 
   3.4977282459540215`*^9, 3.4977284496435795`*^9, {3.4977285597485733`*^9, 
   3.4977286033350496`*^9}, 3.497728667357562*^9, {3.4977295029118304`*^9, 
   3.4977295033954315`*^9}, {3.497729634123661*^9, 3.497729650066889*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["1", "m"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    FractionBox["1", "m"], ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4977282008387423`*^9, 3.497728208435956*^9}, {3.497728263675653*^9, 
   3.497728386635069*^9}, {3.4977284844316406`*^9, 3.497728504134475*^9}, {
   3.4977286781683807`*^9, 3.497728732253676*^9}, {3.4977289038695774`*^9, 
   3.497728908081585*^9}, {3.4977291516292124`*^9, 3.4977291530488153`*^9}, {
   3.497729240939369*^9, 3.497729261157005*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"b", " ", "m"}]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{"1", "/", "m"}]], 
        RowBox[{"1", "-", 
         SuperscriptBox["x", 
          RowBox[{"2", "/", "m"}]]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "m"]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497728173385894*^9, 3.497728181940709*^9}, 
   3.49772847237282*^9, 3.4977286239426856`*^9, {3.4977288885815506`*^9, 
   3.497728899080369*^9}, 3.4977289500144587`*^9, {3.499131610142951*^9, 
   3.499131628062976*^9}, 3.515390730886217*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "m"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "/", "m"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "/", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"1", "/", "m"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"1", "/", "m"}], ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, 3.497728444635971*^9, 
   3.4977285439301453`*^9, {3.4977291237207637`*^9, 3.4977291248439655`*^9}, {
   3.4977292472573805`*^9, 3.4977292495817842`*^9}, {3.4979926067685995`*^9, 
   3.497992654379883*^9}, {3.4991316101529512`*^9, 3.499131628072976*^9}, 
   3.515390735566225*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "n"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "n"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "z", "]"}], "n"]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Cosh", "[", "z", "]"}], "n"], 
        SuperscriptBox[
         RowBox[{"Sinh", "[", "z", "]"}], "n"]], ")"}], 
      RowBox[{"1", "/", "n"}]], 
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           SuperscriptBox[
            RowBox[{"Cosh", "[", "z", "]"}], "n"], 
           SuperscriptBox[
            RowBox[{"Sinh", "[", "z", "]"}], "n"]], ")"}], 
         RowBox[{"2", "/", "n"}]]}], ")"}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Cosh", "[", "z", "]"}], "n"], 
      SuperscriptBox[
       RowBox[{"Sinh", "[", "z", "]"}], "n"]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.497729352807166*^9, 3.4977293844996223`*^9}, {
   3.497992700821164*^9, 3.497992745905244*^9}, 3.4979927829085083`*^9, 
   3.49799281764977*^9, {3.499131610172951*^9, 3.499131628092976*^9}, {
   3.5153908007587395`*^9, 3.515390804019145*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "n"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "/", "n"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"1", "/", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"1", "/", "n"}], ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4977275877920647`*^9, 
   3.497728151358655*^9, 3.497728238481609*^9, 3.497728444635971*^9, 
   3.4977285439301453`*^9, {3.4977291237207637`*^9, 3.4977291248439655`*^9}, {
   3.4977292472573805`*^9, 3.4977292495817842`*^9}, {3.4979922482643695`*^9, 
   3.49799229406605*^9}, 3.4979926308394413`*^9, {3.4991316102029514`*^9, 
   3.499131628112976*^9}, {3.51539081791877*^9, 3.5153908213195753`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Cosh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}], "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.497676837075887*^9, {
   3.499131610212951*^9, 3.4991316281229763`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497676465612641*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", "z", "]"}], "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "z", "]"}], "2"]}]}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", "b", "-", "c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, 3.4976764873608847`*^9, {
   3.499131610222951*^9, 3.4991316281429763`*^9}, {3.515687442473916*^9, 
   3.5156874454839206`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "b"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "c"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4976764331417837`*^9, 3.497676440215188*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}], "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}], "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "2"}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", "b", "-", "c", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{
          RowBox[{"2", " ", "d"}], "+", 
          RowBox[{"2", " ", "e", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497676334777158*^9, {3.497676383094921*^9, 3.497676401677984*^9}, {
   3.499131610232951*^9, 3.4991316281529765`*^9}, {3.5156874877439795`*^9, 
   3.515687491033984*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}], "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{"2", ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "+", "b", "-", "c", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", "c"}], ")"}], "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{
             RowBox[{"2", "*", "d"}], "+", 
             RowBox[{"2", "*", "e", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497676053019042*^9, 3.497676309250697*^9, {
   3.4991316102429514`*^9, 3.4991316281629763`*^9}, {3.5156875034240017`*^9, 
   3.5156875068140063`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.497676956996746*^9, {
   3.499131610252951*^9, 3.4991316281729765`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "z", "]"}], " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "z"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, 3.4976770004252305`*^9, {
   3.499131610262951*^9, 3.4991316281829767`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4976770681991067`*^9, 3.4976770695911865`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], " ", 
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", "m"], 
        RowBox[{"a", "+", 
         RowBox[{
          FractionBox["1", "2"], " ", "b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{
            RowBox[{"2", " ", "c"}], "+", 
            RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.497677022476492*^9, 3.4976770426016426`*^9}, {3.499131610272951*^9, 
   3.4991316281929765`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{
            RowBox[{"2", "*", "c"}], "+", 
            RowBox[{"2", "*", "d", "*", "x"}]}], "]"}], "/", "2"}]}]}], 
       ")"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, 
   3.497676975119783*^9, {3.4991316102829514`*^9, 3.499131628202976*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "z", "]"}], " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "z"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, 3.4976770004252305`*^9, {
   3.499131610292951*^9, 3.4991316282129765`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4976766874213276`*^9, 3.497676700561079*^9}, {3.4976771139027205`*^9, 
   3.497677114675765*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{
           FractionBox["1", "2"], " ", "b", " ", 
           RowBox[{"Sinh", "[", 
            RowBox[{
             RowBox[{"2", " ", "c"}], "+", 
             RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.4976765781900797`*^9, 3.4976765810842457`*^9}, {
   3.497676622091591*^9, 3.497676634969328*^9}, {3.497677142048331*^9, 
   3.497677153363978*^9}, {3.499131610312951*^9, 3.4991316282229767`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{
            RowBox[{"2", "*", "c"}], "+", 
            RowBox[{"2", "*", "d", "*", "x"}]}], "]"}], "/", "2"}]}]}], ")"}],
       "^", "n"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"HalfIntegerQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497676050505898*^9, 
   3.4976765187576804`*^9, {3.497676670817378*^9, 3.4976766725164747`*^9}, 
   3.4976769683113937`*^9, 3.4976770887172804`*^9, {3.4991316103229513`*^9, 
   3.4991316282329764`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4978079429925823`*^9, 
   3.497835276823431*^9, {3.4978353630447826`*^9, 3.497835377053607*^9}, {
   3.4991316103329515`*^9, 3.499131628242976*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.497808080032774*^9, 
   3.497835292142658*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Sinh", "[", "z", "]"}], " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "z"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497727769376384*^9, 3.4977279239102554`*^9}, {
   3.4977280278688383`*^9, 3.497728029538041*^9}, {3.49772809175095*^9, 
   3.497728115119791*^9}, {3.4978081055728097`*^9, 3.4978081127928195`*^9}, 
   3.4978353067130837`*^9, {3.4991316103429513`*^9, 3.4991316282529764`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, 
   3.497808194332934*^9, {3.4978353985660453`*^9, 3.497835443447324*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "2"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, 3.497808148012869*^9, 
   3.4978081849229207`*^9, {3.497835330674726*^9, 3.4978353401907425`*^9}, 
   3.497835388285627*^9, {3.499131610352951*^9, 3.4991316282629766`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], "]"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sinh", "[", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "+", 
          RowBox[{"2", "*", "b", "*", 
           RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4978080398827176`*^9, 3.4978352852162457`*^9, {3.4991316103629513`*^9, 
   3.4991316282729764`*^9}, {3.51719042612503*^9, 3.517190428418234*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Csch", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4977276071672993`*^9, 3.4984069663016233`*^9, {
   3.49840956369526*^9, 3.4984095884152946`*^9}, 3.4991316103729515`*^9, 
   3.4991317068730865`*^9, 3.515728574582822*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Csch", "[", "z", "]"}], "+", 
    RowBox[{"Sinh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"Cosh", "[", "z", "]"}], " ", 
    RowBox[{"Coth", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.49840715643189*^9, {
   3.498407308712103*^9, 3.4984073159621134`*^9}, 3.498409641305369*^9, {
   3.4991316103829517`*^9, 3.4991316563030157`*^9}, {3.499131706883086*^9, 
   3.499131706883086*^9}, {3.515728352173231*^9, 3.515728352173231*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4977276559485846`*^9, 3.4977276831862326`*^9}, {
   3.4979913869868565`*^9, 3.497991388203659*^9}, {3.498407021651701*^9, 
   3.498407030171713*^9}, {3.498409650145381*^9, 3.498409650905382*^9}, {
   3.5157283839192867`*^9, 3.5157283839192867`*^9}, 3.515728497347086*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Csch", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], " ", 
          RowBox[{"Coth", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.4977276351693482`*^9, 3.497727644763365*^9}, {
   3.497727950523902*^9, 3.4977279522711053`*^9}, {3.4984069748816357`*^9, 
   3.498407000051671*^9}, {3.498409665405402*^9, 3.4984096826054263`*^9}, {
   3.4991316103929515`*^9, 3.499131656313016*^9}, 3.499131706883086*^9, 
   3.515728493322279*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Csch", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "*", 
        RowBox[{"Coth", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.4984096001853113`*^9, {
   3.4991316104029512`*^9, 3.4991316563230157`*^9}, 3.4991317068930864`*^9, 
   3.5157284101273327`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Sech", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cosh", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "*", 
        RowBox[{"Tanh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497727597947683*^9, 
   3.4979913639144163`*^9, 3.4984069491415997`*^9, 3.4984096001853113`*^9, 
   3.4984097728955526`*^9, {3.499131610432952*^9, 3.4991316432729974`*^9}, 
   3.4991316939630685`*^9, 3.515728591742852*^9, {3.5157286394633355`*^9, 
   3.5157286424273405`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sech", "[", "v", "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", "v", "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, 3.4976651531681385`*^9, {
   3.497665246783903*^9, 3.4976652608707275`*^9}, 3.4984448389818015`*^9, 
   3.499131643282997*^9, 3.499131693973068*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, 
   3.4984448860018673`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Tanh", "[", "z", "]"}]}]}], 
    RowBox[{"Sech", "[", "z", "]"}]], "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, {
   3.4984448860018673`*^9, 3.498444903621892*^9}, {3.4991316104429517`*^9, 
   3.499131643282997*^9}, {3.4991316939830685`*^9, 3.4991316939830685`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"m", "+", "n"}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      FractionBox[
       RowBox[{"m", "-", "1"}], "2"], "\[Element]", 
      "\[DoubleStruckCapitalZ]"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, 
   3.4976651743061757`*^9, {3.4984449155119085`*^9, 3.4984449562019653`*^9}, {
   3.4984449925320168`*^9, 3.498444996612022*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sech", "[", "v", "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Tanh", "[", "v", "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"Cosh", "[", "v", "]"}]}], "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sinh", "[", "v", "]"}]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4976652106074395`*^9, 
   3.4976652204666567`*^9}, 3.4976652749419527`*^9, {3.49844485903183*^9, 
   3.4984448687918434`*^9}, {3.4991316104529514`*^9, 3.4991316432929974`*^9}, 
   3.4991316939930687`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sech", "[", "v_", "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Tanh", "[", "v_", "]"}]}]}], ")"}], "^", "n_."}]}], ",", 
    " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"Cosh", "[", "v", "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sinh", "[", "v", "]"}]}]}], ")"}], "^", "n"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "==", "0"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, {3.4991316104629517`*^9, 3.4991316433029976`*^9}, 
   3.4991316940030684`*^9, 3.5171903861097593`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csch", "[", "v_", "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Coth", "[", "v_", "]"}]}]}], ")"}], "^", "n_."}]}], ",", 
    " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", 
         RowBox[{"Cosh", "[", "v", "]"}]}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sinh", "[", "v", "]"}]}]}], ")"}], "^", "n"}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "==", "0"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4991316104929514`*^9, 
   3.499131656373016*^9}, 3.4991317069430866`*^9, 3.5171903861097593`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Csch", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498333353478813*^9, {3.498336885814452*^9, 3.4983368925380635`*^9}, {
   3.4989598937935734`*^9, 3.498959902013585*^9}, {3.5158663924477725`*^9, 
   3.515866392962573*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, 
   3.4984448860018673`*^9, {3.4989599202336106`*^9, 3.498959922113613*^9}, {
   3.498961978466492*^9, 3.4989619805164948`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"Csch", "[", "z", "]"}], 
    RowBox[{"Sech", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    RowBox[{"Csch", "[", 
     RowBox[{"2", " ", "z"}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, {
   3.4984448860018673`*^9, 3.498444903621892*^9}, 3.498445042812087*^9, {
   3.4989615720559235`*^9, 3.498961574875927*^9}, 3.4989616595060453`*^9, {
   3.4989618266762795`*^9, 3.4989618327962885`*^9}, {3.515866394054575*^9, 
   3.515866394959377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, 
   3.4976651743061757`*^9, {3.4984449155119085`*^9, 3.4984449562019653`*^9}, {
   3.4984449925320168`*^9, 3.498444996612022*^9}, {3.498961534965871*^9, 
   3.498961551775895*^9}, {3.4989618425363016`*^9, 3.4989618427963023`*^9}, {
   3.498964230119644*^9, 3.4989642308496456`*^9}, {3.5158646421386976`*^9, 
   3.515864642372698*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Csch", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   SuperscriptBox[
    RowBox[{"Sech", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["2", "n"]}]}], 
   RowBox[{"\[Integral]", " ", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"Csch", "[", 
       RowBox[{
        RowBox[{"2", "a"}], "+", 
        RowBox[{"2", "b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4976652106074395`*^9, 
   3.4976652204666567`*^9}, 3.4976652749419527`*^9, {3.49844485903183*^9, 
   3.4984448687918434`*^9}, {3.498445062402114*^9, 3.4984450839521446`*^9}, 
   3.4989599380336356`*^9, {3.4989603528242164`*^9, 3.4989603753142476`*^9}, {
   3.4989611343953104`*^9, 3.498961174675367*^9}, 3.4989617501661725`*^9, {
   3.498961856946322*^9, 3.4989618915663705`*^9}, {3.515866395754978*^9, 
   3.515866397907782*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Csch", "[", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", 
           RowBox[{"2", "*", "b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4989599657836742`*^9, 
   3.4989599699336805`*^9}, {3.4989601025038657`*^9, 
   3.4989601755239677`*^9}, {3.498960298844141*^9, 3.498960332734188*^9}, 
   3.498960439724338*^9, 3.498960515504444*^9, {3.4989613073055525`*^9, 
   3.498961346945608*^9}, {3.4989617552761793`*^9, 3.4989617636161914`*^9}, {
   3.498961913586401*^9, 3.4989619310264254`*^9}, {3.515863583544038*^9, 
   3.515863587007244*^9}, {3.5158645818757915`*^9, 3.5158646154158506`*^9}, {
   3.5158663999201856`*^9, 3.5158664026813903`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "p"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}, {3.495385258065951*^9, 
   3.4953852588771524`*^9}, {3.5158636845542154`*^9, 3.515863693337031*^9}, {
   3.515864741495272*^9, 3.515864746487281*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Csch", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    SuperscriptBox[
     RowBox[{"Sech", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      SuperscriptBox["x", "m"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Csch", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      SuperscriptBox[
       RowBox[{"Sech", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "p"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"(", 
      RowBox[{"\[Integral]", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csch", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
        SuperscriptBox[
         RowBox[{"Sech", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "p"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9, {3.495385100474474*^9, 
   3.495385108914089*^9}, 3.4953852236054907`*^9, {3.5158593201278286`*^9, 
   3.5158593965079355`*^9}, {3.5158633301371927`*^9, 3.515863342866815*^9}, {
   3.515866405926196*^9, 3.5158664082038*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "p_."}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Csch", "[", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "*", 
            RowBox[{
             RowBox[{"Sech", "[", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], "]"}], "^", "p"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "p"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9, 
   3.4953849502834396`*^9, {3.5158582978563976`*^9, 3.515858343836462*^9}, {
   3.5158634947954817`*^9, 3.5158635162455196`*^9}, {3.515863554200386*^9, 
   3.5158635705492153`*^9}, {3.5158636259137125`*^9, 
   3.5158636715125923`*^9}, {3.515864691278784*^9, 3.5158646962239923`*^9}, {
   3.515866409717003*^9, 3.51586641383541*^9}, {3.5171904311794386`*^9, 
   3.517190433909444*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "v", "]"}], "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sech", "[", "v", "]"}], "m"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498333353478813*^9, {3.498336885814452*^9, 3.4983368925380635`*^9}, {
   3.4989598937935734`*^9, 3.498959902013585*^9}, 3.5156078761244507`*^9, {
   3.5157249696496906`*^9, 3.5157249701644917`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, 
   3.4984448860018673`*^9, {3.4989599202336106`*^9, 3.498959922113613*^9}, {
   3.498961978466492*^9, 3.4989619805164948`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Tanh", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sech", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", " ", 
    RowBox[{"Tanh", "[", 
     RowBox[{
      FractionBox["z", "2"], "-", 
      RowBox[{
       FractionBox["\[Pi]", "4"], 
       FractionBox["a", "b"]}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, {
   3.4984448860018673`*^9, 3.498444903621892*^9}, 3.498445042812087*^9, {
   3.4989615720559235`*^9, 3.498961574875927*^9}, 3.4989616595060453`*^9, {
   3.4989618266762795`*^9, 3.4989618327962885`*^9}, {3.515607927024522*^9, 
   3.515607972734586*^9}, {3.5157249713032937`*^9, 3.5157249729100966`*^9}, {
   3.515725072906272*^9, 3.5157250769622793`*^9}, 3.515725579329962*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, 
   3.4976651743061757`*^9, {3.4984449155119085`*^9, 3.4984449562019653`*^9}, {
   3.4984449925320168`*^9, 3.498444996612022*^9}, {3.498961534965871*^9, 
   3.498961551775895*^9}, {3.4989618425363016`*^9, 3.4989618427963023`*^9}, {
   3.498964230119644*^9, 3.4989642308496456`*^9}, {3.5156081749148684`*^9, 
   3.5156082012049055`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Tanh", "[", "v", "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sech", "[", "v", "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["a", "n"]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tanh", "[", 
       RowBox[{
        FractionBox["v", "2"], "-", 
        RowBox[{
         FractionBox["\[Pi]", "4"], 
         FractionBox["a", "b"]}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4976652106074395`*^9, 
   3.4976652204666567`*^9}, 3.4976652749419527`*^9, {3.49844485903183*^9, 
   3.4984448687918434`*^9}, {3.498445062402114*^9, 3.4984450839521446`*^9}, 
   3.4989599380336356`*^9, {3.4989603528242164`*^9, 3.4989603753142476`*^9}, {
   3.4989611343953104`*^9, 3.498961174675367*^9}, 3.4989617501661725`*^9, {
   3.498961856946322*^9, 3.4989618915663705`*^9}, {3.5156081147047844`*^9, 
   3.5156081455748277`*^9}, {3.5156082738650074`*^9, 
   3.5156082827950196`*^9}, {3.5157249738148985`*^9, 3.5157249747353*^9}, 
   3.5157253873404245`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Tanh", "[", "v_", "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sech", "[", "v_", "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"v", "/", "2"}], "-", 
          RowBox[{
           RowBox[{"Pi", "/", "4"}], "*", 
           RowBox[{"a", "/", "b"}]}]}], "]"}], "^", "n"}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4989599657836742`*^9, 
   3.4989599699336805`*^9}, {3.4989601025038657`*^9, 
   3.4989601755239677`*^9}, {3.498960298844141*^9, 3.498960332734188*^9}, 
   3.498960439724338*^9, 3.498960515504444*^9, {3.4989613073055525`*^9, 
   3.498961346945608*^9}, {3.4989617552761793`*^9, 3.4989617636161914`*^9}, {
   3.498961913586401*^9, 3.4989619310264254`*^9}, 3.5156078885244675`*^9, {
   3.515608290725031*^9, 3.5156082934250345`*^9}, {3.5157249774653044`*^9, 
   3.51572498060091*^9}, {3.5157250972423153`*^9, 3.515725113856344*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Coth", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Csch", "[", "z", "]"}]}]}], "=", 
   RowBox[{"a", " ", 
    RowBox[{"Coth", "[", 
     RowBox[{
      FractionBox["z", "2"], "+", 
      RowBox[{
       FractionBox[
        RowBox[{" ", 
         RowBox[{"\[Pi]", " ", "\[ImaginaryI]"}]}], "4"], " ", 
       FractionBox[
        RowBox[{"a", "-", "b"}], "b"]}]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, {
   3.4984448860018673`*^9, 3.498444903621892*^9}, 3.498445042812087*^9, {
   3.4989615720559235`*^9, 3.498961574875927*^9}, 3.4989616595060453`*^9, {
   3.4989618266762795`*^9, 3.4989618327962885`*^9}, {3.515607927024522*^9, 
   3.515607972734586*^9}, {3.5157249713032937`*^9, 3.5157249729100966`*^9}, {
   3.515725072906272*^9, 3.5157250769622793`*^9}, {3.5157254442961245`*^9, 
   3.515725459381351*^9}, {3.5157256099840155`*^9, 3.5157256164268265`*^9}, {
   3.5157257516718655`*^9, 3.515725758769878*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"Coth", "[", "v_", "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Csch", "[", "v_", "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Coth", "[", 
         RowBox[{
          RowBox[{"v", "/", "2"}], "+", 
          RowBox[{"Pi", "*", 
           RowBox[{"I", "/", "4"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "-", "b"}], ")"}], "/", "b"}]}]}], "]"}], "^", 
        "n"}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4989599657836742`*^9, 
   3.4989599699336805`*^9}, {3.4989601025038657`*^9, 
   3.4989601755239677`*^9}, {3.498960298844141*^9, 3.498960332734188*^9}, 
   3.498960439724338*^9, 3.498960515504444*^9, {3.4989613073055525`*^9, 
   3.498961346945608*^9}, {3.4989617552761793`*^9, 3.4989617636161914`*^9}, {
   3.498961913586401*^9, 3.4989619310264254`*^9}, 3.5156078885244675`*^9, {
   3.515608290725031*^9, 3.5156082934250345`*^9}, 3.5156085396153793`*^9, {
   3.515724984532117*^9, 3.5157249872309217`*^9}, 3.5157258456620307`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, 
   3.4984448860018673`*^9, {3.4989599202336106`*^9, 3.498959922113613*^9}, {
   3.515607992754614*^9, 3.5156079942646155`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"Sech", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"Tanh", "[", "z", "]"}]}]}], "=", 
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sinh", "[", "z", "]"}]}]}], 
    RowBox[{"Cosh", "[", "z", "]"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, 3.497665167504564*^9, {
   3.4984448860018673`*^9, 3.498444903621892*^9}, 3.498445042812087*^9, {
   3.4989615720559235`*^9, 3.498961574875927*^9}, 3.4989616595060453`*^9, {
   3.5156080076446342`*^9, 3.515608013014642*^9}, {3.5157249906317277`*^9, 
   3.5157249920669303`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"m", " ", "n"}], "-", "1"}], "2"], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", " ", 
      RowBox[{
       RowBox[{"m", " ", "n"}], "<", "0"}]}], ")"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"2", " ", "\[And]", " ", 
         RowBox[{"a", "-", "b"}]}], "=", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, 
   3.4976651743061757`*^9, {3.4984449155119085`*^9, 3.4984449562019653`*^9}, {
   3.4984449925320168`*^9, 3.498444996612022*^9}, {3.498961534965871*^9, 
   3.498961551775895*^9}, {3.498964198899601*^9, 3.4989642024096055`*^9}, {
   3.5156083475551105`*^9, 3.5156083477951107`*^9}, {3.5156083833451605`*^9, 
   3.5156084923953133`*^9}, 3.515725174836851*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox[
        RowBox[{"Tanh", "[", "v", "]"}], "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sech", "[", "v", "]"}], "m"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sinh", "[", "v", "]"}], "m"]}]}], ")"}], "n"]}], 
        SuperscriptBox[
         RowBox[{"Cosh", "[", "v", "]"}], 
         RowBox[{"m", " ", "n"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4976652106074395`*^9, 
   3.4976652204666567`*^9}, 3.4976652749419527`*^9, {3.49844485903183*^9, 
   3.4984448687918434`*^9}, {3.498445062402114*^9, 3.4984450839521446`*^9}, 
   3.4989599380336356`*^9, {3.4989603528242164`*^9, 3.4989603753142476`*^9}, {
   3.4989611343953104`*^9, 3.498961174675367*^9}, {3.5156082289249444`*^9, 
   3.5156082504349747`*^9}, {3.5157249943133345`*^9, 3.5157249959981375`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{
          RowBox[{"Sech", "[", "v_", "]"}], "^", "m_."}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Tanh", "[", "v_", "]"}], "^", "m_."}]}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sinh", "[", "v", "]"}], "^", "m"}]}]}], ")"}], "^", 
        "n"}], "/", 
       RowBox[{
        RowBox[{"Cosh", "[", "v", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "n"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"OddQ", "[", 
       RowBox[{"m", "*", "n"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "*", "n"}], "<", "0"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"m", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"a", "-", "b"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4989599657836742`*^9, 
   3.4989599699336805`*^9}, {3.4989601025038657`*^9, 
   3.4989601755239677`*^9}, {3.498960298844141*^9, 3.498960332734188*^9}, 
   3.498960439724338*^9, 3.498960515504444*^9, {3.4989613073055525`*^9, 
   3.498961346945608*^9}, {3.498964182899578*^9, 3.498964192419592*^9}, 
   3.515607900054484*^9, {3.515724999133743*^9, 3.515725022174983*^9}, 
   3.5157251664908366`*^9, 3.5171903862033596`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{
          RowBox[{"Csch", "[", "v_", "]"}], "^", "m_."}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Coth", "[", "v_", "]"}], "^", "m_."}]}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Cosh", "[", "v", "]"}], "^", "m"}]}]}], ")"}], "^", 
        "n"}], "/", 
       RowBox[{
        RowBox[{"Sinh", "[", "v", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "n"}], ")"}]}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"OddQ", "[", 
       RowBox[{"m", "*", "n"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "*", "n"}], "<", "0"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"m", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"a", "+", "b"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, 3.4976651612957525`*^9, 
   3.4984448448918095`*^9, 3.498445047972094*^9, {3.4989599657836742`*^9, 
   3.4989599699336805`*^9}, {3.4989601025038657`*^9, 
   3.4989601755239677`*^9}, {3.498960298844141*^9, 3.498960332734188*^9}, 
   3.498960439724338*^9, 3.498960515504444*^9, {3.4989613073055525`*^9, 
   3.498961346945608*^9}, {3.498964182899578*^9, 3.498964192419592*^9}, 
   3.515607900054484*^9, 3.515608569455421*^9, {3.515725010240962*^9, 
   3.515725013984969*^9}, 3.51719038621896*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Two Hyperbolic Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1705, 38, 131, "Title"],
Cell[2275, 62, 369, 5, 253, "Subsubsection"],
Cell[2647, 69, 1116, 21, 187, "Subsubsection"],
Cell[3766, 92, 2344, 62, 468, "Subsubtitle"],
Cell[6113, 156, 771, 11, 253, "Subsubsection"],
Cell[6887, 169, 2428, 70, 961, "Code"],
Cell[9318, 241, 2502, 71, 1037, "Code"],
Cell[11823, 314, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[11904, 320, 1449, 30, 80, "Title"],
Cell[13356, 352, 394, 6, 35, "Subsubsection"],
Cell[13753, 360, 375, 5, 25, "Subsubsection"],
Cell[14131, 367, 896, 19, 26, "Subsubsection"],
Cell[15030, 388, 917, 13, 25, "Subsubsection"],
Cell[15950, 403, 1576, 37, 59, "Subsubtitle"],
Cell[17529, 442, 771, 11, 35, "Subsubsection"],
Cell[18303, 455, 1268, 34, 104, "Code"],
Cell[19574, 491, 416, 6, 35, "Subsubsection"],
Cell[19993, 499, 1368, 36, 104, "Code"],
Cell[21364, 537, 89, 2, 35, "Subsubsection"],
Cell[21456, 541, 590, 13, 26, "Subsubsection"],
Cell[22049, 556, 2067, 45, 64, "Subsubtitle"],
Cell[24119, 603, 771, 11, 35, "Subsubsection"],
Cell[24893, 616, 1636, 45, 104, "Code"],
Cell[26532, 663, 1691, 45, 114, "Code"],
Cell[28226, 710, 89, 2, 35, "Subsubsection"],
Cell[28318, 714, 409, 6, 25, "Subsubsection"],
Cell[28730, 722, 1669, 44, 57, "Subsubsection"],
Cell[30402, 768, 633, 12, 26, "Subsubsection"],
Cell[31038, 782, 791, 18, 37, "Subsubsection"],
Cell[31832, 802, 2333, 52, 81, "Subsubtitle"],
Cell[34168, 856, 771, 11, 35, "Subsubsection"],
Cell[34942, 869, 2222, 60, 104, "Code"],
Cell[37167, 931, 1661, 43, 67, "Subsubsection"],
Cell[38831, 976, 2271, 60, 104, "Code"],
Cell[41105, 1038, 89, 2, 35, "Subsubsection"],
Cell[41197, 1042, 446, 6, 25, "Subsubsection"],
Cell[41646, 1050, 895, 19, 26, "Subsubsection"],
Cell[42544, 1071, 2633, 63, 64, "Subsubtitle"],
Cell[45180, 1136, 771, 11, 35, "Subsubsection"],
Cell[45954, 1149, 2618, 72, 129, "Code"],
Cell[48575, 1223, 474, 7, 35, "Subsubsection"],
Cell[49052, 1232, 2690, 73, 129, "Code"],
Cell[51745, 1307, 89, 2, 35, "Subsubsection"],
Cell[51837, 1311, 474, 7, 25, "Subsubsection"],
Cell[52314, 1320, 947, 19, 26, "Subsubsection"],
Cell[53264, 1341, 2777, 67, 66, "Subsubtitle"],
Cell[56044, 1410, 771, 11, 35, "Subsubsection"],
Cell[56818, 1423, 2814, 79, 129, "Code"],
Cell[59635, 1504, 496, 7, 35, "Subsubsection"],
Cell[60134, 1513, 2890, 81, 129, "Code"],
Cell[63027, 1596, 89, 2, 93, "Subsubsection"],
Cell[63119, 1600, 496, 7, 65, "Subsubsection"],
Cell[63618, 1609, 916, 17, 69, "Subsubsection"],
Cell[64537, 1628, 2720, 63, 173, "Subsubtitle"],
Cell[67260, 1693, 771, 11, 93, "Subsubsection"],
Cell[68034, 1706, 2511, 68, 351, "Code"],
Cell[70548, 1776, 522, 7, 93, "Subsubsection"],
Cell[71073, 1785, 2538, 68, 351, "Code"],
Cell[73614, 1855, 89, 2, 93, "Subsubsection"],
Cell[73706, 1859, 512, 7, 65, "Subsubsection"],
Cell[74221, 1868, 940, 17, 69, "Subsubsection"],
Cell[75164, 1887, 2863, 67, 179, "Subsubtitle"],
Cell[78030, 1956, 771, 11, 93, "Subsubsection"],
Cell[78804, 1969, 2667, 74, 351, "Code"],
Cell[81474, 2045, 538, 8, 93, "Subsubsection"],
Cell[82015, 2055, 2727, 75, 351, "Code"],
Cell[84745, 2132, 89, 2, 93, "Subsubsection"],
Cell[84837, 2136, 550, 8, 65, "Subsubsection"],
Cell[85390, 2146, 1116, 22, 69, "Subsubsection"],
Cell[86509, 2170, 2861, 67, 179, "Subsubtitle"],
Cell[89373, 2239, 771, 11, 93, "Subsubsection"],
Cell[90147, 2252, 2850, 78, 351, "Code"],
Cell[93000, 2332, 572, 8, 35, "Subsubsection"],
Cell[93575, 2342, 2914, 80, 129, "Code"],
Cell[96492, 2424, 89, 2, 35, "Subsubsection"],
Cell[96584, 2428, 564, 8, 25, "Subsubsection"],
Cell[97151, 2438, 1143, 22, 26, "Subsubsection"],
Cell[98297, 2462, 2861, 67, 66, "Subsubtitle"],
Cell[101161, 2531, 771, 11, 35, "Subsubsection"],
Cell[101935, 2544, 2789, 76, 129, "Code"],
Cell[104727, 2622, 588, 8, 35, "Subsubsection"],
Cell[105318, 2632, 2869, 77, 129, "Code"],
Cell[108190, 2711, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[108271, 2717, 1452, 26, 80, "Title"],
Cell[109726, 2745, 442, 6, 67, "Subsubsection"],
Cell[110171, 2753, 1001, 25, 71, "Subsubsection"],
Cell[111175, 2780, 1492, 28, 50, "Subsubsection"],
Cell[112670, 2810, 1660, 37, 114, "Subsubtitle"],
Cell[114333, 2849, 771, 11, 67, "Subsubsection"],
Cell[115107, 2862, 2152, 57, 251, "Code"],
Cell[117262, 2921, 89, 2, 67, "Subsubsection"],
Cell[117354, 2925, 442, 6, 47, "Subsubsection"],
Cell[117799, 2933, 1077, 26, 71, "Subsubsection"],
Cell[118879, 2961, 1489, 28, 50, "Subsubsection"],
Cell[120371, 2991, 1777, 38, 114, "Subsubtitle"],
Cell[122151, 3031, 771, 11, 67, "Subsubsection"],
Cell[122925, 3044, 2154, 57, 251, "Code"],
Cell[125082, 3103, 1047, 25, 90, "Subsubsection"],
Cell[126132, 3130, 2128, 57, 251, "Code"],
Cell[128263, 3189, 89, 2, 67, "Subsubsection"],
Cell[128355, 3193, 442, 6, 47, "Subsubsection"],
Cell[128800, 3201, 1082, 24, 50, "Subsubsection"],
Cell[129885, 3227, 1428, 26, 50, "Subsubsection"],
Cell[131316, 3255, 2082, 45, 103, "Subsubtitle"],
Cell[133401, 3302, 771, 11, 67, "Subsubsection"],
Cell[134175, 3315, 1833, 47, 202, "Code"],
Cell[136011, 3364, 1112, 24, 69, "Subsubsection"],
Cell[137126, 3390, 1853, 47, 202, "Code"],
Cell[138982, 3439, 89, 2, 67, "Subsubsection"],
Cell[139074, 3443, 442, 6, 47, "Subsubsection"],
Cell[139519, 3451, 1026, 23, 50, "Subsubsection"],
Cell[140548, 3476, 1426, 26, 50, "Subsubsection"],
Cell[141977, 3504, 2006, 44, 103, "Subsubtitle"],
Cell[143986, 3550, 771, 11, 67, "Subsubsection"],
Cell[144760, 3563, 1831, 47, 202, "Code"],
Cell[146594, 3612, 1054, 23, 69, "Subsubsection"],
Cell[147651, 3637, 1805, 47, 202, "Code"],
Cell[149459, 3686, 89, 2, 67, "Subsubsection"],
Cell[149551, 3690, 442, 6, 47, "Subsubsection"],
Cell[149996, 3698, 1060, 24, 50, "Subsubsection"],
Cell[151059, 3724, 1426, 26, 50, "Subsubsection"],
Cell[152488, 3752, 2040, 45, 103, "Subsubtitle"],
Cell[154531, 3799, 771, 11, 67, "Subsubsection"],
Cell[155305, 3812, 1880, 50, 202, "Code"],
Cell[157188, 3864, 1188, 26, 69, "Subsubsection"],
Cell[158379, 3892, 1936, 51, 202, "Code"],
Cell[160318, 3945, 89, 2, 67, "Subsubsection"],
Cell[160410, 3949, 442, 6, 47, "Subsubsection"],
Cell[160855, 3957, 1083, 24, 50, "Subsubsection"],
Cell[161941, 3983, 1424, 26, 50, "Subsubsection"],
Cell[163368, 4011, 2120, 46, 103, "Subsubtitle"],
Cell[165491, 4059, 771, 11, 67, "Subsubsection"],
Cell[166265, 4072, 1909, 50, 202, "Code"],
Cell[168177, 4124, 1136, 25, 69, "Subsubsection"],
Cell[169316, 4151, 1911, 50, 202, "Code"],
Cell[171230, 4203, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[171311, 4209, 1614, 33, 80, "Title"],
Cell[172928, 4244, 435, 6, 35, "Subsubsection"],
Cell[173366, 4252, 1326, 25, 26, "Subsubsection"],
Cell[174695, 4279, 2341, 61, 69, "Subsubtitle"],
Cell[177039, 4342, 771, 11, 35, "Subsubsection"],
Cell[177813, 4355, 2671, 75, 129, "Code"],
Cell[180487, 4432, 461, 7, 35, "Subsubsection"],
Cell[180951, 4441, 2773, 76, 129, "Code"],
Cell[183727, 4519, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[183786, 4523, 89, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[183900, 4529, 1428, 30, 80, "Title"],
Cell[185331, 4561, 622, 14, 96, "Subsubsection"],
Cell[185956, 4577, 1152, 22, 69, "Subsubsection"],
Cell[187111, 4601, 1611, 41, 179, "Subsubtitle"],
Cell[188725, 4644, 771, 11, 93, "Subsubsection"],
Cell[189499, 4657, 1667, 48, 282, "Code"],
Cell[191169, 4707, 89, 2, 93, "Subsubsection"],
Cell[191261, 4711, 359, 5, 65, "Subsubsection"],
Cell[191623, 4718, 1323, 36, 120, "Subsubsection"],
Cell[192949, 4756, 558, 11, 69, "Subsubsection"],
Cell[193510, 4769, 848, 23, 104, "Subsubsection"],
Cell[194361, 4794, 2087, 47, 159, "Subsubtitle"],
Cell[196451, 4843, 771, 11, 93, "Subsubsection"],
Cell[197225, 4856, 2035, 56, 282, "Code"],
Cell[199263, 4914, 1458, 38, 148, "Subsubsection"],
Cell[200724, 4954, 2090, 57, 282, "Code"],
Cell[202817, 5013, 89, 2, 93, "Subsubsection"],
Cell[202909, 5017, 392, 6, 65, "Subsubsection"],
Cell[203304, 5025, 1173, 22, 69, "Subsubsection"],
Cell[204480, 5049, 2596, 65, 179, "Subsubtitle"],
Cell[207079, 5116, 771, 11, 93, "Subsubsection"],
Cell[207853, 5129, 2562, 76, 351, "Code"],
Cell[210418, 5207, 442, 6, 93, "Subsubsection"],
Cell[210863, 5215, 2588, 76, 351, "Code"],
Cell[213454, 5293, 89, 2, 93, "Subsubsection"],
Cell[213546, 5297, 439, 6, 65, "Subsubsection"],
Cell[213988, 5305, 1638, 35, 104, "Subsubsection"],
Cell[215629, 5342, 2591, 64, 179, "Subsubtitle"],
Cell[218223, 5408, 771, 11, 93, "Subsubsection"],
Cell[218997, 5421, 2550, 73, 351, "Code"],
Cell[221550, 5496, 465, 6, 93, "Subsubsection"],
Cell[222018, 5504, 2522, 73, 351, "Code"],
Cell[224543, 5579, 89, 2, 93, "Subsubsection"],
Cell[224635, 5583, 465, 6, 65, "Subsubsection"],
Cell[225103, 5591, 1316, 24, 69, "Subsubsection"],
Cell[226422, 5617, 2576, 64, 179, "Subsubtitle"],
Cell[229001, 5683, 771, 11, 93, "Subsubsection"],
Cell[229775, 5696, 2573, 75, 351, "Code"],
Cell[232351, 5773, 493, 7, 93, "Subsubsection"],
Cell[232847, 5782, 2556, 74, 351, "Code"],
Cell[235406, 5858, 89, 2, 93, "Subsubsection"],
Cell[235498, 5862, 359, 5, 65, "Subsubsection"],
Cell[235860, 5869, 1759, 50, 201, "Subsubsection"],
Cell[237622, 5921, 633, 9, 65, "Subsubsection"],
Cell[238258, 5932, 1536, 28, 104, "Subsubsection"],
Cell[239797, 5962, 2400, 56, 179, "Subsubtitle"],
Cell[242200, 6020, 771, 11, 93, "Subsubsection"],
Cell[242974, 6033, 2386, 65, 282, "Code"],
Cell[245363, 6100, 1852, 51, 228, "Subsubsection"],
Cell[247218, 6153, 2434, 65, 282, "Code"],
Cell[249655, 6220, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[249736, 6226, 1718, 37, 80, "Title"],
Cell[251457, 6265, 356, 5, 692, "Subsubsection"],
Cell[251816, 6272, 1012, 28, 737, "Subsubsection"],
Cell[252831, 6302, 1278, 24, 510, "Subsubsection"],
Cell[254112, 6328, 2215, 51, 1300, "Subsubtitle"],
Cell[256330, 6381, 771, 11, 692, "Subsubsection"],
Cell[257104, 6394, 2085, 56, 2113, "Code"],
Cell[259192, 6452, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[259273, 6458, 1627, 34, 80, "Title"],
Cell[260903, 6494, 349, 5, 29016073, "Subsubsection"],
Cell[261255, 6501, 654, 17, 32275663, "Subsubsection"],
Cell[261912, 6520, 1112, 20, 21370236, "Subsubsection"],
Cell[263027, 6542, 1616, 40, 66595022, "Subsubtitle"],
Cell[264646, 6584, 771, 11, 29016073, "Subsubsection"],
Cell[265420, 6597, 1553, 43, 88763763, "Code"],
Cell[266976, 6642, 89, 2, 29016073, "Subsubsection"],
Cell[267068, 6646, 380, 5, 19886525, "Subsubsection"],
Cell[267451, 6653, 654, 17, 32275663, "Subsubsection"],
Cell[268108, 6672, 1146, 21, 32275663, "Subsubsection"],
Cell[269257, 6695, 2145, 46, 49598651, "Subsubtitle"],
Cell[271405, 6743, 771, 11, 29016073, "Subsubsection"],
Cell[272179, 6756, 1627, 43, 88763763, "Code"],
Cell[273809, 6801, 44, 1, 2095850, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[273890, 6807, 1584, 33, 80, "Title"],
Cell[275477, 6842, 404, 6, 35, "Subsubsection"],
Cell[275884, 6850, 837, 19, 37, "Subsubsection"],
Cell[276724, 6871, 1095, 19, 26, "Subsubsection"],
Cell[277822, 6892, 1647, 39, 59, "Subsubtitle"],
Cell[279472, 6933, 771, 11, 35, "Subsubsection"],
Cell[280246, 6946, 1539, 42, 104, "Code"],
Cell[281788, 6990, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[281847, 6994, 89, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[281961, 7000, 1613, 34, 80, "Title"],
Cell[283577, 7036, 377, 5, 253, "Subsubsection"],
Cell[283957, 7043, 811, 18, 187, "Subsubsection"],
Cell[284771, 7063, 1115, 15, 174, "Subsubsection"],
Cell[285889, 7080, 1799, 43, 393, "Subsubtitle"],
Cell[287691, 7125, 771, 11, 253, "Subsubsection"],
Cell[288465, 7138, 1610, 44, 771, "Code"],
Cell[290078, 7184, 1708, 46, 848, "Code"],
Cell[291789, 7232, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[291870, 7238, 1499, 30, 80, "Title"],
Cell[293372, 7270, 401, 6, 93, "Subsubsection"],
Cell[293776, 7278, 840, 21, 104, "Subsubsection"],
Cell[294619, 7301, 1404, 29, 104, "Subsubsection"],
Cell[296026, 7332, 1612, 37, 144, "Subsubtitle"],
Cell[297641, 7371, 771, 11, 93, "Subsubsection"],
Cell[298415, 7384, 1559, 41, 282, "Code"],
Cell[299977, 7427, 1579, 41, 310, "Code"],
Cell[301559, 7470, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[301640, 7476, 1536, 32, 80, "Title"],
Cell[303179, 7510, 501, 7, 35, "Subsubsection"],
Cell[303683, 7519, 825, 19, 26, "Subsubsection"],
Cell[304511, 7540, 1329, 22, 26, "Subsubsection"],
Cell[305843, 7564, 1869, 42, 53, "Subsubtitle"],
Cell[307715, 7608, 771, 11, 35, "Subsubsection"],
Cell[308489, 7621, 2069, 49, 104, "Code"],
Cell[310561, 7672, 89, 2, 35, "Subsubsection"],
Cell[310653, 7676, 247, 4, 25, "Subsubsection"],
Cell[310903, 7682, 1701, 30, 26, "Subsubsection"],
Cell[312607, 7714, 2799, 66, 101, "Subsubtitle"],
Cell[315409, 7782, 771, 11, 35, "Subsubsection"],
Cell[316183, 7795, 2818, 72, 129, "Code"],
Cell[319004, 7869, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[319085, 7875, 1577, 32, 80, "Title"],
Cell[320665, 7909, 501, 7, 253, "Subsubsection"],
Cell[321169, 7918, 1245, 32, 282, "Subsubsection"],
Cell[322417, 7952, 1495, 28, 282, "Subsubsection"],
Cell[323915, 7982, 1967, 43, 414, "Subsubtitle"],
Cell[325885, 8027, 771, 11, 253, "Subsubsection"],
Cell[326659, 8040, 2051, 49, 771, "Code"],
Cell[328713, 8091, 1477, 37, 359, "Subsubsection"],
Cell[330193, 8130, 2131, 51, 771, "Code"],
Cell[332327, 8183, 89, 2, 253, "Subsubsection"],
Cell[332419, 8187, 501, 7, 174, "Subsubsection"],
Cell[332923, 8196, 942, 23, 282, "Subsubsection"],
Cell[333868, 8221, 1898, 40, 282, "Subsubsection"],
Cell[335769, 8263, 2009, 45, 502, "Subsubtitle"],
Cell[337781, 8310, 771, 11, 253, "Subsubsection"],
Cell[338555, 8323, 2390, 62, 771, "Code"],
Cell[340948, 8387, 2385, 62, 848, "Code"],
Cell[343336, 8451, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
