(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    425841,      10911]
NotebookOptionsPosition[    408239,      10514]
NotebookOutlinePosition[    409367,      10553]
CellTagsIndexPosition[    409324,      10550]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: G&R 2.261.3 which is correct only for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", "+", 
    RowBox[{"2", " ", "c", " ", "x"}]}], ">", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.495844244480311*^9, 
   3.495844305820397*^9}, {3.4958443596904716`*^9, 3.4958444728106303`*^9}, {
   3.49584462952085*^9, 3.495844638010862*^9}, {3.4958527077421594`*^9, 
   3.4958527290721893`*^9}, {3.495854697367911*^9, 3.4958547166480136`*^9}}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958402261046853`*^9, {3.4958526069920187`*^9, 
   3.4958526117520247`*^9}, {3.4959233132583637`*^9, 3.4959233189283714`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958402463647137`*^9, {3.495852559321952*^9, 3.4958525797819805`*^9}, 
   3.4969612069183855`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.4958422686175447`*^9, 
   3.495842303017593*^9}, {3.4958436313894525`*^9, 3.495843633099455*^9}, {
   3.4958528798424006`*^9, 3.4958529199424562`*^9}, {3.495854757215334*^9, 
   3.4958547601265*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495843517419293*^9, {3.4958523542716646`*^9, 3.495852360971674*^9}, {
   3.4958523983817263`*^9, 3.495852417761753*^9}, {3.4958526254420443`*^9, 
   3.4958526278120475`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "*", "c", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495844519700696*^9, 3.495844553900744*^9}, 
   3.4958480700856667`*^9, {3.495852784802267*^9, 3.4958528313623323`*^9}, {
   3.4958534894532537`*^9, 3.4958534937532597`*^9}, 3.4958547365421515`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.261.2, CRC 237b, A&S 3.3.34", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483218460193`*^9, 
   3.49584832250602*^9}}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4958402261046853`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"ArcSinh", "[", "x", "]"}]}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958402463647137`*^9}],

Cell["\<\
Note: Unlike the formulas in the references, this rule is valid even if c is \
not positive.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958402261046853`*^9, 3.495840381164902*^9, {
   3.495840425944965*^9, 3.4958404478449955`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "a"}], "-", 
     FractionBox[
      SuperscriptBox["b", "2"], "c"]}], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"c", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, 
   3.495848017645593*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox["c"]]}]}], " ", 
   RowBox[{"ArcSinh", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     RowBox[{
      SqrtBox["c"], 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", "a"}], "-", 
        FractionBox[
         SuperscriptBox["b", "2"], "c"]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847580954982*^9, 3.4958475894349937`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSinh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{"c", ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"4", "*", "a"}], "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "/", "c"}]}], "]"}]}], ")"}]}], "]"}], 
    "/", 
    RowBox[{"Rt", "[", 
     RowBox[{"c", ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"4", "*", "a"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.4958476236850414`*^9, 3.4958476279550476`*^9}, 
   3.4958480771456766`*^9, 3.4960144284855285`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.261.3, CRC 238, A&S 3.3.36", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, 3.495840507285079*^9, {
   3.4958483232460213`*^9, 3.495848323886022*^9}}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4958402261046853`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"ArcSin", "[", "x", "]"}]}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958402463647137`*^9, 3.4958405216850986`*^9}],

Cell["\<\
Note: Unlike the formulas in the references, this rule is valid even if c is \
not positive.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958402261046853`*^9, 3.495840381164902*^9, {
   3.495840425944965*^9, 3.4958404478449955`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", " ", "a"}], "-", 
     FractionBox[
      SuperscriptBox["b", "2"], "c"]}], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"c", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, 3.4958480264556055`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"-", "c"}]]]}]}]}], 
   RowBox[{"ArcSin", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"-", "c"}]], 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", "a"}], "-", 
        FractionBox[
         SuperscriptBox["b", "2"], "c"]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958475964350033`*^9, 3.495847602595012*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcSin", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", "2"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"4", "*", "a"}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "/", "c"}]}], "]"}]}], ")"}]}], "]"}]}], 
    "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"4", "*", "a"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, 3.4958407140653687`*^9, 
   3.4958408538655643`*^9, 3.495848081065682*^9, {3.495850360048873*^9, 
   3.495850391518917*^9}, 3.496014431685533*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", "a"}], "-", 
       FractionBox[
        SuperscriptBox["b", "2"], "c"]}], ">", "0"}], ")"}]}], " ", "\[And]", 
   " ", 
   RowBox[{"c", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, {3.4958407302153907`*^9, 
   3.495840731065392*^9}, 3.496059843846301*^9, {3.496060055788274*^9, 
   3.4960600815907187`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      SqrtBox["c"]]}]}], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["c"], " ", "x"}], 
     SqrtBox[
      RowBox[{
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958407691354456`*^9, 3.495840784535467*^9}, {
   3.4960598445639024`*^9, 3.496059866981142*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{"c", ",", "2"}], "]"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{"c", ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"b", "^", "2"}]}], "/", "c"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, 3.4958407140653687`*^9, {
   3.496059846997507*^9, 3.496059872675152*^9}, {3.4960599153880267`*^9, 
   3.49605993431086*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", "a"}], "-", 
       FractionBox[
        SuperscriptBox["b", "2"], "c"]}], ">", "0"}], ")"}]}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"c", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, {3.4958407302153907`*^9, 
   3.495840731065392*^9}, {3.4958409366156797`*^9, 3.4958409538557043`*^9}, 
   3.4960598497899113`*^9, {3.496060106082762*^9, 3.496060114522377*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{"-", "c"}]]]}]}], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"-", "c"}]], " ", "x"}], 
     SqrtBox[
      RowBox[{
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958407691354456`*^9, 3.495840784535467*^9}, {
   3.4958409000856285`*^9, 3.4958409126156464`*^9}, {3.496059850429513*^9, 
   3.4960598770275593`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", "2"}], "]"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"b", "^", "2"}]}], "/", "c"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, 3.4958407140653687`*^9, 
   3.4958408538655643`*^9, {3.4960598523951163`*^9, 3.496059882378369*^9}, {
   3.4960599443104773`*^9, 3.4960599464008813`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.261.1, CRC 237a, A&S 3.3.33", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495840214754669*^9, 
  3.495840507285079*^9, 3.495841665776701*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4958402261046853`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"c", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, {3.4958418720769897`*^9, 
   3.495841895797023*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox["c"]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     RowBox[{"2", " ", 
      SqrtBox["c"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, 3.4958417518368216`*^9, {3.4998209940489454`*^9, 
   3.499821004188963*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{"c", ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{"c", ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, 3.4958416397566643`*^9, {
   3.4958418629869766`*^9, 3.4958418649569798`*^9}, {3.4998210306778097`*^9, 
   3.499821057946658*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 238", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495840214754669*^9, 
  3.495840507285079*^9, 3.495841665776701*^9, 3.495841932447074*^9, 
  3.4958483263560257`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4958402261046853`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"c", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, {3.4958418720769897`*^9, 
   3.495841895797023*^9}, {3.4958419485170965`*^9, 3.495841950487099*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"-", "c"}]]]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"-", "c"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, 3.4958417518368216`*^9, {3.495841969577126*^9, 
   3.4958419863371496`*^9}, {3.4998210103197737`*^9, 3.4998210211305933`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", "2"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}]}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, 3.4958416397566643`*^9, {
   3.4958418629869766`*^9, 3.4958418649569798`*^9}, {3.495841924727063*^9, 
   3.495841942477088*^9}, {3.4998210670414734`*^9, 3.4998210983819284`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4958216891532397`*^9, 3.4958323633864603`*^9, 3.4958421250273438`*^9, {
   3.495842424347763*^9, 3.4958424249777637`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.4958422686175447`*^9, 
   3.495842303017593*^9}, {3.495845497522065*^9, 3.495845527062106*^9}, {
   3.4958458980126257`*^9, 3.4958459051526356`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "c", " ", "x"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], 
      RowBox[{"2", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.4958326509168625`*^9, 
   3.495832653186866*^9}, {3.4958421542873845`*^9, 3.4958422064974575`*^9}, 
   3.4958454826120443`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}, 
   3.4958323917665*^9, 3.4958326113568077`*^9, 3.495842067467263*^9, {
   3.4958422214774785`*^9, 3.495842223037481*^9}, {3.495845554392145*^9, 
   3.4958455927421985`*^9}, {3.495845881762603*^9, 3.495845890502615*^9}, {
   3.496900888756771*^9, 3.4969008921667757`*^9}, {3.496901339157401*^9, 
   3.4969013418074055`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.264.5, CRC 239", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9, 
  3.495842084717287*^9, 3.495842846048353*^9, 3.4958465814435825`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.4958422686175447`*^9, 
   3.495842303017593*^9}, {3.495842936178479*^9, 3.4958429524785023`*^9}, {
   3.49584675825383*^9, 3.4958467622738357`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.4958326509168625`*^9, 
   3.495832653186866*^9}, {3.4958421542873845`*^9, 3.4958422064974575`*^9}, 
   3.4958429073284388`*^9, {3.495846617143633*^9, 3.495846665883701*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}, 
   3.4958323917665*^9, 3.4958326113568077`*^9, 3.495842067467263*^9, {
   3.4958422214774785`*^9, 3.495842223037481*^9}, 3.495842854008364*^9, 
   3.495846573393571*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.260.2, CRC 245, A&S 3.3.37", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9, 
  3.495842084717287*^9, 3.495842846048353*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.4958422686175447`*^9, 
   3.495842303017593*^9}, {3.495842936178479*^9, 3.4958429524785023`*^9}, {
   3.4958512952301817`*^9, 3.4958513194602156`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], "n"]}], 
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}], 
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.4958326509168625`*^9, 
   3.495832653186866*^9}, {3.4958421542873845`*^9, 3.4958422064974575`*^9}, 
   3.4958429073284388`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}, 
   3.4958323917665*^9, 3.4958326113568077`*^9, 3.495842067467263*^9, {
   3.4958422214774785`*^9, 3.495842223037481*^9}, 3.495842854008364*^9, 
   3.4958468114239044`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.263.3, CRC 241", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.49565374201346*^9, 3.495842084717287*^9, 
   3.495842846048353*^9, {3.495851092479898*^9, 3.495851113959928*^9}, {
   3.4958512135800676`*^9, 3.49585121501007*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958219316384664`*^9, 3.4958219817613544`*^9}, {
   3.4958324842466297`*^9, 3.4958325169966755`*^9}, {3.4958422686175447`*^9, 
   3.495842303017593*^9}, {3.495842936178479*^9, 3.4958429524785023`*^9}, {
   3.495851258970131*^9, 3.4958512620401354`*^9}, 3.495851336180239*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "3"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495821744330537*^9, 3.4958217818642025`*^9, {
   3.495832431946556*^9, 3.49583245583659*^9}, {3.4958326509168625`*^9, 
   3.495832653186866*^9}, {3.4958421542873845`*^9, 3.4958422064974575`*^9}, 
   3.4958429073284388`*^9, 3.4958510317998133`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4958217052212677`*^9, {3.4958219175672417`*^9, 3.495821919891646*^9}, 
   3.4958323917665*^9, 3.4958326113568077`*^9, 3.495842067467263*^9, {
   3.4958422214774785`*^9, 3.495842223037481*^9}, 3.495842854008364*^9, 
   3.4958468114239044`*^9, 3.4958508759095945`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4959171454797287`*^9, {3.495918961852271*^9, 3.4959189628422728`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.266.7, CRC 260", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495917184979784*^9}],

Cell[TextData[{
 "Note: This is an unnecessary special case of the integration rule for ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"]}]]],
 " when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]}], "=", "0"}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495917184979784*^9, {3.495917216009827*^9, 
   3.495917235099854*^9}, 3.496249689429512*^9, {3.4962509381805053`*^9, 
   3.4962510044650216`*^9}, {3.496251048004698*^9, 3.4962510512807035`*^9}, {
   3.496251329155592*^9, 3.4962513351772027`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      RowBox[{"c", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4959173452100077`*^9, 3.495917356290024*^9}, 
   3.495917390720072*^9, 3.4962513013563433`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d_", "+", 
          RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "   ", 
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", "x"}]}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"d", "^", "2"}]}], "+", 
       RowBox[{"a", "*", 
        RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495917118599691*^9, {3.495917419010112*^9, 3.4959174419301434`*^9}, {
   3.4959191496625347`*^9, 3.4959191542125406`*^9}, 3.4998296569361315`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.1, CRC 258", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959178419907036`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"c", " ", 
          SuperscriptBox["d", "2"]}], "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["e", "2"]}]}]]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "e"}], "-", 
      RowBox[{"c", " ", "d", " ", "x"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"c", " ", 
         SuperscriptBox["d", "2"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, {
   3.4998206108498726`*^9, 3.499820634171913*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "e"}], "-", 
         RowBox[{"c", "*", "d", "*", "x"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"c", "*", 
             RowBox[{"d", "^", "2"}]}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}]}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"d", "^", "2"}]}], "+", 
       RowBox[{"a", "*", 
        RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918683721882*^9, 3.4959186875418873`*^9}, 
   3.4959187348719535`*^9, {3.4998206544207487`*^9, 3.49982066633917*^9}, 
   3.499829597806049*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.3, CRC 259", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959178419907036`*^9, 
  3.495918438011538*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", 
       SuperscriptBox["d", "2"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["e", "2"]}]}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.495918531511669*^9, 3.495918542881685*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", 
         SuperscriptBox["d", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "e"}], "-", 
      RowBox[{"c", " ", "d", " ", "x"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", 
         SuperscriptBox["d", "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, {
   3.4959193784228544`*^9, 3.495919387472867*^9}, {3.49982071778806*^9, 
   3.499820736086892*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "e"}], "-", 
        RowBox[{"c", "*", "d", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "c"}], "*", 
            RowBox[{"d", "^", "2"}]}], "-", 
           RowBox[{"a", "*", 
            RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}], "/", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", 
        RowBox[{"d", "^", "2"}]}], "-", 
       RowBox[{"a", "*", 
        RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918449101554*^9, 3.4959184735315876`*^9}, {
   3.495918558431707*^9, 3.495918562951713*^9}, {3.4959186247817993`*^9, 
   3.49591863922182*^9}, {3.4959186765118723`*^9, 3.495918679121876*^9}, 
   3.495918772962007*^9, {3.4959188930621753`*^9, 3.4959189056721926`*^9}, {
   3.4998207503141174`*^9, 3.4998207597053337`*^9}, 3.4998296016460543`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4959171454797287`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.266.7, CRC 260", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495917184979784*^9, 
  3.4959190232023573`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"b", " ", "d", " ", "e"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "c", " ", "d"}], "-", 
      RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, {
   3.495919181752579*^9, 3.495919187992588*^9}, {3.4962729937713437`*^9, 
   3.4962729937713437`*^9}, {3.4962730304313946`*^9, 
   3.4962730304313946`*^9}, {3.496278948283682*^9, 3.4962789712937145`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " ", "e", " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4959173452100077`*^9, 3.495917356290024*^9}, 
   3.495917390720072*^9, 3.495919114822486*^9, 3.495919208222616*^9, {
   3.4962722861103525`*^9, 3.4962722986203704`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", "e", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495917118599691*^9, {3.495917419010112*^9, 3.4959174419301434`*^9}, 
   3.4959190096523385`*^9, {3.4962723352604218`*^9, 3.4962723439504337`*^9}, {
   3.4962750193481817`*^9, 3.496275023768188*^9}, {3.4962789791037254`*^9, 
   3.4962790178737793`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.266.6 which is correct only for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "a"}], "+", 
    RowBox[{"b", " ", "x"}]}], ">", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.495844244480311*^9, 
   3.495844305820397*^9}, {3.4958443596904716`*^9, 3.4958444728106303`*^9}, {
   3.49584462952085*^9, 3.495844638010862*^9}, {3.4958527077421594`*^9, 
   3.4958527290721893`*^9}, {3.495854697367911*^9, 3.4958547166480136`*^9}, {
   3.496280200625436*^9, 3.4962802027354383`*^9}, {3.496280255805513*^9, 
   3.496280262545522*^9}}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4958402261046853`*^9, {3.4958526069920187`*^9, 
   3.4958526117520247`*^9}, {3.4959233132583637`*^9, 3.4959233189283714`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4958402463647137`*^9, {3.495852559321952*^9, 3.4958525797819805`*^9}, 
   3.4969612145983963`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.4959195454030886`*^9, 3.495919550903096*^9}, {
   3.496266864832709*^9, 3.49626690852277*^9}, {3.4962675011935997`*^9, 
   3.4962675011935997`*^9}, {3.4962724349805613`*^9, 
   3.4962724553805895`*^9}, {3.4969612268184137`*^9, 3.4969612273484144`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "c", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, 
   3.495919117042489*^9, {3.495919299342744*^9, 3.4959193169627686`*^9}, {
   3.4962723066503816`*^9, 3.4962723092703853`*^9}, 3.496272421810543*^9, {
   3.496273868254569*^9, 3.4962738718745737`*^9}, {3.496273908944626*^9, 
   3.496273930494656*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"2", "*", "c", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918683721882*^9, 3.4959186875418873`*^9}, 
   3.4959187348719535`*^9, 3.49591908217244*^9, {3.4959192298026466`*^9, 
   3.495919254562681*^9}, {3.496251680684536*^9, 3.4962516883345466`*^9}, {
   3.4962517250745983`*^9, 3.496251737674616*^9}, {3.496266938142812*^9, 
   3.496266945372822*^9}, {3.496272354500448*^9, 3.496272357050452*^9}, {
   3.4962725712607517`*^9, 3.4962725816307664`*^9}, 3.496274289065158*^9, {
   3.4962744626474023`*^9, 3.496274473807418*^9}, 3.496279602384598*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "d"}], "-", 
    RowBox[{"b", " ", "e"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "c"], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.4959195454030886`*^9, 3.495919550903096*^9}, {
   3.496266864832709*^9, 3.49626690852277*^9}, {3.4962675011935997`*^9, 
   3.4962675011935997`*^9}, {3.499829863626421*^9, 3.499829876466439*^9}, {
   3.499831305338439*^9, 3.499831305338439*^9}, {3.499831675218957*^9, 
   3.499831744449054*^9}, {3.499831825259167*^9, 3.4998318275991707`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"e", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], "c"]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     SqrtBox[
      FractionBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}], "c"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, 
   3.4959191198024926`*^9, 3.4959195220930557`*^9, {3.4962723135203915`*^9, 
   3.4962723167703953`*^9}, {3.499820821231842*^9, 3.4998208331814632`*^9}, 
   3.4998311927982817`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", "c"}], ",", 
         "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", "c"}], ",", 
         "2"}], "]"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", "c"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918449101554*^9, 3.4959184735315876`*^9}, {
   3.495918558431707*^9, 3.495918562951713*^9}, {3.4959186247817993`*^9, 
   3.49591863922182*^9}, {3.4959186765118723`*^9, 3.495918679121876*^9}, 
   3.495918772962007*^9, {3.4959188930621753`*^9, 3.4959189056721926`*^9}, 
   3.495919094472457*^9, {3.495919420312913*^9, 3.4959194881730084`*^9}, {
   3.4962517437946243`*^9, 3.4962517500346327`*^9}, {3.496266953782833*^9, 
   3.4962669552528353`*^9}, {3.496272361270458*^9, 3.496272363520461*^9}, {
   3.4998208841467524`*^9, 3.4998208932727685`*^9}, {3.4998298463463964`*^9, 
   3.499829848066399*^9}, {3.4998313121684484`*^9, 3.4998313139684515`*^9}, {
   3.499831373328534*^9, 3.4998314100385857`*^9}, {3.4998318350791807`*^9, 
   3.4998318364391828`*^9}, {3.499831882189247*^9, 3.499831902819276*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "d"}], "-", 
    RowBox[{"b", " ", "e"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}], "c"], ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.4959195454030886`*^9, 3.495919550903096*^9}, {
   3.496266864832709*^9, 3.49626690852277*^9}, {3.4962675011935997`*^9, 
   3.4962675011935997`*^9}, {3.499829863626421*^9, 3.499829876466439*^9}, {
   3.499831305338439*^9, 3.499831305338439*^9}, {3.499831675218957*^9, 
   3.499831744449054*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"e", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"4", " ", "a", " ", "c"}], "-", 
           SuperscriptBox["b", "2"]}], "c"]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}], 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", "a", " ", "c"}], "-", 
        SuperscriptBox["b", "2"]}], "c"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, 
   3.495919117042489*^9, {3.495919299342744*^9, 3.4959193169627686`*^9}, {
   3.4962723066503816`*^9, 3.4962723092703853`*^9}, {3.4998208010766068`*^9, 
   3.4998208122930264`*^9}, {3.4998307415876503`*^9, 3.499830754617668*^9}, {
   3.499831223518325*^9, 3.499831269388389*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"e", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", "*", "a", "*", "c"}], "-", 
            RowBox[{"b", "^", "2"}]}], ")"}], "/", "c"}], ",", "2"}], "]"}]}],
       ")"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"2", "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", "*", "a", "*", "c"}], "-", 
            RowBox[{"b", "^", "2"}]}], ")"}], "/", "c"}], ",", "2"}], 
        "]"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], ")"}], "/", "c"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918683721882*^9, 3.4959186875418873`*^9}, 
   3.4959187348719535`*^9, 3.49591908217244*^9, {3.4959192298026466`*^9, 
   3.495919254562681*^9}, {3.496251680684536*^9, 3.4962516883345466`*^9}, {
   3.4962517250745983`*^9, 3.496251737674616*^9}, {3.496266938142812*^9, 
   3.496266945372822*^9}, {3.496272354500448*^9, 3.496272357050452*^9}, {
   3.499820867236323*^9, 3.499820872509132*^9}, {3.499829824316366*^9, 
   3.499829837256384*^9}, {3.499830665017543*^9, 3.499830669167549*^9}, {
   3.499831360378516*^9, 3.499831368798528*^9}, 3.4998314170385957`*^9, {
   3.49983150573872*^9, 3.4998315852388315`*^9}, {3.4998316397989073`*^9, 
   3.499831640838909*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.1, CRC 258", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959178419907036`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.4959195454030886`*^9, 3.495919550903096*^9}, {
   3.496266864832709*^9, 3.49626690852277*^9}, {3.4962675011935997`*^9, 
   3.4962675011935997`*^9}, {3.499829863626421*^9, 3.499829876466439*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{
         RowBox[{"c", " ", 
          SuperscriptBox["d", "2"]}], "-", 
         RowBox[{"b", " ", "d", " ", "e"}], "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["e", "2"]}]}]]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "a", " ", "e"}], "-", 
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"c", " ", 
         SuperscriptBox["d", "2"]}], "-", 
        RowBox[{"b", " ", "d", " ", "e"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, 
   3.495919117042489*^9, {3.495919299342744*^9, 3.4959193169627686`*^9}, {
   3.4962723066503816`*^9, 3.4962723092703853`*^9}, {3.4998208010766068`*^9, 
   3.4998208122930264`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"d", "^", "2"}]}], "-", 
        RowBox[{"b", "*", "d", "*", "e"}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}]}], "*", "\n", "  ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "a", "*", "e"}], "-", 
        RowBox[{"b", "*", "d"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "c", "*", "d"}], "-", 
           RowBox[{"b", "*", "e"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"c", "*", 
            RowBox[{"d", "^", "2"}]}], "-", 
           RowBox[{"b", "*", "d", "*", "e"}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918683721882*^9, 3.4959186875418873`*^9}, 
   3.4959187348719535`*^9, 3.49591908217244*^9, {3.4959192298026466`*^9, 
   3.495919254562681*^9}, {3.496251680684536*^9, 3.4962516883345466`*^9}, {
   3.4962517250745983`*^9, 3.496251737674616*^9}, {3.496266938142812*^9, 
   3.496266945372822*^9}, {3.496272354500448*^9, 3.496272357050452*^9}, {
   3.499820867236323*^9, 3.499820872509132*^9}, {3.499829824316366*^9, 
   3.499829837256384*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.3, CRC 259", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959178419907036`*^9, 
  3.495918438011538*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"c", " ", 
        SuperscriptBox["d", "2"]}], "-", 
       RowBox[{"b", " ", "d", " ", "e"}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["e", "2"]}]}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4959176534804397`*^9, 3.495917659330448*^9}, 
   3.4959182918113337`*^9, {3.495918531511669*^9, 3.495918542881685*^9}, 
   3.4959195576831055`*^9, {3.4962669318728027`*^9, 3.4962669318728027`*^9}, {
   3.496267506923608*^9, 3.496267506923608*^9}, {3.4998298859564524`*^9, 
   3.4998298859564524`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", 
         SuperscriptBox["d", "2"]}], "+", 
        RowBox[{"b", " ", "d", " ", "e"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "a", " ", "e"}], "-", 
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], " ", 
         SuperscriptBox["d", "2"]}], "+", 
        RowBox[{"b", " ", "d", " ", "e"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["e", "2"]}]}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495917348740013*^9, {3.495917933900832*^9, 
   3.495917934590833*^9}, {3.495918204401211*^9, 3.495918223261237*^9}, 
   3.4959191198024926`*^9, 3.4959195220930557`*^9, {3.4962723135203915`*^9, 
   3.4962723167703953`*^9}, {3.499820821231842*^9, 3.4998208331814632`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d_.", "+", 
         RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], "*", 
         RowBox[{"d", "^", "2"}]}], "+", 
        RowBox[{"b", "*", "d", "*", "e"}], "-", 
        RowBox[{"a", "*", 
         RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}]}], "*", "\n", "  ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "a", "*", "e"}], "-", 
        RowBox[{"b", "*", "d"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "c", "*", "d"}], "-", 
           RowBox[{"b", "*", "e"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "c"}], "*", 
            RowBox[{"d", "^", "2"}]}], "+", 
           RowBox[{"b", "*", "d", "*", "e"}], "-", 
           RowBox[{"a", "*", 
            RowBox[{"e", "^", "2"}]}]}], ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.495917833070691*^9, {3.4959180306909676`*^9, 
   3.495918053771*^9}, {3.495918449101554*^9, 3.4959184735315876`*^9}, {
   3.495918558431707*^9, 3.495918562951713*^9}, {3.4959186247817993`*^9, 
   3.49591863922182*^9}, {3.4959186765118723`*^9, 3.495918679121876*^9}, 
   3.495918772962007*^9, {3.4959188930621753`*^9, 3.4959189056721926`*^9}, 
   3.495919094472457*^9, {3.495919420312913*^9, 3.4959194881730084`*^9}, {
   3.4962517437946243`*^9, 3.4962517500346327`*^9}, {3.496266953782833*^9, 
   3.4962669552528353`*^9}, {3.496272361270458*^9, 3.496272363520461*^9}, {
   3.4998208841467524`*^9, 3.4998208932727685`*^9}, {3.4998298463463964`*^9, 
   3.499829848066399*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4959201967940006`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.265b", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4959202203740335`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.49592034646421*^9, 3.495920375734251*^9}, {
   3.495920626984603*^9, 3.495920648374633*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
       RowBox[{"2", " ", "e", " ", "n"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["e", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.495920251564077*^9, 3.4959203176241693`*^9, {
   3.4959218619763317`*^9, 3.4959218649363356`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "e", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"e", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, {
   3.4959202401540613`*^9, 3.4959202747641096`*^9}, {3.4959218685563407`*^9, 
   3.4959218828263607`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.265b", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959207796548166`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4959207989548435`*^9, 
   3.4959208116248612`*^9}, {3.4959221327367105`*^9, 3.495922139976721*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
       RowBox[{"2", " ", "e", " ", "n"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], 
    SuperscriptBox["e", "2"]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4959202544540815`*^9, 3.495920851324917*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "e", "*", "n"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}], "-", 
         RowBox[{"b", "*", "d", "*", "e"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"e", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4959207463947697`*^9, 3.4959208299448867`*^9, 
   3.495922027706564*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.265b", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959207796548166`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4959207989548435`*^9, 
   3.4959208116248612`*^9}, {3.4959209502150555`*^9, 3.495920952235058*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
       RowBox[{"2", " ", "e", " ", "n"}]]}]}]}]}], "-", 
  "                                                                        ", 
  "\[IndentingNewLine]", "               ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["e", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], 
    SuperscriptBox["e", "2"]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4959202544540815`*^9, 3.495920851324917*^9, {
   3.495921131525309*^9, 3.4959211600953493`*^9}, {3.4959219011263866`*^9, 
   3.495921904576391*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "e", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"e", "^", "2"}]}], ")"}]}], ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}], "-", 
         RowBox[{"b", "*", "d", "*", "e"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"e", "^", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4959207463947697`*^9, 3.4959208299448867`*^9, {
   3.4959209442050467`*^9, 3.4959209689350815`*^9}, {3.4959219169464083`*^9, 
   3.4959219190064116`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.268b, CRC 122", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959207796548166`*^9, 
  3.495921259485488*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", 
       SuperscriptBox["d", "2"]}], "-", 
      RowBox[{"b", " ", "d", " ", "e"}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["e", "2"]}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4959207989548435`*^9, 
   3.4959208116248612`*^9}, {3.495921412245702*^9, 3.495921413635704*^9}, {
   3.495921501705827*^9, 3.495921512905843*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SuperscriptBox["d", "2"]}], "-", 
           RowBox[{"b", " ", "d", " ", "e"}], "+", 
           RowBox[{"a", " ", 
            SuperscriptBox["e", "2"]}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["e", "2"], 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4959202544540815`*^9, 3.495920851324917*^9, 
   3.495921324185579*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "*", 
           RowBox[{"d", "^", "2"}]}], "-", 
          RowBox[{"b", "*", "d", "*", "e"}], "+", 
          RowBox[{"a", "*", 
           RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}], "-", 
         RowBox[{"b", "*", "d", "*", "e"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4959207463947697`*^9, 3.4959208299448867`*^9, {
   3.4959212830755215`*^9, 3.495921290445532*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.268b, CRC 122", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4959207796548166`*^9, 
  3.495921259485488*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4959207989548435`*^9, 
   3.4959208116248612`*^9}, {3.495921412245702*^9, 3.495921413635704*^9}, {
   3.495921501705827*^9, 3.495921512905843*^9}, {3.4959216232859974`*^9, 
   3.495921625176*^9}, {3.4959220895866504`*^9, 3.4959220924566545`*^9}, {
   3.4959221736767683`*^9, 3.4959221954167986`*^9}, {3.4959223513970165`*^9, 
   3.495922352327018*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", 
            SuperscriptBox["d", "2"]}], "-", 
           RowBox[{"b", " ", "d", " ", "e"}], "+", 
           RowBox[{"a", " ", 
            SuperscriptBox["e", "2"]}]}], ")"}]}]]}]}]}]}]}], "+", 
  "                                                                       ", 
  "\[IndentingNewLine]", "                      ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", 
        SuperscriptBox["d", "2"]}], "-", 
       RowBox[{"b", " ", "d", " ", "e"}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["e", "2"]}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["e", "2"], 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4959202544540815`*^9, 3.495920851324917*^9, 
   3.495921324185579*^9, {3.495921597815962*^9, 3.4959216105759797`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "*", 
           RowBox[{"d", "^", "2"}]}], "-", 
          RowBox[{"b", "*", "d", "*", "e"}], "+", 
          RowBox[{"a", "*", 
           RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "*", 
            RowBox[{"d", "^", "2"}]}], "-", 
           RowBox[{"b", "*", "d", "*", "e"}], "+", 
           RowBox[{"a", "*", 
            RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", " ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}], "-", 
         RowBox[{"b", "*", "d", "*", "e"}], "+", 
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4959207463947697`*^9, 3.4959208299448867`*^9, {
   3.4959212830755215`*^9, 3.495921290445532*^9}, {3.495921549885895*^9, 
   3.495921564285915*^9}, {3.4959220675466194`*^9, 3.4959220720566254`*^9}, 
   3.495922347367011*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495922890087771*^9, 3.4959229005877857`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Algebraic expansion and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "4"]}]}], "=", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "-", "q"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "+", "q"}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, {3.496961245218439*^9, 
   3.4969612525084496`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "2"]}], 
         RowBox[{"b", "-", "q"}]]}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "2"]}], 
         RowBox[{"b", "+", "q"}]]}]]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4969612509084473`*^9, 3.496961262098463*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "-", "q"}]]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "+", "q"}]]}]]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "-", "q"}]]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "+", "q"}]]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "-", "q"}], ")"}]}]}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{"2", "*", "c", "*", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q"}], ")"}]}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "4"}]}]}], "]"}]}], "*", "\n", "  ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{
               RowBox[{"x", "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "-", "q"}], ")"}]}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{
               RowBox[{"x", "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "+", "q"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, {
   3.495922890087771*^9, 3.4959229005877857`*^9}, 3.496281212036852*^9, {
   3.4967267140808764`*^9, 3.49672671623368*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, {3.4962809620265017`*^9, 3.496280965046506*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["x", "2"]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.4969612696284733`*^9, 
   3.4969612824984913`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4962806723160963`*^9, 
   3.4962806826661105`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4962809247964497`*^9, 3.4962809525964885`*^9}, {
   3.4962812156468563`*^9, 3.496281235446884*^9}, {3.496726728027301*^9, 
   3.496726737184517*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "4"}]}]}], "]"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", "*", "c", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, {
   3.4962810697866526`*^9, 3.4962810798566666`*^9}, {3.4962812448668976`*^9, 
   3.496281250606906*^9}, {3.49672674489093*^9, 3.4967267583693542`*^9}, {
   3.496726800988629*^9, 3.496726806089838*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, 3.4971601701650543`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    SqrtBox["a"], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "-", "q"}]]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "+", "q"}]]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, {3.4969612992285147`*^9, 
   3.496961302318519*^9}, {3.497160285605257*^9, 3.4971603517337737`*^9}, 
   3.497160660739116*^9, {3.4971607561176834`*^9, 3.4971607765537195`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"a", ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4971602295387588`*^9, 
   3.4971602339691668`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SqrtBox["a"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "-", "q"}]]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "+", "q"}]]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4959235009586263`*^9, 3.4959235044486313`*^9}, 
   3.495923597958762*^9, {3.4967267852794013`*^9, 3.496726787416605*^9}, {
   3.497160187917886*^9, 3.497160191381092*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "a", "]"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", "c", "*", 
               RowBox[{
                RowBox[{"x", "^", "2"}], "/", 
                RowBox[{"(", 
                 RowBox[{"b", "-", "q"}], ")"}]}]}]}], "]"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{"2", "*", "c", "*", 
               RowBox[{
                RowBox[{"x", "^", "2"}], "/", 
                RowBox[{"(", 
                 RowBox[{"b", "+", "q"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", 
         "x"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, 
   3.495923494298617*^9, {3.495923555498702*^9, 3.4959235563087034`*^9}, 
   3.4967267756697845`*^9, {3.49672681861666*^9, 3.4967268308626814`*^9}, {
   3.497159195377345*^9, 3.49715920372336*^9}, {3.4971596430245285`*^9, 
   3.4971596546621494`*^9}, {3.4971597187782617`*^9, 3.4971597300570817`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic expansion and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "4"]}]}], "=", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "-", "q"}]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"b", "+", "q"}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, {3.4969612992285147`*^9, 
   3.496961302318519*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ",",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "2"]}], 
         RowBox[{"b", "-", "q"}]]}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "2"]}], 
         RowBox[{"b", "+", "q"}]]}]]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4969613045685225`*^9, 3.4969613072085257`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "-", "q"}]]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "+", "q"}]]}]]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "-", "q"}]]}]], " ", 
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", " ", "c", " ", 
           SuperscriptBox["x", "2"]}], 
          RowBox[{"b", "+", "q"}]]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4959235009586263`*^9, 3.4959235044486313`*^9}, 
   3.495923597958762*^9, {3.4967267852794013`*^9, 3.496726787416605*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "-", "q"}], ")"}]}]}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{"2", "*", "c", "*", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q"}], ")"}]}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "2"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "4"}]}]}], "]"}]}], "*", "\n", "  ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{
               RowBox[{"x", "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "-", "q"}], ")"}]}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{
               RowBox[{"x", "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "+", "q"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, 
   3.495923494298617*^9, {3.495923555498702*^9, 3.4959235563087034`*^9}, 
   3.4967267756697845`*^9, {3.49672681861666*^9, 3.4967268308626814`*^9}, {
   3.497159195377345*^9, 3.49715920372336*^9}, {3.4971596430245285`*^9, 
   3.4971596546621494`*^9}, {3.497159756187127*^9, 3.497159770710753*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, {
   3.4961889629008017`*^9, 3.4961889634008026`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.266.7, CRC 260", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958405564251475`*^9, 3.4958405599751525`*^9}, {3.4958474015647306`*^9, 
   3.4958474065747375`*^9}, {3.4958475556249466`*^9, 3.495847559034951*^9}, 
   3.49584800093557*^9, 3.495848221025878*^9, {3.4958482556659265`*^9, 
   3.4958482563859277`*^9}, 3.4959266155529866`*^9, {3.4959267677331996`*^9, 
   3.495926773033207*^9}, 3.4959268267632823`*^9, 3.496185030185296*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", 
            RowBox[{"2", "n"}]]}]}]]}], 
       RowBox[{"b", " ", "n", " ", 
        SuperscriptBox["x", "n"]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.496188965010805*^9, 3.4961889679408092`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_."}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "j"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"x", "^", "n"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.4961888912207017`*^9, {3.4961889690308104`*^9, 3.4961889711708136`*^9}, 
   3.4961920450977497`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.1, CRC 258", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.4961852577556148`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{"a", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.496185249265603*^9, 
   3.4961852497756033`*^9}, {3.4962674849735775`*^9, 
   3.4962674849735775`*^9}, {3.4962675275136366`*^9, 3.4962675275136366`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{
        SqrtBox["a"], " ", "n"}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"2", " ", 
      SqrtBox["a"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961852001955347`*^9, 3.4961852261055703`*^9}, {
   3.4961852728856363`*^9, 3.496185277225642*^9}, {3.4961889744708185`*^9, 
   3.4961889761008205`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_."}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "a"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", 
         RowBox[{"Rt", "[", 
          RowBox[{"a", ",", "2"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "j"}]}]}], "]"}]}], ")"}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"n", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.4961850632853427`*^9, 3.496188893830705*^9, {3.4961889768608217`*^9, 
   3.496188978130823*^9}, 3.496192046997752*^9, 3.49626756538369*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.266.3, CRC 259", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.4961852577556148`*^9, 
   3.496185323645707*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"a", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.496185249265603*^9, 
   3.4961852497756033`*^9}, {3.496185408715826*^9, 3.496185414315834*^9}, {
   3.4962675483036656`*^9, 3.4962675483036656`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", "a"}]], " ", "n"}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "a"}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"-", "a"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961852001955347`*^9, 3.4961852261055703`*^9}, {
   3.4961852728856363`*^9, 3.496185277225642*^9}, 3.4961853904358006`*^9, {
   3.4961889798108253`*^9, 3.4961889815208282`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_."}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "a"}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "2"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "j"}]}]}], "]"}]}], ")"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"n", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.4961850632853427`*^9, 3.4961853185857*^9, 3.4961888959707084`*^9, {
   3.496188982370829*^9, 3.496188986330835*^9}, 3.496192048577755*^9, 
   3.4962675676636925`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, {
   3.4961889629008017`*^9, 3.4961889634008026`*^9}, 3.4968611644590693`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Algebraic manipulation and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, {3.4962809620265017`*^9, 3.496280965046506*^9}, {
   3.49689985967533*^9, 3.496899870215345*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], "=", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", " ", "c"}], ")"}], 
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     RowBox[{"2", " ", "p"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999828455024`*^9, 
   3.4969000307455697`*^9}, {3.4969000933956575`*^9, 
   3.4969000955656605`*^9}, {3.496961329248557*^9, 3.4969613347485647`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999237054195`*^9, 
   3.496899927365425*^9}, {3.496961343778577*^9, 3.496961351628588*^9}, {
   3.496962172669738*^9, 3.496962173019738*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4962806723160963`*^9, 
   3.4962806826661105`*^9}, 3.4968968557611246`*^9, 3.4968968959111805`*^9, {
   3.4968997096451197`*^9, 3.4968997236051397`*^9}, {3.49690144536755*^9, 
   3.49690144536755*^9}, {3.496904028191166*^9, 3.4969040468411922`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", " ", "c"}], ")"}], 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4962809247964497`*^9, 3.4962809525964885`*^9}, {
   3.4968952590972276`*^9, 3.4968952762260575`*^9}, 3.4968963479804134`*^9, {
   3.4968964242805204`*^9, 3.4968964394505415`*^9}, {3.4968964901406126`*^9, 
   3.496896504500633*^9}, {3.496899530084869*^9, 3.4968995686849227`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}]}], "*", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "*", "c"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"2", "*", "c", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "p"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, {
   3.4962810697866526`*^9, 3.4962810798566666`*^9}, {3.49687170143589*^9, 
   3.496871705913098*^9}, {3.496895397453871*^9, 3.4968954002774754`*^9}, {
   3.496895434893936*^9, 3.496895489806033*^9}, {3.4968956828251715`*^9, 
   3.4968956853523765`*^9}, {3.4968966669908605`*^9, 
   3.4968966700708647`*^9}, {3.4968967114709225`*^9, 
   3.4968967507709775`*^9}, {3.4968968232910795`*^9, 
   3.4968968293410873`*^9}, {3.4968990936242576`*^9, 3.496899115884289*^9}, {
   3.4968997370051584`*^9, 3.4968997671052003`*^9}, {3.496900141125724*^9, 
   3.4969001439857283`*^9}, 3.4969014475975533`*^9, {3.4969019354882364`*^9, 
   3.4969019759782925`*^9}, 3.4969039334610333`*^9, {3.4969040508411975`*^9, 
   3.4969040531212006`*^9}, {3.5171890135569487`*^9, 3.517189018704958*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic manipulation and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, {3.4962809620265017`*^9, 3.496280965046506*^9}, {
   3.49689985967533*^9, 3.496899870215345*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", " ", "c"}], ")"}], 
       RowBox[{"p", "+", 
        FractionBox["1", "2"]}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     RowBox[{"2", " ", "p"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999828455024`*^9, 
   3.4969000307455697`*^9}, {3.4969000933956575`*^9, 
   3.4969000955656605`*^9}, {3.496902913529606*^9, 3.4969029351996355`*^9}, {
   3.496903024519761*^9, 3.4969030276597652`*^9}, 3.4969036018405695`*^9, {
   3.496961362998604*^9, 3.496961364208606*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["x", "n"]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999237054195`*^9, 
   3.496899927365425*^9}, {3.496903038909781*^9, 3.4969030575398073`*^9}, {
   3.496961371118615*^9, 3.4969613719186163`*^9}, {3.4969621773897443`*^9, 
   3.496962177749745*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p", "+", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4962806723160963`*^9, 
   3.4962806826661105`*^9}, 3.4968968557611246`*^9, 3.4968968959111805`*^9, {
   3.4968997096451197`*^9, 3.4968997236051397`*^9}, {3.4969002592758894`*^9, 
   3.4969002595658903`*^9}, {3.4969028918395753`*^9, 
   3.4969028964295816`*^9}, {3.4969037232607393`*^9, 3.49690372381074*^9}, {
   3.4969038038808517`*^9, 3.496903809120859*^9}, 3.4969040397811823`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", " ", "c"}], ")"}], 
        RowBox[{"p", "+", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "n"}]]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4962809247964497`*^9, 3.4962809525964885`*^9}, {
   3.4968952590972276`*^9, 3.4968952762260575`*^9}, 3.4968963479804134`*^9, {
   3.4968964242805204`*^9, 3.4968964394505415`*^9}, {3.4968964901406126`*^9, 
   3.496896504500633*^9}, {3.496899530084869*^9, 3.4968995686849227`*^9}, {
   3.496900185895787*^9, 3.4969001879057894`*^9}, 3.4969036371106186`*^9, {
   3.4969037712908063`*^9, 3.4969037753408117`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}]}], "]"}]}], "*", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "*", "c"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "+", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"2", "*", "c", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "p"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", 
      RowBox[{"p", "+", 
       RowBox[{"1", "/", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, {
   3.4962810697866526`*^9, 3.4962810798566666`*^9}, {3.49687170143589*^9, 
   3.496871705913098*^9}, {3.496895397453871*^9, 3.4968954002774754`*^9}, {
   3.496895434893936*^9, 3.496895489806033*^9}, {3.4968956828251715`*^9, 
   3.4968956853523765`*^9}, {3.4968966669908605`*^9, 
   3.4968966700708647`*^9}, {3.4968967114709225`*^9, 
   3.4968967507709775`*^9}, {3.4968968232910795`*^9, 
   3.4968968293410873`*^9}, {3.4968990936242576`*^9, 3.496899115884289*^9}, {
   3.4968997370051584`*^9, 3.4968997671052003`*^9}, {3.496900141125724*^9, 
   3.4969001439857283`*^9}, {3.4969001934657974`*^9, 
   3.4969002169458303`*^9}, {3.496902108998479*^9, 3.4969021305985093`*^9}, {
   3.4969028701395445`*^9, 3.4969028719295473`*^9}, {3.4969036541706424`*^9, 
   3.4969036677406616`*^9}, {3.4969037269907446`*^9, 
   3.4969037274107447`*^9}, {3.496903778970817*^9, 3.4969037873108287`*^9}, {
   3.496903937431039*^9, 3.49690394495105*^9}, {3.4969043608616314`*^9, 
   3.496904361271632*^9}, {3.5171890262865715`*^9, 3.517189030264578*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}}],

Cell["\<\
Note: Although the resulting integrand appears more complicated than the \
original, it has the form of another new rule.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.496780701395195*^9, 3.496780745355256*^9}, {
   3.4967807805253057`*^9, 3.496780811285349*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, {3.4967115923915434`*^9, 
   3.4967115923915434`*^9}, {3.4967252635411277`*^9, 3.496725265506731*^9}, {
   3.496725300669193*^9, 3.4967253043819995`*^9}, {3.4967259831235914`*^9, 
   3.4967259929204087`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"]}], 
       RowBox[{
        RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{
     RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4967249618085976`*^9, 
   3.496724984179037*^9}, {3.496725555948041*^9, 3.4967257862512455`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, {3.4967251391185093`*^9, 
   3.496725167791359*^9}, {3.4967252290182667`*^9, 3.4967252582839184`*^9}, {
   3.4967253349424534`*^9, 3.496725373708521*^9}, {3.496725560300449*^9, 
   3.496725603169324*^9}, {3.496725821070507*^9, 3.4967259581635475`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.265c", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961942653108582`*^9, 
   3.49619426651086*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], 
        RowBox[{"p", "+", "1"}]], 
       RowBox[{"b", " ", "p", " ", "x"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "p"}], "+", "1"}], ")"}]}], 
    RowBox[{"b", " ", "p"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496194268210862*^9, 3.4961942724408684`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "p", "*", "x"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "p"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "p"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, {3.496194275090872*^9, 
   3.496194281600881*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic manipulation and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, {3.4962809620265017`*^9, 3.496280965046506*^9}, {
   3.49689985967533*^9, 3.496899870215345*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], "=", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", " ", "c"}], ")"}], 
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}]], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     RowBox[{"2", " ", "p"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999828455024`*^9, 
   3.4969000307455697`*^9}, {3.4969000933956575`*^9, 
   3.4969000955656605`*^9}, {3.4969613843886337`*^9, 3.496961385478636*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999237054195`*^9, 
   3.496899927365425*^9}, {3.496961391438644*^9, 3.496961400998657*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4962806723160963`*^9, 
   3.4962806826661105`*^9}, 3.4968968557611246`*^9, 3.4968968959111805`*^9, {
   3.4968997096451197`*^9, 3.4968997236051397`*^9}, {3.4969002592758894`*^9, 
   3.4969002595658903`*^9}, {3.496902879769558*^9, 3.4969028836595635`*^9}, {
   3.496905197922804*^9, 3.496905197922804*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", " ", "c"}], ")"}], 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", " ", "c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4962809247964497`*^9, 3.4962809525964885`*^9}, {
   3.4968952590972276`*^9, 3.4968952762260575`*^9}, 3.4968963479804134`*^9, {
   3.4968964242805204`*^9, 3.4968964394505415`*^9}, {3.4968964901406126`*^9, 
   3.496896504500633*^9}, {3.496899530084869*^9, 3.4968995686849227`*^9}, {
   3.496900185895787*^9, 3.4969001879057894`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}]}], "*", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "*", "c"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, {
   3.4962810697866526`*^9, 3.4962810798566666`*^9}, {3.49687170143589*^9, 
   3.496871705913098*^9}, {3.496895397453871*^9, 3.4968954002774754`*^9}, {
   3.496895434893936*^9, 3.496895489806033*^9}, {3.4968956828251715`*^9, 
   3.4968956853523765`*^9}, {3.4968966669908605`*^9, 
   3.4968966700708647`*^9}, {3.4968967114709225`*^9, 
   3.4968967507709775`*^9}, {3.4968968232910795`*^9, 
   3.4968968293410873`*^9}, {3.4968990936242576`*^9, 3.496899115884289*^9}, {
   3.4968997370051584`*^9, 3.4968997671052003`*^9}, {3.496900141125724*^9, 
   3.4969001439857283`*^9}, {3.4969001934657974`*^9, 
   3.4969002169458303`*^9}, {3.496902108998479*^9, 3.4969021305985093`*^9}, {
   3.496902858039528*^9, 3.4969028620095334`*^9}, 3.49690391669101*^9, 
   3.4969041207912955`*^9, {3.49690513828272*^9, 3.496905155482744*^9}, {
   3.496962459070139*^9, 3.4969624599601398`*^9}, {3.5171890355217876`*^9, 
   3.5171890399989953`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic manipulation and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495923078768035*^9, {3.495923273118307*^9, 
   3.4959232939383364`*^9}, {3.4962809620265017`*^9, 3.496280965046506*^9}, {
   3.49689985967533*^9, 3.496899870215345*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", " ", "c"}], ")"}], 
       RowBox[{"p", "+", 
        FractionBox["1", "2"]}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     RowBox[{"2", " ", "p"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999828455024`*^9, 
   3.4969000307455697`*^9}, {3.4969000933956575`*^9, 
   3.4969000955656605`*^9}, {3.496902913529606*^9, 3.4969029351996355`*^9}, {
   3.496903024519761*^9, 3.4969030276597652`*^9}, 3.4969036018405695`*^9, {
   3.496961415668678*^9, 3.496961416378679*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox["x", "n"]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4959231687581615`*^9, 3.4959232119482217`*^9}, 3.4959232662282977`*^9, {
   3.4962808567963543`*^9, 3.496280888166398*^9}, {3.496895304384107*^9, 
   3.496895312605322*^9}, 3.496896606910776*^9, {3.4968999237054195`*^9, 
   3.496899927365425*^9}, {3.496903038909781*^9, 3.4969030575398073`*^9}, {
   3.496961423008688*^9, 3.4969614275786943`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p", "+", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495922938707839*^9, 3.4959229711678843`*^9}, {
   3.4959231003080654`*^9, 3.4959231175680895`*^9}, {3.4962806723160963`*^9, 
   3.4962806826661105`*^9}, 3.4968968557611246`*^9, 3.4968968959111805`*^9, {
   3.4968997096451197`*^9, 3.4968997236051397`*^9}, {3.4969002592758894`*^9, 
   3.4969002595658903`*^9}, {3.4969028918395753`*^9, 
   3.4969028964295816`*^9}, {3.4969037232607393`*^9, 3.49690372381074*^9}, {
   3.4969051822027817`*^9, 3.4969051907227936`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"4", " ", "c"}], ")"}], 
        RowBox[{"p", "+", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "n"}]]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4959228185976706`*^9, 3.495922913057803*^9, 
   3.495923018917951*^9, {3.4962809247964497`*^9, 3.4962809525964885`*^9}, {
   3.4968952590972276`*^9, 3.4968952762260575`*^9}, 3.4968963479804134`*^9, {
   3.4968964242805204`*^9, 3.4968964394505415`*^9}, {3.4968964901406126`*^9, 
   3.496896504500633*^9}, {3.496899530084869*^9, 3.4968995686849227`*^9}, {
   3.496900185895787*^9, 3.4969001879057894`*^9}, 3.4969036371106186`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}]}], "]"}]}], "*", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "*", "c"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "+", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"p", "+", 
       RowBox[{"1", "/", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4959225619973116`*^9, {3.4959230364279757`*^9, 3.4959230376679773`*^9}, {
   3.4962810697866526`*^9, 3.4962810798566666`*^9}, {3.49687170143589*^9, 
   3.496871705913098*^9}, {3.496895397453871*^9, 3.4968954002774754`*^9}, {
   3.496895434893936*^9, 3.496895489806033*^9}, {3.4968956828251715`*^9, 
   3.4968956853523765`*^9}, {3.4968966669908605`*^9, 
   3.4968966700708647`*^9}, {3.4968967114709225`*^9, 
   3.4968967507709775`*^9}, {3.4968968232910795`*^9, 
   3.4968968293410873`*^9}, {3.4968990936242576`*^9, 3.496899115884289*^9}, {
   3.4968997370051584`*^9, 3.4968997671052003`*^9}, {3.496900141125724*^9, 
   3.4969001439857283`*^9}, {3.4969001934657974`*^9, 
   3.4969002169458303`*^9}, {3.496902108998479*^9, 3.4969021305985093`*^9}, {
   3.4969028701395445`*^9, 3.4969028719295473`*^9}, {3.4969036541706424`*^9, 
   3.4969036677406616`*^9}, {3.4969037269907446`*^9, 3.4969037274107447`*^9}, 
   3.496903914411007*^9, 3.496904123251299*^9, {3.4969043435316076`*^9, 
   3.496904343891608*^9}, 3.4969051736627693`*^9, {3.4969624688501525`*^9, 
   3.4969624713001556`*^9}, {3.517189043524602*^9, 3.5171890470814075`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.2", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961879789794245`*^9, 3.496636205806266*^9}],

Cell["\<\
Note: Can this be generalized to handle any symmetric trinomial?\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, {3.4961879789794245`*^9, 3.4961879953894477`*^9}, {
   3.496188028099493*^9, 3.4961880435895147`*^9}, {3.4967939301291313`*^9, 
   3.49679397223919*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
     " ", 
     RowBox[{"p", "<", 
      RowBox[{"-", "1"}]}], "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "1"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961883873499966`*^9, 
   3.4961884030100183`*^9}, {3.496189071340954*^9, 3.4961890724609556`*^9}, {
   3.4966408645847893`*^9, 3.496640880584812*^9}, {3.4966409351048884`*^9, 
   3.4966409553049164`*^9}, {3.4968607087062674`*^9, 3.4968607087062674`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}]]}]}]}]}]}], "-", 
  "                                                  ", "\[IndentingNewLine]",
   "                                                          ", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, 3.4961880860495744`*^9, {3.4961882159597564`*^9, 
   3.496188222229765*^9}, {3.4961890745209584`*^9, 3.4961890769209614`*^9}, {
   3.4962522439453244`*^9, 3.496252252675337*^9}, {3.496252317325427*^9, 
   3.496252321485433*^9}, {3.496252364135493*^9, 3.496252372205504*^9}, {
   3.4962527460260277`*^9, 3.496252756786042*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.496187970719413*^9, {
   3.496188055569532*^9, 3.496188057739535*^9}, {3.496189080060966*^9, 
   3.49618908989098*^9}, {3.496640827264737*^9, 3.4966408474047656`*^9}, {
   3.496641648295887*^9, 3.4966416499158893`*^9}, {3.4967782325617385`*^9, 
   3.4967782348617415`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.2", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.496632901717638*^9, 
   3.496632902637639*^9}, {3.4966330971479115`*^9, 3.4966330976779127`*^9}, {
   3.496641875236204*^9, 3.496641900096239*^9}, {3.496641937816292*^9, 
   3.496641937816292*^9}, {3.4966421744966235`*^9, 3.4966421744966235`*^9}, {
   3.49687254997898*^9, 3.49687254997898*^9}, {3.496872592829056*^9, 
   3.4968726002858686`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", "n"}]]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  "                                                                   ", 
  "\[IndentingNewLine]", "                          ", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496632904817642*^9, 
   3.4966329088076477`*^9}, {3.496633098557914*^9, 3.4966331021879187`*^9}, {
   3.4966349603645225`*^9, 3.4966349631845264`*^9}, 3.496635017954603*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, {3.49663291019765*^9, 3.4966329214976654`*^9}, {
   3.49663310309792*^9, 3.4966331072879257`*^9}, 3.496634543103938*^9, {
   3.4966349689745345`*^9, 3.4966349712045374`*^9}, {3.496638205751067*^9, 
   3.496638251411131*^9}, 3.496638522521511*^9, 3.496872550930582*^9, {
   3.496872608007882*^9, 3.4968726103790865`*^9}, 3.5171889959601183`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.4", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9}],

Cell["\<\
Note: This rule is commented out since it seems inferior to G&R 2.160.2 above.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, {3.4967934276084275`*^9, 3.496793457488469*^9}, {
   3.496793635888719*^9, 3.49679364376873*^9}, {3.4967936863087893`*^9, 
   3.496793703048813*^9}, {3.4967937432488694`*^9, 3.4967937492588778`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966327984874935`*^9, 
   3.4966328033475*^9}, {3.4966330528978496`*^9, 3.4966330542078514`*^9}, {
   3.49664220045666*^9, 3.49664220045666*^9}, {3.4967934762584953`*^9, 
   3.4967934971985245`*^9}, {3.4968725518821836`*^9, 
   3.4968725518821836`*^9}, {3.496872628865119*^9, 3.4968726311895227`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", 
        RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  "                                                                           \
            ", "\[IndentingNewLine]", "                             ", 
  RowBox[{
   FractionBox[
    RowBox[{"2", "a", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", 
     RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"m", "+", 
     RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, {
   3.496632805817504*^9, 3.4966328257675314`*^9}, {3.4966330552178526`*^9, 
   3.496633061157861*^9}, 3.4966332601181393`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", 
     "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"2", "*", "a", "*", "n", "*", 
        RowBox[{"p", "/", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
     " ", "+", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"p", "/", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", "n"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"j", "-", 
       RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{"n", ">", "0"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
     RowBox[{"p", ">", "0"}], " ", "&&", "\n", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{"m", "+", 
       RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], "]"}]}]}]}], " ", 
  "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, {3.496632828097535*^9, 3.4966328436075563`*^9}, {
   3.4966330620878625`*^9, 3.4966330677978706`*^9}, 3.496634540463935*^9, {
   3.496641723335992*^9, 3.496641727685998*^9}, {3.4966421943566513`*^9, 
   3.496642196846655*^9}, {3.4967935183185544`*^9, 3.4967935351085777`*^9}, 
   3.4968725529585857`*^9, {3.496872638599536*^9, 3.4968726405495396`*^9}, {
   3.496962530260238*^9, 3.49696253152024*^9}, 3.517188995975718*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.1", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.496188449500083*^9, 
   3.4961908979261436`*^9, 3.4961924998683863`*^9, 3.4961928754389124`*^9, 
   3.49619304510915*^9, 3.496193155469304*^9, 3.4961932832594833`*^9}],

Cell["Note: G&R 2.161.6 is a special case of G&R 2.160.1.", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.496188449500083*^9, 
   3.4961908979261436`*^9, 3.4961924998683863`*^9, 3.4961928754389124`*^9, 
   3.49619304510915*^9, 3.496193155469304*^9, {3.4961932832594833`*^9, 
   3.4961932978895035`*^9}, {3.4966350787846885`*^9, 3.496635092524708*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", "0"}], 
    " ", "\[And]", "  ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "n", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", 
     "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496632925347671*^9, 3.4966329261776724`*^9}, {
   3.496633108627928*^9, 3.496633109047928*^9}, {3.4966420029163833`*^9, 
   3.4966420861365*^9}, {3.4966421665866127`*^9, 3.4966421665866127`*^9}, {
   3.496643617381618*^9, 3.496643617381618*^9}, {3.4968725542689877`*^9, 
   3.4968725542689877`*^9}, {3.4968726508455577`*^9, 3.4968726532011614`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
         ", "\[IndentingNewLine]", "   ", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496632928127675*^9, 3.496632933937683*^9}, {
   3.4966331099279294`*^9, 3.4966331131779337`*^9}, {3.4966360006259785`*^9, 
   3.4966360189760046`*^9}, {3.4969625704502945`*^9, 3.4969625956503296`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966329356176853`*^9, 
   3.4966329485077033`*^9}, {3.496633114157935*^9, 3.4966331180579405`*^9}, 
   3.496634543813939*^9, {3.4966360230560102`*^9, 3.496636034666026*^9}, {
   3.496638321391229*^9, 3.4966383572712793`*^9}, 3.4966385165315027`*^9, {
   3.496639911863456*^9, 3.496639947513506*^9}, {3.496640631974464*^9, 
   3.4966406368344707`*^9}, 3.496643600283988*^9, 3.4968725552517896`*^9, {
   3.496872659253972*^9, 3.496872661297576*^9}, 3.5171889959913177`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.3", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966321069865255`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"2", "<", 
      RowBox[{"2", "n"}], "\[LessEqual]", "m"}], " ", "\[And]", " ", 
     RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
     " ", 
     RowBox[{"m", "+", 
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.4966328457275596`*^9, 3.4966328479675627`*^9}, {
   3.4966330691478724`*^9, 3.496633070287874*^9}, {3.4966344198437657`*^9, 
   3.496634432183783*^9}, {3.4966417601860437`*^9, 3.4966417603860435`*^9}, {
   3.496641831246143*^9, 3.496641839846155*^9}, {3.4968606862578278`*^9, 
   3.4968606862578278`*^9}, {3.496872556187791*^9, 3.496872556187791*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", 
          RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"c", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.4966328497175655`*^9, 3.4966328542175713`*^9}, {
   3.496633070947875*^9, 3.4966330743778796`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "\[LessEqual]", "m"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, {3.496632856177574*^9, 
   3.4966328671475897`*^9}, {3.4966330752578807`*^9, 
   3.4966330796978874`*^9}, {3.4966343023036013`*^9, 3.49663432255363*^9}, {
   3.4966343977537346`*^9, 3.496634413373757*^9}, 3.496634541463936*^9, {
   3.4966375354581275`*^9, 3.4966375602081623`*^9}, 3.496637676318325*^9, 
   3.496637707328368*^9, 3.496776733169639*^9, 3.4967784464320383`*^9, 
   3.496778492062102*^9, 3.4968725574045935`*^9, 3.517188996006918*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.3", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, {
   3.4966346740141215`*^9, 3.496634681614132*^9}}],

Cell["Note: G&R 2.174.1 is a special case of G&R 2.160.3.", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, {
   3.496634647164084*^9, 3.496634671584118*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"2", "<", 
     RowBox[{"2", "n"}], "\[LessEqual]", "m"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}], 
    " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "\[NotEqual]", 
     "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966328700075936`*^9, 3.4966328722875967`*^9}, {3.4966330808178887`*^9, 
   3.49663308181789*^9}, {3.496634759624242*^9, 3.4966347682542534`*^9}, {
   3.4966418535961742`*^9, 3.4966418575861797`*^9}, {3.4966429389776936`*^9, 
   3.4966429389776936`*^9}, {3.4968725598693976`*^9, 3.4968725598693976`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", 
          RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}]}]]}]}]}]}], 
  "-", "                                                                      \
          ", "\[IndentingNewLine]", "            ", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966328743475995`*^9, 3.49663288187761*^9}, {3.496633082287891*^9, 
   3.4966330863578963`*^9}, 3.4966347174541826`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}],
       ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}],
       ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "\[LessEqual]", "m"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, {
   3.4966328843976135`*^9, 3.4966329000576353`*^9}, {3.496633087447898*^9, 
   3.49663309590791*^9}, 3.496634542383937*^9, {3.4966347798342695`*^9, 
   3.496634783624275*^9}, {3.4966373469378633`*^9, 3.496637377757907*^9}, {
   3.4966374464680033`*^9, 3.496637450828009*^9}, 3.4966376794283295`*^9, 
   3.496637712998376*^9, {3.4966429431076994`*^9, 3.4966429488477077`*^9}, 
   3.4967784417620316`*^9, 3.4967784717920732`*^9, 3.4968725607741995`*^9, 
   3.517188996022518*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}, 3.4967114949069724`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}}],

Cell["\<\
Note: Although the resulting integrand has complicated coefficients, it is \
has the same form as the original integrand so recursion can occur. \
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n", " ", "p"}], "+", "1"}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n", " ", "p"}], "+", "n", "+", "1"}], "\[NotEqual]", 
    "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, {3.4967115923915434`*^9, 
   3.4967115923915434`*^9}, {3.4967252635411277`*^9, 3.496725265506731*^9}, {
   3.496725300669193*^9, 3.4967253043819995`*^9}, {3.496726097411793*^9, 
   3.496726124509041*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                       ", 
      "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "e", " ", "n", " ", "p"}], "+", 
          RowBox[{"c", " ", "d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "1"}], ")"}]}],
           "+", 
          RowBox[{"c", " ", "e", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}], " ", 
           SuperscriptBox["x", "n"]}]}], ")"}]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "1"}], 
         ")"}]}]]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "1"}], ")"}]}]], 
   "\[CenterDot]", "             ", "\[IndentingNewLine]", "    ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "b", " ", "e"}], "-", 
        RowBox[{"2", " ", "a", " ", "c", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "1"}], ")"}]}], 
        "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a", " ", "c", " ", "e", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "n", " ", "p"}], "+", "1"}], ")"}]}], "+", 
           RowBox[{"b", " ", "c", " ", "d", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "1"}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], "e", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]}], ")"}], 
         SuperscriptBox["x", "n"]}]}], ")"}], "\[CenterDot]", 
      "                  ", "\[IndentingNewLine]", 
      "                                                                       \
                                                                      ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", 
           RowBox[{"2", " ", "n"}]]}]}], ")"}], 
       RowBox[{"p", "-", "1"}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4967249618085976`*^9, 
   3.496724984179037*^9}, {3.4969626848604546`*^9, 3.496962827330654*^9}, {
   3.496962964980847*^9, 3.4969630166709194`*^9}, {3.4969631252010713`*^9, 
   3.496963135371085*^9}, {3.496963206651185*^9, 3.496963246681241*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", "e", "*", "n", "*", "p"}], "+", 
       RowBox[{"c", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], ")"}]}], 
       "+", 
       RowBox[{"c", "*", "e", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}], "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], ")"}]}], 
       ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], ")"}]}], 
         ")"}]}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "b", "*", "e"}], "-", 
           RowBox[{"2", "*", "a", "*", "c", "*", "d", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], 
             ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a", "*", "c", "*", "e", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], ")"}]}], "+", 
              RowBox[{"b", "*", "c", "*", "d", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], 
                ")"}]}], "-", 
              RowBox[{
               RowBox[{"b", "^", "2"}], "*", "e", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], ")"}], "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "*", "\n", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "n", "*", "p"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "1"}], "]"}], 
    " "}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, {3.4967251391185093`*^9, 
   3.496725167791359*^9}, {3.4967252290182667`*^9, 3.4967252582839184`*^9}, {
   3.4967253349424534`*^9, 3.496725373708521*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}, 3.4967114949069724`*^9, {
   3.4972205462945137`*^9, 3.497220572159359*^9}, {3.497226493510017*^9, 
   3.497226502292832*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4956785976344337`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["d", "3"], "-", 
    RowBox[{"4", " ", "c", " ", "d", " ", "e"}], "+", 
    RowBox[{"8", " ", "b", " ", 
     SuperscriptBox["e", "2"]}]}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"t", "=", 
   RowBox[{
    FractionBox["d", 
     RowBox[{"4", " ", "e"}]], "+", "x"}]}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"e", " ", 
     SuperscriptBox["x", "4"]}]}], "=", 
   RowBox[{"a", "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["d", "4"]}], 
     RowBox[{"256", " ", 
      SuperscriptBox["e", "3"]}]], "-", 
    FractionBox[
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], 
     RowBox[{"16", " ", 
      SuperscriptBox["e", "2"]}]], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "-", 
       FractionBox[
        RowBox[{"3", " ", 
         SuperscriptBox["d", "2"]}], 
        RowBox[{"8", " ", "e"}]]}], ")"}], " ", 
     SuperscriptBox["t", "2"]}], "+", 
    RowBox[{"e", " ", 
     SuperscriptBox["t", "4"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495678654704514*^9, {3.497309838538514*^9, 3.4973098681385555`*^9}, {
   3.497309898498598*^9, 3.4973099685386963`*^9}, {3.4973101707989798`*^9, 
   3.4973101715189805`*^9}, {3.4973103564592395`*^9, 3.497310359849244*^9}, 
   3.497310458189382*^9}],

Cell["\<\
Note: The substitution transforms a dense quartic polynomial into a symmetric \
quartic trinomial. \
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}, {
   3.4972205911601925`*^9, 3.4972206326094656`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
    "  ", "\[And]", " ", 
    RowBox[{
     SuperscriptBox["d", "3"], "-", 
     RowBox[{"4", " ", "c", " ", "d", " ", "e"}], "+", 
     RowBox[{"8", " ", "b", " ", 
      SuperscriptBox["e", "2"]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, {3.4967115923915434`*^9, 
   3.4967115923915434`*^9}, {3.4967252635411277`*^9, 3.496725265506731*^9}, {
   3.496725300669193*^9, 3.4967253043819995`*^9}, {3.496726097411793*^9, 
   3.496726124509041*^9}, {3.4972206436542845`*^9, 3.4972206475386915`*^9}, {
   3.4972206832627544`*^9, 3.4972207283312335`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            FractionBox[
             RowBox[{"5", " ", 
              SuperscriptBox["d", "4"]}], 
             RowBox[{"256", " ", 
              SuperscriptBox["e", "3"]}]], "-", 
            FractionBox[
             RowBox[{"c", " ", 
              SuperscriptBox["d", "2"]}], 
             RowBox[{"16", " ", 
              SuperscriptBox["e", "2"]}]], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "-", 
               FractionBox[
                RowBox[{"3", " ", 
                 SuperscriptBox["d", "2"]}], 
                RowBox[{"8", " ", "e"}]]}], ")"}], " ", 
             SuperscriptBox["x", "2"]}], "+", 
            RowBox[{"e", " ", 
             SuperscriptBox["x", "4"]}]}], ")"}], "p"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
       RowBox[{
        FractionBox["d", 
         RowBox[{"4", " ", "e"}]], "+", "x"}]}], "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4967249618085976`*^9, 
   3.496724984179037*^9}, {3.4969626848604546`*^9, 3.496962827330654*^9}, {
   3.496962964980847*^9, 3.4969630166709194`*^9}, {3.4969631252010713`*^9, 
   3.496963135371085*^9}, {3.496963206651185*^9, 3.496963246681241*^9}, 
   3.497220743993661*^9, {3.4972207926657467`*^9, 3.4972207988277574`*^9}, 
   3.4972265111692476`*^9, {3.497309659238263*^9, 3.4973096809082937`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}], "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"5", "*", 
           RowBox[{
            RowBox[{"d", "^", "4"}], "/", 
            RowBox[{"(", 
             RowBox[{"256", "*", 
              RowBox[{"e", "^", "3"}]}], ")"}]}]}], "-", 
          RowBox[{"c", "*", 
           RowBox[{
            RowBox[{"d", "^", "2"}], "/", 
            RowBox[{"(", 
             RowBox[{"16", "*", 
              RowBox[{"e", "^", "2"}]}], ")"}]}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "-", 
             RowBox[{"3", "*", 
              RowBox[{
               RowBox[{"d", "^", "2"}], "/", 
               RowBox[{"(", 
                RowBox[{"8", "*", "e"}], ")"}]}]}]}], ")"}], "*", 
           RowBox[{"x", "^", "2"}]}], "+", 
          RowBox[{"e", "*", 
           RowBox[{"x", "^", "4"}]}]}], ")"}], "^", "p"}], ",", "x"}], "]"}], 
     ",", "x", ",", 
     RowBox[{
      RowBox[{"d", "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "e"}], ")"}]}], "+", "x"}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"d", "^", "3"}], "-", 
      RowBox[{"4", "*", "c", "*", "d", "*", "e"}], "+", 
      RowBox[{"8", "*", "b", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, {3.4967251391185093`*^9, 
   3.496725167791359*^9}, {3.4967252290182667`*^9, 3.4967252582839184`*^9}, {
   3.4967253349424534`*^9, 3.496725373708521*^9}, 3.4972206651043224`*^9, 
   3.497221068926632*^9, {3.497221109939104*^9, 3.497221118347519*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4956785976344337`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "3"], "-", 
    RowBox[{"4", " ", "a", " ", "b", " ", "c"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"], " ", "d"}]}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"t", "=", 
   RowBox[{
    FractionBox["b", 
     RowBox[{"4", " ", "a"}]], "+", 
    FractionBox["1", "x"]}]}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"e", " ", 
     SuperscriptBox["x", "4"]}]}], "=", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["b", "4"]}], "+", 
       RowBox[{"16", " ", "a", " ", 
        SuperscriptBox["b", "2"], " ", "c"}], "-", 
       RowBox[{"64", " ", 
        SuperscriptBox["a", "2"], " ", "b", " ", "d"}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["a", "3"], " ", "e"}], "-", 
       RowBox[{"32", " ", 
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["b", "2"]}], "-", 
          RowBox[{"8", " ", "a", " ", "c"}]}], ")"}], " ", 
        SuperscriptBox["t", "2"]}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["a", "4"], " ", 
        SuperscriptBox["t", "4"]}]}], ")"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "-", 
       RowBox[{"4", " ", "a", " ", "t"}]}], ")"}], "4"]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495678654704514*^9, {3.497309838538514*^9, 3.4973098681385555`*^9}, {
   3.497309898498598*^9, 3.4973099685386963`*^9}, {3.4973101707989798`*^9, 
   3.4973101715189805`*^9}, {3.4973103564592395`*^9, 3.497310359849244*^9}, 
   3.497310416579324*^9, 3.497310473219403*^9, 3.4973105353694897`*^9}],

Cell["\<\
Note: The substitution transforms a dense quartic polynomial into a symmetric \
quartic trinomial over the 4th power of a linear.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}, {
   3.4972205911601925`*^9, 3.4972206326094656`*^9}, {3.497311093080271*^9, 
   3.4973111120002975`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
    "  ", "\[And]", " ", 
    RowBox[{
     SuperscriptBox["b", "3"], "-", 
     RowBox[{"4", " ", "a", " ", "b", " ", "c"}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["a", "2"], " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, {3.4967115923915434`*^9, 
   3.4967115923915434`*^9}, {3.4967252635411277`*^9, 3.496725265506731*^9}, {
   3.496725300669193*^9, 3.4967253043819995`*^9}, {3.496726097411793*^9, 
   3.496726124509041*^9}, {3.4972206436542845`*^9, 3.4972206475386915`*^9}, {
   3.4972206832627544`*^9, 3.4972207283312335`*^9}, 3.4973107751298256`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", "16"}]}]}], 
   SuperscriptBox["a", "2"], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", 
               SuperscriptBox["b", "4"]}], "+", 
              RowBox[{"16", " ", "a", " ", 
               SuperscriptBox["b", "2"], " ", "c"}], "-", 
              RowBox[{"64", " ", 
               SuperscriptBox["a", "2"], " ", "b", " ", "d"}], "+", 
              RowBox[{"256", " ", 
               SuperscriptBox["a", "3"], " ", "e"}], "-", 
              RowBox[{"32", " ", 
               SuperscriptBox["a", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["b", "2"]}], "-", 
                 RowBox[{"8", " ", "a", " ", "c"}]}], ")"}], " ", 
               SuperscriptBox["x", "2"]}], "+", 
              RowBox[{"256", " ", 
               SuperscriptBox["a", "4"], " ", 
               SuperscriptBox["x", "4"]}]}], ")"}]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "-", 
              RowBox[{"4", " ", "a", " ", "x"}]}], ")"}], "4"]], ")"}], "p"], 
        "/", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "-", 
           RowBox[{"4", " ", "a", " ", "x"}]}], ")"}], "2"]}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{
      FractionBox["b", 
       RowBox[{"4", " ", "a"}]], "+", 
      FractionBox["1", "x"]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4967249618085976`*^9, 
   3.496724984179037*^9}, {3.4969626848604546`*^9, 3.496962827330654*^9}, {
   3.496962964980847*^9, 3.4969630166709194`*^9}, {3.4969631252010713`*^9, 
   3.496963135371085*^9}, {3.496963206651185*^9, 3.496963246681241*^9}, 
   3.497220743993661*^9, {3.4972207926657467`*^9, 3.4972207988277574`*^9}, 
   3.4972265111692476`*^9, 3.497309553418115*^9, 3.4973108537199354`*^9, 
   3.4973109270100384`*^9, {3.4973109686500964`*^9, 3.497310998200138*^9}, {
   3.4973110637202296`*^9, 3.4973110678902354`*^9}, {3.4973112729605227`*^9, 
   3.49731129270055*^9}, {3.497312796762656*^9, 3.49731284275272*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}], "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "16"}], "*", 
      RowBox[{"a", "^", "2"}]}], ",", 
     RowBox[{"Subst", "[", "\n", "    ", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], "*", 
                 RowBox[{"b", "^", "4"}]}], "+", 
                RowBox[{"16", "*", "a", "*", 
                 RowBox[{"b", "^", "2"}], "*", "c"}], "-", 
                RowBox[{"64", "*", 
                 RowBox[{"a", "^", "2"}], "*", "b", "*", "d"}], "+", 
                RowBox[{"256", "*", 
                 RowBox[{"a", "^", "3"}], "*", "e"}], "-", 
                RowBox[{"32", "*", 
                 RowBox[{"a", "^", "2"}], "*", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", "*", 
                    RowBox[{"b", "^", "2"}]}], "-", 
                   RowBox[{"8", "*", "a", "*", "c"}]}], ")"}], "*", 
                 RowBox[{"x", "^", "2"}]}], "+", 
                RowBox[{"256", "*", 
                 RowBox[{"a", "^", "4"}], "*", 
                 RowBox[{"x", "^", "4"}]}]}], ")"}], "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"b", "-", 
                 RowBox[{"4", "*", "a", "*", "x"}]}], ")"}], "^", "4"}]}]}], 
            ")"}], "^", "p"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", 
             RowBox[{"4", "*", "a", "*", "x"}]}], ")"}], "^", "2"}]}], ",", 
         "x"}], "]"}], ",", "x", ",", 
       RowBox[{
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "a"}], ")"}]}], "+", 
        RowBox[{"1", "/", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "3"}], "-", 
      RowBox[{"4", "*", "a", "*", "b", "*", "c"}], "+", 
      RowBox[{"8", "*", 
       RowBox[{"a", "^", "2"}], "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, {3.4967251391185093`*^9, 
   3.496725167791359*^9}, {3.4967252290182667`*^9, 3.4967252582839184`*^9}, {
   3.4967253349424534`*^9, 3.496725373708521*^9}, 3.4972206651043224`*^9, 
   3.497221068926632*^9, {3.497221109939104*^9, 3.497221118347519*^9}, {
   3.497309387007882*^9, 3.497309410447915*^9}, 3.497311179620392*^9, {
   3.497311324550595*^9, 3.497311334530609*^9}, {3.497311397740697*^9, 
   3.497311399040699*^9}, {3.4973121204717093`*^9, 3.497312124771715*^9}, {
   3.4973128535927353`*^9, 3.4973128895027857`*^9}, {3.497312951222872*^9, 
   3.497312963502889*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "^", "p_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Expand", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"v", "^", "p"}], ",", "x"}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{
       RowBox[{"v", "=!=", "u"}], " ", "&&", " ", 
       RowBox[{"(", "\n", " ", 
        RowBox[{
         RowBox[{"MatchQ", "[", 
          RowBox[{"v", ",", 
           RowBox[{
            RowBox[{"a_", "+", 
             RowBox[{"b_.", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c_.", "*", 
              RowBox[{"x", "^", "4"}]}]}], " ", "/;", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], 
             "]"}]}]}], "]"}], " ", "||", "\n", " ", 
         RowBox[{"MatchQ", "[", 
          RowBox[{"v", ",", 
           RowBox[{
            RowBox[{"a_.", "+", 
             RowBox[{"b_.", "*", "x"}], "+", 
             RowBox[{"c_.", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"d_.", "*", 
              RowBox[{"x", "^", "3"}]}], "+", 
             RowBox[{"e_.", "*", 
              RowBox[{"x", "^", "4"}]}]}], " ", "/;", " ", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
               ",", "x"}], "]"}], " ", "&&", " ", 
             RowBox[{"ZeroQ", "[", 
              RowBox[{
               RowBox[{"d", "^", "3"}], "-", 
               RowBox[{"4", "*", "c", "*", "d", "*", "e"}], "+", 
               RowBox[{"8", "*", "b", "*", 
                RowBox[{"e", "^", "2"}]}]}], "]"}]}]}]}], "]"}]}], 
        ")"}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "\[Equal]", "4"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, {3.4967251391185093`*^9, 
   3.496725167791359*^9}, {3.4967252290182667`*^9, 3.4967252582839184`*^9}, {
   3.4967253349424534`*^9, 3.496725373708521*^9}, 3.4972206651043224`*^9, 
   3.497221068926632*^9, {3.497221109939104*^9, 3.497221118347519*^9}, {
   3.4972264255562973`*^9, 3.497226448238737*^9}, {3.49722653552089*^9, 
   3.497226551214518*^9}, {3.4972266032094097`*^9, 3.497226687727158*^9}, {
   3.4972267200192146`*^9, 3.497226722546419*^9}, {3.4972271014398847`*^9, 
   3.497227101767485*^9}, {3.4972271371951475`*^9, 3.497227147179165*^9}, 
   3.497227178160819*^9, {3.4972277698074584`*^9, 3.497227932234944*^9}, {
   3.4974965239473157`*^9, 3.497496542747342*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Algebraic Functions of Trinomials", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 974, 23, 164, "Title"],
Cell[1544, 47, 512, 11, 134, "Subsubsection"],
Cell[2059, 60, 241, 3, 90, "Subsubsection"],
Cell[2303, 65, 720, 26, 181, "Subsubsection"],
Cell[3026, 93, 1153, 22, 96, "Subsubsection"],
Cell[4182, 117, 1353, 36, 302, "Subsubtitle"],
Cell[5538, 155, 771, 11, 130, "Subsubsection"],
Cell[6312, 168, 1523, 44, 394, "Code"],
Cell[7838, 214, 89, 2, 130, "Subsubsection"],
Cell[7930, 218, 189, 3, 90, "Subsubsection"],
Cell[8122, 223, 119, 1, 90, "Subsubsection"],
Cell[8244, 226, 391, 14, 181, "Subsubsection"],
Cell[8638, 242, 270, 6, 90, "Subsubsection"],
Cell[8911, 250, 1004, 22, 158, "Subsubsection"],
Cell[9918, 274, 1153, 33, 384, "Subsubtitle"],
Cell[11074, 309, 771, 11, 130, "Subsubsection"],
Cell[11848, 322, 1543, 46, 394, "Code"],
Cell[13394, 370, 89, 2, 130, "Subsubsection"],
Cell[13486, 374, 211, 3, 90, "Subsubsection"],
Cell[13700, 379, 119, 1, 90, "Subsubsection"],
Cell[13822, 382, 414, 14, 181, "Subsubsection"],
Cell[14239, 398, 270, 6, 90, "Subsubsection"],
Cell[14512, 406, 1107, 24, 158, "Subsubsection"],
Cell[15622, 432, 1239, 36, 384, "Subsubtitle"],
Cell[16864, 470, 771, 11, 130, "Subsubsection"],
Cell[17638, 483, 1693, 50, 394, "Code"],
Cell[19334, 535, 89, 2, 130, "Subsubsection"],
Cell[19426, 539, 1221, 27, 158, "Subsubsection"],
Cell[20650, 568, 1156, 32, 316, "Subsubtitle"],
Cell[21809, 602, 771, 11, 130, "Subsubsection"],
Cell[22583, 615, 1468, 42, 394, "Code"],
Cell[24054, 659, 89, 2, 130, "Subsubsection"],
Cell[24146, 663, 1322, 29, 158, "Subsubsection"],
Cell[25471, 694, 1255, 35, 316, "Subsubtitle"],
Cell[26729, 731, 771, 11, 130, "Subsubsection"],
Cell[27503, 744, 1544, 44, 394, "Code"],
Cell[29050, 790, 89, 2, 130, "Subsubsection"],
Cell[29142, 794, 182, 2, 90, "Subsubsection"],
Cell[29327, 798, 119, 1, 90, "Subsubsection"],
Cell[29449, 801, 1083, 23, 130, "Subsubsection"],
Cell[30535, 826, 1225, 34, 302, "Subsubtitle"],
Cell[31763, 862, 771, 11, 130, "Subsubsection"],
Cell[32537, 875, 1590, 45, 394, "Code"],
Cell[34130, 922, 89, 2, 130, "Subsubsection"],
Cell[34222, 926, 205, 3, 90, "Subsubsection"],
Cell[34430, 931, 119, 1, 90, "Subsubsection"],
Cell[34552, 934, 1182, 25, 130, "Subsubsection"],
Cell[35737, 961, 1344, 37, 302, "Subsubtitle"],
Cell[37084, 1000, 771, 11, 130, "Subsubsection"],
Cell[37858, 1013, 1720, 48, 394, "Code"],
Cell[39581, 1063, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[39662, 1069, 1090, 24, 80, "Title"],
Cell[40755, 1095, 1314, 27, 217043, "Subsubsection"],
Cell[42072, 1124, 1410, 37, 418545, "Subsubtitle"],
Cell[43485, 1163, 771, 11, 210492, "Subsubsection"],
Cell[44259, 1176, 1891, 52, 643950, "Code"],
Cell[46153, 1230, 89, 2, 210492, "Subsubsection"],
Cell[46245, 1234, 192, 2, 144262, "Subsubsection"],
Cell[46440, 1238, 1112, 21, 155031, "Subsubsection"],
Cell[47555, 1261, 1542, 40, 515792, "Subsubtitle"],
Cell[49100, 1303, 771, 11, 210492, "Subsubsection"],
Cell[49874, 1316, 1649, 48, 643950, "Code"],
Cell[51526, 1366, 89, 2, 210492, "Subsubsection"],
Cell[51618, 1370, 180, 2, 144262, "Subsubsection"],
Cell[51801, 1374, 1265, 25, 210492, "Subsubsection"],
Cell[53069, 1401, 2061, 59, 418545, "Subsubtitle"],
Cell[55133, 1462, 771, 11, 210492, "Subsubsection"],
Cell[55907, 1475, 2428, 72, 802636, "Code"],
Cell[58338, 1549, 89, 2, 210492, "Subsubsection"],
Cell[58430, 1553, 269, 4, 144262, "Subsubsection"],
Cell[58702, 1559, 1305, 26, 210492, "Subsubsection"],
Cell[60010, 1587, 2259, 65, 458926, "Subsubtitle"],
Cell[62272, 1654, 771, 11, 210492, "Subsubsection"],
Cell[63046, 1667, 2685, 80, 802636, "Code"],
Cell[65734, 1749, 44, 1, 15196, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[65815, 1755, 1097, 26, 126, "Title"],
Cell[66915, 1783, 122, 1, 130, "Subsubsection"],
Cell[67040, 1786, 847, 26, 106, "Subsubsection"],
Cell[67890, 1814, 938, 20, 96, "Subsubsection"],
Cell[68831, 1836, 1170, 33, 338, "Subsubtitle"],
Cell[70004, 1871, 771, 11, 130, "Subsubsection"],
Cell[70778, 1884, 1526, 44, 394, "Code"],
Cell[72307, 1930, 89, 2, 130, "Subsubsection"],
Cell[72399, 1934, 121, 1, 90, "Subsubsection"],
Cell[72523, 1937, 966, 21, 96, "Subsubsection"],
Cell[73492, 1960, 2079, 54, 302, "Subsubtitle"],
Cell[75574, 2016, 771, 11, 130, "Subsubsection"],
Cell[76348, 2029, 2009, 61, 394, "Code"],
Cell[78360, 2092, 89, 2, 130, "Subsubsection"],
Cell[78452, 2096, 146, 2, 90, "Subsubsection"],
Cell[78601, 2100, 1071, 23, 106, "Subsubsection"],
Cell[79675, 2125, 2149, 56, 302, "Subsubtitle"],
Cell[81827, 2183, 771, 11, 130, "Subsubsection"],
Cell[82601, 2196, 2223, 64, 394, "Code"],
Cell[84827, 2262, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[84908, 2268, 1087, 27, 126, "Title"],
Cell[85998, 2297, 149, 2, 130, "Subsubsection"],
Cell[86150, 2301, 1348, 29, 96, "Subsubsection"],
Cell[87501, 2332, 1444, 40, 338, "Subsubtitle"],
Cell[88948, 2374, 771, 11, 130, "Subsubsection"],
Cell[89722, 2387, 1975, 56, 394, "Code"],
Cell[91700, 2445, 89, 2, 130, "Subsubsection"],
Cell[91792, 2449, 624, 14, 96, "Subsubsection"],
Cell[92419, 2465, 241, 3, 90, "Subsubsection"],
Cell[92663, 2470, 720, 26, 181, "Subsubsection"],
Cell[93386, 2498, 1178, 22, 96, "Subsubsection"],
Cell[94567, 2522, 2211, 53, 302, "Subsubtitle"],
Cell[96781, 2577, 771, 11, 130, "Subsubsection"],
Cell[97555, 2590, 2148, 58, 394, "Code"],
Cell[99706, 2650, 89, 2, 130, "Subsubsection"],
Cell[99798, 2654, 1444, 29, 158, "Subsubsection"],
Cell[101245, 2685, 2145, 53, 418, "Subsubtitle"],
Cell[103393, 2740, 771, 11, 130, "Subsubsection"],
Cell[104167, 2753, 2870, 75, 394, "Code"],
Cell[107040, 2830, 89, 2, 130, "Subsubsection"],
Cell[107132, 2834, 1457, 31, 158, "Subsubsection"],
Cell[108592, 2867, 2272, 55, 418, "Subsubtitle"],
Cell[110867, 2924, 771, 11, 130, "Subsubsection"],
Cell[111641, 2937, 2749, 75, 394, "Code"],
Cell[114393, 3014, 89, 2, 130, "Subsubsection"],
Cell[114485, 3018, 121, 1, 90, "Subsubsection"],
Cell[114609, 3021, 1520, 34, 130, "Subsubsection"],
Cell[116132, 3057, 2554, 65, 302, "Subsubtitle"],
Cell[118689, 3124, 771, 11, 130, "Subsubsection"],
Cell[119463, 3137, 3060, 85, 491, "Code"],
Cell[122526, 3224, 89, 2, 130, "Subsubsection"],
Cell[122618, 3228, 146, 2, 90, "Subsubsection"],
Cell[122767, 3232, 1614, 37, 130, "Subsubsection"],
Cell[124384, 3271, 2546, 65, 302, "Subsubtitle"],
Cell[126933, 3338, 771, 11, 130, "Subsubsection"],
Cell[127707, 3351, 3251, 88, 491, "Code"],
Cell[130961, 3441, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[131042, 3447, 1069, 26, 100, "Title"],
Cell[132114, 3475, 114, 1, 3106402, "Subsubsection"],
Cell[132231, 3478, 1186, 26, 3106402, "Subsubsection"],
Cell[133420, 3506, 1672, 49, 6088546, "Subsubtitle"],
Cell[135095, 3557, 771, 11, 3106402, "Subsubsection"],
Cell[135869, 3570, 2186, 66, 11845189, "Code"],
Cell[138058, 3638, 89, 2, 3106402, "Subsubsection"],
Cell[138150, 3642, 111, 1, 2128979, "Subsubsection"],
Cell[138264, 3645, 1122, 23, 2287914, "Subsubsection"],
Cell[139389, 3670, 2227, 59, 6088546, "Subsubtitle"],
Cell[141619, 3731, 771, 11, 3106402, "Subsubsection"],
Cell[142393, 3744, 2181, 67, 11845189, "Code"],
Cell[144577, 3813, 89, 2, 3106402, "Subsubsection"],
Cell[144669, 3817, 111, 1, 2128979, "Subsubsection"],
Cell[144783, 3820, 979, 18, 2287914, "Subsubsection"],
Cell[145765, 3840, 2937, 80, 12106555, "Subsubtitle"],
Cell[148705, 3922, 771, 11, 3106402, "Subsubsection"],
Cell[149479, 3935, 2775, 85, 14141412, "Code"],
Cell[152257, 4022, 89, 2, 3106402, "Subsubsection"],
Cell[152349, 4026, 145, 2, 2128979, "Subsubsection"],
Cell[152497, 4030, 1436, 32, 3106402, "Subsubsection"],
Cell[153936, 4064, 2655, 72, 6772763, "Subsubtitle"],
Cell[156594, 4138, 771, 11, 3106402, "Subsubsection"],
Cell[157368, 4151, 2881, 89, 11845189, "Code"],
Cell[160252, 4242, 89, 2, 3106402, "Subsubsection"],
Cell[160344, 4246, 145, 2, 2128979, "Subsubsection"],
Cell[160492, 4250, 1490, 30, 3106402, "Subsubsection"],
Cell[161985, 4282, 3478, 96, 13622720, "Subsubtitle"],
Cell[165466, 4380, 771, 11, 3106402, "Subsubsection"],
Cell[166240, 4393, 3674, 112, 14141412, "Code"],
Cell[169917, 4507, 44, 1, 224246, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[169998, 4513, 1029, 24, 126, "Title"],
Cell[171030, 4539, 219, 5, 968, "Subsubsection"],
Cell[171252, 4546, 978, 35, 1374, "Subsubsection"],
Cell[172233, 4583, 1102, 39, 2113, "Subsubsection"],
Cell[173338, 4624, 1115, 26, 1079, "Subsubsection"],
Cell[174456, 4652, 1899, 58, 3765, "Subsubtitle"],
Cell[176358, 4712, 771, 11, 968, "Subsubsection"],
Cell[177132, 4725, 2634, 78, 4401, "Code"],
Cell[179769, 4805, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[179850, 4811, 1181, 28, 126, "Title"],
Cell[181034, 4841, 235, 3, 968, "Subsubsection"],
Cell[181272, 4846, 860, 29, 1506, "Subsubsection"],
Cell[182135, 4877, 1003, 20, 713, "Subsubsection"],
Cell[183141, 4899, 1635, 46, 2260, "Subsubtitle"],
Cell[184779, 4947, 771, 11, 968, "Subsubsection"],
Cell[185553, 4960, 2006, 58, 2958, "Code"],
Cell[187562, 5020, 89, 2, 968, "Subsubsection"],
Cell[187654, 5024, 201, 3, 664, "Subsubsection"],
Cell[187858, 5029, 1157, 39, 1661, "Subsubsection"],
Cell[189018, 5070, 1239, 30, 1210, "Subsubsection"],
Cell[190260, 5102, 1694, 48, 2882, "Subsubtitle"],
Cell[191957, 5152, 771, 11, 968, "Subsubsection"],
Cell[192731, 5165, 2677, 73, 3687, "Code"],
Cell[195411, 5240, 89, 2, 968, "Subsubsection"],
Cell[195503, 5244, 219, 5, 664, "Subsubsection"],
Cell[195725, 5251, 978, 35, 1374, "Subsubsection"],
Cell[196706, 5288, 1104, 39, 2113, "Subsubsection"],
Cell[197813, 5329, 1115, 26, 1079, "Subsubsection"],
Cell[198931, 5357, 2187, 65, 3765, "Subsubtitle"],
Cell[201121, 5424, 771, 11, 968, "Subsubsection"],
Cell[201895, 5437, 3195, 90, 4401, "Code"],
Cell[205093, 5529, 44, 1, 71, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[205174, 5535, 1396, 30, 126, "Title"],
Cell[206573, 5567, 273, 4, 181, "Subsubsection"],
Cell[206849, 5573, 1116, 15, 125, "Subsubsection"],
Cell[207968, 5590, 1640, 40, 473, "Subsubtitle"],
Cell[209611, 5632, 771, 11, 181, "Subsubsection"],
Cell[210385, 5645, 1688, 45, 551, "Code"],
Cell[212076, 5692, 89, 2, 181, "Subsubsection"],
Cell[212168, 5696, 297, 4, 125, "Subsubsection"],
Cell[212468, 5702, 1516, 29, 181, "Subsubsection"],
Cell[213987, 5733, 1933, 49, 422, "Subsubtitle"],
Cell[215923, 5784, 771, 11, 181, "Subsubsection"],
Cell[216697, 5797, 2326, 61, 551, "Code"],
Cell[219026, 5860, 89, 2, 181, "Subsubsection"],
Cell[219118, 5864, 323, 5, 125, "Subsubsection"],
Cell[219444, 5871, 1565, 31, 181, "Subsubsection"],
Cell[221012, 5904, 1979, 50, 422, "Subsubtitle"],
Cell[222994, 5956, 771, 11, 181, "Subsubsection"],
Cell[223768, 5969, 2365, 63, 551, "Code"],
Cell[226136, 6034, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[226217, 6040, 1402, 29, 80, "Title"],
Cell[227622, 6071, 319, 6, 35, "Subsubsection"],
Cell[227944, 6079, 1750, 55, 65, "Subsubsection"],
Cell[229697, 6136, 1074, 31, 55, "Subsubsection"],
Cell[230774, 6169, 1489, 30, 39, "Subsubsection"],
Cell[232266, 6201, 1936, 52, 90, "Subsubtitle"],
Cell[234205, 6255, 771, 11, 35, "Subsubsection"],
Cell[234979, 6268, 3003, 79, 104, "Code"],
Cell[237985, 6349, 89, 2, 35, "Subsubsection"],
Cell[238077, 6353, 319, 6, 25, "Subsubsection"],
Cell[238399, 6361, 1845, 56, 54, "Subsubsection"],
Cell[240247, 6419, 1101, 31, 51, "Subsubsection"],
Cell[241351, 6452, 1624, 32, 39, "Subsubsection"],
Cell[242978, 6486, 2039, 53, 80, "Subsubtitle"],
Cell[245020, 6541, 771, 11, 35, "Subsubsection"],
Cell[245794, 6554, 3260, 83, 104, "Code"],
Cell[249057, 6639, 89, 2, 35, "Subsubsection"],
Cell[249149, 6643, 475, 7, 25, "Subsubsection"],
Cell[249627, 6652, 667, 11, 25, "Subsubsection"],
Cell[250297, 6665, 2361, 41, 35, "Subsubsection"],
Cell[252661, 6708, 2780, 68, 68, "Subsubtitle"],
Cell[255444, 6778, 771, 11, 35, "Subsubsection"],
Cell[256218, 6791, 4332, 101, 154, "Code"],
Cell[260553, 6894, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[260634, 6900, 1409, 30, 80, "Title"],
Cell[262046, 6932, 241, 4, 35, "Subsubsection"],
Cell[262290, 6938, 1377, 26, 39, "Subsubsection"],
Cell[263670, 6966, 1901, 51, 69, "Subsubtitle"],
Cell[265574, 7019, 771, 11, 35, "Subsubsection"],
Cell[266348, 7032, 2018, 59, 129, "Code"],
Cell[268369, 7093, 89, 2, 35, "Subsubsection"],
Cell[268461, 7097, 319, 6, 25, "Subsubsection"],
Cell[268783, 7105, 1750, 55, 65, "Subsubsection"],
Cell[270536, 7162, 1024, 30, 55, "Subsubsection"],
Cell[271563, 7194, 1668, 34, 39, "Subsubsection"],
Cell[273234, 7230, 2050, 55, 90, "Subsubtitle"],
Cell[275287, 7287, 771, 11, 35, "Subsubsection"],
Cell[276061, 7300, 3387, 88, 129, "Code"],
Cell[279451, 7390, 89, 2, 35, "Subsubsection"],
Cell[279543, 7394, 319, 6, 25, "Subsubsection"],
Cell[279865, 7402, 1845, 56, 54, "Subsubsection"],
Cell[281713, 7460, 1049, 30, 51, "Subsubsection"],
Cell[282765, 7492, 1725, 35, 39, "Subsubsection"],
Cell[284493, 7529, 2047, 54, 80, "Subsubtitle"],
Cell[286543, 7585, 771, 11, 35, "Subsubsection"],
Cell[287317, 7598, 3519, 89, 129, "Code"],
Cell[290839, 7689, 89, 2, 35, "Subsubsection"],
Cell[290931, 7693, 288, 4, 25, "Subsubsection"],
Cell[291222, 7699, 445, 8, 25, "Subsubsection"],
Cell[291670, 7709, 1764, 33, 26, "Subsubsection"],
Cell[293437, 7744, 2906, 75, 125, "Subsubtitle"],
Cell[296346, 7821, 771, 11, 35, "Subsubsection"],
Cell[297120, 7834, 3231, 92, 154, "Code"],
Cell[300354, 7928, 89, 2, 35, "Subsubsection"],
Cell[300446, 7932, 389, 6, 25, "Subsubsection"],
Cell[300838, 7940, 2049, 37, 26, "Subsubsection"],
Cell[302890, 7979, 3036, 82, 122, "Subsubtitle"],
Cell[305929, 8063, 771, 11, 35, "Subsubsection"],
Cell[306703, 8076, 4135, 111, 154, "Code"],
Cell[310841, 8189, 89, 2, 35, "Subsubsection"],
Cell[310933, 8193, 313, 5, 25, "Subsubsection"],
Cell[311249, 8200, 576, 9, 25, "Subsubsection"],
Cell[311828, 8211, 1980, 37, 26, "Subsubsection"],
Cell[313811, 8250, 2980, 81, 146290, "Subsubtitle"],
Cell[316794, 8333, 771, 11, 39139, "Subsubsection"],
Cell[317568, 8346, 4469, 117, 207964, "Code"],
Cell[322040, 8465, 89, 2, 39139, "Subsubsection"],
Cell[322132, 8469, 433, 6, 26825, "Subsubsection"],
Cell[322568, 8477, 540, 7, 26825, "Subsubsection"],
Cell[323111, 8486, 2422, 48, 28827, "Subsubsection"],
Cell[325536, 8536, 3545, 98, 146449, "Subsubtitle"],
Cell[329084, 8636, 771, 11, 692, "Subsubsection"],
Cell[329858, 8649, 5053, 136, 3670, "Code"],
Cell[334914, 8787, 89, 2, 692, "Subsubsection"],
Cell[335006, 8791, 361, 5, 475, "Subsubsection"],
Cell[335370, 8798, 2045, 38, 510, "Subsubsection"],
Cell[337418, 8838, 2261, 61, 1397, "Subsubtitle"],
Cell[339682, 8901, 771, 11, 692, "Subsubsection"],
Cell[340456, 8914, 3538, 91, 3144, "Code"],
Cell[343997, 9007, 89, 2, 692, "Subsubsection"],
Cell[344089, 9011, 413, 6, 475, "Subsubsection"],
Cell[344505, 9019, 440, 6, 475, "Subsubsection"],
Cell[344948, 9027, 2198, 43, 510, "Subsubsection"],
Cell[347149, 9072, 3471, 98, 2585, "Subsubtitle"],
Cell[350623, 9172, 771, 11, 692, "Subsubsection"],
Cell[351397, 9185, 5073, 138, 3670, "Code"],
Cell[356473, 9325, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[356554, 9331, 1511, 33, 80, "Title"],
Cell[358068, 9366, 475, 7, 692, "Subsubsection"],
Cell[358546, 9375, 641, 10, 475, "Subsubsection"],
Cell[359190, 9387, 2491, 46, 692, "Subsubsection"],
Cell[361684, 9435, 5148, 128, 4085, "Subsubtitle"],
Cell[366835, 9565, 771, 11, 692, "Subsubsection"],
Cell[367609, 9578, 6291, 154, 4181, "Code"],
Cell[373903, 9734, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[373984, 9740, 1574, 33, 80, "Title"],
Cell[375561, 9775, 132, 1, 35, "Subsubsection"],
Cell[375696, 9778, 1619, 53, 44, "Subsubsection"],
Cell[377318, 9833, 649, 11, 25, "Subsubsection"],
Cell[377970, 9846, 2305, 41, 39, "Subsubsection"],
Cell[380278, 9889, 3180, 70, 67, "Subsubtitle"],
Cell[383461, 9961, 771, 11, 35, "Subsubsection"],
Cell[384235, 9974, 4034, 92, 104, "Code"],
Cell[388272, 10068, 89, 2, 35, "Subsubsection"],
Cell[388364, 10072, 132, 1, 25, "Subsubsection"],
Cell[388499, 10075, 2037, 61, 47, "Subsubsection"],
Cell[390539, 10138, 731, 12, 25, "Subsubsection"],
Cell[391273, 10152, 2329, 41, 39, "Subsubsection"],
Cell[393605, 10195, 4015, 89, 71, "Subsubtitle"],
Cell[397623, 10286, 771, 11, 35, "Subsubsection"],
Cell[398397, 10299, 5099, 112, 129, "Code"],
Cell[403499, 10413, 4724, 98, 214, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
