/* Free Foundation Classes for string ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcstring: ffcstring.h,v 1.44.1 2001/09/17 22:57:48 Toshihiro Inoue Exp $
 */

#ifndef _FFCSTRING_H_
#define _FFCSTRING_H_


class FFCString
{
public:
  inline operator const char*() const { return buffer; }
  inline const char* data() const { return buffer; }
  inline int length() const { return size; }
  inline char operator[](int pos) const { return buffer[pos]; }
  inline bool empty() const { return size < 1; }
  friend FFCString operator+(const char* str1, const FFCString& str2);
  
public:
  FFCString();
  FFCString(const FFCString& s);
  FFCString(const char* s);
  FFCString(const char* s, int len);
  virtual ~FFCString();
  void setMaxSize(int sz);
  void erase();
  FFCString& operator=(const FFCString& s);
  FFCString& operator=(const char* s);
  FFCString& setString(const char* s, int len = -1);
  FFCString& sprintf(const char* fmt,  ...);
  FFCString& operator+=(char ch);
  FFCString& operator+=(unsigned short ch);
  FFCString& operator+=(const char* s);
  FFCString& operator+=(const FFCString& s);
  FFCString& append(const char* s, int len);
  FFCString operator+(const FFCString& str) const;
  FFCString operator+(const char* str) const;
  bool operator==(const FFCString& str) const;
  bool operator==(const char* str) const;
  bool operator!=(const FFCString& str) const;
  bool operator!=(const char* str) const;
  bool operator<(const FFCString& str) const;
  bool operator<(const char* str) const;
  bool operator>(const FFCString& str) const;
  bool operator>(const char* str) const;
  bool operator<=(const FFCString& str) const;
  bool operator<=(const char* str) const;
  bool operator>=(const FFCString& str) const;
  bool operator>=(const char* str) const;
  bool prefix(const FFCString& str) const;
  bool prefix(const char* str) const;
  bool suffix(const FFCString& str) const;
  bool suffix(const char* str) const;
  FFCString lower() const;
  FFCString upper() const;
  FFCString rmSpace() const;
  int toInt();
  FFCString mid(int pos, int len = -1) const;
  FFCString left(int len) const;
  FFCString right(int len) const;
  FFCString insert(int pos, const FFCString& s) const;
  FFCString remove(int pos, int len = -1) const;
  int find(char ch, int pos = 0) const;
  int find(const char* str, int pos = 0) const;
  int rfind(char ch) const;
  FFCString replace(char ch1, char ch2) const;
  FFCString directReplace(char ch1, char ch2);
  FFCString& operator-=(int len);
  FFCString& directInsert(int pos, const FFCString& s);
  FFCString& directRemove(int pos, int len = -1);
  static void memcpy(void* dst, const void* src, int len);
  
private:
  void __init_class__();
  void init();
  
protected:
  char* buffer;
  int size;
  int max;
};

#endif // _FFCSTRING_H_
