#include "fxex.h"
#define PORT 20002

class SocketServer : public FXMainWindow {
  FXDECLARE(SocketServer)
protected:
  FXButton            *sendbutton;
  FXSocketServer      *socketserver;
  FXSocket            *lastsocket;
protected:
  SocketServer(){}
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onSocketOpened(FXObject*,FXSelector,void*);
  long onSocketClosed(FXObject*,FXSelector,void*);
  long onSocketRead(FXObject*,FXSelector,void*);
  long onCmdSend(FXObject*,FXSelector,void*);
  long onUpdSend(FXObject*,FXSelector,void*);
public:
  enum{
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_SOCKET,
    ID_SEND,
    ID_SENDTEXT,
    ID_LAST
    };
public:
  SocketServer(FXApp* a);
  virtual void create();
  virtual ~SocketServer();
  };


// map...
FXDEFMAP(SocketServer) SocketServerMap[]={
  // quit application
  FXMAPFUNC(SEL_CLOSE,0,SocketServer::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,SocketServer::ID_MAINWINDOW,SocketServer::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,SocketServer::ID_QUIT,SocketServer::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,SocketServer::ID_QUIT,SocketServer::onCmdQuit),
  // handle socket event
  FXMAPFUNC(SEL_OPENED,SocketServer::ID_SOCKET,SocketServer::onSocketOpened),
  FXMAPFUNC(SEL_DESTROY,SocketServer::ID_SOCKET,SocketServer::onSocketClosed),
  FXMAPFUNC(SEL_COMMAND,SocketServer::ID_SOCKET,SocketServer::onSocketRead),
  // send some text
  FXMAPFUNC(SEL_COMMAND,SocketServer::ID_SEND,SocketServer::onCmdSend),
  FXMAPFUNC(SEL_UPDATE,SocketServer::ID_SEND,SocketServer::onUpdSend),
  FXMAPFUNC(SEL_COMMAND,SocketServer::ID_SENDTEXT,SocketServer::onCmdSend),
  FXMAPFUNC(SEL_UPDATE,SocketServer::ID_SENDTEXT,SocketServer::onUpdSend),
  };
FXIMPLEMENT(SocketServer,FXMainWindow,SocketServerMap,ARRAYNUMBER(SocketServerMap))


// ctor
SocketServer::SocketServer(FXApp* a) : FXMainWindow(a,"Socker Server demo"){
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  new FXToolTip(getApp());
  setX(50);
  setY(50);
  FXToolBar *toolbar=new FXToolBar(this,LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // populate toolbar
  new FXButton(toolbar,"&Quit",NULL,this,ID_QUIT);
  sendbutton = new FXButton(toolbar,"&Send text",NULL,this,ID_SEND);

  // text field
  new FXTextField(this,40,this,ID_SENDTEXT,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);

  // open socket server
  socketserver=new FXSocketServer(getApp(),PORT,5,this,ID_SOCKET);
  }

// dtor
SocketServer::~SocketServer(){
  delete socketserver;
  }

// create resources
void SocketServer::create(){
  FXMainWindow::create();
  socketserver->create();
  if (socketserver->status() != FXIOStatusOk) fxerror("socketserver startup failed\n");
  show();
  }

// quit application
long SocketServer::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit();
  return 1;
  }

// socket just opened
long SocketServer::onSocketOpened(FXObject*,FXSelector,void *ptr){
  FXSocket *s = (FXSocket*)ptr;
  fxmessage("inbound socket: %i\n",s->getHandle());
  lastsocket=s;
  s->setText("hello client");
  return 1;
  }

// socket wants us to read some data
long SocketServer::onSocketRead(FXObject* sender,FXSelector,void*){
  FXSocket *s = (FXSocket*)sender;
  lastsocket=s;
  fxmessage("socket: %i, incoming text: '%s'\n",s->getHandle(),s->getText().text());
  return 1;
  }

// socket closed for some unknown reason
long SocketServer::onSocketClosed(FXObject* sender,FXSelector,void*){
  FXSocket *s = (FXSocket*)sender;
  if (lastsocket==s) lastsocket=NULL;
  fxmessage("socket closed: %i\n",s->getHandle());
  return 1;
  }

// demonstrates that we can keep receiving data, while interacting with environment
long SocketServer::onCmdSend(FXObject*,FXSelector sel,void *ptr){
  if (lastsocket) {
    FXString msg="a server message";
    if (FXSELID(sel)==ID_SENDTEXT) msg=*((FXString*)ptr);
    lastsocket->setText(msg);
    }
  else fxmessage("Server not connected to any clients\n");
  return 1;
  }

// demonstrates that we can keep receiving data, while interacting with environment
long SocketServer::onUpdSend(FXObject* sender,FXSelector,void*){
  if (lastsocket)
    sender->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

// start the ball rolling
int main(int argc,char *argv[]){
  FXApp app("Socket Server Test","FoxExTest");
  app.init(argc,argv);
  new SocketServer(&app);
  app.create();
  return app.run();
  }

