#include "fxex.h"
#define PORT 20002

class SocketClient : public FXMainWindow {
  FXDECLARE(SocketClient)
protected:
  FXSocketClient  *socket;
protected:
  SocketClient(){}
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onSocketOpened(FXObject*,FXSelector,void*);
  long onSocketRead(FXObject*,FXSelector,void*);
  long onSocketClosed(FXObject*,FXSelector,void*);
  long onCmdDisconnect(FXObject*,FXSelector,void*);
  long onCmdConnect(FXObject*,FXSelector,void*);
  long onCmdSend(FXObject*,FXSelector,void*);
  long onUpdConnected(FXObject*,FXSelector,void*);
public:
  enum{
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_SOCKET,
    ID_DISCONNECT,
    ID_CONNECT,
    ID_SEND,
    ID_SENDTEXT,
    ID_LAST
    };
public:
  SocketClient(FXApp* a);
  virtual void create();
  virtual ~SocketClient();
  };


// map...
FXDEFMAP(SocketClient) SocketClientMap[]={
  // close application
  FXMAPFUNC(SEL_CLOSE,0,SocketClient::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,SocketClient::ID_MAINWINDOW,SocketClient::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,SocketClient::ID_QUIT,SocketClient::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_QUIT,SocketClient::onCmdQuit),
  // handle socket event
  FXMAPFUNC(SEL_OPENED,SocketClient::ID_SOCKET,SocketClient::onSocketOpened),
  FXMAPFUNC(SEL_DESTROY,SocketClient::ID_SOCKET,SocketClient::onSocketClosed),
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_SOCKET,SocketClient::onSocketRead),
  // update widget state
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_CONNECT,SocketClient::onCmdConnect),
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_DISCONNECT,SocketClient::onCmdDisconnect),
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_SEND,SocketClient::onCmdSend),
  FXMAPFUNC(SEL_COMMAND,SocketClient::ID_SENDTEXT,SocketClient::onCmdSend),
  FXMAPFUNC(SEL_UPDATE,SocketClient::ID_CONNECT,SocketClient::onUpdConnected),
  FXMAPFUNC(SEL_UPDATE,SocketClient::ID_DISCONNECT,SocketClient::onUpdConnected),
  FXMAPFUNC(SEL_UPDATE,SocketClient::ID_SEND,SocketClient::onUpdConnected),
  FXMAPFUNC(SEL_UPDATE,SocketClient::ID_SENDTEXT,SocketClient::onUpdConnected),
  };
FXIMPLEMENT(SocketClient,FXMainWindow,SocketClientMap,ARRAYNUMBER(SocketClientMap))


// ctor
SocketClient::SocketClient(FXApp* a) : FXMainWindow(a,"Socket Client demo"){
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  new FXToolTip(getApp());
  setX(400);
  setY(50);
  FXToolBar *toolbar=new FXToolBar(this,LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // buttons on toolbar
  new FXButton(toolbar,"&Quit",NULL,this,ID_QUIT,FRAME_RAISED);
  new FXButton(toolbar,"&Connect socket",NULL,this,ID_CONNECT,FRAME_RAISED);
  new FXButton(toolbar,"&Disconnect socket",NULL,this,ID_DISCONNECT,FRAME_RAISED);
  new FXButton(toolbar,"&Send text",NULL,this,ID_SEND,FRAME_RAISED);

  // text field
  new FXTextField(this,40,this,ID_SENDTEXT,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);

  // the socket
  socket = new FXSocketClient(getApp(),"localhost",PORT,this,ID_SOCKET);
  }

SocketClient::~SocketClient(){
  delete socket;
  }

void SocketClient::create(){
  FXMainWindow::create();
  show();
  socket->create();
  if (socket->status() != FXIOStatusOk) {
    fxmessage("socketclient failed to connect to server\n");
    socket->destroy();
    }
  }

long SocketClient::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit();
  return 1;
  }

// socket just opened
long SocketClient::onSocketOpened(FXObject*,FXSelector,void *ptr){
  FXSocket *s = (FXSocket*) ptr;
  fxmessage("socket opened: %i\n",s->getHandle());
  s->setText("hello server");
  return 1;
  }

// socket wants us to read some data
long SocketClient::onSocketRead(FXObject* sender,FXSelector,void*){
  FXSocket *s = (FXSocket*) sender;
  fxmessage("socket: %i, incoming text: '%s'\n",s->getHandle(),s->getText().text());
  return 1;
  }

// socket closed for some unknown reason
long SocketClient::onSocketClosed(FXObject* sender,FXSelector,void*){
  FXSocket *s = (FXSocket*) sender;
  fxmessage("socket closed: %i\n",s->getHandle());
  return 1;
  }

// grey out widgets when not connected
long SocketClient::onUpdConnected(FXObject* sender,FXSelector sel,void*){
  FXushort msg=ID_DISABLE;
  if (FXSELID(sel)==ID_CONNECT){
    if (!socket->opened()) msg=ID_ENABLE;
    }
  else {
    if (socket->opened()) msg=ID_ENABLE;
    }
  sender->handle(this,FXSEL(SEL_COMMAND,msg),NULL);
  return 1;
  }

// send some text
long SocketClient::onCmdSend(FXObject* sender,FXSelector sel,void *ptr){
  if (socket->opened()) {
    FXString msg="a client message";
    if (FXSELID(sel)==ID_SENDTEXT) msg=*((FXString*)ptr);
    socket->setText(msg);
    sender->handle(this,FXSEL(SEL_COMMAND,FXTextField::ID_DELETE),NULL);
    }
  else fxmessage("socket is not connected\n");
  return 1;
  }

// disconnect from server, on button press
long SocketClient::onCmdDisconnect(FXObject*,FXSelector,void*){
  if (socket->opened()) socket->close();
  return 1;
  }

// connect to server, on button press
long SocketClient::onCmdConnect(FXObject*,FXSelector,void*){
  if (socket->closed()) {
    if (!socket->open()) fxmessage("socketclient failed to connect to server\n");
    }
  return 1;
  }

// start the ball rolling
int main(int argc,char *argv[]){
  FXApp app("Socket Client Test","FoxExTest");
  app.init(argc,argv);
  new SocketClient(&app);
  app.create();
  return app.run();
  }

