#include "fxex.h"

class MainWindow : public FXMainWindow {
  FXDECLARE(MainWindow)
private:
  FXProcess *duplicate;
  FXProcess *external;
protected:
  MainWindow(){}
public:
  enum {
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_DUPLICATE_START,
    ID_EXTERNAL_START,
    ID_DUPLICATE,
    ID_EXTERNAL,
    ID_QUIT
    };
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onDuplicateStart(FXObject*,FXSelector,void*);
  long onExternalStart(FXObject*,FXSelector,void*);
  long onDuplicateDeath(FXObject*,FXSelector,void*);
  long onExternalDeath(FXObject*,FXSelector,void*);
  long onDuplicateInput(FXObject*,FXSelector,void*);
  long onExternalInput(FXObject*,FXSelector,void*);
  long onDuplicateOutput(FXObject*,FXSelector,void*);
  long onExternalOutput(FXObject*,FXSelector,void*);
  long onDuplicateError(FXObject*,FXSelector,void*);
  long onExternalError(FXObject*,FXSelector,void*);
public:
  MainWindow(FXApp* a);
  void create();
  ~MainWindow();
  };


// Map
FXDEFMAP(MainWindow) MainWindowMap[]={
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_QUIT,MainWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,MainWindow::ID_QUIT,MainWindow::onCmdQuit),

  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_DUPLICATE_START,MainWindow::onDuplicateStart),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_EXTERNAL_START,MainWindow::onExternalStart),
  
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_DUPLICATE,MainWindow::onDuplicateDeath),
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_EXTERNAL,MainWindow::onExternalDeath),
  FXMAPFUNC(SEL_INPUT,MainWindow::ID_DUPLICATE,MainWindow::onDuplicateInput),
  FXMAPFUNC(SEL_INPUT,MainWindow::ID_EXTERNAL,MainWindow::onExternalInput),
  FXMAPFUNC(SEL_OUTPUT,MainWindow::ID_DUPLICATE,MainWindow::onDuplicateOutput),
  FXMAPFUNC(SEL_OUTPUT,MainWindow::ID_EXTERNAL,MainWindow::onExternalOutput),
  FXMAPFUNC(SEL_ERROR,MainWindow::ID_DUPLICATE,MainWindow::onDuplicateError),
  FXMAPFUNC(SEL_ERROR,MainWindow::ID_EXTERNAL,MainWindow::onExternalError),

  };
FXIMPLEMENT(MainWindow,FXMainWindow,MainWindowMap,ARRAYNUMBER(MainWindowMap))

// Make some windows
MainWindow::MainWindow(FXApp* a):FXMainWindow(a,"Parent process Test",NULL,NULL,DECOR_TITLE|DECOR_MINIMIZE|DECOR_MAXIMIZE|DECOR_CLOSE|DECOR_BORDER|DECOR_STRETCHABLE|DECOR_MENU){
  new FXToolTip(getApp(),TOOLTIP_PERMANENT);
  FXToolBar *toolbar=new FXToolBar(this,FRAME_RAISED|LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  new FXButton(toolbar,"&Quit",NULL,this,ID_QUIT,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);
  setWidth(200);
  setHeight(200);
  setX(0);
  setY(0);
  new FXButton(toolbar,"&Make duplicate child",NULL,this,ID_DUPLICATE_START,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);
  new FXButton(toolbar,"&Make external process",NULL,this,ID_EXTERNAL_START,BUTTON_TOOLBAR|FRAME_RAISED|FRAME_THICK);
  }

MainWindow::~MainWindow(){
  }

// Start
void MainWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_MAXIMIZED);
  }

// quit application
long MainWindow::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit(0);
  return 1;
  }

// duplicate this process
long MainWindow::onDuplicateStart(FXObject*,FXSelector,void*){
  if (duplicate) return 1;
  fxmessage("Making duplicate of self\n");
  duplicate = new FXProcess(getApp(),this,ID_DUPLICATE);
  return 1;
  }

// make a child process
long MainWindow::onExternalStart(FXObject*,FXSelector,void*){
  if (external) return 1;
  FXString process="childprocess";
  FXStringList args;
  fxmessage("Start a child process called: '%s'\n",process.text());
//  external = new FXProcess(getApp(),process,&args,this,ID_EXTERNAL);
  return 1;
  }

long MainWindow::onDuplicateDeath(FXObject*,FXSelector,void*){
  fxmessage("duplicate death\n");
  return 1;
  }

long MainWindow::onExternalDeath(FXObject*,FXSelector,void*){
  fxmessage("external death\n");
  return 1;
  }

long MainWindow::onDuplicateInput(FXObject*,FXSelector,void*){
  fxmessage("duplicate input\n");
  return 1;
  }

long MainWindow::onExternalInput(FXObject*,FXSelector,void*){
  fxmessage("external input\n");
  return 1;
  }

long MainWindow::onDuplicateOutput(FXObject*,FXSelector,void*){
  fxmessage("duplicate Output\n");
  return 1;
  }

long MainWindow::onExternalOutput(FXObject*,FXSelector,void*){
  fxmessage("external Output\n");
  return 1;
  }

long MainWindow::onDuplicateError(FXObject*,FXSelector,void*){
  fxmessage("duplicate Error\n");
  return 1;
  }

long MainWindow::onExternalError(FXObject*,FXSelector,void*){
  fxmessage("external Error\n");
  return 1;
  }

/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){
  FXApp app("ParentProcess","FoxTest");
  app.init(argc,argv);
  new MainWindow(&app);
  app.create();
  return app.run();
  }

