/********************************************************************************
*                                                                               *
*                   Thread object for worker functions                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXMutex.h"
#include "FXThreadFunction.h"
using namespace FXEX;
namespace FXEX {

// map
FXIMPLEMENT(FXThreadFunction,FXRunnable,NULL,0)

// PThread needs a 'void*' to start executing... WIN32 needs something similar...
// Thus we need this helper routine.
#ifndef WIN32
extern "C" void* ThreadFunctionSetup(void *ptr){
#else
extern "C" LPTHREAD_START_ROUTINE ThreadFunctionSetup(void *ptr){
#endif
  FXThreadFunction *th=(FXThreadFunction*)ptr;
  th->signal(SEL_CREATE);
  (*th->threadFunction)();
  th->reset();
  th->signal(SEL_DESTROY);
  return NULL;
  }


// construct a new thread object, to execute the specified function
FXThreadFunction::FXThreadFunction(void (*func)(),FXObject *tgt,FXSelector sel) : FXRunnable(tgt,sel){
  threadFunction=func;
  thread=NULL;
  }

// dtor
FXThreadFunction::~FXThreadFunction(){
  if (thread) fxerror("%s: thread still running\n",getClassName());
  }

// set to new function
void FXThreadFunction::setFunc(void (*func)()){
  mutex->lock();
  threadFunction=func;
  mutex->unlock();
  }

// start the thread running
void FXThreadFunction::start(){
  mutex->lock();
  if (thread) fxerror("%s: trying to start thread while existing thread is still running\n",getClassName());
  if (threadFunction==NULL) fxerror("FXThreadFunction: failed to start NULL thread\n");
#ifndef WIN32
  FXMALLOC(&thread,pthread_t,1);
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_DETACHED);
  if (pthread_create((pthread_t*)thread,&attr,ThreadFunctionSetup,this) != 0 )
    fxerror("%s failure: Could not create thread\n",getClassName());
  pthread_attr_destroy(&attr);
#else
  DWORD tid;
  if((thread=CreateThread(NULL,0,ThreadFunctionSetup,(void*)this,NULL,&tid))==NULL)
    fxerror("%s failure: Could not create thread\n",getClassName());
#endif
  mutex->unlock();
  }

// reset the thread
void FXThreadFunction::reset(){
  mutex->lock();
  if (thread) {
#ifndef WIN32
    FXFREE(&thread);
#else
    CloseHandle(thread);
    thread=NULL;
#endif
    }
  mutex->unlock();
  }

}

