/********************************************************************************
*                                                                               *
*                Device Context (DC) helper routines                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXDC.h>
#include <fox/FXRegion.h>
#include <fox/FXWindow.h>
using namespace FX;
#include "FXDCHelper.h"
using namespace FXEX;
namespace FXEX {

// Frame styles
#define FRAME_MASK  (FRAME_LINE|FRAME_SUNKEN|FRAME_RAISED|FRAME_THICK|FRAME_GROOVE|FRAME_RIDGE)

// Create child frame window
FXDCHelper::FXDCHelper(FXApp *a,FXDC *dc,FXuint opts){
  app=a;
  device=dc;
  options=opts;
  setFrameStyle(opts);
  baseColor=getApp()->getBaseColor();
  hiliteColor=getApp()->getHiliteColor();
  shadowColor=getApp()->getShadowColor();
  borderColor=getApp()->getBorderColor();
  }

// create based on other DC helper
FXDCHelper::FXDCHelper(const FXDCHelper& h){
  app=h.app;
  device=h.device;
  options=h.options;
  setFrameStyle(h.options);
  baseColor=h.baseColor;
  hiliteColor=h.hiliteColor;
  shadowColor=h.shadowColor;
  borderColor=h.borderColor;
  }

// re-assign
FXDCHelper& FXDCHelper::operator=(const FXDCHelper& h){
  app=h.app;
  device=h.device;
  options=h.options;
  setFrameStyle(h.options);
  baseColor=h.baseColor;
  hiliteColor=h.hiliteColor;
  shadowColor=h.shadowColor;
  borderColor=h.borderColor;
  return *this;
  }

// dtor
FXDCHelper::~FXDCHelper(){
  device=(FXDC*)-1;
  }


void FXDCHelper::drawBorderRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(borderColor);
  device->drawRectangle(x,y,w-1,h-1);
  }


void FXDCHelper::drawRaisedRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(shadowColor);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  device->setForeground(hiliteColor);
  device->fillRectangle(x,y,w,1);
  device->fillRectangle(x,y,1,h);
  }


void FXDCHelper::drawSunkenRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(shadowColor);
  device->fillRectangle(x,y,w,1);
  device->fillRectangle(x,y,1,h);
  device->setForeground(hiliteColor);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  }


void FXDCHelper::drawRidgeRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(hiliteColor);
  device->fillRectangle(x,y,w,1);
  device->fillRectangle(x,y,1,h);
  device->fillRectangle(x+1,y+h-2,w-2,1);
  device->fillRectangle(x+w-2,y+1,1,h-2);
  device->setForeground(shadowColor);
  device->fillRectangle(x+1,y+1,w-3,1);
  device->fillRectangle(x+1,y+1,1,h-3);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  }


void FXDCHelper::drawGrooveRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(shadowColor);
  device->fillRectangle(x,y,w,1);
  device->fillRectangle(x,y,1,h);
  device->fillRectangle(x+1,y+h-2,w-2,1);
  device->fillRectangle(x+w-2,y+1,1,h-2);
  device->setForeground(hiliteColor);
  device->fillRectangle(x+1,y+1,w-3,1);
  device->fillRectangle(x+1,y+1,1,h-3);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  }


void FXDCHelper::drawDoubleRaisedRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(hiliteColor);
  device->fillRectangle(x,y,w-1,1);
  device->fillRectangle(x,y,1,h-1);
  device->setForeground(baseColor);
  device->fillRectangle(x+1,y+1,w-2,1);
  device->fillRectangle(x+1,y+1,1,h-2);
  device->setForeground(shadowColor);
  device->fillRectangle(x+1,y+h-2,w-2,1);
  device->fillRectangle(x+w-2,y+1,1,h-1);
  device->setForeground(borderColor);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  }

void FXDCHelper::drawDoubleSunkenRectangle(FXint x,FXint y,FXint w,FXint h){
  device->setForeground(shadowColor);
  device->fillRectangle(x,y,w-1,1);
  device->fillRectangle(x,y,1,h-1);
  device->setForeground(borderColor);
  device->fillRectangle(x+1,y+1,w-3,1);
  device->fillRectangle(x+1,y+1,1,h-3);
  device->setForeground(hiliteColor);
  device->fillRectangle(x,y+h-1,w,1);
  device->fillRectangle(x+w-1,y,1,h);
  device->setForeground(baseColor);
  device->fillRectangle(x+1,y+h-2,w-2,1);
  device->fillRectangle(x+w-2,y+1,1,h-2);
  }


// Draw border
void FXDCHelper::drawFrame(FXint x,FXint y,FXint w,FXint h){
  switch(options&FRAME_MASK) {
    case FRAME_LINE: drawBorderRectangle(x,y,w,h); break;
    case FRAME_SUNKEN: drawSunkenRectangle(x,y,w,h); break;
    case FRAME_RAISED: drawRaisedRectangle(x,y,w,h); break;
    case FRAME_GROOVE: drawGrooveRectangle(x,y,w,h); break;
    case FRAME_RIDGE: drawRidgeRectangle(x,y,w,h); break;
    case FRAME_SUNKEN|FRAME_THICK: drawDoubleSunkenRectangle(x,y,w,h); break;
    case FRAME_RAISED|FRAME_THICK: drawDoubleRaisedRectangle(x,y,w,h); break;
    }
  }


// draw region
void FXDCHelper::fillRegion(const FXRegion& region) {
  FXint clipW = device->getClipWidth();
  FXint clipH = device->getClipHeight();
  FXRectangle r;
  region.bounds(r);
  device->setClipRegion(region);
  device->fillRectangle(r.x,r.y,r.w,r.h);
  device->setClipRegion(FXRegion(0,0,clipW,clipH));
  }


// fill an arc
void FXDCHelper::fillArc(FXint x,FXint y,FXint w,FXint h,FXfloat start,FXfloat end){
  FXint as=(90*64)-lround(start*64);
  FXint ae=-lround((end-start)*64);
  device->fillArc(x-w,y-h,w<<1,h<<1,as,ae);
  }


// Change frame border style
void FXDCHelper::setFrameStyle(FXuint style){
  options=(options&~FRAME_MASK) | (style&FRAME_MASK);
  border=(options&FRAME_THICK) ? 2 : (options&(FRAME_SUNKEN|FRAME_RAISED)) ? 1 : 0;
  }


// Get frame style
FXuint FXDCHelper::getFrameStyle() const {
  return (options&FRAME_MASK);
  }


// Set base color
void FXDCHelper::setBaseColor(FXColor clr){
  baseColor=clr;
  }


// Set highlight color
void FXDCHelper::setHiliteColor(FXColor clr){
  hiliteColor=clr;
  }


// Set shadow color
void FXDCHelper::setShadowColor(FXColor clr){
  shadowColor=clr;
  }


// Set border color
void FXDCHelper::setBorderColor(FXColor clr){
  borderColor=clr;
  }

}

