/********************************************************************************
*                                                                               *
*                   Atomic data target                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/xincs.h>
#include <fox/fxver.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
class FXApp;
#include <fox/FXWindow.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXFastMutex.h"
#include "FXAtomic.h"
#include "FXAtomicDataTarget.h"
using namespace FXEX;
namespace FXEX {

// map
FXDEFMAP(FXAtomicIntDataTarget) FXAtomicIntDataTargetMap[]={
  FXMAPFUNC(SEL_COMMAND,FXDataTarget::ID_VALUE,FXAtomicIntDataTarget::onCmdValue),
  FXMAPFUNC(SEL_CHANGED,FXDataTarget::ID_VALUE,FXAtomicIntDataTarget::onCmdValue),
  FXMAPFUNC(SEL_UPDATE,FXDataTarget::ID_VALUE,FXAtomicIntDataTarget::onUpdValue),
  FXMAPFUNCS(SEL_COMMAND,FXDataTarget::ID_OPTION-10001,FXDataTarget::ID_OPTION+10000,FXAtomicIntDataTarget::onCmdOption),
  FXMAPFUNCS(SEL_UPDATE,FXDataTarget::ID_OPTION-10001,FXDataTarget::ID_OPTION+10000,FXAtomicIntDataTarget::onUpdOption),
  };
FXIMPLEMENT(FXAtomicIntDataTarget,FXDataTarget,FXAtomicIntDataTargetMap,ARRAYNUMBER(FXAtomicIntDataTargetMap))

// ctor
FXAtomicIntDataTarget::FXAtomicIntDataTarget(FXObject *tgt,FXSelector sel) : FXDataTarget(tgt,sel){}

// ctor
FXAtomicIntDataTarget::FXAtomicIntDataTarget(FXAtomicInt &a,FXObject *tgt,FXSelector sel) : FXDataTarget(tgt,sel){
  data=&a;
  type=DT_ATOMIC_INT;
  }

// connect to a new atomic int
void FXAtomicIntDataTarget::connect(FXAtomicInt &a){
  data=&a;
  type=DT_ATOMIC_INT;
  }

// Value changed from widget
long FXAtomicIntDataTarget::onCmdValue(FXObject* sender,FXSelector sel,void* ptr){
  if (type==DT_ATOMIC_INT) {
    FXint i=((FXAtomicInt*)data)->getValue();
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_GETINTVALUE),(void*)&i);
    ((FXAtomicInt*)data)->setValue(i);
    }
  return FXDataTarget::onCmdValue(sender,sel,ptr);
  }

// Widget changed from value
long FXAtomicIntDataTarget::onUpdValue(FXObject* sender,FXSelector sel,void* ptr){
  if (type==DT_ATOMIC_INT) {
    FXint i=((FXAtomicInt*)data)->getValue();
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETINTVALUE),(void*)&i);
    return 1;
    }
  return FXDataTarget::onUpdValue(sender,sel,ptr);
  }

// Value set from message id
long FXAtomicIntDataTarget::onCmdOption(FXObject* sender,FXSelector sel,void* ptr){
  if (type==DT_ATOMIC_INT) {
    FXint num=((FXint)FXSELID(sel))-ID_OPTION;
    ((FXAtomicInt*)data)->setValue(num);
    }
  return (FXDataTarget::onCmdOption(sender,sel,ptr));
  }

// Check widget whose message id matches
long FXAtomicIntDataTarget::onUpdOption(FXObject* sender,FXSelector sel,void* ptr){
  if (type==DT_ATOMIC_INT) {
    FXint num=((FXint)FXSELID(sel))-ID_OPTION;
    FXint i=((FXAtomicInt*)data)->getValue();
    if(i==num)
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
    else
      sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
    return 1;
    }
  return FXDataTarget::onUpdOption(sender,sel,ptr);
  }

}

