/********************************************************************************
*                                                                               *
*                      Simple db navigator control                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Giancarlo Formicuccia.  All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXDBNAVIGATOR_H
#define FXDBNAVIGATOR_H

#ifndef FXVERTICALFRAME_H
#include <fox/FXVerticalFrame.h>
#endif
namespace FXEX {
class FXDatabaseQuery;

class FXAPI FXdbNavigator: public FXVerticalFrame {
  FXDECLARE(FXdbNavigator)

private:
  FXMatrix *mtx;
    FXButton *bFirst;
    FXButton *bPrev;
    FXButton *bTo;
    FXButton *bNext;
    FXButton *bLst;
    FXButton *bAdd;
    FXButton *bEdit;
    FXButton *bDel;
    FXButton *bOk;
    FXButton *bCanc;
  FXDatabaseQuery *dbq;
protected:
  FXdbNavigator() {}
  void setEditMode(FXbool mode);
public:
  enum {
    ID_FIRST = FXVerticalFrame::ID_LAST,
    ID_PREV,
    ID_TO,
    ID_NEXT,
    ID_LST,
    ID_ADD,
    ID_EDIT,
    ID_DEL,
    ID_OK,
    ID_CANC,
    ID_DBQUERY,
    ID_LAST
  };
  long onFirst(FXObject *, FXSelector, void *);
  long onPrev(FXObject *, FXSelector, void *);
  long onTo(FXObject *, FXSelector, void *);
  long onNext(FXObject *, FXSelector, void *);
  long onLst(FXObject *, FXSelector, void *);
  long onAdd(FXObject *, FXSelector, void *);
  long onEdit(FXObject *, FXSelector, void *);
  long onDel(FXObject *, FXSelector, void *);
  long onOk(FXObject *, FXSelector, void *);
  long onCanc(FXObject *, FXSelector, void *);
  long onDBQuery(FXObject *, FXSelector, void *);
public:
  FXdbNavigator(FXComposite *p, FXDatabaseQuery *dbq);
  virtual void create();
  virtual ~FXdbNavigator() {}
  void setQuery(FXDatabaseQuery *dbq);
  FXDatabaseQuery *getQuery() const { return dbq; }
};

}
#endif /* FXDBNAVIGATOR_H */
