/********************************************************************************
*                                                                               *
*                   Recent Items object                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXRECENTITEMS_H
#define FXRECENTITEMS_H

#ifndef FXHISTORYITEMS_H
#include "FXHistoryItems.h"
#endif
namespace FXEX {

/**
* The Recent items manages a most recently used items list (an MRU list)
*/
class FXAPI FXRecentItems : public FXHistoryItems {
  FXDECLARE(FXRecentItems)

  private:
    FXRecentItems(const FXRecentItems&);
    FXRecentItems &operator=(const FXRecentItems&);

  protected:
    FXRecentItems(){}

  public:
    long onCmdItem(FXObject*,FXSelector sel,void*);

  public:
    /// Make new Recent Items Group with groupname gp,
    /// capable of tracking ten items
    FXRecentItems(FXApp *a,const FXString& gp="Recent Items",FXObject* tgt=NULL,FXSelector sel=0,FXint size=10);

    /// Add an item; its added to the top of the list.  If it already exists, it is removed.
    virtual FXint add(const FXString& name, void *data=NULL);

    ///dtor
    virtual ~FXRecentItems(){}
  };

} // namespace FXEX
#endif // FXRECENTITEMS_H
