/********************************************************************************
*                                                                               *
*                   Julian Date object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
// Origonal design/implementation taken from jDate by: J. Knight <jimbag@kw.igs.net>
#ifndef FXJULIANDATE_H
#define FXJULIANDATE_H

namespace FXEX {

/**
 * Julian date to Gregorian data object
 */
class FXAPI FXJulianDate {
private:
  FXuint julian;                      // the date in Julian date format
  static const FXchar *monthNames[];  // names of months
  static const FXchar *dayNames[];    // names of days of the week
  
protected:
  FXuint greg2jul( FXint y, FXint m, FXint d );
  void jul2greg( FXuint jd, FXint &y, FXint &m, FXint &d );

public:
  /// use today's date
  FXJulianDate();

  /// use specific date
  FXJulianDate( FXint yr, FXint mo, FXint da );
  
  /// set the adte to a specific date
  void setDate( FXint y, FXint m, FXint d );

  /// set it to today's date
  void today();

  /// accessors
  FXint day();
  FXint month();
  FXint year();
  FXint daysInMonth();
  FXint dayOfWeek();
  FXint dayOfYear();

  /// is the value a leap year
  FXbool leapYear( FXint y );

  /// get the name of the month
  const FXchar *monthName( FXint month ) const;

  /// get the name of the day
  const FXchar *dayName( FXint day ) const;

  /// save to stream
  friend FXAPI FXStream& operator<< (FXStream& store,const FXJulianDate& d);

  /// load from stream
  friend FXAPI FXStream& operator>> (FXStream& store,FXJulianDate& d);
  
  /// dtor
  virtual ~FXJulianDate() {}
  };

} // namespace FXEX
#endif // FXJULIANDATE_H
