#ifndef THREADEDPIPE_H
#define THREADEDPIPE_H

#include<windows.h>
#include <fx.h>
#include "FXExThread.h"
#include "FXExThreadEvent.h"

class ThreadedPipe : public FXExThread
{
protected:
	bool sync;
	CHAR lpBuffer[256];
	DWORD nBytesRead;
	HANDLE hRead;
	HANDLE hWrite;
	FXExThreadEvent * event;
	FXString outBuffer;
public:
  ThreadedPipe(FXObject * tgt,
						 FXSelector sel,
						 void* arg = NULL,
             priority_t pri = PRIORITY_NORMAL);
	static void * worker_task(void *);
	int write(const FXString & buf);
	const FXString & read();
protected:
	void lock();
	void unlock();
	void wait();
	virtual void * work(void *);
};

#endif // THREADEDPIPE_H