/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritebox.cpp,v 1.23.2 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteBox.h"
#include "FXSpriteLayer.h"

FXIMPLEMENT(FXSpriteBox, FXSpriteObject, NULL, 0)

FXSpriteBox::FXSpriteBox(FXSpriteLayer* layer,FXdouble x,FXdouble y,FXdouble w,FXdouble h,FXbool fill): FXSpriteObject(layer,x,y,w,h) {
  flgFill = fill;
  }

FXSpriteBox::~FXSpriteBox() {
  redraw();
  mW = 0;
  mH = 0;
  }

void FXSpriteBox::draw(FXDC* dc, FXdouble x, FXdouble y) {
  FXSpriteObject::draw(dc, x, y);
  FXSpriteRectangle r=getRect();
  x += r.x - absX;
  y += r.y - absY;
  if(flgFill) { dc->fillRectangle(FXint(x), FXint(y), FXint(r.w), FXint(r.h)); }
  else { dc->drawRectangle(FXint(x), FXint(y), FXint(r.w) - 1, FXint(r.h) - 1); }
  }

void FXSpriteBox::redraw() {
  if(!mShown || flgRedraw) return;
  FXSpriteRectangle r=getRect();
  if(flgFill) { mLayer->getCanvas()->redraw(r.x, r.y, r.w, r.h); }
  else {
    FXdouble lwx=FXdouble(lineWidth + 1);
    FXdouble lwxh=lwx / 2;
    FXdouble lwy=FXdouble(lineWidth + 1);
    FXdouble lwyh=lwy / 2;
    mLayer->getCanvas()->redraw(r.x - lwxh, r.y - lwyh, lwx, r.h + lwy);
    mLayer->getCanvas()->redraw(r.x + r.w - lwxh, r.y - lwyh, lwx, r.h + lwy);
    mLayer->getCanvas()->redraw(r.x + lwxh, r.y - lwyh, r.w - lwx, lwy);
    mLayer->getCanvas()->redraw(r.x + lwxh, r.y + r.h - lwyh, r.w - lwx, lwy);
    }
  flgRedraw = TRUE;
  }

FXSpriteRectangle FXSpriteBox::getRect() const {
  FXSpriteRectangle r = { absX, absY, mW, mH };
  if(r.w < 0) {
    r.x += r.w;
    r.w = -r.w;
    }
  if(r.h < 0) {
    r.y += r.h;
    r.h = -r.h;
    }
  r.w++;
  r.h++;
  return r;
  }

