/********************************************************************************
*                                                                               *
*                  Recent Items object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXRecentItems.h"
using namespace FXEX;
namespace FXEX {

/* This RecentItems is a list that items are appended to the front of the list.  If
 * it already existed in the list, it is removed. The app can move up and down the list.
 */

// Message map
FXDEFMAP(FXRecentItems) FXRecentItemsMap[] = {
  FXMAPFUNCS(SEL_COMMAND,FXHistoryItems::ID_ITEM_0,FXHistoryItems::ID_ITEM_9,FXRecentItems::onCmdItem),
  };
FXIMPLEMENT(FXRecentItems,FXHistoryItems,FXRecentItemsMap,ARRAYNUMBER(FXRecentItemsMap))


// Make a new Recent Items group
FXRecentItems::FXRecentItems(FXApp *a,const FXString& gp,FXObject* tgt,FXSelector sel,FXint size):FXHistoryItems(a,gp,tgt,sel,size){}


// Add an item; its added to the top of the list.  If it already exists, it is removed, and
// everything else is moved down the list one notch; the last one is dropped from the list.
FXint FXRecentItems::add(const FXString& name,void *data){
  if ( listStart != NULL && listStart->name == name ) return index(0);
  if ( moveFirst(name) == ID_ITEM_NOT_FOUND ) FXHistoryItems::add(name,data);
  return index();
  }


// User clicks on one of the item names
long FXRecentItems::onCmdItem(FXObject*,FXSelector sel,void*){
  FXint which=FXSELID(sel);
  moveFirst(which);
  if (target) target->handle(this,FXSEL(SEL_COMMAND,message),(void*)currentItem->name.text());
  return 1;
  }

}

