/********************************************************************************
*                                                                               *
*                  Garbage collector object                                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXObject.h>
#include <fox/FXException.h>
using namespace FX;
#include "FXArray.h"
#include "FXGarbageCollector.h"
using namespace FXEX;
namespace FXEX {

/// when we destruct, we garbage collect
FXGarbageCollector::~FXGarbageCollector() {
  FXint i;
  for (i=0; i<objects.no(); i++) {
    if (objects[i] != NULL && objects[i] != (FXObject*)-1) delete objects[i];
    } 
  for (i=0; i<streams.no(); i++) {
    if (streams[i] != NULL && streams[i] != (FXStream*)-1) delete streams[i];
    } 
  for (i=0; i<exceptions.no(); i++) {
    if (exceptions[i] != NULL && exceptions[i] != (FXException*)-1) delete exceptions[i];
    } 
  }

}

