/********************************************************************************
*                                                                               *
*                  Calendar widet                                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
* Copyright (C) by J. Knight.                                                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXGIFIcon.h>
#include <fox/FXHorizontalFrame.h>
#include <fox/FXSeparator.h>
#include <fox/FXMatrix.h>
#include <fox/FXButton.h>
using namespace FX;
#include "FXJulianDate.h"
#include "FXCalendar.h"
using namespace FXEX;
namespace FXEX {

// Desc: Calendar widget for FOX Library
// Auth: J. Knight <jimbag@kw.igs.net>
// Updated: Mathew Robertson


const unsigned char leftarrow1_gif[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0c,0x00,0x0c,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x02,0x17,0x84,
  0x0f,0x81,0x9b,0xca,0x16,0xe2,0x6b,0x92,0xc5,0x6b,0x6f,0x45,0x7a,0x73,0x3d,0x81,
  0xa1,0x97,0x4d,0x87,0x63,0x14,0x00,0x3b
  };

const unsigned char leftarrow2_gif[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0c,0x00,0x0c,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x02,0x1d,0x84,
  0x1d,0x87,0x1a,0x79,0xfd,0x20,0x92,0x8d,0x56,0x50,0x61,0xde,0xbc,0x77,0x9c,0x81,
  0x97,0xe8,0x84,0x93,0x23,0x32,0x28,0xa8,0x60,0x6d,0x50,0x00,0x00,0x3b
  };

const unsigned char rightarrow1_gif[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0c,0x00,0x0c,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x02,0x17,0x84,
  0x11,0xa7,0x1a,0xb9,0xdc,0xde,0x69,0x51,0xd2,0xba,0x2e,0x9e,0xfa,0x75,0x4f,0x49,
  0xc8,0x96,0x39,0xa2,0xa9,0x14,0x00,0x3b
  };

const unsigned char rightarrow2_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x0c,0x00,0x0c,0x00,0x80,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x21,0xfe,0x0e,0x4d,0x61,0x64,0x65,0x20,0x77,0x69,0x74,0x68,0x20,
  0x47,0x49,0x4d,0x50,0x00,0x2c,0x00,0x00,0x00,0x00,0x0c,0x00,0x0c,0x00,0x00,0x02,
  0x1c,0x0c,0x7e,0x86,0x10,0x9a,0xce,0x1a,0x6a,0x8e,0x2a,0xfb,0x68,0xd4,0xb6,0xfb,
  0xff,0x6d,0x12,0x26,0x66,0x93,0xf4,0x2c,0x68,0xb2,0x30,0x6d,0x01,0x00,0x3b
  };

// maps
FXDEFMAP(FXCalendar) FXCalendarMap[] = {
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_NEXTMONTH,FXCalendar::onNextMonth),
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_PREVMONTH,FXCalendar::onPrevMonth),
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_NEXTYEAR,FXCalendar::onNextYear),
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_PREVYEAR,FXCalendar::onPrevYear),
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_TODAY,FXCalendar::onToday),
  FXMAPFUNC(SEL_COMMAND,FXCalendar::ID_DAY,FXCalendar::onCmdDay),
  };
FXIMPLEMENT(FXCalendar,FXVerticalFrame,FXCalendarMap,ARRAYNUMBER(FXCalendarMap))

// ctor
FXCalendar::FXCalendar(FXComposite *p,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs,FXint vs) : FXVerticalFrame(p,opts,x,y,w,h,pl,pr,pt,pb,hs,vs) {
  hilite_color = FXRGB(255,0,0);
  FXColor medGrey = FXRGB(100,100,100);

  // make some icons
  FXIcon *leftArrow1= new FXGIFIcon(getApp(),leftarrow1_gif);
  FXIcon *leftArrow2= new FXGIFIcon(getApp(),leftarrow2_gif);
  FXIcon *rightArrow1= new FXGIFIcon(getApp(),rightarrow1_gif);
  FXIcon *rightArrow2= new FXGIFIcon(getApp(),rightarrow2_gif);

  // title label
  dateLabel = new FXLabel(this,"",0,LAYOUT_FILL_X);
  new FXHorizontalSeparator(this,LAYOUT_FILL_X|SEPARATOR_GROOVE);
  FXMatrix *matrix = new FXMatrix(this,7,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|PACK_UNIFORM_WIDTH, 0,0,0,0, 0,0,0,0, 0,0);

  // day labels
  FXLabel *lbl;
  for( FXint i = 0; i < 7; i++ ) {
    lbl= new FXLabel(matrix,currentDate.dayName(i),NULL,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X );
    if( i == 0 || i == 6 ) lbl->setTextColor(medGrey);
    }

  // buttons for the days
  for( FXint i = 0; i < 42; i++ ) {
    button_array[i]= new FXButton(matrix,"",NULL,this,ID_DAY,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|LAYOUT_FILL_X|LAYOUT_FILL_Y );
    }
   
  // nav buttons
  FXHorizontalFrame *buttons = new FXHorizontalFrame( this,LAYOUT_SIDE_BOTTOM|FRAME_NONE|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH|PACK_UNIFORM_HEIGHT, 0,0,0,0, 0,0,0,0);
  new FXButton( buttons, "\tPrevious Month\tSelect previous month.",leftArrow1,this,ID_PREVMONTH,FRAME_RAISED|FRAME_THICK|LAYOUT_LEFT|LAYOUT_CENTER_Y );
  new FXButton( buttons, "\tPrevious Year\tSelect previous year.",leftArrow2,this,ID_PREVYEAR,FRAME_RAISED|FRAME_THICK|LAYOUT_LEFT|LAYOUT_CENTER_Y );
  new FXButton( buttons, "\tNext Month\tSelect next month.",rightArrow1,this,ID_NEXTMONTH,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y );
  new FXButton( buttons, "\tNext Year\tSelect next year.",rightArrow2,this,ID_NEXTYEAR,FRAME_RAISED|FRAME_THICK|LAYOUT_RIGHT|LAYOUT_CENTER_Y );

  // make todays date the tool tip
  FXJulianDate now;
  FXString s;
  s.format("Today\t%s %d, %d", now.monthName(now.month()), now.day(), now.year());
  todayButton = new FXButton(buttons,s,NULL,this,ID_TODAY,FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|LAYOUT_FILL_X );
   
  // set us up for today
  setDate( currentDate.year(), currentDate.month(), currentDate.day());
  }

// dtor
FXCalendar::~FXCalendar(){
  FXButton *b;
  for( FXint i = 0; i < 42; i++ ) {
    b=button_array[i];
    delete b;
    }
  delete todayButton;
  delete dateLabel;
  }

// save to stream
void FXCalendar::save(FXStream& store) const {
  FXVerticalFrame::save(store);
  store << hilite_color;
  store << currentDate;
  }

// load from stream
void FXCalendar::load(FXStream& store) {
  FXVerticalFrame::load(store);
  store >> hilite_color;
  store >> currentDate;
  }

// someone pressed the 'today' button
long FXCalendar::onToday(FXObject*,FXSelector,void*) {
  currentDate.today();
  setDate( currentDate.year(), currentDate.month(), currentDate.day());
  // tell the app that the calendar has changed
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// next year button
long FXCalendar::onNextYear(FXObject*,FXSelector,void*) {
  setDate(currentDate.year()+1,currentDate.month(),currentDate.day());
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// previous year button
long FXCalendar::onPrevYear(FXObject*,FXSelector,void*) {
  FXint d = currentDate.day();
  FXint m = currentDate.month();
  FXint y = currentDate.year();
  setDate( y-1, m, d );
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// next month button
long FXCalendar::onNextMonth(FXObject*,FXSelector,void*) {
  FXint d = currentDate.day();
  int m = currentDate.month();
  int y = currentDate.year();
  setDate( y, m+1, d );
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// previous month button
long FXCalendar::onPrevMonth( FXObject *, FXSelector, void * ) {
  FXint d = currentDate.day();
  FXint m = currentDate.month();
  FXint y = currentDate.year();
  setDate( y, m-1, d );
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// day button
long FXCalendar::onCmdDay(FXObject *sender,FXSelector,void*) {
  FXButton *b=(FXButton *)sender;
  if(b) {
    FXint d = FXIntVal(b->getText());
    if(d) setDate(currentDate.year(),currentDate.month(),d);
    }
  getApp()->handle(this,FXSEL(SEL_CHANGED,ID_CALENDAR),(void*)&currentDate);
  return 1;
  }

// return the current date
void FXCalendar::getDate(FXint& y,FXint& m,FXint& d) {
  y = currentDate.year();
  m = currentDate.month();
  d = currentDate.day();
  }

// set to new date - validate the new value
void FXCalendar::setDate(FXint y,FXint m,FXint d) {
  FXint j = 0;
  FXString s;

  // set this date as current
  currentDate.setDate( y, m, d );
  // get the day of the first of the month
  FXJulianDate first( currentDate.year(), currentDate.month(), 1 );
  // set the title string
  s.format("%s %d", first.monthName(first.month()), first.year());
  dateLabel->setText(s);
   
  // filler button(s)
  for( FXint i = 0; i <= first.dayOfWeek(); i++, j++ ) {
    button_array[j]->setText("");
    button_array[j]->disable();
    }

  // real dates
  for( FXint i = 0; i < first.daysInMonth(); i++,j++ ) {
    s.format("%d", i+1 );
    button_array[j]->setText(s);
    button_array[j]->enable( );
    if( i+1 == d ) button_array[j]->setTextColor( hilite_color );
    else button_array[j]->setTextColor( FXRGB( 0, 0, 0 ) );
    }

  // filler buttons
  for( FXint i = first.daysInMonth()+first.dayOfWeek(); i < 41; i++,j++ ) {
    button_array[j]->setText( "" );
    button_array[j]->disable( );
    }

  // Make sure the 'today' top has the correct text
  FXJulianDate now;
  s.format("%s %d, %d", now.monthName(now.month()), now.day(), now.year());
  todayButton->setTipText(s); 
  }

}

