/********************************************************************************
*                                                                               *
*             B a c k  B u f f e r e d  C a n v a s  W i d g e t                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Davy Durham.  With coding tips from Jeroen van der Zijp *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXCanvas.h>
#include <fox/FXImage.h>
#include <fox/FXDC.h>
#include <fox/FXDCWindow.h>
using namespace FX;
#include "FXBackBufferedCanvas.h"
using namespace FXEX;
namespace FXEX {


// Map
FXDEFMAP(FXBackBufferedCanvas) FXBackBufferedCanvasMap[]= {
  FXMAPFUNC(SEL_PAINT,0,FXBackBufferedCanvas::onPaint),
  FXMAPFUNC(SEL_CONFIGURE,0,FXBackBufferedCanvas::onConfigure),
  };
FXIMPLEMENT(FXBackBufferedCanvas,FXCanvas,FXBackBufferedCanvasMap,ARRAYNUMBER(FXBackBufferedCanvasMap))


// serialisation
FXBackBufferedCanvas::FXBackBufferedCanvas() : FXCanvas() {
  backBuffer=new FXImage(getApp(),NULL,0,0,0);
  }


// Construct new back buffered drawing canvas widget
FXBackBufferedCanvas::FXBackBufferedCanvas(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_NORMAL,FXint x=0,FXint y=0,FXint w=0,FXint h=0) : FXCanvas(p,tgt,sel,opts,x,y,w,h) {
  backBuffer=new FXImage(getApp(),NULL,0,w,h);
  currentDC=NULL;
  }

// cleanup
FXBackBufferedCanvas::~FXBackBufferedCanvas() {
  delete backBuffer;
  currentDC=(FXDC*)-1;
  }

// create resources
void FXBackBufferedCanvas::create() {
  FXCanvas::create();
  backBuffer->create();
  }

// save resources
void FXBackBufferedCanvas::save(FXStream& store) const {
  FXCanvas::save(store);
  store << backBuffer;
  }

// load resources
void FXBackBufferedCanvas::load(FXStream& store) {
  FXCanvas::load(store);
  store >> backBuffer;
  }

// NOTE: if IMAGE_OWNED is in the flags, then there is really no need to allocate an FXDCWindow
//       and return it via the ptr parameter in the onPaint even or via the return value of
//       beginPaint()
void FXBackBufferedCanvas::setBackBufferOptions(FXint options) {
  delete backBuffer;
  if(options&IMAGE_OWNED) options|=IMAGE_KEEP;
  backBuffer=new FXImage(getApp(),NULL,options,getWidth(),getHeight());
  backBuffer->create();
  }

// return handle to back-buffer data
void* FXBackBufferedCanvas::getBackBufferData() {
  return backBuffer->getData();
  }

// Handle paint event.  If synthetic event, allow target a chance at drawing into backbuffer
// before blitting it to screen
//
// Note that we dont handle the scenario where someone has called beginPaint(), then this event
// is called - it is a programming error. ie the user is not allowed to call beginPaint and
// endPaint within the onPaint handler...
long FXBackBufferedCanvas::onPaint(FXObject*,FXSelector,void *ptr) {
  if (currentDC) fxerror("%s: multiple trigger of onPoint.\n",getClassName());
  FXEvent *ev=(FXEvent*)ptr;

  // triggered by a call to update()
  if(ev->synthetic && target) {
    FXDCWindow dc(backBuffer);
    currentDC=&dc;
    target->handle(this,FXSEL(SEL_PAINT,message),currentDC);
    currentDC=NULL;
    }

  // now blit the back buffer to the screen
  FXDCWindow screenDC(this); // FIXME: should this be (this,ev) ?
  backBuffer->render();
  screenDC.drawArea(backBuffer,ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h,ev->rect.x,ev->rect.y);
  return 1;
  }

// Resized .. so resize the back buffer and repaint it
long FXBackBufferedCanvas::onConfigure(FXObject *sender,FXSelector sel,void *ptr) {
  backBuffer->resize(getWidth(),getHeight());
  update();
  if(target) target->handle(this,FXSEL(SEL_CONFIGURE,message),ptr);
  return 1;
  }

// return handle to current back buffer, so that you can draw into it
FXDC* FXBackBufferedCanvas::beginPaint() {
  if(currentDC) return currentDC;
  currentDC=new FXDCWindow(backBuffer);
  return currentDC;
  }

// finish drawing to backbuffer - blits buffer to screen
void FXBackBufferedCanvas::endPaint() {
  if(currentDC) {
    delete currentDC;
    currentDC=NULL;
    // I suppose we should just blit the whole thing when they're done painting
    FXDCWindow screenDC(this);
    backBuffer->render();
    screenDC.drawArea(backBuffer,0,0,getWidth(),getHeight(),0,0);
    // tell the event loop that no painting is necessary now for this window???
    // is there a way to do this Jeroen?
    }
  }

}
