/********************************************************************************
*                                                                               *
*                  OpenAL Context - adapter class                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Sander Jansen.   All Rights Reserved.                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#ifdef HAVE_LIBOPENAL
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
using namespace FX;
#include "exincs.h"
#include "FXALDevice.h"
#include "FXALContext.h"
using namespace FXEX;
namespace FXEX {

// Object implementation
FXIMPLEMENT(FXALContext,FXId,NULL,0)

// constructor
FXALContext::FXALContext(FXApp *a,FXALDevice *d,FXint f,FXint r,FXint s) : FXId(a) {
  FXASSERT(d);
  frs[0] = f;
  frs[1] = r;
  frs[2] = s;
  pDevice = d;
  ctx = NULL;
  }

// destroy resources
FXALContext::~FXALContext() {
  destroy();
  }

// create Audio device resources
void FXALContext::create() {
  FXASSERT(((FXALDevice*)pDevice)->dev);
  ALCdevice * dev = (ALCdevice*) pDevice->dev;

  //detach possible context
  detach();

  //if there are attributes, try them...
  if (frs[0] != -1 && frs[1] != -1 && frs[2] != -1) {
    ctx = alcCreateContext(dev,frs);
    if (!ctx) fxmessage("\nFXALContext::create: invalid AL device context %s",alGetString(alcGetError(dev)));
    }

  //no attributes or didn't work, make default context
  if (!ctx) {
    ctx = alcCreateContext(dev,NULL);
    if (!ctx) fxmessage("\nFXALContext::create: invalid AL device context %s",alGetString(alcGetError(dev)));
    }
  }

void FXALContext::destroy() {
  if (ctx) {
    makeNonCurrent(); 
    alcDestroyContext((ALvoid*)ctx);
    }
  }

FXbool FXALContext::makeCurrent() {
  if (!ctx) return false;
  if (!alcMakeContextCurrent((ALvoid*)ctx)) {
    //fxmessage("\nFXALContext::MakeCurrent() : %s",alcGetString(((FXALDevice*)pDevice)->dev,alcGetError( ((FXALDevice*)pDevice)->dev )));
    return false;
    }
  return true;
  }

FXbool FXALContext::makeNonCurrent() {
  alGetError();
  if (!alcMakeContextCurrent(NULL)) {
    // fxmessage("\nFXALContext::MakeNonCurrent() : %s",alGetString( alGetError()));
    return false;
    }
  return true;
  }

void FXALContext::suspend() {
  if (ctx) alcSuspendContext((ALvoid*)ctx);
  }

void FXALContext::process() {
  if (ctx) alcProcessContext((ALvoid*)ctx);
  }

}
#endif

