/********************************************************************************
*                                                                               *
*                  Settings Data Target                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXSETTINGSDATATARGET_H
#define FXSETTINGSDATATARGET_H

#ifndef FXDATATARGET_H
#include <fox/FXDataTarget.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * An extension to FXDataTarget...
 *
 * Using this type of datatarget, we manipulate the values in the FXSettings dict directly,
 * such as directly updating the application registry
 */
class FXAPI FXSettingsDataTarget : public FXDataTarget {
  FXDECLARE(FXSettingsDataTarget)

  protected:
    FXSettings  *settings;  // pointer to real application settings database
    FXString     section;
    FXString     key;

  public:
  long onCmdValue(FXObject*,FXSelector,void*);
  long onCmdOption(FXObject*,FXSelector,void*);

  public:
    /// create unassociated data target 
    FXSettingsDataTarget(FXObject* tgt=NULL,FXSelector sel=0):FXDataTarget(tgt,sel){}

    /// create FXint-associated data target
    FXSettingsDataTarget(FXint& value,FXObject* tgt=NULL,FXSelector sel=0):FXDataTarget(value,tgt,sel){}

    /// create FXuint-associated data target
    FXSettingsDataTarget(FXuint& value,FXObject* tgt=NULL,FXSelector sel=0):FXDataTarget(value,tgt,sel){}

    /// create FXdouble-associated data target
    FXSettingsDataTarget(FXdouble& value,FXObject* tgt=NULL,FXSelector sel=0):FXDataTarget(value,tgt,sel){}

    /// create FXString-associated data target
    FXSettingsDataTarget(FXString& value,FXObject* tgt=NULL,FXSelector sel=0):FXDataTarget(value,tgt,sel){}

    /// associate with FXint
    void connect(FXint& value);

    /// associate with FXuint
    void connect(FXuint& value);

    /// associate with FXdouble
    void connect(FXdouble& value);

    /// associate with FXString
    void connect(FXString& value);

    /// call this immediately after instantiation - otherwise it acts like a normal DataTarget
    void setSettings(FXSettings* settingsDb=NULL,const FXString& sect=NULL,const FXString& ky=NULL);

    /// dtor
    virtual ~FXSettingsDataTarget();
  };

} // namespace FXEX
#endif // FXSETTINGSDATATARGET_H
