/********************************************************************************
*                                                                               *
*                  Pane close widget                                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXPANEHEADER_H
#define FXPANEHEADER_H

#ifndef FXHORIZONTALFRAME_H
#include <fox/FXHorizontalFrame.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * The is a simple header for window frames (like an FXVerticalFrame).
 * As is, it can be used to close a pane, though normally you would specify your parent pane.
 */
class FXAPI FXPaneHeader : public FXHorizontalFrame {
  FXDECLARE(FXPaneHeader)

protected:
  FXLabel   *textLabel;
  FXButton  *closeButton;

protected:
  FXPaneHeader();

private:
  FXPaneHeader(const FXPaneHeader&);
  FXPaneHeader &operator=(const FXPaneHeader&);

public:
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);

public:
  /// Make new pane header
  FXPaneHeader(FXComposite* p,const FXString& lbl,FXIcon* icon=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=LAYOUT_FILL_X|FRAME_RAISED|FRAME_THICK,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=0,FXint pr=0,FXint pt=1,FXint pb=1);

  /// Change item's text label
  void setText(const FXString& lbl);

  /// Return item's text label
  FXString getText() const;

  /// Save to a stream
  virtual void save(FXStream& store) const;

  /// Load from a stream
  virtual void load(FXStream& store);

  /// goodbye
  virtual ~FXPaneHeader();
  };

} // namespace FXEX
#endif // FXPANEHEADER_H
