/********************************************************************************
*                                                                               *
*                  Database instance creator object                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.       All Rights Reserved.            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXDATABASEMANAGER_H
#define FXDATABASEMANAGER_H

namespace FXEX {
class FXDatabaseInterface;

/**
 * This class is a nice and simple class which just supplies the user
 * with a list of the available database source types.  It then allows
 * you to ask it for a handle to an instance which you then set some
 * parameters on, then call create().
 *
 * Note:
 * 1. in the future this may use or inherit-from FXDLL so that we
 *    can dynamically load the various database sources.
 *
 * 2. this is a class rather than a namespace since, it then allows
 *    programmers to make an object out of it...
 */
class FXAPI FXDatabaseManager {
public:
  /// returns a list of available database sources
  static FXStringList getSources();

  /// get a specific database source, by name
  static FXDatabaseInterface* getSource(const FXString& source);

  /// delete a database source,
  static void deleteSource(FXDatabaseInterface **dbi);
  };

} // namespace FXEX
#endif // FXDATABASEMANAGER_H
