/********************************************************************************
*                                                                               *
*                   Atomic data target                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXATOMICDATATARGET_H
#define FXATOMICDATATARGET_H

#ifndef FXDATATARGET_H
#include <fox/FXDataTarget.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * FXAtomicDataTarget is very similar to a normal FXDataTarget. Except that it is
 * wrapped up in an FXAtomic so that multiple threads can access the values in the
 * valuator widgets (just like a normal data target).
 *
 * This allows you to create a worker thread (either by using the FXThreadFunction or
 * FXThread objects) which continually posts updates to widget values, without requiring
 * the programmer to create any glue code.
 */
class FXAPI FXAtomicIntDataTarget : public FXDataTarget {
  FXDECLARE(FXAtomicIntDataTarget)

public:
  enum {
    DT_ATOMIC_INT=FXDataTarget::DT_LAST,
    DT_LAST
    };

public:
  long onCmdValue(FXObject*,FXSelector,void*);
  long onUpdValue(FXObject*,FXSelector,void*);
  long onCmdOption(FXObject*,FXSelector,void*);
  long onUpdOption(FXObject*,FXSelector,void*);

public:
  /// Create an atomic DataTarget
  FXAtomicIntDataTarget(FXObject *tgt=NULL,FXSelector sel=0);

  /// Create an atomic DataTarget, and connect it
  FXAtomicIntDataTarget(FXAtomicInt &a,FXObject *tgt=NULL,FXSelector sel=0);

  /// Associate with / connect to an atomic int
  void connect(FXAtomicInt &a);

  /// dtor
  virtual ~FXAtomicIntDataTarget() {}
  };

} // namespace FXEX
#endif // FXATOMICDATATARGET_H
 
