#include "ThreadedPipe.h"

ThreadedPipe::ThreadedPipe(FXObject * tgt,
						 FXSelector sel,
						 void* arg,
             priority_t pri) :
  FXExThread(worker_task, arg, pri)
{
	event = new FXExThreadEvent(tgt, sel);
	// Create pipe.
	CreatePipe(&hRead,&hWrite,0,0);
}

// worker task, now there better be no REAL reference to anything that belongs to FOX
// (besides the call to the event's signal method)

void* ThreadedPipe::worker_task(void * ptr)
{
	// get a pointer to my own thread object!
	return static_cast<ThreadedPipe *>(FXExThread::self())->work(ptr);
}

void * ThreadedPipe::work(void *) {
	while(true) // never stop
	{
		if (ReadFile(hRead,lpBuffer,sizeof(lpBuffer),
			&nBytesRead,NULL) && nBytesRead) {
			// signale the main-task to call onThreadEvent (see method-map)
			wait();
		}
	};
};

void ThreadedPipe::lock()
{
	sync = false;
}

void ThreadedPipe::unlock()
{
	sync = true;
}

void ThreadedPipe::wait() {
	lock();
	event->signal();
	do {
		sleep(0);
	}	while(!sync);
};

int ThreadedPipe::write(const FXString & buf)
{
	DWORD nBytesWrote;
	WriteFile(hWrite, buf.text(), buf.length(), &nBytesWrote, NULL);
	return nBytesWrote;
}

const FXString & ThreadedPipe::read()
{
	outBuffer.replace(0, outBuffer.length(), lpBuffer, nBytesRead);
	unlock();
	return outBuffer;
}
