/********************************************************************************
*                                                                               *
*              FoxSweeper game button                                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/

/*
I decided to create a custom button specifically to have 'focus follow mouse',
so that the player can easily see what they are about to click on.

Its why I always die, I accidentially clock the wrong button :-)

Since I've created a custom button, I should probably take the button change state
stuff out of the app, and place it in here.  Then I can do something like
'setState(hidden|flagged|questioned|opened)' without having to do the specific
left/right click processing...

Todo:
- still have to create the load/save functions
*/

#include <fox/fx.h>
#include "fsButton.h"

#define BUTTON_MASK (FRAME_RAISED|FRAME_THICK)

FXDEFMAP ( fsButton ) fsButtonMap [] = {
  FXMAPFUNC(SEL_MIDDLEBUTTONPRESS, 0, fsButton::onCmdMiddleClick ),
  FXMAPFUNC(SEL_RIGHTBUTTONPRESS,  0, fsButton::onCmdRightClick  ),
  FXMAPFUNC(SEL_ENTER,             0, fsButton::onEnter          ),
  };
FXIMPLEMENT(fsButton,FXButton,fsButtonMap,ARRAYNUMBER(fsButtonMap))

fsButton::fsButton(FXComposite* p,FXIcon* ico,FXObject* tgt,FXSelector leftSel,FXSelector middleSel,FXSelector rightSel,FXint w,FXint h) : FXButton(p," ",ico,tgt,leftSel,BUTTON_MASK|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,w,h,0,0,0,0){
  middleMessage=middleSel;
  rightMessage=rightSel;
  }

fsButton::~fsButton(){
  rightMessage=0;
  middleMessage=0;
  }

long fsButton::onCmdMiddleClick( FXObject*, FXSelector, void* ptr){
  if (target) target->handle(this,MKUINT(middleMessage,SEL_COMMAND),ptr);
  return 1;
  }

long fsButton::onCmdRightClick( FXObject* o, FXSelector, void* ptr){
  if (target) target->handle(this,MKUINT(rightMessage,SEL_COMMAND),ptr);
  return 1;
  }

long fsButton::onEnter( FXObject* o, FXSelector sel, void* ptr){
  handle(this,MKUINT(0,SEL_FOCUS_SELF),ptr);
  return FXButton::onEnter(o,sel,ptr);
  }
