/********************************************************************************
*                                                                               *
*              FoxSweeper high score dialog                                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <fox/fx.h>
#include "fxex.h"
#include "Icons.h"
#include "GridPointerArray.h"
#include "fsButton.h"
#include "fsGridPointerArray.h"
#include "HighScores.h"
#include "FoxSweeper.h"

FXIMPLEMENT(HighScores,FXDialogBox,NULL,0)

HighScores::HighScores(FXWindow* app) : FXDialogBox(app,"High Scores"){
  FXVerticalFrame *vertical=new FXVerticalFrame(this,LAYOUT_FILL_Y|LAYOUT_FILL_X);

  // show the highscores for each mode
  FXMatrix *matrix = new FXMatrix(vertical,4,MATRIX_BY_ROWS|LAYOUT_FILL_X);
  new FXLabel(matrix,"Beginner:",NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(matrix,"Intermediate:",NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(matrix,"Advanced:",NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(matrix,"Custom:",NULL,LAYOUT_LEFT|LAYOUT_CENTER_Y);
  new FXTextField(matrix,3,app,FoxSweeper::ID_HS_BEGINNER,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);
  new FXTextField(matrix,3,app,FoxSweeper::ID_HS_INTERMEDIATE,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);
  new FXTextField(matrix,3,app,FoxSweeper::ID_HS_ADVANCED,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);
  new FXTextField(matrix,3,app,FoxSweeper::ID_HS_CUSTOM,FRAME_SUNKEN|FRAME_THICK|LAYOUT_RIGHT);

  new FXHorizontalSeparator(vertical,SEPARATOR_RIDGE|LAYOUT_FILL_X);
  new FXButton(vertical,"&Ok",NULL,this,FXDialogBox::ID_ACCEPT,LAYOUT_CENTER_X|FRAME_RAISED|FRAME_THICK,0,0,0,0,20,20);
  }

