<?php
$header_title = 'Scripts by Dieter Egger';
include '../include/begin-head.php';
include '../include/begin-body.php';
?>

<p style="text-align: center"><a href="EggerScripts.php">Deutsche Originalversion</a></p>
<p>
    Here are some examples of REDUCE scripts.  You can either click
    the links below to read the scripts in a web browser or you can
    download them for later input into REDUCE.  Since the scripts
    often use the same variable, it is advisable to restart REDUCE
    before processing a new script.
</p>
<p>
    Solving equations:
    <a href="EggerReduceScripts/algebra.txt">algebra.txt</a>
</p>
<p>
    Analyzing functions:
    <a href="EggerReduceScripts/analyze.red">analyze.red</a>
    <br />
    Decide on the function to be analyzed, for example "f:=x**3 -
    2*x**2;"
</p>
<p>
    Properties:
    <a href="EggerReduceScripts/boolean.txt">boolean.txt</a>
</p>
<p>
    Analysis:
    <a href="EggerReduceScripts/calculus.txt">calculus.txt</a>
</p>
<p>
    <b>Physical constants</b>: establish definitions:
    <a href="EggerReduceScripts/constants.red">constants.red</a>;
    delete definitions:
    <a href="EggerReduceScripts/clear_constants.red">clear_constants.red</a>
</p>
<p>
    Sine, cosine, tangent:
    <a href="EggerReduceScripts/example01.red">example01.red</a>
</p>
<p>
    Binomials, trigonometry, computational accuracy:
    <a href="EggerReduceScripts/example02.red">example02.red</a>
</p>
<p>
    Simple function analysis:
    <a href="EggerReduceScripts/example03.red">example03.red</a>
</p>
<p>
    Simple derivatives:
    <a href="EggerReduceScripts/example04.red">example04.red</a>
</p>
<p>
    Binomials, rules:
    <a href="EggerReduceScripts/example05.red">example05.red</a>
</p>
<p>
    Nested parentheses:
    <a href="EggerReduceScripts/heron.txt">heron.txt</a>
</p>
<p>
    Hypergeometry and MeijerG:
    <a href="EggerReduceScripts/hypermeijerg.txt">hypermeijerg.txt</a>
    <br />
    Without LaTeX formatting OK.
</p>
<p>
    Integration, limits:
    <a href="EggerReduceScripts/integLimit.red">integLimit.red</a>
</p>
<p>
    Integration:
    <a href="EggerReduceScripts/integral.txt">integral.txt</a>
</p>
<p>
    Introduction:
    <a href="EggerReduceScripts/introReduce.txt">introReduce.txt</a>
</p>
<p>
    Linear algebra:
    <a href="EggerReduceScripts/linalg.txt">linalg.txt</a>
</p>
<p>
    Matrix inversion:
    <a href="EggerReduceScripts/mat.red">mat.red</a>
</p>
<p>
    <b>Computation of space-time metrics</b>
    <br />
    Metric-tensor from the equation of the hypersurface of a
    hypersphere, 2-dim:
    <a href="EggerReduceScripts/metric2calc.red">metric2calc.red</a>,
    3-dim:
    <a href="EggerReduceScripts/metric3calc.red">metric3calc.red</a>,
    4-dim:
    <a href="EggerReduceScripts/metric4calc.red">metric4calc.red</a>
    <br />
    Riemann, Ricci, Einstein tensors and solution of the field
    equations, 2-dim:
    <a href="EggerReduceScripts/metric2d.red">metric2d.red</a>,
    3-dim:
    <a href="EggerReduceScripts/metric3d.red">metric3d.red</a>,
    4-dim:
    <a href="EggerReduceScripts/metric4d.red">metric4d.red</a>
</p>
<p>
    Dynamic variable names:
    <a href="EggerReduceScripts/mkid.txt">mkid.txt</a>
</p>
<p>Partial fractions:
    <a href="EggerReduceScripts/partialFraction.txt">partialFraction.txt</a>
</p>
<p>
    Energy of a photon (requires
    <a href="EggerReduceScripts/constants.red">constants.red</a>
    and <a href="EggerReduceScripts/clear_constants.red">clear_constants.red</a>):
    <a href="EggerReduceScripts/photonenergy.txt">photonenergy.txt</a>
</p>
<p>
    Prefix operators:
    <a href="EggerReduceScripts/prefix.txt">prefix.txt</a>
</p>
<p>
    Programming:
    <a href="EggerReduceScripts/programming.txt">programming.txt</a>
</p>
<p>
    Simple rules:
    <a href="EggerReduceScripts/rules.red">rules.red</a>
</p>
<p>
    Definition of a function:
    <a href="EggerReduceScripts/scalprod.red">scalprod.red</a>
</p>
<p>
    Speed of light:
    <a href="EggerReduceScripts/speedoflight.txt">speedoflight.txt</a>
</p>

</div><!-- opened in begin-body.php -->

<?php
include '../include/footer.php';
?>

</body>
</html>
