//
// cmfont-widths.cpp
// Widths for characters in Computer Modern Fonts
//
// extracted from wxfonts/tfm
//
//


// $Id: cmfont-widths.cpp 5331 2020-04-25 13:47:28Z arthurcnorman $


#include <stdint.h>

typedef struct font_width
{   const char *name;
    int32_t checksum;
    int32_t designsize;
    int32_t charwidth[128];
} font_width;

static font_width cm_font_width[] =
{   {   "cmb10", -770990554, 10485760, { // 32202717046 10.0
            629149, 873816, 815562, 734006, 699053, 821387, 757307, 815562,
            757307, 815562, 757307, 611672, 582544, 582544, 873816, 873816,
            291272, 320400, 524290, 524290, 524290, 524290, 524290, 792261,
            466035, 586912, 757307, 815562, 524290, 949547,1066056, 815562,
            291272, 320398, 570893, 873816, 524290, 873816, 815562, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 320398, 815562, 495163, 495163,
            815562, 792261, 745658, 757307, 803912, 687403, 658277, 824301,
            821387, 416520, 541766, 821389, 629149, 996150, 821387, 786435,
            716530, 786435, 796629, 582544, 728181, 806824, 792261,1083533,
            792261, 792261, 640798, 293603, 570893, 293603, 524290, 291272,
            291272, 509726, 582544, 466035, 582544, 489336, 320400, 524290,
            582544, 291272, 320400, 553418, 291272, 873816, 582544, 524290,
            582544, 553416, 448560, 413606, 409237, 582544, 553418, 757307,
            553418, 553418, 466035, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmbsy10", -523662324, 10485760, { // 34062306014 10.0
            937888, 334960, 937888, 602928, 937888, 602928, 937888, 937888,
            937888, 937888, 937888, 937888, 937888,1205856, 602928, 602928,
            937888, 937888, 937888, 937888, 937888, 937888, 937888, 937888,
            937888, 937888, 937888, 937888,1205856,1205856, 937888, 937888,
            1205856,1205856, 602928, 602928,1205856,1205856,1205856, 937888,
            1205856,1205856, 736912, 736912,1205856,1205856,1205856, 937888,
            361174,1205856, 803904, 803904,1071872,1071872,      0,      0,
            669920, 669920, 803904, 602928, 870896, 870896, 937888, 937888,
            736912, 965453, 784171, 642758, 935413, 636424, 853634, 714704,
            1035352, 673595, 817302, 913571, 826477,1444755, 982853, 949539,
            849197, 984782,1037646, 730213, 675432, 749432, 773176,1225371,
            856395, 795459, 858229, 803904, 803904, 803904, 803904, 803904,
            736912, 736912, 535936, 535936, 535936, 535936, 602928, 602928,
            468944, 468944, 334960, 602928, 602928, 736912, 602928, 334960,
            1004880, 943714,1004880, 596378, 803904, 803904, 937888, 937888,
            551957, 535936, 535936, 736912, 937888, 937888, 937888, 937888
        }
    },
    {   "cmbsy6", 565139544, 6291456, { // 4153654130 6.00
            1139835, 432051,1139835, 746621,1139835, 746621,1139835,1139835,
            1139835,1139835,1139835,1139835,1139835,1454405, 746621, 746621,
            1139835,1139835,1139835,1139835,1139835,1139835,1139835,1139835,
            1139835,1139835,1139835,1139835,1454405,1454405,1139835,1139835,
            1454405,1454405, 746621, 746621,1454405,1454405,1454405,1139835,
            1454405,1454405, 903907, 903907,1454405,1454405,1454405,1139835,
            449525,1454405, 982549, 982549,1297120,1297120,      0,      0,
            825264, 825264, 982549, 746621,1061192,1061192,1139835,1139835,
            903907,1175323, 950005, 802763,1143187, 785947,1025291, 874709,
            1274584, 849915, 998280,1105035,1002795,1722277,1184803,1141000,
            1048232,1194888,1275712, 896045, 854077, 908464, 959589,1490427,
            1039701, 960123,1027555, 982549, 982549, 982549, 982549, 982549,
            903907, 903907, 667979, 667979, 667979, 667979, 746621, 746621,
            589336, 589336, 432051, 746621, 746621, 903907, 746621, 432051,
            1199059,1135952,1218477, 716768, 982549, 982549,1139835,1139835,
            681088, 667979, 667979, 903907,1139835,1139835,1139835,1139835
        }
    },
    {   "cmbsy7", -778919009, 7340032, { // 32144521637 7.00
            1059397, 389056,1059397, 686985,1059397, 686985,1059397,1059397,
            1059397,1059397,1059397,1059397,1059397,1357326, 686985, 686985,
            1059397,1059397,1059397,1059397,1059397,1059397,1059397,1059397,
            1059397,1059397,1059397,1059397,1357326,1357326,1059397,1059397,
            1357326,1357326, 686985, 686985,1357326,1357326,1357326,1059397,
            1357326,1357326, 835950, 835950,1357326,1357326,1357326,1059397,
            406530,1357326, 910432, 910432,1208361,1208361,      0,      0,
            761467, 761467, 910432, 686985, 984914, 984914,1059397,1059397,
            835950,1092055, 882459, 737301,1060667, 724226, 955666, 809248,
            1180830, 778626, 925328,1028341, 931509,1617451,1104361,1064306,
            968832,1111534,1182377, 828501, 781961, 844183, 885737,1388491,
            965918, 892999, 958763, 910432, 910432, 910432, 910432, 910432,
            835950, 835950, 612503, 612503, 612503, 612503, 686985, 686985,
            538021, 538021, 389056, 686985, 686985, 835950, 686985, 389056,
            1125557,1058981,1133879, 670654, 910432, 910432,1059397,1059397,
            629771, 612503, 612503, 835950,1059397,1059397,1059397,1059397
        }
    },
    {   "cmbsy8", 2042927564, 8388608, { // 17161114714 8.00
            999068, 356810, 999068, 642258, 999068, 642258, 999068, 999068,
            999068, 999068, 999068, 999068, 999068,1284516, 642258, 642258,
            999068, 999068, 999068, 999068, 999068, 999068, 999068, 999068,
            999068, 999068, 999068, 999068,1284516,1284516, 999068, 999068,
            1284516,1284516, 642258, 642258,1284516,1284516,1284516, 999068,
            1284516,1284516, 784982, 784982,1284516,1284516,1284516, 999068,
            381568,1284516, 856344, 856344,1141792,1141792,      0,      0,
            713620, 713620, 856344, 642258, 927706, 927706, 999068, 999068,
            784982,1029604, 831806, 688208, 998780, 677942, 903454, 760152,
            1110518, 725164, 870618, 970820, 878046,1538832,1044034,1006788,
            909286,1049024,1112376, 777848, 727872, 795976, 830350,1312044,
            910584, 842656, 907172, 856344, 856344, 856344, 856344, 856344,
            784982, 784982, 570896, 570896, 570896, 570896, 642258, 642258,
            499534, 499534, 356810, 642258, 642258, 784982, 642258, 356810,
            1070430,1001250,1070430, 632424, 856344, 856344, 999068, 999068,
            587644, 570896, 570896, 784982, 999068, 999068, 999068, 999068
        }
    },
    {   "cmbsy9", 1730424146, 9437184, { // 14711026522 9.00
            965067, 344667, 965067, 620400, 965067, 620400, 965067, 965067,
            965067, 965067, 965067, 965067, 965067,1240800, 620400, 620400,
            965067, 965067, 965067, 965067, 965067, 965067, 965067, 965067,
            965067, 965067, 965067, 965067,1240800,1240800, 965067, 965067,
            1240800,1240800, 620400, 620400,1240800,1240800,1240800, 965067,
            1240800,1240800, 758267, 758267,1240800,1240800,1240800, 965067,
            375093,1240800, 827200, 827200,1102933,1102933,      0,      0,
            689333, 689333, 827200, 620400, 896133, 896133, 965067, 965067,
            758267, 993952, 805333, 662949, 963563, 654869, 875767, 734896,
            1068745, 696505, 840987, 939004, 849387,1490597,1010034, 974971,
            875892,1013321,1070844, 751374, 698729, 770108, 800196,1265495,
            880469, 816425, 879972, 827200, 827200, 827200, 827200, 827200,
            758267, 758267, 551467, 551467, 551467, 551467, 620400, 620400,
            482533, 482533, 344667, 620400, 620400, 758267, 620400, 344667,
            1034000, 969276,1034000, 615632, 827200, 827200, 965067, 965067,
            567812, 551467, 551467, 758267, 965067, 965067, 965067, 965067
        }
    },
    {   "cmbx10", 452076118, 10485760, { // 3274421126 10.0
            725261,1004880, 937888, 844682, 803904, 943714, 870896, 937888,
            870896, 937888, 870896, 703416, 669920, 669920,1004880,1004880,
            334960, 368456, 602928, 602928, 602928, 602928, 602928, 911674,
            535936, 626230, 870896, 937888, 602928,1092261,1226245, 937888,
            334960, 367000, 632056,1004880, 602928,1004880, 937888, 334960,
            468944, 468944, 602928, 937888, 334960, 401952, 334960, 602928,
            602928, 602928, 602928, 602928, 602928, 602928, 602928, 602928,
            602928, 602928, 334960, 334960, 367000, 937888, 569432, 569432,
            937888, 911674, 857789, 870896, 924781, 792253, 758757, 948083,
            943714, 457294, 623317, 945170, 725261,1144690, 943714, 905848,
            824293, 905848, 904392, 669920, 838856, 927694, 911674,1246634,
            911674, 911674, 736912, 334960, 632056, 334960, 602928, 334960,
            334960, 586179, 669920, 535936, 669920, 552685, 368456, 602928,
            669920, 334960, 368456, 636424, 334960,1004880, 669920, 602928,
            669920, 636424, 496616, 475643, 468944, 669920, 636424, 870896,
            636424, 636424, 535936, 602928,1205856, 602928, 602928, 602928
        }
    },
    {   "cmbx12", -1026142560, 12582912, { // 30265447240 12.0
            708760, 983040, 917504, 825269, 786432, 922360, 851968, 917504,
            851968, 917504, 851968, 688128, 655360, 655360, 983040, 983040,
            327680, 360448, 589824, 589824, 589824, 589824, 589824, 890805,
            524288, 601961, 851968, 917504, 589824,1067995,1199067, 917504,
            327680, 359235, 609243, 983040, 589824, 983040, 917504, 327680,
            458752, 458752, 589824, 917504, 327680, 393216, 327680, 589824,
            589824, 589824, 589824, 589824, 589824, 589824, 589824, 589824,
            589824, 589824, 327680, 327680, 359235, 917504, 557056, 557056,
            917504, 890805, 838619, 851968, 904155, 774296, 741528, 927213,
            922360, 439335, 609243, 923573, 708760,1118968, 922360, 885949,
            805851, 885949, 879883, 655360, 820413, 906583, 890805,1218485,
            890805, 890805, 720896, 327680, 609243, 327680, 589824, 327680,
            327680, 573440, 655360, 524288, 655360, 538245, 360448, 589824,
            655360, 327680, 360448, 622592, 327680, 983040, 655360, 589824,
            655360, 622592, 481812, 465307, 458752, 655360, 622592, 851968,
            622592, 622592, 524288, 589824,1179648, 589824, 589824, 589824
        }
    },
    {   "cmbx5", -1423078296, 5242880, { // 25313306150 5.00
            940787,1301958,1217491,1083507,1048557,1208752,1133024,1217491,
            1133024,1217491,1133024, 956806, 914573, 914573,1371859,1371859,
            457286, 499520, 795155, 795155, 795155, 795155, 795155,1167974,
            710688, 799533,1133024,1217491, 795155,1403901,1572835,1217491,
            457286, 498064, 806810,1301958, 795155,1301958,1217491, 457286,
            626221, 626221, 795155,1217491, 457286, 541754, 457286, 795155,
            795155, 795155, 795155, 795155, 795155, 795155, 795155, 795155,
            795155, 795155, 457286, 457286, 498064,1217491, 752922, 752922,
            1217491,1167974,1108266,1133024,1192733,1025254, 983021,1226230,
            1208752, 576704, 812630,1210208, 940787,1462154,1208752,1176714,
            1066032,1176714,1156326, 879622,1092246,1188365,1167974,1590310,
            1167974,1167974, 964090, 460141, 806810, 460141, 795155, 457286,
            457286, 774038, 879622, 710688, 879622, 725981, 499520, 795155,
            879622, 457286, 499520, 837389, 457286,1301958, 879622, 795155,
            879622, 837389, 652438, 634669, 626221, 879622, 837389,1133024,
            837389, 837389, 710688, 795155,1590310, 795155, 795155, 795155
        }
    },
    {   "cmbx6", -2142912396, 6291456, { // 20021340164 6.00
            865072,1199059,1120416,1000027, 963131,1116533,1041773,1120416,
            1041773,1120416,1041773, 864587, 825264, 825264,1237896,1237896,
            412632, 451955, 727203, 727203, 727203, 727203, 727203,1078669,
            648560, 742256,1041773,1120416, 727203,1296149,1453435,1120416,
            412632, 450496, 744680,1199059, 727203,1199059,1120416, 412632,
            569917, 569917, 727203,1120416, 412632, 491275, 412632, 727203,
            727203, 727203, 727203, 727203, 727203, 727203, 727203, 727203,
            727203, 727203, 412632, 412632, 450496,1120416, 687883, 687883,
            1120416,1078669,1020901,1041773,1099544, 943715, 904395,1129640,
            1116533, 531085, 745651,1117992, 865072,1352461,1116533,1082552,
            981579,1082552,1068960, 805845,1003909,1097603,1078669,1471883,
            1078669,1078669, 884488, 414381, 744680, 414381, 727203, 412632,
            412632, 707541, 805845, 648560, 805845, 664824, 451955, 727203,
            805845, 412632, 451955, 766525, 412632,1199059, 805845, 727203,
            805845, 766523, 598805, 577781, 569917, 805845, 766525,1041773,
            766525, 766525, 648560, 727203,1454405, 727203, 727203, 727203
        }
    },
    {   "cmbx7", 1712792792, 7340032, { // 14605622330 7.00
            810981,1125554,1051072, 940389, 902107,1050656, 976590,1051072,
            976590,1051072, 976590, 798704, 761463, 761463,1142194,1142194,
            380731, 417973, 678661, 678661, 678661, 678661, 678661,1014871,
            604178, 701339, 976590,1051072, 678661,1219177,1368142,1051072,
            380731, 416517, 700297,1125554, 678661,1125554,1051072, 380731,
            529696, 529696, 678661,1051072, 380731, 455214, 380731, 678661,
            678661, 678661, 678661, 678661, 678661, 678661, 678661, 678661,
            678661, 678661, 380731, 380731, 416517,1051072, 641419, 641419,
            1051072,1014871, 958489, 976590,1032971, 885463, 848222,1060642,
            1050656, 502649, 697801,1052112, 810981,1274103,1050656,1015287,
            921248,1015287,1006549, 753143, 940805,1032763,1014871,1387282,
            1014871,1014871, 827625, 381689, 700297, 381689, 678661, 380731,
            380731, 660039, 753143, 604178, 753143, 621136, 417973, 678661,
            753143, 380731, 417973, 715902, 380731,1125554, 753143, 678661,
            753143, 715902, 560489, 537145, 529696, 753143, 715902, 976590,
            715902, 715902, 604178, 678661,1357321, 678661, 678661, 678661
        }
    },
    {   "cmbx8", 851919049, 8388608, { // 6261640311 8.00
            770418,1070430, 999068, 895664, 856344,1001250, 927706, 999068,
            927706, 999068, 927706, 749302, 713620, 713620,1070430,1070430,
            356810, 392492, 642258, 642258, 642258, 642258, 642258, 967026,
            570896, 668834, 927706, 999068, 642258,1161452,1304176, 999068,
            356810, 391034, 667014,1070430, 642258,1070430, 999068, 356810,
            499534, 499534, 642258, 999068, 356810, 428172, 356810, 642258,
            642258, 642258, 642258, 642258, 642258, 642258, 642258, 642258,
            642258, 642258, 356810, 356810, 391034, 999068, 606578, 606578,
            999068, 967026, 911686, 927706, 983048, 841780, 806100,1008898,
            1001250, 481326, 661918,1002708, 770418,1215336,1001250, 964844,
            876004, 964844, 959744, 713620, 893482, 984138, 967026,1323836,
            967026, 967026, 784982, 356810, 667014, 356810, 642258, 356810,
            356810, 624418, 713620, 570896, 713620, 588372, 392492, 642258,
            713620, 356810, 392492, 677940, 356810,1070430, 713620, 642258,
            713620, 677938, 530846, 506670, 499534, 713620, 677940, 927706,
            677940, 677940, 570896, 642258,1284516, 642258, 642258, 642258
        }
    },
    {   "cmbx9", 1946978618, 9437184, { // 16403104472 9.00
            745321,1034000, 965067, 867332, 827200, 969276, 896133, 965067,
            896133, 965067, 896133, 723801, 689333, 689333,1034000,1034000,
            344667, 379134, 620400, 620400, 620400, 620400, 620400, 936265,
            551467, 646782, 896133, 965067, 620400,1122999,1260866, 965067,
            344667, 377678, 647588,1034000, 620400,1034000, 965067, 344667,
            482533, 482533, 620400, 965067, 344667, 413600, 344667, 620400,
            620400, 620400, 620400, 620400, 620400, 620400, 620400, 620400,
            620400, 620400, 344667, 344667, 377678, 965067, 585934, 585934,
            965067, 936265, 881733, 896133, 950667, 814254, 779788, 975100,
            969276, 467973, 640466, 970732, 745321,1176076, 969276, 932055,
            847266, 932055, 929794, 689333, 863122, 952772, 936265,1280932,
            936265, 936265, 758267, 344667, 647588, 344667, 620400, 344667,
            344667, 603166, 689333, 551467, 689333, 569349, 379134, 620400,
            689333, 344667, 379134, 654868, 344667,1034000, 689333, 620400,
            689333, 654866, 511826, 489428, 482533, 689333, 654868, 896133,
            654868, 654868, 551467, 620400,1240800, 620400, 620400, 620400
        }
    },
    {   "cmbxsl10", -1907513578, 10485760, { // 21623323426 10.0
            725261,1004880, 937888, 844682, 803904, 943714, 870896, 937888,
            870896, 937888, 870896, 703416, 669920, 669920,1004880,1004880,
            334960, 368456, 602928, 602928, 602928, 602928, 602928, 969930,
            535936, 626230, 870896, 937888, 602928,1092261,1226245, 937888,
            334960, 367000, 632056,1004880, 602928,1004880, 937888, 334960,
            468944, 468944, 602928, 937888, 334960, 401952, 334960, 602928,
            602928, 602928, 602928, 602928, 602928, 602928, 602928, 602928,
            602928, 602928, 334960, 334960, 367000, 937888, 569432, 569432,
            937888, 911674, 857789, 870896, 924781, 792253, 758757, 948083,
            943714, 457294, 623317, 945170, 725261,1144690, 943714, 905848,
            824293, 905848, 904392, 669920, 838856, 927694, 911674,1246634,
            911674, 911674, 736912, 334960, 632056, 334960, 602928, 334960,
            334960, 586179, 669920, 535936, 669920, 552685, 368456, 602928,
            669920, 334960, 368456, 636424, 334960,1004880, 669920, 602928,
            669920, 636424, 496616, 475643, 468944, 669920, 636424, 870896,
            636424, 636424, 535936, 602928,1205856, 602928, 602928, 602928
        }
    },
    {   "cmbxti10", 1175274390, 10485760, { // 10603241626 10.0
            731666, 990312, 928563, 845843, 805066, 939632, 866814, 928563,
            866814, 928563, 866814, 792256, 707205, 738078,1095466,1110902,
            372824, 403699, 619819, 619819, 619819, 619819, 619819, 994973,
            558070, 697302, 866814, 866814, 619819,1072450,1195947, 928563,
            311075, 404864, 650696, 990312, 910723, 990312, 928563, 372824,
            496322, 496322, 619819, 928563, 372824, 434573, 372824, 619819,
            619819, 619819, 619819, 619819, 619819, 619819, 619819, 619819,
            619819, 619819, 372824, 372824, 404864, 928563, 619819, 619819,
            928563, 907592, 856330, 866814, 918078, 793414, 762541, 938758,
            939632, 494576, 640208, 938467, 731666,1124878, 939632, 896523,
            825454, 896523, 901186, 681568, 834774, 923613, 907592,1216336,
            907592, 907592, 743317, 373408, 650696, 373408, 619819, 372824,
            372824, 619819, 558070, 558070, 619819, 558070, 419432, 558070,
            619819, 372824, 372824, 558070, 311075, 990312, 681568, 619819,
            619819, 558070, 526034, 510595, 403699, 650694, 558070, 805066,
            587782, 588946, 514382, 619819,1239638, 619819, 619819, 619819
        }
    },
    {   "cmcsc10", -1943144428, 10485760, { // 21413374024 10.0
            716520, 946622, 885456, 792250, 763123, 853416, 824290, 885456,
            824290, 885456, 824290, 579624, 579624, 334958, 334958, 549042,
            316902, 445061, 579624, 579624, 579624, 579624, 579624, 853416,
            518458, 960026, 771283, 864490, 666426,1022352,1144685, 885456,
            334958, 334958, 579624, 946622, 579624, 946622, 885456, 334958,
            457291, 457291, 579624, 885456, 334958, 396125, 334958, 579624,
            579624, 579624, 579624, 579624, 579624, 579624, 579624, 579624,
            579624, 579624, 334958, 334958, 885456, 885456, 885456, 549042,
            885456, 853416, 808270, 824290, 869437, 777686, 747104, 892738,
            853416, 425251, 594187, 884000, 716520,1036915, 853416, 885456,
            777686, 885456, 838853, 640790, 824290, 853416, 853416,1159248,
            853416, 853416, 701957, 334958, 579624, 334958, 579624, 334958,
            334958, 643125, 608173, 619822, 654776, 584870, 561570, 672251,
            643125, 316902, 445061, 666427, 538267, 782934, 643125, 666426,
            584870, 666426, 631474, 480013, 619822, 643125, 643125, 876141,
            643125, 643125, 526616, 579624,1159248, 579624, 579624, 579624
        }
    },
    {   "cmcsc8", -1587116571, 8388608, { // 24131502745 8.00
            754028,1001244, 935708, 834492, 804636, 900028, 870172, 935708,
            870172, 935708, 870172, 608028, 608028, 345884, 345884, 575260,
            332780, 464946, 608028, 608028, 608028, 608028, 608028, 900028,
            542492,1004896, 796270, 890934, 691776,1081708,1212780, 935708,
            345884, 345884, 608028,1001244, 608028,1001244, 935708, 345884,
            476956, 476956, 608028, 935708, 345884, 411420, 345884, 608028,
            608028, 608028, 608028, 608028, 608028, 608028, 608028, 608028,
            608028, 608028, 345884, 345884, 935708, 935708, 935708, 575260,
            935708, 900028, 852332, 870172, 917868, 819564, 786796, 943172,
            900028, 441276, 622956, 932796, 754028,1096636, 900028, 935708,
            819564, 935708, 885100, 673564, 870172, 900028, 900028,1227708,
            900028, 900028, 739100, 345884, 608028, 345884, 608028, 345884,
            345884, 664104, 630608, 644444, 677940, 606942, 583276, 696692,
            664104, 332780, 464946, 687770, 559610, 806100, 664104, 691776,
            606942, 691776, 654274, 502448, 644444, 664104, 664104, 900764,
            664104, 664104, 549780, 608028,1216056, 608028, 608028, 608028
        }
    },
    {   "cmcsc9", -804709715, 9437184, { // 32002215255 9.00
            713931, 945003, 883513, 790308, 760533, 851797, 822023, 883513,
            822023, 883513, 822023, 576064, 576064, 330105, 330105, 545319,
            326222, 455996, 576064, 576064, 576064, 576064, 576064, 851797,
            514574, 983836, 784480, 878332, 679623,1021380,1144359, 883513,
            330105, 330105, 576064, 945003, 576064, 945003, 883513, 330105,
            453084, 453084, 576064, 883513, 330105, 391595, 330105, 576064,
            576064, 576064, 576064, 576064, 576064, 576064, 576064, 576064,
            576064, 576064, 330105, 330105, 883513, 883513, 883513, 545319,
            883513, 851797, 806165, 822023, 867655, 775420, 744676, 890956,
            851797, 421369, 590951, 882542, 713931,1036267, 851797, 883513,
            775420, 883513, 836910, 637554, 822023, 851797, 851797,1159246,
            851797, 851797, 699044, 330105, 576064, 330105, 576064, 330105,
            330105, 654706, 620238, 632697, 667164, 596775, 573312, 685125,
            654706, 326222, 455996, 678169, 549849, 795484, 654706, 679623,
            596775, 679623, 643701, 491918, 632697, 654706, 654706, 889337,
            654706, 654706, 538844, 576064,1152128, 576064, 576064, 576064
        }
    },
    {   "cmdunh10", 1274110073, 10485760, { // 11374260171 10.0
            655362, 873816, 815562, 728179, 699053, 786434, 757307, 815562,
            757307, 815562, 757307, 611672, 582544, 582544, 873816, 873816,
            291272, 320400, 524290, 524290, 524290, 524290, 524290, 786434,
            466035, 524291, 757307, 815562, 524290, 946634,1063142, 815562,
            291272, 291272, 524290, 873816, 524290, 873816, 815562, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 291272, 815562, 495163, 495163,
            815562, 786434, 742744, 757307, 800998, 713616, 684490, 822843,
            786434, 378653, 538853, 815562, 655362, 961197, 786434, 815562,
            713616, 815562, 771870, 582544, 757307, 786434, 786434,1077706,
            786434, 786434, 640798, 291272, 524290, 291272, 524290, 291272,
            291272, 524290, 582544, 466035, 582544, 466035, 320400, 524290,
            582544, 291272, 320400, 553418, 291272, 873816, 582544, 524290,
            582544, 553416, 410694, 413606, 407781, 582544, 553418, 757307,
            553418, 553418, 466035, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmex10", -89033454, 10485760, { // 37254272422 10.0
            480600, 480600, 436909, 436909, 495163, 495163, 495163, 495163,
            611672, 611672, 495163, 495163, 349526, 582544, 605845, 605845,
            626235, 626235, 771872, 771872, 553418, 553418, 611672, 611672,
            611672, 611672, 786434, 786434, 786434, 786434,1095182,1095182,
            830126, 830126, 611672, 611672, 669926, 669926, 669926, 669926,
            844691, 844691, 844691, 844691,1339851,1339851, 850515, 850515,
            917507, 917507, 699053, 699053, 699053, 699053, 699053, 699053,
            932070, 932070, 932070, 932070, 932070, 932070, 932070, 699053,
            917507, 917507, 917507, 917507, 640798, 640798, 873816,1165088,
            495162, 582544,1165088,1584520,1165088,1584520,1165088,1584520,
            1106834, 990325, 495162, 873816, 873816, 873816, 873816, 873816,
            1514614,1339851, 582544,1165088,1165088,1165088,1165088,1165088,
            990325,1339851, 582544,1048579,1514614, 582544,1048579,1514614,
            495163, 495163, 553418, 553418, 553418, 553418, 699053, 699053,
            1048579,1048579,1048579,1048579,1106834,1106834,1106834, 815562,
            699053, 699053, 471864, 471864, 471864, 471864, 815562, 815562
        }
    },
    {   "cmex7", 388214957, 7340032, { // 2710730255 7.00
            565383, 565383, 517010, 517010, 581506, 581506, 581506, 581506,
            710498, 710498, 581506, 581506, 420265, 678249, 670759, 670759,
            726622, 726622, 887863, 887863, 646002, 646002, 710498, 710498,
            710498, 710498, 903984, 903984, 903984, 903984,1212526,1212526,
            952359, 952359, 710498, 710498, 774994, 774994, 774994, 774994,
            968485, 968485, 968485, 968485,1483408,1483408, 941641, 941641,
            1049102,1049102, 807241, 807241, 807241, 807241, 807241, 807241,
            1065225,1065225,1065225,1065225,1065225,1065225,1065225, 807241,
            1049102,1049102,1049102,1049102, 742745, 742745,1000729,1323209,
            581504, 678249,1323209,1787579,1323209,1787579,1323209,1787579,
            1258713,1129721, 581504,1000729,1000729,1000729,1000729,1000729,
            1710185,1516697, 678249,1323209,1323209,1323209,1323209,1323209,
            1129721,1516697, 678249,1194217,1710185, 678249,1194217,1710185,
            581506, 581506, 646002, 646002, 646002, 646002, 807241, 807241,
            1177573,1177573,1177573,1177573,1242069,1242069,1242069, 936233,
            807241, 807241, 505154, 505154, 505154, 505154, 936233, 936233
        }
    },
    {   "cmex8", 16867638, 8388608, { // 100260466 8.00
            510642, 510642, 464220, 464220, 526116, 526116, 526116, 526116,
            649908, 649908, 526116, 526116, 371376, 618960, 643718, 643718,
            665382, 665382, 820122, 820122, 588012, 588012, 649908, 649908,
            649908, 649908, 835596, 835596, 835596, 835596,1163644,1163644,
            882018, 882018, 649908, 649908, 711804, 711804, 711804, 711804,
            897492, 897492, 897492, 897492,1423608,1423608, 903682, 903682,
            974862, 974862, 742752, 742752, 742752, 742752, 742752, 742752,
            990336, 990336, 990336, 990336, 990336, 990336, 990336, 742752,
            974862, 974862, 974862, 974862, 680856, 680856, 928440,1237920,
            526116, 618960,1237920,1683572,1237920,1683572,1237920,1683572,
            1176024,1052232, 526116, 928440, 928440, 928440, 928440, 928440,
            1609296,1423608, 618960,1237920,1237920,1237920,1237920,1237920,
            1052232,1423608, 618960,1114128,1609296, 618960,1114128,1609296,
            526116, 526116, 588012, 588012, 588012, 588012, 742752, 742752,
            1114128,1114128,1114128,1114128,1176024,1176024,1176024, 866544,
            742752, 742752, 471864, 471864, 471864, 471864, 866544, 866544
        }
    },
    {   "cmex9", 2059457385, 9437184, { // 17260151551 9.00
            493943, 493943, 449040, 449040, 508912, 508912, 508912, 508912,
            628658, 628658, 508914, 508914, 359232, 598720, 622668, 622668,
            643623, 643623, 793303, 793303, 568784, 568784, 628656, 628656,
            628656, 628656, 808274, 808274, 808274, 808274,1125595,1125595,
            853175, 853175, 628656, 628656, 688528, 688528, 688528, 688528,
            868144, 868144, 868144, 868144,1377056,1377056, 874132, 874132,
            942983, 942983, 718464, 718464, 718464, 718464, 718464, 718464,
            957952, 957952, 957952, 957952, 957952, 957952, 957952, 718464,
            942983, 942983, 942983, 942983, 658592, 658592, 898080,1197440,
            508912, 598720,1197440,1628517,1197440,1628517,1197440,1628517,
            1137568,1017824, 508912, 898080, 898080, 898080, 898080, 898080,
            1556672,1377056, 598720,1197440,1197440,1197440,1197440,1197440,
            1017824,1377056, 598720,1077696,1556672, 598720,1077696,1556672,
            508912, 508912, 568784, 568784, 568784, 568784, 718464, 718464,
            1077696,1077696,1077696,1077696,1137568,1137568,1137568, 838208,
            718464, 718464, 471865, 471865, 471865, 471865, 838208, 838208
        }
    },
    {   "cmff10", -1927996437, 10485760, { // 21505215753 10.0
            559238, 710699, 664096, 547587, 570890, 547587, 617493, 664096,
            617493, 664096, 617493, 512637, 480597, 480597, 725264, 725264,
            227192, 250494, 431080, 431080, 431080, 431080, 431080, 582539,
            384477, 422344, 617493, 664096, 431080, 745651, 838858, 664096,
            227192, 198064, 431080, 710699, 431080, 710699, 655358, 244667,
            337874, 337874, 431080, 664096, 244667, 291270, 244667, 431080,
            431080, 431080, 431080, 431080, 431080, 431080, 431080, 431080,
            431080, 431080, 244667, 244667, 198064, 664096, 407779, 407779,
            664096, 594190, 582541, 617493, 629144, 605842, 582541, 658270,
            547587, 267968, 419429, 617493, 559238, 687397, 547587, 710699,
            559238, 710699, 605842, 477683, 664096, 570888, 594190, 827206,
            594190, 594190, 524286, 247581, 431080, 247581, 431080, 244667,
            244667, 422342, 460208, 384477, 460208, 384477, 267970, 431080,
            460208, 227192, 250494, 436907, 227192, 693224, 460208, 431080,
            460208, 436906, 329136, 342534, 337874, 460208, 436907, 600018,
            436907, 436907, 380107, 431080, 862160, 431080, 431080, 431080
        }
    },
    {   "cmfi10", 319521934, 10485760, { // 2302702216 10.0
            719434, 929147, 867981, 722346, 745648, 736909, 806814, 867981,
            806814, 867981, 806814, 634968, 573802, 604384, 906576, 921867,
            317483, 348067, 562149, 562149, 562149, 562149, 562149, 795163,
            500982, 592734, 806814, 806814, 562149, 978662,1100995, 867981,
            256317, 270880, 562149, 929147, 763126, 929147, 867981, 317483,
            439816, 439816, 562149, 867981, 317483, 378650, 317483, 562149,
            562149, 562149, 562149, 562149, 562149, 562149, 562149, 562149,
            562149, 562149, 317483, 317483, 270880, 867981, 562149, 562149,
            867981, 783512, 764581, 806814, 825747, 780600, 750018, 862155,
            736909, 355347, 550498, 814096, 719434, 920408, 736909, 914584,
            733997, 914584, 795163, 623315, 853418, 760210, 783512,1089344,
            783512, 783512, 684482, 317483, 562149, 317483, 562149, 317483,
            317483, 562149, 500982, 500982, 562149, 500982, 317485, 500982,
            562149, 317483, 317483, 500982, 256317, 929147, 623315, 562149,
            562149, 500982, 455109, 439816, 348067, 592733, 500982, 745648,
            500984, 531566, 439818, 562149,1124298, 562149, 562149, 562149
        }
    },
    {   "cmfib8", -844143043, 8388608, { // 31553663075 8.00
            841038,1146870,1070412, 917496, 917496, 993954, 993954,1070412,
            993954,1070412, 993954, 802810, 757298, 757298,1139588,1139588,
            367726, 405956, 688122, 688122, 688122, 688122, 688122, 993954,
            611664, 680842, 993954,1070412, 688122,1223328,1376244,1070412,
            367726, 382290, 688122,1146870, 688122,1146870,1063130, 382290,
            535206, 535206, 688122,1070412, 382290, 458748, 382290, 688122,
            688122, 688122, 688122, 688122, 688122, 688122, 688122, 688122,
            688122, 688122, 382290, 382290, 382290,1070412, 649894, 649894,
            1070412, 993954, 955726, 993954,1032184, 917496, 879268,1070412,
            993954, 458748, 688122,1032184, 841038,1223328, 993954,1070412,
            917496,1070412, 993954, 764580, 993954, 993954, 993954,1376244,
            993954, 993954, 841038, 382292, 688122, 382292, 688122, 382290,
            382290, 661726, 750016, 611664, 750016, 625318, 420520, 688122,
            750016, 367726, 405956, 711788, 367726,1132306, 750016, 688122,
            750016, 711786, 537028, 542852, 535206, 750016, 711788, 979390,
            711788, 711788, 608022, 688122,1376244, 688122, 688122, 688122
        }
    },
    {   "cminch", -566337077, 109124000, { // 33617460713 104.
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            576717, 576717, 576717, 576717, 576717, 576717, 576717, 576717,
            576717, 576717,      0,      0,      0,      0,      0,      0,
            0, 768955, 768956, 736916, 833035, 672836, 640796, 768956,
            833035, 346613, 544677, 800995, 608756,1025274, 833035, 833035,
            736916, 833035, 736916, 640796, 768956, 800995, 768955,1089354,
            768955, 768955, 704876,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "cmitt10", -538297224, 10485760, { // 33772436170 10.0
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498
        }
    },
    {   "cmmi10", -1725937524, 10485760, { // 23110044214 10.0
            645166, 873816, 799829, 728179, 778424, 871630, 817746, 611669,
            699051, 641962, 809918, 670776, 593102, 542880, 466034, 425621,
            458754, 520651, 492248, 371130, 604147, 611672, 631819, 517979,
            458754, 597717, 542130, 599171, 458390, 566525, 624778, 656086,
            683034, 652691, 488970, 620170, 868357, 542130, 380474, 685944,
            1048579,1048579,1048579,1048579, 291272, 291272, 524290, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 815562, 524290, 815562, 524290,
            556693, 786434, 795355, 749440, 868134, 774054, 674294, 824442,
            871630, 460938, 581450, 890563, 713616,1017266, 842502, 799829,
            673200, 828957, 796173, 642982, 612763, 715944, 611670, 990323,
            868718, 608758, 715800, 407781, 407781, 407781,1048579,1048579,
            436910, 554267, 450014, 453778, 545771, 488245, 513368, 500138,
            604147, 361248, 431811, 545893, 312874, 920664, 629392, 508269,
            527566, 468099, 473075, 491520, 378654, 600266, 508270, 750694,
            599291, 514098, 487640, 338120, 402685, 667376, 524290, 291272
        }
    },
    {   "cmmi12", -871742625, 12582912, { // 31402441537 12.0
            636120, 855600, 784652, 712637, 764064, 850688, 802991, 598920,
            684480, 627085, 794435, 653047, 579624, 532560, 454741, 414572,
            448432, 506564, 478468, 362872, 591032, 598920, 617732, 507293,
            448432, 582416, 529563, 583568, 445883, 553409, 607657, 643219,
            667489, 639333, 480472, 605109, 848199, 529563, 371365, 672585,
            1026720,1026720,1026720,1026720, 285200, 285200, 513360, 513360,
            513360, 513360, 513360, 513360, 513360, 513360, 513360, 513360,
            513360, 513360, 285200, 285200, 798560, 513360, 798560, 513360,
            542001, 769677, 779993, 734567, 852471, 760029, 664640, 809872,
            850688, 452833, 567491, 873504, 698559, 993288, 822168, 784652,
            661788, 813172, 781496, 631447, 601772, 697309, 598557, 969317,
            852113, 595705, 702747, 399280, 399280, 399280,1026720,1026720,
            430836, 538967, 436537, 441877, 533507, 475860, 506080, 491636,
            591032, 350260, 424768, 533992, 305832, 898076, 612876, 493577,
            515303, 455228, 462692, 483628, 370760, 584356, 496369, 733935,
            583448, 500617, 476952, 327676, 396248, 653655, 513360, 285200
        }
    },
    {   "cmmi5", 1799862295, 5242880, { // 15321734027 5.00
            873094,1208794,1098397,1013638,1067158,1164371,1117040, 881107,
            990336, 936886,1112125, 957686, 829040, 783187, 685949, 643350,
            699059, 779891, 709978, 576480, 867757, 881107, 891059, 746634,
            699059, 871520, 761318, 854768, 714717, 830134, 882560, 906592,
            975773, 929411, 707430, 896886,1200419, 761318, 606214, 962662,
            1427251,1427251,1427251,1427251, 480602, 480602, 771878, 771878,
            771878, 771878, 771878, 771878, 771878, 771878, 771878, 771878,
            771878, 771878, 480602, 480602,1135974, 771878,1135974, 771878,
            785344,1086458,1087366,1044368,1163789,1055872, 909504,1115728,
            1164371, 657187, 810470,1194230,1001987,1346419,1127962,1098397,
            917878,1134806,1079994, 897856, 872733, 989750, 868000,1341325,
            1166922, 864358, 988880, 626240, 626240, 626240,1427251,1427251,
            626237, 812048, 664102, 680973, 775638, 709904, 717261, 734618,
            867757, 559491, 616771, 794938, 503661,1287683, 923587, 736922,
            775642, 690925, 703914, 702698, 591046, 887178, 757315,1057997,
            830131, 766054, 722118, 559491, 580362, 932445, 771878, 480602
        }
    },
    {   "cmmi6", -214548420, 6291456, { // 36315440074 6.00
            778661,1077696, 979440, 900992, 951483,1048085, 997843, 771864,
            873808, 819144, 991955, 843592, 731941, 683656, 593707, 548680,
            599531, 675259, 618955, 489093, 760944, 771864, 786432, 651715,
            599531, 762032, 670048, 751355, 610331, 723320, 778179, 804632,
            859245, 817739, 615184, 787157,1071507, 670048, 511541, 850992,
            1281584,1281584,1281584,1281584, 398069, 398069, 669920, 669920,
            669920, 669920, 669920, 669920, 669920, 669920, 669920, 669920,
            669920, 669920, 398069, 398069,1009733, 669920,1009733, 669920,
            690677, 968955, 971565, 926624,1046773, 943472, 812643, 999200,
            1048085, 574288, 714707,1075512, 887400,1217992,1014104, 979440,
            817861,1013421, 966923, 793469, 766645, 878808, 765069,1206827,
            1050027, 761669, 878421, 533995, 533995, 533995,1281584,1281584,
            543707, 707667, 574291, 586304, 673685, 617616, 629872, 637269,
            760944, 467248, 536424, 692981, 421131,1146875, 807061, 642253,
            673685, 598437, 608027, 612883, 500013, 773080, 655357, 936613,
            731816, 663851, 625019, 467248, 502443, 825387, 669920, 398069
        }
    },
    {   "cmmi7", 675789302, 7340032, { // 5021734766 7.00
            727454,1000729, 911138, 836370, 885520, 981070, 929367, 710494,
            807239, 751710, 922789, 778757, 679239, 629225, 544471, 499273,
            545095, 617189, 570578, 443326, 701310, 710498, 728359, 600578,
            545095, 700496, 621504, 694149, 552430, 663687, 720274, 748466,
            792679, 754640, 565952, 723365, 996103, 621504, 460574, 787893,
            1194217,1194217,1194217,1194217, 355769, 355769, 613753, 613753,
            613753, 613753, 613753, 613753, 613753, 613753, 613753, 613753,
            613753, 613753, 355769, 355769, 936233, 613753, 936233, 613753,
            639705, 900866, 905106, 859191, 979445, 879435, 759703, 932631,
            981070, 530898, 662747,1006558, 821806,1142309, 948821, 911138,
            762665, 943387, 902414, 735568, 707531, 816021, 707378,1126601,
            982370, 704155, 816187, 484761, 484761, 484761,1194217,1194217,
            501408, 649765, 526786, 535335, 623584, 568347, 584110, 584402,
            701310, 423819, 495687, 636814, 378827,1062974, 740494, 591282,
            617515, 549033, 556194, 565381, 452514, 708247, 599191, 866581,
            679289, 607515, 572320, 418014, 463440, 765579, 613753, 355769
        }
    },
    {   "cmmi8", -1852389792, 8388608, { // 22145543140 8.00
            674118, 928440, 845352, 772608, 821486, 915240, 863448, 649908,
            742752, 686572, 856348, 715566, 625148, 573836, 492984, 450384,
            489708, 559066, 519742, 394434, 642018, 649908, 670234, 547658,
            489708, 639774, 570534, 636680, 494440, 604396, 662288, 691776,
            728188, 692750, 514464, 662772, 924980, 570534, 407786, 726004,
            1114128,1114128,1114128,1114128, 309480, 309480, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 309480, 309480, 866544, 557064, 866544, 557064,
            586918, 834504, 840328, 794052, 914020, 816480, 705066, 868144,
            915240, 483062, 608582, 939544, 757680,1069980, 884292, 845352,
            706340, 876300, 839098, 677578, 648634, 753728, 648816,1051140,
            916334, 645722, 754948, 433272, 433272, 433272,1114128,1114128,
            455116, 591774, 476600, 482546, 573264, 516832, 535216, 530182,
            642018, 379316, 450564, 580122, 332538, 985480, 676000, 538496,
            560826, 497414, 502752, 515192, 402324, 645052, 542500, 799490,
            627150, 550692, 518226, 366520, 419616, 706160, 557064, 309480
        }
    },
    {   "cmmi9", 227285477, 9437184, { // 1543014745 9.00
            658188, 898080, 820052, 748238, 797552, 891447, 838048, 628656,
            718464, 661776, 830542, 690672, 607339, 556631, 478005, 436620,
            472503, 538121, 504464, 381483, 620971, 628656, 649289, 531566,
            472503, 616802, 555154, 616236, 474404, 583348, 641440, 671943,
            703092, 670485, 500295, 639095, 893913, 555154, 392606, 703739,
            1077696,1077696,1077696,1077696, 299360, 299360, 538848, 538848,
            538848, 538848, 538848, 538848, 538848, 538848, 538848, 538848,
            538848, 538848, 299360, 299360, 838208, 538848, 838208, 538848,
            570119, 808110, 815493, 769259, 888679, 793063, 688124, 843856,
            891447, 471088, 593787, 912645, 733351,1041127, 861511, 820052,
            688084, 849988, 815403, 658350, 628697, 733012, 628496,1017664,
            890192, 625500, 733191, 419104, 419104, 419104,1077696,1077696,
            444996, 570928, 461824, 466556, 558388, 501024, 523072, 513886,
            620971, 368772, 440546, 561099, 321611, 949458, 650098, 521696,
            540994, 481524, 486260, 502037, 389168, 620162, 523476, 772370,
            610859, 530757, 501227, 350738, 410610, 685010, 538848, 299360
        }
    },
    {   "cmmib10", 987124668, 10485760, { // 7265451674 10.0
            688853,1004880, 909344, 844682, 882110,1030003, 928059, 703416,
            803904, 748706, 921597, 797594, 691766, 618691, 547586, 506810,
            533024, 629144, 589093, 432051, 700019, 703416, 742254, 604870,
            533024, 715554, 641523, 719194, 546131, 661182, 747106, 752934,
            795166, 752688, 554506, 725141,1022358, 641523, 444186, 783514,
            1205856,1205856,1205856,1205856, 334960, 334960, 602928, 602928,
            602928, 602928, 602928, 602928, 602928, 602928, 602928, 602928,
            602928, 602928, 334960, 334960, 937888, 602928, 937888, 602928,
            658997, 911674, 908490, 856624, 983691, 849416, 722349, 929806,
            1030003, 535938, 661912,1018352, 792253,1197483, 996507, 877304,
            758213, 910800, 914725, 726355, 667552, 839149, 710699,1146147,
            993230, 707347, 810094, 468944, 468944, 468944,1205856,1205856,
            496618, 663610, 546130, 538363, 639338, 580501, 595651, 571373,
            700019, 424459, 493704, 633027, 365059,1082554, 747594, 613122,
            630114, 568461, 554386, 557056, 435448, 714098, 594190, 871869,
            691040, 618949, 582056, 412634, 460208, 776234, 602928, 334960
        }
    },
    {   "cmmib6", -1525994067, 6291456, { // 24502626655 6.00
            810219,1218477,1093808,1019445,1058717,1215445,1112531, 864581,
            982547, 930264,1108979, 978672, 832067, 756557, 669437, 627203,
            670891, 786917, 709488, 547592, 862163, 864587, 900029, 732544,
            670891, 884976, 761917, 868715, 702445, 823325, 899541, 910221,
            980611, 922109, 676109, 899667,1238384, 761917, 570400, 950512,
            1454405,1454405,1454405,1454405, 432051, 432051, 746621, 746621,
            746621, 746621, 746621, 746621, 746621, 746621, 746621, 746621,
            746621, 746621, 432051, 432051,1139835, 746621,1139835, 746621,
            788131,1098088,1088107,1038179,1166219,1014472, 849541,1108448,
            1215445, 627691, 790677,1207680, 963133,1412051,1176123,1055944,
            899963,1095267,1085952, 875875, 814160,1006141, 862160,1373336,
            1178189, 858229, 974176, 589336, 589336, 589336,1454405,1454405,
            590797, 821387, 663613, 666040, 782064, 708080, 697597, 703416,
            862163, 546624, 586427, 783520, 468947,1333051, 939837, 742256,
            782064, 691768, 688373, 669680, 568709, 900517, 744683,1068963,
            826968, 770899, 717987, 546624, 547107, 933035, 746621, 432051
        }
    },
    {   "cmmib7", 1940741258, 7340032, { // 16353256212 7.00
            758553,1133879,1019616, 948713, 987328,1139653,1038331, 798709,
            910432, 857106,1033742, 906203, 774162, 699003, 618121, 574224,
            613335, 723810, 659211, 498007, 795936, 798709, 836923, 680190,
            613335, 817712, 712683, 809079, 638302, 757099, 837824, 845733,
            906064, 853287, 624363, 829017,1154478, 712683, 517008, 882553,
            1357326,1357326,1357326,1357326, 389056, 389056, 686985, 686985,
            686985, 686985, 686985, 686985, 686985, 686985, 686985, 686985,
            686985, 686985, 389056, 389056,1059397, 686985,1059397, 686985,
            734734,1023195,1015641, 965024,1092715, 947205, 795794,1036334,
            1139653, 587431, 735513,1131746, 893787,1325858,1102411, 983831,
            841022,1021072,1016206, 814158, 753481, 936937, 799751,1283886,
            1103815, 796025, 907259, 538021, 538021, 538021,1357326,1357326,
            551961, 757239, 614377, 612642, 719998, 655031, 662231, 648981,
            795936, 490448, 546553, 721454, 423525,1235271, 862859, 688859,
            719998, 641493, 635321, 624261, 511842, 825618, 682617, 990256,
            773225, 709872, 664240, 490448, 509312, 870279, 686985, 389056
        }
    },
    {   "cmmib8", -1661369540, 8388608, { // 23476301474 8.00
            719808,1070430, 963966, 895664, 933786,1082442, 982684, 749298,
            856342, 802240, 977314, 851854, 730732, 655834, 579632, 537034,
            570168, 674666, 621502, 460820, 746268, 749302, 787774, 639102,
            570168, 765444, 673932, 762528, 590194, 707432, 791534, 797358,
            850156, 801668, 585548, 776036,1089728, 673932, 476960, 831584,
            1284516,1284516,1284516,1284516, 356810, 356810, 642258, 642258,
            642258, 642258, 642258, 642258, 642258, 642258, 642258, 642258,
            642258, 642258, 356810, 356810, 999068, 642258, 999068, 642258,
            694684, 967026, 961294, 910156,1037586, 896758, 755490, 982244,
            1082442, 558696, 693774,1074798, 841780,1260846,1046760, 929742,
            796812, 965424, 965434, 767870, 707976, 884668, 752940,1216792,
            1048036, 749372, 857072, 499534, 499534, 499534,1284516,1284516,
            519194, 709130, 577448, 572594, 673448, 614876, 632056, 606332,
            746268, 450988, 514824, 674906, 389456,1161942, 805132, 648810,
            673450, 601964, 595532, 590188, 469196, 769452, 636070, 931228,
            732914, 662286, 620292, 448322, 479144, 821390, 642258, 356810
        }
    },
    {   "cmmib9", -1141540475, 9437184, { // 27375274605 9.00
            702601,1034000, 933607, 867332, 905067,1054110, 952324, 723797,
            827198, 772487, 946348, 822510, 709888, 635191, 562633, 521049,
            549524, 649367, 605113, 444832, 720565, 723801, 762476, 620078,
            549524, 737719, 656731, 739257, 565707, 681730, 768464, 772670,
            819596, 774448, 568295, 747751,1052288, 656731, 458745, 804869,
            1240800,1240800,1240800,1240800, 344667, 344667, 620400, 620400,
            620400, 620400, 620400, 620400, 620400, 620400, 620400, 620400,
            620400, 620400, 344667, 344667, 965067, 620400, 965067, 620400,
            676473, 936265, 931948, 880404,1007634, 870444, 737068, 953099,
            1054110, 546050, 676672,1043429, 814254,1226443,1019643, 900596,
            775360, 935063, 938871, 744796, 685506, 860180, 729465,1177531,
            1017579, 726020, 830964, 482533, 482533, 482533,1240800,1240800,
            506647, 684644, 561664, 554380, 654060, 596583, 615067, 586094,
            720565, 437228, 503086, 651632, 375897,1117822, 773156, 630597,
            650176, 584156, 574286, 573396, 448958, 738690, 612796, 898238,
            711264, 638203, 599044, 428489, 468620, 796293, 620400, 344667
        }
    },
    {   "cmr10", 1274110073, 10485760, { // 11374260171 10.0
            655362, 873816, 815562, 728179, 699053, 786434, 757307, 815562,
            757307, 815562, 757307, 611672, 582544, 582544, 873816, 873816,
            291272, 320400, 524290, 524290, 524290, 524290, 524290, 786434,
            466035, 524291, 757307, 815562, 524290, 946634,1063142, 815562,
            291272, 291272, 524290, 873816, 524290, 873816, 815562, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 291272, 815562, 495163, 495163,
            815562, 786434, 742744, 757307, 800998, 713616, 684490, 822843,
            786434, 378653, 538853, 815562, 655362, 961197, 786434, 815562,
            713616, 815562, 771870, 582544, 757307, 786434, 786434,1077706,
            786434, 786434, 640798, 291272, 524290, 291272, 524290, 291272,
            291272, 524290, 582544, 466035, 582544, 466035, 320400, 524290,
            582544, 291272, 320400, 553418, 291272, 873816, 582544, 524290,
            582544, 553416, 410694, 413606, 407781, 582544, 553418, 757307,
            553418, 553418, 466035, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmr12", 1487622411, 12582912, { // 13052650413 12.0
            641519, 855600, 798560, 712637, 684480, 769677, 741520, 798560,
            741520, 798560, 741520, 598920, 570400, 570400, 855600, 855600,
            285200, 313720, 513360, 513360, 513360, 513360, 513360, 769677,
            456320, 513360, 741520, 798560, 513360, 926719,1040799, 798560,
            285200, 285200, 513360, 855600, 513360, 855600, 798560, 285200,
            399280, 399280, 513360, 798560, 285200, 342240, 285200, 513360,
            513360, 513360, 513360, 513360, 513360, 513360, 513360, 513360,
            513360, 513360, 285200, 285200, 285200, 798560, 484840, 484840,
            798560, 769677, 727079, 741520, 784119, 698559, 670039, 805600,
            769677, 370397, 527439, 798197, 641519, 940797, 769677, 798560,
            698559, 798560, 755599, 570400, 741520, 769677, 769677,1054877,
            769677, 769677, 627440, 285200, 513360, 285200, 513360, 285200,
            285200, 513360, 570400, 456320, 570400, 456320, 313720, 513360,
            570400, 285200, 313720, 541880, 285200, 855600, 570400, 513360,
            570400, 541880, 399280, 404984, 399280, 570400, 541880, 741520,
            541880, 541880, 456320, 513360,1026720, 513360, 513360, 513360
        }
    },
    {   "cmr17", 1154739572, 18119392, { // 10464766564 17.3
            603944, 809585, 754804, 672211, 645241, 726993, 700022, 754804,
            700022, 754804, 700022, 550932, 523541, 523541, 785311, 785311,
            261770, 289161, 480896, 480896, 480896, 480896, 480896, 726993,
            426115, 480896, 700022, 754804, 480896, 877852, 987415, 754804,
            261770, 261770, 480896, 809585, 480896, 809585, 754804, 261770,
            371333, 371333, 480896, 754804, 261770, 316552, 261770, 480896,
            480896, 480896, 480896, 480896, 480896, 480896, 480896, 480896,
            480896, 480896, 261770, 261770, 261770, 754804, 453506, 453506,
            754804, 726993, 686117, 700022, 740898, 658726, 631335, 761546,
            726993, 343522, 494382, 754383, 603944, 891337, 726993, 754804,
            658726, 754804, 713507, 535678, 700022, 726993, 726993,1000900,
            726993, 726993, 590459, 261770, 480896, 261770, 480896, 261770,
            261770, 480896, 535678, 426115, 535678, 426115, 289161, 480896,
            535678, 261770, 289161, 508287, 261770, 809585, 535678, 480896,
            535678, 508287, 371333, 376812, 371333, 535678, 508287, 700022,
            508287, 508287, 426115, 480896, 961793, 480896, 480896, 480896
        }
    },
    {   "cmr5", -2046583974, 5242880, { // 20600715532 5.00
            870915,1150541,1077722, 955386, 932083,1028205,1004902,1077722,
            1004902,1077722,1004902, 713626, 713626, 422349, 422349, 677216,
            422349, 458758, 713626, 713626, 713626, 713626, 713626,1028205,
            640806, 713626,1004902,1077722, 713626,1235011,1380650,1077722,
            422349, 422349, 713626,1150541, 713626,1150541,1077722, 422349,
            567987, 567987, 713626,1077722, 422349, 495168, 422349, 713626,
            713626, 713626, 713626, 713626, 713626, 713626, 713626, 713626,
            713626, 713626, 422349, 422349,1077722,1077722,1077722, 677216,
            1077722,1028205, 980144,1004902,1052963, 943734, 907325,1083549,
            1028205, 518470, 725277,1064614, 870915,1246662,1028205,1077722,
            943734,1077722,1016554, 786445,1004902,1028205,1028205,1392301,
            1028205,1028205, 859264, 422349, 713626, 422349, 713626, 422349,
            422349, 713626, 786445, 640806, 786445, 640806, 458758, 713626,
            786445, 422349, 458758, 750035, 422349,1150541, 786445, 713626,
            786445, 750035, 567987, 575270, 567987, 786445, 750035,1004902,
            750035, 750035, 640806, 713626,1427251, 713626, 713626, 713626
        }
    },
    {   "cmr6", -1186897496, 6291456, { // 27120260650 6.00
            790307,1048565, 980603, 871861, 844677, 939824, 912640, 980603,
            912640, 980603, 912640, 771859, 737877, 737877,1106816,1106816,
            368939, 402920, 640789, 640789, 640789, 640789, 640789, 939824,
            572827, 640789, 912640, 980603, 640789,1130120,1266045, 980603,
            368939, 368939, 640789,1048565, 640789,1048565, 980603, 368939,
            504864, 504864, 640789, 980603, 368939, 436901, 368939, 640789,
            640789, 640789, 640789, 640789, 640789, 640789, 640789, 640789,
            640789, 640789, 368939, 368939, 368939, 980603, 606808, 606808,
            980603, 939824, 892251, 912640, 960213, 858269, 824288, 987400,
            939824, 464085, 654381, 973805, 790307,1143712, 939824, 980603,
            858269, 980603, 926232, 708752, 912640, 939824, 939824,1279637,
            939824, 939824, 776715, 368939, 640789, 368939, 640789, 368939,
            368939, 640789, 708752, 572827, 708752, 572829, 402920, 640789,
            708752, 368939, 402920, 674771, 368939,1048565, 708752, 640789,
            708752, 674771, 504864, 511661, 504864, 708752, 674771, 912640,
            674771, 674771, 572827, 640789,1281579, 640789, 640789, 640789
        }
    },
    {   "cmr7", -644636590, 7340032, { // 33144720122 7.00
            740665, 984085, 919589, 819726, 790597, 884222, 855093, 919589,
            855093, 919589, 855093, 710498, 678249, 678249,1017374,1017374,
            339125, 371374, 597109, 597109, 597109, 597109, 597109, 884222,
            532613, 597111, 855093, 919589, 597109,1063145,1192137, 919589,
            339125, 339125, 597109, 984085, 597109, 984085, 919589, 339125,
            468117, 468117, 597109, 919589, 339125, 403621, 339125, 597109,
            597109, 597109, 597109, 597109, 597109, 597109, 597109, 597109,
            597109, 597109, 339125, 339125, 339125, 919589, 564862, 564862,
            919589, 884222, 837410, 855093, 901906, 805161, 772914, 926871,
            884222, 432750, 611673, 916471, 740665,1077710, 884222, 919589,
            805161, 919589, 869657, 661605, 855093, 884222, 884222,1206702,
            884222, 884222, 726101, 339125, 597109, 339125, 597109, 339125,
            339125, 597109, 661605, 532613, 661605, 532613, 371374, 597109,
            661605, 339125, 371374, 629358, 339125, 984085, 661605, 597109,
            661605, 629355, 468117, 474567, 468117, 661605, 629358, 855093,
            629358, 629358, 532613, 597109,1194217, 597109, 597109, 597109
        }
    },
    {   "cmr8", 2088458503, 8388608, { // 17436654407 8.00
            695784, 928440, 866544, 772608, 742752, 834504, 804648, 866544,
            804648, 866544, 804648, 649908, 618960, 618960, 928440, 928440,
            309480, 340428, 557064, 557064, 557064, 557064, 557064, 834504,
            495168, 557064, 804648, 866544, 557064,1005264,1129056, 866544,
            309480, 309480, 557064, 928440, 557064, 928440, 866544, 309480,
            433272, 433272, 557064, 866544, 309480, 371376, 309480, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 309480, 309480, 309480, 866544, 526116, 526116,
            866544, 834504, 788628, 804648, 850524, 757680, 726732, 874008,
            834504, 401232, 571992, 865452, 695784,1020192, 834504, 866544,
            757680, 866544, 819576, 618960, 804648, 834504, 834504,1143984,
            834504, 834504, 680856, 309480, 557064, 309480, 557064, 309480,
            309480, 557064, 618960, 495168, 618960, 495168, 340428, 557064,
            618960, 309480, 340428, 588012, 309480, 928440, 618960, 557064,
            618960, 588012, 434182, 439462, 433272, 618960, 588012, 804648,
            588012, 588012, 495168, 557064,1114128, 557064, 557064, 557064
        }
    },
    {   "cmr9", 1874103239, 9437184, { // 15755105707 9.00
            673479, 898080, 838208, 748238, 718464, 808110, 778336, 838208,
            778336, 838208, 778336, 628656, 598720, 598720, 898080, 898080,
            299360, 329296, 538848, 538848, 538848, 538848, 538848, 808110,
            478976, 538848, 778336, 838208, 538848, 972839,1092583, 838208,
            299360, 299360, 538848, 898080, 538848, 898080, 838208, 299360,
            419104, 419104, 538848, 838208, 299360, 359232, 299360, 538848,
            538848, 538848, 538848, 538848, 538848, 538848, 538848, 538848,
            538848, 538848, 299360, 299360, 299360, 838208, 508912, 508912,
            838208, 808110, 763287, 778336, 823159, 733351, 703415, 845652,
            808110, 389006, 553735, 838046, 673479, 987726, 808110, 838208,
            733351, 838208, 793223, 598720, 778336, 808110, 808110,1107470,
            808110, 808110, 658592, 299360, 538848, 299360, 538848, 299360,
            299360, 538848, 598720, 478976, 598720, 479381, 329296, 538848,
            598720, 299360, 329296, 568784, 299360, 898080, 598720, 538848,
            598720, 568784, 421532, 425092, 419104, 598720, 568784, 778336,
            568784, 568784, 478976, 538848,1077696, 538848, 538848, 538848
        }
    },
    {   "cmsl10", 1890463818, 10485760, { // 16053430112 10.0
            655362, 873816, 815562, 728179, 699053, 786434, 757307, 815562,
            757307, 815562, 757307, 611672, 582544, 582544, 873816, 873816,
            291272, 320400, 524290, 524290, 524290, 524290, 524290, 847926,
            466035, 524291, 757307, 815562, 524290, 946634,1063142, 815562,
            291272, 291272, 524290, 873816, 524290, 873816, 815562, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 291272, 815562, 495163, 495163,
            815562, 786434, 742744, 757307, 800998, 713616, 684490, 822843,
            786434, 378653, 538853, 815562, 655362, 961197, 786434, 815562,
            713616, 815562, 771870, 582544, 757307, 786434, 786434,1077706,
            786434, 786434, 640798, 291272, 524290, 291272, 524290, 291272,
            291272, 524290, 582544, 466035, 582544, 466035, 320400, 524290,
            582544, 291272, 320400, 553418, 291272, 873816, 582544, 524290,
            582544, 553416, 410694, 413606, 407781, 582544, 553418, 757307,
            553418, 553418, 466035, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmsl12", 2103976403, 12582912, { // 17532020723 12.0
            641519, 855600, 798560, 712637, 684480, 769677, 741520, 798560,
            741520, 798560, 741520, 598920, 570400, 570400, 855600, 855600,
            285200, 313720, 513360, 513360, 513360, 513360, 513360, 831169,
            456320, 513360, 741520, 798560, 513360, 926719,1040799, 798560,
            285200, 285200, 513360, 855600, 513360, 855600, 798560, 285200,
            399280, 399280, 513360, 798560, 285200, 342240, 285200, 513360,
            513360, 513360, 513360, 513360, 513360, 513360, 513360, 513360,
            513360, 513360, 285200, 285200, 285200, 798560, 484840, 484840,
            798560, 769677, 727079, 741520, 784119, 698559, 670039, 805600,
            769677, 370397, 527439, 798197, 641519, 940797, 769677, 798560,
            698559, 798560, 755599, 570400, 741520, 769677, 769677,1054877,
            769677, 769677, 627440, 285200, 513360, 285200, 513360, 285200,
            285200, 513360, 570400, 456320, 570400, 456320, 313720, 513360,
            570400, 285200, 313720, 541880, 285200, 855600, 570400, 513360,
            570400, 541880, 399280, 404984, 399280, 570400, 541880, 741520,
            541880, 541880, 456320, 513360,1026720, 513360, 513360, 513360
        }
    },
    {   "cmsl8", -1590154801, 8388608, { // 24116024717 8.00
            695784, 928440, 866544, 772608, 742752, 834504, 804648, 866544,
            804648, 866544, 804648, 649908, 618960, 618960, 928440, 928440,
            309480, 340428, 557064, 557064, 557064, 557064, 557064, 895996,
            495168, 557064, 804648, 866544, 557064,1005264,1129056, 866544,
            309480, 309480, 557064, 928440, 557064, 928440, 866544, 309480,
            433272, 433272, 557064, 866544, 309480, 371376, 309480, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 309480, 309480, 309480, 866544, 526116, 526116,
            866544, 834504, 788628, 804648, 850524, 757680, 726732, 874008,
            834504, 401232, 571992, 865452, 695784,1020192, 834504, 866544,
            757680, 866544, 819576, 618960, 804648, 834504, 834504,1143984,
            834504, 834504, 680856, 309480, 557064, 309480, 557064, 309480,
            309480, 557064, 618960, 495168, 618960, 495168, 340428, 557064,
            618960, 309480, 340428, 588012, 309480, 928440, 618960, 557064,
            618960, 588012, 434182, 439462, 433272, 618960, 588012, 804648,
            588012, 588012, 495168, 557064,1114128, 557064, 557064, 557064
        }
    },
    {   "cmsl9", -1804510312, 9437184, { // 22434255630 9.00
            673479, 898080, 838208, 748238, 718464, 808110, 778336, 838208,
            778336, 838208, 778336, 628656, 598720, 598720, 898080, 898080,
            299360, 329296, 538848, 538848, 538848, 538848, 538848, 869602,
            478976, 538848, 778336, 838208, 538848, 972839,1092583, 838208,
            299360, 299360, 538848, 898080, 538848, 898080, 838208, 299360,
            419104, 419104, 538848, 838208, 299360, 359232, 299360, 538848,
            538848, 538848, 538848, 538848, 538848, 538848, 538848, 538848,
            538848, 538848, 299360, 299360, 299360, 838208, 508912, 508912,
            838208, 808110, 763287, 778336, 823159, 733351, 703415, 845652,
            808110, 389006, 553735, 838046, 673479, 987726, 808110, 838208,
            733351, 838208, 793223, 598720, 778336, 808110, 808110,1107470,
            808110, 808110, 658592, 299360, 538848, 299360, 538848, 299360,
            299360, 538848, 598720, 478976, 598720, 479381, 329296, 538848,
            598720, 299360, 329296, 568784, 299360, 898080, 598720, 538848,
            598720, 568784, 421532, 425092, 419104, 598720, 568784, 778336,
            568784, 568784, 478976, 538848,1077696, 538848, 538848, 538848
        }
    },
    {   "cmsltt10", -538297224, 10485760, { // 33772436170 10.0
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498
        }
    },
    {   "cmss10", 1831058770, 10485760, { // 15510736522 10.0
            567981, 873816, 815562, 640800, 699053, 742746, 757307, 815562,
            757307, 815562, 757307, 611672, 562155, 562155, 853427, 853427,
            250494, 279622, 524290, 524290, 524290, 524290, 524290, 699054,
            466035, 503902, 757307, 815562, 524290, 902944,1019453, 815562,
            250494, 334963, 524290, 873816, 524290, 873816, 795173, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 334963, 815562, 495163, 495163,
            699053, 699054, 699054, 669926, 757309, 626235, 597109, 699053,
            742746, 291274, 495163, 728182, 567981, 917509, 742746, 771870,
            669926, 771870, 677208, 582544, 713616, 720901, 699054, 990326,
            699054, 699054, 640798, 302923, 524290, 302923, 524290, 291272,
            291272, 503901, 541766, 466035, 541766, 466035, 320400, 524290,
            541766, 250494, 279622, 512640, 250494, 833038, 541766, 524290,
            541766, 541766, 358266, 401955, 378653, 541766, 483512, 716530,
            483512, 483512, 455840, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmss12", -2100407754, 12582912, { // 20263451066 12.0
            554621, 855600, 798560, 621371, 684480, 719675, 741520, 798560,
            741520, 798560, 741520, 598920, 548555, 548555, 833755, 833755,
            241509, 270029, 513360, 513360, 513360, 513360, 513360, 678411,
            456320, 491515, 741520, 798560, 513360, 881085, 995165, 798560,
            241509, 326464, 513360, 855600, 513360, 855600, 776715, 285200,
            399280, 399280, 513360, 798560, 285200, 342240, 285200, 513360,
            513360, 513360, 513360, 513360, 513360, 513360, 513360, 513360,
            513360, 513360, 285200, 285200, 326464, 798560, 484840, 484840,
            684480, 678411, 681445, 655960, 738485, 611661, 583141, 684480,
            719675, 279131, 481805, 706931, 554621, 890795, 719675, 757296,
            652925, 757296, 660813, 570400, 700256, 699043, 678411, 963611,
            678411, 678411, 627440, 296731, 513360, 296731, 513360, 285200,
            285200, 491515, 526709, 456320, 526709, 456320, 313720, 513360,
            526709, 241509, 270029, 498189, 241509, 811909, 526709, 513360,
            526709, 526709, 348915, 393576, 370760, 526709, 469669, 697829,
            469669, 469669, 445397, 513360,1026720, 513360, 513360, 513360
        }
    },
    {   "cmss17", 97961503, 18119392, { // 565543037 17.3
            533486, 821722, 766941, 600067, 657378, 695303, 712159, 766941,
            712159, 766941, 712159, 575206, 527588, 527588, 801495, 801495,
            233454, 260844, 493033, 493033, 493033, 493033, 493033, 654848,
            438252, 472807, 712159, 766941, 493033, 847848, 957411, 766941,
            233454, 314362, 493033, 821722, 493033, 821722, 746714, 273907,
            383470, 383470, 493033, 766941, 273907, 328689, 273907, 493033,
            493033, 493033, 493033, 493033, 493033, 493033, 493033, 493033,
            493033, 493033, 273907, 273907, 314362, 766941, 465643, 465643,
            657378, 654848, 656113, 629987, 710894, 588268, 560877, 657378,
            695303, 271378, 464378, 682239, 533486, 859647, 695303, 726486,
            628722, 726486, 635885, 547815, 671705, 675076, 654848, 928756,
            654848, 654848, 602596, 286129, 493033, 286129, 493033, 273907,
            273907, 472807, 507361, 438252, 507361, 438252, 301298, 493033,
            507361, 233454, 260844, 479970, 233454, 781269, 507361, 493033,
            507361, 507361, 335853, 377993, 356080, 507361, 452580, 671706,
            452580, 452580, 428138, 493033, 986067, 493033, 493033, 493033
        }
    },
    {   "cmss8", -965527919, 8388608, { // 30634633221 8.00
            606218, 928440, 866544, 680856, 742752, 786442, 804648, 866544,
            804648, 866544, 804648, 649908, 597114, 597114, 906594, 906594,
            265788, 296736, 557064, 557064, 557064, 557064, 557064, 742752,
            495168, 535218, 804648, 866544, 557064, 959388,1083180, 866544,
            265788, 353170, 557064, 928440, 557064, 928440, 844698, 309480,
            433272, 433272, 557064, 866544, 309480, 371376, 309480, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 309480, 309480, 353170, 866544, 526116, 526116,
            742752, 742752, 742752, 711804, 804648, 668114, 637166, 742752,
            786442, 309480, 526116, 773700, 606218, 972130, 786442, 822854,
            711804, 822854, 720906, 618960, 760958, 764598, 742752,1052232,
            742752, 742752, 680856, 324044, 557064, 324044, 557064, 309480,
            309480, 535218, 575268, 495168, 575268, 495168, 340428, 557064,
            575268, 265788, 296736, 544320, 265788, 884748, 575268, 557064,
            575268, 575268, 380478, 427082, 402324, 575268, 513372, 760956,
            513372, 513372, 484244, 557064,1114128, 557064, 557064, 557064
        }
    },
    {   "cmss9", -764426377, 9437184, { // 32233743567 9.00
            587392, 898080, 838208, 660210, 718464, 762155, 778336, 838208,
            778336, 838208, 778336, 628656, 577684, 577684, 877044, 877044,
            257287, 287223, 538848, 538848, 538848, 538848, 538848, 720082,
            478976, 517812, 778336, 838208, 538848, 928825,1048569, 838208,
            257287, 341433, 538848, 898080, 538848, 898080, 817172, 299360,
            419104, 419104, 538848, 838208, 299360, 359232, 299360, 538848,
            538848, 538848, 538848, 538848, 538848, 538848, 538848, 538848,
            538848, 538848, 299360, 299360, 341433, 838208, 508912, 508912,
            718464, 720082, 719273, 688528, 779145, 647264, 617328, 718464,
            762155, 300978, 509721, 750018, 587392, 941771, 762155, 796135,
            689337, 796135, 698236, 598720, 736263, 741118, 720082,1019442,
            720082, 720082, 658592, 313115, 538848, 313115, 538848, 299360,
            299360, 517812, 556647, 478976, 556647, 478978, 329296, 538848,
            556647, 257287, 287223, 526711, 257287, 856007, 556647, 538848,
            556647, 556647, 368132, 413118, 389168, 556647, 496775, 736263,
            496775, 496775, 468457, 538848,1077696, 538848, 538848, 538848
        }
    },
    {   "cmssbx10", -244629176, 10485760, { // 36132640510 10.0
            608760, 961200, 897120, 704880, 768960, 833040, 833040, 897120,
            833040, 897120, 833040, 672840, 614586, 614586, 934986, 934986,
            267971, 300011, 576720, 576720, 576720, 576720, 576720, 768960,
            512640, 592739, 833040, 897120, 576720, 993240,1121400, 897120,
            267971, 384480, 585458, 961200, 576720,1079109, 870906, 320400,
            448560, 448560, 576720, 897120, 320400, 384480, 320400, 576720,
            576720, 576720, 576720, 576720, 576720, 576720, 576720, 576720,
            576720, 576720, 320400, 320400, 384480, 897120, 544680, 544680,
            768960, 768960, 768960, 736920, 833040, 672840, 640800, 768960,
            833040, 346614, 544680, 801000, 608760,1025280, 833040, 833040,
            736920, 833040, 736920, 640800, 768960, 801000, 768960,1089360,
            768960, 768960, 704880, 359722, 585458, 359722, 576720, 320400,
            320400, 550506, 588371, 512640, 588371, 535942, 352440, 576720,
            588371, 267971, 300011, 556331, 267971, 908771, 588371, 576720,
            588371, 588371, 390306, 442152, 423802, 588371, 524291, 780611,
            524291, 524291, 499533, 576720,1153440, 576720, 576720, 576720
        }
    },
    {   "cmssdc10", 1893393257, 10485760, { // 16066561551 10.0
            538843, 830112, 774771, 611661, 664090, 710693, 719430, 774771,
            719430, 774771, 719430, 581078, 530106, 530106, 806810, 806810,
            230099, 257770, 498067, 498067, 498067, 498067, 498067, 667002,
            442726, 490789, 719430, 774771, 498067, 859238, 969920, 774771,
            230099, 320395, 498069, 830112, 498067, 922162, 751469, 276704,
            387386, 387386, 498067, 774771, 276704, 332045, 276704, 498067,
            498067, 498067, 498067, 498067, 498067, 498067, 498067, 498067,
            498067, 498067, 276704, 276704, 320395, 774771, 470397, 470397,
            664090, 667002, 665546, 636419, 720886, 594184, 566514, 664090,
            710693, 297094, 471853, 694672, 538843, 876715, 710693, 731080,
            637875, 731080, 643699, 553408, 675739, 688848, 667002, 943706,
            667002, 667002, 608749, 307288, 498069, 307288, 498067, 276704,
            276704, 474765, 506803, 442726, 506803, 459475, 304374, 506803,
            506803, 230099, 257770, 479133, 230099, 783507, 506803, 498067,
            506803, 506803, 336413, 381853, 362629, 506803, 451462, 672826,
            451462, 451462, 431075, 498067, 996134, 498067, 498067, 498067
        }
    },
    {   "cmssi10", -984248855, 10485760, { // 30525306751 10.0
            567981, 873816, 815562, 640800, 699053, 742746, 757307, 815562,
            757307, 815562, 757307, 611672, 562155, 562155, 853427, 853427,
            250494, 279622, 524290, 524290, 524290, 524290, 524290, 773347,
            466035, 503902, 757307, 815562, 524290, 902944,1019453, 815562,
            250494, 334963, 524290, 873816, 524290, 873816, 795173, 291272,
            407781, 407781, 524290, 815562, 291272, 349526, 291272, 524290,
            524290, 524290, 524290, 524290, 524290, 524290, 524290, 524290,
            524290, 524290, 291272, 291272, 334963, 815562, 495163, 495163,
            699053, 699054, 699054, 669926, 757309, 626235, 597109, 699053,
            742746, 291274, 495163, 728182, 567981, 917509, 742746, 771870,
            669926, 771870, 677208, 582544, 713616, 720901, 699054, 990326,
            699054, 699054, 640798, 302923, 524290, 302923, 524290, 291272,
            291272, 503901, 541766, 466035, 541766, 466035, 320400, 524290,
            541766, 250494, 279622, 512640, 250494, 833038, 541766, 524290,
            541766, 541766, 358266, 401955, 378653, 541766, 483512, 716530,
            483512, 483512, 455840, 524290,1048579, 524290, 524290, 524290
        }
    },
    {   "cmssi12", -637328691, 12582912, { // 33200621315 12.0
            554621, 855600, 798560, 621371, 684480, 719675, 741520, 798560,
            741520, 798560, 741520, 598920, 548555, 548555, 833755, 833755,
            241509, 270029, 513360, 513360, 513360, 513360, 513360, 752704,
            456320, 491515, 741520, 798560, 513360, 881085, 995165, 798560,
            241509, 326464, 513360, 855600, 513360, 855600, 776715, 285200,
            399280, 399280, 513360, 798560, 285200, 342240, 285200, 513360,
            513360, 513360, 513360, 513360, 513360, 513360, 513360, 513360,
            513360, 513360, 285200, 285200, 326464, 798560, 484840, 484840,
            684480, 678411, 681445, 655960, 738485, 611661, 583141, 684480,
            719675, 279131, 481805, 706931, 554621, 890795, 719675, 757296,
            652925, 757296, 660813, 570400, 700256, 699043, 678411, 963611,
            678411, 678411, 627440, 296731, 513360, 296731, 513360, 285200,
            285200, 491515, 526709, 456320, 526709, 456320, 313720, 513360,
            526709, 241509, 270029, 498189, 241509, 811909, 526709, 513360,
            526709, 526709, 348915, 393576, 370760, 526709, 469669, 697829,
            469669, 469669, 445397, 513360,1026720, 513360, 513360, 513360
        }
    },
    {   "cmssi17", -1601180043, 18119392, { // 24043767165 17.3
            533486, 821722, 766941, 600067, 657378, 695303, 712159, 766941,
            712159, 766941, 712159, 575206, 527588, 527588, 801495, 801495,
            233454, 260844, 493033, 493033, 493033, 493033, 493033, 733288,
            438252, 472807, 712159, 766941, 493033, 847848, 957411, 766941,
            233454, 314362, 493033, 821722, 493033, 821722, 746714, 273907,
            383470, 383470, 493033, 766941, 273907, 328689, 273907, 493033,
            493033, 493033, 493033, 493033, 493033, 493033, 493033, 493033,
            493033, 493033, 273907, 273907, 314362, 766941, 465643, 465643,
            657378, 654848, 656113, 629987, 710894, 588268, 560877, 657378,
            695303, 271378, 464378, 682239, 533486, 859647, 695303, 726486,
            628722, 726486, 635885, 547815, 671705, 675076, 654848, 928756,
            654848, 654848, 602596, 286129, 493033, 286129, 493033, 273907,
            273907, 472807, 507361, 438252, 507361, 438252, 301298, 493033,
            507361, 233454, 260844, 479970, 233454, 781269, 507361, 493033,
            507361, 507361, 335853, 377993, 356080, 507361, 452580, 671706,
            452580, 452580, 428138, 493033, 986067, 493033, 493033, 493033
        }
    },
    {   "cmssi8", 542250684, 8388608, { // 4024413274 8.00
            606218, 928440, 866544, 680856, 742752, 786442, 804648, 866544,
            804648, 866544, 804648, 649908, 597114, 597114, 906594, 906594,
            265788, 296736, 557064, 557064, 557064, 557064, 557064, 817046,
            495168, 535218, 804648, 866544, 557064, 959388,1083180, 866544,
            265788, 353170, 557064, 928440, 557064, 928440, 844698, 309480,
            433272, 433272, 557064, 866544, 309480, 371376, 309480, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 309480, 309480, 353170, 866544, 526116, 526116,
            742752, 742752, 742752, 711804, 804648, 668114, 637166, 742752,
            786442, 309480, 526116, 773700, 606218, 972130, 786442, 822854,
            711804, 822854, 720906, 618960, 760958, 764598, 742752,1052232,
            742752, 742752, 680856, 324044, 557064, 324044, 557064, 309480,
            309480, 535218, 575268, 495168, 575268, 495168, 340428, 557064,
            575268, 265788, 296736, 544320, 265788, 884748, 575268, 557064,
            575268, 575268, 380478, 427082, 402324, 575268, 513372, 760956,
            513372, 513372, 484244, 557064,1114128, 557064, 557064, 557064
        }
    },
    {   "cmssi9", 732010263, 9437184, { // 5350313427 9.00
            587392, 898080, 838208, 660210, 718464, 762155, 778336, 838208,
            778336, 838208, 778336, 628656, 577684, 577684, 877044, 877044,
            257287, 287223, 538848, 538848, 538848, 538848, 538848, 794375,
            478976, 517812, 778336, 838208, 538848, 928825,1048569, 838208,
            257287, 341433, 538848, 898080, 538848, 898080, 817172, 299360,
            419104, 419104, 538848, 838208, 299360, 359232, 299360, 538848,
            538848, 538848, 538848, 538848, 538848, 538848, 538848, 538848,
            538848, 538848, 299360, 299360, 341433, 838208, 508912, 508912,
            718464, 720082, 719273, 688528, 779145, 647264, 617328, 718464,
            762155, 300978, 509721, 750018, 587392, 941771, 762155, 796135,
            689337, 796135, 698236, 598720, 736263, 741118, 720082,1019442,
            720082, 720082, 658592, 313115, 538848, 313115, 538848, 299360,
            299360, 517812, 556647, 478976, 556647, 478978, 329296, 538848,
            556647, 257287, 287223, 526711, 257287, 856007, 556647, 538848,
            556647, 556647, 368132, 413118, 389168, 556647, 496775, 736263,
            496775, 496775, 468457, 538848,1077696, 538848, 538848, 538848
        }
    },
    {   "cmssq8", 1265911151, 8388608, { // 11335042557 8.00
            742744,1092270,1019452, 771872, 873816, 851972, 946634,1019452,
            946634,1019452, 946634, 764590, 691772, 691772,1055862,1055862,
            291274, 327684, 655362, 655362, 655362, 655362, 655362, 844690,
            582544, 618956, 946634,1019452, 655362,1114116,1259752,1019452,
            291274, 371372, 655362,1092270, 655362,1092270, 983044, 364090,
            509726, 509726, 655362,1019452, 364090, 436908, 364090, 655362,
            655362, 655362, 655362, 655362, 655362, 655362, 655362, 655362,
            655362, 655362, 364090, 364090, 371372,1019452, 618954, 618954,
            873816, 844690, 859254, 837408, 932072, 815562, 779154, 873816,
            851972, 334964, 604390, 881100, 742744,1070426, 851972,1012170,
            822844,1012170, 855612, 728180, 939352, 848332, 844690,1208780,
            844690, 844690, 800998, 369552, 655362, 369552, 655362, 364090,
            364090, 618954, 655364, 582544, 655364, 582544, 400500, 655364,
            655364, 291274, 327684, 618956, 291274,1019454, 655364, 655362,
            655364, 655364, 436910, 502444, 473316, 655364, 582546, 873818,
            582546, 582546, 564340, 655362,1310724, 655362, 655362, 655362
        }
    },
    {   "cmssqi8", -1660616191, 8388608, { // 23501201001 8.00
            742744,1092270,1019452, 771872, 873816, 851972, 946634,1019452,
            946634,1019452, 946634, 764590, 691772, 691772,1055862,1055862,
            291274, 327684, 655362, 655362, 655362, 655362, 655362, 896282,
            582544, 618956, 946634,1019452, 655362,1114116,1259752,1019452,
            291274, 371372, 655362,1092270, 655362,1092270, 983044, 364090,
            509726, 509726, 655362,1019452, 364090, 436908, 364090, 655362,
            655362, 655362, 655362, 655362, 655362, 655362, 655362, 655362,
            655362, 655362, 364090, 364090, 371372,1019452, 618954, 618954,
            873816, 844690, 859254, 837408, 932072, 815562, 779154, 873816,
            851972, 334964, 604390, 881100, 742744,1070426, 851972,1012170,
            822844,1012170, 855612, 728180, 939352, 848332, 844690,1208780,
            844690, 844690, 800998, 369552, 655362, 369552, 655362, 364090,
            364090, 618954, 655364, 582544, 655364, 582544, 400500, 655364,
            655364, 291274, 327684, 618956, 291274,1019454, 655364, 655362,
            655364, 655364, 436910, 502444, 473316, 655364, 582546, 873818,
            582546, 582546, 564340, 655362,1310724, 655362, 655362, 655362
        }
    },
    {   "cmsy10", 555887770, 10485760, { // 4110426232 10.0
            815562, 291272, 815562, 524290, 815562, 524290, 815562, 815562,
            815562, 815562, 815562, 815562, 815562,1048579, 524290, 524290,
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562,1048579,1048579, 815562, 815562,
            1048579,1048579, 524290, 524290,1048579,1048579,1048579, 815562,
            1048579,1048579, 640798, 640798,1048579,1048579,1048579, 815562,
            288358,1048579, 699053, 699053, 932070, 932070,      0,      0,
            582544, 582544, 699053, 524290, 757307, 757307, 815562, 815562,
            640798, 837258, 688715, 552106, 808864, 553419, 753662, 623762,
            885541, 570966, 710704, 798963, 723229,1259235, 860347, 834786,
            729347, 856341, 888672, 634974, 571101, 656232, 642549,1035766,
            747946, 700802, 759930, 699053, 699053, 699053, 699053, 699053,
            640798, 640798, 466035, 466035, 466035, 466035, 524290, 524290,
            407781, 407781, 291272, 524290, 524290, 640798, 524290, 291272,
            873816, 786434, 873816, 436909, 699053, 699053, 815562, 815562,
            466037, 466035, 466035, 640798, 815562, 815562, 815562, 815562
        }
    },
    {   "cmsy5", -1327746962, 5242880, { // 26067030156 5.00
            1135974, 480602,1135974, 771878,1135974, 771878,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1427251, 771878, 771878,
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1427251,1427251,1135974,1135974,
            1427251,1427251, 771878, 771878,1427251,1427251,1427251,1135974,
            1427251,1427251, 917517, 917517,1427251,1427251,1427251,1135974,
            462397,1427251, 990336, 990336,1281613,1281613,      0,      0,
            844698, 844698, 990336, 771878,1063155,1063155,1135974,1135974,
            917517,1167574, 963974, 820083,1136560, 808288,1036208, 891741,
            1252560, 859338,1004899,1106269,1011600,1644022,1180758,1142090,
            1046118,1186947,1254237, 910234, 862384, 916202, 942570,1434099,
            1045053, 974608,1039562, 990336, 990336, 990336, 990336, 990336,
            917517, 917517, 699059, 699059, 699059, 699059, 771878, 771878,
            626240, 626240, 480602, 771878, 771878, 917517, 771878, 480602,
            1150541,1086458,1208794, 662650, 990336, 990336,1135974,1135974,
            699059, 699059, 699059, 917517,1135974,1135974,1135974,1135974
        }
    },
    {   "cmsy6", 1906386187, 6291456, { // 16150222413 6.00
            1009733, 398069,1009733, 669920,1009733, 669920,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1281584, 669920, 669920,
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1281584,1281584,1009733,1009733,
            1281584,1281584, 669920, 669920,1281584,1281584,1281584,1009733,
            1281584,1281584, 805845, 805845,1281584,1281584,1281584,1009733,
            383507,1281584, 873808, 873808,1145659,1145659,      0,      0,
            737883, 737883, 873808, 669920, 941771, 941771,1009733,1009733,
            805845,1038029, 852789, 711328,1007888, 703901, 922592, 782979,
            1110776, 743779, 887400, 984397, 896043,1496560,1054517,1020219,
            921091,1057307,1112939, 799048, 745856, 812053, 823371,1282117,
            926581, 863909, 926917, 873808, 873808, 873808, 873808, 873808,
            805845, 805845, 601957, 601957, 601957, 601957, 669920, 669920,
            533995, 533995, 398069, 669920, 669920, 805845, 669920, 398069,
            1048568, 968955,1077696, 567979, 873808, 873808,1009733,1009733,
            601957, 601957, 601957, 805845,1009733,1009733,1009733,1009733
        }
    },
    {   "cmsy7", 1327620741, 7340032, { // 11710361205 7.00
            936233, 355769, 936233, 613753, 936233, 613753, 936233, 936233,
            936233, 936233, 936233, 936233, 936233,1194217, 613753, 613753,
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233,1194217,1194217, 936233, 936233,
            1194217,1194217, 613753, 613753,1194217,1194217,1194217, 936233,
            1194217,1194217, 742745, 742745,1194217,1194217,1194217, 936233,
            345365,1194217, 807241, 807241,1065225,1065225,      0,      0,
            678249, 678249, 807241, 613753, 871737, 871737, 936233, 936233,
            742745, 962176, 790037, 650311, 932656, 646005, 858107, 721963,
            1026183, 677906, 820142, 914021, 830171,1407911, 981017, 949840,
            848457, 981383,1028690, 736297, 679289, 752667, 754898,1190247,
            858633, 801502, 863127, 807241, 807241, 807241, 807241, 807241,
            742745, 742745, 549257, 549257, 549257, 549257, 613753, 613753,
            484761, 484761, 355769, 613753, 613753, 742745, 613753, 355769,
            984085, 900866,1000729, 517531, 807241, 807241, 936233, 936233,
            549259, 549257, 549257, 742745, 936233, 936233, 936233, 936233
        }
    },
    {   "cmsy8", -1102329845, 8388608, { // 27622744013 8.00
            866544, 309480, 866544, 557064, 866544, 557064, 866544, 866544,
            866544, 866544, 866544, 866544, 866544,1114128, 557064, 557064,
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544,1114128,1114128, 866544, 866544,
            1114128,1114128, 557064, 557064,1114128,1114128,1114128, 866544,
            1114128,1114128, 680856, 680856,1114128,1114128,1114128, 866544,
            302194,1114128, 742752, 742752, 990336, 990336,      0,      0,
            618960, 618960, 742752, 557064, 804648, 804648, 866544, 866544,
            680856, 890716, 728406, 589978, 861666, 588012, 795176, 661632,
            948174, 613934, 755132, 846668, 766198,1325946, 911326, 882490,
            779418, 909872, 950942, 674666, 614800, 695014, 688068,1105866,
            793100, 740130, 800716, 742752, 742752, 742752, 742752, 742752,
            680856, 680856, 495168, 495168, 495168, 495168, 557064, 557064,
            433272, 433272, 309480, 557064, 557064, 680856, 557064, 309480,
            928440, 834504, 928440, 465130, 742752, 742752, 866544, 866544,
            495168, 495168, 495168, 680856, 866544, 866544, 866544, 866544
        }
    },
    {   "cmsy9", -1447980854, 9437184, { // 25154310312 9.00
            838208, 299360, 838208, 538848, 838208, 538848, 838208, 838208,
            838208, 838208, 838208, 838208, 838208,1077696, 538848, 538848,
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208,1077696,1077696, 838208, 838208,
            1077696,1077696, 538848, 538848,1077696,1077696,1077696, 838208,
            1077696,1077696, 658592, 658592,1077696,1077696,1077696, 838208,
            292889,1077696, 718464, 718464, 957952, 957952,      0,      0,
            598720, 598720, 718464, 538848, 778336, 778336, 838208, 838208,
            658592, 861003, 706345, 568928, 832318, 568784, 772103, 640583,
            913360, 590053, 730437, 820153, 742316,1288868, 882990, 855975,
            751588, 880117, 916331, 652604, 590512, 673460, 662768,1066903,
            768004, 718274, 778046, 718464, 718464, 718464, 718464, 718464,
            658592, 658592, 478976, 478976, 478976, 478976, 538848, 538848,
            419104, 419104, 299360, 538848, 538848, 658592, 538848, 299360,
            898080, 808110, 898080, 449042, 718464, 718464, 838208, 838208,
            478976, 478976, 478976, 658592, 838208, 838208, 838208, 838208
        }
    },
    {   "cmtcsc10", -751363667, 10485760, { // 32315614655 10.0
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498,1100995, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498
        }
    },
    {   "cmtex10", -538297224, 10485760, { // 33772436170 10.0
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498
        }
    },
    {   "cmtex8", -549205389, 8388608, { // 33720745163 8.00
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064
        }
    },
    {   "cmtex9", -542880256, 9437184, { // 33751047000 9.00
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496
        }
    },
    {   "cmti10", -50321606, 10485760, { // 37500023472 10.0
            657686, 857498, 803904, 725843, 696717, 779437, 750310, 803904,
            750310, 803904, 750310, 643123, 589530, 616326, 924490, 937888,
            321562, 348358, 535936, 535936, 535936, 535936, 535936, 871672,
            482342, 562733, 750310, 750310, 535936, 925654,1032842, 803904,
            267968, 321562, 539432, 857498, 806453, 857498, 803904, 321562,
            428749, 428749, 535936, 803904, 321562, 375155, 321562, 535936,
            535936, 535936, 535936, 535936, 535936, 535936, 535936, 535936,
            535936, 535936, 321562, 321562, 321562, 803904, 535936, 535936,
            803904, 779437, 738077, 750310, 791670, 711280, 684483, 811186,
            779437, 404282, 550499, 806234, 657686, 940218, 779437, 803904,
            711280, 803904, 764874, 589530, 750310, 779437, 779437,1047405,
            779437, 779437, 643123, 321562, 539432, 321562, 535936, 321562,
            321562, 535936, 482342, 482342, 535936, 482342, 321562, 482342,
            535936, 321562, 321562, 482342, 267968, 857498, 589530, 535936,
            535936, 482342, 442147, 428749, 348358, 562733, 482342, 696717,
            486421, 509139, 428749, 535936,1071872, 535936, 535936, 535936
        }
    },
    {   "cmti12", -1682208704, 12582912, { // 23356704100 12.0
            643231, 838869, 786440, 709739, 681581, 762168, 734011, 786440,
            734011, 786440, 734011, 629152, 576724, 602939, 904408, 917515,
            314576, 340791, 524293, 524293, 524293, 524293, 524293, 854404,
            471864, 550508, 734011, 734011, 524293, 905377,1010236, 786440,
            262147, 314576, 524293, 838869, 791900, 838869, 786440, 314576,
            419435, 419435, 524293, 786440, 314576, 367005, 314576, 524293,
            524293, 524293, 524293, 524293, 524293, 524293, 524293, 524293,
            524293, 524293, 314576, 314576, 314576, 786440, 524293, 524293,
            786440, 762168, 721875, 734011, 774304, 695660, 669445, 793480,
            762168, 395163, 538372, 788383, 643231, 919456, 762168, 786440,
            695660, 786440, 748089, 576723, 734011, 762168, 762168,1024315,
            762168, 762168, 629152, 314576, 524293, 314576, 524293, 314576,
            314576, 524293, 471864, 471864, 524293, 471864, 314576, 471864,
            524293, 314576, 314576, 471864, 262147, 838869, 576723, 524293,
            524293, 471864, 432543, 419436, 340791, 550508, 471864, 681581,
            471864, 498079, 419435, 524293,1048587, 524293, 524293, 524293
        }
    },
    {   "cmti7", 1954372810, 7340032, { // 16437256312 7.00
            770215,1001986, 940402, 846363, 817234, 907947, 878818, 940402,
            878818, 940402, 878818, 772295, 710713, 741504,1112254,1127650,
            386146, 416939, 632482, 632482, 632482, 632482, 632482,1000183,
            570898, 663278, 878818, 878818, 632482,1078135,1201303, 940402,
            324562, 386146, 632482,1001986, 922976,1001986, 940402, 386146,
            509314, 509314, 632482, 940402, 386146, 447730, 386146, 632482,
            632482, 632482, 632482, 632482, 632482, 632482, 632482, 632482,
            632482, 632482, 386146, 386146, 386146, 940402, 632482, 632482,
            940402, 907947, 862592, 878818, 924176, 831799, 801008, 947685,
            907947, 476859, 647047, 938741, 770215,1092699, 907947, 940402,
            831799, 940402, 893383, 694066, 878818, 907947, 907947,1215867,
            907947, 907947, 755650, 386146, 632482, 386146, 632482, 386146,
            386146, 632482, 570898, 570898, 632482, 570898, 386149, 570898,
            632482, 386146, 386146, 570898, 324562,1001986, 694066, 632482,
            632482, 570898, 524711, 509314, 416939, 663275, 570898, 817234,
            570901, 601691, 509317, 632482,1264965, 632482, 632482, 632482
        }
    },
    {   "cmti8", 600925840, 8388608, { // 4364263220 8.00
            705242, 920418, 862892, 777696, 747840, 835222, 805366, 862892,
            805366, 862892, 805366, 690318, 632794, 661556, 992332,1006714,
            345158, 373922, 575262, 575262, 575262, 575262, 575262, 927458,
            517736, 604028, 805366, 805366, 575262, 992872,1107924, 862892,
            287632, 345158, 576718, 920418, 855610, 920418, 862892, 345158,
            460210, 460210, 575262, 862892, 345158, 402684, 345158, 575262,
            575262, 575262, 575262, 575262, 575262, 575262, 575262, 575262,
            575262, 575262, 345158, 345158, 345158, 862892, 575262, 575262,
            862892, 835222, 791532, 805366, 849058, 762768, 734006, 870356,
            835222, 432540, 590190, 863986, 705242,1007800, 835222, 862892,
            762768, 862892, 820294, 632788, 805366, 835222, 835222,1122852,
            835222, 835222, 690314, 345158, 576718, 345158, 575262, 345158,
            345158, 575262, 517736, 517736, 575262, 517736, 345160, 517736,
            575262, 345158, 345158, 517736, 287632, 920418, 632788, 575262,
            575262, 517736, 474592, 460210, 373922, 604026, 517736, 747840,
            518830, 546500, 460212, 575262,1150524, 575262, 575262, 575262
        }
    },
    {   "cmti9", -1133866567, 9437184, { // 27432510671 9.00
            675111, 880299, 825280, 745017, 715243, 800036, 770261, 825280,
            770261, 825280, 770261, 660224, 605205, 632715, 949072, 962827,
            330112, 357621, 550187, 550187, 550187, 550187, 550187, 892272,
            495168, 577696, 770261, 770261, 550187, 950204,1060242, 825280,
            275093, 330112, 553422, 880299, 824267, 880299, 825280, 330112,
            440149, 440149, 550187, 825280, 330112, 385131, 330112, 550187,
            550187, 550187, 550187, 550187, 550187, 550187, 550187, 550187,
            550187, 550187, 330112, 330112, 330112, 825280, 550187, 550187,
            825280, 800036, 757639, 770261, 812658, 730130, 702620, 832724,
            800036, 414905, 565074, 827545, 675111, 965092, 800036, 825280,
            730130, 825280, 785148, 605205, 770261, 800036, 800036,1075129,
            800036, 800036, 660224, 330112, 553422, 330112, 550187, 330112,
            330112, 550187, 495168, 495168, 550187, 495168, 330112, 495168,
            550187, 330112, 330112, 495168, 275093, 880299, 605205, 550187,
            550187, 495168, 453904, 440149, 357621, 577696, 495168, 715243,
            496786, 522677, 440149, 550187,1100373, 550187, 550187, 550187
        }
    },
    {   "cmtt10", -538297224, 10485760, { // 33772436170 10.0
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498
        }
    },
    {   "cmtt12", -544819884, 12582912, { // 33741532524 12.0
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580,
            539580, 539580, 539580, 539580, 539580, 539580, 539580, 539580
        }
    },
    {   "cmtt8", -549205389, 8388608, { // 33720745163 8.00
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064,
            557064, 557064, 557064, 557064, 557064, 557064, 557064, 557064
        }
    },
    {   "cmtt9", -542880256, 9437184, { // 33751047000 9.00
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496,
            550496, 550496, 550496, 550496, 550496, 550496, 550496, 550496
        }
    },
    {   "cmu10", 320884962, 10485760, { // 2310050342 10.0
            713614, 932069, 873814, 786432, 757306, 844686, 815560, 873814,
            815560, 873814, 815560, 699051, 640797, 669923,1004885,1019448,
            349525, 378653, 582542, 582542, 582542, 582542, 582542, 844686,
            524288, 611672, 815560, 815560, 582542,1004886,1121395, 873814,
            291270, 349525, 582542, 932069, 728178, 932069, 873814, 349525,
            466034, 466034, 582542, 873814, 349525, 407779, 349525, 582542,
            582542, 582542, 582542, 582542, 582542, 582542, 582542, 582542,
            582542, 582542, 349525, 349525, 349525, 873814, 582542, 582542,
            873814, 844686, 800997, 815560, 859251, 771869, 742742, 881096,
            844686, 436906, 597106, 873814, 713614,1019450, 844686, 873814,
            771869, 873814, 830123, 640797, 815560, 844686, 844686,1135958,
            844686, 844686, 699051, 349525, 582542, 349525, 582542, 349525,
            349525, 582542, 524288, 524288, 582542, 524288, 349526, 524288,
            582542, 349525, 349525, 524288, 291270, 932069, 640797, 582542,
            582542, 524288, 480598, 466034, 378653, 611670, 524288, 757306,
            533027, 553416, 466035, 582542,1165085, 582542, 582542, 582542
        }
    },
    {   "cmvtt10", -1029646951, 10485760, { // 30250152631 10.0
            672830, 917496, 856330, 733997, 733997, 795163, 795163, 856330,
            795163, 856330, 795163, 642248, 611664, 611664, 917496, 917496,
            305832, 336416, 550498, 550498, 550498, 550498, 550498, 795163,
            489331, 550499, 795163, 856330, 550498, 978662,1100995, 856330,
            305832, 305832, 550498, 917496, 550498, 917496, 856330, 305832,
            428165, 428165, 550498, 856330, 305832, 366998, 305832, 550498,
            550498, 550498, 550498, 550498, 550498, 550498, 550498, 550498,
            550498, 550498, 305832, 305832, 305832, 856330, 519915, 519915,
            733997, 795163, 764581, 795163, 825747, 733997, 703414, 856330,
            795163, 366998, 550498, 825747, 672830, 978662, 795163, 856330,
            733997, 856330, 795163, 611664, 795163, 795163, 795163,1100995,
            795163, 795163, 672830, 311659, 550498, 311659, 550498, 305832,
            305832, 535206, 611664, 489331, 611664, 489331, 336416, 550498,
            611664, 305832, 336416, 581082, 305832, 917496, 611664, 550498,
            611664, 581080, 428165, 434282, 428165, 611664, 581082, 795163,
            581082, 581082, 489331, 550498,1100995, 550498, 550498, 550498
        }
    },
    {   "euex10", 1644650801, 10485760, { // 14201660461 10.0
            0,      0,      0,      0,      0,      0,      0,      0,
            611672, 611672, 699053, 699053, 786434, 786434, 844691, 844691,
            0,      0,      0,      0,      0,      0,      0,      0,
            1048579,1048579,1048579,1048579,      0,      0,      0,      0,
            1048579,1048579, 524290, 524290,1048579,1048579,1048579,      0,
            1048579,1048579, 699053, 699053,1048579,1048579,1048579,      0,
            0,1048579,      0,      0,      0,      0,      0,      0,
            932070, 932070, 932070, 932070, 932070, 932070, 932070,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            553416, 466035,      0,      0,      0,      0,      0,      0,
            1106834,1106834, 553416,      0,      0,      0,      0,      0,
            1514614,1479661, 466035,      0,      0,      0,      0,      0,
            1106834,1479661,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0, 524290, 699053,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 471864, 471864, 471864, 471864,      0,      0
        }
    },
    {   "euex7", 1796464529, 7340032, { // 15304757621 7.00
            0,      0,      0,      0,      0,      0,      0,      0,
            693854, 693854, 790597, 790597, 887339, 887339, 951840, 951840,
            0,      0,      0,      0,      0,      0,      0,      0,
            1177573,1177573,1177573,1177573,      0,      0,      0,      0,
            1177573,1177573, 597109, 597109,1177573,1177573,1177573,      0,
            1177573,1177573, 790597, 790597,1177573,1177573,1177573,      0,
            0,1177573,      0,      0,      0,      0,      0,      0,
            1048581,1048581,1048581,1048581,1048581,1048581,1048581,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            629355, 532613,      0,      0,      0,      0,      0,      0,
            1242069,1242069, 629355,      0,      0,      0,      0,      0,
            1693541,1654843, 532613,      0,      0,      0,      0,      0,
            1242069,1654843,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0, 597109, 790597,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 488510, 488510, 488510, 488510,      0,      0
        }
    },
    {   "euex8", 604371431, 8388608, { // 4401374747 8.00
            0,      0,      0,      0,      0,      0,      0,      0,
            649908, 649908, 742752, 742752, 835596, 835596, 897492, 897492,
            0,      0,      0,      0,      0,      0,      0,      0,
            1114128,1114128,1114128,1114128,      0,      0,      0,      0,
            1114128,1114128, 557064, 557064,1114128,1114128,1114128,      0,
            1114128,1114128, 742752, 742752,1114128,1114128,1114128,      0,
            0,1114128,      0,      0,      0,      0,      0,      0,
            990336, 990336, 990336, 990336, 990336, 990336, 990336,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            588012, 495168,      0,      0,      0,      0,      0,      0,
            1176024,1176024, 588012,      0,      0,      0,      0,      0,
            1609296,1572158, 495168,      0,      0,      0,      0,      0,
            1176024,1572158,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0, 557064, 742752,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 471864, 471864, 471864, 471864,      0,      0
        }
    },
    {   "euex9", -2032658551, 9437184, { // 20666013611 9.00
            0,      0,      0,      0,      0,      0,      0,      0,
            628658, 628658, 718464, 718464, 808274, 808274, 868144, 868144,
            0,      0,      0,      0,      0,      0,      0,      0,
            1077696,1077696,1077696,1077696,      0,      0,      0,      0,
            1077696,1077696, 538848, 538848,1077696,1077696,1077696,      0,
            1077696,1077696, 718464, 718464,1077696,1077696,1077696,      0,
            0,1077696,      0,      0,      0,      0,      0,      0,
            957952, 957952, 957952, 957952, 957952, 957952, 957952,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            568784, 478976,      0,      0,      0,      0,      0,      0,
            1137568,1137570, 568784,      0,      0,      0,      0,      0,
            1556672,1520748, 478976,      0,      0,      0,      0,      0,
            1137570,1520748,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0, 538848, 718464,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 471865, 471865, 471865, 471865,      0,      0
        }
    },
    {   "eufb10", -661254937, 10485760, { // 33045406347 10.0
            0, 615965, 412650, 406296, 621315, 412315, 416997,      0,
            1028280, 762098,      0,      0,      0,      0,      0,      0,
            0,      0, 265848, 265848,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 366168,      0,      0,      0,      0, 913581, 262504,
            481202, 481202, 343763, 936320, 343763, 936320, 343763, 621315,
            621315, 621315, 621315, 621315, 621315, 621315, 621315, 621315,
            621315, 621315, 267520, 267520,      0, 609946,      0, 448765,
            0, 888501,1094491, 758419,1029618, 820618, 756747, 972435,
            891845, 686523, 683848, 827640, 824630,1299478,1030286,1023933,
            1024602,1023933,1025270,1025939, 828309, 891845,1029283,1295131,
            890507,1031290, 745378, 269192,      0, 269192, 618640,      0,
            0, 632016, 618640, 486218, 617302, 494912, 407299, 623656,
            645392, 347442, 347776, 486552, 353126, 966082, 685520, 638704,
            633019, 624659, 481870, 548082, 412315, 617302, 633688, 962069,
            481202, 617637, 483542,      0,      0, 265848,      0, 568480
        }
    },
    {   "eufb5", -1562321527, 5242880, { // 24270156611 5.00
            0, 898656, 674912, 667920, 904544, 674544, 679696,      0,
            1352400,1059472,      0,      0,      0,      0,      0,      0,
            0,      0, 513360, 513360,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 623760,      0,      0,      0,      0,1226176, 509680,
            750352, 750352, 599104,1251200, 599104,1251200, 599104, 904544,
            904544, 904544, 904544, 904544, 904544, 904544, 904544, 904544,
            904544, 904544, 515200, 515200,      0, 892032,      0, 714656,
            0,1198576,1425264,1055424,1353872,1123872,1053584,1290944,
            1202256, 976304, 973360,1131600,1128288,1650848,1354608,1347616,
            1348352,1347616,1349088,1349824,1132336,1202256,1353504,1646064,
            1200784,1355712,1041072, 517040,      0, 517040, 901600,      0,
            0, 916320, 901600, 755872, 900128, 765440, 669024, 907120,
            931040, 603152, 603520, 756240, 609408,1283952, 975200, 923680,
            917424, 908224, 751088, 823952, 674544, 900128, 918160,1279536,
            750352, 900496, 752928,      0,      0, 513360,      0, 846400
        }
    },
    {   "eufb6", 953717986, 6291456, { // 7066112342 6.00
            0, 759696, 544059, 537320, 765371, 543704, 548669,      0,
            1197000, 914685,      0,      0,      0,      0,      0,      0,
            0,      0, 388360, 388360,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 494760,      0,      0,      0,      0,1075349, 384813,
            616765, 616765, 470997,1099467, 470997,1099467, 470997, 765371,
            765371, 765371, 765371, 765371, 765371, 765371, 765371, 765371,
            765371, 765371, 390133, 390133,      0, 753312,      0, 582363,
            0,1048749,1267224, 910784,1198419, 976752, 909011,1137771,
            1052296, 834531, 831693, 984200, 981008,1484635,1199128,1192389,
            1193099,1192389,1193808,1194517, 984909,1052296,1198064,1480024,
            1050877,1200192, 896952, 391907,      0, 391907, 762533,      0,
            0, 776720, 762533, 622085, 761115, 631307, 538384, 767853,
            790907, 474899, 475253, 622440, 480928,1131032, 833467, 783813,
            777784, 768917, 617475, 687699, 543704, 761115, 778493,1126776,
            616765, 761469, 619248,      0,      0, 388360,      0, 709333
        }
    },
    {   "eufb7", -1933153063, 7340032, { // 21461466331 7.00
            0, 695447, 488379, 481909, 700896, 488039, 492807,      0,
            1115371, 844277,      0,      0,      0,      0,      0,      0,
            0,      0, 338869, 338869,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 441040,      0,      0,      0,      0, 998555, 335463,
            558197, 558197, 418222,1021714, 418222,1021714, 418222, 700896,
            700896, 700896, 700896, 700896, 700896, 700896, 700896, 700896,
            700896, 700896, 340571, 340571,      0, 689317,      0, 525161,
            0, 973013,1182805, 840530,1116734, 903877, 838827,1058496,
            976418, 767307, 764583, 911029, 907963,1391575,1117415,1110944,
            1111625,1110944,1112306,1112987, 911710, 976418,1116393,1387147,
            975056,1118437, 827248, 342274,      0, 342274, 698171,      0,
            0, 711794, 698171, 563305, 696809, 572160, 482930, 703280,
            725417, 421968, 422309, 563646, 427758,1052025, 766286, 718606,
            712816, 704302, 558878, 626311, 488039, 696809, 713497,1047938,
            558197, 697150, 560581,      0,      0, 338869,      0, 647086
        }
    },
    {   "eufb8", -1314401225, 8388608, { // 26151752067 8.00
            0, 622596, 417092, 410670, 628004, 416754, 421486,      0,
            1039350, 770302,      0,      0,      0,      0,      0,      0,
            0,      0, 268710, 268710,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 370110,      0,      0,      0,      0, 923416, 265330,
            486382, 486382, 347464, 946400, 347464, 946400, 347464, 628004,
            628004, 628004, 628004, 628004, 628004, 628004, 628004, 628004,
            628004, 628004, 270400, 270400,      0, 616512,      0, 453596,
            0, 898066,1106274, 766584,1040702, 829452, 764894, 982904,
            901446, 693914, 691210, 836550, 833508,1313468,1041378,1034956,
            1035632,1034956,1036308,1036984, 837226, 901446,1040364,1309074,
            900094,1042392, 753402, 272090,      0, 272090, 625300,      0,
            0, 638820, 625300, 491452, 623948, 500240, 411684, 630370,
            652340, 351182, 351520, 491790, 356928, 976482, 692900, 645580,
            639834, 631384, 487058, 553982, 416754, 623948, 640510, 972426,
            486382, 624286, 488748,      0,      0, 268710,      0, 574600
        }
    },
    {   "eufb9", 1295088986, 9437184, { // 11514276532 9.00
            0, 615637, 412430, 406080, 620985, 412096, 416775,      0,
            1027733, 761692,      0,      0,      0,      0,      0,      0,
            0,      0, 265707, 265707,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 365973,      0,      0,      0,      0, 913095, 262364,
            480946, 480946, 343580, 935822, 343580, 935822, 343580, 620985,
            620985, 620985, 620985, 620985, 620985, 620985, 620985, 620985,
            620985, 620985, 267378, 267378,      0, 609621,      0, 448526,
            0, 888028,1093909, 758016,1029070, 820181, 756345, 971918,
            891371, 686158, 683484, 827200, 824192,1298788,1029739,1023388,
            1024057,1023388,1024725,1025394, 827868, 891371,1028736,1294443,
            890034,1030741, 744981, 269049,      0, 269049, 618311,      0,
            0, 631680, 618311, 485959, 616974, 494649, 407083, 623324,
            645049, 347257, 347591, 486293, 352939, 965568, 685156, 638364,
            632683, 624327, 481614, 547790, 412096, 616974, 633351, 961557,
            480946, 617308, 483285,      0,      0, 265707,      0, 568178
        }
    },
    {   "eufm10", -1893372238, 10485760, { // 21711267262 10.0
            521654, 522504, 349469, 345221, 527885, 349186, 350318, 525053,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 225144, 225144,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 310104,      0,      0,      0,      0, 773702, 222312,
            407525, 407525, 291130, 792960, 291130, 792960, 291130, 526186,
            526186, 526186, 526186, 526186, 526186, 526186, 526186, 526186,
            526186, 526186, 226560, 226560,      0, 792960,      0, 380054,
            0, 752462, 926914, 642298, 871973, 694973, 640882, 823546,
            755294, 581410, 579144, 700920, 698371,1100515, 872539, 867158,
            867725, 867158, 868291, 868858, 701486, 677131, 871690,1096834,
            754162, 873389, 631253, 291130,      0, 291130, 523920,      0,
            0, 524770, 538080, 408374, 522787, 419986, 342106, 528168,
            546576, 292546, 294528, 408374, 293112, 804005, 552240, 512592,
            524770, 512875, 408091, 464165, 349186, 542328, 536664, 811085,
            407525, 523070, 409507,      0,      0, 225144,      0, 396480
        }
    },
    {   "eufm5", -1194741804, 5242880, { // 27062327724 5.00
            828326, 829344, 622093, 617005, 835789, 621754, 623110, 832397,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 473184, 473184,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 574944,      0,      0,      0,      0,1130214, 469792,
            691629, 691629, 552218,1153280, 552218,1153280, 552218, 833754,
            833754, 833754, 833754, 833754, 833754, 833754, 833754, 833754,
            833754, 833754, 474880, 474880,      0,1153280,      0, 658726,
            0,1104774,1313722, 972826,1247917,1035917, 971130,1189914,
            1108166, 899898, 897184,1043040,1039987,1521651,1248595,1242150,
            1242829,1242150,1243507,1244186,1043718,1014547,1247578,1517242,
            1106810,1249613, 959597, 552218,      0, 552218, 831040,      0,
            0, 832058, 848000, 692646, 829683, 706554, 613274, 836128,
            858176, 553914, 556288, 692646, 554592,1166509, 864960, 817472,
            832058, 817811, 692307, 759469, 621754, 853088, 846304,1174989,
            691629, 830022, 694003,      0,      0, 473184,      0, 678400
        }
    },
    {   "eufm6", 1695972292, 6291456, { // 14505475704 6.00
            691152, 692120, 494971, 490131, 698251, 494648, 495939, 695024,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 353320, 353320,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 450120,      0,      0,      0,      0, 978325, 350093,
            561117, 561117, 428501,1000267, 428501,1000267, 428501, 696315,
            696315, 696315, 696315, 696315, 696315, 696315, 696315, 696315,
            696315, 696315, 354933, 354933,      0,1000267,      0, 529819,
            0, 954125,1152888, 828608,1090291, 888624, 826995,1035115,
            957352, 759235, 756653, 895400, 892496,1350683,1090936,1084805,
            1085451,1084805,1086096,1086741, 896045, 868296,1089968,1346488,
            956061,1091904, 816024, 428501,      0, 428501, 693733,      0,
            0, 694701, 709867, 562085, 692443, 575315, 486581, 698573,
            719547, 430115, 432373, 562085, 430760,1012851, 726000, 680827,
            694701, 681149, 561763, 625651, 494648, 714707, 708253,1020917,
            561117, 692765, 563376,      0,      0, 353320,      0, 548533
        }
    },
    {   "eufm7", 1491936770, 7340032, { // 13073223002 7.00
            625435, 626354, 439214, 434619, 632174, 438907, 440133, 629111,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 304754, 304754,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 396640,      0,      0,      0,      0, 898030, 301691,
            502002, 502002, 376119, 918857, 376119, 918857, 376119, 630336,
            630336, 630336, 630336, 630336, 630336, 630336, 630336, 630336,
            630336, 630336, 306286, 306286,      0, 918857,      0, 472293,
            0, 875058,1063730, 755913,1004311, 812882, 754382, 951936,
            878121, 690062, 687611, 819314, 816558,1251483,1004923, 999104,
            999717, 999104,1000329,1000942, 819927, 793586,1004005,1247502,
            876896,1005842, 743968, 376119,      0, 376119, 627886,      0,
            0, 628805, 643200, 502921, 626661, 515479, 431250, 632480,
            652389, 377650, 379794, 502921, 378263, 930802, 658514, 615634,
            628805, 615941, 502615, 563259, 438907, 647794, 641669, 938459,
            502002, 626967, 504146,      0,      0, 304754,      0, 490057
        }
    },
    {   "eufm8", 1553433125, 8388608, { // 13445701045 8.00
            541548, 542430, 362796, 358386, 548016, 362502, 363678, 545076,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 233730, 233730,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 321930,      0,      0,      0,      0, 803208, 230790,
            423066, 423066, 302232, 823200, 302232, 823200, 302232, 546252,
            546252, 546252, 546252, 546252, 546252, 546252, 546252, 546252,
            546252, 546252, 235200, 235200,      0, 823200,      0, 394548,
            0, 781158, 962262, 666792, 905226, 721476, 665322, 854952,
            784098, 603582, 601230, 727650, 725004,1142484, 905814, 900228,
            900816, 900228, 901404, 901992, 728238, 702954, 904932,1138662,
            782922, 906696, 655326, 302232,      0, 302232, 543900,      0,
            0, 544782, 558600, 423948, 542724, 436002, 355152, 548310,
            567420, 303702, 305760, 423948, 304290, 834666, 573300, 532140,
            544782, 532434, 423654, 481866, 362502, 563010, 557130, 842016,
            423066, 543018, 425124,      0,      0, 233730,      0, 411600
        }
    },
    {   "eufm9", -130813009, 9437184, { // 37014771657 9.00
            533771, 534640, 357586, 353239, 540146, 357296, 358455, 537248,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 230373, 230373,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0, 317307,      0,      0,      0,      0, 791673, 227476,
            416990, 416990, 297892, 811378, 297892, 811378, 297892, 538407,
            538407, 538407, 538407, 538407, 538407, 538407, 538407, 538407,
            538407, 538407, 231822, 231822,      0, 811378,      0, 388882,
            0, 769940, 948443, 657216, 892226, 711115, 655767, 842674,
            772837, 594914, 592596, 717200, 714592,1126076, 892805, 887300,
            887879, 887300, 888459, 889038, 717780, 692859, 891936,1122309,
            771678, 893675, 645915, 297892,      0, 297892, 536089,      0,
            0, 536958, 550578, 417860, 534930, 429740, 350052, 540436,
            559271, 299340, 301369, 417860, 299920, 822679, 565067, 524498,
            536958, 524788, 417570, 474946, 357296, 554924, 549129, 829924,
            416990, 535220, 419019,      0,      0, 230373,      0, 405689
        }
    },
    {   "eurb10", -1855621176, 10485760, { // 22131273710 10.0
            562362, 820872,1015560, 888888, 684216, 886080, 747240, 833040,
            1020864, 819624,1006512, 749424, 734136, 677352, 612456, 616200,
            549120, 683280, 680472, 371280, 611520, 625248, 677664, 669552,
            616512, 696696, 640536, 734136, 609024, 652080, 916032, 616200,
            861744,1020552, 557856, 670488, 978432,      0,      0, 856752,
            0,      0,      0,      0,      0,      0,      0,      0,
            577200, 577200, 577200, 577200, 577200, 577200, 577200, 577200,
            577200, 577200, 320736, 320736, 380640, 579696, 378768,      0,
            674544, 870168, 761592, 827736, 943800, 671736, 550992, 887016,
            898560, 483600, 479856, 784368, 650832,1214616, 967200, 925080,
            697320, 963768, 748800, 686400, 569675, 900432, 781698,1180365,
            773136, 612350, 769392,      0,      0,      0,      0,      0,
            430560, 697320, 706056, 575952, 706056, 643656, 451776, 690144,
            697008, 385008, 380640, 640848, 386568,1037088, 703560, 705744,
            694824, 704496, 521040, 522912, 458640, 702936, 572832, 964080,
            577200, 702624, 570960, 385008, 385008, 707304,      0,      0
        }
    },
    {   "eurb5", 706752412, 5242880, { // 5210027634 5.00
            868723,1168330,1393968,1247158,1009949,1243904,1082992,1182432,
            1400115,1166883,1383482,1085523,1067805,1001994, 926781, 931120,
            853376,1008864,1005610, 647264, 925696, 941606,1002355, 992954,
            931482,1024413, 959325,1067805, 922803, 972704,1278618, 931120,
            1215699,1399754, 863501, 994038,1350938,      0,      0,1209914,
            0,      0,      0,      0,      0,      0,      0,      0,
            885920, 885920, 885920, 885920, 885920, 885920, 885920, 885920,
            885920, 885920, 588685, 588685, 658112, 888813, 655942,      0,
            998739,1225462,1099626,1176285,1310800, 995485, 855546,1244989,
            1258368, 777440, 773101,1126022, 971258,1624669,1337920,1289104,
            1025136,1333942,1084800,1012480, 877200,1260538,1122928,1584973,
            1113005, 926659,1108666,      0,      0,      0,      0,      0,
            715968,1025136,1035261, 884474,1035261, 962941, 740557,1016819,
            1024774, 663174, 658112, 959686, 664982,1418918,1032368,1034899,
            1022243,1033453, 820832, 823002, 748512,1031645, 880858,1334304,
            885920,1031283, 878688, 663174, 663174,1036707,      0,      0
        }
    },
    {   "eurb6", -1573580899, 6291456, { // 24215207635 6.00
            734453,1023896,1241880,1100051, 870888,1096907, 941453,1037520,
            1247819,1022499,1231749, 943899, 926781, 863203, 790541, 794733,
            719627, 869840, 866696, 520507, 789493, 804864, 863552, 854469,
            795083, 884861, 821981, 926781, 786699, 834907,1130443, 794733,
            1069659,1247469, 729408, 855517,1200309,      0,      0,1064069,
            0,      0,      0,      0,      0,      0,      0,      0,
            751067, 751067, 751067, 751067, 751067, 751067, 751067, 751067,
            751067, 751067, 463915, 463915, 530987, 753861, 528891,      0,
            860059,1079091, 957523,1031581,1161533, 856915, 721723,1097955,
            1110880, 646267, 642075, 983024, 833509,1464755,1187733,1140573,
            885560,1183891, 943200, 873333, 742643,1112976, 980035,1426405,
            970448, 790424, 966256,      0,      0,      0,      0,      0,
            586880, 885560, 895341, 749669, 895341, 825475, 610635, 877525,
            885211, 535877, 530987, 822331, 537624,1265984, 892547, 894992,
            882765, 893595, 688187, 690283, 618320, 891848, 746176,1184240,
            751067, 891499, 744080, 535877, 535877, 896739,      0,      0
        }
    },
    {   "eurb7", 1231305095, 7340032, { // 11131034607 7.00
            681975, 964158,1176674,1038402, 814987,1035337, 883783, 977440,
            1182464, 962795,1166798, 886167, 869479, 807495, 736656, 740743,
            667520, 813966, 810901, 473394, 735634, 750619, 807835, 798981,
            741083, 828610, 767307, 869479, 732910, 779909,1068032, 740743,
            1008773,1182123, 677056, 800002,1136146,      0,      0,1003323,
            0,      0,      0,      0,      0,      0,      0,      0,
            698171, 698171, 698171, 698171, 698171, 698171, 698171, 698171,
            698171, 698171, 418222, 418222, 483611, 700896, 481568,      0,
            804430,1017968, 899449, 971650,1098343, 801365, 669563,1036359,
            1048960, 596000, 591913, 924311, 778546,1393959,1123886,1077909,
            829291,1120139, 885486, 817371, 689959,1051003, 921397,1356571,
            912050, 736542, 907963,      0,      0,      0,      0,      0,
            538103, 829291, 838827, 696809, 838827, 770713, 561262, 821458,
            828951, 488379, 483611, 767648, 490082,1200174, 836103, 838487,
            826567, 837125, 636869, 638912, 568754, 835422, 693403,1120480,
            698171, 835081, 691360, 488379, 488379, 840190,      0,      0
        }
    },
    {   "eurb8", -2144170547, 8388608, { // 20014506715 8.00
            598412, 873492,1080660, 945868, 728076, 942880, 795140, 886440,
            1086304, 872164,1071032, 797464, 781196, 720772, 651716, 655700,
            584320, 727080, 724092, 395080, 650720, 665328, 721104, 712472,
            656032, 741356, 681596, 781196, 648064, 693880, 974752, 655700,
            916984,1085972, 593616, 713468,1041152,      0,      0, 911672,
            0,      0,      0,      0,      0,      0,      0,      0,
            614200, 614200, 614200, 614200, 614200, 614200, 614200, 614200,
            614200, 614200, 341296, 341296, 405040, 616856, 403048,      0,
            717784, 925948, 810412, 880796,1004300, 714796, 586312, 943876,
            956160, 514600, 510616, 834648, 692552,1292476,1029200, 984380,
            742020,1025548, 796800, 730400, 606196, 958152, 831808,1256030,
            822696, 651606, 818712,      0,      0,      0,      0,      0,
            458160, 742020, 751316, 612872, 751316, 684916, 480736, 734384,
            741688, 409688, 405040, 681928, 411348,1103568, 748660, 750984,
            739364, 749656, 554440, 556432, 488040, 747996, 609552,1025880,
            614200, 747664, 607560, 409688, 409688, 752644,      0,      0
        }
    },
    {   "eurb9", -2099972077, 9437184, { // 20265174023 9.00
            573579, 837243,1035813, 906615, 697861, 903751, 762142, 849653,
            1041223, 835970,1026585, 764370, 748777, 690860, 624670, 628489,
            560071, 696907, 694043, 378684, 623716, 637717, 691179, 682905,
            628807, 710590, 653310, 748777, 621170, 665084, 934300, 628489,
            878930,1040905, 568981, 683860, 997945,      0,      0, 873838,
            0,      0,      0,      0,      0,      0,      0,      0,
            588711, 588711, 588711, 588711, 588711, 588711, 588711, 588711,
            588711, 588711, 327132, 327132, 388231, 591257, 386322,      0,
            687996, 887522, 776780, 844244, 962622, 685132, 561980, 904706,
            916480, 493244, 489426, 800011, 663812,1238839, 986489, 943529,
            711227, 982988, 763733, 700089, 581040, 918389, 797289,1203906,
            788555, 624565, 784736,      0,      0,      0,      0,      0,
            439147, 711227, 720137, 587438, 720137, 656492, 460786, 703908,
            710908, 392686, 388231, 653628, 394277,1057771, 717591, 719819,
            708681, 718546, 531431, 533340, 467787, 716955, 584256, 983307,
            588711, 716636, 582347, 392686, 392686, 721410,      0,      0
        }
    },
    {   "eurm10", 586924345, 10485760, { // 4276740471 10.0
            449405, 747931, 794376, 808253, 625022, 757843, 677981, 751046,
            873672, 737453, 918134, 690442, 694690, 638050, 525336, 576878,
            536947, 587357, 581126, 351168, 582259, 568099, 647678, 628421,
            579994, 638616, 574613, 634651, 538930, 615677, 762941, 604632,
            790978, 892363, 510043, 578861, 918418,      0,      0, 800323,
            0,      0,      0,      0,      0,      0,      0,      0,
            523920, 523920, 523920, 523920, 523920, 523920, 523920, 523920,
            523920, 523920, 291130, 291130, 792960, 526186, 792960,      0,
            587640, 807970, 687326, 749347, 868574, 634368, 523637, 802589,
            821280, 413472, 421685, 701203, 586224,1094851, 869990, 842237,
            604066, 869141, 638616, 584242, 516806, 811934, 677602,1034371,
            698371, 582101, 698938,      0,      0,      0,      0,      0,
            407242, 638616, 617093, 510610, 633235, 523920, 440376, 596419,
            651926, 377506, 348053, 582826, 383170, 960331, 696672, 590755,
            618226, 634934, 453120, 478042, 436978, 673733, 519672, 851582,
            551674, 622757, 493618, 349186, 348053, 633802,      0,      0
        }
    },
    {   "eurm5", 926664423, 5242880, { // 6716743347 5.00
            741798,1099347,1154976,1171597, 952134,1111219,1015565,1103078,
            1249952,1086797,1303206,1030490,1035578, 967738, 832736, 894470,
            846643, 907021, 899558, 624128, 900915, 883955, 979270, 956205,
            898202, 968416, 891757, 963667, 849018, 940941,1117325, 927712,
            1150906,1272339, 814419, 896845,1303546,      0,      0,1162099,
            0,      0,      0,      0,      0,      0,      0,      0,
            831040, 831040, 831040, 831040, 831040, 831040, 831040, 831040,
            831040, 831040, 552218, 552218,1153280, 833754,1153280,      0,
            907360,1171258,1026758,1101043,1243846, 963328, 830701,1164813,
            1187200, 698752, 708589,1043379, 905664,1514867,1245542,1212301,
            927034,1244525, 968416, 903290, 822528,1176006,1015117,1442432,
            1039987, 900730,1040666,      0,      0,      0,      0,      0,
            691290, 968416, 942637, 815098, 961971, 831040, 730976, 917875,
            984358, 655674, 620397, 901594, 662458,1353747,1037952, 911091,
            943994, 964006, 746240, 776090, 726906,1010477, 825952,1223494,
            864282, 949421, 794746, 621754, 620397, 962650,      0,      0
        }
    },
    {   "eurm6", -468944857, 6291456, { // 34403074047 6.00
            618896, 964648,1018440,1034512, 822296, 976128, 883632, 968256,
            1110280, 952512,1161776, 898064, 902984, 837384, 706840, 766536,
            720288, 778672, 771456, 505120, 772768, 756368, 848536, 826232,
            770144, 838040, 763912, 833448, 722584, 811472, 982032, 798680,
            1014504,1131928, 689128, 768832,1162104,      0,      0,1025328,
            0,      0,      0,      0,      0,      0,      0,      0,
            705200, 705200, 705200, 705200, 705200, 705200, 705200, 705200,
            705200, 705200, 435584, 435584,1016800, 707824,1016800,      0,
            779000,1034184, 894456, 966288,1104376, 833120, 704872,1027952,
            1049600, 577280, 586792, 910528, 777360,1366448,1106016,1073872,
            798024,1105032, 838040, 775064, 696960,1038776, 883192,1296400,
            907248, 772584, 907904,      0,      0,      0,      0,      0,
            570064, 838040, 813112, 689784, 831808, 705200, 608440, 789168,
            853456, 535624, 501512, 773424, 542184,1210648, 905280, 782608,
            814424, 833776, 623200, 652064, 604504, 878712, 700280,1084696,
            737344, 819672, 670104, 502824, 501512, 832464,      0,      0
        }
    },
    {   "eurm7", -88373412, 7340032, { // 37256703534 7.00
            571803, 909120, 961600, 977280, 770240, 920320, 830080, 912640,
            1051200, 897280,1101440, 844160, 848960, 784960, 657600, 715840,
            670720, 727680, 720640, 460800, 721920, 705920, 795840, 774080,
            719360, 785600, 713280, 781120, 672960, 759680, 926080, 747200,
            957760,1072320, 640320, 718080,1101760,      0,      0, 968320,
            0,      0,      0,      0,      0,      0,      0,      0,
            656000, 656000, 656000, 656000, 656000, 656000, 656000, 656000,
            656000, 656000, 392960, 392960, 960000, 658560, 960000,      0,
            728000, 976960, 840640, 910720,1045440, 780800, 655680, 970880,
            992000, 531200, 540480, 856320, 726400,1301120,1047040,1015680,
            746560,1046080, 785600, 724160, 647963, 981440, 829653,1232782,
            853120, 721742, 853760,      0,      0,      0,      0,      0,
            524160, 785600, 761280, 640960, 779520, 656000, 561600, 737920,
            800640, 490560, 457280, 722560, 496960,1149120, 851200, 731520,
            762560, 781440, 576000, 604160, 557760, 825280, 651200,1026240,
            687360, 767680, 621760, 458560, 457280, 780160,      0,      0
        }
    },
    {   "eurm8", 2026293814, 8388608, { // 17061545066 8.00
            485588, 808146, 858330, 873324, 675342, 818856, 732564, 811512,
            944010, 796824, 992052, 746028, 750618, 689418, 567630, 623322,
            580176, 634644, 627912, 379440, 629136, 613836, 699822, 679014,
            626688, 690030, 620874, 685746, 582318, 665244, 824364, 653310,
            854658, 964206, 551106, 625464, 992358,      0,      0, 864756,
            0,      0,      0,      0,      0,      0,      0,      0,
            566100, 566100, 566100, 566100, 566100, 566100, 566100, 566100,
            566100, 566100, 314568, 314568, 856800, 568548, 856800,      0,
            634950, 873018, 742662, 809676, 938502, 685440, 565794, 867204,
            887400, 446760, 455634, 757656, 633420,1182996, 940032, 910044,
            652698, 939114, 690030, 631278, 558416, 877302, 732156,1117648,
            754596, 628966, 755208,      0,      0,      0,      0,      0,
            440028, 690030, 666774, 551718, 684216, 566100, 475830, 644436,
            704412, 407898, 376074, 629748, 414018,1037646, 752760, 638316,
            667998, 686052, 489600, 516528, 472158, 727974, 561510, 920142,
            596088, 672894, 533358, 377298, 376074, 684828,      0,      0
        }
    },
    {   "eurm9", -1792823819, 9437184, { // 22510726765 9.00
            462663, 769998, 817813, 832100, 643463, 780203, 697984, 773205,
            899449, 759211, 945223, 710812, 715186, 656875, 540836, 593899,
            552789, 604686, 598272, 361529, 599438, 584860, 666788, 646962,
            597106, 657458, 591566, 653376, 554830, 633842, 785451, 622471,
            814315, 918692, 525092, 595940, 945515,      0,      0, 823936,
            0,      0,      0,      0,      0,      0,      0,      0,
            539378, 539378, 539378, 539378, 539378, 539378, 539378, 539378,
            539378, 539378, 299719, 299719, 816356, 541710, 816356,      0,
            604978, 831808, 707605, 771456, 894201, 653084, 539086, 826268,
            845511, 425671, 434126, 721892, 603520,1127154, 895659, 867086,
            621888, 894784, 657458, 601479, 532053, 835890, 697593,1064889,
            718976, 599275, 719559,      0,      0,      0,      0,      0,
            419257, 657458, 635300, 525675, 651918, 539378, 453369, 614016,
            671161, 388644, 358322, 600021, 394475, 988665, 717227, 608185,
            636466, 653668, 466489, 492146, 449870, 693611, 535004, 876708,
            567950, 641131, 508181, 359488, 358322, 652501,      0,      0
        }
    },
    {   "eusb10", -1332376429, 10485760, { // 26045306223 10.0
            896000,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            653440,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 810880,      0, 981120, 656960,      0,      0,
            917760, 928960, 906240, 713920, 984000, 720640, 792000, 716160,
            1048000, 590720, 599680, 975040, 847680,1163840, 917120, 838400,
            782720, 802560, 856320, 627840, 685760, 838080, 787520,1172160,
            849280, 713920, 778240,      0,      0,      0, 918400, 918400,
            0,      0,      0,      0,      0,      0, 379200, 379200,
            0,      0, 252800,      0,      0,      0, 594560,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            610240,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusb5", 689891563, 5242880, { // 5107564353 5.00
            1229440,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            955347,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,1133254,      0,1325626, 959325,      0,      0,
            1254029,1266685,1241011,1023690,1328880,1031283,1111920,1026221,
            1401200, 884474, 894598,1318755,1174838,1532099,1253306,1164352,
            1101434,1123853,1184602, 926419, 991869,1163990,1106858,1541501,
            1176646,1023690,1096371,      0,      0,      0,1254752,1254752,
            0,      0,      0,      0,      0,      0, 645456, 645456,
            0,      0, 502624,      0,      0,      0, 888813,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            906531,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusb6", -1896571298, 6291456, { // 21675117136 6.00
            1091200,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            824384,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 997568,      0,1184832, 828256,      0,      0,
            1115136,1127456,1102464, 890912,1188000, 898304, 976800, 893376,
            1258400, 755392, 765248,1178144,1038048,1385824,1114432,1027840,
            966592, 988416,1047552, 796224, 859936,1027488, 971872,1394976,
            1039808, 890912, 961664,      0,      0,      0,1115840,1115840,
            0,      0,      0,      0,      0,      0, 522720, 522720,
            0,      0, 383680,      0,      0,      0, 759616,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            776864,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusb7", -611365609, 7340032, { // 33343646427 7.00
            1028571,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            768686,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 937371,      0,1119771, 772457,      0,      0,
            1051886,1063886,1039543, 833486,1122857, 840686, 917143, 835886,
            1191429, 701486, 711086,1113257, 976800,1315543,1051200, 966857,
            907200, 928457, 986057, 741257, 803314, 966514, 912343,1324457,
            978514, 833486, 902400,      0,      0,      0,1052571,1052571,
            0,      0,      0,      0,      0,      0, 474857, 474857,
            0,      0, 339429,      0,      0,      0, 705600,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            722400,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusb8", 1734325818, 8388608, { // 14727733072 8.00
            935200,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            682028,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 846356,      0,1024044, 685702,      0,      0,
            957912, 969602, 945888, 745154,1027050, 752168, 826650, 747492,
            1093850, 616564, 625916,1017698, 884766,1214758, 957244, 875080,
            816964, 837672, 893784, 655308, 715762, 874746, 821974,1223442,
            886436, 745154, 812288,      0,      0,      0, 958580, 958580,
            0,      0,      0,      0,      0,      0, 395790, 395790,
            0,      0, 263860,      0,      0,      0, 620572,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            636938,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusb9", 512982202, 9437184, { // 3644676272 9.00
            910933,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            664331,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 824395,      0, 997472, 667909,      0,      0,
            933056, 944443, 921344, 725819,1000400, 732651, 805200, 728096,
            1065467, 600565, 609675, 991291, 861808,1183237, 932405, 852373,
            795765, 815936, 870592, 638304, 697189, 852048, 800645,1191696,
            863435, 725819, 791211,      0,      0,      0, 933707, 933707,
            0,      0,      0,      0,      0,      0, 385520, 385520,
            0,      0, 257013,      0,      0,      0, 604469,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            620411,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm10", 1280485294, 10485760, { // 11424523656 10.0
            792960,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            578294,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 717629,      0, 868291, 581410,      0,      0,
            812218, 807970, 798058, 631819, 870840, 637766, 680813, 633802,
            927480, 451704, 530717, 862910, 750197,1029998, 811651, 741984,
            692707, 694690, 757843, 568382, 615394, 748781, 696955,1037362,
            751613, 624739, 688742,      0,      0,      0, 812784, 812784,
            0,      0,      0,      0,      0,      0, 335592, 335592,
            0,      0, 223728,      0,      0,      0, 526186,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            540062,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm5", -1810016425, 5242880, { // 22407253527 5.00
            1153280,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            896166,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,1063053,      0,1243507, 899898,      0,      0,
            1176346,1171258,1159386, 960275,1246560, 967398,1018957, 962650,
            1314400, 744544, 839181,1237062,1102061,1437190,1175667,1092224,
            1033203,1035578,1111219, 884294, 940602,1100365,1038291,1446010,
            1103757, 951795,1028454,      0,      0,      0,1177024,1177024,
            0,      0,      0,      0,      0,      0, 605472, 605472,
            0,      0, 471488,      0,      0,      0, 833754,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            850374,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm6", -65501254, 6291456, { // 37406103672 6.00
            1016800,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            768176,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 929552,      0,1104048, 771784,      0,      0,
            1039104,1034184,1022704, 830168,1107000, 837056, 886912, 832464,
            1172600, 621560, 713072,1097816, 967272,1291336,1038448, 957760,
            900688, 902984, 976128, 756696, 811144, 965632, 905608,1299864,
            968912, 821968, 896096,      0,      0,      0,1039760,1039760,
            0,      0,      0,      0,      0,      0, 487080, 487080,
            0,      0, 357520,      0,      0,      0, 707824,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            723896,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm7", 1779696870, 7340032, { // 15205002346 7.00
            960000,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            717440,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 874880,      0,1045120, 720960,      0,      0,
            981760, 976960, 965760, 777920,1048000, 784640, 833280, 780160,
            1112000, 574400, 663680,1039040, 911680,1227840, 981120, 902400,
            846720, 848960, 920320, 706240, 759360, 910080, 851520,1236160,
            913280, 769920, 842240,      0,      0,      0, 982400, 982400,
            0,      0,      0,      0,      0,      0, 443200, 443200,
            0,      0, 316800,      0,      0,      0, 658560,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            674240,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm8", -1561757812, 8388608, { // 24272273614 8.00
            862400,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            628936,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 780472,      0, 944328, 632324,      0,      0,
            883344, 878724, 867944, 687148, 947100, 693616, 740432, 689304,
            1008700, 491260, 577192, 938476, 815892,1120196, 882728, 806960,
            753368, 755524, 824208, 618156, 669284, 814352, 757988,1128204,
            817432, 679448, 749056,      0,      0,      0, 883960, 883960,
            0,      0,      0,      0,      0,      0, 364980, 364980,
            0,      0, 243320,      0,      0,      0, 572264,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            587356,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "eusm9", 1977502424, 9437184, { // 16567445330 9.00
            826311,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            602617,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            0,      0, 747812,      0, 904811, 605863,      0,      0,
            846379, 841952, 831623, 658393, 907467, 664590, 709447, 660459,
            966489, 470702, 553038, 899204, 781749,1073319, 845788, 773191,
            721842, 723908, 789717, 592288, 641276, 780274, 726268,1080992,
            783225, 651015, 717710,      0,      0,      0, 846969, 846969,
            0,      0,      0,      0,      0,      0, 349707, 349707,
            0,      0, 233138,      0,      0,      0, 548316,      0,
            0,      0,      0,      0,      0,      0,      0,      0,
            562777,      0,      0,      0,      0,      0,      0,      0
        }
    },
    {   "msam10", -1749815603, 10485760, { // 22754767315 10.0
            815562, 815562, 815562, 815562, 815562, 291272, 699053, 699053,
            815562, 815562,1048579,1048579, 815562, 757307, 932070, 640798,
            1048579,1048579,1048579,1048579, 873816, 873816, 436909, 436909,
            436909, 436909,1165088,1165088,1048579,1048579, 524290, 524290,
            1048579,1456360,1048579,1048579, 815562, 815562, 815562, 815562,
            1165088, 699053, 699053, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            288358, 524290, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 815562, 815562, 990323, 524290,
            757307, 815562, 815562, 524290, 524290, 757307, 757307, 757307,
            815562, 815562, 815562, 815562, 815562, 786434,1048579,1048579,
            873816, 640798, 640798, 640798, 757307, 757307, 757307, 815562,
            815562, 815562, 815562, 815562, 699053, 699053, 797355, 797355,
            815562, 815562, 815562, 815562, 815562, 815562,1398106,1398106,
            524290, 524290, 992648, 946045, 699053, 815562, 815562, 815562,
            524290, 524290, 873816, 524290, 582544, 815562, 815562, 815562
        }
    },
    {   "msam5", 579411064, 5242880, { // 4242216170 5.00
            1135974,1135974,1135974,1135974,1135974, 480602, 990336, 990336,
            1135974,1135974,1427251,1427251,1135974,1063155,1281613, 917517,
            1427251,1427251,1427251,1427251,1208794,1208794, 662650, 662650,
            662650, 662650,1572890,1572890,1427251,1427251, 771878, 771878,
            1427251,1936986,1427251,1427251,1135974,1135974,1135974,1135974,
            1572890, 990336, 990336,1135974,1019469,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            462397, 655373,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1135974,1121395, 771878,
            917507,1135974,1135974, 655373, 655373, 917507, 917507, 917507,
            1135974,1135974,1135974,1135974,1135974,1086458,1427251,1427251,
            1208794, 917517, 917517, 917517,1063155,1063155,1063155,1135974,
            1135974,1135974,1135974,1135974, 990336, 990336,1084986,1084986,
            1135974,1135974,1135974,1135974,1135974,1135974,1864166,1864166,
            771878, 771878,1086458,1036941, 990336,1135974,1135974,1135974,
            771878, 771878,1208794, 771878, 844698,1135974,1135974,1135974
        }
    },
    {   "msam6", 205908534, 6291456, { // 1421365066 6.00
            1009733,1009733,1009733,1009733,1009733, 398069, 873808, 873808,
            1009733,1009733,1281584,1281584,1009733, 941771,1145659, 805845,
            1281584,1281584,1281584,1281584,1077696,1077696, 567976, 567976,
            567976, 567976,1417509,1417509,1281584,1281584, 669920, 669920,
            1281584,1757323,1281584,1281584,1009733,1009733,1009733,1009733,
            1417509, 873808, 873808,1009733, 951477,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            383507, 611664,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1009733,1058288, 669920,
            844688,1009733,1009733, 611664, 611664, 844688, 844688, 844688,
            1009733,1009733,1009733,1009733,1009733, 968955,1281584,1281584,
            1077696, 805845, 805845, 805845, 941771, 941771, 941771,1009733,
            1009733,1009733,1009733,1009733, 873808, 873808, 984739, 984739,
            1009733,1009733,1009733,1009733,1009733,1009733,1689360,1689360,
            669920, 669920,1058261,1009717, 873808,1009733,1009733,1009733,
            669920, 669920,1077696, 669920, 737883,1009733,1009733,1009733
        }
    },
    {   "msam7", -1200230857, 7340032, { // 27035367067 7.00
            936233, 936233, 936233, 936233, 936233, 355769, 807241, 807241,
            936233, 936233,1194217,1194217, 936233, 871737,1065225, 742745,
            1194217,1194217,1194217,1194217,1000729,1000729, 517010, 517010,
            517010, 517010,1323209,1323209,1194217,1194217, 613753, 613753,
            1194217,1645689,1194217,1194217, 936233, 936233, 936233, 936233,
            1323209, 807241, 807241, 936233, 902944, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            345365, 580464, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 936233, 936233,1029856, 613753,
            809321, 936233, 936233, 580464, 580464, 809321, 809321, 809321,
            936233, 936233, 936233, 936233, 936233, 900866,1194217,1194217,
            1000729, 742745, 742745, 742745, 871737, 871737, 871737, 936233,
            936233, 936233, 936233, 936233, 807241, 807241, 923333, 923333,
            936233, 936233, 936233, 936233, 936233, 936233,1581193,1581193,
            613753, 613753,1038169, 990318, 807241, 936233, 936233, 936233,
            613753, 613753,1000729, 613753, 678249, 936233, 936233, 936233
        }
    },
    {   "msam8", -1353038669, 8388608, { // 25726442263 8.00
            866544, 866544, 866544, 866544, 866544, 309480, 742752, 742752,
            866544, 866544,1114128,1114128, 866544, 804648, 990336, 680856,
            1114128,1114128,1114128,1114128, 928440, 928440, 464220, 464220,
            464220, 464220,1237920,1237920,1114128,1114128, 557064, 557064,
            1114128,1547400,1114128,1114128, 866544, 866544, 866544, 866544,
            1237920, 742752, 742752, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            302194, 557064, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 866544, 866544, 993964, 557064,
            768232, 866544, 866544, 557064, 557064, 768232, 768232, 768232,
            866544, 866544, 866544, 866544, 866544, 834504,1114128,1114128,
            928440, 680856, 680856, 680856, 804648, 804648, 804648, 866544,
            866544, 866544, 866544, 866544, 742752, 742752, 857068, 857068,
            866544, 866544, 866544, 866544, 866544, 866544,1485504,1485504,
            557064, 557064,1023100, 975768, 742752, 866544, 866544, 866544,
            557064, 557064, 928440, 557064, 618960, 866544, 866544, 866544
        }
    },
    {   "msam9", -743339001, 9437184, { // 32354306007 9.00
            838208, 838208, 838208, 838208, 838208, 299360, 718464, 718464,
            838208, 838208,1077696,1077696, 838208, 778336, 957952, 658592,
            1077696,1077696,1077696,1077696, 898080, 898080, 449040, 449040,
            449040, 449040,1197440,1197440,1077696,1077696, 538848, 538848,
            1077696,1496800,1077696,1077696, 838208, 838208, 838208, 838208,
            1197440, 718464, 718464, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            292889, 538848, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 838208, 838208, 991940, 538848,
            762160, 838208, 838208, 538848, 538848, 762160, 762160, 762160,
            838208, 838208, 838208, 838208, 838208, 808110,1077696,1077696,
            898080, 658592, 658592, 658592, 778336, 778336, 778336, 838208,
            838208, 838208, 838208, 838208, 718464, 718464, 826398, 826398,
            838208, 838208, 838208, 838208, 838208, 838208,1436928,1436928,
            538848, 538848,1008107, 961180, 718464, 838208, 838208, 838208,
            538848, 538848, 898080, 538848, 598720, 838208, 838208, 838208
        }
    },
    {   "msbm10", -2001332536, 10485760, { // 21055413310 10.0
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 815562, 815562, 932070, 932070,
            815562, 815562, 815562, 815562, 815562, 815562, 815562, 815562,
            815562, 815562, 815562, 815562, 524290, 291272, 233018, 407781,
            640798, 757307, 640798, 757307, 815562, 815562, 815562, 815562,
            1048579,1048579,1048579,1048579,1048579,1048579, 815562, 815562,
            582544, 757307, 699053, 757307, 757307, 699053, 640798, 815562,
            815562, 407781, 524290, 815562, 699053, 990325, 757307, 815562,
            640798, 815562, 757307, 582544, 699053, 757307, 757307,1048579,
            757307, 757307, 699053,1980650,2446685,1980650,2446685,      0,
            582544, 669925,      0,      0,      0,      0, 757307, 582544,
            815562, 699053, 466035, 699053, 815562, 815562, 815562, 815562,
            233018, 407781, 815562, 815562, 815562, 815562, 815562, 815562,
            1048579,1048579, 815562, 699053, 582544, 566525, 566525, 450016
        }
    },
    {   "msbm5", -34201321, 5242880, { // 37575420427 5.00
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974,1135974,1135974,1281613,1281613,
            1135974,1135974,1135974,1135974,1135974,1135974,1135974,1135974,
            1135974,1135974,1135974,1135974, 771878, 480602, 407782, 626240,
            917517,1063155, 917517,1063155,1135974,1135974,1135974,1135974,
            1427251,1427251,1427251,1427251,1427251,1427251,1135974,1135974,
            844698, 757286, 699034, 757286, 757286, 699034, 640781, 815539,
            815539, 407770, 524275, 815539, 699034, 990298, 757286, 815539,
            640781, 815539, 757286, 582528, 699034, 757286, 757286,1048550,
            757286, 757286, 699034,2592358,3174912,2592358,3174912,      0,
            844698, 953926,      0,      0,      0,      0,1063155, 844698,
            1135974, 990336, 699059, 990336,1135974,1135974,1135974,1135974,
            407782, 626240,1135974,1135974,1135974,1135974,1135974,1135974,
            1427251,1427251,1135974, 990336, 582528, 830134, 830134, 677213
        }
    },
    {   "msbm6", 1327105067, 6291456, { // 11706402053 6.00
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733,1009733,1009733,1145659,1145659,
            1009733,1009733,1009733,1009733,1009733,1009733,1009733,1009733,
            1009733,1009733,1009733,1009733, 669920, 398069, 330107, 533995,
            805845, 941771, 805845, 941771,1009733,1009733,1009733,1009733,
            1281584,1281584,1281584,1281584,1281584,1281584,1009733,1009733,
            737883, 757293, 699040, 757293, 757293, 699040, 640787, 815547,
            815547, 407773, 524280, 815547, 699040, 990307, 757293, 815547,
            640787, 815547, 757293, 582533, 699040, 757293, 757293,1048560,
            757293, 757293, 699040,2368987,2912688,2368987,2912688,      0,
            737883, 839827,      0,      0,      0,      0, 941771, 737883,
            1009733, 873808, 601957, 873808,1009733,1009733,1009733,1009733,
            330107, 533995,1009733,1009733,1009733,1009733,1009733,1009733,
            1281584,1281584,1009733, 873808, 582533, 723320, 723320, 582541
        }
    },
    {   "msbm7", 1903804545, 7340032, { // 16136340201 7.00
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 936233, 936233,1065225,1065225,
            936233, 936233, 936233, 936233, 936233, 936233, 936233, 936233,
            936233, 936233, 936233, 936233, 613753, 355769, 291273, 484761,
            742745, 871737, 742745, 871737, 936233, 936233, 936233, 936233,
            1194217,1194217,1194217,1194217,1194217,1194217, 936233, 936233,
            678249, 757298, 699045, 757298, 757298, 699045, 640791, 815552,
            815552, 407776, 524283, 815552, 699045, 990313, 757298, 815552,
            640791, 815552, 757298, 582537, 699045, 757298, 757298,1048567,
            757298, 757298, 699045,2226153,2742121,2226153,2742121,      0,
            678249, 774992,      0,      0,      0,      0, 871737, 678249,
            936233, 807241, 549257, 807241, 936233, 936233, 936233, 936233,
            291273, 484761, 936233, 936233, 936233, 936233, 936233, 936233,
            1194217,1194217, 936233, 807241, 582537, 663687, 663687, 531573
        }
    },
    {   "msbm8", 1892315340, 8388608, { // 16062470314 8.00
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 866544, 866544, 990336, 990336,
            866544, 866544, 866544, 866544, 866544, 866544, 866544, 866544,
            866544, 866544, 866544, 866544, 557064, 309480, 247584, 433272,
            680856, 804648, 680856, 804648, 866544, 866544, 866544, 866544,
            1114128,1114128,1114128,1114128,1114128,1114128, 866544, 866544,
            618960, 757302, 699048, 757302, 757302, 699048, 640794, 815556,
            815556, 407778, 524286, 815556, 699048, 990318, 757302, 815556,
            640794, 815556, 757302, 582540, 699048, 757302, 757302,1048572,
            757302, 757302, 699048,2104464,2599632,2104464,2599632,      0,
            618960, 711804,      0,      0,      0,      0, 804648, 618960,
            866544, 742752, 495168, 742752, 866544, 866544, 866544, 866544,
            247584, 433272, 866544, 866544, 866544, 866544, 866544, 866544,
            1114128,1114128, 866544, 742752, 582540, 604396, 604396, 478784
        }
    },
    {   "msbm9", -1442794143, 9437184, { // 25200132541 9.00
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 838208, 838208, 957952, 957952,
            838208, 838208, 838208, 838208, 838208, 838208, 838208, 838208,
            838208, 838208, 838208, 838208, 538848, 299360, 239488, 419104,
            658592, 778336, 658592, 778336, 838208, 838208, 838208, 838208,
            1077696,1077696,1077696,1077696,1077696,1077696, 838208, 838208,
            598720, 757305, 699051, 757305, 757305, 699051, 640796, 815559,
            815559, 407780, 524288, 815559, 699051, 990322, 757305, 815559,
            640796, 815559, 757305, 582542, 699051, 757305, 757305,1048576,
            757305, 757305, 699051,2035648,2514624,2035648,2514624,      0,
            598720, 688528,      0,      0,      0,      0, 778336, 598720,
            838208, 718464, 478976, 718464, 838208, 838208, 838208, 838208,
            239488, 419104, 838208, 838208, 838208, 838208, 838208, 838208,
            1077696,1077696, 838208, 718464, 582542, 583348, 583348, 462795
        }
    },
    {nullptr, 0, 0, {0}}
};


// End of cmfont-widths.cpp
