(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1260895,      29282]
NotebookOptionsPosition[   1235248,      28619]
NotebookOutlinePosition[   1236186,      28653]
CellTagsIndexPosition[   1236143,      28650]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Integration Utility Functions", "Title",
 CellChangeTimes->{{3.517247682581088*^9, 3.5172476842502913`*^9}},
 TextAlignment->Center],

Cell["\<\
In addition to the utility functions defined here, implementing a general \
purpose integrator based on the rules provided on this website requires \
defining system dependent functions for simplifying and expanding \
mathematical expressions.\
\>", "Text",
 CellChangeTimes->{{3.5172482299184504`*^9, 3.5172483278086224`*^9}, {
  3.517248362799484*^9, 3.517248422859589*^9}, {3.5172484689420705`*^9, 
  3.517248597361496*^9}, {3.517248663443212*^9, 3.5172486643636136`*^9}, {
  3.517248698340473*^9, 3.5172487061248865`*^9}},
 FontFamily->"Arial Narrow",
 FontSize->16],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "TimeLimit", " ", "is", " ", "the", " ", "time", " ", "constraint", " ", 
    "in", " ", "seconds", " ", "on", " ", "some", " ", "potentially", " ", 
    "expensive", " ", 
    RowBox[{"routines", "."}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"NumberQ", "[", "TimeLimit", "]"}], "]"}], ",", " ", 
     RowBox[{"TimeLimit", "=", "1.0"}]}], "]"}], ";"}]}]], "Code",
 CellChangeTimes->{{3.527214364607917*^9, 3.527214446742061*^9}, {
  3.5272146212127676`*^9, 3.5272146824896755`*^9}}],

Cell[CellGroupData[{

Cell["Miscellaneous Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Note", ":", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Clear", "[", "func", "]"}], " ", "also", " ", "eliminates", 
      " ", "2"}], "-", 
     RowBox[{
     "D", " ", "display", " ", "of", " ", "functions", " ", "like", " ", 
      RowBox[{"Integrate", "."}]}]}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"ClearDownValues", "[", "func_Symbol", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\n", "  ", 
    RowBox[{
     RowBox[{"Unprotect", "[", "func", "]"}], ";", "\n", "  ", 
     RowBox[{
      RowBox[{"DownValues", "[", "func", "]"}], "=", 
      RowBox[{"{", "}"}]}], ";", "\n", "  ", 
     RowBox[{"Protect", "[", "func", "]"}]}], ")"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDownValues", "[", 
   RowBox[{"func_Symbol", ",", "lst_List"}], "]"}], " ", ":=", " ", 
  RowBox[{"(", "\n", "  ", 
   RowBox[{
    RowBox[{"Unprotect", "[", "func", "]"}], ";", "\n", "  ", 
    RowBox[{
     RowBox[{"DownValues", "[", "func", "]"}], "=", 
     RowBox[{"Take", "[", 
      RowBox[{"lst", ",", 
       RowBox[{"Min", "[", 
        RowBox[{"529", ",", 
         RowBox[{"Length", "[", "lst", "]"}]}], "]"}]}], "]"}]}], ";", "\n", 
    "  ", 
    RowBox[{"Scan", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{
         RowBox[{"ReplacePart", "[", 
          RowBox[{"#", ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
         "SetDelayed", ",", "0"}], "]"}], "]"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"lst", ",", 
        RowBox[{"Min", "[", 
         RowBox[{"529", ",", 
          RowBox[{"Length", "[", "lst", "]"}]}], "]"}]}], "]"}]}], "]"}], ";",
     "\n", "  ", 
    RowBox[{"Protect", "[", "func", "]"}]}], ")"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MoveDownValues", "[", 
      RowBox[{"func1", ",", "func2"}], "]"}], " ", "moves", " ", 
     RowBox[{"func1", "'"}], "s", " ", "DownValues", " ", "to", " ", 
     "func2"}], ",", " ", 
    RowBox[{"and", " ", "deletes", " ", "them", " ", "from", " ", 
     RowBox[{"func1", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MoveDownValues", "[", 
    RowBox[{"func1_Symbol", ",", "func2_Symbol"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"SetDownValues", "[", 
       RowBox[{"func2", ",", 
        RowBox[{"ReplaceAll", "[", 
         RowBox[{
          RowBox[{"DownValues", "[", "func1", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"func1", "->", "func2"}], "}"}]}], "]"}]}], "]"}], ";", 
      "\n", "  ", 
      RowBox[{"ClearDownValues", "[", "func1", "]"}]}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Map2", "[", 
   RowBox[{"func_", ",", "lst1_", ",", "lst2_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"ReapList", "[", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"func", "[", 
       RowBox[{
        RowBox[{"lst1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"lst2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "lst1", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ReapList", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{
        RowBox[{"Reap", "[", "u", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lst", "===", 
        RowBox[{"{", "}"}]}], ",", " ", "lst", ",", " ", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ReapList", ",", "HoldFirst"}], "]"}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MapAnd", "[", 
      RowBox[{"f", ",", "l"}], "]"}], " ", "applies", " ", "f", " ", "to", 
     " ", "the", " ", "elements", " ", "of", " ", "list", " ", "l", " ", 
     "until", " ", "False", " ", "is", " ", "returned"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "True"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"MapAnd", "[", 
     RowBox[{"f_", ",", "lst_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"f", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "lst"}],
        "]"}], ";", "True"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"MapAnd", "[", 
     RowBox[{"f_", ",", "lst_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "lst"}],
        "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MapOr", "[", 
      RowBox[{"f", ",", "l"}], "]"}], " ", "applies", " ", "f", " ", "to", 
     " ", "the", " ", "elements", " ", "of", " ", "list", " ", "l", " ", 
     "until", " ", "True", " ", "is", " ", "return"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MapOr", "[", 
    RowBox[{"f_", ",", "lst_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"f", "[", "#", "]"}], ",", 
          RowBox[{"Throw", "[", "True", "]"}], ",", "Null"}], "]"}], "]"}], 
       ",", "lst"}], "]"}], ";", "False"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", "is", " ", "a", " ", "sum"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"MapSum", "[", 
       RowBox[{"f", ",", "u", ",", "x"}], "]"}], " ", "applies", " ", "f", 
      " ", "to", " ", "the", " ", "terms", " ", "of", " ", "u"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "applies", " ", "f", " ", "to", " ", 
      RowBox[{"u", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"MapSum", "[", 
     RowBox[{"f_", ",", "u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"f", "[", 
          RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n",
       "  ", 
      RowBox[{"f", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Recognizer Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NotIntegrableQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True", " ", "if",
       " ", "u", " ", "is", " ", "definitely", " ", "not", " ", "integrable", 
      " ", "wrt", " ", "x"}], ";", " ", 
     RowBox[{
     "else", " ", "it", " ", "returns", " ", "\n", "\t", "False", " ", "if", 
      " ", "u", " ", "is"}]}], ",", " ", 
    RowBox[{"or", " ", "might", " ", "be"}], ",", " ", 
    RowBox[{"integrable", " ", "wrt", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NotIntegrableQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m_"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x"}]}], "]"}], "^", "n_"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegersQ", "[", 
         RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
        RowBox[{"m", "<", "0"}], " ", "&&", " ", 
        RowBox[{"n", "<", "0"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"f_", "[", 
        RowBox[{
         RowBox[{"x", "^", "m_."}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x"}]}], "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"TrigQ", "[", "f", "]"}], " ", "||", " ", 
          RowBox[{"HyperbolicQ", "[", "f", "]"}]}], ")"}]}]}]}], 
     "]"}]}]}]}]], "Code"],

Cell[CellGroupData[{

Cell["Number Domains", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u1", ",", "u2", ",", "..."}], "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u1"}], ",", " ", "u2", ",", " ", 
    RowBox[{
     RowBox[{"...", " ", "are", " ", "all", " ", "0"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ZeroQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"Quiet", "[", 
     RowBox[{"PossibleZeroQ", "[", "u", "]"}], "]"}]}], "\n", 
   RowBox[{
    RowBox[{"NonzeroQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"Quiet", "[", 
      RowBox[{"PossibleZeroQ", "[", "u", "]"}], "]"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"ZeroQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ZeroQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.544296429998809*^9, 3.5442964317788115`*^9}, {
  3.5442965001789074`*^9, 3.544296507938918*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"OneQ", "[", 
      RowBox[{"u1", ",", "u2", ",", "..."}], "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u1"}], ",", " ", "u2", ",", " ", 
    RowBox[{
     RowBox[{"...", " ", "are", " ", "all", " ", "1"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"OneQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"u", "-", "1"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OneQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OneQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "a", " ", "real", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RealNumericQ", "[", "u_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"NumericQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"Im", "[", 
      RowBox[{"N", "[", "u", "]"}], "]"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ImaginaryNumericQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "an", " ", "imaginary", " ",
      "numeric", " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ImaginaryNumericQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"NumericQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"Re", "[", 
      RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PossibleZeroQ", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PositiveQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "positive", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], ">", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PositiveOrZeroQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "a", " ", "nonpositive", " ", 
     "numeric", " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveOrZeroQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], ">=", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"NegativeQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "negative", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], "<", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"NegativeQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "negative", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeOrZeroQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], "<=", "0"}]}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Number Types", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "..."}], "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "m"}], ",", " ", "n", ",", " ", 
    RowBox[{
     RowBox[{
     "...", " ", "are", " ", "all", " ", "explicit", " ", "integers"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegersQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"IntegerQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], "]"}]}], 
   ";"}]}]], "Code",
 CellChangeTimes->{{3.51967531541057*^9, 3.5196753311983123`*^9}, 
   3.519675560396833*^9, {3.5196756539682703`*^9, 3.5196756541395226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PositiveIntegerQ", "[", 
      RowBox[{"m", ",", "n", ",", "..."}], "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "m"}], ",", " ", "n", ",", " ", 
    RowBox[{
     RowBox[{
     "...", " ", "are", " ", "all", " ", "explicit", " ", "positive", " ", 
      "integers"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"PositiveIntegerQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerQ", "[", "#", "]"}], " ", "&&", " ", 
            RowBox[{"#", ">", "0"}]}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], "]"}]}], 
   ";"}]}]], "Code",
 CellChangeTimes->{{3.51967531541057*^9, 3.5196753311983123`*^9}, {
  3.5196754963445992`*^9, 3.5196755574442873`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"NegativeIntegerQ", "[", 
      RowBox[{"m", ",", "n", ",", "..."}], "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "m"}], ",", " ", "n", ",", " ", 
    RowBox[{
     RowBox[{
     "...", " ", "are", " ", "all", " ", "explicit", " ", "negative", " ", 
      "integers"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"NegativeIntegerQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerQ", "[", "#", "]"}], " ", "&&", " ", 
            RowBox[{"#", "<", "0"}]}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], "]"}]}], 
   ";"}]}]], "Code",
 CellChangeTimes->{{3.51967531541057*^9, 3.5196753311983123`*^9}, {
  3.5196754963445992`*^9, 3.5196755574442873`*^9}, {3.521146330581854*^9, 
  3.521146351033489*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionQ", "[", 
      RowBox[{"m", ",", "n", ",", "..."}], "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "m"}], ",", " ", "n", ",", " ", 
    RowBox[{
     RowBox[{
     "...", " ", "are", " ", "all", " ", "explicit", " ", "fractions"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionQ", "[", "u__", "]"}], " ", ":=", " ", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", "#", "]"}], "===", "Rational"}], ",", "Null", 
          ",", 
          RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5196754213859477`*^9, 3.51967542934982*^9}, 
   3.519675564973153*^9, {3.519675666128457*^9, 3.519675690818836*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"m", ",", "n", ",", "..."}], "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "m"}], ",", " ", "n", ",", " ", 
    RowBox[{
     RowBox[{
     "...", " ", "are", " ", "all", " ", "explicit", " ", "integers", " ", 
      "or", " ", "fractions"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RationalQ", "[", "u__", "]"}], " ", ":=", " ", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"IntegerQ", "[", "#", "]"}], " ", "||", " ", 
           RowBox[{
            RowBox[{"Head", "[", "#", "]"}], "===", "Rational"}]}], ",", 
          "Null", ",", 
          RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5196753866691647`*^9, 3.5196754020469007`*^9}, {
   3.5196754336061354`*^9, 3.5196754528901815`*^9}, 3.5196755628393707`*^9, {
   3.519675695060151*^9, 3.5196757200167847`*^9}, {3.526940996692387*^9, 
   3.526941000692393*^9}, {3.527197102082358*^9, 3.5271971023323584`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionOrNegativeQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "fraction", " ", 
     "or", " ", "negative", " ", "number"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionOrNegativeQ", "[", "u__", "]"}], " ", ":=", " ", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"FractionQ", "[", "#", "]"}], " ", "||", " ", 
           RowBox[{
            RowBox[{"IntegerQ", "[", "#", "]"}], " ", "&&", " ", 
            RowBox[{"#", "<", "0"}]}]}], ",", "Null", ",", 
          RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", "u", "}"}]}], "]"}], ";", " ", "True"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5196755682682037`*^9, 3.5196756086613245`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"SqrtNumberQ", "[", "u", "]"}], " ", "returns", " ", "True", " ",
      "if", " ", 
     RowBox[{"u", "^", "2"}], " ", "is", " ", "a", " ", "rational", " ", 
     "number"}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"m_", "^", "n_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"SqrtNumberQ", "[", "m", "]"}]}], " ", "||", " ", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "-", 
        RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "m", "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"u_", "*", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"SqrtNumberQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"SqrtNumberQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{"u", "===", "I"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.519789328494759*^9, 3.519789337558375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SqrtNumberSumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"Rest", "[", "u", "]"}], "]"}]}], " ", "||", " ", "\n", "  ", 
   RowBox[{
    RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"SqrtNumberSumQ", "[", 
     RowBox[{"Rest", "[", "u", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5224555435721245`*^9, 3.52245557589217*^9}, {
   3.5224556099042187`*^9, 3.5224556285542445`*^9}, 3.522621567622011*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "returns", " ", 
      "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "real"}], "-", 
     RowBox[{"valued", " ", "algebraic", " ", "number", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "rational", " ", "number"}], ",", "\n", "   ", 
        RowBox[{
        "an", " ", "algebraic", " ", "number", " ", "raised", " ", "to", " ", 
         "an", " ", "integer", " ", "power"}], ",", " ", 
        RowBox[{
        "a", " ", "positive", " ", "algebraic", " ", "number", " ", "raised", 
         " ", "to", " ", "a", " ", "\n", "   ", "fractional", " ", "power"}], 
        ",", " ", 
        RowBox[{
        "or", " ", "a", " ", "product", " ", "or", " ", "sum", " ", "of", " ",
          "algebraic", " ", "numbers"}]}], ")"}]}]}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"AlgebraicNumberQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"MapAnd", "[", 
       RowBox[{"AlgebraicNumberQ", ",", "u"}], "]"}], " ", "/;", "\n", 
      RowBox[{
       RowBox[{"ListQ", "[", "u", "]"}], "\n", "\n", 
       RowBox[{"AlgebraicNumberQ", "[", 
        RowBox[{"u_", "^", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "v", "]"}], " ", "||", " ", 
          RowBox[{
           RowBox[{"PositiveQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"FractionQ", "[", "v", "]"}]}]}], ")"}], "\n", "\n", 
        RowBox[{"AlgebraicNumberQ", "[", 
         RowBox[{"u_", "*", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"AlgebraicNumberQ", "[", "v", "]"}], "\n", "\n", 
         RowBox[{"AlgebraicNumberQ", "[", 
          RowBox[{"u_", "+", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"AlgebraicNumberQ", "[", "v", "]"}], "\n", "\n", 
          RowBox[{"AlgebraicNumberQ", "[", "u_", "]"}]}]}], " ", ":=", "\n", 
        "  ", 
        RowBox[{"RationalQ", "[", "u", "]"}]}]}]}]}]}], " ", "*)"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"NiceSqrtQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", "u", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"NiceSqrtAuxQ", "[", "u", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"NiceSqrtAuxQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"u", ">", "0"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"EvenQ", "[", 
       RowBox[{"u", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"NiceSqrtAuxQ", "[", 
          RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"NiceSqrtAuxQ", "[", 
          RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"NonsumQ", "[", "#", "]"}], " ", "&&", " ", 
             RowBox[{"NiceSqrtAuxQ", "[", "#", "]"}]}], "]"}], " ", "[", 
           RowBox[{"Simplify", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
          "False"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.518895055451686*^9, 3.518895292977703*^9}, {
   3.5188954440483685`*^9, 3.5188954457175713`*^9}, {3.5188954917376523`*^9, 
   3.518895608363457*^9}, 3.5188957501677065`*^9, {3.518895838089461*^9, 
   3.518895868509514*^9}, {3.518895906604781*^9, 3.518895915309596*^9}, {
   3.518896074991477*^9, 3.518896184238469*^9}, {3.5188970067187133`*^9, 
   3.518897028043951*^9}, {3.518897076014035*^9, 3.518897219471887*^9}, {
   3.518897275413585*^9, 3.5188973011848307`*^9}, {3.522379941654209*^9, 
   3.5223799708742495`*^9}, {3.522380003104295*^9, 3.522380013434309*^9}, {
   3.5223807284953103`*^9, 3.52238077074537*^9}, 3.527392849144123*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "u", " ", "is", " ", "a", " ", "rational", " ", "number", 
       " ", "whose", " ", "squareroot", " ", "is", " ", "rational", " ", "or",
        " ", "if", " ", "u", " ", "is", " ", "of", " ", "the", " ", "form", 
       " ", 
       RowBox[{"u1", "^", "n1"}], " ", 
       RowBox[{"u2", "^", "n2"}]}], " ", "..."}], " ", "\n", "\t", "and", " ",
      "n1"}], ",", " ", "n2", ",", " ", 
    RowBox[{"...", " ", "are", " ", "even"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PerfectSquareQ", "[", "u", "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PerfectSquareQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{
      RowBox[{"u", ">", "0"}], " ", "&&", " ", 
      RowBox[{"u", "\[NotEqual]", "1"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", 
       RowBox[{"Sqrt", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"EvenQ", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"PerfectSquareQ", "[", 
           RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"PerfectSquareQ", "[", 
           RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"NonsumQ", "[", "#", "]"}], " ", "&&", " ", 
              RowBox[{"PerfectSquareQ", "[", "#", "]"}]}], "]"}], " ", "[", 
            RowBox[{"Simplify", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
           "False"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.518895055451686*^9, 3.518895292977703*^9}, {
   3.5188954440483685`*^9, 3.5188954457175713`*^9}, {3.5188954917376523`*^9, 
   3.518895608363457*^9}, 3.5188957501677065`*^9, {3.518895838089461*^9, 
   3.518895868509514*^9}, {3.518895906604781*^9, 3.518895915309596*^9}, {
   3.518896074991477*^9, 3.518896184238469*^9}, {3.5188970067187133`*^9, 
   3.518897028043951*^9}, {3.518897076014035*^9, 3.518897219471887*^9}, {
   3.518897275413585*^9, 3.5188973011848307`*^9}, 3.522379938724205*^9, {
   3.527393208163151*^9, 3.5273932143059607`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "perfect", " ", "square"}], ",",
     " ", 
    RowBox[{
     RowBox[{"PerfectSquareRoot", "[", "u", "]"}], " ", "returns", " ", "the",
      " ", "squareroot", " ", "of", " ", 
     RowBox[{"u", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PerfectSquareRoot", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"Sqrt", "[", "u", "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "/", "2"}], ")"}]}], ",", "\n", 
        "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{
           RowBox[{"PerfectSquareRoot", "[", 
            RowBox[{"First", "[", "u", "]"}], "]"}], "*", 
           RowBox[{"PerfectSquareRoot", "[", 
            RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
            RowBox[{"PerfectSquareRoot", "[", 
             RowBox[{"Simplify", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
            "False"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], " ", 
   "*)"}]}]], "Code",
 CellChangeTimes->{{3.518895055451686*^9, 3.518895292977703*^9}, {
   3.5188954440483685`*^9, 3.5188954457175713`*^9}, {3.5188954917376523`*^9, 
   3.518895608363457*^9}, 3.5188957501677065`*^9, {3.518895838089461*^9, 
   3.518895868509514*^9}, {3.518895906604781*^9, 3.518895915309596*^9}, {
   3.518896074991477*^9, 3.518896184238469*^9}, {3.5188970067187133`*^9, 
   3.518897028043951*^9}, {3.518897076014035*^9, 3.518897495748372*^9}, {
   3.5189007153256273`*^9, 3.518900720645237*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Types", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FalseQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"u", "===", "False"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotFalseQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"u", "=!=", "False"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Plus"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NonsumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "=!=", "Plus"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Times"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Power"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IntegerPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PositiveIntegerPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ">", "0"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FractionalPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RationalPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SqrtQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "===", 
     RowBox[{"1", "/", "2"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "===", "E"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ImaginaryQ", "[", "u_", "]"}], " ", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\\\n", "  ", "Head"}], "[", "u", "]"}], "===", "Complex"}], " ",
    "&&", " ", 
   RowBox[{
    RowBox[{"Re", "[", "u", "]"}], "===", "0"}]}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FractionalPowerFreeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"AtomQ", "[", 
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
      "False", ",", "\n", "  ", 
      RowBox[{"Catch", "[", 
       RowBox[{
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FractionalPowerFreeQ", "[", "#", "]"}], ",", "Null", 
             ",", 
             RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}],
          "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexFreeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{
     RowBox[{"Head", "[", "u", "]"}], "=!=", "Complex"}], ",", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ComplexFreeQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "True"}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Log"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SinQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sin"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CosQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cos"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TanQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Tan"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CotQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cot"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SecQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sec"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CscQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Csc"}]}]}], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SinhQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sinh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CoshQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cosh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TanhQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Tanh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CothQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Coth"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SechQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sech"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CschQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Csch"}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"TrigQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", "if",
      " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ", "u", " ", 
     "is", " ", "a", " ", "trig", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"TrigQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sec", ",", "Csc"}], 
       "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseTrigQ", "[", "u", "]"}], " ", "returns", " ", "True", 
      " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ",
       "u", " ", "is", " ", "an", " ", "inverse", " ", "trig", " ", 
      "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"InverseTrigQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "ArcSin", ",", "ArcCos", ",", "ArcTan", ",", "ArcCot", ",", "ArcSec", 
        ",", "ArcCsc"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "returns", " ", "True", 
      " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ",
       "u", " ", "is", " ", "a", " ", "trig", " ", "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"HyperbolicQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sinh", ",", "Cosh", ",", "Tanh", ",", "Coth", ",", "Sech", ",", 
        "Csch"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseHyperbolicQ", "[", "u", "]"}], " ", "returns", " ", 
      "True", " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", 
      "of", " ", "u", " ", "is", " ", "an", " ", "inverse", " ", "trig", " ", 
      "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"InverseHyperbolicQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "ArcSinh", ",", "ArcCosh", ",", "ArcTanh", ",", "ArcCoth", ",", 
        "ArcSech", ",", "ArcCsch"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SinCosQ", "[", "f_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Sin", ",", "Cos", ",", "Sec", ",", "Csc"}], "}"}], ",", "f"}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SinhCoshQ", "[", "f_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Sinh", ",", "Cosh", ",", "Sech", ",", "Csch"}], "}"}], ",", 
    "f"}], "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CalculusFunctions", "=", 
    RowBox[{"{", 
     RowBox[{
     "D", ",", "Integrate", ",", "Sum", ",", "Product", ",", "Int", ",", 
      "Dif", ",", "Subst"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"CalculusQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "the", " ", "head", " ", "of", " ", "u", " ", "is", " ", "a", 
     " ", "calculus", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CalculusQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"MemberQ", "[", 
    RowBox[{"CalculusFunctions", ",", 
     RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CalculusFreeQ", "[", 
   RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "===", "x"}]}], " ", "||", " ", 
       RowBox[{"HeldFormQ", "[", "u", "]"}]}], ",", "\n", "    ", "False", 
      ",", "\n", "  ", 
      RowBox[{"Catch", "[", 
       RowBox[{
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"CalculusFreeQ", "[", 
              RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
             RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}],
          "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.53670226063268*^9, 3.5367022630538187`*^9}, 
   3.5367126961225557`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"HeldFormQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", 
     RowBox[{"Head", "[", "u", "]"}], "]"}], ",", "\n", "    ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Hold", ",", "HoldForm", ",", "Defer", ",", "Pattern"}], "}"}],
       ",", 
      RowBox[{"Head", "[", "u", "]"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"HeldFormQ", "[", 
     RowBox[{"Head", "[", "u", "]"}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.5367021949239216`*^9, 3.5367022440097294`*^9}, {
  3.536702347090625*^9, 3.5367023545240498`*^9}, {3.5367024024717927`*^9, 
  3.536702441400019*^9}, {3.536712528149948*^9, 3.5367125425757732`*^9}, {
  3.53671257329153*^9, 3.536712672121183*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "u", " ", "is", " ", "a", " ", "call", " ", "on", " ", 
     "an", " ", "inverse", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"LogQ", "[", "u", "]"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"InverseTrigQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Length", "[", "u", "]"}], "==", "1"}]}], " ", "||", " ", 
    RowBox[{"InverseHyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"Head", "[", "u", "]"}], "===", "Mods"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "free", " ", "of", " ", "inverse", " ", 
     "or", " ", "calculus", " ", "functions", " ", "involving", " ", "x"}], 
    ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "true"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"TrigHyperbolicFreeQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TrigQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Catch", "[", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"TrigHyperbolicFreeQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "free", " ", "of", " ", "inverse", " ", 
     "or", " ", "calculus", " ", "functions", " ", "involving", " ", "x"}], 
    ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "true"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", 
       RowBox[{"(*", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcTan"}], " ", "&&", 
            " ", 
            RowBox[{"TanQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcCot"}], " ", "&&", 
            " ", 
            RowBox[{"CotQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", "\n", 
           "       ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcTanh"}], " ", "&&", 
            " ", 
            RowBox[{"TanhQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcCoth"}], " ", "&&", 
            " ", 
            RowBox[{"CothQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ",", "\n", "      ", 
          RowBox[{"InverseFunctionFreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "x"}], "]"}], ","}],
          " "}], "*)"}], "\n", "    ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Catch", "[", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"InverseFunctionFreeQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ElementaryExpressionQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "sum"}], ",", " ",
     "product", ",", " ", 
    RowBox[{
     RowBox[{
     "or", " ", "power", " ", "and", " ", "all", " ", "the", " ", "operands", 
      "\n", "\t", "are", " ", "elementary", " ", "expressions"}], ";", " ", 
     RowBox[{
     "or", " ", "if", " ", "u", " ", "is", " ", "a", " ", "call", " ", "on", 
      " ", "a", " ", "trig"}]}], ",", " ", "hyperbolic", ",", " ", 
    RowBox[{
     RowBox[{
     "or", " ", "inverse", " ", "function", "\n", "\t", "and", " ", "all", 
      " ", "the", " ", "arguments", " ", "are", " ", "elementary", " ", 
      "expressions"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ElementaryFunctionQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SumQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"TrigQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"InverseFunctionQ", "[", "u", "]"}]}], ",", "\n", "    ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"ElementaryFunctionQ", "[", "#", "]"}], ",", "Null", 
               ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", "False"}], 
       "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", 
      "the", " ", "form"}], " ", "-", "v"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"NegativeCoefficientQ", "[", "u", "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeCoefficientQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", 
     RowBox[{"(*", "  ", 
      RowBox[{
       RowBox[{"MapAnd", "[", 
        RowBox[{"NegativeCoefficientQ", ",", "u"}], "]"}], ","}], " ", "*)"}],
      "\n", "    ", 
     RowBox[{"NegativeCoefficientQ", "[", 
      RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", " ", 
       RowBox[{
        RowBox[{"m_", "*", "v_."}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
         RowBox[{"m", "<", "0"}]}]}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Domains", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Real", "[", "u", "]"}], " ", "returns", " ", "True", " ", "if",
       " ", "u", " ", "is", " ", "a", " ", "real"}], "-", 
     RowBox[{"valued", " ", "quantity"}]}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"MapAnd", "[", 
      RowBox[{"RealQ", ",", "u"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ListQ", "[", "u", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"PossibleZeroQ", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], " ", "/;", "\n", 
     RowBox[{"NumericQ", "[", "u", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "^", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "v", "]"}], " ", "||", " ", 
       RowBox[{"PositiveOrZeroQ", "[", "u", "]"}]}], ")"}]}]}], "  ", "\n", 
   "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "*", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "+", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"f_", "[", "u_", "]"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sec", ",", "Csc", 
          ",", "ArcTan", ",", "ArcCot", ",", "Erf"}], "}"}], ",", "f"}], 
       "]"}], ",", "\n", "    ", 
      RowBox[{"RealQ", "[", "u", "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ArcSin", ",", "ArcCos"}], "}"}], ",", "f"}], "]"}], ",", 
        "\n", "    ", 
        RowBox[{"LE", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "u", ",", "1"}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"f", "===", "Log"}], ",", "\n", "    ", 
          RowBox[{"PositiveOrZeroQ", "[", "u", "]"}], ",", "\n", "  ", 
          "False"}], "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    "False"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "not", " ", "0", " ", "and", " ", "has", 
     " ", "a", " ", "positive", " ", "form"}], ",", " ", 
    RowBox[{
     RowBox[{"PosQ", "[", "u", "]"}], " ", "returns", " ", "True"}], ",", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PosQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", ">", "0"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PossibleZeroQ", "[", 
          RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], ">", "0"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"Re", "[", "u", "]"}], ">", "0"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"v", "=", 
             RowBox[{"N", "[", "u", "]"}]}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"PossibleZeroQ", "[", 
              RowBox[{"Re", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{
              RowBox[{"Im", "[", "v", "]"}], ">", "0"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"Re", "[", "v", "]"}], ">", "0"}]}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"PosQ", "[", 
              RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{"PosQ", "[", 
              RowBox[{"Rest", "[", "u", "]"}], "]"}], ",", "\n", "    ", 
             RowBox[{"Not", "[", 
              RowBox[{"PosQ", "[", 
               RowBox[{"Rest", "[", "u", "]"}], "]"}], "]"}]}], "]"}], ",", 
           "\n", 
           RowBox[{"(*", "  ", 
            RowBox[{
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"v", "=", 
                 RowBox[{"Together", "[", "u", "]"}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ProductQ", "[", "v", "]"}], ",", "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"PosQ", "[", 
                    RowBox[{"First", "[", "v", "]"}], "]"}], ",", "\n", 
                   "        ", 
                   RowBox[{"PosQ", "[", 
                    RowBox[{"Rest", "[", "v", "]"}], "]"}], ",", "\n", 
                   "      ", 
                   RowBox[{"Not", "[", 
                    RowBox[{"PosQ", "[", 
                    RowBox[{"Rest", "[", "v", "]"}], "]"}], "]"}]}], "]"}], 
                 ",", "\n", "    ", 
                 RowBox[{"PosQ", "[", "v", "]"}]}], "]"}]}], "]"}], ","}], 
            " ", "*)"}], "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"v", "=", 
                 RowBox[{"Together", "[", 
                  RowBox[{"Simplify", "[", 
                   RowBox[{"Together", "[", "u", "]"}], "]"}], "]"}]}], "}"}],
                ",", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "      ", 
                 RowBox[{"PosQ", "[", 
                  RowBox[{"First", "[", "v", "]"}], "]"}], ",", "\n", "    ", 
                 RowBox[{"PosQ", "[", "v", "]"}]}], "]"}]}], "]"}], ",", "\n",
              "  ", "True"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5494768760302525`*^9, 3.549477028440466*^9}, {
  3.549678194500057*^9, 3.54967820368007*^9}, {3.54968020179937*^9, 
  3.5496802416094255`*^9}, {3.549681548190767*^9, 3.5496815615907855`*^9}, {
  3.5538793781026955`*^9, 3.5538794347927747`*^9}, {3.55467502151584*^9, 
  3.554675048905878*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NegQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"PossibleZeroQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
     "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"PosQ", "[", "u", "]"}], "]"}]}], "]"}]}]], "Code"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Product Selector Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeadTerm", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"First", "[", "u", "]"}], ",", "\n", "  ", "u"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemainingTerms", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Rest", "[", "u", "]"}], ",", "\n", "  ", "0"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadFactor", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "leading", " ", "factor", " ", "of", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadFactor", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"LeadFactor", "[", 
      RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ImaginaryQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], "===", "1"}], ",", "\n", "      ", 
         "u", ",", "\n", "    ", 
         RowBox[{"LeadFactor", "[", 
          RowBox[{"Im", "[", "u", "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
       "u"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"RemainingFactors", "[", "u", "]"}], " ", "returns", " ", "the", 
    " ", "remaining", " ", "factors", " ", "of", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RemainingFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{
      RowBox[{"RemainingFactors", "[", 
       RowBox[{"First", "[", "u", "]"}], "]"}], "*", 
      RowBox[{"Rest", "[", "u", "]"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ImaginaryQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], "===", "1"}], ",", "\n", "      ", 
         "1", ",", "\n", "    ", 
         RowBox[{"I", "*", 
          RowBox[{"RemainingFactors", "[", 
           RowBox[{"Im", "[", "u", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
       "1"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadBase", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "base", " ", "of", " ", "the", " ", "leading", " ", "factor", " ", "of", 
    " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadBase", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"LeadFactor", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"v", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "  ", "v"}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadDegree", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "degree", " ", "of", " ", "the", " ", "leading", " ", "factor", " ", "of",
     " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadDegree", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"LeadFactor", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"v", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "\n", "  ", "1"}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"v", "^", "n"}], " ", "is", " ", "a", " ", "factor", " ", "of", 
     " ", "u"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FindFactor", "[", 
       RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"u", "/", 
         RowBox[{"v", "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"FindFactor", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "1"}], ",", "\n", "    ", "False", ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"LeadBase", "[", "u", "]"}], "===", "v"}], ",", "\n", "    ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LeadDegree", "[", "u", "]"}], ",", " ", 
          RowBox[{"RemainingFactors", "[", "u", "]"}]}], "}"}], ",", "\n", 
        "  ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lst", "=", 
            RowBox[{"FindFactor", "[", 
             RowBox[{
              RowBox[{"RemainingFactors", "[", "u", "]"}], ",", "v"}], 
             "]"}]}], "}"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "    ", "False", 
            ",", "\n", "  ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
              RowBox[{
               RowBox[{"LeadFactor", "[", "u", "]"}], "*", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}], "]"}]}],
        "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolic Relational Operators", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"LT", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], 
     "<", "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"LT", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "<", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"LT", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"LT", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"LT", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"LE", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], "<=",
      "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"LE", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "<=", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"LE", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"LE", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"LE", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], 
     ">", "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GT", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], ">", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GT", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"GT", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GE", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], ">=",
      "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GE", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], ">=", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GE", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"GE", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"GE", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Variable Dependence Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndependentQ", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"FreeQ", "[", 
   RowBox[{"u", ",", "x"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SplitFreeFactors", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list", 
    " ", 
    RowBox[{"{", 
     RowBox[{"v", ",", "w"}], "}"}], " ", "where", " ", "v", " ", "is", " ", 
    "the", " ", "product", " ", "of", " ", "the", " ", "factors", " ", "of", 
    " ", "u", " ", "free", " ", "of", " ", "x", "\n", "\t", "and", " ", "w", 
    " ", "is", " ", "the", " ", "product", " ", "of", " ", "the", " ", 
    "other", " ", 
    RowBox[{"factors", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compare", " ", "with", " ", "the", " ", "more", " ", "active", " ", 
    "function", " ", 
    RowBox[{"ConstantFactor", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SplitFreeFactors", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"#", ",", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"#", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "#"}], "}"}]}], "]"}], "]"}], ",", "u"}], "]"}], 
     ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"u", ",", "1"}], "}"}], ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SplitFreeTerms", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list", 
    " ", 
    RowBox[{"{", 
     RowBox[{"v", ",", "w"}], "}"}], " ", "where", " ", "v", " ", "is", " ", 
    "the", " ", "sum", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
    "u", " ", "free", " ", "of", " ", "x", "\n", "\t", "and", " ", "w", " ", 
    "is", " ", "the", " ", "sum", " ", "of", " ", "the", " ", "other", " ", 
    RowBox[{"terms", "."}]}], " ", "*)"}], "  ", "\n", 
  RowBox[{
   RowBox[{"SplitFreeTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"SplitFreeTerms", "[", 
         RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0"}], "}"}], ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"If", " ", "u", " ", 
       RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", "sum", " ", "of", 
       " ", "the", " ", "form", " ", "a"}], "+", 
      RowBox[{"b", "*", "v"}], "+", 
      RowBox[{"c", "*", "w"}], "+"}], "..."}], ",", " ", 
    RowBox[{
     RowBox[{"SplitFactorsOfTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      "\n", "\t", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "a"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "v"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "w"}], "}"}], ",", "..."}], "}"}]}], ",", " ", 
    RowBox[{"where", " ", "v"}], ",", " ", "w", ",", " ", 
    RowBox[{"...", " ", "are", " ", "regularized", " ", "wrt", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SplitFactorsOfTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"SplitFreeTerms", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ",", "v", ",", "w"}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"w", "=", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"(", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", "w", "]"}], ",", "\n", "      ", 
         RowBox[{"lst", "=", 
          RowBox[{"{", "}"}]}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "w", "]"}], ",", "\n", "      ", 
           RowBox[{
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"SplitFreeFactors", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
               RowBox[{"Apply", "[", 
                RowBox[{"List", ",", "w"}], "]"}]}], "]"}]}], ";", "\n", 
            "      ", 
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"Prepend", "[", 
                 RowBox[{
                  RowBox[{"SplitFreeFactors", "[", 
                   RowBox[{
                    RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "x"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], ",", 
               "lst"}], "]"}]}], ";", "\n", "      ", 
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
               "lst"}], "]"}]}]}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"lst", "=", 
             RowBox[{"SplitFreeFactors", "[", 
              RowBox[{"w", ",", "x"}], "]"}]}], ";", "\n", "    ", 
            RowBox[{"lst", "=", 
             RowBox[{"Prepend", "[", 
              RowBox[{
               RowBox[{"SplitFreeFactors", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "x"}], "]"}], ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", "\n", "    ", 
            RowBox[{"lst", "=", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "*", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "}"}]}]}]}], 
          "]"}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", "v", "]"}], ",", "\n", "    ", "lst", ",", "\n",
         "  ", 
        RowBox[{"Prepend", "[", 
         RowBox[{"lst", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "v"}], "}"}]}], "]"}]}], "]"}]}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Multinomial Functions", "Section",
 CellChangeTimes->{{3.540241889451598*^9, 3.5402418929148045`*^9}}],

Cell[CellGroupData[{

Cell["Multinomial Recognizer Functions", "Subsection",
 CellChangeTimes->{{3.5402418832271876`*^9, 3.5402418859103923`*^9}}],

Cell["\<\
LinearQ[u,x] returns True iff u is equivalent to an expression of the form \
a+b x where b is not 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}}],

Cell["\<\
LinearQ[u,x,True] returns True iff u is of the form a+b x where a and b are \
free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"LinearQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", " ", 
        RowBox[{
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}], "]"}], ",",
       "\n", "  ", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "\[Equal]", "1"}]}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{
  3.5284099883829727`*^9, {3.5355599867911577`*^9, 3.5355599938111696`*^9}, {
   3.535560062791291*^9, 3.5355601160185843`*^9}, {3.535560148950242*^9, 
   3.535560199993532*^9}, {3.5373803654510117`*^9, 3.537380366481013*^9}, {
   3.541276109881377*^9, 3.541276185481483*^9}, 3.5412765372919755`*^9}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.543434453325915*^9}],

Cell["\<\
QuadraticQ[u,x] returns True iff u is equivalent to an expression of the form \
a+b x+c x^2 or a+c x^2 where c is not 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, 3.5412765502119937`*^9, {3.541276596422058*^9, 
   3.541276606212072*^9}, {3.5412767729123054`*^9, 3.5412767787723136`*^9}}],

Cell["\<\
QuadraticQ[u,x,True] returns True iff u is of the form a+b x+c x^2 or a+c x^2 \
where a, b and c are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, 
   3.541276551411995*^9, {3.541276830622386*^9, 3.541276859752427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"QuadraticQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"QuadraticQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", " ", 
         RowBox[{
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x"}], "+", 
           RowBox[{"c_.", "*", 
            RowBox[{"x", "^", "2"}]}]}], " ", "/;", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}], 
        "]"}], " ", "||", " ", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", " ", 
         RowBox[{
          RowBox[{"a_.", "+", 
           RowBox[{"c_.", "*", 
            RowBox[{"x", "^", "2"}]}]}], " ", "/;", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}], "]"}]}], 
      ",", "\n", "  ", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "\[Equal]", "2"}]}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{
  3.5284099960084095`*^9, {3.535560239648802*^9, 3.5355602526436243`*^9}, {
   3.537380370071018*^9, 3.5373803710410194`*^9}, {3.5412766294421043`*^9, 
   3.541276648572131*^9}, {3.5412767035922084`*^9, 3.5412767100422173`*^9}, {
   3.5412769988526216`*^9, 3.5412769994926224`*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.5434344512043114`*^9}],

Cell["\<\
BinomialQ[u,x] returns True iff u is equivalent to an expression of the form \
a+b x^n where neither n or b is 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, {3.541277171092863*^9, 3.5412772311129465`*^9}}],

Cell["\<\
BinomialQ[u,x,True] returns True iff u is of the form a+b x^n where a, b and \
n are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}, 3.5412771723628645`*^9, {
   3.5412772604829884`*^9, 3.541277273833007*^9}}],

Cell["\<\
BinomialQ[u,x,n] returns True iff u is equivalent to an expression of the \
form a+b x^n where b is not 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}, 3.5412771723628645`*^9, {
   3.5412772604829884`*^9, 3.541277296213038*^9}, {3.541277345423107*^9, 
   3.5412773741831474`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinomialQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"BinomialQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"flag", "===", "False"}], ",", "\n", "    ", 
      RowBox[{"NotFalseQ", "[", 
       RowBox[{"BinomialTest", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"flag", "===", "True"}], ",", "\n", "    ", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", " ", 
          RowBox[{
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", 
             RowBox[{"x", "^", "n_."}]}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}],
          "]"}], ",", "\n", "  ", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"NotFalseQ", "[", "#", "]"}], " ", "&&", " ", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "===", "flag"}]}], "]"}], "[", 
         RowBox[{"BinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, 
   3.5284237300830417`*^9, {3.535560264811646*^9, 3.535560273984462*^9}, {
   3.541276914202503*^9, 3.541276972312585*^9}, {3.5412770134526424`*^9, 
   3.5412770349526725`*^9}, {3.541277089772749*^9, 3.541277146012828*^9}, 
   3.541277248302971*^9}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.543434449269908*^9}],

Cell["\<\
GeneralizedBinomialQ[u,x] returns True iff u is equivalent to an expression \
of the form a x^q+b x^n where neither n, q or b is 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, {3.541277171092863*^9, 3.5412772311129465`*^9}, {
   3.5434302561797433`*^9, 3.543430277629781*^9}, {3.5434303338990793`*^9, 
   3.543430334601081*^9}}],

Cell["\<\
GeneralizedBinomialQ[u,x,True] returns True iff u is of the form a x^q+b x^n \
where a, b, n and q are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}, 3.5412771723628645`*^9, {
   3.5412772604829884`*^9, 3.541277273833007*^9}, {3.543430257380945*^9, 
   3.5434303044930277`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneralizedBinomialQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GeneralizedBinomialQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"a_.", "*", 
           RowBox[{"x", "^", "q_."}]}], "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x", "^", "n_."}]}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "n", ",", "q"}], "}"}], ",", "x"}], 
          "]"}]}]}], "]"}], ",", "\n", "  ", 
      RowBox[{"NotFalseQ", "[", 
       RowBox[{"GeneralizedBinomialTest", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, 
   3.5284237300830417`*^9, {3.535560264811646*^9, 3.535560273984462*^9}, {
   3.541276914202503*^9, 3.541276972312585*^9}, {3.5412770134526424`*^9, 
   3.5412770349526725`*^9}, {3.541277089772749*^9, 3.541277146012828*^9}, 
   3.541277248302971*^9, {3.5434302226084843`*^9, 3.5434302315629*^9}, {
   3.5434303851295695`*^9, 3.543430463769308*^9}, {3.5434304956089635`*^9, 
   3.543430495796164*^9}, {3.543430533985031*^9, 3.5434306013147497`*^9}, {
   3.5434308396051683`*^9, 3.543430936325338*^9}, {3.5434309741710043`*^9, 
   3.5434310379751167`*^9}, {3.5434310883788047`*^9, 3.543431126817272*^9}, {
   3.5434311677673445`*^9, 3.543431230916255*^9}, {3.5434312714763265`*^9, 
   3.543431292895164*^9}, {3.5434349631036105`*^9, 3.543435013772499*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.543434446415103*^9}],

Cell["\<\
TrinomialQ[u,x] returns True iff u is equivalent to an expression of the form \
a+b x^n+c x^(2 n) or a+c x^2 where n\[NotEqual]0, n\[NotEqual]1, \
b\[NotEqual]0 and c\[NotEqual]0 and u is not of the form (d+e*x^n)^2.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, 3.5412765502119937`*^9, {3.541276596422058*^9, 
   3.541276606212072*^9}, {3.5412767729123054`*^9, 3.5412767787723136`*^9}, {
   3.5412776888135877`*^9, 3.5412777057036114`*^9}, {3.541277741043661*^9, 
   3.541277776913711*^9}}],

Cell["\<\
TrinomialQ[u,x,True] returns True iff u is of the form a+b x+c x^n or a+c \
x^(2 n) where a, b, c and n are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, 
   3.541276551411995*^9, {3.541276830622386*^9, 3.541276859752427*^9}, {
   3.541277689893589*^9, 3.5412777173336277`*^9}, {3.5412778233237762`*^9, 
   3.5412778294237843`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TrinomialQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"TrinomialQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", " ", 
        RowBox[{
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x", "^", "n_."}]}], "+", 
          RowBox[{"c_.", "*", 
           RowBox[{"x", "^", "j_."}]}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], 
           "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{"j", "-", 
            RowBox[{"2", "*", "n"}]}], "]"}]}]}]}], "]"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"NotFalseQ", "[", 
        RowBox[{"TrinomialTest", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"QuadraticQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"w_", "^", "2"}], " ", "/;", " ", 
           RowBox[{"BinomialQ", "[", 
            RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], "]"}]}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5355602860432835`*^9, 
   3.535560304669716*^9}, {3.5412776077634745`*^9, 3.5412776649835544`*^9}, 
   3.5412777920337324`*^9}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.543434457038721*^9}],

Cell["\<\
GeneralizedTrinomialQ[u,x] returns True iff u is equivalent to an expression \
of the form a x^q+b x^n+c x^(2 n-q) where neither n, q, b or c is 0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, {3.541277171092863*^9, 3.5412772311129465`*^9}, {
   3.5434302561797433`*^9, 3.543430277629781*^9}, {3.5434303338990793`*^9, 
   3.543430334601081*^9}, {3.5434313756377096`*^9, 3.543431376994912*^9}, {
   3.543431439332621*^9, 3.543431453544246*^9}}],

Cell["\<\
GeneralizedTrinomialQ[u,x,True] returns True iff u is of the form a x^q+b \
x^n+c x^(2 n-q) where a, b, c, n and q are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}, 3.5412771723628645`*^9, {
   3.5412772604829884`*^9, 3.541277273833007*^9}, {3.543430257380945*^9, 
   3.5434303044930277`*^9}, {3.5434313799589167`*^9, 3.5434314206905885`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneralizedTrinomialQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GeneralizedTrinomialQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"a_.", "*", 
           RowBox[{"x", "^", "q_."}]}], "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x", "^", "n_."}]}], "+", 
          RowBox[{"c_.", "*", 
           RowBox[{"x", "^", "r_."}]}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "q"}], "}"}], 
            ",", "x"}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{"r", "-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "n"}], "-", "q"}], ")"}]}], "]"}]}]}]}], 
       "]"}], ",", "\n", "  ", 
      RowBox[{"NotFalseQ", "[", 
       RowBox[{"GeneralizedTrinomialTest", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, 
   3.5284237300830417`*^9, {3.535560264811646*^9, 3.535560273984462*^9}, {
   3.541276914202503*^9, 3.541276972312585*^9}, {3.5412770134526424`*^9, 
   3.5412770349526725`*^9}, {3.541277089772749*^9, 3.541277146012828*^9}, 
   3.541277248302971*^9, {3.5434302226084843`*^9, 3.5434302315629*^9}, {
   3.5434303851295695`*^9, 3.543430463769308*^9}, {3.5434304956089635`*^9, 
   3.543430495796164*^9}, {3.543430533985031*^9, 3.5434306013147497`*^9}, {
   3.5434308396051683`*^9, 3.543430936325338*^9}, {3.5434309741710043`*^9, 
   3.5434310379751167`*^9}, {3.5434310883788047`*^9, 3.543431126817272*^9}, {
   3.5434311677673445`*^9, 3.543431230916255*^9}, {3.5434312714763265`*^9, 
   3.543431292895164*^9}, {3.5434313715505023`*^9, 3.5434313727361045`*^9}, {
   3.5434314827786975`*^9, 3.543431552089619*^9}, {3.543434306950858*^9, 
   3.5434343238924875`*^9}, {3.5434343733445745`*^9, 3.5434343873065987`*^9}}],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.5434344621399307`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "of", " ", "the", " ", "form", " ", "a", 
      "*", 
      RowBox[{"x", "^", "n"}], " ", "where", " ", "n"}], "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "a"}], "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"MonomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Catch", "[", 
      RowBox[{
       RowBox[{"Scan", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MonomialQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
            RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
        "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", " ", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"x", "^", "n_."}]}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.5355603136553316`*^9, 3.5355603208469443`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"u", "[", "x", "]"}], " ", "is", " ", "a", " ", "sum", " ", 
     "and", " ", "each", " ", "term", " ", "is", " ", "free", " ", "of", " ", 
     "x", " ", "or", " ", "an", " ", "expression", " ", "of", " ", "the", " ",
      "form", " ", "a", "*", 
     RowBox[{"x", "^", "n"}]}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"MonomialSumQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialSumQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"Catch", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], " ", "||", " ", 
            RowBox[{"MonomialQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}]}], ",", " ", "Null", ",", " ", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "\n", "    ", "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.528409984636759*^9, 3.5284236236228924`*^9, {3.52848798556281*^9, 
   3.5284880219728603`*^9}, {3.535136061688569*^9, 3.53513606379869*^9}, {
   3.5351361650414805`*^9, 3.5351361678196397`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "u", " ", "is", " ", "sum", " ", "whose", " ", "terms", " ", "are", " ", 
    RowBox[{"monomials", ".", "  ", 
     RowBox[{"MinimumExponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "exponent", " ", "of", " ", "the", " ", "term", " ", "having", " ", "the",
     " ", "smallest", " ", 
    RowBox[{"exponent", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MinimumMonomialExponent", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", "=", 
       RowBox[{"MonomialExponent", "[", 
        RowBox[{
         RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"PosQ", "[", 
            RowBox[{"n", "-", 
             RowBox[{"MonomialExponent", "[", 
              RowBox[{"#", ",", "x"}], "]"}]}], "]"}], ",", 
           RowBox[{"n", "=", 
            RowBox[{"MonomialExponent", "[", 
             RowBox[{"#", ",", "x"}], "]"}]}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "\n", "  ", "n"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535138661035001*^9, 3.535138894035327*^9}, {3.5351389529254093`*^9, 
   3.535139040225532*^9}, {3.535139384336014*^9, 3.5351394576761165`*^9}, {
   3.535139539646231*^9, 3.535139541146233*^9}, {3.5351396269663534`*^9, 
   3.535139676676423*^9}, {3.535139708136467*^9, 3.535139721776486*^9}, 
   3.535139760736541*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", 
    RowBox[{"monomial", ".", " ", 
     RowBox[{"MonomialExponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "exponent", " ", "of", " ", "x", " ", "in", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialExponent", "[", 
    RowBox[{
     RowBox[{"a_.", "*", 
      RowBox[{"x_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{"n", " ", "/;", " ", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Terms Functions", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "expression", " ", 
     "of", " ", "the", " ", "form", " ", "a", "*", 
     RowBox[{"x", "^", "n"}], " ", "where", " ", "n", " ", "is", " ", "zero", 
     " ", "or", " ", "a", " ", "positive", " ", "integer"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"PolynomialTermQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialTermQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "||", " ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x", "^", "n_."}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "0"}]}]}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", 
    RowBox[{"sum", ".", "  ", 
     RowBox[{"PolynomialTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "sum", " ", "of", " ", "the", " ", "polynomial", " ", "terms", " ", "of", 
    " ", "u", " ", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PolynomialTermQ", "[", 
         RowBox[{"#", ",", "x"}], "]"}], ",", "#", ",", "0"}], "]"}], "]"}], 
     ",", "u"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", 
    RowBox[{"sum", ".", "  ", 
     RowBox[{"NonpolynomialTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "sum", " ", "of", " ", "the", " ", "nonpolynomial", " ", "terms", " ", 
    "of", " ", "u", " ", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NonpolynomialTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PolynomialTermQ", "[", 
         RowBox[{"#", ",", "x"}], "]"}], ",", "0", ",", "#"}], "]"}], "]"}], 
     ",", "u"}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["BinomialTest", "Subsection",
 CellChangeTimes->{{3.5284096046241446`*^9, 3.528409606234147*^9}, {
  3.535139244555818*^9, 3.535139246575821*^9}, {3.5402387599074845`*^9, 
  3.5402387619978886`*^9}, {3.543434635752635*^9, 3.5434346386386404`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", 
    RowBox[{"binomial", ".", " ", 
     RowBox[{"BinomialDegree", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "degree", " ", "of", " ", "x", " ", "in", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"BinomialDegree", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"BinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "[", 
    RowBox[{"[", "3", "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, 
   3.540238683716951*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"If", " ", 
       RowBox[{"u", "[", "x", "]"}], " ", "is", " ", "equivalent", " ", "to", 
       " ", "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", 
       "a"}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}], " ", "where", " ", "n"}]}], "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "b"}], "\[NotEqual]", "0"}], ",", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"BinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"BinomialTest", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ZeroQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "      ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
       "False"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst", "=", 
           RowBox[{"CoefficientList", "[", 
            RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Length", "[", "lst", "]"}], "<", "2"}], ",", "\n", 
           "      ", "False", ",", "\n", "    ", 
           RowBox[{"Catch", "[", "\n", "      ", 
            RowBox[{
             RowBox[{"Scan", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"ZeroQ", "[", "#", "]"}], ",", "Null", ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
               RowBox[{"Drop", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"lst", ",", "1"}], "]"}], ",", 
                 RowBox[{"-", "1"}]}], "]"}]}], "]"}], ";", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"First", "[", "lst", "]"}], ",", 
               RowBox[{"Last", "[", "lst", "]"}], ",", 
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "-", "1"}]}], "}"}]}], 
            "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{
               RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", "\n",
              "      ", 
             RowBox[{
              RowBox[{"lst2", "=", 
               RowBox[{"BinomialTest", "[", 
                RowBox[{
                 RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
              "\n", "      ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "        ", 
                "False", ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], "*", 
                   RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], "*", 
                   RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
             "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "      ", 
               RowBox[{
                RowBox[{"lst1", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                 "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", "        ",
                   "False", ",", "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
               "\n", "    ", 
               RowBox[{
                RowBox[{"lst1", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                 "\n", "    ", 
                RowBox[{"lst2", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
                "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"FalseQ", "[", "lst1", "]"}], " ", "||", " ", 
                   RowBox[{"FalseQ", "[", "lst2", "]"}]}], ",", "\n", 
                  "      ", "False", ",", "\n", "    ", 
                  RowBox[{"Module", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
                    "}"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"a", ",", "b", ",", "m"}], "}"}], "=", "lst1"}], 
                    ";", "\n", "    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"c", ",", "d", ",", "n"}], "}"}], "=", "lst2"}], 
                    ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", "a", "]"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", "c", "]"}], ",", "\n", "        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"m", "+", "n"}]}], "}"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{"m", "+", "n"}], "]"}], ",", "\n", "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"b", "*", "c"}], ",", "m"}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}]}], "]"}], ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", "c", "]"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{"m", "+", "n"}], "]"}], ",", "\n", "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"a", "*", "d"}], ",", "n"}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}], ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{"m", "-", "n"}], "]"}], " ", "&&", " ", 
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"a", "*", "d"}], "+", 
                    RowBox[{"b", "*", "c"}]}], "]"}]}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a", "*", "c"}], ",", 
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"2", "*", "m"}]}], "}"}], ",", "\n", "    ", 
                    "False"}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
                 "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "      ", 
               RowBox[{
                RowBox[{"lst2", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
                "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "        ",
                   "False", ",", "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"FreeQ", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "      ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "      ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", 
                    "        ", "False", ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "+", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
                 "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "    ", 
                  RowBox[{"lst2", "=", 
                   RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                   "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst1", "]"}], " ", "||", " ", 
                    RowBox[{"FalseQ", "[", "lst2", "]"}]}], ",", "\n", 
                    "      ", "False", ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}], ",", "\n", 
                    "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "    ", "False"}], "]"}]}], "]"}]}]}], "]"}]}], "]"}], 
             ",", "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5284096378541913`*^9, 3.5284096395841937`*^9}, {
   3.528409678354248*^9, 3.528409681194252*^9}, {3.528411951146551*^9, 
   3.5284120065266285`*^9}, 3.5284120621867065`*^9, {3.528412134076807*^9, 
   3.52841216484685*^9}, {3.5284124238372126`*^9, 3.5284124394972343`*^9}, {
   3.5284124765572863`*^9, 3.528412501877322*^9}, {3.528412575487425*^9, 
   3.5284126104374743`*^9}, {3.5284128880178623`*^9, 
   3.5284129807179923`*^9}, {3.528413142728219*^9, 3.528413201558302*^9}, {
   3.528413258108381*^9, 3.528413382818555*^9}, {3.528413421158609*^9, 
   3.5284134252886147`*^9}, {3.528413484088697*^9, 3.528413484368697*^9}, {
   3.528413528598759*^9, 3.528413674068963*^9}, {3.5284139794893904`*^9, 
   3.528413979749391*^9}, {3.5284140367894707`*^9, 3.528414058149501*^9}, {
   3.52841479323053*^9, 3.52841486490063*^9}, {3.528414904070685*^9, 
   3.5284149296507206`*^9}, 3.52841496476077*^9, {3.528415106040968*^9, 
   3.528415198131097*^9}, {3.528415290461226*^9, 3.5284152907212267`*^9}, {
   3.528415701741802*^9, 3.528415719821827*^9}, {3.528415853962015*^9, 
   3.5284159467021446`*^9}, {3.5284159965022144`*^9, 3.528416056822299*^9}, {
   3.5284160949523525`*^9, 3.528416206942509*^9}, {3.5284162378325524`*^9, 
   3.5284163752327447`*^9}, {3.528420123967993*^9, 3.528420131538004*^9}, {
   3.5284223680711346`*^9, 3.528422373721143*^9}, {3.528484669402379*^9, 
   3.5284846763911915`*^9}, {3.533148805354947*^9, 3.5331488055649476`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["GeneralizedBinomialTest", "Subsection",
 CellChangeTimes->{{3.5284096046241446`*^9, 3.528409606234147*^9}, {
   3.535139244555818*^9, 3.535139246575821*^9}, {3.5402387599074845`*^9, 
   3.5402387744935102`*^9}, {3.5434329168636165`*^9, 3.5434329239460287`*^9}, 
   3.543434662927883*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
      "generalized", " ", "binomial", " ", "of", " ", "the", " ", "form", " ",
       "a", "*", 
      RowBox[{"x", "^", "q"}]}], " ", "+", " ", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}], " ", "where", " ", "a"}]}], ",", " ", "b", ",",
     " ", "n", ",", " ", 
    RowBox[{"and", " ", "q", " ", "not", " ", "equal", " ", "0"}], ",", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"GeneralizedBinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "n"}], "-", 
     RowBox[{"q", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"GeneralizedBinomialDegree", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "-", 
      RowBox[{"#", "[", 
       RowBox[{"[", "4", "]"}], "]"}]}], "]"}], "[", 
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, {
   3.5402386649969177`*^9, 3.54023866610452*^9}, {3.5402387010017815`*^9, 
   3.5402387271630273`*^9}, {3.5434329846457353`*^9, 
   3.5434330352834244`*^9}, {3.543433083503109*^9, 3.543433099040736*^9}, {
   3.5434333207795258`*^9, 3.5434333307791433`*^9}, {3.543433431804921*^9, 
   3.5434334699157877`*^9}, {3.543434663785885*^9, 3.5434347006955495`*^9}, {
   3.543434932948757*^9, 3.54343493444636*^9}, 3.5434433177304335`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
      "generalized", " ", "binomial", " ", "of", " ", "the", " ", "form", " ",
       "a", "*", 
      RowBox[{"x", "^", "q"}]}], " ", "+", " ", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}], " ", "where", " ", "a"}]}], ",", " ", "b", ",",
     " ", "n", ",", " ", 
    RowBox[{"and", " ", "q", " ", "not", " ", "equal", " ", "0"}], ",", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"GeneralizedBinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n", ",", "q"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "q_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n", ",", "q"}], "}"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "n", ",", "q"}], "}"}], ",", "x"}], 
       "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"n", "-", "q"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"GeneralizedBinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
          RowBox[{"a", "*", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"GeneralizedBinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], "}"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"m", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"BinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", "m"}], "}"}], " ", "/;",
         "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"m", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    "False"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, {
   3.5402386649969177`*^9, 3.54023866610452*^9}, {3.5402387010017815`*^9, 
   3.5402387271630273`*^9}, {3.543432473240037*^9, 3.543432480993251*^9}, {
   3.5434325123181057`*^9, 3.543432613187883*^9}, {3.5434326440759373`*^9, 
   3.5434327168656654`*^9}, {3.5434330591826663`*^9, 
   3.5434330677470813`*^9}, {3.5434332967554836`*^9, 
   3.5434332985182867`*^9}, {3.5434333529935827`*^9, 3.543433422039304*^9}, {
   3.543433484486213*^9, 3.543433499275039*^9}, {3.543433541894314*^9, 
   3.5434335792251797`*^9}, {3.5434336139976406`*^9, 3.543433757689493*^9}, {
   3.5434338110259867`*^9, 3.543433888090122*^9}, {3.5434339330494013`*^9, 
   3.5434340578340206`*^9}, {3.5434341832582407`*^9, 
   3.5434342053946795`*^9}, {3.543434665704688*^9, 3.543434670088296*^9}, {
   3.5434347358736115`*^9, 3.543434850362212*^9}, {3.54344288664983*^9, 
   3.54344288701983*^9}, {3.543442931989893*^9, 3.5434429373199005`*^9}, {
   3.543442971879949*^9, 3.543442973299951*^9}, {3.543443021420018*^9, 
   3.5434430444200506`*^9}, {3.543443080660101*^9, 3.543443136320179*^9}, {
   3.5434432725703697`*^9, 3.5434432914403963`*^9}, {3.543443346420473*^9, 
   3.543443467260642*^9}, {3.543443525920725*^9, 3.5434435962408233`*^9}, {
   3.5434440150614095`*^9, 3.5434440224414196`*^9}, {3.5434441049115353`*^9, 
   3.543444119861556*^9}, {3.5434441588216105`*^9, 3.5434441598616123`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["TrinomialTest", "Subsection",
 CellChangeTimes->{{3.5284096046241446`*^9, 3.528409606234147*^9}, {
  3.535139244555818*^9, 3.535139246575821*^9}, {3.5402387599074845`*^9, 
  3.5402387744935102`*^9}, {3.5434329288912373`*^9, 3.5434329312312417`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
       "trinomial", " ", "of", " ", "the", " ", "form", " ", "a"}], " ", "+", 
      " ", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}]}], " ", "+", " ", 
      RowBox[{"c", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}], " ", "where", " ", "n"}]}], 
     "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"b", "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "c"}], "\[NotEqual]", "0"}], ",", " ", 
    "\n", "\t", 
    RowBox[{
     RowBox[{"TrinomialDegree", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", 
     RowBox[{"n", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"TrinomialDegree", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"TrinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "[", 
    RowBox[{"[", "4", "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, {
   3.5402386649969177`*^9, 3.54023866610452*^9}, {3.5402387010017815`*^9, 
   3.5402387271630273`*^9}, {3.543433141987612*^9, 3.543433184216886*^9}, {
   3.543433231079368*^9, 3.543433262154623*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
       "trinomial", " ", "of", " ", "the", " ", "form", " ", "a"}], " ", "+", 
      " ", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}]}], " ", "+", " ", 
      RowBox[{"c", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"2", "*", "n"}], ")"}]}], " ", "where", " ", "n"}]}], 
     "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"b", "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "c"}], "\[NotEqual]", "0"}], ",", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"TrinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"TrinomialTest", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"CoefficientList", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "lst", "]"}], "<", "3"}], " ", "||", " ", 
          RowBox[{"EvenQ", "[", 
           RowBox[{"Length", "[", "lst", "]"}], "]"}], " ", "||", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{"lst", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "+", "1"}], ")"}], "/", 
              "2"}], "]"}], "]"}], "]"}]}], ",", "\n", "      ", "False", ",",
          "\n", "    ", 
         RowBox[{"Catch", "[", "\n", "      ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"ZeroQ", "[", "#", "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             RowBox[{"Drop", "[", 
              RowBox[{
               RowBox[{"Drop", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"lst", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Length", "[", "lst", "]"}], "+", "1"}], ")"}], 
                    "/", "2"}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
               RowBox[{"-", "1"}]}], "]"}]}], "]"}], ";", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"First", "[", "lst", "]"}], ",", 
             RowBox[{"lst", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Length", "[", "lst", "]"}], "+", "1"}], ")"}], "/",
                 "2"}], "]"}], "]"}], ",", 
             RowBox[{"Last", "[", "lst", "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "-", "1"}], ")"}], "/", 
              "2"}]}], "}"}]}], "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", "2"}], "]"}], ",", "\n", 
         "      ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"BinomialTest", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "}"}], 
           ",", "\n", "      ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "        ", 
             "False", ",", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], ",", 
               RowBox[{"2", "*", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "*", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], 
         ",", "\n", "    ", "False"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{
               RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", "\n",
              "      ", 
             RowBox[{
              RowBox[{"lst2", "=", 
               RowBox[{"TrinomialTest", "[", 
                RowBox[{
                 RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
              "\n", "      ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "        ", 
                "False", ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], "*", 
                   RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], "*", 
                   RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], "*", 
                   RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
             "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "      ", 
               RowBox[{
                RowBox[{"lst1", "=", 
                 RowBox[{"TrinomialTest", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                 "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", "        ",
                   "False", ",", "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
               "\n", "    ", 
               RowBox[{
                RowBox[{"lst1", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                 "\n", "    ", 
                RowBox[{"lst2", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
                "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"FalseQ", "[", "lst1", "]"}], " ", "||", " ", 
                   RowBox[{"FalseQ", "[", "lst2", "]"}]}], ",", "\n", 
                  "      ", "False", ",", "\n", "    ", 
                  RowBox[{"Module", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
                    "}"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"a", ",", "b", ",", "m"}], "}"}], "=", "lst1"}], 
                    ";", "\n", "    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"c", ",", "d", ",", "n"}], "}"}], "=", "lst2"}], 
                    ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{"m", "-", "n"}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"a", "*", "d"}], "+", 
                    RowBox[{"b", "*", "c"}]}], "]"}]}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a", "*", "c"}], ",", 
                    RowBox[{
                    RowBox[{"a", "*", "d"}], "+", 
                    RowBox[{"b", "*", "c"}]}], ",", 
                    RowBox[{"b", "*", "d"}], ",", "m"}], "}"}], ",", "\n", 
                    "    ", "False"}], "]"}]}]}], "]"}]}], "]"}]}]}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "      ", 
               RowBox[{
                RowBox[{"lst2", "=", 
                 RowBox[{"TrinomialTest", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
                "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "        ",
                   "False", ",", "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"FreeQ", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "      ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"TrinomialTest", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "      ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", 
                    "        ", "False", ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "+", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "]"}]}], ",", 
                 "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"TrinomialTest", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", "      ", 
                    RowBox[{
                    RowBox[{"lst1", "=", 
                    RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                    ";", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", 
                    "        ", "False", ",", "\n", "      ", 
                    RowBox[{
                    RowBox[{"lst2", "=", 
                    RowBox[{"TrinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                     "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", 
                    "        ", 
                    RowBox[{
                    RowBox[{"lst2", "=", 
                    RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                     "\n", "        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", 
                    "          ", "False", ",", "\n", "        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"2", "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", "\n", 
                    "          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"2", "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}], ",", "\n", 
                    "          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "        ", "False"}], "]"}]}], "]"}]}], "]"}]}], ",", 
                    "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"2", "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}],
                     ",", "     ", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst2", "=", 
                    RowBox[{"TrinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                     "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "      ", 
                    RowBox[{
                    RowBox[{"lst2", "=", 
                    RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                     "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", 
                    "        ", "False", ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "-", 
                    RowBox[{"2", "*", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}]}], "]"}]}], "]"}]}], ",", 
                    "           ", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], "-", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ",", "\n", 
                    "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", "\n", 
                    "    ", "False"}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}],
               "]"}], ",", "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5284096378541913`*^9, 3.5284096395841937`*^9}, {
   3.528409678354248*^9, 3.528409681194252*^9}, {3.528411951146551*^9, 
   3.5284120065266285`*^9}, 3.5284120621867065`*^9, {3.528412134076807*^9, 
   3.52841216484685*^9}, {3.5284124238372126`*^9, 3.5284124394972343`*^9}, {
   3.5284124765572863`*^9, 3.528412501877322*^9}, {3.528412575487425*^9, 
   3.5284126104374743`*^9}, {3.5284128880178623`*^9, 
   3.5284129807179923`*^9}, {3.528413142728219*^9, 3.528413201558302*^9}, {
   3.528413258108381*^9, 3.528413382818555*^9}, {3.528413421158609*^9, 
   3.5284134252886147`*^9}, {3.528413484088697*^9, 3.528413484368697*^9}, {
   3.528413528598759*^9, 3.528413674068963*^9}, {3.5284139794893904`*^9, 
   3.528413979749391*^9}, {3.5284140367894707`*^9, 3.528414058149501*^9}, {
   3.52841479323053*^9, 3.52841486490063*^9}, {3.528414904070685*^9, 
   3.5284149296507206`*^9}, 3.52841496476077*^9, {3.528415106040968*^9, 
   3.528415198131097*^9}, {3.528415290461226*^9, 3.5284152907212267`*^9}, {
   3.528415701741802*^9, 3.528415719821827*^9}, {3.528415853962015*^9, 
   3.5284159467021446`*^9}, {3.5284159965022144`*^9, 3.528416056822299*^9}, {
   3.5284160949523525`*^9, 3.528416206942509*^9}, {3.5284162378325524`*^9, 
   3.5284163752327447`*^9}, {3.528418356955519*^9, 3.5284184240156136`*^9}, {
   3.528418521185749*^9, 3.5284185290657597`*^9}, {3.528418561925806*^9, 
   3.5284186274258976`*^9}, {3.5284189684263754`*^9, 
   3.5284189713963795`*^9}, {3.528419078556529*^9, 3.5284190980065565`*^9}, {
   3.528419163416648*^9, 3.5284191673566537`*^9}, {3.5284192216167297`*^9, 
   3.5284192221667304`*^9}, {3.5284193256568756`*^9, 
   3.5284193755369453`*^9}, {3.5284194444270415`*^9, 
   3.5284195270271573`*^9}, {3.5284196122372766`*^9, 3.5284196829473753`*^9}, 
   3.5284197681574945`*^9, {3.5284198076875505`*^9, 3.5284198305075817`*^9}, {
   3.5284199704277782`*^9, 3.5284200643179097`*^9}, {3.528420163968049*^9, 
   3.5284201881680827`*^9}, {3.5284202530581737`*^9, 
   3.5284202536781745`*^9}, {3.5284202940182314`*^9, 
   3.5284203129182577`*^9}, {3.528420398178377*^9, 3.52842040025838*^9}, {
   3.5284204314184237`*^9, 3.528420459758463*^9}, {3.5284205037085247`*^9, 
   3.528420505598527*^9}, {3.5284205791186304`*^9, 3.5284206108586745`*^9}, {
   3.5284206450487223`*^9, 3.528420653988735*^9}, {3.528420755608877*^9, 
   3.5284208314689837`*^9}, {3.52842088607906*^9, 3.52842097179918*^9}, {
   3.5284210033692245`*^9, 3.5284210850093384`*^9}, {3.5284211356794095`*^9, 
   3.5284213106296544`*^9}, {3.5284214001397796`*^9, 3.52842146460987*^9}, {
   3.528421497489916*^9, 3.5284215556999974`*^9}, {3.5284216225000906`*^9, 
   3.528421663890149*^9}, {3.5284216979401965`*^9, 3.5284217004802*^9}, {
   3.5284217701702976`*^9, 3.5284218372103915`*^9}, {3.5284218688704357`*^9, 
   3.52842194331054*^9}, {3.5284221193607864`*^9, 3.528422134420808*^9}, {
   3.528422179800871*^9, 3.5284221801508713`*^9}, {3.5284222448409624`*^9, 
   3.52842225731098*^9}, {3.5284222913710275`*^9, 3.528422343761101*^9}, {
   3.528422466571273*^9, 3.5284224758112855`*^9}, {3.5284228823618546`*^9, 
   3.5284228906718664`*^9}, 3.5284229253019147`*^9, {3.528422963531968*^9, 
   3.528422985421999*^9}, {3.528423055452097*^9, 3.528423110142174*^9}, 
   3.5284232593623824`*^9, {3.5284252862327213`*^9, 3.528425291652729*^9}, {
   3.528425326142777*^9, 3.5284253835728574`*^9}, {3.528425440362937*^9, 
   3.5284254787529907`*^9}, {3.52848481212703*^9, 3.5284848522659006`*^9}, {
   3.5284852577106123`*^9, 3.5284852641846237`*^9}, {3.5284854979354343`*^9, 
   3.5284854983722353`*^9}, {3.5284871518116426`*^9, 
   3.5284871520416427`*^9}, {3.5284894528857403`*^9, 3.528489459315749*^9}, {
   3.528489570365905*^9, 3.5284895734359093`*^9}, {3.543433201158516*^9, 
   3.5434332266021605`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["GeneralizedTrinomialTest", "Subsection",
 CellChangeTimes->{{3.5284096046241446`*^9, 3.528409606234147*^9}, {
  3.535139244555818*^9, 3.535139246575821*^9}, {3.5402387599074845`*^9, 
  3.5402387744935102`*^9}, {3.5434329168636165`*^9, 3.5434329239460287`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
       "generalized", " ", "trinomial", " ", "of", " ", "the", " ", "form", 
       " ", "a", "*", 
       RowBox[{"x", "^", "q"}]}], " ", "+", " ", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}]}], " ", "+", " ", 
      RowBox[{"c", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "q"}], ")"}]}], " ", "where", " ", 
       "n"}]}], "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"q", "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"b", "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "c"}], "\[NotEqual]", "0"}], ",", " ", 
    "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"GeneralizedTrinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "n"}], "-", 
     RowBox[{"q", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"GeneralizedTrinomialDegree", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "4", "]"}], "]"}], "-", 
      RowBox[{"#", "[", 
       RowBox[{"[", "5", "]"}], "]"}]}], "]"}], "[", 
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, {
   3.5402386649969177`*^9, 3.54023866610452*^9}, {3.5402387010017815`*^9, 
   3.5402387271630273`*^9}, {3.5434329846457353`*^9, 
   3.5434330352834244`*^9}, {3.543433083503109*^9, 3.543433099040736*^9}, {
   3.5434333207795258`*^9, 3.5434333307791433`*^9}, {3.543433431804921*^9, 
   3.5434334699157877`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
      "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "a", " ", 
       "generalized", " ", "trinomial", " ", "of", " ", "the", " ", "form", 
       " ", "a", "*", 
       RowBox[{"x", "^", "q"}]}], " ", "+", " ", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}]}], " ", "+", " ", 
      RowBox[{"c", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "q"}], ")"}]}], " ", "where", " ", 
       "n"}]}], "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"q", "\[NotEqual]", "0"}], ",", " ", 
    RowBox[{"b", "\[NotEqual]", 
     RowBox[{"0", " ", "and", " ", "c"}], "\[NotEqual]", "0"}], ",", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"GeneralizedTrinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "q"}], "}"}]}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "q_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "r_."}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "q"}], "}"}], " ", "/;",
      "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "q"}], "}"}], ",", 
        "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"r", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "-", "q"}], ")"}]}], "]"}]}]}]}], "\n", 
   "\n", 
   RowBox[{
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"GeneralizedTrinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", 
          RowBox[{"a", "*", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
          RowBox[{"a", "*", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], "}"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"GeneralizedTrinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}]}], "}"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"m", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"TrinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], ",", " ", "m"}], "}"}], " ", "/;",
         "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"m", "+", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"m", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    "False"}]}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, {
   3.5284236594229426`*^9, 3.528423723343032*^9}, {3.5319763153648725`*^9, 
   3.531976332744897*^9}, {3.5319763665849442`*^9, 3.5319763719449515`*^9}, {
   3.531976481485105*^9, 3.5319765432051916`*^9}, {3.5351358963511124`*^9, 
   3.5351359146351585`*^9}, {3.535135999759027*^9, 3.5351361136575413`*^9}, {
   3.535139095405609*^9, 3.535139144575678*^9}, {3.5351393193559227`*^9, 
   3.5351393515459676`*^9}, {3.540232859457922*^9, 3.540232934650054*^9}, {
   3.5402386649969177`*^9, 3.54023866610452*^9}, {3.5402387010017815`*^9, 
   3.5402387271630273`*^9}, {3.543432473240037*^9, 3.543432480993251*^9}, {
   3.5434325123181057`*^9, 3.543432613187883*^9}, {3.5434326440759373`*^9, 
   3.5434327168656654`*^9}, {3.5434330591826663`*^9, 
   3.5434330677470813`*^9}, {3.5434332967554836`*^9, 
   3.5434332985182867`*^9}, {3.5434333529935827`*^9, 3.543433422039304*^9}, {
   3.543433484486213*^9, 3.543433499275039*^9}, {3.543433541894314*^9, 
   3.5434335792251797`*^9}, {3.5434336139976406`*^9, 3.543433757689493*^9}, {
   3.5434338110259867`*^9, 3.543433888090122*^9}, {3.5434339330494013`*^9, 
   3.5434340578340206`*^9}, {3.5434341832582407`*^9, 
   3.5434342053946795`*^9}, {3.543434893480688*^9, 3.5434348987690973`*^9}, {
   3.543443667700923*^9, 3.543443747631035*^9}, {3.5434437792910795`*^9, 
   3.5434438495211773`*^9}, {3.5434441963916636`*^9, 3.5434442080416794`*^9}, 
   3.543444328211848*^9, {3.5434443657019005`*^9, 3.543444366481901*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Perfect Power Test Function", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "a", " ", "polynomial", " ", "raised", " ", "to", " ", "an", " ", 
     "integer", " ", "power", " ", "greater", " ", "than", " ", "1"}], ",", 
    "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"PerfectPowerTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "as", " ", "an", " ", "expanded", " ", 
      "polynomial", " ", "raised", " ", "to", " ", "the", " ", "power"}], ";",
      "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PerfectPowerTest", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"lst", "=", 
          RowBox[{"FactorSquareFreeList", "[", "u", "]"}]}], ",", 
         RowBox[{"gcd", "=", "0"}], ",", 
         RowBox[{"v", "=", "1"}]}], "}"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}]}], ",", "\n", "      ", 
          RowBox[{"lst", "=", 
           RowBox[{"Rest", "[", "lst", "]"}]}]}], "]"}], ";", "\n", "    ", 
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"gcd", "=", 
            RowBox[{"GCD", "[", 
             RowBox[{"gcd", ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], ",", "lst"}],
          "]"}], ";", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"gcd", ">", "1"}], ",", "\n", "      ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"v", "=", 
               RowBox[{"v", "*", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/", "gcd"}], ")"}]}]}]}],
               "]"}], ",", "lst"}], "]"}], ";", "\n", "      ", 
           RowBox[{
            RowBox[{"Expand", "[", "v", "]"}], "^", "gcd"}]}], ",", "\n", 
          "    ", "False"}], "]"}]}]}], "]"}], ",", "\n", "  ", "False"}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Square Free Factor Test Function", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "can", " ", "be", " ", "square", " ", 
     "free", " ", "factored"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"SquareFreeFactorTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "in", "\n", "\t", "factored", " ", 
      "form"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SquareFreeFactorTest", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"v", "=", 
          RowBox[{"FactorSquareFree", "[", "u", "]"}]}], "}"}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PowerQ", "[", "v", "]"}], " ", "||", " ", 
           RowBox[{"ProductQ", "[", "v", "]"}]}], ",", "\n", "      ", "v", 
          ",", "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", "  ", 
      "False"}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rational Function Functions", "Section",
 CellChangeTimes->{{3.5387538615615683`*^9, 3.538753868261577*^9}}],

Cell[CellGroupData[{

Cell["RationalFunctionQ", "Subsection",
 CellChangeTimes->{{3.5387539076916323`*^9, 3.5387539161016445`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "polynomial", " ", "or", " ", 
     "rational", " ", "function", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"RationalFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RationalFunctionQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"IntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SumQ", "[", "u", "]"}]}], ",", "\n", "    ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"RationalFunctionQ", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "True", ",", 
           "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.538753994661754*^9, 3.538753995271755*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["RationalFunctionExponents", "Subsection",
 CellChangeTimes->{3.538753976801729*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "rational", " ", "function", 
     " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{"RationalFunctionExponents", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "a", " ", "list", 
     " ", "of", " ", "the", "\n", "\t", "exponent", " ", "of", " ", "the", 
     " ", "numerator", " ", "of", " ", "u", " ", "and", " ", "the", " ", 
     "exponent", " ", "of", " ", "the", " ", "denominator", " ", "of", " ", 
     RowBox[{"u", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RationalFunctionExponents", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exponent", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "0"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"IntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], ",", "\n", "      ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "*", 
          RowBox[{"Reverse", "[", 
           RowBox[{"RationalFunctionExponents", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "]"}]}]}], 
        "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], "+", 
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"v", "=", 
               RowBox[{"Together", "[", "u", "]"}]}], "}"}], ",", "\n", 
             "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "      ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "      ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"RationalFunctionExponents", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "      ", 
                  RowBox[{"lst2", "=", 
                   RowBox[{"RationalFunctionExponents", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                   "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], "]"}], ",",
                "\n", "    ", 
               RowBox[{"RationalFunctionExponents", "[", 
                RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "]"}], ",", "\n", 
           "  ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}], "    "}]}]], "Code",
 CellChangeTimes->{{3.5387541824320173`*^9, 3.5387541826820173`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Recognizers", "Section"],

Cell[CellGroupData[{

Cell["Algebraic Function Recognizer", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "algebraic", " ", 
     "function", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"AlgebraicFunctionQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", "True", ",", "\n",
      "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"AlgebraicFunctionQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SumQ", "[", "u", "]"}]}], ",", "\n", "    ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"AlgebraicFunctionQ", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", "False"}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quotient of Linears Recognizer and Accessor", "Subsection"],

Cell["\<\
QuotientOfLinearsQ[u,x] returns True iff u is equivalent to an expression of \
the form (a+b x)/(c+d x) where b\[NotEqual]0 and d\[NotEqual]0.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276368651739*^9}, {3.5487151683316326`*^9, 3.548715202711681*^9}, {
   3.5487353055929546`*^9, 3.548735320638816*^9}, {3.5487353690385838`*^9, 
   3.5487353967781706`*^9}}],

Cell["\<\
QuotientOfLinearsQ[u,x,True] returns True iff u is of the form (a+b x)/(c+d \
x) where a, b, c and d are free of x.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, 3.541276306961653*^9, {3.5412763443917055`*^9, 
   3.541276459541867*^9}, {3.5412765088119354`*^9, 3.541276516491946*^9}, {
   3.541276814232363*^9, 3.541276824902378*^9}, 3.548715169351634*^9, {
   3.548715217741702*^9, 3.5487152404917336`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"QuotientOfLinearsQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"QuotientOfLinearsQ", "[", 
            RowBox[{"#", ",", "x", ",", "flag"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", " ", "True"}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{"flag", ",", "\n", "    ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
          "]"}]}]}], "]"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"QuotientOfLinearsP", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"NonzeroQ", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"NonzeroQ", "[", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"QuotientOfLinearsParts", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{
  3.528409979137444*^9, {3.528423451152651*^9, 3.5284235211627493`*^9}, 
   3.5284237300830417`*^9, {3.535560264811646*^9, 3.535560273984462*^9}, {
   3.541276914202503*^9, 3.541276972312585*^9}, {3.5412770134526424`*^9, 
   3.5412770349526725`*^9}, {3.541277089772749*^9, 3.541277146012828*^9}, 
   3.541277248302971*^9, {3.5434302226084843`*^9, 3.5434302315629*^9}, {
   3.5434303851295695`*^9, 3.543430463769308*^9}, {3.5434304956089635`*^9, 
   3.543430495796164*^9}, {3.543430533985031*^9, 3.5434306013147497`*^9}, {
   3.5434308396051683`*^9, 3.543430936325338*^9}, {3.5434309741710043`*^9, 
   3.5434310379751167`*^9}, {3.5434310883788047`*^9, 3.543431126817272*^9}, {
   3.5434311677673445`*^9, 3.543431230916255*^9}, {3.5434312714763265`*^9, 
   3.543431292895164*^9}, {3.5434349631036105`*^9, 3.543435013772499*^9}, {
   3.548715496782092*^9, 3.5487155002920976`*^9}, {3.5487155443221593`*^9, 
   3.5487155871522193`*^9}, {3.5487157353524265`*^9, 
   3.5487157393624325`*^9}, {3.5487354341023054`*^9, 3.548735473185541*^9}, {
   3.548735543399557*^9, 3.548735556860327*^9}, {3.5487356088443003`*^9, 
   3.5487356497686405`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{
     RowBox[{"a_", "*", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"QuotientOfLinearsP", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{
     RowBox[{"a_", "+", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"QuotientOfLinearsP", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{
     RowBox[{"1", "/", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"True", " ", "/;", "\n", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"QuotientOfLinearsP", "[", 
    RowBox[{
     RowBox[{"u_", "/", "v_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"True", " ", "/;", "\n", 
    RowBox[{
     RowBox[{"LinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"QuotientOfLinearsP", "[", 
   RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"u", "===", "x"}], " ", "||", " ", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]}], "Code",
 CellChangeTimes->{
  3.5487152523717504`*^9, {3.5487157096923904`*^9, 3.548715714972398*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "an", " ", 
     "expression", " ", "of", " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"QuotientOfLinearsParts", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "\n", "\t", "returns", " ", "the", 
     " ", "list", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "b", ",", " ", "c", ",", " ", "d"}], "}"}], 
      "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "*", "#1"}], ",", " ", 
          RowBox[{"a", "*", "#2"}], ",", " ", "#3", ",", " ", "#4"}], "}"}], 
        "]"}], ",", " ", 
       RowBox[{"QuotientOfLinearsParts", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"a_", "+", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "+", 
           RowBox[{"a", "*", "#3"}]}], ",", " ", 
          RowBox[{"#2", "+", 
           RowBox[{"a", "*", "#4"}]}], ",", " ", "#3", ",", " ", "#4"}], 
         "}"}], "]"}], ",", " ", 
       RowBox[{"QuotientOfLinearsParts", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"1", "/", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"{", 
        RowBox[{"#3", ",", " ", "#4", ",", " ", "#1", ",", " ", "#2"}], "}"}],
        "]"}], ",", " ", 
      RowBox[{"QuotientOfLinearsParts", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "1"}], "]"}], ",", " ", "1", ",", " ", 
       "0"}], "}"}], " ", "/;", "\n", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"u_", "/", "v_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "1"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], "}"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"LinearQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "x"}], ",", "\n", "    ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "1", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
       "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
        RowBox[{"{", 
         RowBox[{"u", ",", " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], 
        ",", "\n", "  ", 
        RowBox[{
         RowBox[{"Print", "[", "\"\<QuotientOfLinearParts error!\>\"", "]"}], 
         ";", "\n", "  ", 
         RowBox[{"{", 
          RowBox[{"u", ",", " ", "0", ",", " ", "1", ",", " ", "0"}], 
          "}"}]}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Improper Rational Functions", "Section"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"u", " ", 
   RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "improper", " ", 
   "fraction", " ", "if", " ", "it", " ", "is", " ", "an", " ", "expression", 
   " ", "of", " ", "the", " ", "form", " ", "w", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"v", " ", 
      RowBox[{"(", "x", ")"}]}], ")"}], "/", "t"}], 
   RowBox[{"(", 
    RowBox[{"v", " ", 
     RowBox[{"(", "x", ")"}]}], ")"}], " ", "where", " ", "w", " ", 
   RowBox[{"(", "x", ")"}], "\n", "\t", "and", " ", "t", " ", 
   RowBox[{"(", "x", ")"}], " ", "are", " ", "polynomials", " ", "in", " ", 
   "x", " ", "and", " ", "the", " ", "degree", " ", "of", " ", "w", " ", 
   RowBox[{"(", "x", ")"}], " ", "is", " ", "greater", " ", "than", " ", "or",
    " ", "equal", " ", "the", " ", "degree", "\n", "\t", "of", " ", "t", " ", 
   RowBox[{
    RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}]], "Code"],

Cell[CellGroupData[{

Cell["Improper Rational Function Recognizer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "improper", " ", 
     "fraction"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ImproperFractionQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ImproperFractionQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lst1", "=", 
         RowBox[{"PolynomialFunctionOf", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], ",", 
        RowBox[{"lst2", "=", 
         RowBox[{"PolynomialFunctionOf", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"lst1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "===", 
        RowBox[{"lst2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{
          RowBox[{"lst1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ">=", 
        RowBox[{"Exponent", "[", 
         RowBox[{
          RowBox[{"lst2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}]}]}], "]"}]}], 
   " ", "*)"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "improper", " ", 
      "rational", " ", "function", " ", "where", " ", "v", " ", "is", " ", 
      "of", " ", "the", " ", "form", " ", "fraction", " ", "a"}], "+", 
     RowBox[{"b", "*", "x"}], "+", 
     RowBox[{"c", "*", 
      RowBox[{"x", "^", "2"}], " ", "or", " ", "a"}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}]}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"ImproperRationalFunctionQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ImproperRationalFunctionQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_."}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}], "]"}], " ", "&&", "\n", 
      "\t  ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"v", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_."}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}], "]"}]}], "]"}], " ", "&&",
     "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ">=", "2"}]}], " ", "||", "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"v", ",", 
        RowBox[{
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x", "^", "n_."}]}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
          RowBox[{"0", "<", "n", "<=", 
           RowBox[{"Exponent", "[", 
            RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "]"}]}], 
     ")"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Improper Fraction Expander", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "an", " ", "improper", " ", "fraction"}], 
    ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandImproperFraction", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"q", ",", "a", ",", "r"}], "}"}], "\n", "\t", "where", " ", 
      "q", " ", "is", " ", "the", " ", "integral", " ", "part", " ", "of", 
      " ", "u", " ", "and", " ", "a", "*", "r", " ", "is", " ", "the", " ", 
      "proper", " ", "fractional", " ", "part", " ", "of", " ", "u"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpandImproperFraction", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", 
         RowBox[{"tmp", "=", 
          RowBox[{"ExpandImproperFraction", "[", 
           RowBox[{
            RowBox[{"Numerator", "[", "u", "]"}], ",", 
            RowBox[{"Denominator", "[", "u", "]"}], ",", "x"}], "]"}]}], 
         "]"}], ",", "\n", "    ", "tmp", ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"NotFalseQ", "[", 
           RowBox[{"tmp", "=", 
            RowBox[{"ExpandImproperFraction", "[", 
             RowBox[{
              RowBox[{"SmartNumerator", "[", "u", "]"}], ",", 
              RowBox[{"SmartDenominator", "[", "u", "]"}], ",", "x"}], 
             "]"}]}], "]"}], ",", "\n", "    ", "tmp", ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FunctionOfQ", "[", 
             RowBox[{
              RowBox[{"Sin", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], 
            ",", "\n", "    ", 
            RowBox[{
             RowBox[{"tmp", "=", 
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Sin", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}],
                 ",", "x"}], "]"}]}], ";", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"NotFalseQ", "[", 
                RowBox[{"tmp", "=", 
                 RowBox[{"ExpandImproperFraction", "[", 
                  RowBox[{
                   RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                   RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                  "]"}]}], "]"}], ",", "\n", "      ", 
               RowBox[{"Subst", "[", 
                RowBox[{"tmp", ",", "x", ",", 
                 RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", "\n", "    ", 
               "False"}], "]"}]}], ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FunctionOfQ", "[", 
               RowBox[{
                RowBox[{"Cos", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], 
              ",", "\n", "    ", 
              RowBox[{
               RowBox[{"tmp", "=", 
                RowBox[{"Regularize", "[", 
                 RowBox[{
                  RowBox[{"SubstFor", "[", 
                   RowBox[{
                    RowBox[{"Cos", "[", "x", "]"}], ",", "u", ",", "x"}], 
                   "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"NotFalseQ", "[", 
                  RowBox[{"tmp", "=", 
                   RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                 RowBox[{"Subst", "[", 
                  RowBox[{"tmp", ",", "x", ",", 
                   RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", "\n", "    ",
                  "False"}], "]"}]}], ",", "\n", "  ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FunctionOfQ", "[", 
                 RowBox[{
                  RowBox[{"Sinh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                 "]"}], ",", "\n", "    ", 
                RowBox[{
                 RowBox[{"tmp", "=", 
                  RowBox[{"Regularize", "[", 
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                    "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"NotFalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                   RowBox[{"Subst", "[", 
                    RowBox[{"tmp", ",", "x", ",", 
                    RowBox[{"Sinh", "[", "x", "]"}]}], "]"}], ",", "\n", 
                   "    ", "False"}], "]"}]}], ",", "\n", "  ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FunctionOfQ", "[", 
                   RowBox[{
                    RowBox[{"Cosh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"tmp", "=", 
                    RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                    "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                    RowBox[{"Subst", "[", 
                    RowBox[{"tmp", ",", "x", ",", 
                    RowBox[{"Cosh", "[", "x", "]"}]}], "]"}], ",", "\n", 
                    "    ", "False"}], "]"}]}], ",", "\n", "  ", "False"}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"ExpandImproperFraction", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"lst1", "=", 
        RowBox[{"PolynomialFunctionOf", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"lst2", "=", 
        RowBox[{"PolynomialFunctionOf", "[", 
         RowBox[{"v", ",", "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"lst1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", 
           RowBox[{"lst2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", " ", 
          RowBox[{
           RowBox[{"Exponent", "[", 
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ">=", 
           RowBox[{"Exponent", "[", 
            RowBox[{
             RowBox[{"lst2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}]}], ",", 
         "\n", "    ", 
         RowBox[{"ReplaceAll", "[", 
          RowBox[{
           RowBox[{"PolynomialDivide", "[", 
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"lst2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
           RowBox[{"x", "->", 
            RowBox[{"lst1", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
         "False"}], "]"}]}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PolynomialDivide", "[", 
      RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", "the", 
     " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{"q", ",", "a", ",", "r"}], "}"}], " ", "where", " ", "q", " ", 
     "is", " ", "the", " ", "integral", " ", "part", " ", "of", " ", 
     RowBox[{"u", "/", "v"}], " ", "and", "\n", "\t", "a", "*", "r", " ", 
     "is", " ", "the", " ", "proper", " ", "fractional", " ", "part", " ", 
     "of", " ", 
     RowBox[{"u", "/", "v"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialDivide", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SplitFreeFactors", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PolynomialRemainder", "[", 
           RowBox[{"u", ",", "v", ",", "x"}], "]"}], "/", "v"}], ",", "x"}], 
        "]"}], ",", "x"}], "]"}], ",", "\n", "\t\t", 
     RowBox[{"PolynomialQuotient", "[", 
      RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmartNumerator", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", "Csch"}],
        "}"}], ",", 
      RowBox[{"Head", "[", "u", "]"}]}], "]"}], ",", "\n", "    ", "1", ",", 
    "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", 
           "Csch"}], "}"}], ",", 
         RowBox[{"Head", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", "\n", 
      "    ", "1", ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ",", "\n", "    ", 
        "1", ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Map", "[", 
           RowBox[{"SmartNumerator", ",", "u"}], "]"}], ",", "\n", "  ", 
          "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmartDenominator", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", "Csch"}],
        "}"}], ",", 
      RowBox[{"Head", "[", "u", "]"}]}], "]"}], ",", "\n", "    ", 
    RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", 
           "Csch"}], "}"}], ",", 
         RowBox[{"Head", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", "\n", 
      "    ", 
      RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ",", "\n", "    ", 
        RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Map", "[", 
           RowBox[{"SmartDenominator", ",", "u"}], "]"}], ",", "\n", "  ", 
          "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Function Composer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PolynomialFunctionOf", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", " ", 
        RowBox[{"(", "x", ")"}]}], ",", 
       RowBox[{"w", " ", 
        RowBox[{"(", "x", ")"}]}]}], "}"}], " ", "where", " ", "w", " ", 
     RowBox[{"(", 
      RowBox[{"v", " ", 
       RowBox[{"(", "x", ")"}]}], ")"}], " ", "equals", " ", "u", " ", 
     RowBox[{"(", "x", ")"}]}], ",", " ", 
    RowBox[{"w", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", "\n", "\t", "a", " ", "polynomial", 
     " ", "in", " ", "x"}], ",", " ", 
    RowBox[{"and", " ", "v", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "minimal"}]}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"PolynomialFunctionOf", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x"}], "}"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PositiveIntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst", "=", 
           RowBox[{"PolynomialFunctionOf", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "}"}], ",",
          "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "^", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst1", "=", 
              RowBox[{"PolynomialFunctionOf", "[", 
               RowBox[{
                RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
             RowBox[{"lst2", "=", 
              RowBox[{"PolynomialFunctionOf", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], "}"}],
            ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
             "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"lst2", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"lst1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "*", 
                RowBox[{"lst2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lst2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
               "      ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"lst1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "*", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "\n", "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                 "    ", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}],
           "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"lst1", "=", 
                RowBox[{"PolynomialFunctionOf", "[", 
                 RowBox[{
                  RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
               RowBox[{"lst2", "=", 
                RowBox[{"PolynomialFunctionOf", "[", 
                 RowBox[{
                  RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], 
              "}"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lst1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
               "      ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"lst2", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "+", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
                 "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                 "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "===", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "\n", 
                   "      ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                   "    ", 
                   RowBox[{"{", 
                    RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
             RowBox[{"{", 
              RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "  ", 
             RowBox[{"{", 
              RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Gcd Function", "Section",
 CellChangeTimes->{{3.5197824276574383`*^9, 3.5197824306838436`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gcd", "[", 
   RowBox[{"m_", ",", "n_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"denr", "=", 
       RowBox[{"LCM", "[", 
        RowBox[{
         RowBox[{"Denominator", "[", "m", "]"}], ",", 
         RowBox[{"Denominator", "[", "n", "]"}]}], "]"}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"Sign", "[", "n", "]"}], "*", 
      RowBox[{
       RowBox[{"GCD", "[", 
        RowBox[{
         RowBox[{"m", "*", "denr"}], ",", 
         RowBox[{"n", "*", "denr"}]}], "]"}], "/", "denr"}]}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{"RationalQ", "[", 
    RowBox[{"m", ",", "n"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.517247815898923*^9, 3.5172478163825235`*^9}, {
   3.5172478482377796`*^9, 3.517247924256713*^9}, 3.5197823880489683`*^9, {
   3.5197824354886518`*^9, 3.519782556934865*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Rational Number Factors", "Section",
 CellChangeTimes->{{3.5195842536471157`*^9, 3.5195842604331274`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "lst", " ", "is", " ", "a", " ", "list", " ", "of", " ", "n", 
     " ", "terms"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CommonNumericFactors", "[", "lst", "]"}], " ", "returns", " ", 
      "a", " ", "n"}], "+", "1", "-", 
     RowBox[{
     "element", " ", "list", " ", "whose", " ", "first", "\n", "\t", 
      "element", " ", "is", " ", "the", " ", "product", " ", "of", " ", "the",
       " ", "numeric", " ", "factors", " ", "common", " ", "to", " ", "all", 
      " ", "terms", " ", "of", " ", "lst"}]}], ",", " ", 
    RowBox[{
    "and", " ", "whose", " ", "remaining", "\n", "\t", "elements", " ", "are",
      " ", "quotients", " ", "of", " ", "each", " ", "term", " ", "divided", 
     " ", "by", " ", "the", " ", "numeric", " ", "common", " ", 
     RowBox[{"factor", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"CommonNumericFactors", " ", "[", "lst_", "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"num", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"GCD", ",", 
         RowBox[{"Map", "[", 
          RowBox[{"NumericFactor", ",", "lst"}], "]"}]}], "]"}]}], "}"}], ",",
      "\n", "  ", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"#", "/", "num"}], "]"}], ",", "lst"}], "]"}], ",", "num"}],
       "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NumericFactor", "[", "u", "]"}], " ", "returns", " ", "the", " ",
     "product", " ", "of", " ", "the", " ", "factors", " ", "of", " ", "u", 
    " ", "that", " ", "are", " ", "rational", " ", 
    RowBox[{"numbers", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NumericFactor", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ZeroQ", "[", 
        RowBox[{"Im", "[", "u", "]"}], "]"}], ",", "\n", "      ", "u", ",", 
       "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", 
          RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{"Im", "[", "u", "]"}], ",", "\n", "    ", "1"}], "]"}]}], 
      "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RationalQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"FractionQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], ",", "\n", 
           "        ", 
           RowBox[{"1", "/", 
            RowBox[{"Denominator", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
           RowBox[{"1", "/", 
            RowBox[{"Denominator", "[", 
             RowBox[{"1", "/", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
         "    ", "1"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Map", "[", 
          RowBox[{"NumericFactor", ",", "u"}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "#", "]"}], ",", " ", "1", ",", " ", 
               RowBox[{"NumericFactor", "[", "#", "]"}]}], "]"}], "]"}], "[", 
            RowBox[{"ContentFactor", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
           "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195836372276335`*^9, 3.5195836627648783`*^9}, {
   3.5195843564512963`*^9, 3.51958438699615*^9}, {3.523213335857153*^9, 
   3.5232135092826576`*^9}, 3.52321358467759*^9, {3.5232139714802694`*^9, 
   3.5232139744286747`*^9}, {3.5272046058614964`*^9, 3.52720467645162*^9}, 
   3.5272052477364597`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NonnumericFactors", "[", "u", "]"}], " ", "returns", " ", "the", 
    " ", "product", " ", "of", " ", "the", " ", "factors", " ", "of", " ", 
    "u", " ", "that", " ", "are", " ", "not", " ", "rational", " ", 
    RowBox[{"numbers", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NonnumericFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ZeroQ", "[", 
        RowBox[{"Im", "[", "u", "]"}], "]"}], ",", "\n", "      ", "1", ",", 
       "    ", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", 
          RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", "I", ",",
          "\n", "    ", "u"}], "]"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"RationalQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"FractionQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
         RowBox[{"u", "/", 
          RowBox[{"NumericFactor", "[", "u", "]"}]}], ",", "\n", "    ", 
         "u"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Map", "[", 
          RowBox[{"NonnumericFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "#", "]"}], ",", " ", "u", ",", " ", 
               RowBox[{"NonnumericFactors", "[", "#", "]"}]}], "]"}], "]"}], 
            "[", 
            RowBox[{"ContentFactor", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
           "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519583679940508*^9, 3.519583685525318*^9}, {
   3.5195843940941625`*^9, 3.5195844035165787`*^9}, {3.5232135447883196`*^9, 
   3.5232135889207973`*^9}, 3.5232139865810957`*^9, 3.527205378746643*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Absurd Number Factors", "Section",
 CellChangeTimes->{{3.5195831061871004`*^9, 3.5195831116003103`*^9}}],

Cell["\<\
Definition: A number is absurd if it is a rational number, a positive \
rational number raised to a fractional power, or a product of absurd numbers.\
\>", "Text",
 CellChangeTimes->{{3.5195849023114552`*^9, 3.5195849405003223`*^9}},
 FontSize->14],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"AbsurdNumberQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "an", " ", "absurd", " ", 
     "number"}], ",", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"AbsurdNumberQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"RationalQ", "[", "u", "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"AbsurdNumberQ", "[", 
     RowBox[{"u_", "^", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"u", ">", "0"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"AbsurdNumberQ", "[", 
     RowBox[{"u_", "*", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"AbsurdNumberQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"AbsurdNumberQ", "[", "v", "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.5195831762156234`*^9, 3.5195833289866915`*^9}, 
   3.5195848895662327`*^9, {3.5195866951100707`*^9, 3.5195867045100837`*^9}, {
   3.5195867443501396`*^9, 3.5195867845201955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"AbsurdNumberFactors", "[", "u", "]"}], " ", "returns", " ", 
    "the", " ", "product", " ", "of", " ", "the", " ", "factors", " ", "of", 
    " ", "u", " ", "that", " ", "are", " ", "absurd", " ", 
    RowBox[{"numbers", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"AbsurdNumberFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AbsurdNumberQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Map", "[", 
        RowBox[{"AbsurdNumberFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
       RowBox[{"NumericFactor", "[", "u", "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195834406204877`*^9, 3.5195834499961042`*^9}, {
  3.5195834893549733`*^9, 3.519583548167077*^9}, {3.5195835832515383`*^9, 
  3.5195836197400026`*^9}, {3.5195838281563683`*^9, 3.519583868295239*^9}, {
  3.519584107022458*^9, 3.5195841079896603`*^9}, {3.5195841767701807`*^9, 
  3.519584182807391*^9}, {3.5195842903383803`*^9, 3.519584323301238*^9}, {
  3.5195844120809937`*^9, 3.519584424030615*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NonabsurdNumberFactors", "[", "u", "]"}], " ", "returns", " ", 
    "the", " ", "product", " ", "of", " ", "the", " ", "factors", " ", "of", 
    " ", "u", " ", "that", " ", "are", " ", "not", " ", "absurd", " ", 
    RowBox[{"numbers", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NonabsurdNumberFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AbsurdNumberQ", "[", "u", "]"}], ",", "\n", "    ", "1", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Map", "[", 
        RowBox[{"NonabsurdNumberFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
       RowBox[{"NonnumericFactors", "[", "u", "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195837253209877`*^9, 3.519583756021842*^9}, {
  3.519583876251253*^9, 3.519583887311672*^9}, {3.5195841022020497`*^9, 
  3.519584103434452*^9}, {3.5195841908726053`*^9, 3.519584195521414*^9}, {
  3.519584333597256*^9, 3.519584342192871*^9}, {3.519584431347028*^9, 
  3.519584437509039*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"m", " ", "must", " ", "be", " ", "an", " ", "absurd", " ", 
    RowBox[{"number", ".", "  ", 
     RowBox[{"FactorAbsurdNumber", "[", "m", "]"}]}], " ", "returns", " ", 
    "the", " ", "prime", " ", "factorization", " ", "of", " ", "m"}], " ", 
   "*)"}], " ", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"as", " ", "list", " ", "of", " ", "base"}], "-", 
    RowBox[{
    "degree", " ", "pairs", " ", "where", " ", "the", " ", "bases", " ", 
     "are", " ", "prime", " ", "numbers", " ", "and", " ", "the", " ", 
     "degrees", " ", "are", " ", 
     RowBox[{"rational", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FactorAbsurdNumber", "[", "m_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", "m", "]"}], ",", "\n", "    ", 
     RowBox[{"FactorInteger", "[", "m", "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "m", "]"}], ",", "\n", "    ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "*", 
             RowBox[{"m", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}], ",", 
         RowBox[{"FactorInteger", "[", 
          RowBox[{"m", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"CombineExponents", "[", 
        RowBox[{"Sort", "[", 
         RowBox[{
          RowBox[{"Flatten", "[", 
           RowBox[{
            RowBox[{"Map", "[", 
             RowBox[{"FactorAbsurdNumber", ",", 
              RowBox[{"Apply", "[", 
               RowBox[{"List", ",", "m"}], "]"}]}], "]"}], ",", "1"}], "]"}], 
          ",", " ", 
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195831762156234`*^9, 3.5195833289866915`*^9}, {
   3.51958479679287*^9, 3.5195848819534197`*^9}, {3.519585009873644*^9, 
   3.519585012510049*^9}, {3.519585646286947*^9, 3.519585693827013*^9}, {
   3.5195857337070694`*^9, 3.519585836807624*^9}, {3.519585904090542*^9, 
   3.5195859304077883`*^9}, 3.5195859823390727`*^9, {3.5195860222091284`*^9, 
   3.51958603757915*^9}, {3.5195861574793177`*^9, 3.5195861711893373`*^9}, {
   3.5195863177295423`*^9, 3.519586318539543*^9}, {3.519586357479598*^9, 
   3.5195863593196*^9}, {3.519586431439701*^9, 3.5195864764797645`*^9}, {
   3.5195865270098352`*^9, 3.5195865435798583`*^9}, {3.519586575599903*^9, 
   3.5195865957899313`*^9}, {3.5195868639003067`*^9, 3.519586971140457*^9}, {
   3.5195870038405027`*^9, 3.5195871051406446`*^9}, {3.5195872392908325`*^9, 
   3.5195872501808476`*^9}, {3.519587410551072*^9, 3.519587411941074*^9}, {
   3.519587477871166*^9, 3.51958748042117*^9}, {3.519587516671221*^9, 
   3.5195875391912527`*^9}, {3.5195876035313425`*^9, 
   3.5195876066713467`*^9}, {3.5195879289217978`*^9, 3.51958793756181*^9}, {
   3.519588443482518*^9, 3.5195884496025267`*^9}, {3.519588532582643*^9, 
   3.519588594242729*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CombineExponents", "[", "lst_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "lst", "]"}], "<", "2"}], ",", "\n", "    ", 
    "lst", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"lst", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", 
       RowBox[{"lst", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", "\n", "    ", 
      RowBox[{"CombineExponents", "[", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Drop", "[", 
          RowBox[{"lst", ",", "2"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], "+", 
            RowBox[{"lst", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}]}]}], "}"}]}], "]"}], 
       "]"}], ",", "\n", "  ", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"CombineExponents", "[", 
         RowBox[{"Rest", "[", "lst", "]"}], "]"}], ",", 
        RowBox[{"First", "[", "lst", "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{{3.5195831762156234`*^9, 3.5195833289866915`*^9}, {
   3.51958479679287*^9, 3.5195848819534197`*^9}, {3.519585009873644*^9, 
   3.519585012510049*^9}, {3.519585646286947*^9, 3.519585693827013*^9}, {
   3.5195857337070694`*^9, 3.519585836807624*^9}, {3.519585904090542*^9, 
   3.5195859304077883`*^9}, 3.5195859823390727`*^9, {3.5195860222091284`*^9, 
   3.51958603757915*^9}, {3.5195861574793177`*^9, 3.5195861711893373`*^9}, {
   3.5195863177295423`*^9, 3.519586318539543*^9}, {3.519586357479598*^9, 
   3.5195863593196*^9}, {3.519586431439701*^9, 3.5195864764797645`*^9}, {
   3.5195865270098352`*^9, 3.5195865435798583`*^9}, {3.519586575599903*^9, 
   3.5195865957899313`*^9}, {3.5195868639003067`*^9, 3.519586971140457*^9}, {
   3.5195870038405027`*^9, 3.5195871051406446`*^9}, {3.5195872392908325`*^9, 
   3.5195872501808476`*^9}, {3.519587410551072*^9, 3.519587411941074*^9}, {
   3.519587477871166*^9, 3.51958748042117*^9}, {3.519587516671221*^9, 
   3.5195875391912527`*^9}, {3.5195876035313425`*^9, 
   3.5195876066713467`*^9}, {3.5195879289217978`*^9, 
   3.5195881730421395`*^9}, {3.519588258292259*^9, 3.5195884025324607`*^9}, {
   3.519588470342556*^9, 3.5195884820225725`*^9}, {3.51958863754279*^9, 
   3.5195886402427936`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"m", ",", " ", "n", ",", " ", 
    RowBox[{"...", " ", "must", " ", "be", " ", "absurd", " ", 
     RowBox[{"numbers", ".", "  ", 
      RowBox[{"AbsurdNumberGCD", "[", 
       RowBox[{"m", ",", "n", ",", "..."}], "]"}]}], " ", "returns", " ", 
     "the", " ", "gcd", " ", "of", " ", "m"}], ",", " ", "n", ",", " ", 
    "..."}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"AbsurdNumberGCD", "[", "seq__", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"{", "seq", "}"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "[", "lst", "]"}], "\[Equal]", "1"}], ",", "\n", 
       "    ", 
       RowBox[{"First", "[", "lst", "]"}], ",", "\n", "  ", 
       RowBox[{"AbsurdNumberGCDList", "[", 
        RowBox[{
         RowBox[{"FactorAbsurdNumber", "[", 
          RowBox[{"First", "[", "lst", "]"}], "]"}], ",", 
         RowBox[{"FactorAbsurdNumber", "[", 
          RowBox[{"Apply", "[", 
           RowBox[{"AbsurdNumberGCD", ",", 
            RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195831762156234`*^9, 3.5195833289866915`*^9}, {
   3.51958479679287*^9, 3.5195848819534197`*^9}, {3.519585009873644*^9, 
   3.519585012510049*^9}, 3.51958563452693*^9, {3.519589029523339*^9, 
   3.5195890657233896`*^9}, {3.519589250353648*^9, 3.5195892781136866`*^9}, {
   3.519589308373729*^9, 3.5195894014938593`*^9}, {3.5195918413472753`*^9, 
   3.519591922847389*^9}, {3.519591985457477*^9, 3.519592033397544*^9}, {
   3.519592068957594*^9, 3.5195920968176327`*^9}, {3.519592131207681*^9, 
   3.519592262297865*^9}, {3.5195923542579937`*^9, 3.519592428098097*^9}, {
   3.5195924816081715`*^9, 3.519592485218177*^9}, {3.5195925607482824`*^9, 
   3.519592564698288*^9}, 3.5195926185483637`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "lst1", " ", "and", " ", "lst2", " ", "must", " ", "be", " ", "absurd", 
    " ", "number", " ", "prime", " ", "factorization", " ", 
    RowBox[{"lists", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"AbsurdNumberGCDList", "[", 
     RowBox[{"lst1", ",", "lst2"}], "]"}], " ", "returns", " ", "the", " ", 
    "gcd", " ", "of", " ", "the", " ", "absurd", " ", "numbers", " ", 
    "represented", " ", "by", " ", "lst1", " ", "and", " ", 
    RowBox[{"lst2", "."}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"AbsurdNumberGCDList", "[", 
    RowBox[{"lst1_", ",", "lst2_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"lst1", "===", 
      RowBox[{"{", "}"}]}], ",", "\n", "    ", 
     RowBox[{"Apply", "[", 
      RowBox[{"Times", ",", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "^", 
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "]"}]}], "]"}], ",",
          "lst2"}], "]"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lst2", "===", 
        RowBox[{"{", "}"}]}], ",", "\n", "    ", 
       RowBox[{"Apply", "[", 
        RowBox[{"Times", ",", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", 
             RowBox[{"Min", "[", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "]"}]}], "]"}], 
           ",", "lst1"}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst1", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "\[Equal]", 
          RowBox[{"lst2", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lst1", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}], "\[LessEqual]", 
            RowBox[{"lst2", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", "\n", "      ", 
           RowBox[{
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "^", 
             RowBox[{"lst1", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "*", 
            RowBox[{"AbsurdNumberGCDList", "[", 
             RowBox[{
              RowBox[{"Rest", "[", "lst1", "]"}], ",", 
              RowBox[{"Rest", "[", "lst2", "]"}]}], "]"}]}], ",", "\n", 
           "    ", 
           RowBox[{
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "^", 
             RowBox[{"lst2", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "*", 
            RowBox[{"AbsurdNumberGCDList", "[", 
             RowBox[{
              RowBox[{"Rest", "[", "lst1", "]"}], ",", 
              RowBox[{"Rest", "[", "lst2", "]"}]}], "]"}]}]}], "]"}], ",", 
         "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"lst1", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "<", 
            RowBox[{"lst2", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "2"}], "]"}], "]"}], "<", "0"}], ",", "\n", 
             "      ", 
             RowBox[{
              RowBox[{
               RowBox[{"lst1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], "^", 
               RowBox[{"lst1", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "*", 
              RowBox[{"AbsurdNumberGCDList", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "lst1", "]"}], ",", "lst2"}], "]"}]}], 
             ",", "\n", "    ", 
             RowBox[{"AbsurdNumberGCDList", "[", 
              RowBox[{
               RowBox[{"Rest", "[", "lst1", "]"}], ",", "lst2"}], "]"}]}], 
            "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst2", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "2"}], "]"}], "]"}], "<", "0"}], ",", "\n", 
             "    ", 
             RowBox[{
              RowBox[{
               RowBox[{"lst2", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], "^", 
               RowBox[{"lst2", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "*", 
              RowBox[{"AbsurdNumberGCDList", "[", 
               RowBox[{"lst1", ",", 
                RowBox[{"Rest", "[", "lst2", "]"}]}], "]"}]}], ",", "\n", 
             "  ", 
             RowBox[{"AbsurdNumberGCDList", "[", 
              RowBox[{"lst1", ",", 
               RowBox[{"Rest", "[", "lst2", "]"}]}], "]"}]}], "]"}]}], 
          "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5195831762156234`*^9, 3.5195833289866915`*^9}, {
   3.51958479679287*^9, 3.5195848819534197`*^9}, {3.519585009873644*^9, 
   3.519585012510049*^9}, 3.51958563452693*^9, {3.519589029523339*^9, 
   3.5195890657233896`*^9}, {3.519589250353648*^9, 3.5195892781136866`*^9}, {
   3.519589308373729*^9, 3.519589425973894*^9}, {3.519589462273945*^9, 
   3.5195895181540227`*^9}, {3.5195895569140773`*^9, 
   3.5195896052541447`*^9}, {3.5195899586946397`*^9, 
   3.5195899913846855`*^9}, {3.519590032324743*^9, 3.5195902344950256`*^9}, {
   3.519590268905074*^9, 3.5195905999955373`*^9}, {3.5195907243857117`*^9, 
   3.5195907287957177`*^9}, {3.5195907896058025`*^9, 
   3.5195908121658344`*^9}, {3.519591138116291*^9, 3.519591139936293*^9}, {
   3.5195911707163363`*^9, 3.5195912168264008`*^9}, {3.5195913028565216`*^9, 
   3.5195913036865225`*^9}, {3.519591334796566*^9, 3.519591454206733*^9}, {
   3.519594197500574*^9, 3.5195942465806427`*^9}, {3.5195942800006895`*^9, 
   3.519594346790783*^9}, {3.5195945636110864`*^9, 3.5195946162811604`*^9}, {
   3.5195946629912252`*^9, 3.519594721231307*^9}, {3.5195950668117905`*^9, 
   3.519595176901945*^9}, {3.519602189733043*^9, 3.519602215161088*^9}, {
   3.5196022827719913`*^9, 3.519602312372032*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Standardization Functions", "Section",
 CellChangeTimes->{{3.5195140860351057`*^9, 3.51951409565512*^9}, {
  3.528926707473311*^9, 3.528926711498118*^9}, {3.5371295293701863`*^9, 
  3.5371295323601904`*^9}, {3.5372916025635805`*^9, 3.537291605952774*^9}, {
  3.537667397198867*^9, 3.537667400798872*^9}, {3.540231114959881*^9, 
  3.540231121121892*^9}, {3.540231462185291*^9, 3.5402314666468987`*^9}}],

Cell[CellGroupData[{

Cell["DisguisedKnownIntegrandQ", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5402316300841627`*^9, 3.540231636776574*^9}, {
   3.5408664655215864`*^9, 3.5408664670503893`*^9}}],

Cell[TextData[{
 "DisguisedKnownIntegrandQ[u,x] returns True iff u is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " in the exact form of a known integrand but can algebraically be \
transformed into one."
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DisguisedKnownIntegrandQ", "[", 
   RowBox[{"Integrand_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"KnownIntegrandQ", "[", 
    RowBox[{"Integrand", ",", "x"}], "]"}], " ", "&&", " ", 
   RowBox[{"Not", "[", 
    RowBox[{"KnownIntegrandQ", "[", 
     RowBox[{"Integrand", ",", "x", ",", "True"}], "]"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.5408664962692404`*^9, 3.540866547858531*^9}, {3.5412787700351014`*^9, 
   3.5412787884151273`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["KnownIntegrandQ", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5402316300841627`*^9, 3.540231636776574*^9}}],

Cell["\<\
KnownIntegrandQ[u,x,True] returns True iff u is in the exact form of a known \
integrand.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, 3.5412717906053305`*^9, {3.541274806999553*^9, 
   3.5412748086595554`*^9}, {3.541278729685045*^9, 3.5412787312850475`*^9}}],

Cell["\<\
KnownIntegrandQ[u,x] returns True iff u is in the exact form of a known \
integrand or can algebraically be transformed into one.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, {3.5408665600265527`*^9, 3.540866574082177*^9}, {
   3.541270866064036*^9, 3.5412708715940437`*^9}, {3.5412714377248363`*^9, 
   3.5412714480348506`*^9}, {3.5412749646797743`*^9, 
   3.5412749973698196`*^9}, {3.5412779658039756`*^9, 3.541277969683981*^9}, {
   3.5412787365850544`*^9, 3.5412787375450563`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KnownIntegrandQ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"KnownIntegrandQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"m", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.541271919655511*^9}, {
   3.541271955505561*^9, 3.5412720655457153`*^9}, {3.541272156865843*^9, 
   3.5412721838358808`*^9}, 3.5412722663759966`*^9, 3.5412723619861298`*^9, {
   3.5412723928461733`*^9, 3.541272453086258*^9}, {3.5412725578164043`*^9, 
   3.541272593776455*^9}, {3.5412726451765265`*^9, 3.5412726482465305`*^9}, {
   3.5412729298069253`*^9, 3.541272944396946*^9}, {3.5412729941370153`*^9, 
   3.541273003657028*^9}, {3.5412737435280647`*^9, 3.541273763178092*^9}, {
   3.5412738383181973`*^9, 3.5412738654782352`*^9}, {3.5412739401883397`*^9, 
   3.5412739480383506`*^9}, {3.541274018018449*^9, 3.541274018268449*^9}, {
   3.5412740508784943`*^9, 3.541274082028538*^9}, {3.5412741591486464`*^9, 
   3.5412741736086664`*^9}, {3.541274216918727*^9, 3.5412742187187295`*^9}, {
   3.541274273498806*^9, 3.541274316828867*^9}, 3.5412780386240773`*^9, 
   3.5412781428242235`*^9, 3.5412782994744425`*^9, {3.5487148420611763`*^9, 
   3.5487149467313223`*^9}, {3.548715004951404*^9, 3.548715011611413*^9}, {
   3.5487197866476994`*^9, 3.5487197870977*^9}, {3.5487198423477774`*^9, 
   3.5487198899478445`*^9}, {3.5487199680779533`*^9, 3.548719996057993*^9}, {
   3.5487200336980457`*^9, 3.548720040978056*^9}, {3.5487200720780993`*^9, 
   3.548720091878127*^9}, {3.548720178428248*^9, 3.548720189198263*^9}, 
   3.5487202286683187`*^9, {3.5491703335155807`*^9, 3.54917041795341*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KnownIntegrandQ", "[", 
   RowBox[{
    RowBox[{"u_", "+", "v_"}], ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"KnownIntegrandQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
   RowBox[{"KnownIntegrandQ", "[", 
    RowBox[{"v", ",", "x", ",", "flag"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.5412719145655036`*^9}, {
   3.5412779902940097`*^9, 3.541277997094019*^9}, 3.5412822572144947`*^9, {
   3.541282363774644*^9, 3.5412823964346895`*^9}, {3.541282438274748*^9, 
   3.5412824542147703`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KnownIntegrandQ", "[", 
   RowBox[{"z_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{"u_", "^", "p_."}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"KnownMultinomialQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"KnownMultinomialQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"KnownMultinomialQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"LinearQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
         RowBox[{"QuadraticQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}], ")"}]}]}]}], "]"}], 
   " ", "||", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{
        RowBox[{"f_", "[", "v_", "]"}], "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"LinearQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
         RowBox[{"QuadraticQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}], ")"}]}]}]}], "]"}], 
   " ", "||", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f_", "^", "v_"}], ")"}], "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"LinearQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
         RowBox[{"QuadraticQ", "[", 
          RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}], ")"}]}]}]}], "]"}], 
   " ", "||", "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v"}], "}"}], ",", "x", ",", "flag"}], "]"}], " ",
        "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{
        RowBox[{"f_", "[", "v_", "]"}], "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v"}], "}"}], ",", "x", ",", "flag"}], "]"}], " ",
        "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"f_", "^", "v_"}], ")"}], "^", "q_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v"}], "}"}], ",", "x", ",", "flag"}], "]"}], " ",
        "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "p_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"TrinomialQ", "[", 
        RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"TrinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   " ", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "p_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"GeneralizedTrinomialQ", "[", 
        RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"GeneralizedTrinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   " ", "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}], "*", 
       RowBox[{"w_", "^", "r_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"BinomialQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", "x", ",", "flag"}], 
        "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "-", 
         RowBox[{"BinomialDegree", "[", 
          RowBox[{"w", ",", "x"}], "]"}]}], "]"}]}]}]}], "]"}], " ", "||", 
   "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}], "*", 
       RowBox[{"w_", "^", "r_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"LinearQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"v", ",", "w"}], "}"}], ",", "x", ",", "flag"}], "]"}], " ",
        "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"q", "===", "1"}], " ", "||", " ", 
         RowBox[{"r", "===", "1"}]}], ")"}]}]}]}], "]"}], " ", "||", "\n", 
   "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}], "*", 
       RowBox[{"w_", "^", "r_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "x"}], "]"}], " ", "&&",
        " ", 
       RowBox[{"p", "===", "1"}], " ", "&&", " ", 
       RowBox[{"LinearQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"QuadraticQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"v", ",", "w"}], "}"}], ",", "x", ",", "flag"}], 
        "]"}]}]}]}], "]"}], " ", "||", "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"u_", "^", "p_."}], "*", 
       RowBox[{"v_", "^", "q_."}], "*", 
       RowBox[{"w_", "^", "r_."}], "*", 
       RowBox[{"y_", "^", "s_."}]}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r", ",", "s"}], "}"}], ",", "x"}], 
        "]"}], " ", "&&", " ", 
       RowBox[{"LinearQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"u", ",", "v", ",", "w", ",", "y"}], "}"}], ",", "x", ",", 
         "flag"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", "u_", "]"}], "/", "v_"}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"QuotientOfLinearsQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"LinearQ", "[", 
          RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
         RowBox[{"QuadraticQ", "[", 
          RowBox[{"v", ",", "x", ",", "flag"}], "]"}]}], ")"}]}]}]}], "]"}], 
   " ", "||", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"z", ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"u_", "^", "n_."}]}], "]"}], "/", "v_"}], " ", "/;", " ", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"LinearQ", "[", 
        RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"LinearQ", "[", 
          RowBox[{"v", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
         RowBox[{"QuadraticQ", "[", 
          RowBox[{"v", ",", "x", ",", "flag"}], "]"}]}], ")"}]}]}]}], "]"}], 
   " ", "||", "\n", "\n", "  ", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"z", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.541271919655511*^9}, {
   3.541271955505561*^9, 3.5412720655457153`*^9}, {3.541272156865843*^9, 
   3.5412721838358808`*^9}, 3.5412722663759966`*^9, 3.5412723619861298`*^9, {
   3.5412723928461733`*^9, 3.541272453086258*^9}, {3.5412725578164043`*^9, 
   3.541272593776455*^9}, {3.5412726451765265`*^9, 3.5412726482465305`*^9}, {
   3.5412729298069253`*^9, 3.541272944396946*^9}, {3.5412729941370153`*^9, 
   3.541273003657028*^9}, {3.5412737435280647`*^9, 3.541273763178092*^9}, {
   3.5412738383181973`*^9, 3.5412738654782352`*^9}, {3.5412739401883397`*^9, 
   3.5412739480383506`*^9}, {3.541274018018449*^9, 3.541274018268449*^9}, {
   3.5412740508784943`*^9, 3.541274082028538*^9}, {3.5412741591486464`*^9, 
   3.5412741736086664`*^9}, {3.541274216918727*^9, 3.5412742187187295`*^9}, {
   3.541274273498806*^9, 3.541274316828867*^9}, 3.5412780386240773`*^9, 
   3.5412781428242235`*^9, 3.5412782994744425`*^9, {3.5487148420611763`*^9, 
   3.5487149467313223`*^9}, {3.548715004951404*^9, 3.548715011611413*^9}, {
   3.5487197866476994`*^9, 3.5487197870977*^9}, {3.5487198423477774`*^9, 
   3.5487198899478445`*^9}, {3.5487199680779533`*^9, 3.548719996057993*^9}, {
   3.5487200336980457`*^9, 3.548720040978056*^9}, {3.5487200720780993`*^9, 
   3.548720091878127*^9}, {3.548720178428248*^9, 3.548720189198263*^9}, 
   3.5487202286683187`*^9, {3.549169340996812*^9, 3.5491694206243663`*^9}, {
   3.549169559479308*^9, 3.5491696062899857`*^9}, {3.5491696711356945`*^9, 
   3.549169745974975*^9}, {3.54916978539723*^9, 3.5491697876393585`*^9}, {
   3.549169853984153*^9, 3.5491698934544106`*^9}, {3.549169926346292*^9, 
   3.549169976459158*^9}, {3.5491700244229016`*^9, 3.549170068202406*^9}, {
   3.5491701033204145`*^9, 3.5491701044334784`*^9}, {3.5491701496780653`*^9, 
   3.549170166465026*^9}, {3.549170199116894*^9, 3.5491702327218156`*^9}, {
   3.5491704256178484`*^9, 3.5491704460210156`*^9}, {3.549170494482787*^9, 
   3.549170497202943*^9}, {3.549170555508278*^9, 3.549170574055339*^9}, {
   3.5491706040750556`*^9, 3.549170605165118*^9}, {3.549170640601145*^9, 
   3.5491707417729316`*^9}, {3.5491708864132047`*^9, 3.549171012599422*^9}, 
   3.5491710644993906`*^9, {3.549171145701035*^9, 3.549171152176405*^9}, {
   3.549171188249469*^9, 3.5491711960149126`*^9}, {3.549171245211727*^9, 
   3.549171292423427*^9}, {3.5491713654606047`*^9, 3.5491714122532806`*^9}, {
   3.5491714542616835`*^9, 3.549171499414266*^9}, {3.549171545062877*^9, 
   3.549171591685544*^9}, {3.5491716459636483`*^9, 3.54917167361223*^9}, {
   3.549171717310729*^9, 3.5491717723878794`*^9}, {3.549171887371456*^9, 
   3.549171891446689*^9}, {3.5491719453927746`*^9, 3.5491719507800827`*^9}, {
   3.5525023919902387`*^9, 3.5525024112094727`*^9}, {3.5525024639687653`*^9, 
   3.55250248958401*^9}, {3.552503044773385*^9, 3.5525030518713975`*^9}, {
   3.5525312772776604`*^9, 3.552531327556549*^9}, 3.552531448207161*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"KnownMultinomialQ", "[", 
   RowBox[{"u_", ",", "x_Symbol", ",", 
    RowBox[{"flag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"BinomialQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
   RowBox[{"QuadraticQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
   RowBox[{"TrinomialQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", "\n", "  ", 
   RowBox[{"GeneralizedBinomialQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}], " ", "||", " ", 
   RowBox[{"GeneralizedTrinomialQ", "[", 
    RowBox[{"u", ",", "x", ",", "flag"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.541271919655511*^9}, {
   3.541271955505561*^9, 3.5412720655457153`*^9}, {3.541272156865843*^9, 
   3.5412721838358808`*^9}, 3.5412722663759966`*^9, 3.5412723619861298`*^9, {
   3.5412723928461733`*^9, 3.541272453086258*^9}, {3.5412725578164043`*^9, 
   3.541272593776455*^9}, {3.5412726451765265`*^9, 3.5412726482465305`*^9}, {
   3.5412729298069253`*^9, 3.541272944396946*^9}, {3.5412729941370153`*^9, 
   3.541273003657028*^9}, {3.5412737435280647`*^9, 3.541273763178092*^9}, {
   3.5412738383181973`*^9, 3.5412738654782352`*^9}, {3.5412739401883397`*^9, 
   3.5412739480383506`*^9}, {3.541274018018449*^9, 3.541274018268449*^9}, {
   3.5412740508784943`*^9, 3.541274082028538*^9}, {3.5412741591486464`*^9, 
   3.5412741736086664`*^9}, {3.541274216918727*^9, 3.5412742187187295`*^9}, {
   3.541274273498806*^9, 3.541274316828867*^9}, 3.5412780386240773`*^9, 
   3.5412781428242235`*^9, 3.5412782994744425`*^9, {3.5487148420611763`*^9, 
   3.5487149467313223`*^9}, {3.548715004951404*^9, 3.548715011611413*^9}, {
   3.5487197866476994`*^9, 3.5487197870977*^9}, {3.5487198423477774`*^9, 
   3.5487198899478445`*^9}, {3.5487199680779533`*^9, 3.548719996057993*^9}, {
   3.5487200336980457`*^9, 3.548720040978056*^9}, {3.5487200720780993`*^9, 
   3.548720091878127*^9}, {3.548720178428248*^9, 3.548720189198263*^9}, 
   3.5487202286683187`*^9, {3.549169439141425*^9, 3.549169481273835*^9}, {
   3.5501937383641872`*^9, 3.5501937430641937`*^9}, {3.5502863761627493`*^9, 
   3.550286379127919*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["StandardizeIntegrand", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5402316300841627`*^9, 3.540231636776574*^9}, {
   3.5402360168026667`*^9, 3.540236025351482*^9}}],

Cell["\<\
u can be put in the form of a know integrand.  StandardizeIntegrand[u,x] \
returns u in the form of a known integrand.\
\>", "Item",
 CellChangeTimes->{
  3.540237245020024*^9, {3.5408669042411575`*^9, 3.540866914022374*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "m"}], "*", 
    RowBox[{"StandardizeIntegrand", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"m", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.541271919655511*^9}, {
   3.541271955505561*^9, 3.5412720655457153`*^9}, {3.541272156865843*^9, 
   3.5412721838358808`*^9}, 3.5412722663759966`*^9, 3.5412723619861298`*^9, {
   3.5412723928461733`*^9, 3.541272453086258*^9}, {3.5412725578164043`*^9, 
   3.541272593776455*^9}, {3.5412726451765265`*^9, 3.5412726482465305`*^9}, {
   3.5412729298069253`*^9, 3.541272944396946*^9}, {3.5412729941370153`*^9, 
   3.541273003657028*^9}, {3.5412737435280647`*^9, 3.541273763178092*^9}, {
   3.5412738383181973`*^9, 3.5412738654782352`*^9}, {3.5412739401883397`*^9, 
   3.5412739480383506`*^9}, {3.541274018018449*^9, 3.541274018268449*^9}, {
   3.5412740508784943`*^9, 3.541274082028538*^9}, {3.5412741591486464`*^9, 
   3.5412741736086664`*^9}, {3.541274216918727*^9, 3.5412742187187295`*^9}, {
   3.541274273498806*^9, 3.541274316828867*^9}, 3.5412780386240773`*^9, 
   3.5412781428242235`*^9, 3.5412782994744425`*^9, {3.5487148420611763`*^9, 
   3.5487149467313223`*^9}, {3.548715004951404*^9, 3.548715011611413*^9}, {
   3.5487197866476994`*^9, 3.5487197870977*^9}, {3.5487198423477774`*^9, 
   3.5487198899478445`*^9}, {3.5487199680779533`*^9, 3.548719996057993*^9}, {
   3.5487200336980457`*^9, 3.548720040978056*^9}, {3.5487200720780993`*^9, 
   3.548720091878127*^9}, {3.548720178428248*^9, 3.548720189198263*^9}, 
   3.5487202286683187`*^9, {3.5491703335155807`*^9, 3.54917041795341*^9}, {
   3.549172088531962*^9, 3.549172113279377*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "+", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{"u", ",", "x"}], "]"}], " ", "+", " ", 
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{"v", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.5402383819968204`*^9, 3.540238441183325*^9}, {
   3.5402384925698147`*^9, 3.5402385384806957`*^9}, {3.5402385979792004`*^9, 
   3.5402386239064455`*^9}, 3.540239454670305*^9, {3.5402406455210133`*^9, 
   3.54024068915429*^9}, {3.540240760009615*^9, 3.5402408344217453`*^9}, {
   3.5402410161464643`*^9, 3.5402410470345187`*^9}, 3.5402411816471553`*^9, {
   3.5402412147972136`*^9, 3.540241218931221*^9}, 3.540241266901305*^9, {
   3.5402419289976683`*^9, 3.540242029352644*^9}, {3.540242111143588*^9, 
   3.540242175758901*^9}, {3.540242236911009*^9, 3.54024223753501*^9}, {
   3.540866690785982*^9, 3.540866707088011*^9}, {3.540866800578975*^9, 
   3.5408668073025866`*^9}, {3.5408668541494694`*^9, 3.540866880763116*^9}, {
   3.541270763493892*^9, 3.5412708410840006`*^9}, {3.541271815365365*^9, 
   3.541271824075377*^9}, {3.54127186893544*^9, 3.5412719145655036`*^9}, {
   3.5412779902940097`*^9, 3.541277997094019*^9}, 3.5412822572144947`*^9, {
   3.541282363774644*^9, 3.5412823964346895`*^9}, {3.541282438274748*^9, 
   3.5412824542147703`*^9}, {3.549172134800608*^9, 3.549172150778522*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "^", "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "]"}], 
     "[", 
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"BinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f_", "[", 
       RowBox[{"u_", "^", "m_."}], "]"}], "^", "p_."}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"#", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "m"}], "]"}], 
       "^", "p"}], "]"}], "[", 
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"BinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f_", "^", 
       RowBox[{"(", 
        RowBox[{"u_", "^", "m_."}], ")"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "*", 
             RowBox[{"x", "^", 
              RowBox[{"#", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "m"}], 
         ")"}]}], ")"}], "^", "p"}], "]"}], "[", 
    RowBox[{"BinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, {3.5494970037107534`*^9, 
   3.5494970808372884`*^9}, {3.549497111335342*^9, 3.54949715019501*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "^", "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}], ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "^", "p"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "^", "p"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, 
   3.549172824448054*^9, {3.5491734456505847`*^9, 3.5491735142225065`*^9}, {
   3.549386602334258*^9, 3.5493866033638597`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "^", "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"#", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}]}], ")"}], "^", 
       "p"}], "]"}], "[", 
     RowBox[{"TrinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"TrinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}], ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"#", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}]}], "]"}], "^", 
       "p"}], "]"}], "[", 
     RowBox[{"TrinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"TrinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"#", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}]}], ")"}]}], ")"}], 
      "^", "p"}], "]"}], "[", 
    RowBox[{"TrinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"TrinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, 
   3.5491728590450325`*^9, {3.549173523861058*^9, 3.5491735972832575`*^9}, {
   3.549386604175061*^9, 3.5493866051578627`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "^", "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], "+", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "]"}], 
     "[", 
     RowBox[{"GeneralizedBinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"GeneralizedBinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}], ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], "+", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], "]"}], "^", "p"}], "]"}], 
     "[", 
     RowBox[{"GeneralizedBinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"GeneralizedBinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], "+", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}]}], ")"}], "^", "p"}],
      "]"}], "[", 
    RowBox[{"GeneralizedBinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"GeneralizedBinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, {
   3.5491728829053974`*^9, 3.5491728855665493`*^9}, {3.5491736304891567`*^9, 
   3.549173686591366*^9}, {3.5493866058754644`*^9, 3.549386606998666*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "^", "p_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"#", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], "-", 
             RowBox[{"#", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ")"}]}]}]}], ")"}], "^", 
       "p"}], "]"}], "[", 
     RowBox[{"GeneralizedTrinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"GeneralizedTrinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}], ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "5", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"#", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], "-", 
             RowBox[{"#", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ")"}]}]}]}], "]"}], "^", 
       "p"}], "]"}], "[", 
     RowBox[{"GeneralizedTrinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"GeneralizedTrinomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#", "[", 
             RowBox[{"[", "5", "]"}], "]"}]}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#", "[", 
             RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", 
               RowBox[{"#", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], "-", 
              RowBox[{"#", "[", 
               RowBox[{"[", "5", "]"}], "]"}]}], ")"}]}]}]}], ")"}]}], ")"}], 
      "^", "p"}], "]"}], "[", 
    RowBox[{"GeneralizedTrinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"GeneralizedTrinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, 
   3.5491729080148335`*^9, {3.5491737014512157`*^9, 3.5491737545652533`*^9}, {
   3.549386607950268*^9, 3.549386612723876*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"u_", "^", "p_."}], "*", 
      RowBox[{"v_", "^", "q_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#1", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"#2", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#1", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "q"}]}], "]"}],
      "[", 
     RowBox[{
      RowBox[{"BinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", 
      RowBox[{"BinomialTest", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"BinomialQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"BinomialDegree", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "-", 
       RowBox[{"BinomialDegree", "[", 
        RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"u_", "^", "p_."}], "*", 
      RowBox[{
       RowBox[{"f_", "[", 
        RowBox[{"v_", "^", "m_."}], "]"}], "^", "q_."}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"#1", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"#1", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "*", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"#2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "*", 
             RowBox[{"x", "^", 
              RowBox[{"#1", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "m"}], "]"}],
         "^", "q"}]}], "]"}], "[", 
     RowBox[{
      RowBox[{"BinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", 
      RowBox[{"BinomialTest", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "m", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"BinomialQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"BinomialDegree", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "-", 
       RowBox[{"BinomialDegree", "[", 
        RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u_", "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"v_", "^", "m_."}], ")"}]}], ")"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#1", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"#2", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{
              RowBox[{"#2", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "m"}], 
          ")"}]}], ")"}], "^", "q"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", 
     RowBox[{"BinomialTest", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "m", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "-", 
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, 
   3.549173024010468*^9, {3.5491738323107004`*^9, 3.549173833948794*^9}, {
   3.5491739405748925`*^9, 3.549173990290736*^9}, {3.549393731389198*^9, 
   3.5493937632992425`*^9}, {3.549497645839081*^9, 3.5494976956031685`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "*", 
      RowBox[{"w_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", "\n", "  ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"w", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "w"}], "}"}], ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"f_", "[", "w_", "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", "\n", "  ", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"w", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "^", "p"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "w"}], "}"}], ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"v_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", "w_"}], ")"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"w", ",", "x", ",", "2"}], "]"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "^", "p"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", ",", "w"}], "}"}], ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, {
   3.549172497738367*^9, 3.5491725274570665`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "*", 
      RowBox[{"u_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
      "m"}], "*", "\n", "  ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"f_", "[", "u_", "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
      "m"}], "*", "\n", "  ", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "^", "p"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"v_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", "u_"}], ")"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
     "m"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}], "^", "p"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, {
   3.549172661926758*^9, 3.5491726789477315`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"v_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "*", 
         RowBox[{"x", "^", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", 
             RowBox[{"#2", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}]}], ")"}], "^", 
       "p"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", 
     RowBox[{"TrinomialTest", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"TrinomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "-", 
      RowBox[{"TrinomialDegree", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, {3.540237837945865*^9, 
   3.5402379321076307`*^9}, {3.54023816514084*^9, 3.5402381860916767`*^9}, {
   3.540238228960552*^9, 3.5402382658858166`*^9}, {3.5402388548960514`*^9, 
   3.5402389089657464`*^9}, {3.540239012924329*^9, 3.540239039225975*^9}, {
   3.5402390724852333`*^9, 3.5402391111265016`*^9}, {3.5402391924650445`*^9, 
   3.54023920140386*^9}, {3.5402392381263247`*^9, 3.540239260325164*^9}, 
   3.5402393177020645`*^9, {3.543441023284721*^9, 3.543441025584724*^9}, {
   3.543441128574868*^9, 3.543441144984891*^9}, {3.54344162278556*^9, 
   3.543441661285614*^9}, 3.5434417208556976`*^9, 3.549172852269645*^9, 
   3.5491732065079064`*^9, {3.5491733643849363`*^9, 3.549173373472456*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"v_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "*", 
         RowBox[{"x", "^", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "^", 
          RowBox[{"#2", "[", 
           RowBox[{"[", "5", "]"}], "]"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#2", "[", 
            RowBox[{"[", "4", "]"}], "]"}]}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", 
              RowBox[{"#2", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], "-", 
             RowBox[{"#2", "[", 
              RowBox[{"[", "5", "]"}], "]"}]}], ")"}]}]}]}], ")"}], "^", 
       "p"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", 
     RowBox[{"GeneralizedTrinomialTest", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"GeneralizedTrinomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "-", 
      RowBox[{"GeneralizedTrinomialDegree", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5434400114933043`*^9, 3.5434400395833435`*^9}, 3.543440083193405*^9, {
   3.543440129233469*^9, 3.54344017294353*^9}, {3.543440205573576*^9, 
   3.5434402189735947`*^9}, {3.5434402822936835`*^9, 3.543440311373724*^9}, {
   3.5434403652837996`*^9, 3.5434403900838346`*^9}, 3.5434404369238997`*^9, {
   3.5434412005049686`*^9, 3.5434412415350266`*^9}, {3.5434413616751947`*^9, 
   3.5434413643051987`*^9}, {3.5434414065852575`*^9, 
   3.5434415438054495`*^9}, {3.543441781545782*^9, 3.543441835375858*^9}, 
   3.5436989950144424`*^9, 3.5491729008904257`*^9, 3.549173301238325*^9, {
   3.5491733783737364`*^9, 3.5491733960907497`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u_", "^", "m_."}], "*", 
     RowBox[{"v_", "^", "p_."}], "*", 
     RowBox[{"w_", "^", "q_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#1", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "m"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#1", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "p"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#3", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#3", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#1", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "^", "q"}]}], "]"}], 
    "[", 
    RowBox[{
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", 
     RowBox[{"BinomialTest", "[", 
      RowBox[{"v", ",", "x"}], "]"}], ",", 
     RowBox[{"BinomialTest", "[", 
      RowBox[{"w", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "p", ",", "q"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "-", 
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "-", 
      RowBox[{"BinomialDegree", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, 3.5491722381575203`*^9, 3.549172619491331*^9, {
   3.5491730035052953`*^9, 3.5491730165190396`*^9}, {3.549173086879064*^9, 
   3.5491730872710867`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "*", "w_", "*", 
      RowBox[{"u_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
      "m"}], "*", "\n", "  ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "*", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "2"}], "]"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "w"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"QuadraticQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{"r_", "^", "2"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"p", "-", "1"}], "]"}]}], "]"}]}], " ", "*)"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"v_", "^", "m_."}], "*", 
     RowBox[{"w_", "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "*", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "2"}], "]"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", ",", "w"}], "}"}], ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, {3.5402373662010365`*^9, 
   3.540237554540168*^9}, 3.54023761321187*^9, {3.5402376524615393`*^9, 
   3.5402376636779594`*^9}, {3.54023769824762*^9, 3.5402377040976305`*^9}, {
   3.5402377395252924`*^9, 3.540237746233304*^9}, {3.5402377765285573`*^9, 
   3.540237780740565*^9}, {3.5402409204870963`*^9, 3.5402409689407816`*^9}, {
   3.549167629715932*^9, 3.5491676385924397`*^9}, {3.5491677114316063`*^9, 
   3.549167786979927*^9}, {3.549167982282098*^9, 3.5491680885711775`*^9}, 
   3.549172493263111*^9, 3.549172651885184*^9, 3.549172819069746*^9, {
   3.5491731005568466`*^9, 3.549173104268059*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u_", "^", "m_."}], "*", 
     RowBox[{"v_", "^", "p_."}], "*", 
     RowBox[{"w_", "^", "q_."}], "*", 
     RowBox[{"z_", "^", "r_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
     "m"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
     "p"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"w", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"w", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
     "q"}], "*", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"z", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"z", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^", 
     "r"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "p", ",", "q", ",", "r"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "w", ",", "z"}], "}"}], ",", "x"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, 3.5402404582582846`*^9, {
   3.540240853360179*^9, 3.54024089393585*^9}, {3.5402413781607003`*^9, 
   3.540241456051637*^9}, {3.5402415575454154`*^9, 3.540241558403417*^9}, {
   3.5491631446394005`*^9, 3.5491631677917247`*^9}, {3.549163856449114*^9, 
   3.5491639061199546`*^9}, {3.54916397911613*^9, 3.549164037217453*^9}, 
   3.549164075858663*^9, {3.54916430134356*^9, 3.5491643913897104`*^9}, {
   3.5491645248623447`*^9, 3.549164556473153*^9}, {3.549164689374754*^9, 
   3.549164694137027*^9}, {3.5491648360621443`*^9, 3.5491648842118983`*^9}, {
   3.5491650138533134`*^9, 3.5491650341334734`*^9}, 3.549165079791085*^9, {
   3.549165117848262*^9, 3.5491651259807267`*^9}, {3.5491652153018355`*^9, 
   3.5491652296756573`*^9}, {3.5491663776493177`*^9, 
   3.5491663795054245`*^9}, {3.5491665642459908`*^9, 3.549166630826799*^9}, 
   3.5491682475422697`*^9, {3.549172233383247*^9, 3.549172271001398*^9}, {
   3.5491723487598457`*^9, 3.5491723669078836`*^9}, 3.5491724654515204`*^9, {
   3.549172623052535*^9, 3.5491726249736443`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"u_", "^", "n_."}]}], "]"}], "/", "v_"}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
          RowBox[{
           RowBox[{"Coefficient", "[", 
            RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], 
        "^", "n"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}]}], " ",
     "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"u_", "^", "n_."}]}], "]"}], "/", "v_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"c", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "0"}], "]"}], "+", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}], "^",
        "n"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, {3.540237837945865*^9, 
   3.5402379321076307`*^9}, {3.54023816514084*^9, 3.5402381860916767`*^9}, {
   3.540238228960552*^9, 3.5402382658858166`*^9}, {3.5402388548960514`*^9, 
   3.5402389089657464`*^9}, {3.540239012924329*^9, 3.540239039225975*^9}, {
   3.5402390724852333`*^9, 3.5402391111265016`*^9}, {3.5402391924650445`*^9, 
   3.54023920140386*^9}, {3.5402392381263247`*^9, 3.540239260325164*^9}, 
   3.5402393177020645`*^9, {3.5412838640527487`*^9, 3.5412839068628087`*^9}, {
   3.5487159097026706`*^9, 3.548715946422722*^9}, {3.5487160346528454`*^9, 
   3.548716061052882*^9}, 3.5487161283029766`*^9, {3.5487162075930877`*^9, 
   3.548716345643281*^9}, {3.5487164207933865`*^9, 3.5487164502034273`*^9}, {
   3.548720286088399*^9, 3.5487202888584023`*^9}, {3.54872032991846*^9, 
   3.548720338338472*^9}, {3.548720431288602*^9, 3.548720443288619*^9}, {
   3.548720491998687*^9, 3.548720532538744*^9}, {3.548736735763756*^9, 
   3.548736875966775*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"StandardizeIntegrand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", "v_"}], ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "4", "]"}], "]"}], "*", "x"}]}], ")"}]}], "]"}], 
       "[", 
       RowBox[{"QuotientOfLinearsParts", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}], "]"}], "/", "\n", "\t", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Coefficient", "[", 
         RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}]}], ")"}]}], " ",
     "/;", "\n", 
    RowBox[{
     RowBox[{"QuotientOfLinearsQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "u_", "]"}], "/", "v_"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", "x"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "*", "x"}]}], ")"}]}], "]"}], "[", 
      RowBox[{"QuotientOfLinearsParts", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "]"}], "]"}], "/", "\n", "\t", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Coefficient", "[", 
       RowBox[{"v", ",", "x", ",", "0"}], "]"}], "+", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}], "*", "x"}], "+", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "2"}], "]"}], "*", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"QuadraticQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, {3.540237837945865*^9, 
   3.5402379321076307`*^9}, {3.54023816514084*^9, 3.5402381860916767`*^9}, {
   3.540238228960552*^9, 3.5402382658858166`*^9}, {3.5402388548960514`*^9, 
   3.5402389089657464`*^9}, {3.540239012924329*^9, 3.540239039225975*^9}, {
   3.5402390724852333`*^9, 3.5402391111265016`*^9}, {3.5402391924650445`*^9, 
   3.54023920140386*^9}, {3.5402392381263247`*^9, 3.540239260325164*^9}, 
   3.5402393177020645`*^9, {3.5412838640527487`*^9, 3.5412839068628087`*^9}, {
   3.5487159097026706`*^9, 3.548715946422722*^9}, {3.5487160346528454`*^9, 
   3.548716061052882*^9}, 3.5487161283029766`*^9, {3.5487162075930877`*^9, 
   3.548716345643281*^9}, {3.5487164207933865`*^9, 3.5487164502034273`*^9}, {
   3.548720286088399*^9, 3.5487202888584023`*^9}, {3.54872032991846*^9, 
   3.548720338338472*^9}, {3.548720431288602*^9, 3.548720443288619*^9}, {
   3.548720491998687*^9, 3.548720532538744*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardizeIntegrand", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"u", " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5402316546542053`*^9, 3.5402317384263525`*^9}, {3.540231775008417*^9, 
   3.5402318275493093`*^9}, {3.540231971259162*^9, 3.540232119771423*^9}, {
   3.540232159645093*^9, 3.540232240765235*^9}, {3.5402322781273007`*^9, 
   3.540232329295391*^9}, {3.5402325517853813`*^9, 3.5402325719250174`*^9}, {
   3.5402326255267115`*^9, 3.5402326962104354`*^9}, {3.540232731950098*^9, 
   3.540232763727354*^9}, 3.540232996457362*^9, {3.5402330289990196`*^9, 
   3.540233053101062*^9}, 3.540233207463333*^9, {3.540233238351387*^9, 
   3.5402333622780046`*^9}, {3.5402334036960773`*^9, 
   3.5402334445057497`*^9}, {3.540233481243814*^9, 3.5402335175450773`*^9}, {
   3.5402335543299427`*^9, 3.540233588712403*^9}, {3.540233637384488*^9, 
   3.540233641612096*^9}, {3.5402336728121505`*^9, 3.54023369540099*^9}, 
   3.5402337831979446`*^9, {3.540233846612056*^9, 3.5402338538036685`*^9}, {
   3.540234069708048*^9, 3.540234082968071*^9}, {3.5402342505435653`*^9, 
   3.5402342731636047`*^9}, {3.5402343240196943`*^9, 
   3.5402344266678743`*^9}, {3.540234536024067*^9, 3.5402345537768974`*^9}, {
   3.5402346174718094`*^9, 3.5402346412774515`*^9}, {3.5402346885767345`*^9, 
   3.540234715923582*^9}, {3.5402347681524744`*^9, 3.540234823735372*^9}, {
   3.5402348732342587`*^9, 3.5402348934206944`*^9}, {3.5402349374907713`*^9, 
   3.5402349780040426`*^9}, 3.5402350106705003`*^9, {3.5402357220329494`*^9, 
   3.5402358091279025`*^9}, {3.540236044180715*^9, 3.5402361068732247`*^9}, {
   3.540236137683279*^9, 3.540236188804569*^9}, {3.5402362595506926`*^9, 
   3.5402362956803565`*^9}, {3.540236331201619*^9, 3.5402363388300323`*^9}, {
   3.54023637174609*^9, 3.5402363944129295`*^9}, {3.540236426143386*^9, 
   3.540236518635948*^9}, {3.5402365540948105`*^9, 3.540236659504195*^9}, {
   3.5402367297511187`*^9, 3.5402367478627505`*^9}, {3.5402367948344336`*^9, 
   3.54023683842091*^9}, {3.540236889276999*^9, 3.5402369402734885`*^9}, {
   3.5402370022679977`*^9, 3.5402370221112328`*^9}, {3.5402370734197226`*^9, 
   3.5402371117801895`*^9}, 3.540237168501889*^9, {3.5402371997955446`*^9, 
   3.540237200045145*^9}, 3.540237287155698*^9, {3.540237837945865*^9, 
   3.5402379321076307`*^9}, {3.54023816514084*^9, 3.5402381860916767`*^9}, {
   3.540238228960552*^9, 3.5402382658858166`*^9}, {3.5402388548960514`*^9, 
   3.5402389089657464`*^9}, {3.540239012924329*^9, 3.540239039225975*^9}, {
   3.5402390724852333`*^9, 3.5402391111265016`*^9}, {3.5402391924650445`*^9, 
   3.54023920140386*^9}, {3.5402392381263247`*^9, 3.540239260325164*^9}, 
   3.5402393177020645`*^9, {3.5412838640527487`*^9, 3.5412839068628087`*^9}, {
   3.541285102806312*^9, 3.5412851254563437`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Normalization Functions", "Section",
 CellChangeTimes->{{3.5195140860351057`*^9, 3.51951409565512*^9}, {
  3.528926707473311*^9, 3.528926711498118*^9}, {3.5371295293701863`*^9, 
  3.5371295323601904`*^9}, {3.5372916025635805`*^9, 3.537291605952774*^9}, {
  3.537667397198867*^9, 3.537667400798872*^9}, {3.540231114959881*^9, 
  3.540231121121892*^9}}],

Cell[CellGroupData[{

Cell["SimplifyIntegrand", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SimplifyIntegrand", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "simplifies", " ", "u", " ", "and", 
    " ", "returns", " ", "the", " ", "result", " ", "in", " ", "a", " ", 
    "standard", " ", "form", " ", "recognizable", " ", "by", " ", 
    "integration", " ", 
    RowBox[{"rules", "."}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SimplifyIntegrand", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"KnownIntegrandQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"StandardizeIntegrand", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "v", "}"}], ",", "\n", "  ", 
        RowBox[{
         RowBox[{"v", "=", 
          RowBox[{"NormalizeLeadTermSigns", "[", 
           RowBox[{"NormalizeIntegrandAux", "[", 
            RowBox[{
             RowBox[{"Simplify", "[", "u", "]"}], ",", "x"}], "]"}], "]"}]}], 
         ";", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"v", "===", 
            RowBox[{"NormalizeLeadTermSigns", "[", "u", "]"}]}], ",", "\n", 
           "    ", "u", ",", "\n", "  ", "v"}], "]"}]}]}], "]"}]}], "]"}]}], 
   "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SimplifyIntegrand", "[", 
      RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"v", "=", 
          RowBox[{"Together", "[", "u", "]"}]}], ",", "lst"}], "}"}], ",", 
       "\n", "  ", 
       RowBox[{
        RowBox[{"lst", "=", 
         RowBox[{"SplitFreeFactors", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"KnownIntegrandQ", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
          "    ", 
          RowBox[{
           RowBox[{"Simplify", "[", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
           RowBox[{"StandardizeIntegrand", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
          "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"KnownIntegrandQ", "[", 
             RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
            RowBox[{"StandardizeIntegrand", "[", 
             RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
            RowBox[{
             RowBox[{"v", "=", 
              RowBox[{"NormalizeLeadTermSigns", "[", 
               RowBox[{"NormalizeIntegrandAux", "[", 
                RowBox[{
                 RowBox[{"Simplify", "[", "v", "]"}], ",", "x"}], "]"}], 
               "]"}]}], ";", "\n", "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"v", "===", 
                RowBox[{"NormalizeLeadTermSigns", "[", "u", "]"}]}], ",", 
               "\n", "    ", "u", ",", "\n", "  ", "v"}], "]"}]}]}], "]"}]}], 
         "]"}]}]}], "]"}]}], " ", "*)"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, {3.5372312602134686`*^9, 
   3.5372312965135193`*^9}, {3.537287055325494*^9, 3.537287055936528*^9}, {
   3.537287180865674*^9, 3.537287254339876*^9}, {3.5372874018533134`*^9, 
   3.5372874198303423`*^9}, {3.5372882896170907`*^9, 3.537288304831961*^9}, {
   3.5372883376828403`*^9, 3.537288342082092*^9}, {3.5372884063797693`*^9, 
   3.5372884566566453`*^9}, {3.537289689835179*^9, 3.537289691149254*^9}, {
   3.5372897223810406`*^9, 3.5372897915519967`*^9}, 3.537290126999183*^9, 
   3.540230872078655*^9, {3.540231035478942*^9, 3.5402310376941457`*^9}, {
   3.5412808418785105`*^9, 3.541280844348514*^9}, {3.5412809577186728`*^9, 
   3.5412809709886913`*^9}, {3.541281009628745*^9, 3.5412810111987476`*^9}, {
   3.5412810462187967`*^9, 3.5412810570388117`*^9}, {3.5423066313953867`*^9, 
   3.542306636005393*^9}, {3.549414434063592*^9, 3.5494145128537025`*^9}, {
   3.549414543173745*^9, 3.5494146187838507`*^9}, {3.549414651613897*^9, 
   3.549414773824068*^9}, {3.5494149106862607`*^9, 3.5494149110462613`*^9}, {
   3.5496499549430847`*^9, 3.5496500056431737`*^9}, 3.5496500361256275`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
NormalForm                   xxxxxxxxxxxxxxxxxxxxxxxxxx\
\>", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5372871004680758`*^9, 3.5372871045813107`*^9}, 
   3.541981819970476*^9, {3.54230667673545*^9, 3.5423066795754538`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"NormalForm", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", "u"}], " ",
   "*)"}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372034445996094`*^9, 3.537203490859674*^9}, {
   3.5372035287997274`*^9, 3.537203533069733*^9}, {3.537210844681978*^9, 
   3.5372109283820953`*^9}, {3.537214589627221*^9, 3.53721463892729*^9}, {
   3.5372252945316105`*^9, 3.5372254091917715`*^9}, {3.5372254878618813`*^9, 
   3.5372255505419693`*^9}, {3.537225898812457*^9, 3.537225977482567*^9}, {
   3.537226098712737*^9, 3.5372261029927425`*^9}, {3.537226136182789*^9, 
   3.537226144502801*^9}, {3.537226246162943*^9, 3.5372262621529655`*^9}, {
   3.5372263190730453`*^9, 3.537226322003049*^9}, {3.537228887894143*^9, 
   3.5372289481442275`*^9}, {3.5372295210850296`*^9, 
   3.5372295612450857`*^9}, {3.5372295968251357`*^9, 
   3.5372296030951443`*^9}, {3.53723225970387*^9, 3.537232287043908*^9}, {
   3.537232374404031*^9, 3.5372323956540604`*^9}, 3.5372331417771063`*^9, {
   3.537235060219792*^9, 3.5372351475999146`*^9}, {3.5372351995499873`*^9, 
   3.5372352000399876`*^9}, {3.5372352345000362`*^9, 3.537235240340044*^9}, {
   3.5372352812401013`*^9, 3.5372352835701046`*^9}, {3.537235398750266*^9, 
   3.5372354943103995`*^9}, {3.5372355381604614`*^9, 
   3.5372357023006907`*^9}, {3.537235749040756*^9, 3.5372358162908506`*^9}, {
   3.5372358986309657`*^9, 3.537236018281133*^9}, {3.5372361074512577`*^9, 
   3.5372361495313168`*^9}, {3.5372361842713656`*^9, 
   3.5372363363315783`*^9}, {3.5372363748316326`*^9, 3.537236383461644*^9}, {
   3.5372364163116903`*^9, 3.5372364557217455`*^9}, {3.5372365790019183`*^9, 
   3.5372365830319242`*^9}, {3.537236635541998*^9, 3.5372367843722057`*^9}, {
   3.5372368624923153`*^9, 3.5372369912824955`*^9}, {3.537237062382595*^9, 
   3.5372370666726007`*^9}, {3.537237097362644*^9, 3.537237198012785*^9}, {
   3.5372372543028636`*^9, 3.537237385213047*^9}, {3.537237417283092*^9, 
   3.5372375085732193`*^9}, {3.537237593013338*^9, 3.5372375934933386`*^9}, {
   3.5372376320833926`*^9, 3.537237704703494*^9}, {3.5372377414335456`*^9, 
   3.537237843153688*^9}, 3.5372380685540037`*^9, {3.5372869783130884`*^9, 
   3.5372869959650984`*^9}, {3.537287262184325*^9, 3.537287274461027*^9}, {
   3.537287415633102*^9, 3.537287423031525*^9}, {3.5372884692033625`*^9, 
   3.537288471970521*^9}, {3.537289683804834*^9, 3.5372896865109887`*^9}, {
   3.5372898095370255`*^9, 3.537289812672205*^9}, {3.5372898998241897`*^9, 
   3.537289918487257*^9}, {3.5372900887289944`*^9, 3.537290111433293*^9}, 
   3.540230873217457*^9, {3.5402310388329477`*^9, 3.5402310393945484`*^9}, {
   3.541281215239033*^9, 3.5412812175390368`*^9}, {3.541282057054214*^9, 
   3.5412820593942175`*^9}, {3.5419818215704784`*^9, 
   3.5419818302204905`*^9}, {3.5423066712654424`*^9, 3.5423066748554473`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["NormalizeIntegrand", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5372871004680758`*^9, 3.5372871045813107`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NormalizeIntegrand", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "u", " ", "in", " ",
     "a", " ", "standard", " ", "form", " ", "recognizable", " ", "by", " ", 
    "integration", " ", 
    RowBox[{"rules", "."}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"NormalizeIntegrand", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"NormalizeLeadTermSigns", "[", 
        RowBox[{"NormalizeIntegrandAux", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"v", "===", 
        RowBox[{"NormalizeLeadTermSigns", "[", "u", "]"}]}], ",", "\n", 
       "    ", "u", ",", "\n", "  ", "v"}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372034445996094`*^9, 3.537203490859674*^9}, {
   3.5372035287997274`*^9, 3.537203533069733*^9}, {3.537210844681978*^9, 
   3.5372109283820953`*^9}, {3.537214589627221*^9, 3.53721463892729*^9}, {
   3.5372252945316105`*^9, 3.5372254091917715`*^9}, {3.5372254878618813`*^9, 
   3.5372255505419693`*^9}, {3.537225898812457*^9, 3.537225977482567*^9}, {
   3.537226098712737*^9, 3.5372261029927425`*^9}, {3.537226136182789*^9, 
   3.537226144502801*^9}, {3.537226246162943*^9, 3.5372262621529655`*^9}, {
   3.5372263190730453`*^9, 3.537226322003049*^9}, {3.537228887894143*^9, 
   3.5372289481442275`*^9}, {3.5372295210850296`*^9, 
   3.5372295612450857`*^9}, {3.5372295968251357`*^9, 
   3.5372296030951443`*^9}, {3.53723225970387*^9, 3.537232287043908*^9}, {
   3.537232374404031*^9, 3.5372323956540604`*^9}, 3.5372331417771063`*^9, {
   3.537235060219792*^9, 3.5372351475999146`*^9}, {3.5372351995499873`*^9, 
   3.5372352000399876`*^9}, {3.5372352345000362`*^9, 3.537235240340044*^9}, {
   3.5372352812401013`*^9, 3.5372352835701046`*^9}, {3.537235398750266*^9, 
   3.5372354943103995`*^9}, {3.5372355381604614`*^9, 
   3.5372357023006907`*^9}, {3.537235749040756*^9, 3.5372358162908506`*^9}, {
   3.5372358986309657`*^9, 3.537236018281133*^9}, {3.5372361074512577`*^9, 
   3.5372361495313168`*^9}, {3.5372361842713656`*^9, 
   3.5372363363315783`*^9}, {3.5372363748316326`*^9, 3.537236383461644*^9}, {
   3.5372364163116903`*^9, 3.5372364557217455`*^9}, {3.5372365790019183`*^9, 
   3.5372365830319242`*^9}, {3.537236635541998*^9, 3.5372367843722057`*^9}, {
   3.5372368624923153`*^9, 3.5372369912824955`*^9}, {3.537237062382595*^9, 
   3.5372370666726007`*^9}, {3.537237097362644*^9, 3.537237198012785*^9}, {
   3.5372372543028636`*^9, 3.537237385213047*^9}, {3.537237417283092*^9, 
   3.5372375085732193`*^9}, {3.537237593013338*^9, 3.5372375934933386`*^9}, {
   3.5372376320833926`*^9, 3.537237704703494*^9}, {3.5372377414335456`*^9, 
   3.537237843153688*^9}, 3.5372380685540037`*^9, {3.5372869783130884`*^9, 
   3.5372869959650984`*^9}, {3.537287262184325*^9, 3.537287274461027*^9}, {
   3.537287415633102*^9, 3.537287423031525*^9}, {3.5372884692033625`*^9, 
   3.537288471970521*^9}, {3.537289683804834*^9, 3.5372896865109887`*^9}, {
   3.5372898095370255`*^9, 3.537289812672205*^9}, {3.5372898998241897`*^9, 
   3.537289918487257*^9}, {3.5372900887289944`*^9, 3.537290111433293*^9}, 
   3.540230873217457*^9, {3.5402310388329477`*^9, 3.5402310393945484`*^9}, {
   3.541281215239033*^9, 3.5412812175390368`*^9}, {3.541282057054214*^9, 
   3.5412820593942175`*^9}, {3.542306595605336*^9, 3.542306615275364*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["NormalizeIntegrandAux", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5372871004680758`*^9, 3.5372871045813107`*^9}, {
   3.5372875337278566`*^9, 3.537287537442069*^9}, {3.537667402268874*^9, 
   3.5376674043288765`*^9}, {3.5377185805285234`*^9, 3.537718582088526*^9}, {
   3.5402308998067036`*^9, 3.540230906561516*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeIntegrandAux", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"NormalizeIntegrandAux", "[", 
        RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"NormalizeIntegrandFactor", "[", 
          RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n",
       "  ", 
      RowBox[{"NormalizeIntegrandFactor", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372034445996094`*^9, 3.537203490859674*^9}, {
   3.5372035287997274`*^9, 3.537203533069733*^9}, {3.537210844681978*^9, 
   3.5372109283820953`*^9}, {3.537214589627221*^9, 3.53721463892729*^9}, {
   3.5372252945316105`*^9, 3.5372254091917715`*^9}, {3.5372254878618813`*^9, 
   3.5372255505419693`*^9}, {3.537225898812457*^9, 3.537225977482567*^9}, {
   3.537226098712737*^9, 3.5372261029927425`*^9}, {3.537226136182789*^9, 
   3.537226144502801*^9}, {3.537226246162943*^9, 3.5372262621529655`*^9}, {
   3.5372263190730453`*^9, 3.537226322003049*^9}, {3.537228887894143*^9, 
   3.5372289481442275`*^9}, {3.5372295210850296`*^9, 
   3.5372295612450857`*^9}, {3.5372295968251357`*^9, 
   3.5372296030951443`*^9}, {3.53723225970387*^9, 3.537232287043908*^9}, {
   3.537232374404031*^9, 3.5372323956540604`*^9}, 3.5372331417771063`*^9, {
   3.537235060219792*^9, 3.5372351475999146`*^9}, {3.5372351995499873`*^9, 
   3.5372352000399876`*^9}, {3.5372352345000362`*^9, 3.537235240340044*^9}, {
   3.5372352812401013`*^9, 3.5372352835701046`*^9}, {3.537235398750266*^9, 
   3.5372354943103995`*^9}, {3.5372355381604614`*^9, 
   3.5372357023006907`*^9}, {3.537235749040756*^9, 3.5372358162908506`*^9}, {
   3.5372358986309657`*^9, 3.537236018281133*^9}, {3.5372361074512577`*^9, 
   3.5372361495313168`*^9}, {3.5372361842713656`*^9, 
   3.5372363363315783`*^9}, {3.5372363748316326`*^9, 3.537236383461644*^9}, {
   3.5372364163116903`*^9, 3.5372364557217455`*^9}, {3.5372365790019183`*^9, 
   3.5372365830319242`*^9}, {3.537236635541998*^9, 3.5372367843722057`*^9}, {
   3.5372368624923153`*^9, 3.5372369912824955`*^9}, {3.537237062382595*^9, 
   3.5372370666726007`*^9}, {3.537237097362644*^9, 3.537237198012785*^9}, {
   3.5372372543028636`*^9, 3.537237385213047*^9}, {3.537237417283092*^9, 
   3.5372375085732193`*^9}, {3.537237593013338*^9, 3.5372375934933386`*^9}, {
   3.5372376320833926`*^9, 3.537237704703494*^9}, {3.5372377414335456`*^9, 
   3.537237843153688*^9}, 3.5372380685540037`*^9, {3.5372873072429028`*^9, 
   3.5372873324043417`*^9}, {3.537287435237223*^9, 3.537287447851945*^9}, {
   3.537287575119224*^9, 3.5372875755482483`*^9}, {3.5372880402098255`*^9, 
   3.537288078765031*^9}, {3.5372881635558805`*^9, 3.537288202676118*^9}, {
   3.540230874122258*^9, 3.5402308754638605`*^9}, {3.540230974718035*^9, 
   3.540230975919237*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeIntegrandFactor", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"bas", ",", "deg", ",", "min"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
      "    ", 
      RowBox[{
       RowBox[{"bas", "=", 
        RowBox[{"NormalizeIntegrandFactorBase", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ";", "\n", 
       "    ", 
       RowBox[{"deg", "=", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"IntegerQ", "[", "deg", "]"}], " ", "&&", " ", 
          RowBox[{"SumQ", "[", "bas", "]"}]}], ",", "\n", "      ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MapAnd", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"MonomialQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "bas"}], "]"}], 
           ",", "\n", "        ", 
           RowBox[{
            RowBox[{"min", "=", 
             RowBox[{"MinimumMonomialExponent", "[", 
              RowBox[{"bas", ",", "x"}], "]"}]}], ";", "\n", "        ", 
            RowBox[{
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"min", "*", "deg"}], ")"}]}], "*", 
             RowBox[{
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"Simplify", "[", 
                  RowBox[{"#", "/", 
                   RowBox[{"x", "^", "min"}]}], "]"}], "]"}], ",", "bas"}], 
               "]"}], "^", "deg"}]}]}], ",", "\n", "      ", 
           RowBox[{"bas", "^", "deg"}]}], "]"}], ",", "\n", "    ", 
         RowBox[{"bas", "^", "deg"}]}], "]"}]}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"bas", "=", 
        RowBox[{"NormalizeIntegrandFactorBase", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SumQ", "[", "bas", "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MapAnd", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"MonomialQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "bas"}], "]"}], 
           ",", "\n", "      ", 
           RowBox[{
            RowBox[{"min", "=", 
             RowBox[{"MinimumMonomialExponent", "[", 
              RowBox[{"bas", ",", "x"}], "]"}]}], ";", "\n", "      ", 
            RowBox[{
             RowBox[{"x", "^", "min"}], "*", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"#", "/", 
                 RowBox[{"x", "^", "min"}]}], "]"}], ",", "bas"}], "]"}]}]}], 
           ",", "\n", "    ", "bas"}], "]"}], ",", "\n", "  ", "bas"}], 
        "]"}]}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.5372100587908773`*^9, 
   3.53721008911092*^9}, {3.537210406161364*^9, 3.5372105939816265`*^9}, {
   3.5372106331816816`*^9, 3.5372107143017955`*^9}, {3.537210764261865*^9, 
   3.5372107823918905`*^9}, {3.537213176075242*^9, 3.5372137138659945`*^9}, {
   3.5372137590460577`*^9, 3.537213833806163*^9}, {3.5372139236262884`*^9, 
   3.5372139548363323`*^9}, {3.5372140267964325`*^9, 
   3.5372140523064685`*^9}, {3.5372141742466393`*^9, 3.537214176616643*^9}, {
   3.5372147129573936`*^9, 3.537214723507408*^9}, {3.537214790227502*^9, 
   3.5372148961276503`*^9}, 3.5372150647078857`*^9, {3.537215289608201*^9, 
   3.5372152931782055`*^9}, {3.5372321134536653`*^9, 
   3.5372321818437614`*^9}, {3.537285638296912*^9, 3.53728569389541*^9}, {
   3.537285730243474*^9, 3.5372857521771126`*^9}, {3.537285786996373*^9, 
   3.537285846510478*^9}, {3.537285936787836*^9, 3.5372860310588017`*^9}, {
   3.5372875767143154`*^9, 3.5372875777753763`*^9}, {3.5372878487308736`*^9, 
   3.5372878567713337`*^9}, 3.5372879332857103`*^9, {3.537665215815813*^9, 
   3.537665229975833*^9}, {3.5377185519180727`*^9, 3.537718558672885*^9}, {
   3.5384922184297876`*^9, 3.5384922236713967`*^9}, {3.540230976792839*^9, 
   3.540230978384042*^9}, {3.5494924387211347`*^9, 3.549492439547936*^9}, {
   3.549648634279165*^9, 3.5496486361199684`*^9}, {3.5496523849369535`*^9, 
   3.5496523885561595`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeIntegrandFactorBase", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"NormalizeIntegrandFactorBase", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", "#"}], "]"}], ",", "u"}], "]"}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"SumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.537210112570953*^9, 
   3.5372101210209646`*^9}, {3.5372116122330523`*^9, 3.537211621893066*^9}, {
   3.5372117057631836`*^9, 3.5372118713234153`*^9}, {3.5372868203700547`*^9, 
   3.537286827615469*^9}, {3.5372875785784216`*^9, 3.537287579633482*^9}, {
   3.537665027525549*^9, 3.537665036005561*^9}, {3.5381554528018107`*^9, 
   3.5381554602918215`*^9}, {3.5381555173719015`*^9, 3.538155520941906*^9}, {
   3.540230979070443*^9, 3.540230980224845*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalizeIntegrandFactorBase", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"BinomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"BinomialQ", "[", 
       RowBox[{"u", ",", "x", ",", "True"}], "]"}], ",", "\n", "      ", "u", 
      ",", "\n", "    ", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}]}]}], "]"}], "[", 
       RowBox[{"BinomialTest", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"TrinomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"TrinomialQ", "[", 
         RowBox[{"u", ",", "x", ",", "True"}], "]"}], ",", "\n", "      ", 
        "u", ",", "\n", "    ", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"#", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}]}], "+", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", 
               RowBox[{"#", "[", 
                RowBox[{"[", "4", "]"}], "]"}]}], ")"}]}]}]}], "]"}], "[", 
         RowBox[{"TrinomialTest", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"NormalizeIntegrandFactor", "[", 
            RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", 
        "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PolynomialQ", "[", 
            RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
           RowBox[{
            RowBox[{"Exponent", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "\[LessEqual]", "4"}]}], ",", 
          "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"CoefficientList", "[", 
               RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"Sum", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "*", 
               RowBox[{"x", "^", 
                RowBox[{"(", 
                 RowBox[{"i", "-", "1"}], ")"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "1", ",", 
                RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}]}], 
           "]"}], ",", "    ", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"v", "=", 
                RowBox[{"Together", "[", 
                 RowBox[{"Simplify", "[", 
                  RowBox[{"Together", "[", "u", "]"}], "]"}], "]"}]}], "}"}], 
              ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
                 RowBox[{"MatchQ", "[", 
                  RowBox[{"v", ",", " ", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"x", "^", "m_."}], "*", "w_"}], " ", "/;", " ", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
                    RowBox[{"SumQ", "[", "w", "]"}]}]}]}], "]"}], " ", "||", 
                 " ", 
                 RowBox[{
                  RowBox[{"LeafCount", "[", "v", "]"}], ">", 
                  RowBox[{
                   RowBox[{"LeafCount", "[", "u", "]"}], "+", "2"}]}]}], ",", 
                "\n", "      ", "u", ",", "\n", "    ", 
                RowBox[{"NormalizeIntegrandFactorBase", "[", 
                 RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "]"}], ",", "\n", 
            "  ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"NormalizeIntegrandFactor", "[", 
                RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.537210112570953*^9, 
   3.5372101210209646`*^9}, {3.5372116122330523`*^9, 3.537211621893066*^9}, 
   3.5372117057631836`*^9, 3.537287582131625*^9, {3.5373802190908065`*^9, 
   3.5373802576508603`*^9}, {3.5373803072709303`*^9, 
   3.5373803112009354`*^9}, {3.5373804005010605`*^9, 
   3.5373805685712957`*^9}, {3.538155570871976*^9, 3.5381556768621244`*^9}, {
   3.5381558710023966`*^9, 3.538155917362461*^9}, 3.5381561206027455`*^9, 
   3.53815652328331*^9, {3.5381566601635013`*^9, 3.5381566670935106`*^9}, {
   3.5381575075446873`*^9, 3.538157525754713*^9}, {3.5381576433048773`*^9, 
   3.538157645934881*^9}, {3.539018695103525*^9, 3.5390186990927534`*^9}, {
   3.540230980942446*^9, 3.5402309816444473`*^9}, {3.5412783708545427`*^9, 
   3.541278399734583*^9}, {3.5494928746483*^9, 3.549492897814341*^9}, 
   3.551287565952821*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["NormalizeLeadTermSigns", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5372871004680758`*^9, 3.5372871045813107`*^9}, 
   3.5372914791815233`*^9, 3.540231041032552*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NormalizeLeadTermSigns", "[", "u", "]"}], " ", "returns", " ", 
    "an", " ", "expression", " ", "equal", " ", "u", " ", "but", " ", "with", 
    " ", "not", " ", "more", " ", "than", " ", "one", " ", "sum", " ", "\n", 
    "\t", "factor", " ", "raised", " ", "to", " ", "a", " ", "integer", " ", 
    "degree", " ", "having", " ", "a", " ", "lead", " ", "term", " ", "with", 
    " ", "a", " ", "negative", " ", 
    RowBox[{"coefficient", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NormalizeLeadTermSigns", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", " ", 
         RowBox[{"Map", "[", 
          RowBox[{"SignOfFactor", ",", "u"}], "]"}], ",", " ", 
         RowBox[{"SignOfFactor", "[", "u", "]"}]}], "]"}]}], "}"}], ",", "\n",
      "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"lst", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "1"}], ",", "\n", "    ", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "\n", "  ", 
       RowBox[{"AbsorbMinusSign", "[", 
        RowBox[{"lst", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.5372100587908773`*^9, 
   3.53721008911092*^9}, {3.537210406161364*^9, 3.5372105939816265`*^9}, {
   3.5372106331816816`*^9, 3.5372107143017955`*^9}, {3.537210764261865*^9, 
   3.5372107823918905`*^9}, {3.537213176075242*^9, 3.5372137138659945`*^9}, {
   3.5372137590460577`*^9, 3.537213833806163*^9}, {3.5372139236262884`*^9, 
   3.5372139548363323`*^9}, {3.5372140267964325`*^9, 
   3.5372140523064685`*^9}, {3.5372141742466393`*^9, 3.537214176616643*^9}, {
   3.5372147129573936`*^9, 3.537214723507408*^9}, {3.537214790227502*^9, 
   3.5372148961276503`*^9}, 3.5372150647078857`*^9, {3.537215289608201*^9, 
   3.5372152931782055`*^9}, {3.5372321134536653`*^9, 3.5372321818437614`*^9}, 
   3.5372861942842665`*^9, {3.5372862675443687`*^9, 3.537286313734433*^9}, {
   3.537286359274497*^9, 3.537286501974697*^9}, {3.5372865774416037`*^9, 
   3.5372866302616777`*^9}, {3.5372886670426784`*^9, 
   3.5372888723454213`*^9}, {3.537288904036234*^9, 3.537288925033435*^9}, {
   3.5372889632816224`*^9, 3.5372889990566683`*^9}, {3.5372890422581396`*^9, 
   3.5372892472428637`*^9}, {3.537289279617716*^9, 3.537289486293537*^9}, {
   3.537289531991151*^9, 3.5372895547324514`*^9}, {3.5372896424494686`*^9, 
   3.537289663174654*^9}, {3.537294791672987*^9, 3.5372948499823227`*^9}, {
   3.5402310416565523`*^9, 3.540231043091755*^9}, {3.5423046542526183`*^9, 
   3.5423047298927245`*^9}, {3.542305213413401*^9, 3.542305269133479*^9}, {
   3.542305315983545*^9, 3.54230534102358*^9}, {3.5423059596144457`*^9, 
   3.5423059614544487`*^9}, {3.542306060074587*^9, 3.5423061717147427`*^9}, {
   3.5423062269048204`*^9, 3.542306230264825*^9}, {3.5423062658548746`*^9, 
   3.542306510345217*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"AbsorbMinusSign", "[", "u", "]"}], " ", "returns", " ", "an", 
      " ", "expression", " ", "equal", " ", "to"}], " ", "-", 
     RowBox[{
      RowBox[{"u", ".", "  ", "If"}], " ", "there", " ", "is", " ", "a", " ", 
      "factor", " ", "of", " ", "u", " ", "of", " ", "the", " ", "\n", "\t", 
      "form", " ", 
      RowBox[{"v", "^", "m"}], " ", "where", " ", "v", " ", "is", " ", "a", 
      " ", "sum", " ", "and", " ", "m", " ", "is", " ", "an", " ", "odd", " ",
       "power"}]}], ",", " ", 
    RowBox[{
     RowBox[{
     "the", " ", "minus", " ", "sign", " ", "is", " ", "distributed", " ", 
      "over", " ", "v"}], ";", "\n", "\t", 
     RowBox[{"otherwise", " ", "-", 
      RowBox[{"u", " ", "is", " ", 
       RowBox[{"returned", "."}]}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"AbsorbMinusSign", "[", 
     RowBox[{"u_.", "*", "v_Plus"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"u", "*", 
     RowBox[{"(", 
      RowBox[{"-", "v"}], ")"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"AbsorbMinusSign", "[", 
     RowBox[{"u_.", "*", 
      RowBox[{"v_Plus", "^", "m_"}]}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "v"}], ")"}], "^", "m"}]}], " ", "/;", "\n", 
     RowBox[{"OddQ", "[", "m", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"AbsorbMinusSign", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"-", "u"}]}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372034445996094`*^9, 3.537203490859674*^9}, {
   3.5372035287997274`*^9, 3.537203533069733*^9}, {3.537210844681978*^9, 
   3.5372109283820953`*^9}, {3.537214589627221*^9, 3.53721463892729*^9}, {
   3.5372252945316105`*^9, 3.5372254091917715`*^9}, {3.5372254878618813`*^9, 
   3.5372255505419693`*^9}, {3.537225898812457*^9, 3.537225977482567*^9}, {
   3.537226098712737*^9, 3.5372261029927425`*^9}, {3.537226136182789*^9, 
   3.537226144502801*^9}, {3.537226246162943*^9, 3.5372262621529655`*^9}, {
   3.5372263190730453`*^9, 3.537226322003049*^9}, {3.537228887894143*^9, 
   3.5372289481442275`*^9}, {3.5372295210850296`*^9, 
   3.5372295612450857`*^9}, {3.5372295968251357`*^9, 
   3.5372296030951443`*^9}, {3.53723225970387*^9, 3.537232287043908*^9}, {
   3.537232374404031*^9, 3.5372323956540604`*^9}, 3.5372331417771063`*^9, {
   3.537235060219792*^9, 3.5372351475999146`*^9}, {3.5372351995499873`*^9, 
   3.5372352000399876`*^9}, {3.5372352345000362`*^9, 3.537235240340044*^9}, {
   3.5372352812401013`*^9, 3.5372352835701046`*^9}, {3.537235398750266*^9, 
   3.5372354943103995`*^9}, {3.5372355381604614`*^9, 
   3.5372357023006907`*^9}, {3.537235749040756*^9, 3.5372358162908506`*^9}, {
   3.5372358986309657`*^9, 3.537236018281133*^9}, {3.5372361074512577`*^9, 
   3.5372361495313168`*^9}, {3.5372361842713656`*^9, 
   3.5372363363315783`*^9}, {3.5372363748316326`*^9, 3.537236383461644*^9}, {
   3.5372364163116903`*^9, 3.5372364557217455`*^9}, {3.5372365790019183`*^9, 
   3.5372365830319242`*^9}, {3.537236635541998*^9, 3.5372367843722057`*^9}, {
   3.5372368624923153`*^9, 3.5372369912824955`*^9}, {3.537237062382595*^9, 
   3.5372370666726007`*^9}, {3.537237097362644*^9, 3.537237198012785*^9}, {
   3.5372372543028636`*^9, 3.537237385213047*^9}, {3.537237417283092*^9, 
   3.5372375085732193`*^9}, {3.537237593013338*^9, 3.5372375934933386`*^9}, {
   3.5372376320833926`*^9, 3.537237704703494*^9}, {3.5372377414335456`*^9, 
   3.537237843153688*^9}, 3.5372380685540037`*^9, {3.5372873072429028`*^9, 
   3.5372873324043417`*^9}, {3.537287435237223*^9, 3.537287447851945*^9}, {
   3.537287575119224*^9, 3.5372875755482483`*^9}, {3.5372880402098255`*^9, 
   3.537288078765031*^9}, {3.5372881635558805`*^9, 3.537288173127428*^9}, {
   3.5372885743803787`*^9, 3.537288608410325*^9}, 3.5372898744847403`*^9, {
   3.5372903366891766`*^9, 3.537290522498804*^9}, {3.537290572877686*^9, 
   3.5372906489270353`*^9}, {3.5372906802568274`*^9, 3.537290809991248*^9}, {
   3.537290853882758*^9, 3.5372909988780518`*^9}, {3.537291076145471*^9, 
   3.53729107647549*^9}, {3.5372911135276093`*^9, 3.537291150750738*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["NormalizeSumFactors", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, {3.537231239213439*^9, 
   3.537231244433446*^9}, {3.5372871004680758`*^9, 3.5372871045813107`*^9}, 
   3.5372914791815233`*^9, 3.540231041032552*^9, 3.5423091842589607`*^9, 
   3.5423273561110287`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NormalizeSumFactors", "[", "u", "]"}], " ", "returns", " ", "an",
     " ", "expression", " ", "equal", " ", "u", " ", "but", " ", "with", " ", 
    "the", " ", "numeric", " ", "coefficient", " ", "of", " ", "\n", "\t", 
    "the", " ", "lead", " ", "term", " ", "of", " ", "sum", " ", "factors", 
    " ", "made", " ", "positive", " ", "where", " ", 
    RowBox[{"possible", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NormalizeSumFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"Head", "[", "u", "]"}], "===", "If"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"Head", "[", "u", "]"}], "===", "Int"}], " ", "||", " ", 
      RowBox[{"HeldFormQ", "[", "u", "]"}]}], ",", "\n", "    ", "u", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "*", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "[", 
        RowBox[{"SignOfFactor", "[", 
         RowBox[{"Map", "[", 
          RowBox[{"NormalizeSumFactors", ",", "u"}], "]"}], "]"}], "]"}], ",",
        "\n", "  ", 
       RowBox[{"Map", "[", 
        RowBox[{"NormalizeSumFactors", ",", "u"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.5372100587908773`*^9, 
   3.53721008911092*^9}, {3.537210406161364*^9, 3.5372105939816265`*^9}, {
   3.5372106331816816`*^9, 3.5372107143017955`*^9}, {3.537210764261865*^9, 
   3.5372107823918905`*^9}, {3.537213176075242*^9, 3.5372137138659945`*^9}, {
   3.5372137590460577`*^9, 3.537213833806163*^9}, {3.5372139236262884`*^9, 
   3.5372139548363323`*^9}, {3.5372140267964325`*^9, 
   3.5372140523064685`*^9}, {3.5372141742466393`*^9, 3.537214176616643*^9}, {
   3.5372147129573936`*^9, 3.537214723507408*^9}, {3.537214790227502*^9, 
   3.5372148961276503`*^9}, 3.5372150647078857`*^9, {3.537215289608201*^9, 
   3.5372152931782055`*^9}, {3.5372321134536653`*^9, 3.5372321818437614`*^9}, 
   3.5372861942842665`*^9, {3.5372862675443687`*^9, 3.537286313734433*^9}, {
   3.537286359274497*^9, 3.537286501974697*^9}, {3.5372865774416037`*^9, 
   3.5372866302616777`*^9}, {3.5372886670426784`*^9, 
   3.5372888723454213`*^9}, {3.537288904036234*^9, 3.537288925033435*^9}, {
   3.5372889632816224`*^9, 3.5372889990566683`*^9}, {3.5372890422581396`*^9, 
   3.5372892472428637`*^9}, {3.537289279617716*^9, 3.537289486293537*^9}, {
   3.537289531991151*^9, 3.5372895547324514`*^9}, {3.5372896424494686`*^9, 
   3.537289663174654*^9}, {3.537294791672987*^9, 3.5372948499823227`*^9}, {
   3.5402310416565523`*^9, 3.540231043091755*^9}, {3.5423046542526183`*^9, 
   3.5423047298927245`*^9}, {3.5423053478235893`*^9, 
   3.5423053598136063`*^9}, {3.5423053995536623`*^9, 
   3.5423054207336917`*^9}, {3.5423056351439915`*^9, 3.542305653394017*^9}, {
   3.542305883204339*^9, 3.5423059465144277`*^9}, {3.542309121768873*^9, 
   3.542309146578908*^9}, {3.542309252489056*^9, 3.5423094099792767`*^9}, {
   3.5423263125495677`*^9, 3.5423263326995955`*^9}, {3.5423263740096536`*^9, 
   3.5423264522497635`*^9}, {3.542326525139865*^9, 3.5423265655999217`*^9}, {
   3.542326689510095*^9, 3.542326693860101*^9}, {3.542326731630154*^9, 
   3.542326732800156*^9}, {3.5423267694102073`*^9, 3.54232680009025*^9}, {
   3.5423268353002996`*^9, 3.5423270625006175`*^9}, {3.5423271289707108`*^9, 
   3.542327216670833*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"SignOfFactor", "[", "u", "]"}], " ", "returns", " ", "the", " ",
      "list", " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "v"}], "}"}], " ", "where", " ", "n", "*", "v", " ", 
     "equals", " ", "u"}], ",", " ", 
    RowBox[{
     RowBox[{"n", "^", "2"}], " ", "equals", " ", "1"}], ",", " ", 
    RowBox[{
    "and", " ", "the", " ", "lead", " ", "\n", "\t", "term", " ", "of", " ", 
     "the", " ", "sum", " ", "factors", " ", "of", " ", "v", " ", "raised", 
     " ", "to", " ", "integer", " ", "degrees", " ", "all", " ", "have", " ", 
     "positive", " ", 
     RowBox[{"coefficients", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SignOfFactor", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RationalQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"u", "<", "0"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"NumericFactor", "[", 
         RowBox[{"First", "[", "u", "]"}], "]"}], "<", "0"}]}]}], ",", "\n", 
     "    ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", " ", 
       RowBox[{"-", "u"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"SumQ", "[", 
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"NumericFactor", "[", 
          RowBox[{"First", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
       "\n", "    ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "^", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", 
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Map", "[", 
          RowBox[{"SignOfFactor", ",", "u"}], "]"}], ",", "\n", "  ", 
         RowBox[{"{", 
          RowBox[{"1", ",", " ", "u"}], "}"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.520111417883913*^9, 3.520111490764015*^9}, {
   3.5201115257540646`*^9, 3.520111663154257*^9}, 3.520112706045717*^9, {
   3.5201128910459757`*^9, 3.5201128914759765`*^9}, 3.5371300921309743`*^9, {
   3.5371302199511533`*^9, 3.5371302286311655`*^9}, {3.537130264001215*^9, 
   3.537130271881226*^9}, {3.5371303062312737`*^9, 3.537130325881302*^9}, {
   3.537130407551416*^9, 3.5371304214714355`*^9}, {3.5371304723515067`*^9, 
   3.537130528381585*^9}, {3.537130678411795*^9, 3.537130708131837*^9}, {
   3.5371308414620237`*^9, 3.537130857432046*^9}, {3.5371309514821777`*^9, 
   3.5371310284722853`*^9}, {3.5371314769529133`*^9, 
   3.5371314794029164`*^9}, {3.537131528242985*^9, 3.5371315303729877`*^9}, {
   3.5371315945330777`*^9, 3.537131795553359*^9}, {3.5371330348450937`*^9, 
   3.537133041005103*^9}, {3.5372036730399294`*^9, 3.5372036787799373`*^9}, {
   3.5372047528014407`*^9, 3.5372047546714435`*^9}, {3.5372100587908773`*^9, 
   3.53721008911092*^9}, {3.537210406161364*^9, 3.5372105939816265`*^9}, {
   3.5372106331816816`*^9, 3.5372107143017955`*^9}, {3.537210764261865*^9, 
   3.5372107823918905`*^9}, {3.537213176075242*^9, 3.5372137138659945`*^9}, {
   3.5372137590460577`*^9, 3.537213833806163*^9}, {3.5372139236262884`*^9, 
   3.5372139548363323`*^9}, {3.5372140267964325`*^9, 
   3.5372140523064685`*^9}, {3.5372141742466393`*^9, 3.537214176616643*^9}, {
   3.5372147129573936`*^9, 3.537214723507408*^9}, {3.537214790227502*^9, 
   3.5372148961276503`*^9}, 3.5372150647078857`*^9, {3.537215289608201*^9, 
   3.5372152931782055`*^9}, {3.5372321134536653`*^9, 3.5372321818437614`*^9}, 
   3.5372861942842665`*^9, {3.5372862675443687`*^9, 3.537286313734433*^9}, {
   3.537286359274497*^9, 3.537286501974697*^9}, {3.5372865774416037`*^9, 
   3.5372866302616777`*^9}, {3.5372886670426784`*^9, 
   3.5372888723454213`*^9}, {3.537288904036234*^9, 3.537288925033435*^9}, {
   3.5372889632816224`*^9, 3.5372889990566683`*^9}, {3.5372890422581396`*^9, 
   3.5372892472428637`*^9}, {3.537289279617716*^9, 3.537289486293537*^9}, {
   3.537289531991151*^9, 3.5372895547324514`*^9}, {3.5372896424494686`*^9, 
   3.537289663174654*^9}, {3.537294791672987*^9, 3.5372948499823227`*^9}, {
   3.5402310416565523`*^9, 3.540231043091755*^9}, {3.5423046542526183`*^9, 
   3.5423047298927245`*^9}, {3.5423053478235893`*^9, 
   3.5423053598136063`*^9}, {3.5423053995536623`*^9, 
   3.5423054207336917`*^9}, {3.5423056351439915`*^9, 3.542305653394017*^9}, {
   3.542305883204339*^9, 3.5423059465144277`*^9}, {3.542309121768873*^9, 
   3.542309146578908*^9}, {3.542309252489056*^9, 3.5423094099792767`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Simplification Functions", "Section",
 CellChangeTimes->{{3.518825295745934*^9, 3.518825297485936*^9}, {
  3.5195157934574966`*^9, 3.519515816657529*^9}, {3.537129625350321*^9, 
  3.5371296302903275`*^9}}],

Cell[CellGroupData[{

Cell["Simp", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Simp", "[", 
    RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"TimeConstrained", "[", 
    RowBox[{
     RowBox[{"NormalizeSumFactors", "[", 
      RowBox[{"SimpHelp", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "]"}], ",", "TimeLimit", ",", "u"}], 
    "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SimpHelp", "[", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"u_.", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"v_.", "*", 
           RowBox[{"Log", "[", "a_", "]"}]}], "+", "w_"}], ")"}]}], ")"}]}], 
     ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"a", "^", 
     RowBox[{"(", 
      RowBox[{"u", "*", "v"}], ")"}]}], "*", 
    RowBox[{"SimpHelp", "[", 
     RowBox[{
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{"u", "*", "w"}], ")"}]}], ",", "x"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"SimpHelp", "[", 
   RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "u", "]"}], "===", "If"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"Head", "[", "u", "]"}], "===", "Int"}], " ", "||", " ", 
       RowBox[{"HeldFormQ", "[", "u", "]"}]}], ",", "\n", "    ", "u", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"v", "=", 
            RowBox[{"SmartSimplify", "[", "u", "]"}]}], "}"}], ",", "\n", 
          "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"LeafCount", "[", "v", "]"}], "\[LessEqual]", 
             RowBox[{"LeafCount", "[", "u", "]"}]}], ",", "\n", "      ", "v",
             ",", "\n", "    ", "u"}], "]"}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"v", "=", "1"}], ",", 
              RowBox[{"w", "=", "1"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{
             RowBox[{"Scan", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FreeQ", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], ",", 
                  RowBox[{"v", "=", 
                   RowBox[{"#", "*", "v"}]}], ",", 
                  RowBox[{"w", "=", 
                   RowBox[{"#", "*", "w"}]}]}], "]"}], "]"}], ",", "u"}], 
              "]"}], ";", "\n", "    ", 
             RowBox[{"v", "=", 
              RowBox[{
               RowBox[{"NumericFactor", "[", "v", "]"}], "*", 
               RowBox[{
                RowBox[{"SmartSimplify", "[", 
                 RowBox[{
                  RowBox[{"NonnumericFactors", "[", "v", "]"}], "*", 
                  RowBox[{"x", "^", "2"}]}], "]"}], "/", 
                RowBox[{"x", "^", "2"}]}]}]}], ";", "\n", "    ", 
             RowBox[{"w", "=", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"ProductQ", "[", "w", "]"}], ",", " ", 
                RowBox[{"Map", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"SimpHelp", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "w"}], "]"}], 
                ",", " ", 
                RowBox[{"SimpHelp", "[", 
                 RowBox[{"w", ",", "x"}], "]"}]}], "]"}]}], ";", "\n", "    ", 
             RowBox[{"w", "=", 
              RowBox[{"FactorNumericGcd", "[", "w", "]"}]}], ";", "\n", 
             "    ", 
             RowBox[{"v", "=", 
              RowBox[{"MergeFactors", "[", 
               RowBox[{"v", ",", "w"}], "]"}]}], ";", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"ProductQ", "[", "v", "]"}], ",", "\n", "      ", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"SimpFixFactor", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "v"}], "]"}], 
               ",", "\n", "    ", "v"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"PolynomialQ", "[", 
                RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
               RowBox[{
                RowBox[{"Exponent", "[", 
                 RowBox[{"u", ",", "x"}], "]"}], "\[LessEqual]", "0"}]}], ",",
               "\n", "      ", 
              RowBox[{"SimpHelp", "[", 
               RowBox[{
                RowBox[{"Coefficient", "[", 
                 RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", "x"}], "]"}], 
              ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"PolynomialQ", "[", 
                  RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
                 RowBox[{
                  RowBox[{"Exponent", "[", 
                   RowBox[{"u", ",", "x"}], "]"}], "\[Equal]", "1"}], " ", "&&",
                  " ", 
                 RowBox[{
                  RowBox[{"Coefficient", "[", 
                   RowBox[{"u", ",", "x", ",", "0"}], "]"}], "===", "0"}]}], 
                ",", "\n", "      ", 
                RowBox[{
                 RowBox[{"SimpHelp", "[", 
                  RowBox[{
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"u", ",", "x", ",", "1"}], "]"}], ",", "x"}], 
                  "]"}], "*", "x"}], ",", "\n", "    ", 
                RowBox[{"Module", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"v", "=", "0"}], ",", 
                    RowBox[{"w", "=", "0"}]}], "}"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], ",", 
                    RowBox[{"v", "=", 
                    RowBox[{"#", "+", "v"}]}], ",", 
                    RowBox[{"w", "=", 
                    RowBox[{"#", "+", "w"}]}]}], "]"}], "]"}], ",", "u"}], 
                    "]"}], ";", "\n", "    ", 
                   RowBox[{"v", "=", 
                    RowBox[{"SmartSimplify", "[", "v", "]"}]}], ";", "\n", 
                   "    ", 
                   RowBox[{"w", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SumQ", "[", "w", "]"}], ",", " ", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"SimpHelp", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "w"}], "]"}], 
                    ",", " ", 
                    RowBox[{"SimpHelp", "[", 
                    RowBox[{"w", ",", "x"}], "]"}]}], "]"}]}], ";", "\n", 
                   "    ", 
                   RowBox[{"v", "+", "w"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
            "\n", "  ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"SimpHelp", "[", 
                RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.520110672062869*^9, 3.5201107851030273`*^9}, {
   3.5201108227230797`*^9, 3.5201108474531145`*^9}, {3.5201108903331747`*^9, 
   3.5201112358936586`*^9}, {3.522435896061739*^9, 3.522436068223981*^9}, 
   3.5224361051040325`*^9, {3.5224361938841567`*^9, 3.5224363006643066`*^9}, {
   3.5224364421145043`*^9, 3.5224364878345685`*^9}, {3.52243654620465*^9, 
   3.522436598104723*^9}, {3.5224366498947954`*^9, 3.5224366607348104`*^9}, {
   3.5224367298849072`*^9, 3.5224367490049343`*^9}, {3.5224442914108176`*^9, 
   3.5224442927680197`*^9}, {3.522446038690793*^9, 3.5224461296389527`*^9}, {
   3.522446166579818*^9, 3.5224461680462203`*^9}, {3.5224462066874886`*^9, 
   3.522446233847136*^9}, {3.5224465942277684`*^9, 3.5224465959437714`*^9}, {
   3.522446627533827*^9, 3.5224467136771784`*^9}, {3.522446808166544*^9, 
   3.5224468223937693`*^9}, {3.5224477511664877`*^9, 
   3.5224477973621674`*^9}, {3.522453605643408*^9, 3.5224536175334244`*^9}, {
   3.522453716013562*^9, 3.522453737893593*^9}, {3.522455699844344*^9, 
   3.5224557098043585`*^9}, {3.5224575101648846`*^9, 
   3.5224575241549044`*^9}, {3.5266742376948633`*^9, 
   3.5266742468748765`*^9}, {3.526674309464964*^9, 3.5266743373650026`*^9}, {
   3.526674518125256*^9, 3.5266745334552774`*^9}, {3.5266745892753553`*^9, 
   3.5266745899053564`*^9}, {3.526674800355651*^9, 3.5266748015556526`*^9}, {
   3.5266749347958393`*^9, 3.52667493540584*^9}, {3.5272106303784423`*^9, 
   3.527210630868443*^9}, {3.5272142875625815`*^9, 3.5272142895749855`*^9}, {
   3.5363521610173206`*^9, 3.536352165707327*^9}, {3.5366037798001385`*^9, 
   3.5366038060861845`*^9}, {3.5367023329158144`*^9, 3.5367023363280096`*^9}, 
   3.536712697452632*^9, {3.542304039501758*^9, 3.5423040671517963`*^9}, {
   3.5423104101506767`*^9, 3.542310618200968*^9}, {3.542316427161719*^9, 
   3.542316445161744*^9}, {3.542316475671787*^9, 3.5423164912018085`*^9}, {
   3.5423165668619146`*^9, 3.542316582751937*^9}, {3.5423166248319955`*^9, 
   3.5423166536120358`*^9}, {3.5423166885020847`*^9, 
   3.5423168119622574`*^9}, {3.5423169592424636`*^9, 3.542317068792617*^9}, {
   3.5423176714534607`*^9, 3.542317675123466*^9}, {3.542318365554433*^9, 
   3.542318430484524*^9}, 3.542318491664609*^9, {3.5423186213347907`*^9, 
   3.5423186483348284`*^9}, {3.542318727254939*^9, 3.5423187276949396`*^9}, {
   3.5423235401456795`*^9, 3.5423235424056826`*^9}, {3.5423240093463364`*^9, 
   3.5423240145563436`*^9}, {3.542327475711196*^9, 3.5423274792112007`*^9}, {
   3.5423275114112463`*^9, 3.5423276011713715`*^9}, {3.542327662991458*^9, 
   3.542327690851497*^9}, {3.54232958593415*^9, 3.5423296945843024`*^9}, {
   3.5423299953847237`*^9, 3.5423299968847256`*^9}, {3.543006446179779*^9, 
   3.5430065530828934`*^9}, 3.5430068574032993`*^9, {3.5430100423814697`*^9, 
   3.543010060601512*^9}, {3.543010100410789*^9, 3.5430101269013042`*^9}, {
   3.54301017246891*^9, 3.543010188678838*^9}, {3.5430141598859777`*^9, 
   3.54301428720426*^9}, {3.5430143216972327`*^9, 3.543014333783924*^9}, {
   3.5430163448569508`*^9, 3.5430163500462475`*^9}, {3.5431722855877604`*^9, 
   3.543172319597808*^9}, {3.5431723994579196`*^9, 3.543172438767975*^9}, {
   3.5431729472886868`*^9, 3.5431729496686897`*^9}, {3.543182204087552*^9, 
   3.5431822140475664`*^9}, {3.5431823679877815`*^9, 
   3.5431823815978007`*^9}, {3.5431835532594414`*^9, 
   3.5431835578194475`*^9}, {3.5431836064395156`*^9, 3.543183633089553*^9}, {
   3.5431836933596373`*^9, 3.5431837036096516`*^9}, {3.543184035910117*^9, 
   3.543184171720307*^9}, {3.543184215350368*^9, 3.5431842182003717`*^9}, {
   3.5431843735005894`*^9, 3.5431844289206667`*^9}, {3.543185767392541*^9, 
   3.5431857678425417`*^9}, {3.543186029702908*^9, 3.5431861177330313`*^9}, 
   3.5431862725632477`*^9, {3.543195728865135*^9, 3.543195831725279*^9}, {
   3.5431962334358416`*^9, 3.543196242345854*^9}, {3.543247835540405*^9, 
   3.5432478382180085`*^9}, 3.54326779139124*^9, 3.543779556666649*^9, {
   3.544380361741253*^9, 3.544380403281311*^9}, {3.5443805487615147`*^9, 
   3.5443806582716675`*^9}, {3.5443806893317113`*^9, 
   3.5443807375017786`*^9}, {3.544380859181949*^9, 3.5443808676219606`*^9}, {
   3.5443813343126144`*^9, 3.544381336212617*^9}, {3.5443819230434384`*^9, 
   3.544381977573515*^9}, {3.550253510745909*^9, 3.5502535125559115`*^9}, {
   3.5502535651359854`*^9, 3.5502536288560743`*^9}, {3.5502543658171062`*^9, 
   3.5502543824071293`*^9}, {3.5502692945647807`*^9, 
   3.5502693431348486`*^9}, {3.550269380714901*^9, 3.55026946573502*^9}, {
   3.5502696547652845`*^9, 3.5502697031053524`*^9}, {3.5502923153215866`*^9, 
   3.5502923254616003`*^9}, {3.5504190016253767`*^9, 3.55041900338818*^9}, {
   3.5504190636822863`*^9, 3.5504191296704016`*^9}, {3.5504192782918625`*^9, 
   3.5504193004751015`*^9}, {3.5504193855576515`*^9, 3.550419388069256*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["SmartSimplify", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, 3.5432416511538706`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"factorTime", "=", "0"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"SmartSimplify", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"TimeConstrained", "[", "\n", "    ", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", ",", "w"}], "}"}], ",", "\n", "    ", 
      RowBox[{
       RowBox[{"v", "=", 
        RowBox[{"Simplify", "[", "u", "]"}]}], ";", "\n", "    ", 
       RowBox[{"w", "=", 
        RowBox[{"Factor", "[", "v", "]"}]}], ";", "\n", "    ", 
       RowBox[{"v", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LeafCount", "[", "w", "]"}], "<", 
           RowBox[{"LeafCount", "[", "v", "]"}]}], ",", "w", ",", "v"}], 
         "]"}]}], ";", "\n", "    ", 
       RowBox[{"v", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"NotFalseQ", "[", 
            RowBox[{"w", "=", 
             RowBox[{"FractionalPowerOfSquareQ", "[", "v", "]"}]}], "]"}], 
           " ", "&&", " ", 
           RowBox[{"FractionalPowerSubexpressionQ", "[", 
            RowBox[{"u", ",", "w", ",", 
             RowBox[{"Expand", "[", "w", "]"}]}], "]"}]}], ",", 
          RowBox[{"SubstForExpn", "[", 
           RowBox[{"v", ",", "w", ",", 
            RowBox[{"Expand", "[", "w", "]"}]}], "]"}], ",", "v"}], "]"}]}], 
       ";", "\n", "    ", 
       RowBox[{"FixSimplify", "[", 
        RowBox[{"FactorNumericGcd", "[", "v", "]"}], "]"}]}]}], "]"}], ",", 
    "\n", "  ", "TimeLimit", ",", "u"}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, 
   3.543172494468053*^9, 3.5431844359006767`*^9, {3.5432035876379557`*^9, 
   3.543203594746362*^9}, {3.543203650556777*^9, 3.543203711925287*^9}, {
   3.5432037442241344`*^9, 3.5432038361033726`*^9}, {3.543203911702594*^9, 
   3.5432039119606085`*^9}, {3.5432040275932226`*^9, 
   3.5432040511179767`*^9}, {3.543204338748826*^9, 3.5432043390288267`*^9}, 
   3.5432045779991612`*^9, 3.5432049518496847`*^9, 3.5432088412059937`*^9, {
   3.5432455816452293`*^9, 3.5432456383257093`*^9}, {3.5432516004069123`*^9, 
   3.543251604506918*^9}, 3.5432529236519785`*^9, {3.5432610414117904`*^9, 
   3.543261078441842*^9}, {3.543261421622323*^9, 3.5432614386523466`*^9}, 
   3.5432710063957415`*^9, {3.5433266226117744`*^9, 3.5433266305617857`*^9}, {
   3.543326693621874*^9, 3.5433267382919364`*^9}, {3.543326774071986*^9, 
   3.5433267823699985`*^9}, {3.5433456938347435`*^9, 3.543345699665077*^9}, {
   3.5433457323191414`*^9, 3.543345734084243*^9}, {3.54334582454335*^9, 
   3.5433458413343105`*^9}, 3.543356985382349*^9, {3.543363236840804*^9, 
   3.5433632402808094`*^9}, {3.5434252969758854`*^9, 
   3.5434252982919607`*^9}, {3.5437882254792876`*^9, 3.543788238889306*^9}, {
   3.5437885283897114`*^9, 3.543788538019725*^9}, {3.543791218143483*^9, 
   3.543791326423635*^9}, {3.5437964286477833`*^9, 3.5437964517978153`*^9}, {
   3.543796731368207*^9, 3.5437967315682077`*^9}, 3.543977384175285*^9, 
   3.5439777544402065`*^9, {3.5439777888430557`*^9, 3.5439778117482877`*^9}, {
   3.543977844051133*^9, 3.5439779227620444`*^9}, {3.5439784249763527`*^9, 
   3.5439784385315714`*^9}, {3.5439801448907776`*^9, 3.543980153048389*^9}, {
   3.5439815449563503`*^9, 3.5439815732315903`*^9}, {3.543981640533285*^9, 
   3.5439816465908937`*^9}, {3.543983108777357*^9, 3.54398311086496*^9}, {
   3.544378380308479*^9, 3.5443783812284803`*^9}, {3.5443784566985855`*^9, 
   3.544378456908586*^9}, {3.5447285937010655`*^9, 3.5447286079110856`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "a", " ", "subexpression", " ", "of", " ", "u", " ", "is", " ",
      "of", " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", "+", "w"}], ")"}], "^", "2"}], ")"}], "^", "n"}], " ", 
     "where", " ", "n", " ", "is", " ", "a", " ", "fraction"}], ","}], " ", 
   "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionalPowerOfSquareQ", "[", "u", "]"}], " ", "returns", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "w"}], ")"}], "^", "2"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionalPowerOfSquareQ", "[", "u_", "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"MatchQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{
           RowBox[{"a_.", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b_", "+", "c_"}], ")"}], "^", "2"}]}], " ", "/;", " ", 
           RowBox[{"NonsumQ", "[", "a", "]"}]}]}], "]"}]}], ",", "\n", "    ", 
       RowBox[{"u", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", "\n", "    ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"NotFalseQ", "[", 
                 RowBox[{"tmp", "=", 
                  RowBox[{"FractionalPowerOfSquareQ", "[", "#", "]"}]}], 
                 "]"}], ",", 
                RowBox[{"Throw", "[", "tmp", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "\n", "    ", "False"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524675359006686*^9, 
   3.5246754012767453`*^9}, {3.5246754779468527`*^9, 
   3.5246755183169093`*^9}, {3.5246755515969563`*^9, 3.524675570306982*^9}, {
   3.524675614257044*^9, 3.5246756429770837`*^9}, {3.5246760148676043`*^9, 
   3.52467609734772*^9}, {3.5246762599479475`*^9, 3.5246762608679485`*^9}, {
   3.5246762985380015`*^9, 3.5246763192880306`*^9}, {3.5246763533080783`*^9, 
   3.5246764389581985`*^9}, {3.5246765392683387`*^9, 
   3.5246765647183743`*^9}, {3.524677000388984*^9, 3.524677009758997*^9}, {
   3.5246770613290696`*^9, 3.524677110709139*^9}, {3.5246772535593386`*^9, 
   3.5246772560693417`*^9}, {3.5246773793695145`*^9, 
   3.5246774570196238`*^9}, {3.524677487449666*^9, 3.5246774912996716`*^9}, 
   3.524677812330121*^9, {3.524678269490761*^9, 3.5246782787007737`*^9}, {
   3.524679693812755*^9, 3.524679813422922*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "a", " ", "subexpression", " ", "of", " ", "u", " ", "is", " ",
      "of", " ", "the", " ", "form", " ", 
     RowBox[{"w", "^", "n"}], " ", "where", " ", "n", " ", "is", " ", "a", 
     " ", "fraction", " ", "but", " ", "not", " ", "equal", " ", "to", " ", 
     "v"}], ","}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionalPowerSubexpressionQ", "[", 
      RowBox[{"u", ",", "v", ",", "w"}], "]"}], " ", "returns", " ", "True"}],
     ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionalPowerSubexpressionQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"PositiveQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "/", "w"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{
        RowBox[{"Not", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "===", "v"}], "]"}], " ", "&&", 
        " ", 
        RowBox[{
         RowBox[{"LeafCount", "[", "w", "]"}], "<", 
         RowBox[{"3", "*", 
          RowBox[{"LeafCount", "[", "v", "]"}]}]}]}], ",", "\n", "  ", 
       RowBox[{"Catch", "[", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FractionalPowerSubexpressionQ", "[", 
               RowBox[{"#", ",", "v", ",", "w"}], "]"}], ",", 
              RowBox[{"Throw", "[", "True", "]"}]}], "]"}], "]"}], ",", "u"}],
           "]"}], ";", " ", "False"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524675359006686*^9, 
   3.5246754012767453`*^9}, {3.5246754779468527`*^9, 
   3.5246755183169093`*^9}, {3.5246755515969563`*^9, 3.524675570306982*^9}, {
   3.524675614257044*^9, 3.5246756429770837`*^9}, {3.5246760148676043`*^9, 
   3.52467609734772*^9}, {3.5246762599479475`*^9, 3.5246762608679485`*^9}, {
   3.5246762985380015`*^9, 3.5246763192880306`*^9}, {3.5246763533080783`*^9, 
   3.5246764389581985`*^9}, {3.5246765392683387`*^9, 
   3.5246765647183743`*^9}, {3.524677000388984*^9, 3.524677009758997*^9}, {
   3.5246770613290696`*^9, 3.524677110709139*^9}, {3.5246772535593386`*^9, 
   3.5246772560693417`*^9}, {3.5246773793695145`*^9, 
   3.5246774570196238`*^9}, {3.524677487449666*^9, 3.5246774912996716`*^9}, {
   3.524677696649959*^9, 3.524677697999961*^9}, {3.5246777280300026`*^9, 
   3.5246777856000834`*^9}, {3.524677823700137*^9, 3.5246778249601383`*^9}, {
   3.524677855200181*^9, 3.524677887950227*^9}, {3.524677925480279*^9, 
   3.524677970570342*^9}, 3.524678107120534*^9, {3.5246791097319374`*^9, 
   3.5246791185819497`*^9}, {3.524789548501568*^9, 3.5247895618115864`*^9}, {
   3.5247896749517446`*^9, 3.5247897057317877`*^9}, {3.53532053984015*^9, 
   3.5353205537241745`*^9}, {3.535321196289303*^9, 3.5353212787198477`*^9}, {
   3.5376685616004972`*^9, 3.5376685816805253`*^9}, {3.5376686410906086`*^9, 
   3.53766864235061*^9}, {3.537717359057911*^9, 3.5377173638171835`*^9}, {
   3.5377177068645887`*^9, 3.537717710405795*^9}, {3.537717753820671*^9, 
   3.537717769124298*^9}, 3.5377178468592343`*^9, {3.5377178829108973`*^9, 
   3.537717903627734*^9}, {3.537718021922742*^9, 3.53771802685235*^9}, {
   3.537718253161948*^9, 3.53771825991676*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["FixSimplify", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, 3.5432416511538706`*^9, 
   3.543357044542432*^9}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "m"], " ", "u"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "a"}], ")"}], "n"], " ", "v"}]}], "\[Equal]", 
    RowBox[{
     SuperscriptBox["a", "m"], 
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], " ", 
        SuperscriptBox["a", 
         RowBox[{"n", "-", "m"}]], "v"}]}], ")"}]}]}],
   FontWeight->"Bold"]]]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, 3.5437934461316066`*^9, {
   3.543795173024024*^9, 3.543795237064114*^9}, {3.543795270674161*^9, 
   3.543795296964198*^9}, {3.5437953283142414`*^9, 3.5437953283142414`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"w_.", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"a_", "^", "m_"}], "*", "u_."}], "+", 
      RowBox[{
       RowBox[{"b_", "^", "n_."}], "*", "v_."}]}], ")"}]}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], "*", "w", "*", 
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", 
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "m"}], ")"}]}], "*", "v"}]}], ")"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "+", "b"}], "===", "0"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.543251262174835*^9, 3.543251269434846*^9}, {
   3.5432535666336856`*^9, 3.5432536242217665`*^9}, {3.543253810116829*^9, 
   3.543253865507307*^9}, {3.5432539345130043`*^9, 3.543253935083005*^9}, {
   3.543253970163455*^9, 3.5432540088039093`*^9}, 3.5432540612243834`*^9, 
   3.543271147365939*^9, {3.543271449546362*^9, 3.5432715020064354`*^9}, {
   3.5432715486465006`*^9, 3.5432715885665565`*^9}, 3.54327171249673*^9, {
   3.5432718264468894`*^9, 3.5432718485769205`*^9}, {3.543271888916977*^9, 
   3.5432718942569847`*^9}, {3.543271938267046*^9, 3.543272018867159*^9}, 
   3.5432763436532135`*^9, {3.5433569853923492`*^9, 3.5433569854023495`*^9}, {
   3.5437954883944654`*^9, 3.543795492144471*^9}, {3.5437957945548944`*^9, 
   3.5437957968548975`*^9}, {3.5437958761150084`*^9, 3.543795878865012*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{"t", "\[Element]", "\[DoubleStruckCapitalZ]"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "m"], " ", "u"}], "+", 
      RowBox[{
       SuperscriptBox["a", "n"], " ", "v"}], 
      StyleBox["+",
       FontWeight->"Bold"], 
      StyleBox["\[Ellipsis]",
       FontWeight->"Bold"]}], ")"}], "t"], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], 
   RowBox[{
    StyleBox[
     SuperscriptBox["a", 
      RowBox[{"m", " ", "t"}]],
     FontWeight->"Bold"], 
    StyleBox[" ",
     FontWeight->"Bold"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{
        SuperscriptBox["a", 
         RowBox[{"n", "-", "m"}]], " ", "v"}], 
       StyleBox["+",
        FontWeight->"Bold"], 
       StyleBox["\[Ellipsis]",
        FontWeight->"Bold"]}], ")"}], "t"]}]}]],
  FontWeight->"Bold"]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, 3.5437934461316066`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a_", "^", "m_."}], "*", "u_."}], "+", 
        RowBox[{
         RowBox[{"a_", "^", "n_."}], "*", "v_."}]}], ")"}], "^", "t_."}]}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"FixSimplify", "[", 
     RowBox[{
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "t"}], ")"}]}], "*", "w", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "+", 
         RowBox[{
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "m"}], ")"}]}], "*", "v"}]}], ")"}], "^", 
       "t"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"RationalQ", "[", "a", "]"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "t", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
     RowBox[{"0", "<", "m", "\[LessEqual]", "n"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"a_", "^", "m_."}], "*", "u_."}], "+", 
        RowBox[{
         RowBox[{"a_", "^", "n_."}], "*", "v_."}], "+", 
        RowBox[{
         RowBox[{"a_", "^", "p_."}], "*", "z_."}]}], ")"}], "^", "t_."}]}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"FixSimplify", "[", 
     RowBox[{
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "t"}], ")"}]}], "*", "w", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"u", "+", 
         RowBox[{
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "m"}], ")"}]}], "*", "v"}], "+", 
         RowBox[{
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "m"}], ")"}]}], "*", "z"}]}], ")"}], "^", 
       "t"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"RationalQ", "[", "a", "]"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", "t", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"0", "<", "m", "\[LessEqual]", "n", "\[LessEqual]", "p"}]}]}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"w_.", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"a_", "^", "m_."}], "*", "u_."}], "+", 
       RowBox[{
        RowBox[{"a_", "^", "n_."}], "*", "v_."}], "+", 
       RowBox[{
        RowBox[{"a_", "^", "p_."}], "*", "z_."}], "+", 
       RowBox[{
        RowBox[{"a_", "^", "q_."}], "*", "y_."}]}], ")"}], "^", "t_."}]}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{
     RowBox[{"a", "^", 
      RowBox[{"(", 
       RowBox[{"m", "*", "t"}], ")"}]}], "*", "w", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "m"}], ")"}]}], "*", "v"}], "+", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "m"}], ")"}]}], "*", "z"}], "+", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"q", "-", "m"}], ")"}]}], "*", "y"}]}], ")"}], "^", 
      "t"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "a", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "t", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{
    "0", "<", "m", "\[LessEqual]", "n", "\[LessEqual]", "p", "\[LessEqual]", 
     "q"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.543251262174835*^9, 3.543251269434846*^9}, {
   3.5432535666336856`*^9, 3.5432536242217665`*^9}, {3.543253810116829*^9, 
   3.543253865507307*^9}, {3.5432539345130043`*^9, 3.543253935083005*^9}, {
   3.543253970163455*^9, 3.5432540088039093`*^9}, 3.5432540612243834`*^9, {
   3.5432711337059193`*^9, 3.5432711443659344`*^9}, {3.543272080717245*^9, 
   3.543272151997345*^9}, {3.543293185136089*^9, 3.5432932911062374`*^9}, {
   3.543294042397289*^9, 3.543294078367339*^9}, {3.5433569854023495`*^9, 
   3.543356985432349*^9}, {3.543359809416006*^9, 3.5433598315460367`*^9}, {
   3.543359875736099*^9, 3.54335995537621*^9}, {3.543791818724324*^9, 
   3.5437918304143405`*^9}, {3.5437960309352255`*^9, 3.5437960459952464`*^9}}],

Cell[TextData[{
 StyleBox["Basis: ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SqrtBox["v"]}], 
    StyleBox["+",
     FontWeight->"Bold"], 
    RowBox[{
     StyleBox["b",
      FontWeight->"Bold"], 
     SqrtBox["v"]}], "+", 
    StyleBox["\[Ellipsis]",
     FontWeight->"Bold"]}], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", 
      StyleBox["\[Ellipsis]",
       FontWeight->"Bold"]}], ")"}], 
    SqrtBox["v"]}]}]],
  FontWeight->"Bold"]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437921468347836`*^9, 3.5437922655049496`*^9}, {3.5437924400451937`*^9, 
   3.543792440945195*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w_.", "*", 
     RowBox[{"(", 
      RowBox[{"u_.", "+", 
       RowBox[{"a_.", "*", 
        RowBox[{"Sqrt", "[", "v_Plus", "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", "v_", "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sqrt", "[", "v_", "]"}]}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"Sqrt", "[", "v_", "]"}]}]}], ")"}]}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w", "*", 
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{
        RowBox[{"FixSimplify", "[", 
         RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", "v", "]"}]}]}], ")"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w_.", "*", 
     RowBox[{"(", 
      RowBox[{"u_.", "+", 
       RowBox[{"a_.", "*", 
        RowBox[{"Sqrt", "[", "v_Plus", "]"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", "v_", "]"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"Sqrt", "[", "v_", "]"}]}]}], ")"}]}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{"FixSimplify", "[", 
    RowBox[{"w", "*", 
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{
        RowBox[{"FixSimplify", "[", 
         RowBox[{"a", "+", "b", "+", "c"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", "v", "]"}]}]}], ")"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"w_.", "*", 
    RowBox[{"(", 
     RowBox[{"u_.", "+", 
      RowBox[{"a_.", "*", 
       RowBox[{"Sqrt", "[", "v_Plus", "]"}]}], "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Sqrt", "[", "v_", "]"}]}]}], ")"}]}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"FixSimplify", "[", 
   RowBox[{"w", "*", 
    RowBox[{"(", 
     RowBox[{"u", "+", 
      RowBox[{
       RowBox[{"FixSimplify", "[", 
        RowBox[{"a", "+", "b"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", "v", "]"}]}]}], ")"}]}], "]"}]}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, {
   3.543251446184695*^9, 3.543251446594695*^9}, {3.5433569854423494`*^9, 
   3.5433569854823494`*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{"a", ">", "0"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", 
     FractionBox["m", "4"]], " ", 
    SqrtBox[
     RowBox[{"b", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", 
         SqrtBox["a"]}]}], ")"}]}]]}], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], 
   SqrtBox[
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", " ", 
        SuperscriptBox["a", 
         FractionBox["m", "2"]]}], "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["a", 
         FractionBox[
          RowBox[{"m", "+", "1"}], "2"]]}]}], ")"}]}]]}]],
  FontWeight->"Bold"]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437921468347836`*^9, 3.5437922655049496`*^9}, {3.5437923526050715`*^9, 
   3.543792430875181*^9}, {3.5437924763852453`*^9, 3.543792524315312*^9}, {
   3.543792573345381*^9, 3.5437925738553815`*^9}, {3.543793282621378*^9, 
   3.5437932830213785`*^9}, 3.543793442201601*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"u_.", "*", 
     RowBox[{"a_", "^", "m_"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"Sqrt", "[", "a_", "]"}]}]}], ")"}]}], "]"}]}], "]"}], " ", 
   ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Together", "[", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "*", 
           RowBox[{"a", "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", "m"}], ")"}]}]}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"a", "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "m"}], "+", 
              RowBox[{"1", "/", "2"}]}], ")"}]}]}]}], ")"}]}], "]"}], "]"}], 
     "*", 
     RowBox[{"FixSimplify", "[", "u", "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"a", ">", "0"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Denominator", "[", "m", "]"}], "\[Equal]", "4"}]}]}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"u_.", "*", 
    RowBox[{
     RowBox[{"a_", "^", "m_"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"Sqrt", "[", "a_", "]"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"FixSimplify", "[", "u", "]"}], "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Together", "[", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "/", 
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "m"}], ")"}]}]}], "+", 
         RowBox[{"d", "/", 
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "m"}], "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}]}]}], ")"}]}], "]"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"a", ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Denominator", "[", "m", "]"}], "\[Equal]", "4"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, {
   3.543251446184695*^9, 3.543251446594695*^9}, {3.5433569854423494`*^9, 
   3.5433569854823494`*^9}, {3.5433571412125673`*^9, 3.543357222582681*^9}, {
   3.5433575433931303`*^9, 3.543357638263263*^9}, {3.543357715293371*^9, 
   3.543357781593464*^9}, {3.5433578164135127`*^9, 3.543357917363654*^9}, {
   3.543357953133704*^9, 3.543357954603706*^9}, {3.5433580451138325`*^9, 
   3.5433581159039316`*^9}, {3.5433581695840073`*^9, 3.543358169824007*^9}, {
   3.543358329864231*^9, 3.543358353214264*^9}, {3.543358389484315*^9, 
   3.5433584005843306`*^9}, {3.5433584357143793`*^9, 3.5433584589944124`*^9}, 
   3.5433586429246693`*^9, {3.5433587342447977`*^9, 3.5433587413048077`*^9}, {
   3.5433589631251183`*^9, 3.5433590174051943`*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   StyleBox[
    SuperscriptBox["w", 
     RowBox[{"-", "n"}]],
    FontWeight->"Bold"], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], "v"}]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["v", "m"], " ", 
    SuperscriptBox["w", "n"]}], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], 
   StyleBox[
    SuperscriptBox["v", 
     RowBox[{"m", "-", "1"}]],
    FontWeight->"Bold"]}]],
  FontWeight->"Bold"]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, {3.5437934369615936`*^9, 
   3.543793521981713*^9}, {3.5437942320727067`*^9, 3.543794240342718*^9}, {
   3.543794292812792*^9, 3.5437942952227955`*^9}, {3.543794347142868*^9, 
   3.543794353242876*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"u_.", "*", 
    RowBox[{"v_", "^", "m_"}], "*", 
    RowBox[{"w_", "^", "n_"}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"FixSimplify", "[", 
     RowBox[{"u", "*", 
      RowBox[{"v", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "w", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "+", 
      RowBox[{"w", "^", 
       RowBox[{"(", 
        RowBox[{"-", "n"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, 
   3.5432514507623014`*^9, {3.5433392598170357`*^9, 3.54333927706706*^9}, {
   3.5433393318371367`*^9, 3.5433393910572195`*^9}, {3.5433394523673058`*^9, 
   3.5433395065873814`*^9}, {3.543347451262886*^9, 3.5433474631129026`*^9}, {
   3.5433476617531805`*^9, 3.5433476858432145`*^9}, {3.543347931743559*^9, 
   3.543347934003562*^9}, {3.5433480399637103`*^9, 3.5433480408137116`*^9}, {
   3.543348332054119*^9, 3.543348420714244*^9}, {3.543348500184355*^9, 
   3.543348500494355*^9}, {3.5433508070195866`*^9, 3.543350822829609*^9}, 
   3.5433508939197083`*^9, {3.5433523338117237`*^9, 3.5433523384217305`*^9}, {
   3.5433530012126584`*^9, 3.543353085012776*^9}, {3.5433531346128454`*^9, 
   3.543353189832923*^9}, {3.543353342463136*^9, 3.543353371263177*^9}, {
   3.54335340233322*^9, 3.5433534205332456`*^9}, {3.543356985492349*^9, 
   3.543356985532349*^9}, {3.543793407831553*^9, 3.5437934082815533`*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["v", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "v"}], ")"}], "n"]}], 
   StyleBox["\[Equal]",
    FontWeight->"Bold"], 
   StyleBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     SuperscriptBox["v", 
      RowBox[{"m", "+", "n"}]]}],
    FontWeight->"Bold"]}]],
  FontWeight->"Bold"]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, {3.5437934369615936`*^9, 
   3.543793521981713*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"u_.", "*", 
    RowBox[{"v_", "^", "m_"}], "*", 
    RowBox[{"w_", "^", "n_."}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"(", "n", ")"}]}], "*", 
    RowBox[{"FixSimplify", "[", 
     RowBox[{"u", "*", 
      RowBox[{"v", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "w", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, 
   3.5432514507623014`*^9, {3.5433392598170357`*^9, 3.54333927706706*^9}, {
   3.5433393318371367`*^9, 3.5433393910572195`*^9}, {3.5433394523673058`*^9, 
   3.5433395065873814`*^9}, {3.543347451262886*^9, 3.5433474631129026`*^9}, {
   3.5433476617531805`*^9, 3.5433476858432145`*^9}, {3.543347931743559*^9, 
   3.543347934003562*^9}, {3.5433480399637103`*^9, 3.5433480408137116`*^9}, {
   3.543348332054119*^9, 3.543348420714244*^9}, {3.543348500184355*^9, 
   3.543348500494355*^9}, {3.5433508070195866`*^9, 3.543350822829609*^9}, 
   3.5433508939197083`*^9, {3.5433523338117237`*^9, 3.5433523384217305`*^9}, {
   3.5433530012126584`*^9, 3.543353085012776*^9}, {3.5433531346128454`*^9, 
   3.543353189832923*^9}, {3.543353342463136*^9, 3.543353371263177*^9}, {
   3.54335340233322*^9, 3.5433534205332456`*^9}, {3.543356985492349*^9, 
   3.543356985532349*^9}, 3.543793417581567*^9, {3.5437935697917795`*^9, 
   3.5437935702617807`*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{
    FractionBox["n", "p"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox["v", "p"]}], ")"}], "m"], " ", 
     SuperscriptBox["v", "n"]}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      FractionBox["n", "p"]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox["v", "p"]}], ")"}], 
      RowBox[{"m", "+", 
       FractionBox["n", "p"]}]]}]}],
   FontWeight->"Bold"]]]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, {3.5437934369615936`*^9, 
   3.543793521981713*^9}, {3.543793587691805*^9, 3.5437935880618052`*^9}, {
   3.543793622811854*^9, 3.5437936939019537`*^9}, {3.5437937592320447`*^9, 
   3.54379377677207*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"u_.", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       RowBox[{"v_", "^", "p_."}]}], ")"}], "^", "m_"}], "*", 
    RowBox[{"w_", "^", "n_."}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "/", "p"}], ")"}]}], "*", 
    RowBox[{"FixSimplify", "[", 
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", 
         RowBox[{"v", "^", "p"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "/", "p"}]}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "w", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "-", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, 
   3.5432514507623014`*^9, {3.5433392598170357`*^9, 3.54333927706706*^9}, {
   3.5433393318371367`*^9, 3.5433393910572195`*^9}, {3.5433394523673058`*^9, 
   3.5433395065873814`*^9}, {3.543347451262886*^9, 3.5433474631129026`*^9}, {
   3.5433476617531805`*^9, 3.5433476858432145`*^9}, {3.543347931743559*^9, 
   3.543347934003562*^9}, {3.5433480399637103`*^9, 3.5433480408137116`*^9}, {
   3.543348332054119*^9, 3.543348420714244*^9}, {3.543348500184355*^9, 
   3.543348500494355*^9}, {3.5433508070195866`*^9, 3.543350822829609*^9}, 
   3.5433508939197083`*^9, {3.5433523338117237`*^9, 3.5433523384217305`*^9}, {
   3.5433530012126584`*^9, 3.543353085012776*^9}, {3.5433531346128454`*^9, 
   3.543353189832923*^9}, {3.543353342463136*^9, 3.543353371263177*^9}, {
   3.54335340233322*^9, 3.5433534205332456`*^9}, {3.543356985492349*^9, 
   3.543356985532349*^9}, 3.543793417581567*^9, 3.543793574801787*^9, {
   3.54379384847217*^9, 3.54379384866217*^9}}],

Cell[TextData[{
 StyleBox["Basis: If  ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "|", 
      FractionBox["n", "p"]}], ")"}], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}],
   FontWeight->"Bold"]],
  FontWeight->"Bold"],
 StyleBox[", then ",
  FontWeight->"Bold"],
 Cell[BoxData[
  StyleBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox["v", "p"]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "v"}], ")"}], "n"]}], "\[Equal]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"n", "+", 
       FractionBox["n", "p"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox["v", "p"]}], ")"}], 
      RowBox[{"m", "+", 
       FractionBox["n", "p"]}]]}]}],
   FontWeight->"Bold"]]]
}], "Item",
 CellChangeTimes->{
  3.540237245020024*^9, 3.5402394493818955`*^9, {3.5402399400409746`*^9, 
   3.5402399667014213`*^9}, 3.5408664750376034`*^9, 3.5408665884966025`*^9, {
   3.541274831499587*^9, 3.5412748328095894`*^9}, {3.54127486935964*^9, 
   3.541274877679652*^9}, {3.5437918712243977`*^9, 3.54379191577446*^9}, {
   3.5437919516145105`*^9, 3.543792005614586*^9}, {3.543792049154647*^9, 
   3.543792050294648*^9}, {3.543792097164714*^9, 3.543792098464716*^9}, {
   3.5437932873213844`*^9, 3.5437932875313845`*^9}, {3.5437934369615936`*^9, 
   3.543793521981713*^9}, {3.543793587691805*^9, 3.5437935880618052`*^9}, {
   3.543793622811854*^9, 3.5437936939019537`*^9}, {3.5437937592320447`*^9, 
   3.54379377677207*^9}, {3.5437938705922008`*^9, 3.5437938738222055`*^9}, {
   3.543793922922274*^9, 3.5437939284822817`*^9}, {3.5437940189524083`*^9, 
   3.543794058582464*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FixSimplify", "[", 
   RowBox[{"u_.", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       RowBox[{"v_", "^", "p_."}]}], ")"}], "^", "m_"}], "*", 
    RowBox[{"w_", "^", "n_."}]}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", 
       RowBox[{"n", "/", "p"}]}], ")"}]}], "*", 
    RowBox[{"FixSimplify", "[", 
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", 
         RowBox[{"v", "^", "p"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", "/", "p"}]}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "w", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", 
      RowBox[{"n", "/", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, 
   3.5432514507623014`*^9, {3.5433392598170357`*^9, 3.54333927706706*^9}, {
   3.5433393318371367`*^9, 3.5433393910572195`*^9}, {3.5433394523673058`*^9, 
   3.5433395065873814`*^9}, {3.543347451262886*^9, 3.5433474631129026`*^9}, {
   3.5433476617531805`*^9, 3.5433476858432145`*^9}, {3.543347931743559*^9, 
   3.543347934003562*^9}, {3.5433480399637103`*^9, 3.5433480408137116`*^9}, {
   3.543348332054119*^9, 3.543348420714244*^9}, {3.543348500184355*^9, 
   3.543348500494355*^9}, {3.5433508070195866`*^9, 3.543350822829609*^9}, 
   3.5433508939197083`*^9, {3.5433523338117237`*^9, 3.5433523384217305`*^9}, {
   3.5433530012126584`*^9, 3.543353085012776*^9}, {3.5433531346128454`*^9, 
   3.543353189832923*^9}, {3.543353342463136*^9, 3.543353371263177*^9}, {
   3.54335340233322*^9, 3.5433534205332456`*^9}, {3.543356985492349*^9, 
   3.543356985532349*^9}, 3.543793417581567*^9, 3.543793574801787*^9, 
   3.543793852372175*^9, 3.543794136912574*^9, {3.5445050669879503`*^9, 
   3.544505067292968*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], "^", "m_."}]}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{"u", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ")"}], "^", "m"}]}], " ", "/;", "\n", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"d", "^", "2"}]}], "-", 
        RowBox[{"e", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "*", "d"}], "-", 
           RowBox[{"a", "*", "e"}]}], ")"}]}]}], ")"}], "^", "m_."}]}], "]"}],
    " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"u", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"d", "^", "2"}]}], "-", 
        RowBox[{"b", "*", "d", "*", "e"}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"e", "^", "2"}]}]}], ")"}], "^", "m"}]}], " ", "/;", "\n", 
    RowBox[{"RationalQ", "[", "m", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FixSimplify", "[", 
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"d", "^", "2"}]}], "+", 
        RowBox[{"e", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "b"}], "*", "d"}], "+", 
           RowBox[{"a", "*", "e"}]}], ")"}]}]}], ")"}], "^", "m_."}]}], "]"}],
    " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"u", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"d", "^", "2"}]}], "-", 
        RowBox[{"b", "*", "d", "*", "e"}], "+", 
        RowBox[{"a", "*", 
         RowBox[{"e", "^", "2"}]}]}], ")"}], "^", "m"}]}], " ", "/;", "\n", 
    RowBox[{"RationalQ", "[", "m", "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"FixSimplify", "[", "u_", "]"}], " ", ":=", " ", "u"}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, {3.543009417330719*^9, 3.543009434446698*^9}, {
   3.5430096535302286`*^9, 3.543009660698639*^9}, {3.543009691012373*^9, 
   3.543009696078663*^9}, {3.543009726878424*^9, 3.5430097820725813`*^9}, 
   3.5430098545677276`*^9, {3.54300994640098*^9, 3.543009949734171*^9}, {
   3.5430099831590824`*^9, 3.5430099857612314`*^9}, {3.543010899526496*^9, 
   3.5430109529655523`*^9}, {3.5431978861581554`*^9, 
   3.5431978900481606`*^9}, {3.543197934418223*^9, 3.5431980748484197`*^9}, {
   3.5431981304884977`*^9, 3.543198165268546*^9}, {3.5431986562992334`*^9, 
   3.543198698059292*^9}, {3.543199645340618*^9, 3.543199647080621*^9}, {
   3.5431998648009253`*^9, 3.5431999484110427`*^9}, {3.5432001319912996`*^9, 
   3.5432001775513635`*^9}, {3.5432007702021933`*^9, 
   3.5432008363522854`*^9}, {3.5432417439291773`*^9, 
   3.5432419014846706`*^9}, {3.543242601480353*^9, 3.543242644708825*^9}, {
   3.543242958495136*^9, 3.5432429622843523`*^9}, {3.543243118419992*^9, 
   3.5432431334778533`*^9}, {3.5432512741048517`*^9, 
   3.5432513122753057`*^9}, {3.543251363083378*^9, 3.543251413721849*^9}, 
   3.5432514507623014`*^9, {3.5433392598170357`*^9, 3.54333927706706*^9}, {
   3.5433393318371367`*^9, 3.5433393910572195`*^9}, {3.5433394523673058`*^9, 
   3.5433395065873814`*^9}, {3.543347451262886*^9, 3.5433474631129026`*^9}, {
   3.5433476617531805`*^9, 3.5433476858432145`*^9}, {3.543347931743559*^9, 
   3.543347934003562*^9}, {3.5433480399637103`*^9, 3.5433480408137116`*^9}, {
   3.543348332054119*^9, 3.543348420714244*^9}, {3.543348500184355*^9, 
   3.543348500494355*^9}, {3.5433508070195866`*^9, 3.543350822829609*^9}, 
   3.5433508939197083`*^9, {3.5433523338117237`*^9, 3.5433523384217305`*^9}, {
   3.5433530012126584`*^9, 3.543353085012776*^9}, {3.5433531346128454`*^9, 
   3.543353189832923*^9}, {3.543353342463136*^9, 3.543353371263177*^9}, {
   3.54335340233322*^9, 3.5433534205332456`*^9}, {3.543356985492349*^9, 
   3.543356985532349*^9}, 3.543793417581567*^9, 3.543793574801787*^9, 
   3.543793852372175*^9, 3.543794136912574*^9, {3.5445051051511335`*^9, 
   3.5445051933271766`*^9}, {3.544507017599519*^9, 3.544507039853792*^9}, {
   3.5448407863775005`*^9, 3.5448408009011264`*^9}, {3.5448408357983875`*^9, 
   3.544840858309227*^9}, {3.544841191354212*^9, 3.544841212086649*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["SimpFixFactor", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, 3.543179364965173*^9, 
   3.5431878466054516`*^9, {3.5431958667653284`*^9, 3.543195868665331*^9}, 
   3.543267792391242*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SimpFixFactor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"c_", "^", "r_"}]}], " ", "+", " ", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], ",", "x_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"r", "*", "p"}], ")"}]}], "*", 
     RowBox[{"SimpFixFactor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{
           RowBox[{"b", "/", 
            RowBox[{"c", "^", "r"}]}], "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"AtomQ", "[", "c", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "r", "]"}], " ", "&&", " ", 
     RowBox[{"r", "<", "0"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SimpFixFactor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", " ", "+", " ", 
        RowBox[{"b_.", "*", 
         RowBox[{"c_", "^", "r_"}], "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], ",", "x_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"r", "*", "p"}], ")"}]}], "*", 
     RowBox[{"SimpFixFactor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "/", 
           RowBox[{"c", "^", "r"}]}], "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"AtomQ", "[", "c", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "r", "]"}], " ", "&&", " ", 
     RowBox[{"r", "<", "0"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SimpFixFactor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"c_", "^", "s_."}]}], " ", "+", " ", 
        RowBox[{"b_.", "*", 
         RowBox[{"c_", "^", "r_."}], "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], ",", "x_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"s", "*", "p"}], ")"}]}], "*", 
     RowBox[{"SimpFixFactor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"c", "^", 
            RowBox[{"(", 
             RowBox[{"r", "-", "s"}], ")"}]}], "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"s", ",", "r"}], "]"}], " ", "&&", " ", 
     RowBox[{"0", "<", "s", "\[LessEqual]", "r"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"c", "^", 
       RowBox[{"(", 
        RowBox[{"s", "*", "p"}], ")"}]}], "=!=", 
      RowBox[{"-", "1"}]}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SimpFixFactor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"c_", "^", "s_."}]}], " ", "+", " ", 
        RowBox[{"b_.", "*", 
         RowBox[{"c_", "^", "r_."}], "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}], ",", "x_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"r", "*", "p"}], ")"}]}], "*", 
     RowBox[{"SimpFixFactor", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"c", "^", 
            RowBox[{"(", 
             RowBox[{"s", "-", "r"}], ")"}]}]}], "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"s", ",", "r"}], "]"}], " ", "&&", " ", 
     RowBox[{"0", "<", "r", "<", "s"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"c", "^", 
       RowBox[{"(", 
        RowBox[{"r", "*", "p"}], ")"}]}], "=!=", 
      RowBox[{"-", "1"}]}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"SimpFixFactor", "[", 
   RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", " ", "u"}]}], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, 
   3.543172494468053*^9, {3.543184440880684*^9, 3.543184461140712*^9}, {
   3.5431845108007812`*^9, 3.5431845659708586`*^9}, {3.543184597410903*^9, 
   3.5431846915810347`*^9}, {3.5431847728011484`*^9, 
   3.5431849613114123`*^9}, {3.5431849958214607`*^9, 3.543185050571537*^9}, {
   3.543185151031678*^9, 3.543185156661686*^9}, {3.543185267391841*^9, 
   3.543185274571851*^9}, {3.543185330661929*^9, 3.5431854721421275`*^9}, {
   3.5431855260322027`*^9, 3.543185529612208*^9}, {3.5431856463623714`*^9, 
   3.543185670002404*^9}, {3.543185747752513*^9, 3.5431858427726464`*^9}, {
   3.543185879592698*^9, 3.543185888732711*^9}, {3.5431859850828457`*^9, 
   3.5431859871728487`*^9}, {3.543186272583248*^9, 3.543186272593248*^9}, {
   3.5431958767553425`*^9, 3.5431959095953884`*^9}, {3.543195985995495*^9, 
   3.5431960113855305`*^9}, {3.543196067025609*^9, 3.5431961933857856`*^9}, {
   3.5431965302862573`*^9, 3.543196572836317*^9}, {3.543196821746665*^9, 
   3.5431969920269036`*^9}, {3.5431971852971745`*^9, 
   3.5431973183573604`*^9}, {3.543248737208076*^9, 3.5432488537218404`*^9}, {
   3.5432488961203003`*^9, 3.543248897020302*^9}, 3.5432490495697165`*^9, {
   3.5432492845600476`*^9, 3.543249358340952*^9}, {3.543266556889512*^9, 
   3.543266560269517*^9}, {3.5432666395596275`*^9, 3.5432666416896305`*^9}, {
   3.5432667767498198`*^9, 3.543266779789824*^9}, {3.54326704097019*^9, 
   3.543267043680194*^9}, {3.543267161850359*^9, 3.5432671834303894`*^9}, {
   3.5432675394908876`*^9, 3.543267572620934*^9}, {3.5432676075109825`*^9, 
   3.5432676286310124`*^9}, {3.5432677930012426`*^9, 3.543267795381246*^9}, {
   3.5432678524613256`*^9, 3.54326791256141*^9}, {3.543267996331527*^9, 
   3.543268012021549*^9}, {3.543268113501691*^9, 3.5432681479617395`*^9}, {
   3.5438052799816866`*^9, 3.54380532576175*^9}, {3.543805512202011*^9, 
   3.5438055722220955`*^9}, {3.5438056186121607`*^9, 
   3.5438056229121666`*^9}, {3.5438056597722178`*^9, 
   3.5438056620122213`*^9}, {3.5438057689123707`*^9, 3.543805812502432*^9}, {
   3.5438059672726483`*^9, 3.5438059851926737`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["FactorNumericGcd", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, 3.543179364965173*^9, 
   3.5431878466054516`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"FactorNumericGcd", "[", "u", "]"}], " ", "returns", " ", "u", 
    " ", "with", " ", "the", " ", "gcd", " ", "of", " ", "the", " ", 
    "numeric", " ", "coefficients", " ", "of", " ", "terms", " ", "of", " ", 
    "sums", " ", "factored", " ", 
    RowBox[{"out", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FactorNumericGcd", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", 
       RowBox[{"u", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
     RowBox[{
      RowBox[{"FactorNumericGcd", "[", 
       RowBox[{"u", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], "^", 
      RowBox[{"u", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Map", "[", 
        RowBox[{"FactorNumericGcd", ",", "u"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"g", "=", 
             RowBox[{"Apply", "[", 
              RowBox[{"GCD", ",", 
               RowBox[{"Map", "[", 
                RowBox[{"NumericFactor", ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
            "}"}], ",", "\n", "    ", 
           RowBox[{"g", "*", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"#", "/", "g"}], "]"}], ",", "u"}], "]"}]}]}], "]"}], 
         ",", "\n", "  ", "u"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, 
   3.543172494468053*^9, {3.543184440880684*^9, 3.543184461140712*^9}, {
   3.5431845108007812`*^9, 3.5431845659708586`*^9}, {3.543184597410903*^9, 
   3.5431846915810347`*^9}, {3.5431847728011484`*^9, 
   3.5431849613114123`*^9}, {3.5431849958214607`*^9, 3.543185050571537*^9}, {
   3.543185151031678*^9, 3.543185156661686*^9}, {3.543185267391841*^9, 
   3.543185274571851*^9}, {3.543185330661929*^9, 3.5431854721421275`*^9}, {
   3.5431855260322027`*^9, 3.543185529612208*^9}, {3.5431856463623714`*^9, 
   3.543185670002404*^9}, {3.543185747752513*^9, 3.5431858427726464`*^9}, {
   3.543185879592698*^9, 3.543185888732711*^9}, {3.5431859850828457`*^9, 
   3.5431859871728487`*^9}, {3.543186272583248*^9, 3.543186272593248*^9}, {
   3.5432479600117807`*^9, 3.543247983679414*^9}, {3.543250280785452*^9, 
   3.543250388151603*^9}, {3.5432504494596896`*^9, 3.5432504947701535`*^9}, {
   3.543250525652997*^9, 3.543250533383008*^9}, {3.5432583345980005`*^9, 
   3.54325834087801*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["MergeFactors", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.519578201776486*^9, 3.5195782096700997`*^9}, {3.5195792378115063`*^9, 
   3.519579238357507*^9}, 3.52011052994267*^9, 3.543179364965173*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MergeFactors", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "the", " ", 
     "product", " ", "of", " ", "u", " ", "and", " ", "v"}], ",", " ", 
    RowBox[{
    "but", " ", "with", " ", "the", " ", "mergeable", " ", "factors", " ", 
     "of", " ", "u", " ", "merged", " ", "into", " ", 
     RowBox[{"v", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MergeFactors", "[", 
    RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"MergeFactors", "[", 
      RowBox[{
       RowBox[{"Rest", "[", "u", "]"}], ",", 
       RowBox[{"MergeFactors", "[", 
        RowBox[{
         RowBox[{"First", "[", "u", "]"}], ",", "v"}], "]"}]}], "]"}], ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MergeableFactorQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
         "      ", 
         RowBox[{"MergeFactor", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"RationalQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "<", 
             RowBox[{"-", "1"}]}], " ", "&&", " ", 
            RowBox[{"MergeableFactorQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"-", "1"}], ",", "v"}], "]"}]}], ",", "\n", "      ", 
           RowBox[{"MergeFactors", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], ")"}]}], ",", 
             RowBox[{"MergeFactor", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"-", "1"}], ",", "v"}], "]"}]}], "]"}], ",", "\n", 
           "    ", 
           RowBox[{"u", "*", "v"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MergeableFactorQ", "[", 
          RowBox[{"u", ",", "1", ",", "v"}], "]"}], ",", "\n", "    ", 
         RowBox[{"MergeFactor", "[", 
          RowBox[{"u", ",", "1", ",", "v"}], "]"}], ",", "\n", "  ", 
         RowBox[{"u", "*", "v"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, {
   3.543172500518061*^9, 3.5431725041880665`*^9}, {3.543172547448127*^9, 
   3.543172681558315*^9}, {3.5431727215383706`*^9, 3.543172793278471*^9}, {
   3.5431728732785835`*^9, 3.5431728738185835`*^9}, {3.5431729115986366`*^9, 
   3.5431729128886385`*^9}, {3.543172956268699*^9, 3.543173044568823*^9}, {
   3.5431731953890343`*^9, 3.5431731981190376`*^9}, {3.543173240229097*^9, 
   3.5431733699892783`*^9}, {3.5431739475700874`*^9, 3.5431741789904113`*^9}, 
   3.543174238990495*^9, 3.543176868731678*^9, {3.5431769559018*^9, 
   3.543177003951867*^9}, {3.5431770959919963`*^9, 3.5431771541720777`*^9}, {
   3.5431771982221394`*^9, 3.5431771985521398`*^9}, {3.5431772707222404`*^9, 
   3.5431773280923214`*^9}, {3.5431773727323837`*^9, 3.543177404912429*^9}, {
   3.543177465672514*^9, 3.5431775046125684`*^9}, {3.5431785010839634`*^9, 
   3.5431785390240164`*^9}, 3.543178580834075*^9, {3.543178632724148*^9, 
   3.5431786637541914`*^9}, {3.543179201644944*^9, 3.543179288795066*^9}, {
   3.543780241987609*^9, 3.543780340887747*^9}, {3.5437803803178024`*^9, 
   3.5437804311678734`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"MergeableFactorQ", "[", 
      RowBox[{"bas", ",", "deg", ",", "v"}], "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{"MergeFactor", "[", 
      RowBox[{"bas", ",", "deg", ",", "v"}], "]"}], " ", "return", " ", "the",
      " ", "product", " ", "of", " ", 
     RowBox[{"bas", "^", "deg"}], " ", "and", " ", "v"}], ",", " ", "\n", 
    "\t", 
    RowBox[{"but", " ", "with", " ", 
     RowBox[{"bas", "^", "deg"}], " ", "merged", " ", "into", " ", "the", " ",
      "factor", " ", "of", " ", "v", " ", "whose", " ", "base", " ", "equals",
      " ", 
     RowBox[{"bas", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MergeFactor", "[", 
    RowBox[{"bas_", ",", "deg_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"bas", "===", "v"}], ",", "\n", "    ", 
     RowBox[{"bas", "^", 
      RowBox[{"(", 
       RowBox[{"deg", "+", "1"}], ")"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"bas", "===", 
          RowBox[{"v", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\n", "      ", 
         RowBox[{"bas", "^", 
          RowBox[{"(", 
           RowBox[{"deg", "+", 
            RowBox[{"v", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"MergeFactor", "[", 
           RowBox[{"bas", ",", 
            RowBox[{"deg", "/", 
             RowBox[{"v", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"v", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "^", 
          RowBox[{"v", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "v", "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MergeableFactorQ", "[", 
            RowBox[{"bas", ",", "deg", ",", 
             RowBox[{"First", "[", "v", "]"}]}], "]"}], ",", "\n", "      ", 
           RowBox[{
            RowBox[{"MergeFactor", "[", 
             RowBox[{"bas", ",", "deg", ",", 
              RowBox[{"First", "[", "v", "]"}]}], "]"}], "*", 
            RowBox[{"Rest", "[", "v", "]"}]}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"First", "[", "v", "]"}], "*", 
            RowBox[{"MergeFactor", "[", 
             RowBox[{"bas", ",", "deg", ",", 
              RowBox[{"Rest", "[", "v", "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{
          RowBox[{"MergeFactor", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"First", "[", "v", "]"}]}], "]"}], " ", "+", " ", 
          RowBox[{"MergeFactor", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"Rest", "[", "v", "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, {
   3.543172500518061*^9, 3.5431725041880665`*^9}, {3.543172547448127*^9, 
   3.543172681558315*^9}, {3.5431727215383706`*^9, 3.543172793278471*^9}, {
   3.5431728732785835`*^9, 3.5431728738185835`*^9}, {3.5431729115986366`*^9, 
   3.5431729128886385`*^9}, {3.543172956268699*^9, 3.543173044568823*^9}, {
   3.5431731953890343`*^9, 3.5431731981190376`*^9}, {3.543173240229097*^9, 
   3.5431733993093195`*^9}, {3.543173482559436*^9, 3.5431734845494385`*^9}, {
   3.5431735431795206`*^9, 3.5431735880195837`*^9}, {3.5431736207196293`*^9, 
   3.543173635889651*^9}, {3.5431737147997613`*^9, 3.54317382093991*^9}, {
   3.5431738630799685`*^9, 3.5431739072100306`*^9}, {3.5431742608805256`*^9, 
   3.543174313020599*^9}, {3.5431743972607164`*^9, 3.5431744160607433`*^9}, {
   3.543174449100789*^9, 3.543174547710927*^9}, {3.543174603781006*^9, 
   3.5431746072210107`*^9}, {3.5431746617310867`*^9, 3.5431747484712086`*^9}, 
   3.5431748181313057`*^9, {3.543175010311575*^9, 3.543175026941598*^9}, {
   3.54317506358165*^9, 3.5431750763516674`*^9}, {3.543175116071723*^9, 
   3.5431751170217247`*^9}, {3.5431752008418417`*^9, 
   3.5431752327693872`*^9}, {3.543175269389439*^9, 3.5431754370196733`*^9}, {
   3.543175474319726*^9, 3.54317552013979*^9}, {3.5431755659698544`*^9, 
   3.543175690160028*^9}, {3.5431758112901974`*^9, 3.5431758277702208`*^9}, {
   3.543175858700264*^9, 3.5431760320005064`*^9}, {3.5431761190206285`*^9, 
   3.543176152090675*^9}, {3.543176232410787*^9, 3.5431762610908275`*^9}, {
   3.54317629152087*^9, 3.543176299780882*^9}, {3.543176346370947*^9, 
   3.543176397721019*^9}, {3.5431764284510612`*^9, 3.543176428521062*^9}, {
   3.543176490651149*^9, 3.543176490871149*^9}, {3.5431765284512014`*^9, 
   3.5431765810612755`*^9}, {3.5431766132313204`*^9, 3.543176633431349*^9}, {
   3.5431766988714404`*^9, 3.5431767157414637`*^9}, {3.543177689512827*^9, 
   3.5431778175030065`*^9}, {3.543177852383055*^9, 3.5431779949032545`*^9}, {
   3.5431781633834906`*^9, 3.5431783225837135`*^9}, {3.543178357203762*^9, 
   3.54317836977378*^9}, {3.543178706374251*^9, 3.5431787294442835`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"MergeableFactorQ", "[", 
     RowBox[{"bas", ",", "deg", ",", "v"}], "]"}], " ", "returns", " ", 
    "True", " ", "iff", " ", "bas", " ", "equals", " ", "the", " ", "base", 
    " ", "of", " ", "a", " ", "factor", " ", "of", " ", "v", " ", "or", " ", 
    "bas", " ", "is", " ", "a", " ", "factor", " ", "of", " ", "every", " ", 
    "term", " ", "of", " ", 
    RowBox[{"v", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MergeableFactorQ", "[", 
    RowBox[{"bas_", ",", "deg_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"bas", "===", "v"}], ",", "\n", "    ", 
     RowBox[{
      RowBox[{"RationalQ", "[", 
       RowBox[{"deg", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"deg", "+", "1"}], "\[GreaterEqual]", "0"}], " ", "||", " ", 
        RowBox[{
         RowBox[{"RationalQ", "[", "deg", "]"}], " ", "&&", " ", 
         RowBox[{"deg", ">", "0"}]}]}], ")"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"bas", "===", 
          RowBox[{"v", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", "\n", "      ", 
         RowBox[{
          RowBox[{"RationalQ", "[", 
           RowBox[{"deg", "+", 
            RowBox[{"v", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], " ", "&&", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"deg", "+", 
              RowBox[{"v", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "\[GreaterEqual]", "0"}], 
            " ", "||", " ", 
            RowBox[{
             RowBox[{"RationalQ", "[", "deg", "]"}], " ", "&&", " ", 
             RowBox[{"deg", ">", "0"}]}]}], ")"}]}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"SumQ", "[", 
           RowBox[{"v", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQ", "[", 
           RowBox[{"v", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Not", "[", 
             RowBox[{"IntegerQ", "[", "deg", "]"}], "]"}], " ", "||", " ", 
            RowBox[{"IntegerQ", "[", 
             RowBox[{"deg", "/", 
              RowBox[{"v", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ")"}], " ", "&&", 
          " ", 
          RowBox[{"MergeableFactorQ", "[", 
           RowBox[{"bas", ",", 
            RowBox[{"deg", "/", 
             RowBox[{"v", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", 
            RowBox[{"v", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "v", "]"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"MergeableFactorQ", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"First", "[", "v", "]"}]}], "]"}], " ", "||", " ", 
          RowBox[{"MergeableFactorQ", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"Rest", "[", "v", "]"}]}], "]"}]}], ",", "\n", "  ", 
         RowBox[{
          RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
          RowBox[{"MergeableFactorQ", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"First", "[", "v", "]"}]}], "]"}], " ", "&&", " ", 
          RowBox[{"MergeableFactorQ", "[", 
           RowBox[{"bas", ",", "deg", ",", 
            RowBox[{"Rest", "[", "v", "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519515924057679*^9, 3.5195159435677066`*^9}, {
   3.5201105463926935`*^9, 3.5201105636427174`*^9}, {3.5224368414850636`*^9, 
   3.522436845195069*^9}, {3.5224575370949225`*^9, 3.522457569534968*^9}, {
   3.522458229079894*^9, 3.5224582643999434`*^9}, {3.522458319900021*^9, 
   3.5224584037201385`*^9}, {3.5224591480011806`*^9, 3.522459149191182*^9}, {
   3.5224594408975954`*^9, 3.5224594469876037`*^9}, {3.524677217329288*^9, 
   3.524677333779451*^9}, {3.5246775793597946`*^9, 3.5246776502698936`*^9}, {
   3.524677710719979*^9, 3.524677722109995*^9}, {3.5246781747706285`*^9, 
   3.524678179750635*^9}, {3.5246782320307083`*^9, 3.5246782630007515`*^9}, {
   3.5246783100508175`*^9, 3.5246783294008446`*^9}, {3.5246784770310516`*^9, 
   3.5246784811510572`*^9}, {3.527207485002201*^9, 3.5272074967222176`*^9}, {
   3.5272091179223223`*^9, 3.5272091287523375`*^9}, {3.527209643533058*^9, 
   3.527209675423103*^9}, {3.5272106423084593`*^9, 3.5272106430184603`*^9}, 
   3.52721430951182*^9, {3.5350715214639845`*^9, 3.535071525593991*^9}, {
   3.5351453707709055`*^9, 3.53514537393091*^9}, {3.535321184948083*^9, 
   3.5353211855876837`*^9}, {3.54230169824848*^9, 3.542301743468543*^9}, {
   3.5423023071593323`*^9, 3.542302313839342*^9}, {3.5423041219318733`*^9, 
   3.542304140321899*^9}, {3.542306701195484*^9, 3.5423067183555083`*^9}, {
   3.5423070414459605`*^9, 3.5423070496659718`*^9}, {3.5423071483461103`*^9, 
   3.5423071702561407`*^9}, {3.5423073050363293`*^9, 
   3.5423073192063494`*^9}, {3.542307365776415*^9, 3.542307382556438*^9}, {
   3.5423074209664917`*^9, 3.5423074769665704`*^9}, 3.5423075394066577`*^9, {
   3.5423096697096405`*^9, 3.54230970566969*^9}, {3.5423106448010054`*^9, 
   3.542310649431012*^9}, {3.542311586742324*^9, 3.542311592312332*^9}, {
   3.5423116271323805`*^9, 3.542311648802411*^9}, {3.542324689587289*^9, 
   3.5423248816675577`*^9}, {3.5423251847779818`*^9, 3.5423251910379906`*^9}, 
   3.542327440891147*^9, 3.5430094130904765`*^9, {3.54301083963807*^9, 
   3.5430108620333514`*^9}, {3.543010967416379*^9, 3.543010970476554*^9}, {
   3.543172500518061*^9, 3.5431725041880665`*^9}, {3.543172547448127*^9, 
   3.543172681558315*^9}, {3.5431727215383706`*^9, 3.543172793278471*^9}, {
   3.5431728732785835`*^9, 3.5431728738185835`*^9}, {3.5431729115986366`*^9, 
   3.5431729128886385`*^9}, {3.543172956268699*^9, 3.543173044568823*^9}, {
   3.5431731953890343`*^9, 3.5431731981190376`*^9}, {3.543173240229097*^9, 
   3.5431733993093195`*^9}, {3.543173482559436*^9, 3.5431734845494385`*^9}, {
   3.5431735431795206`*^9, 3.5431735880195837`*^9}, {3.5431736207196293`*^9, 
   3.543173635889651*^9}, {3.5431737147997613`*^9, 3.54317382093991*^9}, {
   3.5431738630799685`*^9, 3.5431739072100306`*^9}, {3.5431742608805256`*^9, 
   3.543174313020599*^9}, {3.5431743972607164`*^9, 3.5431744160607433`*^9}, {
   3.543174449100789*^9, 3.543174547710927*^9}, {3.543174603781006*^9, 
   3.5431746072210107`*^9}, {3.5431746617310867`*^9, 3.5431747484712086`*^9}, 
   3.5431748181313057`*^9, {3.543175010311575*^9, 3.543175026941598*^9}, {
   3.54317506358165*^9, 3.5431750763516674`*^9}, {3.543175116071723*^9, 
   3.5431751170217247`*^9}, {3.5431752008418417`*^9, 
   3.5431752327693872`*^9}, {3.543175269389439*^9, 3.5431754370196733`*^9}, {
   3.543175474319726*^9, 3.54317552013979*^9}, {3.5431755659698544`*^9, 
   3.543175690160028*^9}, {3.5431758112901974`*^9, 3.5431758277702208`*^9}, {
   3.543175858700264*^9, 3.5431760320005064`*^9}, {3.5431761190206285`*^9, 
   3.543176152090675*^9}, {3.543176232410787*^9, 3.5431762610908275`*^9}, {
   3.54317629152087*^9, 3.543176299780882*^9}, {3.543176346370947*^9, 
   3.543176397721019*^9}, {3.5431764284510612`*^9, 3.543176428521062*^9}, {
   3.543176490651149*^9, 3.543176490871149*^9}, {3.5431765284512014`*^9, 
   3.5431765810612755`*^9}, {3.5431766132313204`*^9, 3.543176633431349*^9}, {
   3.5431766988714404`*^9, 3.5431767157414637`*^9}, {3.543178936294573*^9, 
   3.543178986724643*^9}, {3.543179022404693*^9, 3.5431790268746996`*^9}, {
   3.54378005030734*^9, 3.5437800555473475`*^9}, {3.543780193577541*^9, 
   3.543780210867565*^9}, {3.5437807264682865`*^9, 3.543780733768297*^9}, {
   3.5447438902623887`*^9, 3.5447439347424507`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Factoring Functions", "Section",
 CellChangeTimes->{{3.518825295745934*^9, 3.518825297485936*^9}, {
  3.5195159777377543`*^9, 3.51951598167776*^9}, {3.527205210856408*^9, 
  3.527205214116413*^9}}],

Cell[CellGroupData[{

Cell["RemoveContent", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
  3.5255394497616315`*^9, 3.5255394533964376`*^9}, {3.525540006261409*^9, 
  3.5255400084454126`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"RemoveContent", "[", 
     RowBox[{"expn", ",", "x"}], "]"}], " ", "returns", " ", "expn", " ", 
    "with", " ", "the", " ", "factored", " ", "content", " ", "free", " ", 
    "of", " ", "x", " ", 
    RowBox[{"removed", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RemoveContent", "[", 
    RowBox[{"expn_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{
        RowBox[{"SplitFreeFactors", "[", 
         RowBox[{
          RowBox[{"ContentFactor", "[", "expn", "]"}], ",", "x"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"NegQ", "[", 
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
       RowBox[{"-", "u"}], ",", "\n", "  ", "u"}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5188880039449263`*^9, 3.5188880361949716`*^9}, {
   3.518888105105068*^9, 3.518888162145148*^9}, {3.5188886874058833`*^9, 
   3.5188888019460435`*^9}, {3.5188890598664045`*^9, 3.518889082786437*^9}, {
   3.518889126786498*^9, 3.5188891359065113`*^9}, {3.5188892390766554`*^9, 
   3.5188892525766745`*^9}, {3.5188895454670844`*^9, 3.518889645097224*^9}, {
   3.518901059337432*^9, 3.518901120037138*^9}, {3.5189011775388393`*^9, 
   3.5189012159149065`*^9}, {3.518901248004163*^9, 3.5189012715758047`*^9}, {
   3.5189013105602727`*^9, 3.5189013132902775`*^9}, {3.5195108443005676`*^9, 
   3.519511044680848*^9}, {3.5195112076110764`*^9, 3.519511286401187*^9}, 
   3.5195113169412293`*^9, {3.519511393661337*^9, 3.519511477251454*^9}, {
   3.5195115785115957`*^9, 3.519511626911663*^9}, {3.51951166748172*^9, 
   3.5195119038720512`*^9}, {3.5195119529821196`*^9, 
   3.5195121496123953`*^9}, {3.519512293632597*^9, 3.519512353632681*^9}, {
   3.5195130663836784`*^9, 3.5195130732936883`*^9}, {3.525540024419841*^9, 
   3.5255401335576324`*^9}, {3.5255404737442303`*^9, 3.525540482090245*^9}, {
   3.5255406318637075`*^9, 3.525540695371419*^9}, {3.525540728755478*^9, 
   3.525540820483639*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["ContentFactor", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ContentFactor", "[", "expn", "]"}], " ", "returns", " ", "expn", 
    " ", "with", " ", "the", " ", "content", " ", "of", " ", "sum", " ", 
    "factors", " ", "factored", " ", 
    RowBox[{"out", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Basis", ":", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "*", "b"}], "+", 
      RowBox[{"a", "*", "c"}]}], " ", "==", " ", 
     RowBox[{"a", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ContentFactor", "[", "expn_", "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"TimeConstrained", "[", 
      RowBox[{
       RowBox[{"ContentFactorAux", "[", "expn", "]"}], ",", "TimeLimit", ",", 
       "expn"}], "]"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"ContentFactorAux", "[", "expn_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "expn", "]"}], ",", "\n", "    ", "expn", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"IntegerPowerQ", "[", "expn", "]"}], ",", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"SumQ", "[", 
            RowBox[{"expn", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
           RowBox[{
            RowBox[{"NumericFactor", "[", 
             RowBox[{"expn", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}], "<", "0"}]}], 
          ",", "\n", "      ", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], "^", 
            RowBox[{"expn", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], " ", "*", " ", 
           RowBox[{
            RowBox[{"ContentFactorAux", "[", 
             RowBox[{"-", 
              RowBox[{"expn", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "^", 
            RowBox[{"expn", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], ",", "\n", "    ", 
          RowBox[{
           RowBox[{"ContentFactorAux", "[", 
            RowBox[{"expn", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], "^", 
           RowBox[{"expn", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "expn", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"num", "=", "1"}], ",", "tmp"}], "}"}], ",", "\n", 
            "    ", 
            RowBox[{
             RowBox[{"tmp", "=", 
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SumQ", "[", "#", "]"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"NumericFactor", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
                   " ", 
                   RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"-", "num"}]}], ";", " ", 
                    RowBox[{"ContentFactorAux", "[", 
                    RowBox[{"-", "#"}], "]"}]}], ",", " ", 
                   RowBox[{"ContentFactorAux", "[", "#", "]"}]}], "]"}], 
                 "]"}], ",", " ", "expn"}], "]"}]}], ";", "\n", "    ", 
             RowBox[{"num", "*", 
              RowBox[{"UnifyNegativeBaseFactors", "[", "tmp", "]"}]}]}]}], 
           "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"SumQ", "[", "expn", "]"}], ",", "\n", "    ", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"lst", "=", 
                RowBox[{"CommonFactors", "[", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "expn"}], "]"}], "]"}]}], "}"}], ",", 
              "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], " ", "||", 
                 " ", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", 
                  RowBox[{"-", "1"}]}]}], ",", "\n", "      ", "expn", ",", 
                "\n", "    ", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "*", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"Plus", ",", 
                   RowBox[{"Rest", "[", "lst", "]"}]}], "]"}]}]}], "]"}]}], 
             "]"}], ",", "\n", "  ", "expn"}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188880039449263`*^9, 3.5188880361949716`*^9}, {
   3.518888105105068*^9, 3.518888162145148*^9}, {3.5188886874058833`*^9, 
   3.5188888019460435`*^9}, {3.5188890598664045`*^9, 3.518889082786437*^9}, {
   3.518889126786498*^9, 3.5188891359065113`*^9}, {3.5188892390766554`*^9, 
   3.5188892525766745`*^9}, {3.5188895454670844`*^9, 3.518889645097224*^9}, {
   3.518901059337432*^9, 3.518901120037138*^9}, {3.5189011775388393`*^9, 
   3.5189012159149065`*^9}, {3.518901248004163*^9, 3.5189012715758047`*^9}, {
   3.5189013105602727`*^9, 3.5189013132902775`*^9}, {3.5195108443005676`*^9, 
   3.519511044680848*^9}, {3.5195112076110764`*^9, 3.519511286401187*^9}, 
   3.5195113169412293`*^9, {3.519511393661337*^9, 3.519511477251454*^9}, {
   3.5195115785115957`*^9, 3.519511626911663*^9}, {3.51951166748172*^9, 
   3.5195119038720512`*^9}, {3.5195119529821196`*^9, 
   3.5195121496123953`*^9}, {3.519512293632597*^9, 3.519512353632681*^9}, {
   3.5195130663836784`*^9, 3.5195130732936883`*^9}, {3.527205317606558*^9, 
   3.5272053599066167`*^9}, {3.527205405526681*^9, 3.5272054264067097`*^9}, {
   3.527209660583082*^9, 3.5272096615630836`*^9}, {3.5272127390205603`*^9, 
   3.527212740050562*^9}, 3.5272143142074285`*^9, {3.5292164549293633`*^9, 
   3.5292164556001644`*^9}, {3.5293441629145403`*^9, 3.529344163101741*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"UnifyNegativeBaseFactors", "[", "u", "]"}], " ", "returns", " ", 
    "u", " ", "with", " ", "factors", " ", "of", " ", "the", " ", "form", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "v"}], ")"}], "^", "m"}], " ", "and", " ", 
    RowBox[{"v", "^", "n"}], " ", "where", " ", "n", " ", "is", " ", "an", 
    " ", "integer", " ", "replaced", " ", "with", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "v"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n"}], ")"}]}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "should", " ", "be", " ", "done", " ", "automatically", " ", 
    "by", " ", "the", " ", "host", " ", 
    RowBox[{"CAS", "!"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"UnifyNegativeBaseFactors", "[", 
     RowBox[{"u_.", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "v_"}], ")"}], "^", "m_"}], "*", 
      RowBox[{"v_", "^", "n_."}]}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"UnifyNegativeBaseFactors", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", "u", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "v"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"IntegerQ", "[", "n", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"UnifyNegativeBaseFactors", "[", "u_", "]"}], " ", ":=", "\n", 
    "  ", "u"}]}]}]], "Code",
 CellChangeTimes->{{3.5188880039449263`*^9, 3.5188880361949716`*^9}, {
   3.518888105105068*^9, 3.518888162145148*^9}, {3.5188886874058833`*^9, 
   3.5188888019460435`*^9}, {3.5188890598664045`*^9, 3.518889082786437*^9}, {
   3.518889126786498*^9, 3.5188891359065113`*^9}, {3.5188892390766554`*^9, 
   3.5188892525766745`*^9}, {3.5188895454670844`*^9, 3.518889645097224*^9}, {
   3.518901059337432*^9, 3.518901120037138*^9}, {3.5189011775388393`*^9, 
   3.5189012159149065`*^9}, {3.518901248004163*^9, 3.5189012715758047`*^9}, {
   3.5189013105602727`*^9, 3.5189013132902775`*^9}, {3.5195108443005676`*^9, 
   3.519511044680848*^9}, {3.5195112076110764`*^9, 3.519511286401187*^9}, 
   3.5195113169412293`*^9, {3.519511393661337*^9, 3.519511477251454*^9}, {
   3.5195115785115957`*^9, 3.519511626911663*^9}, {3.51951166748172*^9, 
   3.5195119038720512`*^9}, {3.5195119529821196`*^9, 
   3.5195121496123953`*^9}, {3.519512293632597*^9, 3.519512353632681*^9}, {
   3.5195123971427417`*^9, 3.519512496832881*^9}, {3.5195125295629272`*^9, 
   3.5195125329029317`*^9}, {3.519512570282984*^9, 3.519512750673237*^9}, {
   3.5195127853332853`*^9, 3.519512834603354*^9}, {3.519512872563407*^9, 
   3.519512897273442*^9}, 3.5195129341134934`*^9, {3.519513009733599*^9, 
   3.5195130204236145`*^9}, 3.51951330337401*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "lst", " ", "is", " ", "a", " ", "list", " ", "of", " ", "n", 
     " ", "terms"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CommonFactors", "[", "lst", "]"}], " ", "returns", " ", "a", 
      " ", "n"}], "+", "1", "-", 
     RowBox[{
     "element", " ", "list", " ", "whose", " ", "first", "\n", "\t", 
      "element", " ", "is", " ", "the", " ", "product", " ", "of", " ", "the",
       " ", "factors", " ", "common", " ", "to", " ", "all", " ", "terms", 
      " ", "of", " ", "lst"}]}], ",", " ", 
    RowBox[{
    "and", " ", "whose", " ", "remaining", "\n", "\t", "elements", " ", "are",
      " ", "quotients", " ", "of", " ", "each", " ", "term", " ", "divided", 
     " ", "by", " ", "the", " ", "common", " ", 
     RowBox[{"factor", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"CommonFactors", " ", "[", "lst_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "lst1", ",", "lst2", ",", "lst3", ",", "lst4", ",", "common", ",", 
       "base", ",", "num"}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"lst1", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"NonabsurdNumberFactors", ",", "lst"}], "]"}]}], ";", "\n", 
      "  ", 
      RowBox[{"lst2", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"AbsurdNumberFactors", ",", "lst"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"num", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"AbsurdNumberGCD", ",", "lst2"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"common", "=", "num"}], ";", "\n", "  ", 
      RowBox[{"lst2", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"#", "/", "num"}], "]"}], ",", "lst2"}], "]"}]}], ";", "\n",
       "  ", 
      RowBox[{"While", "[", 
       RowBox[{"True", ",", "\n", "    ", 
        RowBox[{
         RowBox[{"lst3", "=", 
          RowBox[{"Map", "[", 
           RowBox[{"LeadFactor", ",", "lst1"}], "]"}]}], ";", "\n", "    ", 
         RowBox[{"(", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Apply", "[", 
             RowBox[{"SameQ", ",", "lst3"}], "]"}], ",", "\n", "        ", 
            RowBox[{
             RowBox[{"common", "=", 
              RowBox[{"common", "*", 
               RowBox[{"lst3", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\n", "        ", 
             RowBox[{"lst1", "=", 
              RowBox[{"Map", "[", 
               RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",", 
            "\n", "      ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"MapAnd", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"LogQ", "[", "#", "]"}], " ", "&&", " ", 
                   RowBox[{"IntegerQ", "[", 
                    RowBox[{"First", "[", "#", "]"}], "]"}], " ", "&&", " ", 
                   RowBox[{
                    RowBox[{"First", "[", "#", "]"}], ">", "0"}]}], "]"}], 
                 ",", "lst3"}], "]"}], " ", "&&", "\n", "           ", 
               RowBox[{"MapAnd", "[", 
                RowBox[{"RationalQ", ",", 
                 RowBox[{"lst4", "=", 
                  RowBox[{"Map", "[", 
                   RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"#", "/", 
                    RowBox[{"First", "[", "lst3", "]"}]}], "]"}], "]"}], ",", 
                    "lst3"}], "]"}]}]}], "]"}]}], ",", "\n", "        ", 
              RowBox[{
               RowBox[{"num", "=", 
                RowBox[{"Apply", "[", 
                 RowBox[{"GCD", ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
               RowBox[{"common", "=", 
                RowBox[{"common", "*", 
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"First", "[", "lst3", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ")"}], "^", "num"}], 
                  "]"}]}]}], ";", "\n", "        ", 
               RowBox[{"lst2", "=", 
                RowBox[{"Map2", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"#1", "*", 
                    RowBox[{"#2", "/", "num"}]}], "]"}], ",", "lst2", ",", 
                  "lst4"}], "]"}]}], ";", "\n", "        ", 
               RowBox[{"lst1", "=", 
                RowBox[{"Map", "[", 
                 RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",", 
              "\n", "      ", 
              RowBox[{
               RowBox[{"lst4", "=", 
                RowBox[{"Map", "[", 
                 RowBox[{"LeadDegree", ",", "lst1"}], "]"}]}], ";", "\n", 
               "      ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Apply", "[", 
                   RowBox[{"SameQ", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{"LeadBase", ",", "lst1"}], "]"}]}], "]"}], " ", "&&",
                   " ", 
                  RowBox[{"MapAnd", "[", 
                   RowBox[{"RationalQ", ",", "lst4"}], "]"}]}], ",", "\n", 
                 "        ", 
                 RowBox[{
                  RowBox[{"num", "=", 
                   RowBox[{"Smallest", "[", "lst4", "]"}]}], ";", "\n", 
                  "        ", 
                  RowBox[{"base", "=", 
                   RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", 
                  "        ", 
                  RowBox[{"(", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                  ";", "\n", "        ", 
                  RowBox[{"lst2", "=", 
                   RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                  RowBox[{"lst1", "=", 
                   RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                  "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "lst1", "]"}], "==", "2"}], " ", "&&",
                     " ", 
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], " ", "&&",
                     " ", "\n", "         ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], "]"}], " ", "&&",
                     " ", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                    RowBox[{"FractionQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", 
                   "        ", 
                   RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"Min", "[", "lst4", "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"base", "=", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"(", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                    ";", "\n", "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                    "\n", "      ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "lst1", "]"}], "==", "2"}], " ", "&&",
                     " ", 
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], " ", "&&",
                     " ", "\n", "         ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "1"}], "]"}], " ", "&&",
                     " ", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                    RowBox[{"FractionQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"Min", "[", "lst4", "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"base", "=", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"(", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                    ";", "\n", "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                     "\n", "      ", 
                    RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"MostMainFactorPosition", "[", "lst3", "]"}]}], 
                    ";", "\n", "      ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"lst2", ",", 
                    RowBox[{
                    RowBox[{"lst3", "[", 
                    RowBox[{"[", "num", "]"}], "]"}], "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "num", "]"}], "]"}]}], ",", "num"}], "]"}]}],
                     ";", "      ", "\n", "      ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"lst1", ",", 
                    RowBox[{"RemainingFactors", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "num", "]"}], "]"}], "]"}], ",", "num"}], 
                    "]"}]}]}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}], 
          " ", ")"}], ";", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MapAnd", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"#", "===", "1"}], "]"}], ",", "lst1"}], "]"}], ",", 
           "\n", "      ", 
           RowBox[{"Return", "[", 
            RowBox[{"Prepend", "[", 
             RowBox[{"lst2", ",", "common"}], "]"}], "]"}]}], "]"}]}]}], 
       "]"}]}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.519592631348381*^9, 3.5195926351183863`*^9}, 
   3.5195929177587824`*^9, {3.519593241869236*^9, 3.519593272039278*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MostMainFactorPosition", "[", "lst_List", "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"factor", "=", "1"}], ",", 
      RowBox[{"num", "=", "1"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FactorOrder", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "factor"}], "]"}], ">", 
          "0"}], ",", 
         RowBox[{
          RowBox[{"factor", "=", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", 
          RowBox[{"num", "=", "i"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", "\n", 
     "  ", "num"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FactorOrder", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"u", "===", "1"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"v", "===", "1"}], ",", "\n", "      ", "0", ",", "\n", "    ", 
      RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"v", "===", "1"}], ",", "\n", "    ", "1", ",", "\n", "  ", 
      RowBox[{"Order", "[", 
       RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Smallest", "[", 
    RowBox[{"num1_", ",", "num2_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"num1", ">", "0"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"num2", ">", "0"}], ",", "\n", "      ", 
       RowBox[{"Min", "[", 
        RowBox[{"num1", ",", "num2"}], "]"}], ",", "\n", "    ", "0"}], "]"}],
      ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"num2", ">", "0"}], ",", "\n", "    ", "0", ",", "\n", "  ", 
       RowBox[{"Max", "[", 
        RowBox[{"num1", ",", "num2"}], "]"}]}], "]"}]}], "]"}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"Smallest", "[", "lst_List", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"num", "=", 
      RowBox[{"lst", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"num", "=", 
         RowBox[{"Smallest", "[", 
          RowBox[{"num", ",", "#"}], "]"}]}], "]"}], ",", 
       RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], ";", "\n", "  ", "num"}]}],
    "]"}]}]}], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["MonomialFactor", "Subsection",
 CellChangeTimes->{3.518825325395975*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MonomialFactor", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "v"}], "}"}], " ", "where", " ", 
     RowBox[{"x", "^", "n"}], "*", "v"}], "==", 
    RowBox[{"u", " ", "and", " ", "n", " ", "is", " ", "free", " ", "of", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialFactor", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "u"}], "}"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"IntegerQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"MonomialFactor", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "}"}], 
           ",", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "*", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "^", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "===", "x"}], " ", "&&", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n",
            "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "1"}], "}"}], ",", "\n", 
           "    ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst1", "=", 
              RowBox[{"MonomialFactor", "[", 
               RowBox[{
                RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
             RowBox[{"lst2", "=", 
              RowBox[{"MonomialFactor", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], "}"}],
            ",", "\n", "    ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"lst2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"lst2", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"lst", ",", "deg"}], "}"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"lst", "=", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"MonomialFactor", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], ";", "\n", 
              "    ", 
              RowBox[{"deg", "=", 
               RowBox[{"lst", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\n", "    ", 
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"deg", "=", 
                  RowBox[{"MinimumDegree", "[", 
                   RowBox[{"deg", ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
                RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], ";", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"ZeroQ", "[", "deg", "]"}], " ", "||", " ", 
                 RowBox[{
                  RowBox[{"RationalQ", "[", "deg", "]"}], " ", "&&", " ", 
                  RowBox[{"deg", "<", "0"}]}]}], ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "u"}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{"deg", ",", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"Plus", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"x", "^", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "deg"}], ")"}]}], 
                    "*", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "lst"}], 
                    "]"}]}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ",", "    ", 
           "\n", "  ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinimumDegree", "[", 
   RowBox[{"deg1_", ",", "deg2_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"RationalQ", "[", "deg1", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "deg2", "]"}], ",", "\n", "      ", 
      RowBox[{"Min", "[", 
       RowBox[{"deg1", ",", "deg2"}], "]"}], ",", "\n", "    ", "deg1"}], 
     "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "deg2", "]"}], ",", "\n", "    ", "deg2", ",",
       "\n", "  ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"deg", "=", 
          RowBox[{"Simplify", "[", 
           RowBox[{"deg1", "-", "deg2"}], "]"}]}], "}"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"RationalQ", "[", "deg", "]"}], ",", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"deg", ">", "0"}], ",", "\n", "      ", "deg2", ",", "\n",
             "    ", "deg1"}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OrderedQ", "[", 
             RowBox[{"{", 
              RowBox[{"deg1", ",", "deg2"}], "}"}], "]"}], ",", "\n", "    ", 
            "deg1", ",", "\n", "  ", "deg2"}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["ConstantFactor", "Subsection",
 CellChangeTimes->{3.5188253398959956`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantFactor", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "a", " ", "2"}], 
    "-", 
    RowBox[{
    "element", " ", "list", " ", "of", " ", "the", " ", "factors", " ", "of", 
     " ", 
     RowBox[{"u", "[", "x", "]"}], " ", "free", " ", "of", " ", "x", " ", 
     "and", " ", "the", " ", "\n", "\t", "factors", " ", "not", " ", "free", 
     " ", "of", " ", 
     RowBox[{
      RowBox[{"u", "[", "x", "]"}], ".", "  ", "Common"}], " ", "constant", 
     " ", "factors", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
     "sums", " ", "are", " ", "also", " ", 
     RowBox[{"collected", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compare", " ", "with", " ", "the", " ", "more", " ", "passive", " ", 
    "function", " ", 
    RowBox[{"SplitFreeFactors", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ConstantFactor", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"u", ",", "1"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst", "=", 
              RowBox[{"ConstantFactor", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", 
             "tmp"}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "^", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"tmp", "=", 
               RowBox[{"PositiveFactors", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"tmp", "===", "1"}], ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"tmp", "^", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NonpositiveFactors", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}]}], 
            "]"}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"lst", "=", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"ConstantFactor", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "}"}], ",", 
             "\n", "    ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Apply", "[", 
                RowBox[{"Times", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{"First", ",", "lst"}], "]"}]}], "]"}], ",", 
               RowBox[{"Apply", "[", 
                RowBox[{"Times", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst"}], 
                  "]"}]}], "]"}]}], "}"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"lst1", "=", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"ConstantFactor", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "}"}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"Apply", "[", 
                  RowBox[{"SameQ", ",", 
                   RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst1"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Apply", "[", 
                    RowBox[{"Plus", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{"First", ",", "lst1"}], "]"}]}], "]"}], ",", 
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", "\n",
                  "    ", 
                 RowBox[{"Module", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"CommonFactors", "[", 
                    RowBox[{"Map", "[", 
                    RowBox[{"First", ",", "lst1"}], "]"}], "]"}]}], "}"}], 
                   ",", "\n", "    ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"First", "[", "lst2", "]"}], ",", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Plus", ",", 
                    RowBox[{"Map2", "[", 
                    RowBox[{"Times", ",", 
                    RowBox[{"Rest", "[", "lst2", "]"}], ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst1"}], 
                    "]"}]}], "]"}]}], "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
              "]"}], ",", "\n", "  ", 
             RowBox[{"{", 
              RowBox[{"1", ",", "u"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PositiveFactors", "[", "u", "]"}], " ", "returns", " ", "the", 
    " ", "positive", " ", "factors", " ", "of", " ", "u"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ZeroQ", "[", "u", "]"}], ",", "\n", "    ", "1", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Abs", "[", "u", "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PositiveQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", 
         "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Map", "[", 
            RowBox[{"PositiveFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
           "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NonpositiveFactors", "[", "u", "]"}], " ", "returns", " ", "the",
     " ", "nonpositive", " ", "factors", " ", "of", " ", "u"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"NonpositiveFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ZeroQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Sign", "[", "u", "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PositiveQ", "[", "u", "]"}], ",", "\n", "    ", "1", ",", 
         "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Map", "[", 
            RowBox[{"NonpositiveFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
           "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Expansion Functions", "Section",
 CellChangeTimes->{{3.5195140860351057`*^9, 3.51951409565512*^9}, {
  3.528926707473311*^9, 3.528926711498118*^9}}],

Cell[CellGroupData[{

Cell["ExpandIntegrand", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.5255394497616315`*^9, 3.5255394533964376`*^9}, {3.525540006261409*^9, 
   3.5255400084454126`*^9}, 3.536715707013769*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "ExpandIntegrand", "]"}], ";"}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, {3.5488068878247967`*^9, 3.5488069465148783`*^9}, {
   3.548807009144966*^9, 3.5488071213651233`*^9}, {3.548807171435193*^9, 
   3.548807213805253*^9}, {3.5488073647454643`*^9, 3.548807394755506*^9}, 
   3.5488078006560745`*^9, {3.5529244809580564`*^9, 3.5529244834072604`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox[
     RowBox[{"b", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"m", "-", "1"}]]}], "d"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "d"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"m", "-", "1"}]]}], 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
    3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
    3.4957347552282763`*^9, 3.5239232039608574`*^9, {3.523923243678527*^9, 
    3.523923288731406*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}, 3.5184748983401833`*^9, 
   3.5239218927501535`*^9, 3.5239223317317247`*^9, {3.523933697950406*^9, 
   3.5239337702877336`*^9}, {3.523933813250209*^9, 3.5239338922955475`*^9}, {
   3.531345375550499*^9, 3.531345382149989*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"f_", "^", 
       RowBox[{"(", 
        RowBox[{"e_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"g_.", "+", 
        RowBox[{"h_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", "=", 
       RowBox[{
        RowBox[{"a", "*", "h"}], "-", 
        RowBox[{"b", "*", "g"}]}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"SimplifyTerm", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"tmp", "^", "m"}], "/", 
          RowBox[{"h", "^", "m"}]}], ",", "x"}], "]"}], "*", 
       RowBox[{
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"e", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"g", "+", 
          RowBox[{"h", "*", "x"}]}], ")"}]}]}], " ", "+", " ", "\n", "\t", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SimplifyTerm", "[", 
          RowBox[{
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"tmp", "^", 
              RowBox[{"(", 
               RowBox[{"k", "-", "1"}], ")"}]}], "/", 
             RowBox[{"h", "^", "k"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"e", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "k"}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "m"}], "}"}]}], "]"}]}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
        "h"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveIntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, {3.5488068878247967`*^9, 3.5488069465148783`*^9}, {
   3.548807009144966*^9, 3.5488071213651233`*^9}, {3.548807171435193*^9, 
   3.548807213805253*^9}, {3.5488073647454643`*^9, 3.548807394755506*^9}, 
   3.5488078006560745`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"e_", "+", 
        RowBox[{"f_.", "*", "x_"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"F_", "^", 
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PositiveIntegerQ", "[", 
       RowBox[{"m", ",", "p"}], "]"}], " ", "&&", " ", 
      RowBox[{"m", "\[LessEqual]", "p"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"OneQ", "[", "n", "]"}], " ", "||", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{
          RowBox[{"d", "*", "e"}], "-", 
          RowBox[{"c", "*", "f"}]}], "]"}]}], ")"}]}], ",", "\n", "    ", 
     RowBox[{"Distribute", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "^", 
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
        RowBox[{"ExpandLinearProduct", "[", 
         RowBox[{
          RowBox[{"x", "^", "m"}], ",", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", "x"}]}], ",", "p", ",", "x"}], "]"}]}], ",", 
       "Plus", ",", "Times"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PositiveIntegerQ", "[", "p", "]"}], ",", "\n", "    ", 
       RowBox[{"Distribute", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{"F", "^", 
           RowBox[{"(", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
          RowBox[{"Expand", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"e", "+", 
               RowBox[{"f", "*", "x"}]}], ")"}], "^", "p"}], ",", "x"}], 
           "]"}]}], ",", "Plus", ",", "Times"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Distribute", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"F", "^", 
           RowBox[{"(", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
          RowBox[{"ExpandIntegrand", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "^", "m"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"e", "+", 
                RowBox[{"f", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
           "]"}]}], ",", "Plus", ",", "Times"}], "]"}]}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "F", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
       "n", ",", "p"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, 3.548807796636069*^9, {3.5502644224293203`*^9, 
   3.5502644261205316`*^9}, {3.5507809436882935`*^9, 
   3.5507809807374125`*^9}, {3.5507810775679507`*^9, 3.550781077887969*^9}, 
   3.5507815988297653`*^9, {3.5510514580947857`*^9, 3.5510514630450687`*^9}, {
   3.5510518488841376`*^9, 3.55105190626742*^9}, {3.551051954418174*^9, 
   3.5510519848589153`*^9}, {3.551052022465066*^9, 3.551052028197394*^9}, {
   3.551052080161366*^9, 3.5510521592828913`*^9}, {3.5510523363400183`*^9, 
   3.551052350575833*^9}, {3.55176331579922*^9, 3.551763342919258*^9}, {
   3.552522700981924*^9, 3.552522710341937*^9}, {3.55287044627604*^9, 
   3.552870461782468*^9}, {3.552871264325877*^9, 3.552871309347556*^9}, {
   3.5528803151093855`*^9, 3.552880386253454*^9}, {3.552880419618363*^9, 
   3.5528804287028823`*^9}, {3.552884036678362*^9, 3.552884068237217*^9}, {
   3.552919212376375*^9, 3.55291922592515*^9}, {3.552921687907158*^9, 
   3.5529218716598806`*^9}, {3.552922058550606*^9, 3.552922069486225*^9}, {
   3.552922577088315*^9, 3.552922594653946*^9}, {3.552923744621163*^9, 
   3.5529238598585653`*^9}, {3.552923914879862*^9, 3.552924029040862*^9}, {
   3.5529244412715864`*^9, 3.552924452971607*^9}, {3.552925450222155*^9, 
   3.5529254727485943`*^9}, 3.5529307612846694`*^9, {3.552931547384848*^9, 
   3.5529316426230154`*^9}, {3.5529328831199903`*^9, 3.5529328833695903`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"e_", "+", 
        RowBox[{"f_.", "*", "x_"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"F_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}]}], ")"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"PositiveIntegerQ", "[", 
       RowBox[{"m", ",", "p"}], "]"}], " ", "&&", " ", 
      RowBox[{"m", "\[LessEqual]", "p"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"OneQ", "[", "n", "]"}], " ", "||", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{
          RowBox[{"d", "*", "e"}], "-", 
          RowBox[{"c", "*", "f"}]}], "]"}]}], ")"}]}], ",", "\n", "    ", 
     RowBox[{"Distribute", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}]}], "*", 
        RowBox[{"ExpandLinearProduct", "[", 
         RowBox[{
          RowBox[{"x", "^", "m"}], ",", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", "x"}]}], ",", "p", ",", "x"}], "]"}]}], ",", 
       "Plus", ",", "Times"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PositiveIntegerQ", "[", "p", "]"}], ",", "\n", "    ", 
       RowBox[{"Distribute", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{"F", "^", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}]}], 
          "*", 
          RowBox[{"Expand", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"e", "+", 
               RowBox[{"f", "*", "x"}]}], ")"}], "^", "p"}], ",", "x"}], 
           "]"}]}], ",", "Plus", ",", "Times"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Distribute", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"F", "^", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}]}], ")"}]}], 
          "*", 
          RowBox[{"ExpandIntegrand", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "^", "m"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"e", "+", 
                RowBox[{"f", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
           "]"}]}], ",", "Plus", ",", "Times"}], "]"}]}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "F", ",", "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", 
       "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, 3.548807796636069*^9, {3.5502644224293203`*^9, 
   3.5502644261205316`*^9}, {3.5507809436882935`*^9, 
   3.5507809807374125`*^9}, {3.5507810775679507`*^9, 3.550781077887969*^9}, 
   3.5507815988297653`*^9, {3.5510514580947857`*^9, 3.5510514630450687`*^9}, {
   3.5510518488841376`*^9, 3.55105190626742*^9}, {3.551051954418174*^9, 
   3.5510519848589153`*^9}, {3.551052022465066*^9, 3.551052028197394*^9}, {
   3.551052080161366*^9, 3.5510521592828913`*^9}, {3.5510523363400183`*^9, 
   3.551052350575833*^9}, {3.55176331579922*^9, 3.551763342919258*^9}, {
   3.552522700981924*^9, 3.552522710341937*^9}, {3.55287044627604*^9, 
   3.552870461782468*^9}, {3.552871264325877*^9, 3.552871309347556*^9}, {
   3.5528803151093855`*^9, 3.552880386253454*^9}, {3.552880419618363*^9, 
   3.5528804287028823`*^9}, {3.552884036678362*^9, 3.552884068237217*^9}, {
   3.552919212376375*^9, 3.55291922592515*^9}, {3.552921687907158*^9, 
   3.5529218716598806`*^9}, {3.552922058550606*^9, 3.552922069486225*^9}, {
   3.552922577088315*^9, 3.552922594653946*^9}, {3.552923744621163*^9, 
   3.5529238598585653`*^9}, {3.552923914879862*^9, 3.552924029040862*^9}, 
   3.552924429368766*^9, 3.552925501437045*^9, 3.552930769708684*^9, {
   3.552931654385436*^9, 3.5529316893606973`*^9}, 3.5529317903240747`*^9, 
   3.552932906878832*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"e_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"ExpandIntegrand", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], ",", "x"}], 
        "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Distribute", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"e", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
         "v"}], ",", "Plus", ",", "Times"}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"SumQ", "[", "v", "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, 3.548807796636069*^9, {3.5502644224293203`*^9, 
   3.5502644261205316`*^9}, {3.5507809436882935`*^9, 
   3.5507809807374125`*^9}, {3.5507810775679507`*^9, 3.550781077887969*^9}, 
   3.5507815988297653`*^9, {3.5510514580947857`*^9, 3.5510514630450687`*^9}, {
   3.5510518488841376`*^9, 3.55105190626742*^9}, {3.551051954418174*^9, 
   3.5510519848589153`*^9}, {3.551052022465066*^9, 3.551052028197394*^9}, {
   3.551052080161366*^9, 3.5510521592828913`*^9}, {3.5510523363400183`*^9, 
   3.551052350575833*^9}, {3.55176331579922*^9, 3.551763342919258*^9}, {
   3.552522700981924*^9, 3.552522710341937*^9}, {3.55287044627604*^9, 
   3.552870461782468*^9}, {3.552871264325877*^9, 3.552871309347556*^9}, {
   3.5528803151093855`*^9, 3.552880386253454*^9}, {3.552880419618363*^9, 
   3.5528804287028823`*^9}, {3.552884036678362*^9, 3.552884068237217*^9}, {
   3.552919212376375*^9, 3.55291922592515*^9}, {3.5529221146171045`*^9, 
   3.5529221334775376`*^9}, {3.5532321758598194`*^9, 3.5532322043454695`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"Log", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d_.", "+", 
          RowBox[{"e_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_."}]}], "]"}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Distribute", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], "]"}], "*", 
      RowBox[{"ExpandIntegrand", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], ",", "x"}], 
       "]"}]}], ",", "Plus", ",", "Times"}], "]"}], " ", "/;", " ", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n", ",", 
        "p"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, 3.548807796636069*^9, {3.5502644224293203`*^9, 
   3.5502644261205316`*^9}, {3.5507809436882935`*^9, 
   3.5507809807374125`*^9}, {3.5507810775679507`*^9, 3.550781077887969*^9}, 
   3.5507815988297653`*^9, {3.5510514580947857`*^9, 3.5510514630450687`*^9}, {
   3.5510518488841376`*^9, 3.55105190626742*^9}, {3.551051954418174*^9, 
   3.5510519848589153`*^9}, {3.551052022465066*^9, 3.551052028197394*^9}, {
   3.551052080161366*^9, 3.5510521592828913`*^9}, {3.5510523363400183`*^9, 
   3.551052350575833*^9}, {3.55176331579922*^9, 3.551763342919258*^9}, {
   3.552522700981924*^9, 3.552522710341937*^9}, {3.55287044627604*^9, 
   3.552870461782468*^9}, {3.55287129434033*^9, 3.5528713184579725`*^9}, {
   3.5528804570425034`*^9, 3.552880489710372*^9}, {3.552880522846267*^9, 
   3.552880539718232*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"e_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}]}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Distribute", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"e", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}], "*", 
      RowBox[{"ExpandLinearProduct", "[", 
       RowBox[{"u", ",", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ",", "0", ",", "x"}], "]"}]}], ",", 
     "Plus", ",", "Times"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d", ",", "e", ",", "f", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.5488051271623316`*^9, {3.5488051631223817`*^9, 
   3.5488052237024665`*^9}, {3.548805520292882*^9, 3.5488055222628846`*^9}, {
   3.5488056099430075`*^9, 3.5488056272330313`*^9}, 3.5488060420536127`*^9, 
   3.548806174893798*^9, 3.548807796636069*^9, {3.550264156813128*^9, 
   3.550264157758182*^9}, {3.550264431613846*^9, 3.5502644764924126`*^9}, {
   3.5507810052598147`*^9, 3.550781005781845*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"v_", "^", "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Distribute", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"NormalizeIntegrand", "[", 
       RowBox[{
        RowBox[{"v", "^", "m"}], ",", "x"}], "]"}], "*", 
      RowBox[{"ExpandIntegrand", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "Plus", ",", "Times"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, 3.548805055352231*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]}]], "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "-", 
     RowBox[{"b", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}]]}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "d"}]}], ")"}], " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
    3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
    3.4957347552282763`*^9, 3.5239232039608574`*^9, {3.523923243678527*^9, 
    3.523923288731406*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}, 3.5184748983401833`*^9, 
   3.5239218927501535`*^9, 3.5239223317317247`*^9, {3.523933697950406*^9, 
   3.5239337702877336`*^9}, {3.523933813250209*^9, 3.5239338922955475`*^9}, {
   3.531345375550499*^9, 3.531345382149989*^9}, {3.538709220912434*^9, 
   3.538709220912434*^9}, {3.538709256043696*^9, 3.538709256043696*^9}, {
   3.5387093892055297`*^9, 3.5387093892055297`*^9}, {3.538709560665431*^9, 
   3.538709560665431*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c_", "+", 
          RowBox[{"d_.", "*", 
           RowBox[{"x_", "^", "j_"}]}]}], "]"}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"ExpandIntegrand", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "-", 
         RowBox[{"b", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"b", "^", "2"}]}], "*", "c"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "-", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "*", "d"}]}], ")"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, {3.5360811408093925`*^9, 3.536081200351798*^9}, {
   3.536081289150877*^9, 3.53608129846441*^9}, {3.5360814042154584`*^9, 
   3.536081409118739*^9}, {3.536685999708608*^9, 3.536686005701951*^9}, {
   3.536686079677182*^9, 3.5366860894917436`*^9}, {3.5366861874823484`*^9, 
   3.536686236088128*^9}, {3.5366864155943956`*^9, 3.5366864347484913`*^9}, {
   3.53668649469692*^9, 3.536686497352072*^9}, 3.536687971759403*^9, {
   3.536690955882085*^9, 3.5366909765842695`*^9}, {3.5372056898687572`*^9, 
   3.537205700798773*^9}, 3.537287582794663*^9, {3.537287631661458*^9, 
   3.537287636822753*^9}, {3.5387089784724083`*^9, 3.538708987161624*^9}, {
   3.538709026629693*^9, 3.5387090639293585`*^9}, 3.538709273219326*^9, {
   3.5387093941663384`*^9, 3.538709435678011*^9}, {3.5387094708560734`*^9, 
   3.5387095231473646`*^9}, {3.5387095872634773`*^9, 3.538709597637496*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox[
     RowBox[{"b", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"m", "-", "1"}]]}], "d"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "d"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"m", "-", "1"}]]}], 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
    3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
    3.4957347552282763`*^9, 3.5239232039608574`*^9, {3.523923243678527*^9, 
    3.523923288731406*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}, 3.5184748983401833`*^9, 
   3.5239218927501535`*^9, 3.5239223317317247`*^9, {3.523933697950406*^9, 
   3.5239337702877336`*^9}, {3.523933813250209*^9, 3.5239338922955475`*^9}, {
   3.531345375550499*^9, 3.531345382149989*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", "\n", "    ", 
     RowBox[{"ExpandIntegrandAux", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}], ",", "\n", 
     "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{
          RowBox[{"a", "*", "d"}], "-", 
          RowBox[{"b", "*", "c"}]}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"SimplifyTerm", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"tmp", "^", "m"}], "/", 
            RowBox[{"d", "^", "m"}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}], " ", "+", " ", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"SimplifyTerm", "[", 
            RowBox[{
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"tmp", "^", 
                RowBox[{"(", 
                 RowBox[{"k", "-", "1"}], ")"}]}], "/", 
               RowBox[{"d", "^", "k"}]}]}], ",", "x"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "k"}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", "m"}], "}"}]}], "]"}]}]}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveIntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5316009056184497`*^9, 
   3.531601093188162*^9, {3.5318463289566393`*^9, 3.531846348191473*^9}, {
   3.5320178411267705`*^9, 3.532017886006833*^9}, {3.53201812643717*^9, 
   3.532018136427184*^9}, 3.5366897585686026`*^9, {3.537139170744377*^9, 
   3.5371391952444115`*^9}, {3.537139231454462*^9, 3.537139239254473*^9}, {
   3.537140875193266*^9, 3.537140907993312*^9}, {3.548807143345154*^9, 
   3.548807144255155*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", "x"}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox[
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "m"]}], "d"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", " ", "d"}], "-", 
        RowBox[{"B", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "m"]}], 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
    3.495391753851657*^9, {3.495733875467045*^9, 3.4957338981670766`*^9}, 
    3.4957347552282763`*^9, 3.5239232039608574`*^9, {3.523923243678527*^9, 
    3.523923288731406*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}, 3.5184748983401833`*^9, 
   3.5239218927501535`*^9, 3.5239223317317247`*^9, {3.523933697950406*^9, 
   3.5239337702877336`*^9}, {3.523933813250209*^9, 3.5239338922955475`*^9}, {
   3.531345375550499*^9, 3.531345382149989*^9}, 3.531599681297963*^9, {
   3.5316001070902224`*^9, 3.5316001151818576`*^9}, 3.5316001785930386`*^9, 
   3.53160021737881*^9, 3.5316002477925425`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", "x_"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "]"}], 
     ",", "\n", "    ", 
     RowBox[{"ExpandIntegrandAux", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"A", "+", 
           RowBox[{"B", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", "\n",
      "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp1", ",", "tmp2"}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"tmp1", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"A", "*", "d"}], "-", 
            RowBox[{"B", "*", "c"}]}], ")"}], "/", "d"}]}], ";", "\n", "  ", 
        RowBox[{"tmp2", "=", 
         RowBox[{"ExpandIntegrand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "/", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], ";", 
        "\n", "  ", 
        RowBox[{"tmp2", "=", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "tmp2", "]"}], ",", " ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"SimplifyTerm", "[", 
               RowBox[{
                RowBox[{"tmp1", "*", "#"}], ",", "x"}], "]"}], "]"}], ",", 
             "tmp2"}], "]"}], ",", " ", 
           RowBox[{"SimplifyTerm", "[", 
            RowBox[{
             RowBox[{"tmp1", "*", "tmp2"}], ",", "x"}], "]"}]}], "]"}]}], ";",
         "\n", "  ", 
        RowBox[{
         RowBox[{
          RowBox[{"SimplifyTerm", "[", 
           RowBox[{
            RowBox[{"B", "/", "d"}], ",", "x"}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], " ", "+", " ", 
         "tmp2"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveIntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 
   3.5313432311670275`*^9}, {3.5313432875280704`*^9, 3.531343316519758*^9}, {
   3.531343552348864*^9, 3.531343570645173*^9}, {3.531343609460987*^9, 
   3.5313437618000402`*^9}, {3.531343793275299*^9, 3.5313438465719357`*^9}, {
   3.5313439201076756`*^9, 3.531343995786496*^9}, {3.5313444382126737`*^9, 
   3.531344439554603*^9}, {3.531344509114626*^9, 3.5313445610392895`*^9}, {
   3.5313447218204813`*^9, 3.531344804168893*^9}, {3.5313448932469807`*^9, 
   3.531344895500221*^9}, {3.5313449283374386`*^9, 3.5313449329640913`*^9}, {
   3.531345058965272*^9, 3.5313451115008144`*^9}, {3.5313451641164722`*^9, 
   3.531345252413437*^9}, {3.5313454044821005`*^9, 3.53134544856549*^9}, 
   3.5313455210697455`*^9, 3.5313457251832466`*^9, 3.531346321971386*^9, 
   3.5313464970230975`*^9, 3.5313468371521792`*^9, 3.5315996265191956`*^9, {
   3.5315997504473953`*^9, 3.531599776675109*^9}, {3.5315998113449616`*^9, 
   3.531599852964808*^9}, {3.531599954510824*^9, 3.531600030399947*^9}, {
   3.5316000608136797`*^9, 3.5316000934205666`*^9}, {3.53160025309016*^9, 
   3.531600383557763*^9}, 3.5316004515855827`*^9, 3.5316008850889297`*^9, {
   3.531846441947638*^9, 3.5318464644896774`*^9}, {3.5320178648368034`*^9, 
   3.5320178681768084`*^9}, {3.532017908416865*^9, 3.532017922986885*^9}, {
   3.5320181464371977`*^9, 3.532018160207217*^9}, {3.536689760345704*^9, 
   3.536689761057745*^9}, {3.537139245554482*^9, 3.5371392615545044`*^9}, {
   3.5371409254833364`*^9, 3.5371409458333645`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", 
     "x"}], ",", " ", 
    RowBox[{
     RowBox[{"ExpandIntegrand", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], ",", "x"}], "]"}], 
     " ", "expand", " ", "u", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], " ", "into", " ", "a", 
     " ", "sum", " ", "of", " ", "terms", " ", "of", " ", "the", " ", "form", 
     " ", "A", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "."}]}]}], " ", "*)"}],
   "\n", 
  RowBox[{
   RowBox[{"ExpandIntegrand", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"tmp1", ",", "tmp2"}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"tmp1", "=", 
        RowBox[{"ExpandLinearProduct", "[", 
         RowBox[{"u", ",", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ",", "m", ",", "x"}], "]"}]}], ";", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], ",", "\n", "    ", 
         "tmp1", ",", "\n", "  ", 
         RowBox[{
          RowBox[{"tmp2", "=", 
           RowBox[{"ExpandIntegrandAux", "[", 
            RowBox[{
             RowBox[{"u", "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], ",", "x"}], 
            "]"}]}], ";", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SumQ", "[", "tmp2", "]"}], " ", "&&", " ", 
             RowBox[{
              RowBox[{"LeafCount", "[", "tmp2", "]"}], "\[LessEqual]", 
              RowBox[{
               RowBox[{"LeafCount", "[", "tmp1", "]"}], "+", "2"}]}]}], ",", 
            "\n", "    ", "tmp2", ",", "\n", "  ", "tmp1"}], "]"}]}]}], 
        "]"}]}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "  ", 
     RowBox[{"Not", "[", 
      RowBox[{
       RowBox[{"PositiveIntegerQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"v_.", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c_", "+", 
              RowBox[{"d_.", "*", "x"}]}], ")"}], "^", "n_"}]}], " ", "/;", 
          " ", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
           " ", 
           RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
           RowBox[{"n", ">", "m"}]}]}]}], "]"}]}], "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530822888945073*^9, 3.530822907485099*^9}, {3.5308232500655785`*^9, 
   3.5308233072256584`*^9}, {3.530823430175831*^9, 3.5308234873259106`*^9}, {
   3.5308241871768904`*^9, 3.5308242060569167`*^9}, {3.5308242887170324`*^9, 
   3.5308243338070955`*^9}, 3.530825046888094*^9, 3.5308254206286173`*^9, 
   3.5308278057019567`*^9, 3.5308278903920746`*^9, {3.5308280545723047`*^9, 
   3.530828068032324*^9}, 3.5308283037326536`*^9, 3.530829852184821*^9, {
   3.530831476657099*^9, 3.530831483027108*^9}, 3.5308371655250635`*^9, {
   3.5308452823239875`*^9, 3.530845424724187*^9}, {3.5308454565042315`*^9, 
   3.530845480314265*^9}, {3.5308455238143253`*^9, 3.530845730844616*^9}, {
   3.5308457903146987`*^9, 3.530845792194701*^9}, {3.5308458513347845`*^9, 
   3.5308459192048793`*^9}, {3.530845953894928*^9, 3.530845957504933*^9}, {
   3.5308460002449927`*^9, 3.530846066265085*^9}, {3.530846118185158*^9, 
   3.5308461192551594`*^9}, {3.530846217605297*^9, 3.530846286305393*^9}, {
   3.53084654826576*^9, 3.5308465716257925`*^9}, {3.5308471956366663`*^9, 
   3.530847236436723*^9}, {3.5309037546434793`*^9, 3.530903811323559*^9}, {
   3.530903849243612*^9, 3.5309038811736565`*^9}, {3.5309039145637035`*^9, 
   3.530903923683716*^9}, {3.5309039989638214`*^9, 3.530904021303853*^9}, {
   3.5309040850539417`*^9, 3.5309040864239435`*^9}, {3.530906057736704*^9, 
   3.5309060633667116`*^9}, {3.530920529257221*^9, 3.5309205326872263`*^9}, {
   3.5309214785585504`*^9, 3.5309214850685596`*^9}, {3.53092917718561*^9, 
   3.530929186705623*^9}, {3.530930608717614*^9, 3.53093076281783*^9}, 
   3.5309307981978793`*^9, {3.5309308351679316`*^9, 3.530930835737932*^9}, 
   3.531087465980461*^9, {3.5311561637612815`*^9, 3.531156304002939*^9}, {
   3.5311615859580173`*^9, 3.5311617739483347`*^9}, 3.531162035013728*^9, {
   3.531162119054573*^9, 3.5311621763769984`*^9}, {3.531242226291*^9, 
   3.5312422278632607`*^9}, {3.5313432305962067`*^9, 3.5313432311670275`*^9}, 
   3.5313473257046833`*^9, {3.5313474124193726`*^9, 3.5313474822097263`*^9}, {
   3.5313475123530703`*^9, 3.5313475229382915`*^9}, {3.531347607950533*^9, 
   3.5313476118160915`*^9}, {3.5313477286841393`*^9, 3.531347744987582*^9}, {
   3.5313478159396067`*^9, 3.5313478246621485`*^9}, {3.531348378398382*^9, 
   3.5313483797803698`*^9}, {3.5313487046975775`*^9, 
   3.5313487057891474`*^9}, {3.5313488365571823`*^9, 3.53134883793917*^9}, {
   3.5313489028525105`*^9, 3.5313489065578384`*^9}, {3.531348956649867*^9, 
   3.531348958091941*^9}, {3.531350076820594*^9, 3.531350100684909*^9}, {
   3.5313533924782753`*^9, 3.5313534001493053`*^9}, {3.5313535535999565`*^9, 
   3.531353581620248*^9}, {3.5313541132747297`*^9, 3.5313541153977823`*^9}, 
   3.531354153362373*^9, {3.531354206889341*^9, 3.531354226777939*^9}, {
   3.5313542699800606`*^9, 3.531354352999437*^9}, {3.5313543858566833`*^9, 
   3.5313544642393923`*^9}, {3.5315380445478864`*^9, 3.5315380538913217`*^9}, 
   {3.5315386425377536`*^9, 3.5315386496079197`*^9}, {3.531539365337088*^9, 
   3.531539413125805*^9}, {3.5315394771278353`*^9, 3.5315395000708256`*^9}, {
   3.5315395535777645`*^9, 3.5315395806567025`*^9}, {3.5315396647776623`*^9, 
   3.5315397745855584`*^9}, {3.531805288566202*^9, 3.5318053242912455`*^9}, {
   3.531840614656771*^9, 3.531840742597089*^9}, {3.5318407817373276`*^9, 
   3.5318408307451305`*^9}, {3.5318411957873535`*^9, 
   3.5318411983104973`*^9}, {3.531841229310397*^9, 3.531841239523981*^9}, {
   3.5318412788322296`*^9, 3.5318412837275095`*^9}, {3.531841316452381*^9, 
   3.5318413211576505`*^9}, {3.531841728589759*^9, 3.5318417474345922`*^9}, {
   3.5318421382932787`*^9, 3.5318421835957584`*^9}, {3.5318424645366516`*^9, 
   3.531842465722254*^9}, {3.5318431702786913`*^9, 3.531843212289565*^9}, {
   3.5318455183792157`*^9, 3.5318455555852814`*^9}, {3.531845660682666*^9, 
   3.5318456759706926`*^9}, {3.531845711055154*^9, 3.5318458579138117`*^9}, 
   3.5318705852124443`*^9, 3.532017868826809*^9, {3.532017924816888*^9, 
   3.5320179260968895`*^9}, 3.5320179903569794`*^9, {3.532018233137319*^9, 
   3.532018241717331*^9}, {3.536689431288883*^9, 3.5366894374612365`*^9}, {
   3.536689761824789*^9, 3.5366897625068283`*^9}, {3.536690089438527*^9, 
   3.5366901059234705`*^9}, {3.5366903158064747`*^9, 3.536690329107236*^9}, {
   3.5366907222687235`*^9, 3.5366907997671556`*^9}, {3.536690836154237*^9, 
   3.536690906649269*^9}, {3.5488046098916073`*^9, 3.5488046415716515`*^9}, {
   3.54880519758243*^9, 3.5488051979824305`*^9}, {3.550264405601358*^9, 
   3.5502644091985636`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "polynomial", " ", "in", " ", 
     "x"}], ",", " ", 
    RowBox[{
     RowBox[{"MergeLinearProduct", "[", 
      RowBox[{"u", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ",", "m", ",", "x"}], "]"}], " ", "expand",
      " ", "u", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], " ", "into", " ", "a", 
     " ", "sum", " ", "of", " ", "terms", " ", "of", " ", "the", " ", "form", 
     " ", "A", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "."}]}]}], " ", "*)"}],
   "\n", 
  RowBox[{
   RowBox[{"ExpandLinearProduct", "[", 
    RowBox[{"u_", ",", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], ",", "m_", ",", "x_Symbol"}], "]"}], " ", 
   ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"CoefficientList", "[", 
         RowBox[{
          RowBox[{"ReplaceAll", "[", 
           RowBox[{"u", ",", 
            RowBox[{"x", "\[Rule]", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "a"}], ")"}], "/", "b"}]}]}], "]"}], ",", 
          "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"lst", "=", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"SimplifyTerm", "[", 
            RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "lst"}], "]"}]}], ";",
        "\n", "  ", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", "k", "-", "1"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", 
           RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}]}]}], "]"}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903691915283`*^9}, {3.5367096263569756`*^9, 3.536709664888179*^9}, {
   3.536709735505218*^9, 3.536709753517248*^9}, {3.5367097943095818`*^9, 
   3.5367097978887863`*^9}, 3.536709859614317*^9, {3.536709904587889*^9, 
   3.536710169038015*^9}, {3.5367102560099893`*^9, 3.536710256362009*^9}, {
   3.536710294209174*^9, 3.5367102943891845`*^9}, {3.5367103622600665`*^9, 
   3.536710416383162*^9}, {3.536710502629095*^9, 3.5367105206111236`*^9}, {
   3.536710803158284*^9, 3.5367108104146996`*^9}, {3.5367159478435435`*^9, 
   3.5367159700698147`*^9}, 3.5367165071955366`*^9, {3.5367181349766407`*^9, 
   3.536718137788801*^9}, {3.536718816357613*^9, 3.536718816755636*^9}, {
   3.539802849702794*^9, 3.5398028542428007`*^9}, {3.539804502085107*^9, 
   3.5398045059151125`*^9}, {3.539805422466396*^9, 3.539805442256424*^9}, {
   3.5398054758264704`*^9, 3.5398055123365216`*^9}, {3.5398055657465963`*^9, 
   3.5398055707666035`*^9}, {3.539805618976671*^9, 3.5398056928767743`*^9}, {
   3.539805972587166*^9, 3.5398060550472813`*^9}, {3.5398060889973288`*^9, 
   3.539806091177332*^9}, {3.539806157487425*^9, 3.5398061688474407`*^9}, {
   3.539806213157503*^9, 3.5398062573375645`*^9}, {3.539806912428482*^9, 
   3.539806921958495*^9}, {3.5406603442663436`*^9, 3.540660346146346*^9}, {
   3.548804217711058*^9, 3.5488042525611067`*^9}, 3.5488043045011797`*^9, {
   3.548804367981269*^9, 3.5488044544913893`*^9}, {3.5488045607215385`*^9, 
   3.5488045921215825`*^9}, 3.5488088308775167`*^9, {3.5502643045395775`*^9, 
   3.550264351365256*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "/", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"CoefficientList", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"lst", "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"x", "^", 
         RowBox[{"Exponent", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "/", "v"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Exponent", "[", 
            RowBox[{"u", ",", "x"}], "]"}]}], "}"}]}], "]"}], "/", "v"}]}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"BinomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"Exponent", "[", 
       RowBox[{"v", ",", "x"}], "]"}], "-", "1"}], "\[GreaterEqual]", 
     "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903691915283`*^9}, {3.5367096263569756`*^9, 3.536709664888179*^9}, {
   3.536709735505218*^9, 3.536709753517248*^9}, {3.5367097943095818`*^9, 
   3.5367097978887863`*^9}, 3.536709859614317*^9, {3.536709904587889*^9, 
   3.536710169038015*^9}, {3.5367102560099893`*^9, 3.536710256362009*^9}, {
   3.536710294209174*^9, 3.5367102943891845`*^9}, {3.5367103622600665`*^9, 
   3.536710416383162*^9}, {3.536710502629095*^9, 3.5367105206111236`*^9}, {
   3.536710803158284*^9, 3.5367108104146996`*^9}, {3.5367159478435435`*^9, 
   3.5367159700698147`*^9}, 3.5367165071955366`*^9, {3.5367181349766407`*^9, 
   3.536718137788801*^9}, {3.536718816357613*^9, 3.536718816755636*^9}, {
   3.539802849702794*^9, 3.5398028542428007`*^9}, {3.539804502085107*^9, 
   3.5398045059151125`*^9}, {3.539805422466396*^9, 3.539805442256424*^9}, {
   3.5398054758264704`*^9, 3.5398055123365216`*^9}, {3.5398055657465963`*^9, 
   3.5398055707666035`*^9}, {3.539805618976671*^9, 3.5398056928767743`*^9}, {
   3.539805972587166*^9, 3.5398060550472813`*^9}, {3.5398060889973288`*^9, 
   3.539806091177332*^9}, {3.539806157487425*^9, 3.5398061688474407`*^9}, {
   3.539806213157503*^9, 3.5398062573375645`*^9}, {3.539806912428482*^9, 
   3.539806921958495*^9}, {3.5406603442663436`*^9, 3.540660346146346*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{
    RowBox[{"u_", "/", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Simp", "[", 
     RowBox[{
      RowBox[{"PolynomialQuotient", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], ",", "x"}], "]"}], " ", "+", 
    " ", 
    RowBox[{"SimplifyIntegrand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Together", "[", 
        RowBox[{"PolynomialRemainder", "[", 
         RowBox[{"u", ",", "v", ",", "x"}], "]"}], "]"}], "/", "v"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "\[GreaterEqual]", 
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903691915283`*^9}, {3.5367096263569756`*^9, 3.536709664888179*^9}, {
   3.536709735505218*^9, 3.536709753517248*^9}, {3.5367097943095818`*^9, 
   3.5367097978887863`*^9}, 3.536709859614317*^9, {3.536709904587889*^9, 
   3.536710169038015*^9}, {3.5367102560099893`*^9, 3.536710256362009*^9}, {
   3.536710294209174*^9, 3.5367102943891845`*^9}, {3.5367103622600665`*^9, 
   3.536710416383162*^9}, {3.536710502629095*^9, 3.5367105206111236`*^9}, {
   3.536710803158284*^9, 3.5367108104146996`*^9}, {3.5367159478435435`*^9, 
   3.5367159700698147`*^9}, 3.5367165071955366`*^9, {3.5367181349766407`*^9, 
   3.536718137788801*^9}, {3.536718816357613*^9, 3.536718816755636*^9}, {
   3.539713407820671*^9, 3.539713467286072*^9}, {3.539713603716875*^9, 
   3.5397136100372367`*^9}, {3.5397137155722733`*^9, 3.539713724691795*^9}, {
   3.5398002570491643`*^9, 3.5398002665191774`*^9}, {3.5398021306317873`*^9, 
   3.53980213288179*^9}, {3.5398150502180696`*^9, 3.5398150529580736`*^9}, {
   3.5496542787902803`*^9, 3.5496542842814903`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrand", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"ExpandIntegrandAux", "[", 
   RowBox[{"u", ",", "x"}], "]"}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903691915283`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Note", ":", " ", 
     RowBox[{
     "These", " ", "rule", " ", "is", " ", "necessary", " ", "because", " ", 
      "if", " ", "a", " ", "or", " ", "b", " ", "contains", " ", "fractional",
       " ", "powers"}]}], ",", " ", 
    RowBox[{
    "Apart", " ", "rationalizes", " ", "\n", "\t", "denominator", " ", 
     "resulting", " ", "in", " ", "hard", " ", "to", " ", "integrate", " ", 
     "terms", " ", "in", " ", "partial", " ", "fraction", " ", 
     RowBox[{"expansion", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpandIntegrandAux", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"d_.", "*", 
           RowBox[{"c_", "^", "m_"}]}], "+", 
          RowBox[{"b_.", "*", "v_"}]}], ")"}], "^", "p_"}]}], ",", 
      "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{
         RowBox[{"ExpandIntegrandAux", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"d", "*", "tmp"}], "+", 
               RowBox[{"b", "*", "v"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"tmp", "->", 
           RowBox[{"c", "^", "m"}]}], "}"}]}], "]"}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
       "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", "<", "0"}], " ", "&&", " ", 
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"ExpandIntegrandAux", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"c_", "^", "m_"}], "*", "v_"}]}], ")"}], "^", "p_"}]}], 
      ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
       RowBox[{"ReplaceAll", "[", 
        RowBox[{
         RowBox[{"ExpandIntegrandAux", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "tmp", "*", "v"}]}], ")"}], "^", "p"}]}], 
           ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"tmp", "->", 
           RowBox[{"c", "^", "m"}]}], "}"}]}], "]"}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
       " ", 
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", "<", "0"}], " ", "&&", " ", 
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903364396553`*^9}, {3.5371323646941557`*^9, 
   3.5371323736841683`*^9}, {3.537133479415716*^9, 3.537133484665724*^9}, {
   3.5373002116219907`*^9, 3.537300234357291*^9}, 3.53730032962374*^9, {
   3.537300575182785*^9, 3.5373007828086605`*^9}, {3.537300916104285*^9, 
   3.5373009187804375`*^9}, {3.5377263670873985`*^9, 3.537726393513845*^9}, {
   3.537726449252743*^9, 3.537726597905404*^9}, {3.5377266483246927`*^9, 
   3.5377267019731865`*^9}, 3.549409612676842*^9, {3.551762454058013*^9, 
   3.5517624704580355`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandIntegrandAux", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "v", "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"AlgebraicFunctionQ", "[", 
          RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{"Not", "[", 
          RowBox[{"RationalFunctionQ", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "]"}]}], ",", " ", 
        RowBox[{"ExpandAlgebraic", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", " ", "0"}], "]"}]}], ";", "\n", 
     "  ", 
     RowBox[{"(", " ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "[", 
         RowBox[{"SumQ", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
        RowBox[{
         RowBox[{"v", "=", 
          RowBox[{"Apart", "[", 
           RowBox[{"u", ",", "x"}], "]"}]}], ";", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Not", "[", 
            RowBox[{"SumQ", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
           RowBox[{
            RowBox[{"v", "=", 
             RowBox[{"Apart", "[", "u", "]"}]}], ";", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"Not", "[", 
               RowBox[{"SumQ", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"v", "=", 
                RowBox[{"Expand", "[", 
                 RowBox[{"u", ",", "x"}], "]"}]}], ";", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"Not", "[", 
                  RowBox[{"SumQ", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
                 RowBox[{"v", "=", 
                  RowBox[{"Expand", "[", "u", "]"}]}]}], "]"}]}]}], "]"}]}]}],
           "]"}]}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"v", "=", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"SimplifyTerm", "[", 
             RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "v"}], "]"}]}], ";", 
        "\n", "    ", 
        RowBox[{"Apply", "[", 
         RowBox[{"Plus", ",", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "*", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
            RowBox[{"UnifyTerms", "[", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"SplitFreeFactors", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
               RowBox[{"Apply", "[", 
                RowBox[{"List", ",", "v"}], "]"}]}], "]"}], "]"}]}], "]"}]}], 
         "]"}]}], ",", "\n", "  ", 
       RowBox[{"SimplifyTerm", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.53201786952681*^9, 3.532017870786812*^9}, {
   3.5320179290168934`*^9, 3.5320179410569105`*^9}, {3.5320179911769805`*^9, 
   3.532017992376982*^9}, {3.5320182498273425`*^9, 3.5320182540173483`*^9}, 
   3.536687153041575*^9, {3.5366871987691903`*^9, 3.5366872047875347`*^9}, 
   3.5366872794058027`*^9, {3.5366873208391724`*^9, 3.5366873256714487`*^9}, {
   3.536687406570076*^9, 3.5366874309864726`*^9}, {3.5366874883707547`*^9, 
   3.5366876919694*^9}, {3.5366877252483034`*^9, 3.536687738284049*^9}, {
   3.5366895551589684`*^9, 3.536689567191656*^9}, {3.536690335714614*^9, 
   3.5366903364396553`*^9}, {3.5371323646941557`*^9, 
   3.5371323736841683`*^9}, {3.537133479415716*^9, 3.537133484665724*^9}, {
   3.5373002116219907`*^9, 3.537300234357291*^9}, 3.53730032962374*^9, {
   3.537300575182785*^9, 3.5373007828086605`*^9}, {3.537300916104285*^9, 
   3.5373009187804375`*^9}, {3.5377263670873985`*^9, 3.537726393513845*^9}, {
   3.537726449252743*^9, 3.537726597905404*^9}, {3.5377266483246927`*^9, 
   3.5377267019731865`*^9}, 3.549409612676842*^9, 3.5517624461780014`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SimplifyTerm", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"NormalizeIntegrand", "[", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{"Simplify", "[", "u", "]"}], "]"}], ",", "x"}], "]"}]}]], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.5320160818943076`*^9, 3.532016187834456*^9}, {
   3.5320162195045004`*^9, 3.53201626193456*^9}, {3.5320164496648226`*^9, 
   3.532016505644901*^9}, {3.532016549444962*^9, 3.5320166082750444`*^9}, {
   3.532017353626088*^9, 3.532017370736112*^9}, {3.532017431206197*^9, 
   3.5320175143063126`*^9}, {3.532017573186395*^9, 3.532017598686431*^9}, {
   3.5321012145869093`*^9, 3.532101226864131*^9}, {3.536689482010784*^9, 
   3.536689482544815*^9}, {3.5371322664440184`*^9, 3.5371322747140303`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ExpandAlgebraic", "[", 
    RowBox[{
     RowBox[{"u_Plus", "*", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"#", "*", "v"}], "]"}], ",", "u"}], "]"}], " ", "/;", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ExpandAlgebraic", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u_Plus", "^", "n_"}], "*", "v_."}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Expand", "[", 
        RowBox[{
         RowBox[{"u", "^", "n"}], ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"#", "*", "v"}], "]"}], ",", "w"}], "]"}], " ", "/;", "\n", 
      " ", 
      RowBox[{"SumQ", "[", "w", "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"PositiveIntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]}], "Code",
 CellChangeTimes->{{3.5188253915660677`*^9, 3.5188254352761292`*^9}, {
   3.5188254659961724`*^9, 3.5188255003562202`*^9}, {3.518887671664461*^9, 
   3.5188876914944887`*^9}, 3.5188918539523177`*^9, 3.5188918839523597`*^9, {
   3.5195141200451536`*^9, 3.519514139625181*^9}, {3.5195141940852575`*^9, 
   3.519514293395396*^9}, {3.5195144343955936`*^9, 3.519514545565749*^9}, {
   3.5195146371258774`*^9, 3.5195146476558924`*^9}, {3.5195146911159534`*^9, 
   3.5195147012359676`*^9}, {3.519514736676017*^9, 3.519514859616189*^9}, {
   3.519514892386235*^9, 3.5195150505664563`*^9}, {3.5195150992765245`*^9, 
   3.5195151540666013`*^9}, {3.519515194566658*^9, 3.519515229536707*^9}, {
   3.519516300358206*^9, 3.519516307268216*^9}, {3.5195163855883255`*^9, 
   3.5195163893383307`*^9}, {3.519516421208375*^9, 3.5195164292183867`*^9}, {
   3.5289265513462377`*^9, 3.5289266655872374`*^9}, {3.528927016755452*^9, 
   3.5289270573935237`*^9}, {3.5307569573414807`*^9, 
   3.5307569900615263`*^9}, {3.530812439076936*^9, 3.5308124455069447`*^9}, {
   3.530920516917204*^9, 3.5309205253272157`*^9}, {3.53092089975774*^9, 
   3.53092091442776*^9}, {3.531161847393944*^9, 3.531161879269779*^9}, {
   3.531161915261533*^9, 3.531161915972555*^9}, {3.531849524196059*^9, 
   3.531849558016919*^9}, {3.5320160818943076`*^9, 3.532016187834456*^9}, {
   3.5320162195045004`*^9, 3.53201626193456*^9}, {3.5320164496648226`*^9, 
   3.532016505644901*^9}, {3.532016549444962*^9, 3.5320166082750444`*^9}, {
   3.532017353626088*^9, 3.532017370736112*^9}, {3.532017431206197*^9, 
   3.5320175143063126`*^9}, {3.532017573186395*^9, 3.532017598686431*^9}, {
   3.5321012145869093`*^9, 3.532101226864131*^9}, {3.536689482010784*^9, 
   3.536689482544815*^9}, {3.5371322664440184`*^9, 3.5371322747140303`*^9}, {
   3.537300895161087*^9, 3.5373009022484922`*^9}, {3.537300941177719*^9, 
   3.5373009698973618`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["UnifyTerms", "Subsection",
 CellChangeTimes->{{3.5188253105859547`*^9, 3.5188253149259605`*^9}, {
   3.5255394497616315`*^9, 3.5255394533964376`*^9}, {3.525540006261409*^9, 
   3.5255400084454126`*^9}, 3.536715707013769*^9, 3.5371324512642775`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "lst", " ", "is", " ", "a", " ", "list", " ", "of", " ", "pairs", " ", 
    "of", " ", "the", " ", "form", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ".", " ", 
     RowBox[{"UnifyTerms", "[", 
      RowBox[{"lst", ",", "x"}], "]"}]}], " ", "returns", " ", "lst", " ", 
    "with", " ", "pairs", " ", "having", " ", "indentical", " ", 
    RowBox[{"v", "'"}], "s", " ", "collected", " ", "into", " ", "a", " ", 
    "single", " ", 
    RowBox[{"element", "."}]}], " ", "*)"}], "  ", "\n", 
  RowBox[{
   RowBox[{"UnifyTerms", "[", "lst_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"lst", "===", 
      RowBox[{"{", "}"}]}], ",", "\n", "    ", "lst", ",", "\n", "  ", 
     RowBox[{"UnifyTerm", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"First", "[", "lst", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{
        RowBox[{"First", "[", "lst", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"UnifyTerms", "[", 
        RowBox[{"Rest", "[", "lst", "]"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.536088958833558*^9, 3.5360890271324644`*^9}, {
   3.536089062257473*^9, 3.5360891537527065`*^9}, 3.5360892177943697`*^9, {
   3.536089305242371*^9, 3.536089308837577*^9}, {3.536089345456671*^9, 
   3.5360893844819036`*^9}, {3.5360894177328053`*^9, 
   3.5360894646894913`*^9}, {3.536089650102096*^9, 3.5360897075923843`*^9}, {
   3.5360898080061274`*^9, 3.536089862583249*^9}, {3.5360899181514273`*^9, 
   3.5360899469640756`*^9}, {3.536090042071515*^9, 3.536090054690237*^9}, {
   3.536090911165225*^9, 3.5360909697415752`*^9}, {3.536091006350669*^9, 
   3.536091008169773*^9}, {3.5360911221512923`*^9, 3.536091162726613*^9}, {
   3.536091212431456*^9, 3.536091311163103*^9}, {3.536091341751853*^9, 
   3.536091386564416*^9}, {3.536091470421212*^9, 3.5360915450454807`*^9}, {
   3.5360916127043505`*^9, 3.5360916135944014`*^9}, {3.53609164398814*^9, 
   3.536091758883712*^9}, {3.5360917991800165`*^9, 3.5360918838888617`*^9}, {
   3.536091994045162*^9, 3.53609199541224*^9}, {3.536092354960805*^9, 
   3.5360923592310495`*^9}, {3.536092395464122*^9, 3.536092472243513*^9}, {
   3.5360925621056533`*^9, 3.5360926581831484`*^9}, {3.5360927723556786`*^9, 
   3.5360927799151115`*^9}, {3.536092840794593*^9, 3.5360928513731985`*^9}, {
   3.536093625560479*^9, 3.5360936325418787`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnifyTerm", "[", 
   RowBox[{"u_", ",", "v_", ",", "lst_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"lst", "===", 
     RowBox[{"{", "}"}]}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"v", "===", 
       RowBox[{
        RowBox[{"First", "[", "lst", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ",", "\n", "    ", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Rest", "[", "lst", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"u", "+", 
           RowBox[{
            RowBox[{"First", "[", "lst", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ",", "v"}], "}"}]}], "]"}], ",",
       "\n", "  ", 
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"UnifyTerm", "[", 
         RowBox[{"u", ",", "v", ",", 
          RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], ",", 
        RowBox[{"First", "[", "lst", "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code",
 CellChangeTimes->{{3.536088958833558*^9, 3.5360890271324644`*^9}, {
   3.536089062257473*^9, 3.5360891537527065`*^9}, 3.5360892177943697`*^9, {
   3.536089305242371*^9, 3.536089308837577*^9}, {3.536089345456671*^9, 
   3.5360893844819036`*^9}, {3.5360894177328053`*^9, 
   3.5360894646894913`*^9}, {3.536089650102096*^9, 3.5360897075923843`*^9}, {
   3.5360898080061274`*^9, 3.536089862583249*^9}, {3.5360899181514273`*^9, 
   3.5360899469640756`*^9}, {3.536090042071515*^9, 3.536090054690237*^9}, {
   3.536090911165225*^9, 3.5360909697415752`*^9}, {3.536091006350669*^9, 
   3.536091008169773*^9}, {3.5360911221512923`*^9, 3.536091162726613*^9}, {
   3.536091212431456*^9, 3.536091311163103*^9}, {3.536091341751853*^9, 
   3.536091386564416*^9}, {3.536091470421212*^9, 3.5360915450454807`*^9}, {
   3.5360916127043505`*^9, 3.5360916135944014`*^9}, {3.53609164398814*^9, 
   3.536091758883712*^9}, {3.5360917991800165`*^9, 3.5360918838888617`*^9}, {
   3.536091994045162*^9, 3.53609199541224*^9}, {3.536092354960805*^9, 
   3.5360923592310495`*^9}, {3.536092395464122*^9, 3.536092472243513*^9}, {
   3.5360925621056533`*^9, 3.5360926786113167`*^9}, {3.536092876108613*^9, 
   3.5360928789047728`*^9}, {3.5360929280935864`*^9, 
   3.5360929390802145`*^9}, {3.536093011167338*^9, 3.5360930755240192`*^9}, {
   3.5360931091879444`*^9, 3.536093352559864*^9}, {3.536093430615329*^9, 
   3.536093473903805*^9}, {3.536093551395237*^9, 3.5360935729654713`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Distribution Functions", "Section",
 CellChangeTimes->{{3.522437943106606*^9, 3.5224379456066093`*^9}, {
  3.536801676986492*^9, 3.5368016791664953`*^9}}],

Cell[CellGroupData[{

Cell["Distrib", "Subsection",
 CellChangeTimes->{{3.5368016947565174`*^9, 3.536801708586537*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Distrib", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Distribute", "[", 
   RowBox[{"u", ",", "Plus", ",", "Times"}], "]"}]}]], "Code",
 CellChangeTimes->{{3.520110571612728*^9, 3.5201105728327303`*^9}, {
   3.522437199795565*^9, 3.522437236075616*^9}, {3.5224382505970364`*^9, 
   3.522438255757044*^9}, {3.522442782960072*^9, 3.5224428100261197`*^9}, {
   3.5224448157890453`*^9, 3.5224448671599355`*^9}, {3.522444935987256*^9, 
   3.5224449385612607`*^9}, {3.5224450362486324`*^9, 3.522445066013485*^9}, 
   3.5224451458700247`*^9, {3.5224453476563797`*^9, 3.522445361805604*^9}, {
   3.5224454329573293`*^9, 3.5224455214250846`*^9}, {3.5224511898955097`*^9, 
   3.5224512291655645`*^9}, {3.522451945293073*^9, 3.522451951833082*^9}, {
   3.522456328695225*^9, 3.5224563291652255`*^9}, {3.522457581224984*^9, 
   3.5224575854549904`*^9}, {3.535666082702162*^9, 3.535666092621729*^9}, {
   3.5368017251865597`*^9, 3.5368017581166058`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Dist", "Subsection",
 CellChangeTimes->{{3.5368016947565174`*^9, 3.5368016956665187`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "the", " ", "sum", 
     " ", "of", " ", "u", " ", "times", " ", "each", " ", "term", " ", "of", 
     " ", "v"}], ",", " ", 
    RowBox[{"provided", " ", "v", " ", "is", " ", "free", " ", "of", " ", 
     RowBox[{"Int", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DownValues", "[", "Dist", "]"}], "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UpValues", "[", "Dist", "]"}], "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"0", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<*** Warning ***:  Dist[0,\>\"", ",", "v", ",", "\"\< \>\"", ",", 
         "x", ",", "\"\<]\>\""}], "]"}], ";", " ", "0"}], ")"}]}], ";"}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"1", ",", "v_", ",", "x_"}], "]"}], " ", ":=", " ", "v"}], "\n", 
   "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"-", "u"}], ",", "v", ",", "x"}], "]"}]}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"NumericFactor", "[", "u", "]"}], "<", "0"}]}]}], "\n", "\n", 
   RowBox[{"Dist", " ", "/:", " ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], "+", 
     RowBox[{"Dist", "[", 
      RowBox[{"w_", ",", "v_", ",", "x_"}], "]"}]}], " ", ":=", " ", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"u", "+", "w"}], "]"}], ",", "\n", "    ", "0", ",", "\n", 
      "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"u", "+", "w"}], ",", "v", ",", "x"}], "]"}]}], "]"}]}], "\n",
    "\n", 
   RowBox[{"Dist", " ", "/:", " ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], "-", 
     RowBox[{"Dist", "[", 
      RowBox[{"w_", ",", "v_", ",", "x_"}], "]"}]}], " ", ":=", " ", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"u", "-", "w"}], "]"}], ",", "\n", "    ", "0", ",", "\n", 
      "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"u", "-", "w"}], ",", "v", ",", "x"}], "]"}]}], "]"}]}], "\n",
    "\n", 
   RowBox[{"Dist", " ", "/:", " ", 
    RowBox[{"w_", "*", 
     RowBox[{"Dist", "[", 
      RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}]}], " ", ":=", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"w", "*", "u"}], ",", "v", ",", "x"}], "]"}], " ", "/;", " ", 
     "\n", 
     RowBox[{"w", "=!=", 
      RowBox[{"-", "1"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", 
      RowBox[{"Dist", "[", 
       RowBox[{"v_", ",", "w_", ",", "x_"}], "]"}], ",", "x_"}], "]"}], " ", ":=",
     " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"u", "*", "v"}], ",", "w", ",", "x"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"Dist", "[", 
         RowBox[{"u", ",", "#", ",", "x"}], "]"}], "]"}], ",", "v"}], "]"}], 
     " ", "/;", "\n", 
     RowBox[{"SumQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"Simp", "[", 
      RowBox[{
       RowBox[{"u", "*", "v"}], ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"v", ",", "Int"}], "]"}], " ", "||", " ", 
      RowBox[{"ShowSteps", "=!=", "True"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", " ", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"w", "=", 
        RowBox[{"Simp", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{"w", ",", "v", ",", "x"}], "]"}], " ", "/;", "\n", 
       RowBox[{"w", "=!=", "u"}]}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"u_", ",", 
      RowBox[{"v_", "*", "w_"}], ",", "x_"}], "]"}], " ", ":=", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"u", "*", "v"}], ",", "w", ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"v", ",", "Int"}], "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"w", ",", "Int"}], "]"}], "]"}]}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.520110571612728*^9, 3.5201105728327303`*^9}, {
   3.522437199795565*^9, 3.522437236075616*^9}, {3.5224382505970364`*^9, 
   3.522438255757044*^9}, {3.522442782960072*^9, 3.5224428100261197`*^9}, {
   3.5224448157890453`*^9, 3.5224448671599355`*^9}, {3.522444935987256*^9, 
   3.5224449385612607`*^9}, {3.5224450362486324`*^9, 3.522445066013485*^9}, 
   3.5224451458700247`*^9, {3.5224453476563797`*^9, 3.522445361805604*^9}, {
   3.5224454329573293`*^9, 3.5224455214250846`*^9}, {3.5224511898955097`*^9, 
   3.5224512291655645`*^9}, {3.522451945293073*^9, 3.522451951833082*^9}, {
   3.522456328695225*^9, 3.5224563291652255`*^9}, {3.522457581224984*^9, 
   3.5224575854549904`*^9}, {3.535666082702162*^9, 3.535666092621729*^9}, {
   3.541474798725541*^9, 3.541474805826947*^9}, {3.541982645601632*^9, 
   3.541982648361636*^9}, {3.5421403678613997`*^9, 3.5421403702135344`*^9}, {
   3.542299424133295*^9, 3.542299425233297*^9}, {3.542299462873349*^9, 
   3.542299622733573*^9}, {3.5423323088079624`*^9, 3.542332310257964*^9}, {
   3.542332379168061*^9, 3.542332383388067*^9}, 3.5423343556828375`*^9, 
   3.5423347159633417`*^9, {3.542334770723418*^9, 3.542334777353428*^9}, {
   3.5423891745851417`*^9, 3.542389176706745*^9}, {3.5430058559320188`*^9, 
   3.54300586591759*^9}, 3.543258402578096*^9}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"DistSimp", "[", 
    RowBox[{"u_.", "*", 
     RowBox[{"v_", "^", "m_"}], "*", 
     RowBox[{"w_", "^", "n_"}]}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"DistSimp", "[", 
      RowBox[{"u", "*", 
       RowBox[{"v", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"v", "-", "w"}], "]"}], "\n", "\n", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Basis", ":", " ", 
         RowBox[{"If", " ", "n", " ", "is", " ", "an", " ", "integer"}]}], 
        ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "z"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "+", 
             RowBox[{"a", "/", "z"}]}], ")"}], "^", "n"}]}], " ", "==", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "z"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "+", "n"}], ")"}]}], "/", 
          RowBox[{"z", "^", "n"}]}]}]}], " ", "*)"}], "\n", 
      RowBox[{"DistSimp", "[", 
       RowBox[{"u_", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"f_", "[", "v_", "]"}]}]}], ")"}], "^", "m_"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b_", "+", 
           RowBox[{"a_.", "*", 
            RowBox[{"g_", "[", "v_", "]"}]}]}], ")"}], "^", "n_."}]}], 
       "]"}]}]}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"f", "[", "v", "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}], "/", 
        RowBox[{
         RowBox[{"f", "[", "v", "]"}], "^", "n"}]}]}], " ", "/;", "\n", 
      RowBox[{
       RowBox[{"TrigQ", "[", "f", "]"}], " ", "&&", " ", 
       RowBox[{"TrigQ", "[", "g", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"f", "[", "v", "]"}], "===", 
        RowBox[{"1", "/", 
         RowBox[{"g", "[", "v", "]"}]}]}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"IntegerQ", "[", "n", "]"}], "\n", "\n", 
        RowBox[{"DistSimp", "[", "u_", "]"}]}]}]}], " ", ":=", " ", "u"}]}]}],
   " ", "*)"}]], "Code",
 CellChangeTimes->{{3.5415322059006853`*^9, 3.541532207146757*^9}, {
   3.5415322460439816`*^9, 3.5415322519963217`*^9}, 3.5415323181491055`*^9, 
   3.5415324988374405`*^9, {3.5423324079681015`*^9, 3.5423324113181057`*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Of Functions", "Section"],

Cell[CellGroupData[{

Cell["Function of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
      "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
      " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], " ", "and", " ", "not", " ", "the", 
      " ", "case", " ", "that", " ", "a"}], "==", 
     RowBox[{"0", " ", "and", "\n", "\t", "b"}], "==", "1"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", "x", ")"}]}], ",", "a", ",", "b"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"FunctionOfLinear", "[", 
        RowBox[{"u", ",", "False", ",", "False", ",", "x", ",", "False"}], 
        "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "===", "0"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "===", "1"}]}]}], ",", "\n", 
       "    ", "False", ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FunctionOfLinearSubst", "[", 
          RowBox[{"u", ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLinear", "[", 
   RowBox[{"u_", ",", "a_", ",", "b_", ",", "x_", ",", "flag_"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"LinearQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FalseQ", "[", "a", "]"}], ",", "\n", "      ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", 
            RowBox[{"Coefficient", "[", 
             RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], ",", "\n", 
          "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"CommonFactors", "[", 
               RowBox[{"{", 
                RowBox[{"b", ",", 
                 RowBox[{"Coefficient", "[", 
                  RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], "]"}]}], 
             "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"u", ",", "x", ",", "0"}], "]"}], "]"}], " ", "&&", 
               " ", 
               RowBox[{"Not", "[", "flag", "]"}]}], ",", "\n", "      ", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"b", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"u", ",", "x", ",", "0"}], "]"}]}], "-", 
                  RowBox[{"a", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"u", ",", "x", ",", "1"}], "]"}]}]}], "]"}], ",", 
                "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"a", "/", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{"FunctionOfLinear", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "a", ",", "b", ",", "x", 
            ",", "False"}], "]"}], ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
               RowBox[{"NonzeroQ", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"lst", "=", 
                   RowBox[{"MonomialFactor", "[", 
                    RowBox[{"u", ",", "x"}], "]"}]}], ")"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"False", " ", "&&", " ", 
                 RowBox[{"IntegerQ", "[", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "!=", 
                  RowBox[{"-", "1"}]}], " ", "&&", " ", 
                 RowBox[{"FreeQ", "[", 
                  RowBox[{
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", 
                "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"RationalQ", "[", 
                    RowBox[{"LeadFactor", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "&&", 
                   " ", 
                   RowBox[{
                    RowBox[{"LeadFactor", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
                  "\n", "        ", 
                  RowBox[{"FunctionOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                    "a", ",", "b", ",", "x", ",", "False"}], "]"}], ",", "\n",
                   "      ", 
                  RowBox[{"FunctionOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                    "a", ",", "b", ",", "x", ",", "False"}], "]"}]}], "]"}], 
                ",", "\n", "    ", "False"}], "]"}], ",", "\n", "  ", 
              RowBox[{
               RowBox[{"lst", "=", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "b"}], "}"}]}], ";", "\n", "  ", 
               RowBox[{"Catch", "[", "\n", "  ", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FunctionOfLinear", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", 
                    RowBox[{"SumQ", "[", "u", "]"}]}], "]"}]}], ";", "\n", 
                    "\t\t\t", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst", "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], 
                   ",", "u"}], "]"}], ";", "\n", "  ", "lst"}], "]"}]}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{3.524675945617508*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLinearSubst", "[", 
   RowBox[{"u_", ",", "a_", ",", "b_", ",", "x_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"tmp", "=", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], ",", "\n", 
        "    ", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"tmp", "===", "b"}], ",", " ", "1", ",", " ", 
            RowBox[{"tmp", "/", "b"}]}], "]"}]}], ";", "\n", "    ", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "0"}], "]"}], "-", 
          RowBox[{"a", "*", "tmp"}], "+", 
          RowBox[{"tmp", "*", "x"}]}]}]}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"E", "^", 
         RowBox[{"FullSimplify", "[", 
          RowBox[{"FunctionOfLinearSubst", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "a", ",", "b", ",", 
            "x"}], "]"}], "]"}]}], ",", "\n", "  ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"NonzeroQ", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"lst", "=", 
                 RowBox[{"MonomialFactor", "[", 
                  RowBox[{"u", ",", "x"}], "]"}]}], ")"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"RationalQ", "[", 
                RowBox[{"LeadFactor", "[", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "&&", 
               " ", 
               RowBox[{
                RowBox[{"LeadFactor", "[", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
              "\n", "      ", 
              RowBox[{"-", 
               RowBox[{
                RowBox[{"FunctionOfLinearSubst", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                  "a", ",", "b", ",", "x"}], "]"}], "^", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ",", "\n", "    ", 
              RowBox[{
               RowBox[{"FunctionOfLinearSubst", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"DivideDegreesOfFactors", "[", 
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                 "a", ",", "b", ",", "x"}], "]"}], "^", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"FunctionOfLinearSubst", "[", 
                RowBox[{"#", ",", "a", ",", "b", ",", "x"}], "]"}], "]"}], 
              ",", "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DivideDegreesOfFactors", "[", 
     RowBox[{"u", ",", "n"}], "]"}], " ", "returns", " ", "the", " ", 
    "product", " ", "of", " ", "the", " ", "base", " ", "of", " ", "the", " ",
     "factors", " ", "of", " ", "u", " ", "raised", " ", "to", "\n", "\t", 
    "the", " ", "degree", " ", "of", " ", "the", " ", "factors", " ", 
    "divided", " ", "by", " ", 
    RowBox[{"n", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"DivideDegreesOfFactors", "[", 
    RowBox[{"u_", ",", "n_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"LeadBase", "[", "#", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"LeadDegree", "[", "#", "]"}], "/", "n"}], ")"}]}], "]"}], 
       ",", "u"}], "]"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"LeadBase", "[", "u", "]"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"LeadDegree", "[", "u", "]"}], "/", "n"}], ")"}]}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of an inverse linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "an", " ", "inverse", " ", "linear", " ", "binomial", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfInverseLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u_", ",", "lst_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "lst", ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "    ", "False", ",", "\n", 
        "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"QuotientOfLinearsQ", "[", 
           RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"tmp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{
                RowBox[{"QuotientOfLinearsParts", "[", 
                 RowBox[{"u", ",", "x"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
            ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"tmp", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "===", "0"}], ",", "\n", 
              "      ", "False", ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"lst", "===", "Null"}], ",", "\n", "      ", "tmp", 
                ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"ZeroQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"tmp", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"tmp", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", 
                  "      ", "lst", ",", "\n", "    ", "False"}], "]"}]}], 
               "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
            ",", "\n", "  ", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"tmp", "=", "lst"}], "}"}], ",", 
              RowBox[{"Catch", "[", "\n", "  ", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"FunctionOfInverseLinear", "[", 
                    RowBox[{"#", ",", "tmp", ",", "x"}], "]"}]}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "\n", "  ", "tmp"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of exponential functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfExponentialOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"v", ",", "a", ",", "b", ",", "f"}], "}"}], " ", "\n", "\t", 
      "where", " ", "v", " ", "of", " ", 
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}], " ", "equals", " ", "u"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfExponentialOfLinear", "[", 
         RowBox[{"u", ",", "x", ",", "False", ",", "False", ",", "False"}], 
         "]"}]}], ",", "a", ",", "b", ",", "f"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"f", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"(", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"u", ",", 
              RowBox[{
               RowBox[{"v_", "*", 
                RowBox[{"g_", "^", 
                 RowBox[{"(", 
                  RowBox[{"c_.", "+", 
                   RowBox[{"d_", "*", "x"}]}], ")"}]}]}], " ", "/;", " ", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "x"}], 
                 "]"}], " ", "&&", " ", 
                RowBox[{
                 RowBox[{"NumericFactor", "[", "d", "]"}], "<", "0"}]}]}]}], 
             "]"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"NumericFactor", "[", "b", "]"}], ">", "0"}]}], ",", 
           "\n", "      ", 
           RowBox[{
            RowBox[{"a", "=", 
             RowBox[{"-", "a"}]}], ";", "\n", "      ", 
            RowBox[{"b", "=", 
             RowBox[{"-", "b"}]}]}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
           RowBox[{"u", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}], ",", 
          "a", ",", "b", ",", "f"}], "}"}]}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfExponentialOfLinear", "[", 
       RowBox[{"u", ",", "x", ",", "False", ",", "False", ",", "False"}], 
       "]"}], " ", "\n", "\t", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "b", ",", " ", "f"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinear", "[", 
    RowBox[{"u_", ",", "x_", ",", "a_", ",", "b_", ",", "f_"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "===", "x"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "False", 
       ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"LinearQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
          RowBox[{"a", ",", "b", ",", "f", ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "0"}], "]"}], 
           ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "1"}], "]"}], 
           ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"LinearQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n",
            "    ", 
           RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
            RowBox[{"a", ",", "b", ",", "f", ",", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}], 
             ",", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}], 
             ",", "E"}], "]"}], ",", "\n", "  ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
                RowBox[{"FreeQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&",
                 " ", 
                RowBox[{"SumQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FunctionOfExponentialOfLinear", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", 
                    RowBox[{"First", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "x", ",", 
                   "a", ",", "b", ",", "f"}], "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "      ", 
                  "False", ",", "\n", "    ", 
                  RowBox[{"FunctionOfExponentialOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", 
                    RowBox[{"Rest", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "x", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
               "\n", "  ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "b", ",", "f"}], "}"}]}], ";", "\n", "  ", 
                RowBox[{"Catch", "[", 
                 RowBox[{
                  RowBox[{"Scan", "[", 
                   RowBox[{
                    RowBox[{"Function", "[", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FunctionOfExponentialOfLinear", "[", 
                    RowBox[{"#", ",", "x", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", "\n", 
                    "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst", "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], 
                    ",", "u"}], "]"}], ";", "\n", "  ", "lst"}], "]"}]}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.5246759584775257`*^9, 3.52467596170753*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
   RowBox[{"a_", ",", "b_", ",", "f_", ",", "c_", ",", "d_", ",", "g_"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FalseQ", "[", "a", "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", "f", "]"}], "*", 
         RowBox[{"NonnumericFactors", "[", "b", "]"}]}], "-", 
        RowBox[{
         RowBox[{"Log", "[", "g", "]"}], "*", 
         RowBox[{"NonnumericFactors", "[", "d", "]"}]}]}], "]"}], ",", "\n", 
      "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"gcd", "=", 
          RowBox[{"GCD", "[", 
           RowBox[{
            RowBox[{"NumericFactor", "[", "b", "]"}], ",", 
            RowBox[{"NumericFactor", "[", "d", "]"}]}], "]"}]}], "}"}], ",", 
        "\n", "    ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"NumericFactor", "[", "b", "]"}], "<", "0"}], " ", "&&",
              " ", 
             RowBox[{
              RowBox[{"NumericFactor", "[", "d", "]"}], "<", "0"}]}], ",", 
            "\n", "        ", 
            RowBox[{"gcd", "=", 
             RowBox[{"-", "gcd"}]}]}], "]"}], " ", ")"}], ";", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"gcd", "==", 
            RowBox[{"NumericFactor", "[", "b", "]"}]}], ",", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"gcd", "==", 
              RowBox[{"NumericFactor", "[", "d", "]"}]}], ",", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "    ", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"gcd", "*", 
                RowBox[{"NonnumericFactors", "[", "b", "]"}]}], ",", "f"}], 
              "}"}]}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", "  ", "False"}], 
     "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
    RowBox[{
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ".", "  ", 
     RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
      RowBox[{"u", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}]}], " ", 
    "returns", " ", "u", " ", "\n", "\t", "with", " ", 
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}]}], " ", "replaced", " ", "by", " ", 
    RowBox[{"x", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
    RowBox[{"u_", ",", "a_", ",", "b_", ",", "f_", ",", "x_"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"LinearQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"c", "=", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}], 
          ";", "\n", "    ", 
          RowBox[{"d", "=", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ";", "\n", "    ", 
          RowBox[{"g", "=", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "    ", 
          RowBox[{
           RowBox[{"g", "^", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"a", "*", 
               RowBox[{"d", "/", "b"}]}]}], ")"}]}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"d", "*", 
              RowBox[{
               RowBox[{"Log", "[", "g", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "*", 
                 RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], ")"}]}]}]}]}], 
        "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"LinearQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d", ",", "tmp"}], "}"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"c", "=", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}],
             ";", "\n", "    ", 
            RowBox[{"d", "=", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}],
             ";", "\n", "    ", 
            RowBox[{"tmp", "=", 
             RowBox[{
              RowBox[{"E", "^", 
               RowBox[{"(", 
                RowBox[{"c", "-", 
                 RowBox[{"a", "*", 
                  RowBox[{"d", "/", "b"}]}]}], ")"}]}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"d", "/", 
                 RowBox[{"(", 
                  RowBox[{"b", "*", 
                   RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ")"}]}]}]}], 
            ";", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"SinhQ", "[", "u", "]"}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"tmp", "/", "2"}], "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"2", "*", "tmp"}], ")"}]}]}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"CoshQ", "[", "u", "]"}], ",", "\n", "      ", 
                RowBox[{
                 RowBox[{"tmp", "/", "2"}], "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", "tmp"}], ")"}]}]}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"TanhQ", "[", "u", "]"}], ",", "    ", "\n", 
                  "      ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"CothQ", "[", "u", "]"}], ",", "    ", "\n", 
                    "      ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SechQ", "[", "u", "]"}], ",", "\n", "      ", 
                    RowBox[{"2", "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                    RowBox[{"2", "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}]}], "]"}]}], "]"}]}], 
                 "]"}]}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
            " ", 
            RowBox[{"SumQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "^", 
               RowBox[{"First", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "a", ",", "b", 
              ",", "f", ",", "x"}], "]"}], "*", "\n", "    ", 
            RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "^", 
               RowBox[{"Rest", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "a", ",", "b", 
              ",", "f", ",", "x"}], "]"}]}], ",", "\n", "  ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
               RowBox[{"#", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}], 
              "]"}], ",", "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of trig functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "trig", " ", "functions", " ", "of", " ", "a", " ", "linear", " ", 
     "function", " ", "of", " ", "x"}], ",", " ", "\n", "    ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTrigOfLinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTrigOfLinearQ", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c_.", "*", 
             RowBox[{"f_", "[", 
              RowBox[{"a_.", "+", 
               RowBox[{"b_.", "*", "x"}]}], "]"}]}], ")"}], "^", "p_."}], " ",
           "/;", " ", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], 
            "]"}], " ", "&&", " ", 
           RowBox[{"MemberQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Sin", ",", "Cos", ",", "Sec", ",", "Csc"}], "}"}], ",",
              "f"}], "]"}]}]}]}], "]"}], "]"}], " ", "&&"}], " ", "*)"}], 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Null", ",", " ", "False"}], "}"}], ",", " ", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "]"}], "]"}], " ", "&&",
      " ", "\n", "    ", 
     RowBox[{"RecognizedFunctionOfTrigQ", "[", 
      RowBox[{
       RowBox[{"SubstInertTrigFunction", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
      "trig", " ", "functions", " ", "of", " ", "v", " ", "where", " ", "v", 
      " ", "is", " ", "a", " ", "linear", " ", "function", " ", "of", " ", 
      "x"}], ",", " ", "\n", "\t", 
     RowBox[{
      RowBox[{
       RowBox[{"FunctionOfTrig", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "v"}], ";", " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"FunctionOfTrig", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "}"}], ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v", "===", "Null"}], ",", " ", "False", ",", " ", "v"}], 
       "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfTrig", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
        "    ", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"LinearQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"v", "===", "Null"}], ",", "\n", "      ", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "0"}], "]"}]}], ",", 
              RowBox[{"b", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", "\n", 
              "\t\t\t", 
              RowBox[{"c", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], 
                "]"}]}], ",", 
              RowBox[{"d", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
                "]"}]}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{
                 RowBox[{"a", "*", "d"}], "-", 
                 RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
               RowBox[{"RationalQ", "[", 
                RowBox[{"b", "/", "d"}], "]"}]}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"a", "/", 
                RowBox[{"Numerator", "[", 
                 RowBox[{"b", "/", "d"}], "]"}]}], "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "/", 
                 RowBox[{"Numerator", "[", 
                  RowBox[{"b", "/", "d"}], "]"}]}]}]}], ",", "\n", "    ", 
              "False"}], "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
          ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"w", "=", "v"}], "}"}], ",", 
            RowBox[{"Catch", "[", "\n", "  ", 
             RowBox[{
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FalseQ", "[", 
                    RowBox[{"w", "=", 
                    RowBox[{"FunctionOfTrig", "[", 
                    RowBox[{"#", ",", "w", ",", "x"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
                "u"}], "]"}], ";", "\n", "  ", "w"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5419050224055104`*^9, 3.5419051854957385`*^9}, {
  3.546734004579488*^9, 3.5467340096467776`*^9}, {3.547954150205161*^9, 
  3.5479541574279733`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
     "inert", " ", "trig", " ", "functions", " ", 
     RowBox[{"(", 
      RowBox[{"sin", ",", " ", 
       RowBox[{"csc", " ", "and", " ", "tan"}]}], ")"}], " ", "of", " ", 
     RowBox[{"x", ".", "  ", "\n", "If"}], " ", "u", " ", "can", " ", "be", 
     " ", "put", " ", "in", " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", "*", 
        RowBox[{"g", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", "*", 
        RowBox[{
         RowBox[{"g", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"g", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "\n", 
     RowBox[{"RecognizedFunctionOfTrigQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RecognizedFunctionOfTrigQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"f_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}], " ",
        "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", "f", "]"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"f_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"f_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"f_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"f_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{"csc", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", "g", "]"}]}]}]}], "]"}], " ", "||", "\n", 
    "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"g_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}]}], " ", "/;", " ", 
       "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"g_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{"csc", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}]}], " ", "/;", " ", 
       "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", "f", "]"}]}]}]}], "]"}], " ", "||", "\n", 
    "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"g_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"h_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g", ",", "h"}], "]"}]}]}]}], "]"}], " ", "||", 
    "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"h_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g", ",", "h"}], "]"}]}]}]}], "]"}], " ", "||", 
    "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"g_", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"h_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g", ",", "h"}], "]"}]}]}]}], "]"}], " ", "||", 
    "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"f_", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{"csc", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{"g_", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n_."}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"InertTrigQ", "[", 
         RowBox[{"f", ",", "g"}], "]"}]}]}]}], "]"}], " ", "||", "\n", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"csc", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"A_", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}]}], " ", "/;", " ", 
       "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{"B", "-", "A"}], "]"}], " ", "&&", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], "]"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"A_", "+", 
            RowBox[{"B_.", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], " ", 
       "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{"B", "-", "A"}], "]"}], " ", "&&", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], "]"}]}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.544926399966567*^9, 3.5449264037267823`*^9}, {
   3.5449264523798013`*^9, 3.5449265178235445`*^9}, 3.544926562825612*^9, {
   3.544926669751728*^9, 3.544926708890967*^9}, {3.5449276018797445`*^9, 
   3.544927707145217*^9}, {3.5454476499146175`*^9, 3.5454476904346743`*^9}, {
   3.54544795149504*^9, 3.5454480211451373`*^9}, {3.547913512029355*^9, 
   3.547913538218853*^9}, {3.5479136293990684`*^9, 3.5479136304131265`*^9}, {
   3.547913666576195*^9, 3.5479137067234907`*^9}, {3.547913844538374*^9, 
   3.5479138682597303`*^9}, {3.547913904550806*^9, 3.5479140653560038`*^9}, {
   3.5479140960177574`*^9, 3.5479141824226995`*^9}, {3.5479142229110155`*^9, 
   3.547914288135746*^9}, {3.547914330489168*^9, 3.547914429629839*^9}, {
   3.5479144618276806`*^9, 3.5479146073430033`*^9}, {3.547914689752717*^9, 
   3.547914705673628*^9}, {3.547914736695402*^9, 3.5479148281476326`*^9}, {
   3.547914876339389*^9, 3.547914883146778*^9}, {3.548001509554134*^9, 
   3.5480015236721587`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InertTrigQ", "[", "f_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"f", "===", "sin"}], " ", "||", " ", 
    RowBox[{"f", "===", "csc"}], " ", "||", " ", 
    RowBox[{"f", "===", "tan"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"InertTrigQ", "[", 
    RowBox[{"f_", ",", "g_"}], "]"}], " ", ":=", " ", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"f", "===", "g"}], ",", "\n", "    ", 
     RowBox[{"InertTrigQ", "[", "f", "]"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "===", "sin"}], " ", "&&", " ", 
       RowBox[{"g", "===", "csc"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"f", "===", "csc"}], " ", "&&", " ", 
       RowBox[{"g", "===", "sin"}]}]}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"InertTrigQ", "[", 
   RowBox[{"f_", ",", "g_", ",", "h_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"InertTrigQ", "[", 
    RowBox[{"f", ",", "g"}], "]"}], " ", "&&", " ", 
   RowBox[{"InertTrigQ", "[", 
    RowBox[{"g", ",", "h"}], "]"}]}]}]}], "Code",
 CellChangeTimes->{{3.544926399966567*^9, 3.5449264037267823`*^9}, {
   3.5449264523798013`*^9, 3.5449265178235445`*^9}, 3.544926562825612*^9, {
   3.544926669751728*^9, 3.544926708890967*^9}, {3.5449276018797445`*^9, 
   3.544927707145217*^9}, {3.5454476499146175`*^9, 3.5454476904346743`*^9}, {
   3.54544795149504*^9, 3.5454480211451373`*^9}, {3.547913512029355*^9, 
   3.547913538218853*^9}, {3.547913569954668*^9, 3.547913601592478*^9}, {
   3.5479137182681513`*^9, 3.5479137858480167`*^9}, {3.5480015526258097`*^9, 
   3.5480015581170197`*^9}, {3.548002148172456*^9, 3.548002171260496*^9}, {
   3.5480022164069757`*^9, 3.5480022325530043`*^9}, 3.5480022633786583`*^9, {
   3.5480023269331694`*^9, 3.5480023365427866`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of hyperbolic functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "hyperbolic", " ", "trig", " ", "functions", " ", "of", " ", "v", " ", 
     "where", " ", "v", " ", "is", " ", "linear", " ", "in", " ", "x"}], ",", 
    " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfHyperbolic", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "v"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfHyperbolic", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "}"}], ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v", "===", "Null"}], ",", " ", "False", ",", " ", "v"}], 
       "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfHyperbolic", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
        "    ", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"LinearQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"v", "===", "Null"}], ",", "\n", "      ", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "0"}], "]"}]}], ",", 
              RowBox[{"b", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", "\n", 
              "\t\t\t", 
              RowBox[{"c", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], 
                "]"}]}], ",", 
              RowBox[{"d", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
                "]"}]}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{
                 RowBox[{"a", "*", "d"}], "-", 
                 RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
               RowBox[{"RationalQ", "[", 
                RowBox[{"b", "/", "d"}], "]"}]}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"a", "/", 
                RowBox[{"Numerator", "[", 
                 RowBox[{"b", "/", "d"}], "]"}]}], "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "/", 
                 RowBox[{"Numerator", "[", 
                  RowBox[{"b", "/", "d"}], "]"}]}]}]}], ",", "\n", "    ", 
              "False"}], "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
          ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"w", "=", "v"}], "}"}], ",", 
            RowBox[{"Catch", "[", "\n", "  ", 
             RowBox[{
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FalseQ", "[", 
                    RowBox[{"w", "=", 
                    RowBox[{"FunctionOfHyperbolic", "[", 
                    RowBox[{"#", ",", "w", ",", "x"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
                "u"}], "]"}], ";", "\n", "  ", "w"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of expression predicate", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"v", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"x", ".", "\n", "\t", "If"}], " ", "u", " ", "is", " ", "a", " ",
      "function", " ", "of", " ", "v"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfQ", "[", 
       RowBox[{"v", ",", "u", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfQ", "[", 
    RowBox[{"v_", ",", "u_", ",", "x_Symbol", ",", 
     RowBox[{"PureFlag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "False", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"AtomQ", "[", "v", "]"}], ",", "\n", "    ", "True", ",", "\n",
        "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "v", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"&&", " ", 
           RowBox[{"NonzeroQ", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], "]"}]}], " ", 
          "*)"}], ",", "\n", "    ", 
         RowBox[{"FunctionOfPowerQ", "[", 
          RowBox[{"u", ",", 
           RowBox[{"v", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"v", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{"PureFlag", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SinQ", "[", "v", "]"}], " ", "||", " ", 
              RowBox[{"CscQ", "[", "v", "]"}]}], ",", "\n", "      ", 
             RowBox[{"PureFunctionOfSinQ", "[", 
              RowBox[{"u", ",", 
               RowBox[{"v", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
             "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", "v", "]"}], " ", "||", " ", 
                RowBox[{"SecQ", "[", "v", "]"}]}], ",", "\n", "      ", 
               RowBox[{"PureFunctionOfCosQ", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"v", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"TanQ", "[", "v", "]"}], ",", "\n", "      ", 
                 RowBox[{"PureFunctionOfTanQ", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"CotQ", "[", "v", "]"}], ",", "\n", "      ", 
                   RowBox[{"PureFunctionOfCotQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SinhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CschQ", "[", "v", "]"}]}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfSinhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"CoshQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"SechQ", "[", "v", "]"}]}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfCoshQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"TanhQ", "[", "v", "]"}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfTanhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"CothQ", "[", "v", "]"}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfCothQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"FunctionOfExpnQ", "[", 
                    RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SinQ", "[", "v", "]"}], " ", "||", " ", 
              RowBox[{"CscQ", "[", "v", "]"}]}], ",", "\n", "    ", 
             RowBox[{"FunctionOfSinQ", "[", 
              RowBox[{"u", ",", 
               RowBox[{"v", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
             "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", "v", "]"}], " ", "||", " ", 
                RowBox[{"SecQ", "[", "v", "]"}]}], ",", "\n", "    ", 
               RowBox[{"FunctionOfCosQ", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"v", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
               "\n", "  ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"TanQ", "[", "v", "]"}], " ", "||", " ", 
                  RowBox[{"CotQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                 RowBox[{"FunctionOfTanQ", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "  ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SinhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CschQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                   RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "  ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"CoshQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"SechQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TanhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CothQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"FunctionOfExpnQ", "[", 
                    RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfExpnQ", "[", 
   RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"u", "===", "v"}], ",", "\n", "    ", "True", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FunctionOfExpnQ", "[", 
                RowBox[{"#", ",", "v", ",", "x"}], "]"}], ",", "Null", ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfPowerQ", "[", 
   RowBox[{"u_", ",", "bas_", ",", "deg_", ",", "x_"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", "bas"}], "]"}], " ", "&&", 
         " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"RationalQ", "[", "deg", "]"}], ",", "\n", "      ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"RationalQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "        ", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], "]"}], " ", "&&",
              " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"deg", ">", "0"}], " ", "||", " ", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ")"}]}], ",", 
            "\n", "      ", "False"}], "]"}], ",", "\n", "    ", 
          RowBox[{"IntegerQ", "[", 
           RowBox[{"Simplify", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], "]"}], "]"}]}], 
         "]"}], ",", "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FunctionOfPowerQ", "[", 
                RowBox[{"#", ",", "bas", ",", "deg", ",", "x"}], "]"}], ",", 
               "Null", ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{
      RowBox[{"func", "[", "w", "]"}], "^", "m"}], " ", "is", " ", "a", " ", 
     "factor", " ", "of", " ", "u", " ", "where", " ", "m", " ", "is", " ", 
     "odd", " ", "and", " ", "w", " ", "is", " ", "an", " ", "integer", " ", 
     "multiple", " ", "of", " ", "v"}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FindTrigFactor", "[", 
       RowBox[{"func1", ",", "func2", ",", "u", ",", "v", ",", "True"}], 
       "]"}], " ", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"w", ",", 
        RowBox[{"u", "/", 
         RowBox[{
          RowBox[{"func", "[", "w", "]"}], "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{
      RowBox[{"func", "[", "w", "]"}], "^", "m"}], " ", "is", " ", "a", " ", 
     "factor", " ", "of", " ", "u", " ", "where", " ", "m", " ", "is", " ", 
     "odd", " ", "and", " ", "w", " ", "is", " ", "an", " ", "integer", " ", 
     "multiple", " ", "of", " ", "v", " ", "not", " ", "equal", " ", "to", 
     " ", "v"}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FindTrigFactor", "[", 
       RowBox[{"func1", ",", "func2", ",", "u", ",", "v", ",", "False"}], 
       "]"}], " ", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"w", ",", 
        RowBox[{"u", "/", 
         RowBox[{
          RowBox[{"func", "[", "w", "]"}], "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FindTrigFactor", "[", 
    RowBox[{"func1_", ",", "func2_", ",", "u_", ",", "v_", ",", "flag_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"u", "===", "1"}], ",", "\n", "    ", "False", ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", 
            RowBox[{"LeadBase", "[", "u", "]"}], "]"}], "===", "func1"}], " ",
           "||", " ", 
          RowBox[{
           RowBox[{"Head", "[", 
            RowBox[{"LeadBase", "[", "u", "]"}], "]"}], "===", "func2"}]}], 
         ")"}], " ", "&&", " ", "\n", "\t\t", 
        RowBox[{"OddQ", "[", 
         RowBox[{"LeadDegree", "[", "u", "]"}], "]"}], " ", "&&", " ", "\n", 
        "\t\t", 
        RowBox[{"IntegerQuotientQ", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LeadBase", "[", "u", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], " ", "&&", " ", 
        "\n", "\t\t", 
        RowBox[{"(", 
         RowBox[{"flag", " ", "||", " ", 
          RowBox[{"NonzeroQ", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"LeadBase", "[", "u", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ")"}]}], 
       ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"LeadBase", "[", "u", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"RemainingFactors", "[", "u", "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst", "=", 
           RowBox[{"FindTrigFactor", "[", 
            RowBox[{"func1", ",", "func2", ",", 
             RowBox[{"RemainingFactors", "[", "u", "]"}], ",", "v", ",", 
             "flag"}], "]"}]}], "}"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "    ", "False", 
           ",", "\n", "  ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
             RowBox[{
              RowBox[{"LeadFactor", "[", "u", "]"}], "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"],

Cell[CellGroupData[{

Cell["Pure function of trig functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Sin", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Csc", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfSinQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfSinQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfSinQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cos", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Sec", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCosQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCosQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SecQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCosQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Tan", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Cot", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfTanQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfTanQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"TanQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CotQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfTanQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cot", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCotQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCotQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"CotQ", "[", "u", "]"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCotQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of trig functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Sin", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSinQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfSinQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OddQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "odd"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "      ", 
           RowBox[{
            RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "even"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "    ", 
           RowBox[{
            RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"SecQ", "[", "u", "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Trig", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n",
              "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfSinQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"SinQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "      ", 
               RowBox[{"FunctionOfSinQ", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"u", ",", "2"}], "]"}], ",", "v", ",", "x"}], "]"}],
                ",", "\n", "    ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Sin", ",", "Csc", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"EvenQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "even", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Cos", ",", "Sec", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"OddQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "odd", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tan", ",", "Cot", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tan", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Cos", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfCosQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfCosQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Basis", ":", " ", 
            RowBox[{"If", " ", "m", " ", "integer"}]}], ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", "a",
             " ", "function", " ", "of", " ", 
            RowBox[{
             RowBox[{"Cos", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SecQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Trig", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Cos", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n",
              "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfCosQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FindTrigFactor", "[", 
                  RowBox[{
                  "Sin", ",", "Csc", ",", "u", ",", "v", ",", "False"}], 
                  "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                  "\n", "      ", 
                  RowBox[{"FunctionOfCosQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tan", ",", "Cot", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tan", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                 "]"}]}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", "x"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTanQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTanQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{
           RowBox[{"TanQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"CotQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"EvenQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"TrigQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQuotientQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
            ",", "\n", "    ", "True", ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"lst", "=", 
                  RowBox[{"ReapList", "[", 
                   RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                    "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", 
                   RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", 
                  "\n", "    ", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "lst", "]"}], "==", "2"}], " ", "&&",
                    " ", 
                   RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}], " ", "&&", " ", 
                   RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
              RowBox[{"Catch", "[", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OddTrigPowerQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"SecQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", "    ", 
      RowBox[{"OddQuotientQ", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"OddQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"OddTrigPowerQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}], 
        ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"ReapList", "[", 
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                 "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"lst", "===", 
               RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", "\n", 
              "    ", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "==", "1"}], " ", "&&", 
               " ", 
               RowBox[{"OddTrigPowerQ", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                "]"}]}]}], "]"}]}], "]"}], ",", "\n", 
          RowBox[{"(*", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}], ","}], " "}], "*)"}], 
          "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
     "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", 
     RowBox[{"x", ".", "\n", 
      RowBox[{"FunctionOfTanWeight", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], " ", "returns", " ", "a", 
     " ", "nonnegative", " ", "number", " ", "if", " ", "u", " ", "is", " ", 
     "best", " ", "considered", " ", "a", " ", "function", "\n", "of", " ", 
     RowBox[{"Tan", "[", "v", "]"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", "a", " ", "negative", " ", 
     RowBox[{"number", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTanWeight", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TanQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n",
            "      ", "1", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"CotQ", "[", "u", "]"}], " ", "&&", " ", 
              RowBox[{"ZeroQ", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", 
             "\n", "      ", 
             RowBox[{"-", "1"}], ",", "\n", "    ", "0"}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"EvenQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TanQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"CosQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"SecQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
             "1", ",", "\n", "    ", 
             RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Catch", "[", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                    "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "      ", 
               RowBox[{"Apply", "[", 
                RowBox[{"Plus", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"FunctionOfTanWeight", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}], ",", 
               "\n", "    ", "0"}], "]"}], ",", "\n", "  ", 
             RowBox[{"Apply", "[", 
              RowBox[{"Plus", ",", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"FunctionOfTanWeight", "[", 
                   RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", "v", "]"}], ",", 
       RowBox[{"Cos", "[", "v", "]"}], ",", 
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}], ",", 
       RowBox[{"Sec", "[", "v", "]"}], ",", 
       RowBox[{"Csc", "[", "v", "]"}]}], ")"}], "\n", "\t", "where", " ", "f",
      " ", "is", " ", "independent", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTrigQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTrigQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", "True", ",", "\n", "  ", 
         RowBox[{"Catch", "[", "\n", "    ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"FunctionOfTrigQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "\n", "    ", "True"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure function of hyperbolic functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Sinh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Csch", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfSinhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfSinhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfSinhQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cosh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Sech", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCoshQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCoshQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SechQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCoshQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Tanh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Coth", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfTanhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfTanhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"TanhQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CothQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfTanhQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Coth", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCothQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCothQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"CothQ", "[", "u", "]"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCothQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of hyperbolic functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Sinh", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSinhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfSinhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OddQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "odd"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Sinh", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "      ", 
           RowBox[{
            RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "even"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "    ", 
           RowBox[{
            RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"SechQ", "[", "u", "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Hyper", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], 
             "\n", "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfSinhQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CoshQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"SinhQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "      ", 
               RowBox[{"FunctionOfSinhQ", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"u", ",", "2"}], "]"}], ",", "v", ",", "x"}], "]"}],
                ",", "\n", "    ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Sinh", ",", "Csch", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"EvenQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "even", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Cosh", ",", "Sech", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"OddQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "odd", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tanh", ",", "Coth", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tanh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Cosh", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfCoshQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfCoshQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Basis", ":", " ", 
            RowBox[{"If", " ", "m", " ", "integer"}]}], ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Cosh", "[", 
              RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", "a",
             " ", "function", " ", "of", " ", 
            RowBox[{
             RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SechQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Hyper", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], 
             "\n", "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfCoshQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FindTrigFactor", "[", 
                  RowBox[{
                  "Sinh", ",", "Csch", ",", "u", ",", "v", ",", "False"}], 
                  "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                   "\n", "      ", 
                  RowBox[{"FunctionOfCoshQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tanh", ",", "Coth", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tanh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                 "]"}]}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", "x"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTanhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTanhQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{
           RowBox[{"TanhQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"CothQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"EvenQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"HyperbolicQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQuotientQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
            ",", "\n", "    ", "True", ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"lst", "=", 
                  RowBox[{"ReapList", "[", 
                   RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                    "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", 
                   RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", 
                  "\n", "    ", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "lst", "]"}], "==", "2"}], " ", "&&",
                    " ", 
                   RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}], " ", "&&", " ", 
                   RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
              RowBox[{"Catch", "[", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OddHyperbolicPowerQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"SechQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", "    ", 
      RowBox[{"OddQuotientQ", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"OddQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"OddHyperbolicPowerQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}], 
        ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"ReapList", "[", 
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                 "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"lst", "===", 
               RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", "\n", 
              "    ", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "==", "1"}], " ", "&&", 
               " ", 
               RowBox[{"OddHyperbolicPowerQ", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                "]"}]}]}], "]"}]}], "]"}], ",", "\n", 
          RowBox[{"(*", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}], ","}], " "}], "*)"}], 
          "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
     "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", 
     RowBox[{"x", ".", "\n", 
      RowBox[{"FunctionOfTanhWeight", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], " ", "returns", " ", "a", 
     " ", "nonnegative", " ", "number", " ", "if", " ", "u", " ", "is", " ", 
     "best", " ", "considered", " ", "a", " ", "function", "\n", "of", " ", 
     RowBox[{"Tanh", "[", "v", "]"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", "a", " ", "negative", " ", 
     RowBox[{"number", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTanhWeight", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TanhQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n",
            "      ", "1", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"CothQ", "[", "u", "]"}], " ", "&&", " ", 
              RowBox[{"ZeroQ", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", 
             "\n", "      ", 
             RowBox[{"-", "1"}], ",", "\n", "    ", "0"}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"EvenQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TanhQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"CoshQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"SechQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
             "1", ",", "\n", "    ", 
             RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Catch", "[", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                    "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "      ", 
               RowBox[{"Apply", "[", 
                RowBox[{"Plus", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"FunctionOfTanhWeight", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}], ",", 
               "\n", "    ", "0"}], "]"}], ",", "\n", "  ", 
             RowBox[{"Apply", "[", 
              RowBox[{"Plus", ",", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"FunctionOfTanhWeight", "[", 
                   RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "a", " ", "function", " ", "of", " ", "the", " ", "form", " ", "f", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sinh", "[", "v", "]"}], ",", 
       RowBox[{"Cosh", "[", "v", "]"}], ",", 
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}], ",", 
       RowBox[{"Sech", "[", "v", "]"}], ",", 
       RowBox[{"Csch", "[", "v", "]"}]}], ")"}], "\n", "\t", "where", " ", 
     "f", " ", "is", " ", "independent", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfHyperbolicQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfHyperbolicQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", "True", ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FunctionOfHyperbolicQ", "[", 
                 RowBox[{"#", ",", "v", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "integer"}], ",", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerQuotientQ", "[", 
       RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "===", "v"}], " ", "||", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u", "-", "v"}], "]"}], " ", "||", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"u", "/", "v"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "odd"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"OddQuotientQ", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
      " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"OddQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "===", "v"}], " ", "||", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u", "-", "v"}], "]"}], " ", "||", " ", 
     RowBox[{"OddQ", "[", 
      RowBox[{"u", "/", "v"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "even"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"EvenQuotientQ", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
      " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"EvenQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"EvenQ", "[", 
     RowBox[{"u", "/", "v"}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of dense polynomials", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "all", " ", "occurrences", " ", "of", " ", "x", " ", "in", " ",
      "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "are", " ", "in", " ", "dense", " ", 
     "polynomials"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfDensePolynomialsQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "\n", "\t", "returns", " ", "True"}], 
     ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfDensePolynomialsQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Exponent", "[", 
          RowBox[{"u", ",", "x", ",", "List"}], "]"}], "]"}], ">", "1"}], ",",
        "\n", "  ", 
       RowBox[{"Catch", "[", "\n", "  ", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FunctionOfDensePolynomialsQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "\n", "  ", "True"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of logarithm", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
     " ", 
     RowBox[{"(", 
      RowBox[{"Log", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}]}], "]"}], ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfLog", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", "\n", "\t", "the", " ",
       "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", "x", ")"}]}], ",", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], ",", "n"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfLog", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"FunctionOfLog", "[", 
        RowBox[{"u", ",", "False", ",", "False", ",", "x"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", "lst"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLog", "[", 
   RowBox[{"u_", ",", "v_", ",", "n_", ",", "x_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
      "    ", 
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "n"}], "}"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LogQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"NotFalseQ", "[", 
            RowBox[{"lst", "=", 
             RowBox[{"BinomialTest", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}], 
           " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"FalseQ", "[", "v", "]"}], " ", "||", " ", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "===", "v"}]}], ",", "\n", 
            "      ", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            "False"}], "]"}], ",", "\n", "  ", 
          RowBox[{
           RowBox[{"lst", "=", 
            RowBox[{"{", 
             RowBox[{"0", ",", "v", ",", "n"}], "}"}]}], ";", "\n", "  ", 
           RowBox[{"Catch", "[", "\n", "    ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FunctionOfLog", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", "x"}], "]"}]}], ";", 
                  "\n", "\t\t\t\t  ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"FalseQ", "[", "lst", "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
                "\n", "\t\t\t", "u"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}]}]}], "]"}]}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{3.524675963677533*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Power of variable", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "m", " ", "is", " ", "an", " ", "integer"}], ",", " ", 
    RowBox[{
     RowBox[{
     "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", "the", " ",
       "form", " ", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", "x"}], ")"}], "^", "n"}], "]"}], " ", "and", " ", 
      "g"}], "=", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ">", "1"}]}], ",", "\n", "   ", 
    RowBox[{
     RowBox[{
      RowBox[{"PowerVariableExpn", "[", 
       RowBox[{"u", ",", "m", ",", "x"}], "]"}], " ", "returns", " ", "the", 
      " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "/", "g"}], ")"}]}], "*", 
         RowBox[{"f", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", "x"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "/", "g"}], ")"}]}], "]"}]}], ",", "g", ",", "c"}], 
       "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PowerVariableExpn", "[", 
    RowBox[{"u_", ",", "m_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"IntegerQ", "[", "m", "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableDegree", "[", 
          RowBox[{"u", ",", "m", ",", "1", ",", "x"}], "]"}]}], "}"}], ",", 
       "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "      ", "False", 
         ",", "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "*", 
            RowBox[{"PowerVariableSubst", "[", 
             RowBox[{"u", ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", " ", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
     "\n", "  ", "False"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerVariableDegree", "[", 
   RowBox[{"u_", ",", "m_", ",", "c_", ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"m", ",", " ", "c"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "False", 
      ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
        ",", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ZeroQ", "[", "m", "]"}], " ", "||", " ", 
           RowBox[{
            RowBox[{"m", "===", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], " ", "&&", " ", 
            RowBox[{"c", "===", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}]}]}], ",", "\n", 
          "      ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}], "}"}], ",", "\n", 
          "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
             RowBox[{
              RowBox[{"GCD", "[", 
               RowBox[{"m", ",", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", "1"}], " ", "&&",
              " ", 
             RowBox[{"c", "===", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}]}], ",", "\n", 
            "      ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"GCD", "[", 
               RowBox[{"m", ",", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", " ", "c"}], 
             "}"}], ",", "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", 
        "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"{", 
              RowBox[{"m", ",", " ", "c"}], "}"}]}], "}"}], ",", "\n", "  ", 
           RowBox[{
            RowBox[{"Scan", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"PowerVariableDegree", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ";", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst", "]"}], ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], ",",
               "u"}], "]"}], ";", "\n", "  ", "lst"}]}], "]"}], "]"}]}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{3.5246759655775356`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerVariableSubst", "[", 
   RowBox[{"u_", ",", "m_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "||", " ", 
     RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", 
     RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "u", ",", 
    "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
      ",", "\n", "    ", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "/", "m"}], ")"}]}], ",", "\n", 
      "  ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"PowerVariableSubst", "[", 
          RowBox[{"#", ",", "m", ",", "x"}], "]"}], "]"}], ",", "u"}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Squareroot of quadratic expression", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Euler", " ", "substitution", " ", "#2"}], ":", "\n", "  ", 
     RowBox[{
     "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", 
      "the", " ", "form", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], ")"}]}]}], ",", 
    " ", 
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "x"}], ")"}], " ", "is", " ", "a", " ", "rational", 
     " ", "function"}], ",", " ", 
    RowBox[{"and", "\n", "\t", 
     RowBox[{"PosQ", "[", "c", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
       "3"}], "-", 
      RowBox[{"element", " ", "list", " ", 
       RowBox[{"{", "\n", "\t\t", 
        RowBox[{
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}]}], "+", 
               RowBox[{"b", "*", "x"}], "+", 
               RowBox[{
                RowBox[{"Sqrt", "[", "c", "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"2", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "a"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"2", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}]}]}], 
           ")"}], "*", "\n", "\t\t  ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Sqrt", "[", "c", "]"}]}], "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", "c", "]"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "+", 
              RowBox[{"2", "*", 
               RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}], "^", 
            "2"}]}]}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}], "+", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", " ", "2"}], " ", 
        "}"}]}]}], ";", "\n", "\n", 
     RowBox[{
      RowBox[{"Euler", " ", "substitution", " ", "#1"}], ":", "\n", "  ", 
      RowBox[{
      "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ",
        "the", " ", "form", " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], ")"}]}]}]}], ",", 
    " ", 
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "x"}], ")"}], " ", "is", " ", "a", " ", "rational", 
     " ", "function"}], ",", " ", 
    RowBox[{"and", "\n", "\t", 
     RowBox[{"PosQ", "[", "a", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "two",
       " ", "element", " ", "list", " ", 
      RowBox[{"{", "\n", "\t\t", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "*", 
               RowBox[{"Sqrt", "[", "a", "]"}]}], "-", 
              RowBox[{"b", "*", "x"}], "+", 
              RowBox[{
               RowBox[{"Sqrt", "[", "a", "]"}], "*", 
               RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"x", "^", "2"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "b"}], "+", 
          